/*
    dllloader
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "winuser.h"


/******************************************************************************
*                                                                             *
* Хå                                                                *
*                                                                             *
******************************************************************************/
LRESULT CALLBACK DefWindowProc(HWND hWnd,UINT Msg,WPARAM wParam,LPARAM lParam)
{
	switch (Msg) {
	case BM_GETCHECK:
		return gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(hWnd))
													?BST_CHECKED:BST_UNCHECKED;
	case BM_SETCHECK:
		if (wParam!=BST_INDETERMINATE)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(hWnd),
														wParam==BST_CHECKED);
		return 0;
	case BM_GETSTATE:
		return (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(hWnd))
													?BST_CHECKED:BST_UNCHECKED)
									| (GTK_WIDGET_HAS_FOCUS(hWnd)?BST_FOCUS:0);
	case BM_SETSTATE:
		return 0;
	case BM_SETSTYLE:
		{
			WindowExtraData *wed;

			wed=gtk_object_get_user_data(GTK_OBJECT(hWnd));
			wed->dwStyle=wParam;
			switch (wed->dwStyle&0x00000300L) {
				case BS_LEFT:
					gtk_label_set_justify(GTK_LABEL(GTK_BIN(hWnd)->child),
															GTK_JUSTIFY_LEFT);
					break;
				case BS_RIGHT:
					gtk_label_set_justify(GTK_LABEL(GTK_BIN(hWnd)->child),
															GTK_JUSTIFY_RIGHT);
					break;
				case BS_CENTER:
					gtk_label_set_justify(GTK_LABEL(GTK_BIN(hWnd)->child),
														GTK_JUSTIFY_CENTER);
			}
		}
		return 0;
	case BM_CLICK:
		gtk_button_clicked(GTK_BUTTON(hWnd));
		return 0;
	case BM_GETIMAGE:
	case BM_SETIMAGE:
		return (LRESULT)NULL;
	case CB_GETEDITSEL:
		if ((LPDWORD)wParam!=NULL)
			*(LPDWORD)wParam=-1;
		if ((LPDWORD)lParam!=NULL)
			*(LPDWORD)lParam=-1;
		return -1;
	case CB_LIMITTEXT:
		gtk_entry_set_max_length(GTK_ENTRY(GTK_COMBO(hWnd)->entry),
													wParam>0?wParam:0xfffe);
		return TRUE;
	case CB_SETEDITSEL:
		gtk_editable_select_region(GTK_EDITABLE(GTK_COMBO(hWnd)->entry),
																wParam,lParam);
		return TRUE;
	case CB_ADDSTRING:
		{
			GtkWidget *list_item;

			list_item=gtk_list_item_new_with_label((gchar *)lParam);
			gtk_widget_show(list_item);
			gtk_container_add(GTK_CONTAINER(GTK_COMBO(hWnd)->list),list_item);
			gtk_widget_queue_resize(GTK_WIDGET(hWnd));
		}
		return g_list_length(gtk_container_children(
									GTK_CONTAINER(GTK_COMBO(hWnd)->list)))-1;
	case CB_DELETESTRING:
		gtk_list_clear_items(GTK_LIST(GTK_COMBO(hWnd)->list),wParam,wParam+1);
		return g_list_length(gtk_container_children(
										GTK_CONTAINER(GTK_COMBO(hWnd)->list)));
	case CB_DIR:
		return CB_ERR;
	case CB_GETCOUNT:
		return g_list_length(gtk_container_children(
										GTK_CONTAINER(GTK_COMBO(hWnd)->list)));
	case CB_GETCURSEL:
		{
			gchar *label,*text;
			gint i,length;
			GList *glist;

			text=gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(hWnd)->entry));
			glist=gtk_container_children(GTK_CONTAINER(GTK_COMBO(hWnd)->list));
			length=g_list_length(glist);
			for (i=wParam+1;i<length;i++) {
				gtk_label_get(GTK_LABEL(
							GTK_BIN(g_list_nth_data(glist,i))->child),&label);
				if (g_strcmp(label,text)==0)
					return i;
			}
		}
		return CB_ERR;
	case CB_GETLBTEXT:
		{
			gchar *label;

			gtk_label_get(GTK_LABEL(GTK_BIN(g_list_nth_data(
				gtk_container_children(GTK_CONTAINER(GTK_COMBO(hWnd)->list)),
													wParam))->child),&label);
			g_strcpy((gchar *)lParam,label);
		}
		return g_strlen((gchar *)lParam);
	case CB_GETLBTEXTLEN:
		{
			gchar *label;

			gtk_label_get(GTK_LABEL(GTK_BIN(g_list_nth_data(
				gtk_container_children(GTK_CONTAINER(GTK_COMBO(hWnd)->list)),
													wParam))->child),&label);
			return g_strlen(label);
		}
	case CB_INSERTSTRING:
		{
			GtkWidget *list_item;

			list_item=gtk_list_item_new_with_label((gchar *)lParam);
			gtk_widget_show(list_item);
			gtk_container_add(GTK_CONTAINER(GTK_COMBO(hWnd)->list),list_item);
		}
		return g_list_length(gtk_container_children(
									GTK_CONTAINER(GTK_COMBO(hWnd)->list)))-1;
	case CB_RESETCONTENT:
		gtk_list_clear_items(GTK_LIST(GTK_COMBO(hWnd)->list),0,G_MAXINT);
	case CB_FINDSTRING:
		{
			gchar *label;
			gint i,length;
			GList *glist;

			glist=gtk_container_children(GTK_CONTAINER(GTK_COMBO(hWnd)->list));
			length=g_list_length(glist);
			for (i=wParam+1;i<length;i++) {
				gtk_label_get(GTK_LABEL(
							GTK_BIN(g_list_nth_data(glist,i))->child),&label);
				if (g_strncasecmp(label,(gchar *)lParam,
												g_strlen((gchar *)lParam))==0)
					return i;
			}
			for (i=0;i<=wParam;i++) {
				gtk_label_get(GTK_LABEL(
							GTK_BIN(g_list_nth_data(glist,i))->child),&label);
				if (g_strncasecmp(label,(gchar *)lParam,
												g_strlen((gchar *)lParam))==0)
					return i;
			}
		}
		return CB_ERR;
	case CB_SELECTSTRING:
		return DefWindowProc(hWnd,CB_SETCURSEL,
							DefWindowProc(hWnd,CB_FINDSTRING,wParam,lParam),0);
	case CB_SETCURSEL:
		{
			gchar *label;

			gtk_label_get(GTK_LABEL(GTK_BIN(g_list_nth_data(
				gtk_container_children(GTK_CONTAINER(GTK_COMBO(hWnd)->list)),
													wParam))->child),&label);
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(hWnd)->entry),label);
		}
		return wParam;
	case CB_SHOWDROPDOWN:
		return TRUE;
	case CB_GETITEMDATA:
		return (LRESULT)
			gtk_object_get_user_data(GTK_OBJECT(GTK_BIN(g_list_nth_data(
				gtk_container_children(GTK_CONTAINER(GTK_COMBO(hWnd)->list)),
															wParam))->child));
	case CB_SETITEMDATA:
		gtk_object_set_user_data(GTK_OBJECT(GTK_BIN(g_list_nth_data(
				gtk_container_children(GTK_CONTAINER(GTK_COMBO(hWnd)->list)),
											wParam))->child),(gpointer)lParam);
		return 0;
	case CB_GETDROPPEDCONTROLRECT:
		return CB_ERR;
	case CB_SETITEMHEIGHT:
		return CB_ERR;
	case CB_GETITEMHEIGHT:
		return CB_ERR;
	case CB_SETEXTENDEDUI:
		return CB_ERR;
	case CB_GETEXTENDEDUI:
		return FALSE;
	case CB_GETDROPPEDSTATE:
		return FALSE;
	case CB_FINDSTRINGEXACT:
		{
			gchar *label;
			gint i,length;
			GList *glist;

			glist=gtk_container_children(GTK_CONTAINER(GTK_COMBO(hWnd)->list));
			length=g_list_length(glist);
			for (i=wParam+1;i<length;i++) {
				gtk_label_get(GTK_LABEL(
							GTK_BIN(g_list_nth_data(glist,i))->child),&label);
				if (g_strcasecmp(label,(gchar *)lParam)==0)
					return i;
			}
			for (i=0;i<=wParam;i++) {
				gtk_label_get(GTK_LABEL(
							GTK_BIN(g_list_nth_data(glist,i))->child),&label);
				if (g_strcasecmp(label,(gchar *)lParam)==0)
					return i;
			}
		}
		return CB_ERR;
	case CB_SETLOCALE:
		return CB_ERR;
	case CB_GETLOCALE:
		return 0;
	case CB_GETTOPINDEX:
		return 0;
	case CB_SETTOPINDEX:
		return CB_ERR;
	case CB_GETHORIZONTALEXTENT:
		return 0;
	case CB_SETHORIZONTALEXTENT:
		return CB_ERR;
	case CB_GETDROPPEDWIDTH:
		return 0;
	case CB_SETDROPPEDWIDTH:
		return CB_ERR;
	case CB_INITSTORAGE:
		return CB_ERR;
	case WM_ENABLE:
		{
			gint i;
			WindowExtraData *wed;

			gtk_widget_set_sensitive(GTK_WIDGET(hWnd),wParam);
			if ((wed=gtk_object_get_user_data(GTK_OBJECT(hWnd)))!=NULL
														&& wed->sister!=NULL)
				for (i=0;wed->sister[i]!=NULL;i++)
					gtk_widget_set_sensitive(wed->sister[i],wParam);
		}
		return 0;
	case WM_GETTEXT:
		{
			gchar *text=NULL;

			if (GTK_IS_BUTTON(hWnd) || GTK_IS_CHECK_BUTTON(hWnd)
												|| GTK_IS_RADIO_BUTTON(hWnd))
				gtk_label_get(GTK_LABEL(GTK_BIN(hWnd)->child),&text);
			else if (GTK_IS_LABEL(hWnd))
				gtk_label_get(GTK_LABEL(hWnd),&text);
			else if (GTK_IS_WINDOW(hWnd))
				text=GTK_WINDOW(hWnd)->title;
			if (wParam>0 && (gchar *)lParam!=NULL && text!=NULL) {
				g_strncpy((gchar *)lParam,text,wParam);
				((gchar *)lParam)[wParam-1]='\0';
				return g_strlen((const gchar *)lParam);
			}
		}
		return 0;
	case WM_SETTEXT:
		if (GTK_IS_BUTTON(hWnd) || GTK_IS_CHECK_BUTTON(hWnd)
												|| GTK_IS_RADIO_BUTTON(hWnd))
			gtk_label_set_text(GTK_LABEL(GTK_BIN(hWnd)->child),
														(const gchar *)lParam);
		else if (GTK_IS_LABEL(hWnd))
			gtk_label_set_text(GTK_LABEL(hWnd),(const gchar *)lParam);
		else if (GTK_IS_WINDOW(hWnd))
			gtk_window_set_title(GTK_WINDOW(hWnd),(const gchar *)lParam);
		return TRUE;
	case WM_SHOWWINDOW:
		{
			gint i;
			WindowExtraData *wed;

			if (wParam)
				gtk_widget_show(GTK_WIDGET(hWnd));
			else
				gtk_widget_hide(GTK_WIDGET(hWnd));
			if ((wed=gtk_object_get_user_data(GTK_OBJECT(hWnd)))!=NULL
														&& wed->sister!=NULL)
				for (i=0;wed->sister[i]!=NULL;i++) {
					if (wParam)
						gtk_widget_show(wed->sister[i]);
					else
						gtk_widget_hide(wed->sister[i]);
				}
		}
		return 0;
	default:
		g_debug("DefWindowProc:hWnd=%X Msg=%X wParam=%X lParam=%X",
												(guint)hWnd,Msg,wParam,lParam);
	}
	return 0;
}
