/*
    avicore
    copyright (c) 2000-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* Avi Core                                                                    *
*                                                                             *
******************************************************************************/
#include "avicore.h"
#ifdef HAVE_SYS_FILE_H
# include <sys/file.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* Avi                                                                     *
*                                                                             *
******************************************************************************/
const guint8 rgb2[8]={0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00};
const guint8 rgb16[64]={
			0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,
			0x00,0xFF,0xFF,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,
			0xFF,0xFF,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0x00,
			0xFF,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0xFF,0xFF,0x00,0x00,
			0xFF,0xFF,0xFF,0x00};
const guint8 rgb256[1024]={
			0x00,0x00,0x00,0x00,0x55,0x00,0x00,0x00,0xAA,0x00,0x00,0x00,
			0xFF,0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x55,0x24,0x00,0x00,
			0xAA,0x24,0x00,0x00,0xFF,0x24,0x00,0x00,0x00,0x49,0x00,0x00,
			0x55,0x49,0x00,0x00,0xAA,0x49,0x00,0x00,0xFF,0x49,0x00,0x00,
			0x00,0x6D,0x00,0x00,0x55,0x6D,0x00,0x00,0xAA,0x6D,0x00,0x00,
			0xFF,0x6D,0x00,0x00,0x00,0x92,0x00,0x00,0x55,0x92,0x00,0x00,
			0xAA,0x92,0x00,0x00,0xFF,0x92,0x00,0x00,0x00,0xB6,0x00,0x00,
			0x55,0xB6,0x00,0x00,0xAA,0xB6,0x00,0x00,0xFF,0xB6,0x00,0x00,
			0x00,0xDB,0x00,0x00,0x55,0xDB,0x00,0x00,0xAA,0xDB,0x00,0x00,
			0xFF,0xDB,0x00,0x00,0x00,0xFF,0x00,0x00,0x55,0xFF,0x00,0x00,
			0xAA,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x24,0x00,
			0x55,0x00,0x24,0x00,0xAA,0x00,0x24,0x00,0xFF,0x00,0x24,0x00,
			0x00,0x24,0x24,0x00,0x55,0x24,0x24,0x00,0xAA,0x24,0x24,0x00,
			0xFF,0x24,0x24,0x00,0x00,0x49,0x24,0x00,0x55,0x49,0x24,0x00,
			0xAA,0x49,0x24,0x00,0xFF,0x49,0x24,0x00,0x00,0x6D,0x24,0x00,
			0x55,0x6D,0x24,0x00,0xAA,0x6D,0x24,0x00,0xFF,0x6D,0x24,0x00,
			0x00,0x92,0x24,0x00,0x55,0x92,0x24,0x00,0xAA,0x92,0x24,0x00,
			0xFF,0x92,0x24,0x00,0x00,0xB6,0x24,0x00,0x55,0xB6,0x24,0x00,
			0xAA,0xB6,0x24,0x00,0xFF,0xB6,0x24,0x00,0x00,0xDB,0x24,0x00,
			0x55,0xDB,0x24,0x00,0xAA,0xDB,0x24,0x00,0xFF,0xDB,0x24,0x00,
			0x00,0xFF,0x24,0x00,0x55,0xFF,0x24,0x00,0xAA,0xFF,0x24,0x00,
			0xFF,0xFF,0x24,0x00,0x00,0x00,0x49,0x00,0x55,0x00,0x49,0x00,
			0xAA,0x00,0x49,0x00,0xFF,0x00,0x49,0x00,0x00,0x24,0x49,0x00,
			0x55,0x24,0x49,0x00,0xAA,0x24,0x49,0x00,0xFF,0x24,0x49,0x00,
			0x00,0x49,0x49,0x00,0x55,0x49,0x49,0x00,0xAA,0x49,0x49,0x00,
			0xFF,0x49,0x49,0x00,0x00,0x6D,0x49,0x00,0x55,0x6D,0x49,0x00,
			0xAA,0x6D,0x49,0x00,0xFF,0x6D,0x49,0x00,0x00,0x92,0x49,0x00,
			0x55,0x92,0x49,0x00,0xAA,0x92,0x49,0x00,0xFF,0x92,0x49,0x00,
			0x00,0xB6,0x49,0x00,0x55,0xB6,0x49,0x00,0xAA,0xB6,0x49,0x00,
			0xFF,0xB6,0x49,0x00,0x00,0xDB,0x49,0x00,0x55,0xDB,0x49,0x00,
			0xAA,0xDB,0x49,0x00,0xFF,0xDB,0x49,0x00,0x00,0xFF,0x49,0x00,
			0x55,0xFF,0x49,0x00,0xAA,0xFF,0x49,0x00,0xFF,0xFF,0x49,0x00,
			0x00,0x00,0x6D,0x00,0x55,0x00,0x6D,0x00,0xAA,0x00,0x6D,0x00,
			0xFF,0x00,0x6D,0x00,0x00,0x24,0x6D,0x00,0x55,0x24,0x6D,0x00,
			0xAA,0x24,0x6D,0x00,0xFF,0x24,0x6D,0x00,0x00,0x49,0x6D,0x00,
			0x55,0x49,0x6D,0x00,0xAA,0x49,0x6D,0x00,0xFF,0x49,0x6D,0x00,
			0x00,0x6D,0x6D,0x00,0x55,0x6D,0x6D,0x00,0xAA,0x6D,0x6D,0x00,
			0xFF,0x6D,0x6D,0x00,0x00,0x92,0x6D,0x00,0x55,0x92,0x6D,0x00,
			0xAA,0x92,0x6D,0x00,0xFF,0x92,0x6D,0x00,0x00,0xB6,0x6D,0x00,
			0x55,0xB6,0x6D,0x00,0xAA,0xB6,0x6D,0x00,0xFF,0xB6,0x6D,0x00,
			0x00,0xDB,0x6D,0x00,0x55,0xDB,0x6D,0x00,0xAA,0xDB,0x6D,0x00,
			0xFF,0xDB,0x6D,0x00,0x00,0xFF,0x6D,0x00,0x55,0xFF,0x6D,0x00,
			0xAA,0xFF,0x6D,0x00,0xFF,0xFF,0x6D,0x00,0x00,0x00,0x92,0x00,
			0x55,0x00,0x92,0x00,0xAA,0x00,0x92,0x00,0xFF,0x00,0x92,0x00,
			0x00,0x24,0x92,0x00,0x55,0x24,0x92,0x00,0xAA,0x24,0x92,0x00,
			0xFF,0x24,0x92,0x00,0x00,0x49,0x92,0x00,0x55,0x49,0x92,0x00,
			0xAA,0x49,0x92,0x00,0xFF,0x49,0x92,0x00,0x00,0x6D,0x92,0x00,
			0x55,0x6D,0x92,0x00,0xAA,0x6D,0x92,0x00,0xFF,0x6D,0x92,0x00,
			0x00,0x92,0x92,0x00,0x55,0x92,0x92,0x00,0xAA,0x92,0x92,0x00,
			0xFF,0x92,0x92,0x00,0x00,0xB6,0x92,0x00,0x55,0xB6,0x92,0x00,
			0xAA,0xB6,0x92,0x00,0xFF,0xB6,0x92,0x00,0x00,0xDB,0x92,0x00,
			0x55,0xDB,0x92,0x00,0xAA,0xDB,0x92,0x00,0xFF,0xDB,0x92,0x00,
			0x00,0xFF,0x92,0x00,0x55,0xFF,0x92,0x00,0xAA,0xFF,0x92,0x00,
			0xFF,0xFF,0x92,0x00,0x00,0x00,0xB6,0x00,0x55,0x00,0xB6,0x00,
			0xAA,0x00,0xB6,0x00,0xFF,0x00,0xB6,0x00,0x00,0x24,0xB6,0x00,
			0x55,0x24,0xB6,0x00,0xAA,0x24,0xB6,0x00,0xFF,0x24,0xB6,0x00,
			0x00,0x49,0xB6,0x00,0x55,0x49,0xB6,0x00,0xAA,0x49,0xB6,0x00,
			0xFF,0x49,0xB6,0x00,0x00,0x6D,0xB6,0x00,0x55,0x6D,0xB6,0x00,
			0xAA,0x6D,0xB6,0x00,0xFF,0x6D,0xB6,0x00,0x00,0x92,0xB6,0x00,
			0x55,0x92,0xB6,0x00,0xAA,0x92,0xB6,0x00,0xFF,0x92,0xB6,0x00,
			0x00,0xB6,0xB6,0x00,0x55,0xB6,0xB6,0x00,0xAA,0xB6,0xB6,0x00,
			0xFF,0xB6,0xB6,0x00,0x00,0xDB,0xB6,0x00,0x55,0xDB,0xB6,0x00,
			0xAA,0xDB,0xB6,0x00,0xFF,0xDB,0xB6,0x00,0x00,0xFF,0xB6,0x00,
			0x55,0xFF,0xB6,0x00,0xAA,0xFF,0xB6,0x00,0xFF,0xFF,0xB6,0x00,
			0x00,0x00,0xDB,0x00,0x55,0x00,0xDB,0x00,0xAA,0x00,0xDB,0x00,
			0xFF,0x00,0xDB,0x00,0x00,0x24,0xDB,0x00,0x55,0x24,0xDB,0x00,
			0xAA,0x24,0xDB,0x00,0xFF,0x24,0xDB,0x00,0x00,0x49,0xDB,0x00,
			0x55,0x49,0xDB,0x00,0xAA,0x49,0xDB,0x00,0xFF,0x49,0xDB,0x00,
			0x00,0x6D,0xDB,0x00,0x55,0x6D,0xDB,0x00,0xAA,0x6D,0xDB,0x00,
			0xFF,0x6D,0xDB,0x00,0x00,0x92,0xDB,0x00,0x55,0x92,0xDB,0x00,
			0xAA,0x92,0xDB,0x00,0xFF,0x92,0xDB,0x00,0x00,0xB6,0xDB,0x00,
			0x55,0xB6,0xDB,0x00,0xAA,0xB6,0xDB,0x00,0xFF,0xB6,0xDB,0x00,
			0x00,0xDB,0xDB,0x00,0x55,0xDB,0xDB,0x00,0xAA,0xDB,0xDB,0x00,
			0xFF,0xDB,0xDB,0x00,0x00,0xFF,0xDB,0x00,0x55,0xFF,0xDB,0x00,
			0xAA,0xFF,0xDB,0x00,0xFF,0xFF,0xDB,0x00,0x00,0x00,0xFF,0x00,
			0x55,0x00,0xFF,0x00,0xAA,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
			0x00,0x24,0xFF,0x00,0x55,0x24,0xFF,0x00,0xAA,0x24,0xFF,0x00,
			0xFF,0x24,0xFF,0x00,0x00,0x49,0xFF,0x00,0x55,0x49,0xFF,0x00,
			0xAA,0x49,0xFF,0x00,0xFF,0x49,0xFF,0x00,0x00,0x6D,0xFF,0x00,
			0x55,0x6D,0xFF,0x00,0xAA,0x6D,0xFF,0x00,0xFF,0x6D,0xFF,0x00,
			0x00,0x92,0xFF,0x00,0x55,0x92,0xFF,0x00,0xAA,0x92,0xFF,0x00,
			0xFF,0x92,0xFF,0x00,0x00,0xB6,0xFF,0x00,0x55,0xB6,0xFF,0x00,
			0xAA,0xB6,0xFF,0x00,0xFF,0xB6,0xFF,0x00,0x00,0xDB,0xFF,0x00,
			0x55,0xDB,0xFF,0x00,0xAA,0xDB,0xFF,0x00,0xFF,0xDB,0xFF,0x00,
			0x00,0xFF,0xFF,0x00,0x55,0xFF,0xFF,0x00,0xAA,0xFF,0xFF,0x00,
			0xFF,0xFF,0xFF,0x00};


/*	AVIե
	avi_edit,AVIԽϥɥ
	     pos,ץֹ													*/
void avi_get_file(AviEdit *avi_edit,const gint pos)
{
	while (pos<avi_edit->offset && avi_edit->file->prev!=NULL) {
		avi_edit->file=avi_edit->file->prev;
		avi_edit->offset-=avi_edit->file->length;
	}
	while (avi_edit->offset+avi_edit->file->length<=pos
											&& avi_edit->file->next!=NULL) {
		avi_edit->offset+=avi_edit->file->length;
		avi_edit->file=avi_edit->file->next;
	}
}


/*	AVIեʬΥ
	avi_edit,AVIԽϥɥ
	     pos,ץֹ													*/
void avi_split_file(AviEdit *avi_edit,const gint pos)
{
	AviFile *avi_file;

	if (pos<0 || avi_edit->length<=pos)
		return;

	/* ֤ */
	avi_get_file(avi_edit,pos);/* AVIե */
	if (avi_edit->offset==pos)
		return;/* եڤܤ˰פ */

	/* ΥեʬΥ */
	avi_file=g_malloc(sizeof(AviFile));
	if (avi_edit->file->fd!=-1) {
		if ((avi_file->fd=open(avi_edit->file->name,O_RDONLY))==-1)
			avi_file->fd=dup(avi_edit->file->fd);
		else
			flock(avi_file->fd,LOCK_SH);
	} else {
		avi_file->fd=-1;
	}
	avi_file->data=avi_edit->file->data!=NULL && avi_edit->file->bmih!=NULL
		?g_memdup(avi_edit->file->data,bm_image_bytes(avi_edit->file->bmih))
																		:NULL;
	avi_file->name=g_strdup(avi_edit->file->name);
	avi_file->start=pos-avi_edit->offset+avi_edit->file->start;
	avi_file->length=avi_edit->file->length-(pos-avi_edit->offset);
	avi_file->entries=avi_edit->file->entries;
	avi_file->param=avi_edit->file->param;
	avi_file->index=g_memdup(avi_edit->file->index,
									avi_edit->file->entries*sizeof(AviIndex));
	avi_file->handler=avi_edit->file->handler;
	avi_file->bmih=avi_edit->file->bmih!=NULL?g_memdup(avi_edit->file->bmih,
								bm_header_bytes(avi_edit->file->bmih)):NULL;
	avi_file->wfx=avi_edit->file->wfx!=NULL?g_memdup(avi_edit->file->wfx,
									wf_header_bytes(avi_edit->file->wfx)):NULL;
	/* Υեѹ */
	avi_edit->file->length-=avi_file->length;
	/* ꥹȤ */
	avi_file->prev=avi_edit->file;
	avi_file->next=avi_edit->file->next;
	avi_file->prev->next=avi_file;
	if (avi_file->next!=NULL)
		avi_file->next->prev=avi_file;
	avi_get_file(avi_edit,pos);
}


/******************************************************************************
*                                                                             *
* AVIե빽¤δؿ                                                       *
*                                                                             *
******************************************************************************/
/*	AVIAVIե빽¤Τ
	 file,ե̾
	param,ȥ꡼ֹ
	 type,streamtypeAUDIO/streamtypeVIDEO
	 rate,졼
	scale,
	  RET,AVIե빽¤,NULL:顼										*/
static AviFile *avi_open_avi(const gchar *file,const gint param,
									guint32 *type,guint32 *rate,guint32 *scale)
{
	gint i;
	guint32 size;
	off_t offset;				/* AVIΥࡼӡ */
	AviFile *avi_file;
	AviIndexEntry avi_index;
	AviStreamHeader *ash;
	Chunk *ck;

	avi_file=g_malloc(sizeof(AviFile));
	/* ե򳫤 */
	if ((avi_file->fd=open(file,O_RDONLY))==-1) {
		g_free(avi_file);
		return NULL;
	}
	if (flock(avi_file->fd,LOCK_SH)==-1) {
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(avi_file->fd);
	/* RIFF󥯤 */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* եबhdrlLIST󥯤õ */
	while (chunk_form(avi_file->fd)!=listtypeAVIHEADER)
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(avi_file);
			return NULL;
		}
	/* եबhdrlLIST󥯤(RIFF'AVI ' -> LIST'hdrl') */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* եबstrlLIST󥯤õ */
	for (i=0;i<=param;i++)
		do
			if (!chunk_next(avi_file->fd,ck)) {
				chunk_free(ck);
				close(avi_file->fd);
				g_free(avi_file);
				return NULL;
			}
		while (chunk_form(avi_file->fd)!=listtypeSTREAMHEADER);
	/* եबstrlLIST󥯤
									(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl') */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* strh󥯤õ(AviStreamHeader) */
	while (chunk_id(avi_file->fd)!=ckidSTREAMHEADER)
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(avi_file);
			return NULL;
		}
	/* strh󥯤Υ(AviStreamHeader) */
	if ((size=chunk_size(avi_file->fd))==-1 || size<ASH_SIZE) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	ash=g_malloc(ASH_SIZE);
	/* strh󥯤(AVIStreamHeader)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' -> strh) */
	if (!chunk_in(avi_file->fd,ck)
		/* AviStreamHeaderɤ߹ */
				|| read(avi_file->fd,ash,ASH_SIZE)!=ASH_SIZE
		/*  */
				|| (ash_get_type(ash)!=streamtypeAUDIO
										&& ash_get_type(ash)!=streamtypeVIDEO)
		/* strh󥯤Ф(AVIStreamHeader)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' <- strh) */
				|| !chunk_out(avi_file->fd,ck)
		/* եबstrlLIST󥯤Ф
									(RIFF'AVI ' -> LIST'hdrl' <- LIST'strl') */
				|| !chunk_out(avi_file->fd,ck)
		/* եबstrlLIST󥯤
									(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl') */
				|| !chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file);
		return NULL;
	}
	/* strf󥯤õ(BitmapInfoHeader)|(WaveFormatEx) */
	while (chunk_id(avi_file->fd)!=ckidSTREAMFORMAT)
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file);
			return NULL;
		}
	/* strf󥯤Υ(BitmapInfoHeader)|(WaveFormatEx) */
	if ((size=chunk_size(avi_file->fd))==-1) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file);
		return NULL;
	}
	if (ash_get_type(ash)==streamtypeVIDEO) {
		if (size<BMIH_SIZE) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file);
			return NULL;
		}
		avi_file->bmih=g_malloc(size);
		avi_file->wfx=NULL;
	} else {
		if (size<WFX_SIZE-sizeof(guint16)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file);
			return NULL;
		}
		avi_file->wfx=g_malloc(MAX(size,WFX_SIZE));
		wfx_set_size(avi_file->wfx,0);
		avi_file->bmih=NULL;
	}
	/* strf󥯤(BitmapInfoHeader)|(WaveFormatEx)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' -> strf) */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* BitmapInfoHeader|WaveFormatExɤ߹ */
	if (read(avi_file->fd,ash_get_type(ash)==streamtypeVIDEO
			?(gpointer)avi_file->bmih:(gpointer)avi_file->wfx,size)!=size) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* 󥯥ݥ󥿤 */
	if (!chunk_free(ck)) {
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}

	/* ࡼӡ󥯤ذư */

	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(avi_file->fd);
	/* RIFF󥯤 */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* movi󥯤õ */
	while (chunk_form(avi_file->fd)!=listtypeAVIMOVIE)
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file->bmih);
			g_free(avi_file->wfx);
			g_free(avi_file);
			return NULL;
		}
	/* եΥեåȤ */
	if ((offset=lseek(avi_file->fd,0,SEEK_CUR))==-1) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	offset+=sizeof(guint32)+sizeof(guint32);/* moviΥեå */
	/* 󥯥ݥ󥿤 */
	if (!chunk_free(ck)) {
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}

	/* ǥå󥯤ذư */

	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(avi_file->fd);
	/* RIFF󥯤 */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* idx1󥯤õ */
	while (chunk_id(avi_file->fd)!=ckidAVINEWINDEX)
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file->bmih);
			g_free(avi_file->wfx);
			g_free(avi_file);
			return NULL;
		}
	/* idx1󥯤Υ */
	/* idx1󥯤(RIFF'AVI ' -> idx1) */
	if ((size=chunk_size(avi_file->fd))==-1 || !chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* ǥåɤ߹ */
	avi_file->entries=0;
	avi_file->index=NULL;
	for (i=0;i<size/AIE_SIZE;i++) {
		if (read(avi_file->fd,&avi_index,AIE_SIZE)!=AIE_SIZE) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file->bmih);
			g_free(avi_file->wfx);
			g_free(avi_file);
			return NULL;
		}
		if (((aie_get_ckid(&avi_index)&0xff)-'0')*10
							+((aie_get_ckid(&avi_index)>>8)&0xff)-'0'==param) {
			avi_file->index=g_realloc(avi_file->index,
											(avi_file->entries+1)*AIE_SIZE);
			avi_file->index[avi_file->entries].offset
								=aie_get_offset(&avi_index)
									+offset+sizeof(guint32)+sizeof(guint32);
			avi_file->index[avi_file->entries].size=aie_get_length(&avi_index);
			avi_file->index[avi_file->entries].flags=aie_get_flags(&avi_index);
			avi_file->entries++;
		}
	}
	/* 󥯥ݥ󥿤 */
	if (!chunk_free(ck)) {
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* ǥåȥإå */
	if (ash_get_type(ash)==streamtypeVIDEO) {
		avi_file->length=avi_file->entries;
	} else {
		avi_file->length=0;
		for (i=0;i<avi_file->entries;i++)
			avi_file->length+=avi_file->index[i].size
										/wfx_get_block_align(avi_file->wfx);
	}
	avi_file->handler=ash_get_handler(ash);
	/*  */
	if (type!=NULL)
		*type=ash_get_type(ash);
	if (rate!=NULL)
		*rate=ash_get_rate(ash);
	if (scale!=NULL)
		*scale=ash_get_scale(ash);
	g_free(ash);
	/* ե */
	avi_file->data=NULL;				/*  */
	return avi_file;
}


/*	ӥåȥޥåפAVIե빽¤Τ
	file,ե̾
	 RET,AVIե빽¤,NULL:顼										*/
static AviFile *avi_open_bitmap(const gchar *file)
{
	guint32 size;
	AviFile *avi_file;
	BitmapInfoHeader *bmih0,*bmih1;

	avi_file=g_malloc(sizeof(AviFile));
	/* ե򳫤 */
	if ((avi_file->fd=open(file,O_RDONLY))==-1) {
		g_free(avi_file);
		return NULL;
	}
	if (flock(avi_file->fd,LOCK_SH)==-1) {
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* ˥إåɤ߹ */
	if (lseek(avi_file->fd,BMFH_SIZE,SEEK_SET)==-1) {
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	avi_file->bmih=g_malloc(BMIH_SIZE);
	if (read(avi_file->fd,avi_file->bmih,BMIH_SIZE)!=BMIH_SIZE) {
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* إåΥ׻ */
	size=bm_header_bytes(avi_file->bmih);
	/* إåɤ߹ */
	avi_file->bmih=g_realloc(avi_file->bmih,size);
	if (lseek(avi_file->fd,BMFH_SIZE,SEEK_SET)==-1
							|| read(avi_file->fd,avi_file->bmih,size)!=size) {
		close(avi_file->fd);
		g_free(avi_file->bmih);
		g_free(avi_file);
		return NULL;
	}
	/* ᡼ɤ߹ */
	if (bmih_get_compression(avi_file->bmih)==BI_RGB
					|| bmih_get_compression(avi_file->bmih)==BI_BITFIELDS) {
		/* ̵ */
		size=bm_image_bytes(avi_file->bmih);
		avi_file->data=g_malloc(size);
		if (read(avi_file->fd,avi_file->data,size)!=size) {
			close(avi_file->fd);
			g_free(avi_file->bmih);
			g_free(avi_file->data);
			g_free(avi_file);
			return NULL;
		}
	} else if (bmih_get_compression(avi_file->bmih)==BI_RLE4
							|| bmih_get_compression(avi_file->bmih)==BI_RLE8) {
		/*  */
		bmih0=g_malloc(size+bmih_get_size_image(avi_file->bmih));
		g_memmove(bmih0,avi_file->bmih,size);
		if (read(avi_file->fd,(guint8 *)bmih0+size,bmih_get_size_image(bmih0))
												!=bmih_get_size_image(bmih0)) {
			g_free(bmih0);
			close(avi_file->fd);
			g_free(avi_file->bmih);
			g_free(avi_file);
			return NULL;
		}
		bmih1=g_malloc(bx_all_bytes(
				bmih_get_width(bmih0),bmih_get_height(bmih0),
				bmih_get_bit_count(bmih0),BI_RGB,bmih_get_color_used(bmih0)));
		bitmap_expand(bmih0,bmih1);
		g_free(bmih0);
		/* ŸDIB򥳥ԡ */
		size=bm_header_bytes(bmih1);
		avi_file->bmih=g_realloc(avi_file->bmih,size);
		g_memmove(avi_file->bmih,bmih1,size);
		avi_file->data=g_memdup((guint8 *)bmih1+size,
											bm_image_bytes(avi_file->bmih));
		g_free(bmih1);
	} else {
		close(avi_file->fd);
		g_free(avi_file->bmih);
		g_free(avi_file->data);
		g_free(avi_file);
		return NULL;
	}
	if (close(avi_file->fd)!=0) {
		g_free(avi_file->bmih);
		g_free(avi_file->data);
		g_free(avi_file);
		return NULL;
	}
	avi_file->handler=comptypeDIB;
	/* ե */
	avi_file->fd=-1;					/* եǥ꥿ */
	avi_file->length=1;
	avi_file->entries=1;				/* ǥåο */
	/* ǥͭ */
	avi_file->wfx=NULL;					/* ꥸʥΥեޥå */
	/* ǥå */
	avi_file->index=g_malloc(sizeof(AviIndex));
	avi_file->index[0].offset=0;
	avi_file->index[0].size=size;
	avi_file->index[0].flags=0;
	return avi_file;
}


/*	WAVEե뤫AVIե빽¤Τ
	file,ե̾
	 RET,AVIե빽¤,NULL:顼										*/
static AviFile *avi_open_wave(const gchar *file)
{
	guint32 size;
	off_t offset;				/* AVIΥࡼӡ */
	AviFile *avi_file;
	Chunk *ck;

	avi_file=g_malloc(sizeof(AviFile));
	/* ե򳫤 */
	if ((avi_file->fd=open(file,O_RDONLY))==-1) {
		g_free(avi_file);
		return NULL;
	}
	if (flock(avi_file->fd,LOCK_SH)==-1) {
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(avi_file->fd);
	/* RIFF󥯤 */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* fmt󥯤õ */
	while (chunk_id(avi_file->fd)!=ckidWAVEFORMAT) {
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(avi_file);
			return NULL;
		}
	}
	/* fmt󥯤Υ */
	/* fmt󥯤(RIFF'AVI ' -> fmt) */
	if ((size=chunk_size(avi_file->fd))==-1 || !chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	if (size<WFX_SIZE-sizeof(guint16)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	avi_file->wfx=g_malloc(MAX(size,WFX_SIZE));
	wfx_set_size(avi_file->wfx,0);
	/* WaveFormatExɤ߹ */
	if (read(avi_file->fd,avi_file->wfx,size)!=size) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* 󥯥ݥ󥿤 */
	if (!chunk_free(ck)) {
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}

	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(avi_file->fd);
	/* RIFF󥯤 */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* data󥯤õ */
	while (chunk_id(avi_file->fd)!=ckidWAVEDATA)
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(avi_file->wfx);
			g_free(avi_file);
			return NULL;
		}
	/* data󥯤Υ */
	/* data󥯤(RIFF'AVI ' -> data) */
	if ((size=chunk_size(avi_file->fd))==-1 || !chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* եΥեåȤ */
	if ((offset=lseek(avi_file->fd,0,SEEK_CUR))==-1) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* 󥯥ݥ󥿤 */
	if (!chunk_free(ck)) {
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* ե */
	avi_file->data=NULL;				/*  */
	avi_file->length=size/wfx_get_block_align(avi_file->wfx);
	avi_file->entries=1;				/* ǥåο */
	/* ӥǥͭ */
	avi_file->handler=0;
	avi_file->bmih=NULL;				/* ꥸʥΥեޥå */
	/* ǥå */
	avi_file->index=g_malloc(sizeof(AviIndex));
	avi_file->index[0].offset=offset;
	avi_file->index[0].size=size;
	avi_file->index[0].flags=0;
	return avi_file;
}


/*	AVIAVIե빽¤Τ
	 file,ե̾
	param,ȥ꡼ֹ
	 type,streamtypeAUDIO/streamtypeVIDEO
	 rate,졼
	scale,
	  RET,AVIե빽¤,NULL:顼										*/
AviFile *avi_open_file(const gchar *file,const gint param,
									guint32 *type,guint32 *rate,guint32 *scale)
{
	AviFile *avi_file=NULL;

	/* եηʬ */
	switch (avi_file_type(file)) {
		case 0:/* AVI */
			avi_file=avi_open_avi(file,param,type,rate,scale);
			break;
		case 1:/* ӥåȥޥå */
			avi_file=param==0?avi_open_bitmap(file):NULL;
			if (avi_file!=NULL) {
				if (type!=NULL)
					*type=streamtypeVIDEO;
				if (rate!=NULL)
					*rate=15;
				if (scale!=NULL)
					*scale=1;
			}
			break;
		case 2:/* WAVEե */
			avi_file=param==0?avi_open_wave(file):NULL;
			if (avi_file!=NULL) {
				if (type!=NULL)
					*type=streamtypeAUDIO;
				if (rate!=NULL)
					*rate=wfx_get_average_bytes_per_sec(avi_file->wfx);
				if (scale!=NULL)
					*scale=wfx_get_block_align(avi_file->wfx);
			}
	}
	if (avi_file!=NULL) {
		avi_file->name=misc_get_full_path(file);	/* ե̾ */
		avi_file->start=0;							/* ͭϰ */
		avi_file->param=param;						/* ȥ꡼ֹ */
		/* ꥹ */
		avi_file->prev=NULL;
		avi_file->next=NULL;
	}
	return avi_file;
}


/*	AVIե빽¤Τ
	avi_file,AVIե빽¤
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_release_file(AviFile *avi_file)
{
	gboolean result;

	result=avi_file->fd==-1 || close(avi_file->fd)==0;
	g_free(avi_file->name);
	g_free(avi_file->index);
	g_free(avi_file->bmih);
	g_free(avi_file->wfx);
	g_free(avi_file);
	return result;
}


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	AVI															*/
gboolean avi_init(void)
{
	return icm_init();
}


/*	AVIλ															*/
gboolean avi_exit(void)
{
	return icm_exit();
}
