/*
    Video maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __VMAID_H__
#define __VMAID_H__


#include "common.h"
#include "avicore/avicore.h"


#define MENUFILE 9


typedef struct VmaidCursor_Tag {
	gint stream;				/* ȥ꡼ΰ(0,1) */
	gint frame;					/* ߤΰ(0...) */
} VmaidCursor;
typedef struct VmaidHistory_Tag {
	AviEdit *avi_edit[2];		/* AVIԽ */
	VmaidCursor cursor,select;
	struct VmaidHistory_Tag *next;
} VmaidHistory;
typedef struct VmaidWindow_Tag {
	gboolean edit;				/* TRUE:ԽѤ,FALSE:̤Խ */
	gchar *file;				/* ե̾ */
	gint same;					/* -1:ʣʤ,0:ֹ */
	gint top;					/* ɥƬ */
	gint width,height;			/* ե졼Υ */
	guint rate,scale;			/* 졼ȡॹ=1ô֤Υե졼 */
	guint timer_id;				/* ѥ */
	AviEdit *avi_edit[2];		/* AVIԽ */
	VmaidCursor cursor;			/* åȤΰ */
	VmaidCursor select;			/* 򳫻ϰ,-1:ʤ */
	VmaidHistory *undo,*redo;	/* Խ */
	GtkWidget *drawing;			/* ΰ */
	GtkWidget *hscroll;			/* ʿС */
	GtkWidget *label;			/* ֤Υ٥ */
	GtkWidget *menu_item;		/* ˥塼Υɥι */
} VmaidWindow;


enum {
	TARGET_VMAID
};
enum {
	TARGET_STRING
};


extern gboolean caret;					/* åȤη */
extern gboolean newfile;				/* TRUE:ե,FALSE:ʤ */
extern gboolean second;					/* TRUE:,FALSE:¸ */
extern gboolean default_ratio;			/* TRUE:/Ψݻʤ */
extern gboolean file_merge;				/* TRUE:Ϣ,FALSE:ñ */
extern gchar *history_files[10];		/* ե */
extern gchar *open_path;				/* Υѥ */
extern gchar *save_path;				/* ̾դ¸Υѥ */
extern gchar *clipboard_scenario;		/* åץܡɤΥƥ */
extern gchar *arg_text;					/* ץ̿ѿ */
extern gint def_width,def_height;		/* ǥեȤΥɥΥ */
extern gint history;					/* ե */
extern gint instance;					/* ץ̿ѿ */
extern gint default_view;				/* ɥν */
extern guint default_rate;				/* ɥν */
extern guint timer_id;					/* ID */
extern GdkAtom atom_clipboard;			/* åץܡ */
extern GdkAtom atom_targets;			/* å */
extern GdkAtom atom_scenario;			/* ʥꥪ֥ */
extern GdkAtom atom_videomaid0;			/* ץ̿ѥȥ */
extern GdkAtom atom_videomaid1;			/* ץ̿ѥȥ */
extern GdkBitmap *bitmap0;				/* ط */
extern GdkBitmap *bitmap1;				/* ط */
extern GtkWidget *window;				/* ɥ */
extern GtkWidget *notebook;				/* Ρȥ֥å */
extern GtkWidget *clist;				/* ꥹȥܥå */
extern GtkWidget *status;				/* ơɥ */
extern GtkPositionType n_pos;			/* Ρȥ֥åΰ */
extern GtkItemFactory *item_factory_menu;	/* ˥塼 */
extern GtkItemFactory *item_factory_popup;	/* ݥåץå */
extern GdkFont *system_font;			/* ե */
extern gint system_font_height;			/* եȤι⤵ */
extern gint system_font_ascent;			/* եȤΥȤι⤵ */
extern GdkColor system_color[4];
extern GtkTargetEntry targets[1];	/* Video maid󶡲ǽʥ쥯 */


#endif
