/*
    avicore
    copyright (c) 2000-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "avibase.h"
#include <gdk/gdkkeysyms.h>


/******************************************************************************
*                                                                             *
* ؿ()                                                      *
*                                                                             *
******************************************************************************/
typedef struct AviWidgetDialog_Tag {
	gint video,audio;		/* ӥǥ/ǥȥ꡼ο */
	AviSave *avi_save;		/* ¸ */
	GtkAccelGroup *accel;	/* 졼 */
	GtkWidget *dialog,*frame0,*frame1,*notebook,*spin0,*spin1;
	GtkWidget *radio0,*radio1,*radio2,*radio3;
} AviWidgetDialog;
typedef struct AviWidgetStream_Tag {
	AviEdit *avi_edit;		/* AVIԽ¤ */
	GtkWidget *button,*check,*combo;
	GtkWidget *label0,*label1,*label2,*spin0,*spin1,*spin2;
} AviWidgetStream;


/* 饸ܥ(AVI)줿 */
static void avi_save_dialog_toggled_avi(GtkWidget *widget,
												AviWidgetDialog *avi_dialog)
{
	gint i;
	GList *glist;

	if (avi_dialog->frame0!=NULL)
		gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->frame0),FALSE);
	if (avi_dialog->frame1!=NULL) {
		gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->frame1),TRUE);
	} else {
		gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->notebook),TRUE);
		glist=gtk_container_children(GTK_CONTAINER(avi_dialog->notebook));
		for (i=g_list_length(glist)-1;i>=0;i--)
			gtk_widget_set_sensitive(GTK_WIDGET(g_list_nth_data(glist,i)),
																		TRUE);
		g_list_free(glist);
	}
}


/* 饸ܥ(ӥåȥޥå)줿 */
static void avi_save_dialog_toggled_bitmap(GtkWidget *widget,
												AviWidgetDialog *avi_dialog)
{
	gint i;
	GList *glist;

	gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->frame0),TRUE);
	if (avi_dialog->frame1!=NULL) {
		gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->frame1),FALSE);
	} else {
		if (avi_dialog->video<=1) {
			gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->notebook),FALSE);
		} else {
			gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->notebook),TRUE);
			glist=gtk_container_children(GTK_CONTAINER(avi_dialog->notebook));
			for (i=g_list_length(glist)-1;i>=0;i--)
				gtk_widget_set_sensitive(GTK_WIDGET(g_list_nth_data(glist,i)),
																		FALSE);
			g_list_free(glist);
		}
	}
}


/* 饸ܥ(WAVE)줿 */
static void avi_save_dialog_toggled_wave(GtkWidget *widget,
												AviWidgetDialog *avi_dialog)
{
	gint i;
	GList *glist;

	if (avi_dialog->frame0!=NULL)
		gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->frame0),FALSE);
	if (avi_dialog->frame1!=NULL)
		gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->frame1),FALSE);
	if (avi_dialog->notebook!=NULL) {
		if (avi_dialog->audio<=1) {
			gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->notebook),FALSE);
		} else {
			gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->notebook),TRUE);
			glist=gtk_container_children(GTK_CONTAINER(avi_dialog->notebook));
			for (i=g_list_length(glist)-1;i>=0;i--)
				gtk_widget_set_sensitive(GTK_WIDGET(g_list_nth_data(glist,i)),
																		FALSE);
			g_list_free(glist);
		}
	}
}


/* 饸ܥ(ʥꥪ֥)줿 */
static void avi_save_dialog_toggled_scenario(GtkWidget *widget,
												AviWidgetDialog *avi_dialog)
{
	if (avi_dialog->frame0!=NULL)
		gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->frame0),FALSE);
	if (avi_dialog->frame1!=NULL)
		gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->frame1),FALSE);
	if (avi_dialog->notebook!=NULL)
		gtk_widget_set_sensitive(GTK_WIDGET(avi_dialog->notebook),FALSE);
}


/* 饸ܥ(ӥǥȥ꡼)줿 */
static void avi_save_dialog_toggled_video(GtkWidget *widget,
												AviWidgetDialog *avi_dialog)
{
	gint max;
#ifndef USE_GTK2
	GtkAdjustment *adjust;
#endif

	max=(gint)gtk_object_get_user_data(GTK_OBJECT(widget));
#ifdef USE_GTK2
	gtk_spin_button_set_range(GTK_SPIN_BUTTON(avi_dialog->spin0),0,max);
#else
	adjust=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(avi_dialog->spin0));
	adjust->lower=0;
	adjust->upper=max;
#endif
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(avi_dialog->spin0),0);

#ifdef USE_GTK2
	gtk_spin_button_set_range(GTK_SPIN_BUTTON(avi_dialog->spin1),0,max);
#else
	adjust=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(avi_dialog->spin1));
	adjust->lower=0;
	adjust->upper=max;
#endif
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(avi_dialog->spin1),max);
}


/* ܥܥåƤѤäȤ */
static void avi_save_dialog_changed(GtkWidget *widget,
												AviWidgetStream *avi_stream)
{
	gchar *label;
	const gchar *text;
	gint i,length,quality,key_frame;
	GList *glist;
	IcmObject *icm_object;
	IcmInfo icm_info;

	text=gtk_entry_get_text(GTK_ENTRY(widget));
	glist=gtk_container_children(GTK_CONTAINER(GTK_COMBO(
													avi_stream->combo)->list));
	length=g_list_length(glist);
	for (i=0;i<length;i++) {
		gtk_label_get(GTK_LABEL(
							GTK_BIN(g_list_nth_data(glist,i))->child),&label);
		if (g_strcmp(label,text)==0)
			break;
	}
	icm_object=gtk_object_get_user_data(GTK_OBJECT(g_list_nth_data(glist,i)));
	g_list_free(glist);
	gtk_object_set_user_data(GTK_OBJECT(avi_stream->combo),icm_object);

	quality=icm_object!=NULL?icm_compress_get_default_quality(icm_object):-1;
	key_frame=icm_object!=NULL
							?icm_compress_get_default_key_frame(icm_object):0;
	/* ԥܥ */
	if (avi_stream->spin0!=NULL) {
		gtk_widget_set_sensitive(GTK_WIDGET(avi_stream->label0),quality>=0);
		gtk_widget_set_sensitive(GTK_WIDGET(avi_stream->spin0),quality>=0);
		if (quality>=0)
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(avi_stream->spin0),
																	quality);
	}
	if (avi_stream->spin1!=NULL) {
		gtk_widget_set_sensitive(GTK_WIDGET(avi_stream->label1),key_frame>0);
		gtk_widget_set_sensitive(GTK_WIDGET(avi_stream->spin1),key_frame>0);
		if (key_frame>0)
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(avi_stream->spin1),
																	key_frame);
	}
	if (avi_stream->spin2!=NULL) {
		if (icm_object!=NULL && icm_get_info(icm_object,&icm_info)
									&& (icm_info.flags&ICM_FLAG_CRUNCH)!=0) {
			gtk_widget_set_sensitive(GTK_WIDGET(avi_stream->label2),TRUE);
			gtk_widget_set_sensitive(GTK_WIDGET(avi_stream->spin2),TRUE);
		} else {
			gtk_widget_set_sensitive(GTK_WIDGET(avi_stream->label2),FALSE);
			gtk_widget_set_sensitive(GTK_WIDGET(avi_stream->spin2),FALSE);
		}
	}
	/* åܥ */
	if (avi_stream->check!=NULL)
		gtk_widget_set_sensitive(GTK_WIDGET(avi_stream->check),
															icm_object!=NULL);
	/* ܥ */
	if (avi_stream->button!=NULL)
		gtk_widget_set_sensitive(GTK_WIDGET(avi_stream->button),
					icm_object!=NULL && icm_is_dialog_configure(icm_object));
}


/* ܥ󤬲줿 */
static void avi_save_dialog_clicked_config(GtkWidget *widget,GtkWidget *combo)
{
	icm_dialog_configure(gtk_object_get_user_data(GTK_OBJECT(combo)));
}


/* OKܥ󤬲줿 */
static void 
avi_save_dialog_clicked_ok(GtkWidget *widget,AviWidgetDialog *avi_dialog)
{
	gint i,streams,value;
	GList *glist;
	GtkWidget *child,*radio;
	AviSave *avi_save;
	AviWidgetStream *avi_stream;
	IcmObject *icm_object;

	avi_save=g_malloc0(sizeof(AviSave));
	if (avi_dialog->radio0!=NULL && gtk_toggle_button_get_active(
									GTK_TOGGLE_BUTTON(avi_dialog->radio0))) {
		avi_save->type=AVI_TYPE_AVI;
		if (avi_dialog->frame1 != NULL)
		  {
			streams = 1;
		  }
		else
		  {
			glist = gtk_container_children
										(GTK_CONTAINER (avi_dialog->notebook));
			streams = g_list_length (glist);
			g_list_free (glist);
		  }
		avi_save->avi_opt = g_malloc0 ((streams + 1) * sizeof (AviOptions));
		for (i=0;i<streams;i++)
		  {
			if (avi_dialog->frame1 != NULL)
			  {
				child = GTK_BIN (avi_dialog->frame1)->child;
			  }
			else
			  {
				child = gtk_notebook_get_nth_page
									(GTK_NOTEBOOK (avi_dialog->notebook), i);
			  }
			avi_stream=gtk_object_get_user_data(GTK_OBJECT(child));
			avi_save->avi_opt[i].type=avi_type(avi_stream->avi_edit);
			if (avi_stream->combo!=NULL
							&& (icm_object=gtk_object_get_user_data(GTK_OBJECT(
												avi_stream->combo)))!=NULL) {
				avi_save->avi_opt[i].handler=icm_get_handler(icm_object);
				avi_save->avi_opt[i].key_frame=avi_stream->spin0!=NULL
								&& GTK_WIDGET_IS_SENSITIVE(avi_stream->spin0)
							?gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(
														avi_stream->spin0)):0;
				avi_save->avi_opt[i].quality=avi_stream->spin1!=NULL
								&& GTK_WIDGET_IS_SENSITIVE(avi_stream->spin1)
							?gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(
														avi_stream->spin1)):-1;
				avi_save->avi_opt[i].data_rate=avi_stream->spin2!=NULL
								&& GTK_WIDGET_IS_SENSITIVE(avi_stream->spin2)
							?gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(
														avi_stream->spin2)):0;
				avi_save->avi_opt[i].recompress=avi_stream->check!=NULL
								&& GTK_WIDGET_IS_SENSITIVE(avi_stream->check)
							&& gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(
														avi_stream->check));
				avi_save->avi_opt[i].param_size=icm_get_state_size(icm_object);
				if (avi_save->avi_opt[i].param_size>0) {
					avi_save->avi_opt[i].param
									=g_malloc(avi_save->avi_opt[i].param_size);
					icm_get_state(icm_object,avi_save->avi_opt[i].param,
											avi_save->avi_opt[i].param_size);
				}
				avi_save->avi_opt[i].bmih_size=icm_compress_get_format_size(
										icm_object,avi_stream->avi_edit->bmih);
				avi_save->avi_opt[i].bmih
									=g_malloc(avi_save->avi_opt[i].bmih_size);
				if (!icm_compress_get_format(icm_object,
					avi_stream->avi_edit->bmih,avi_save->avi_opt[i].bmih)) {
					g_free(avi_save->avi_opt[i].bmih);
					avi_save->avi_opt[i].bmih=NULL;
					avi_save->avi_opt[i].bmih_size=0;
				}
			}
		}
	} else if (avi_dialog->radio1!=NULL && gtk_toggle_button_get_active(
									GTK_TOGGLE_BUTTON(avi_dialog->radio1))) {
		avi_save->type=AVI_TYPE_BITMAP;
		avi_save->start=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(
														avi_dialog->spin0));
		avi_save->end=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(
														avi_dialog->spin1));
		if (avi_save->start>avi_save->end) {
			value=avi_save->start;
			avi_save->start=avi_save->end;
			avi_save->end=value;
		}
		if (avi_dialog->frame1==NULL) {
			glist=gtk_container_children(GTK_CONTAINER(avi_dialog->notebook));
			streams=g_list_length(glist);
			g_list_free(glist);
			for (i=0;i<streams;i++) {
				child=gtk_notebook_get_nth_page(
										GTK_NOTEBOOK(avi_dialog->notebook),i);
				radio=gtk_notebook_get_tab_label(
									GTK_NOTEBOOK(avi_dialog->notebook),child);
				avi_stream=gtk_object_get_user_data(GTK_OBJECT(child));
				if (avi_type(avi_stream->avi_edit)==streamtypeVIDEO
					&& (!GTK_IS_RADIO_BUTTON(radio)
					|| gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio))))
					break;
			}
			avi_save->stream=i;
		}
	} else if (avi_dialog->radio2!=NULL && gtk_toggle_button_get_active(
									GTK_TOGGLE_BUTTON(avi_dialog->radio2))) {
		avi_save->type=AVI_TYPE_WAVE;
		if (avi_dialog->notebook!=NULL) {
			glist=gtk_container_children(GTK_CONTAINER(avi_dialog->notebook));
			streams=g_list_length(glist);
			g_list_free(glist);
			for (i=0;i<streams;i++) {
				child=gtk_notebook_get_nth_page(
										GTK_NOTEBOOK(avi_dialog->notebook),i);
				radio=gtk_notebook_get_tab_label(
									GTK_NOTEBOOK(avi_dialog->notebook),child);
				avi_stream=gtk_object_get_user_data(GTK_OBJECT(child));
				if (avi_type(avi_stream->avi_edit)==streamtypeAUDIO
					&& (!GTK_IS_RADIO_BUTTON(radio)
					|| gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio))))
					break;
			}
			avi_save->stream=i;
		}
	} else if (gtk_toggle_button_get_active(
									GTK_TOGGLE_BUTTON(avi_dialog->radio3))) {
		avi_save->type=AVI_TYPE_SCENARIO;
	} else {
		g_free(avi_save);
		avi_save=NULL;
	}
	avi_dialog->avi_save=avi_save;
	gtk_widget_destroy(avi_dialog->dialog);
}


/* ڡ˴ */
static void avi_save_dialog_destroy_vbox(GtkWidget *widget,
												AviWidgetDialog *avi_dialog)
{
	g_free(avi_dialog);
}


/* ܥܥå˴ */
static void avi_save_dialog_destroy_list(GtkWidget *widget,gpointer user_data)
{
	gint i;
	GList *glist;

	glist=gtk_container_children(GTK_CONTAINER(widget));
	for (i=g_list_length(glist)-1;i>=0;i--)
		icm_close(gtk_object_get_user_data(GTK_OBJECT(
												g_list_nth_data(glist,i))));
	g_list_free(glist);
}


/* ԥܥǥ꥿󤬲줿 */
#define avi_save_dialog_activate avi_save_dialog_clicked_ok


/* ESC줿 */
static gboolean avi_save_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


/*	¸ѤΥץΥΥ١
	avi_edit,AVIԽϥɥؤΥݥ
	     RET,å,NULL:顼											*/
static GtkWidget *avi_save_dialog_base(AviEdit *avi_edit[],
												AviWidgetDialog *avi_dialog)
{
	gchar *text;
	gint i,j,leng,length,streams,video=0,audio=0;
	guint key;
	GList *glist;
	GList *glist_handler;	/* ϿƤ4ʸ */
	GList *glist_object;	/* IcmObjectΥꥹ */
	GList *glist_name;		/* ̾Υꥹ */
	GSList *gslist;			/* 饸ܥ */
	GSList *gslist_v=NULL;	/* 饸ܥ */
	GSList *gslist_a=NULL;	/* 饸ܥ */
	GtkWidget *label0,*label1,*radio;
	GtkWidget *frame,*hbox0,*hbox1,*vbox;
	AviWidgetStream *avi_stream;
	IcmObject *icm_object;
	IcmInfo icm_info;

	if (avi_edit==NULL)
		return NULL;
	g_memset(avi_dialog,0,sizeof(AviWidgetDialog));
	for (streams=0;avi_edit[streams]!=NULL;streams++)
		switch (avi_type(avi_edit[streams])) {
			case streamtypeVIDEO:video++;break;
			case streamtypeAUDIO:audio++;break;
			default:return NULL;
		}
	if (streams<=0)
		return NULL;
	avi_dialog->video=video;
	avi_dialog->audio=audio;

	/* 졼 */
	avi_dialog->accel=gtk_accel_group_new();

	/* AVI */
	if (avi_dialog->video>0 || avi_dialog->audio>1) {
		/* 饸ܥ */
		avi_dialog->radio0=gtk_radio_button_new_with_label(NULL,"");
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(
										avi_dialog->radio0)->child),_("_AVI"));
		gtk_widget_add_accelerator(avi_dialog->radio0,"clicked",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
		gtk_signal_connect(GTK_OBJECT(avi_dialog->radio0),"toggled",
					GTK_SIGNAL_FUNC(avi_save_dialog_toggled_avi),avi_dialog);
		gslist=gtk_radio_button_group(GTK_RADIO_BUTTON(avi_dialog->radio0));
		if (streams>1) {
			/* Ρȥ֥å */
			avi_dialog->notebook=gtk_notebook_new();
			gtk_notebook_set_scrollable(GTK_NOTEBOOK(avi_dialog->notebook),
																		TRUE);
		} else {
			/* ե졼 */
			avi_dialog->frame1=gtk_frame_new("Video #1");
		}
		video=audio=0;
		glist_handler=icm_get_handler_list();
		length=g_list_length(glist_handler);
		for (i=0;i<streams;i++) {
			avi_stream=g_malloc0(sizeof(AviWidgetStream));
			avi_stream->avi_edit=avi_edit[i];
			vbox=gtk_vbox_new(FALSE,8);
			gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
			gtk_object_set_user_data(GTK_OBJECT(vbox),avi_stream);
			gtk_signal_connect(GTK_OBJECT(vbox),"destroy",
					GTK_SIGNAL_FUNC(avi_save_dialog_destroy_vbox),avi_stream);
			if (avi_type(avi_edit[i])==streamtypeVIDEO) {
				/* ̤ */
				glist_object=g_list_append(NULL,NULL);
				glist_name=g_list_append(NULL,g_strdup(_("Uncompress")));
				/* 4ʸɤˤĤ */
				for (j=0;j<length;j++) {
					if ((icm_object=icm_open(
									(guint32)g_list_nth_data(glist_handler,j),
													ICM_MODE_COMPRESS))==NULL)
						continue;
					if (!icm_compress_query(icm_object,avi_edit[i]->bmih)
									|| !icm_get_info(icm_object,&icm_info)) {
						icm_close(icm_object);
						continue;
					}
					/* ԥܥ */
					if (avi_stream->spin0==NULL
							&& icm_compress_get_default_quality(icm_object)>=0)
						avi_stream->spin0=gtk_spin_button_new(GTK_ADJUSTMENT(
								gtk_adjustment_new(-1,-1,10000,1,5,0)),0,0);
					if (avi_stream->spin1==NULL
						&& icm_compress_get_default_key_frame(icm_object)>0)
						avi_stream->spin1=gtk_spin_button_new(GTK_ADJUSTMENT(
								gtk_adjustment_new(0,0,G_MAXINT,1,5,0)),0,0);
					if (avi_stream->spin2==NULL
										&& (icm_info.flags&ICM_FLAG_CRUNCH)!=0)
						avi_stream->spin2=gtk_spin_button_new(GTK_ADJUSTMENT(
								gtk_adjustment_new(0,0,G_MAXINT,1,5,0)),0,0);
					/* ܥ */
					if (avi_stream->button==NULL
										&& icm_is_dialog_configure(icm_object))
						avi_stream->button=gtk_button_new_with_label("");
					glist_object=g_list_append(glist_object,icm_object);
					glist_name=g_list_append(glist_name,icm_info.name);
				}
				if (g_list_length(glist_name)>1) {
					/* åܥ */
					avi_stream->check=gtk_check_button_new_with_label("");
					key=gtk_label_parse_uline(
								GTK_LABEL(GTK_BIN(avi_stream->check)->child),
															_("_Recompress"));
					gtk_widget_add_accelerator(avi_stream->check,"clicked",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
					gtk_toggle_button_set_active(
								GTK_TOGGLE_BUTTON(avi_stream->check),FALSE);
					gtk_widget_set_sensitive(avi_stream->check,FALSE);
					/* ܥܥå */
					avi_stream->combo=gtk_combo_new();
					gtk_combo_set_popdown_strings(GTK_COMBO(avi_stream->combo),
																glist_name);
					glist=gtk_container_children(
							GTK_CONTAINER(GTK_COMBO(avi_stream->combo)->list));
					leng=g_list_length(glist);
					for (j=0;j<leng;j++)
						gtk_object_set_user_data(
										GTK_OBJECT(g_list_nth_data(glist,j)),
											g_list_nth_data(glist_object,j));
					gtk_combo_set_value_in_list(GTK_COMBO(avi_stream->combo),
																TRUE,FALSE);
					gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(
											avi_stream->combo)->entry),FALSE);
					gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(
								avi_stream->combo)->entry),
								(const gchar *)g_list_nth_data(glist_name,0));
					gtk_signal_connect(GTK_OBJECT(GTK_COMBO(
										avi_stream->combo)->entry),"changed",
						GTK_SIGNAL_FUNC(avi_save_dialog_changed),avi_stream);
					gtk_signal_connect(GTK_OBJECT(GTK_COMBO(
										avi_stream->combo)->list),"destroy",
						GTK_SIGNAL_FUNC(avi_save_dialog_destroy_list),NULL);
					/* ٥ */
					label0=gtk_label_new("");
					key=gtk_label_parse_uline(GTK_LABEL(label0),
															_("_Compressor"));
					gtk_widget_add_accelerator(GTK_COMBO(
										avi_stream->combo)->entry,"grab-focus",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
				} else {
					label0=gtk_label_new((const gchar *)
												g_list_nth_data(glist_name,0));
					g_list_free(glist_name);
				}
				g_list_free(glist_object);
				if (avi_stream->spin0!=NULL) {
					gtk_spin_button_set_numeric(
									GTK_SPIN_BUTTON(avi_stream->spin0),TRUE);
#ifndef USE_GTK2
					gtk_spin_button_set_shadow_type(
							GTK_SPIN_BUTTON(avi_stream->spin0),GTK_SHADOW_IN);
#endif
					avi_stream->label0=gtk_label_new("");
					key=gtk_label_parse_uline(GTK_LABEL(avi_stream->label0),
																_("_Quality"));
					gtk_widget_add_accelerator(avi_stream->spin0,"grab-focus",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
					gtk_signal_connect(GTK_OBJECT(avi_stream->spin0),
						"activate",GTK_SIGNAL_FUNC(avi_save_dialog_activate),
																avi_dialog);
					gtk_widget_set_sensitive(avi_stream->spin0,FALSE);
					gtk_widget_set_sensitive(avi_stream->label0,FALSE);
				}
				if (avi_stream->spin1!=NULL) {
					gtk_spin_button_set_numeric(
									GTK_SPIN_BUTTON(avi_stream->spin1),TRUE);
#ifndef USE_GTK2
					gtk_spin_button_set_shadow_type(
							GTK_SPIN_BUTTON(avi_stream->spin1),GTK_SHADOW_IN);
#endif
					avi_stream->label1=gtk_label_new("");
					key=gtk_label_parse_uline(GTK_LABEL(avi_stream->label1),
															_("_Key Frame"));
					gtk_widget_add_accelerator(avi_stream->spin1,"grab-focus",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
					gtk_signal_connect(GTK_OBJECT(avi_stream->spin1),
						"activate",GTK_SIGNAL_FUNC(avi_save_dialog_activate),
																avi_dialog);
					gtk_widget_set_sensitive(avi_stream->spin1,FALSE);
					gtk_widget_set_sensitive(avi_stream->label1,FALSE);
				}
				if (avi_stream->spin2!=NULL) {
					gtk_spin_button_set_numeric(
									GTK_SPIN_BUTTON(avi_stream->spin2),TRUE);
#ifndef USE_GTK2
					gtk_spin_button_set_shadow_type(
							GTK_SPIN_BUTTON(avi_stream->spin2),GTK_SHADOW_IN);
#endif
					avi_stream->label2=gtk_label_new("");
					key=gtk_label_parse_uline(GTK_LABEL(avi_stream->label2),
															_("_Data Rate"));
					gtk_widget_add_accelerator(avi_stream->spin2,"grab-focus",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
					gtk_signal_connect(GTK_OBJECT(avi_stream->spin2),
						"activate",GTK_SIGNAL_FUNC(avi_save_dialog_activate),
																avi_dialog);
					gtk_widget_set_sensitive(avi_stream->spin2,FALSE);
					gtk_widget_set_sensitive(avi_stream->label2,FALSE);
				}
				if (avi_stream->button!=NULL) {
					key=gtk_label_parse_uline(
								GTK_LABEL(GTK_BIN(avi_stream->button)->child),
														_("Con_figure..."));
					gtk_widget_add_accelerator(avi_stream->button,"clicked",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
					gtk_signal_connect(GTK_OBJECT(avi_stream->button),
							"clicked",
							GTK_SIGNAL_FUNC(avi_save_dialog_clicked_config),
															avi_stream->combo);
					GTK_WIDGET_SET_FLAGS(avi_stream->button,GTK_CAN_DEFAULT);
					gtk_widget_set_sensitive(avi_stream->button,FALSE);
				}
				/* ե졼ȥܥå */
				if (avi_stream->combo!=NULL) {
					hbox0=gtk_hbox_new(FALSE,0);
					gtk_box_pack_start(GTK_BOX(hbox0),label0,FALSE,FALSE,0);
					gtk_box_pack_start(GTK_BOX(hbox0),
												avi_stream->combo,TRUE,TRUE,0);
					gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
				} else {
					gtk_box_pack_start(GTK_BOX(vbox),label0,FALSE,FALSE,0);
				}
				if (avi_stream->spin0!=NULL) {
					hbox0=gtk_hbox_new(FALSE,0);
					gtk_box_pack_start(GTK_BOX(hbox0),
											avi_stream->label0,FALSE,FALSE,0);
					gtk_box_pack_start(GTK_BOX(hbox0),
												avi_stream->spin0,TRUE,TRUE,0);
					gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
				}
				if (avi_stream->spin1!=NULL) {
					hbox0=gtk_hbox_new(FALSE,0);
					gtk_box_pack_start(GTK_BOX(hbox0),
											avi_stream->label1,FALSE,FALSE,0);
					gtk_box_pack_start(GTK_BOX(hbox0),
												avi_stream->spin1,TRUE,TRUE,0);
					gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
				}
				if (avi_stream->spin2!=NULL) {
					hbox0=gtk_hbox_new(FALSE,0);
					gtk_box_pack_start(GTK_BOX(hbox0),
											avi_stream->label2,FALSE,FALSE,0);
					gtk_box_pack_start(GTK_BOX(hbox0),
												avi_stream->spin2,TRUE,TRUE,0);
					gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
				}
				if (avi_stream->check!=NULL || avi_stream->button!=NULL) {
					hbox0=gtk_hbox_new(FALSE,8);
					if (avi_stream->check!=NULL)
						gtk_box_pack_start(GTK_BOX(hbox0),
												avi_stream->check,TRUE,TRUE,0);
					if (avi_stream->button!=NULL)
						gtk_box_pack_end(GTK_BOX(hbox0),
											avi_stream->button,FALSE,FALSE,0);
					gtk_box_pack_end(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
				}
			} else {
				gtk_box_pack_start(GTK_BOX(vbox),
										gtk_label_new(_("PCM")),FALSE,FALSE,0);
			}
			text=avi_type(avi_edit[i])==streamtypeVIDEO
										?g_strdup_printf("Video #%d",++video)
										:g_strdup_printf("Audio #%d",++audio);
			if (avi_dialog->notebook!=NULL) {
				if (avi_type(avi_edit[i])==streamtypeVIDEO
													&& avi_dialog->video>1) {
					radio=gtk_radio_button_new_with_label(gslist_v,text);
					gtk_object_set_user_data(GTK_OBJECT(radio),
										(gpointer)(avi_length(avi_edit[i])-1));
					gtk_signal_connect(GTK_OBJECT(radio),"toggled",
								GTK_SIGNAL_FUNC(avi_save_dialog_toggled_video),
																avi_dialog);
					gslist_v=gtk_radio_button_group(GTK_RADIO_BUTTON(radio));
				} else if (avi_type(avi_edit[i])==streamtypeAUDIO
													&& avi_dialog->audio>1) {
					radio=gtk_radio_button_new_with_label(gslist_a,text);
					gslist_a=gtk_radio_button_group(GTK_RADIO_BUTTON(radio));
				} else {
					radio=NULL;
				}
				gtk_notebook_append_page(GTK_NOTEBOOK(avi_dialog->notebook),
								vbox,radio==NULL?gtk_label_new(text):radio);
			} else {
				gtk_container_add(GTK_CONTAINER(avi_dialog->frame1),vbox);
			}
			g_free(text);
		}
	} else {
		gslist=NULL;
	}
	/* ӥåȥޥå */
	if (avi_dialog->video>0) {
		/* 饸ܥ */
		avi_dialog->radio1=gtk_radio_button_new_with_label(gslist,"");
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(
									avi_dialog->radio1)->child),_("_Bitmap"));
		gtk_widget_add_accelerator(avi_dialog->radio1,"clicked",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
		gtk_signal_connect(GTK_OBJECT(avi_dialog->radio1),"toggled",
				GTK_SIGNAL_FUNC(avi_save_dialog_toggled_bitmap),avi_dialog);
		gslist=gtk_radio_button_group(GTK_RADIO_BUTTON(avi_dialog->radio1));
		/* ԥܥ */
		for (i=0;i<streams;i++)
			if (avi_type(avi_edit[i])==streamtypeVIDEO)
				break;
		avi_dialog->spin0=gtk_spin_button_new(GTK_ADJUSTMENT(
				gtk_adjustment_new(0,0,avi_length(avi_edit[i])-1,1,5,0)),0,0);
		avi_dialog->spin1=gtk_spin_button_new(GTK_ADJUSTMENT(
				gtk_adjustment_new(avi_length(avi_edit[i])-1,
									0,avi_length(avi_edit[i])-1,1,5,0)),0,0);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(avi_dialog->spin0),TRUE);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(avi_dialog->spin1),TRUE);
#ifndef USE_GTK2
		gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(avi_dialog->spin0),
																GTK_SHADOW_IN);
		gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(avi_dialog->spin1),
																GTK_SHADOW_IN);
#endif
		gtk_signal_connect(GTK_OBJECT(avi_dialog->spin0),"activate",
						GTK_SIGNAL_FUNC(avi_save_dialog_activate),avi_dialog);
		gtk_signal_connect(GTK_OBJECT(avi_dialog->spin1),"activate",
						GTK_SIGNAL_FUNC(avi_save_dialog_activate),avi_dialog);
		/* ٥ */
		label0=gtk_label_new("");
		label1=gtk_label_new("");
		key=gtk_label_parse_uline(GTK_LABEL(label0),_("_Start"));
		gtk_widget_add_accelerator(avi_dialog->spin0,"grab-focus",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
		key=gtk_label_parse_uline(GTK_LABEL(label1),_("_End"));
		gtk_widget_add_accelerator(avi_dialog->spin1,"grab-focus",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
		/* ե졼ȥܥå */
		hbox0=gtk_hbox_new(FALSE,8);
		gtk_container_set_border_width(GTK_CONTAINER(hbox0),8);
		hbox1=gtk_hbox_new(FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox1),label0,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox1),avi_dialog->spin0,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(hbox0),hbox1,FALSE,FALSE,0);
		hbox1=gtk_hbox_new(FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox1),label1,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox1),avi_dialog->spin1,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(hbox0),hbox1,FALSE,FALSE,0);
		avi_dialog->frame0=gtk_frame_new(_("Range"));
		gtk_container_add(GTK_CONTAINER(avi_dialog->frame0),hbox0);
		gtk_widget_set_sensitive(avi_dialog->frame0,FALSE);
	}
	/* WAVE */
	if (avi_dialog->audio>0) {
		/* 饸ܥ */
		avi_dialog->radio2=gtk_radio_button_new_with_label(gslist,"");
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(
									avi_dialog->radio2)->child),_("_WAVE"));
		gtk_widget_add_accelerator(avi_dialog->radio2,"clicked",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
		gtk_signal_connect(GTK_OBJECT(avi_dialog->radio2),"toggled",
					GTK_SIGNAL_FUNC(avi_save_dialog_toggled_wave),avi_dialog);
		gslist=gtk_radio_button_group(GTK_RADIO_BUTTON(avi_dialog->radio2));
	}
	/* ʥꥪ֥ */
	/* 饸ܥ */
	avi_dialog->radio3=gtk_radio_button_new_with_label(gslist,"");
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(avi_dialog->radio3)->child),
														_("Scenario _Object"));
	gtk_widget_add_accelerator(avi_dialog->radio3,"clicked",
										avi_dialog->accel,key,GDK_MOD1_MASK,0);
	gtk_signal_connect(GTK_OBJECT(avi_dialog->radio3),"toggled",
				GTK_SIGNAL_FUNC(avi_save_dialog_toggled_scenario),avi_dialog);

	/* ե졼ȥܥå */
	hbox0=gtk_hbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(hbox0),8);
	if (avi_dialog->radio0!=NULL)
		gtk_box_pack_start(GTK_BOX(hbox0),avi_dialog->radio0,FALSE,FALSE,0);
	if (avi_dialog->radio1!=NULL)
		gtk_box_pack_start(GTK_BOX(hbox0),avi_dialog->radio1,FALSE,FALSE,0);
	if (avi_dialog->radio2!=NULL)
		gtk_box_pack_start(GTK_BOX(hbox0),avi_dialog->radio2,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),avi_dialog->radio3,FALSE,FALSE,0);
	frame=gtk_frame_new(_("Format"));
	gtk_container_add(GTK_CONTAINER(frame),hbox0);

	vbox=gtk_vbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),frame,FALSE,FALSE,0);
	if (avi_dialog->frame0!=NULL)
		gtk_box_pack_start(GTK_BOX(vbox),avi_dialog->frame0,FALSE,FALSE,0);
	if (avi_dialog->frame1!=NULL)
		gtk_box_pack_start(GTK_BOX(vbox),avi_dialog->frame1,FALSE,FALSE,0);
	if (avi_dialog->notebook!=NULL)
		gtk_box_pack_start(GTK_BOX(vbox),avi_dialog->notebook,FALSE,FALSE,0);

	return vbox;
}


/*	¸ѤΥץ
	avi_edit,AVIԽϥɥؤΥݥ
	     RET,ץ,NULL:顼											*/
AviSave *avi_save_dialog(AviEdit *avi_edit[])
{
	GtkWidget *button0,*button1,*hbox,*vbox;
	AviWidgetDialog avi_dialog;

	if ((vbox=avi_save_dialog_base(avi_edit,&avi_dialog))==NULL)
		return NULL;

	/* ᥤ󥦥ɥ */
	avi_dialog.dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(avi_dialog.dialog),_("Save Options"));
	gtk_signal_connect_after(GTK_OBJECT(avi_dialog.dialog),"key-press-event",
							GTK_SIGNAL_FUNC(avi_save_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(avi_dialog.dialog),"destroy",
														gtk_main_quit,NULL);
	/* 졼 */
	gtk_window_add_accel_group(GTK_WINDOW(avi_dialog.dialog),avi_dialog.accel);

	/* ܥ */
	button0=gtk_button_new_with_label(_("OK"));
	button1=gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
					GTK_SIGNAL_FUNC(avi_save_dialog_clicked_ok),&avi_dialog);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(avi_dialog.dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);

	/* ե졼ȥܥå */
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(avi_dialog.dialog),vbox);

	/* ɽ */
	gtk_widget_grab_focus(button0);

	gtk_window_set_policy(GTK_WINDOW(avi_dialog.dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(avi_dialog.dialog);
	gtk_widget_show_all(avi_dialog.dialog);
	gtk_main();

	return avi_dialog.avi_save;
}


/* OKܥ󤬲줿 */
static void avi_save_dialog_clicked_ok_file(GtkWidget *widget,
												AviWidgetDialog *avi_dialog)
{
	const gchar *file;

	file=gtk_file_selection_get_filename(
									GTK_FILE_SELECTION(avi_dialog->dialog));
	*(gchar **)gtk_object_get_user_data(GTK_OBJECT(avi_dialog->dialog))
					=file!=NULL && file[0]!='\0' && file[g_strlen(file)-1]!='/'
														?g_strdup(file):NULL;
}


/*	¸ѤΥץ
	avi_edit,AVIԽϥɥؤΥݥ
	    file,򤷤ե
	    path,ǥեȤΥǥ쥯ȥ
	     RET,ץ,NULL:顼											*/
AviSave *avi_save_dialog_with_file(AviEdit *avi_edit[],
												gchar **file,const gchar *path)
{
	GtkWidget *hbox0,*hbox1,*vbox;
	AviWidgetDialog avi_dialog;

	if (file==NULL)
		return avi_save_dialog(avi_edit);
	if ((vbox=avi_save_dialog_base(avi_edit,&avi_dialog))==NULL)
		return NULL;

	*file=NULL;
	avi_dialog.dialog=gtk_file_selection_new(_("Save As"));
	gtk_signal_connect(GTK_OBJECT(avi_dialog.dialog),"destroy",
														gtk_main_quit,NULL);
	gtk_signal_connect(
				GTK_OBJECT(GTK_FILE_SELECTION(avi_dialog.dialog)->ok_button),
					"clicked",GTK_SIGNAL_FUNC(avi_save_dialog_clicked_ok_file),
																&avi_dialog);
	gtk_signal_connect(
				GTK_OBJECT(GTK_FILE_SELECTION(avi_dialog.dialog)->ok_button),
			"clicked",GTK_SIGNAL_FUNC(avi_save_dialog_clicked_ok),&avi_dialog);
	gtk_signal_connect_object(
			GTK_OBJECT(GTK_FILE_SELECTION(avi_dialog.dialog)->cancel_button),
								"clicked",GTK_SIGNAL_FUNC(gtk_widget_destroy),
												GTK_OBJECT(avi_dialog.dialog));
	if (path!=NULL)
		gtk_file_selection_set_filename(
								GTK_FILE_SELECTION(avi_dialog.dialog),path);
	gtk_object_set_user_data(GTK_OBJECT(avi_dialog.dialog),file);

	/* 졼 */
	gtk_window_add_accel_group(GTK_WINDOW(avi_dialog.dialog),avi_dialog.accel);

	/* ե졼ȥܥå */
#ifdef USE_GTK2
	hbox0=gtk_widget_get_parent(
							GTK_FILE_SELECTION(avi_dialog.dialog)->ok_button);
#else
	hbox0=GTK_WIDGET(GTK_FILE_SELECTION(avi_dialog.dialog)->ok_button)->parent;
#endif
	gtk_widget_ref(hbox0);
	gtk_container_remove(
		GTK_CONTAINER(GTK_FILE_SELECTION(avi_dialog.dialog)->main_vbox),hbox0);
	gtk_widget_ref(GTK_FILE_SELECTION(avi_dialog.dialog)->main_vbox);
	gtk_container_remove(GTK_CONTAINER(avi_dialog.dialog),
							GTK_FILE_SELECTION(avi_dialog.dialog)->main_vbox);

	hbox1=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox1),
				GTK_FILE_SELECTION(avi_dialog.dialog)->main_vbox,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),vbox,FALSE,FALSE,0);
	gtk_widget_show_all(vbox);

	vbox=gtk_vbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox1,TRUE,TRUE,0);
	gtk_box_pack_end(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(avi_dialog.dialog),vbox);
	gtk_widget_show(vbox);

	gtk_widget_show(hbox1);
	gtk_widget_show(avi_dialog.dialog);
	gtk_grab_add(avi_dialog.dialog);
	gtk_main();

	if (*file==NULL && avi_dialog.avi_save!=NULL) {
		avi_save_free(avi_dialog.avi_save);
		avi_dialog.avi_save=NULL;
	}
	return avi_dialog.avi_save;
}
