/*
    avicore
    copyright (c) 2002-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* Chunk                                                                       *
*                                                                             *
******************************************************************************/
#ifndef __CHUNK_H__
#define __CHUNK_H__


#include "common.h"
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif


typedef struct ChunkList_Tag {
	off_t offset;				/* եå */
	guint32 id;					/* ID */
	guint32 size;				/*  */
	guint32 form;				/* եॿ */
} ChunkList;
typedef struct Chunk_Tag {
	gint num;					/* ꥹȤο */
	ChunkList *list;
} Chunk;


/*	2ĤʸID
	 c0,1ʸ
	 c1,2ʸ
	RET,ID																	*/
#define make2cc(c0,c1)\
		(\
			(guint16)(guint8)(c0)|((guint16)(guint8)(c1)<<8)				\
		)


/*	4ĤʸID
	 c0,1ʸ
	 c1,2ʸ
	 c2,3ʸ
	 c3,4ʸ
	RET,ID																	*/
#define make4cc(c0,c1,c2,c3)\
		(\
			(guint32)(guint8)(c0)|((guint32)(guint8)(c1)<<8)				\
			|((guint32)(guint8)(c2)<<16)|((guint32)(guint8)(c3)<<24)		\
		)


#define ICTYPE_VIDEO			make4cc('v','i','d','c')
#define ICTYPE_AUDIO			make4cc('a','u','d','c')
#define FOURCC_RIFF				make4cc('R','I','F','F')
#define FOURCC_LIST				make4cc('L','I','S','T')
#define streamtypeVIDEO			make4cc('v','i','d','s')
#define streamtypeAUDIO			make4cc('a','u','d','s')
#define comptypeDIB				make4cc('D','I','B',' ')
#define formtypeAVI				make4cc('A','V','I',' ')
#define formtypeWAVE			make4cc('W','A','V','E')
#define listtypeAVIHEADER		make4cc('h','d','r','l')
#define listtypeSTREAMHEADER	make4cc('s','t','r','l')
#define listtypeAVIMOVIE		make4cc('m','o','v','i')
#define ckidAVIMAINHDR			make4cc('a','v','i','h')
#define ckidSTREAMHEADER		make4cc('s','t','r','h')
#define ckidSTREAMFORMAT		make4cc('s','t','r','f')
#define ckidSTREAMHANDLERDATA	make4cc('s','t','r','d')
#define ckidSTREAMNAME			make4cc('s','t','r','n')
#define ckidAVINEWINDEX			make4cc('i','d','x','1')
#define ckidAVIPADDING			make4cc('J','U','N','K')
#define ckidWAVEFORMAT			make4cc('f','m','t',' ')
#define ckidWAVEDATA			make4cc('d','a','t','a')


/*	եǥ꥿󥯹¤Τ
	 fd,եǥ꥿
	RET,󥯹¤,NULL:顼											*/
#define chunk_open(fd) (lseek(fd,0,SEEK_SET)!=(off_t)-1						\
												?g_malloc0(sizeof(Chunk)):NULL)


/*	󥯹¤Τ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean chunk_free(Chunk *ck);


/*	󥯤
	 fd,եǥ꥿
	 ck,󥯹¤
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean chunk_in(int fd,Chunk *ck);


/*	󥯤Ф
	 fd,եǥ꥿
	 ck,󥯹¤
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean chunk_out(int fd,Chunk *ck);


/*	Υ󥯤˰ư
	 fd,եǥ꥿
	 ck,󥯹¤
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean chunk_next(int fd,Chunk *ck);


/*	󥯤ID
	 fd,եǥ꥿
	RET,ID,-1:顼														*/
guint32 chunk_id(int fd);


/*	󥯤Υ
	 fd,եǥ꥿
	RET,,-1:顼													*/
guint32 chunk_size(int fd);


/*	󥯤Υե
	 fd,եǥ꥿
	RET,ե,-1:顼													*/
guint32 chunk_form(int fd);


#ifdef __cplusplus
}
#endif
#endif
