/*
    misc
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MISC_H__
#define __MISC_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif


#define MISC_CREATE_MENU_BAR       1
#define MISC_CREATE_MENU_SHELL     2
#define MISC_CREATE_MENU_ITEM      3
#define MISC_CREATE_MENU_SEPARATOR 4
#define MISC_CREATE_MENU_TERMINAL  0


typedef struct MiscCreateMenuEntry_Tag
{
  gchar *path;
  gchar *name;
  gchar *accel;
  guint menu_type;
  void (*func) (GtkWidget *widget, gpointer user_data);
  gpointer user_data;
  GtkWidget *widget;
} MiscCreateMenuEntry;
typedef struct MiscCreateToolbarEntry_Tag
{
  gchar *path;
  gchar *name;
  const gchar **xpm;
  void (*func) (GtkWidget *widget, gpointer user_data);
  gpointer user_data;
  GtkToolItem *tool_item;
} MiscCreateToolbarEntry;


/******************************************************************************
*                                                                             *
* ja:メッセージボックス関数群                                                 *
*                                                                             *
******************************************************************************/
/*  ja:メッセージボックスを表示する
    title,タイトル
     text,本文
      def,デフォルトのボタン
      ...,ボタンのラベル
      RET,押されたボタン(-1:キャンセル)                                     */
gint
misc_message_box (const gchar *title,
                  const gchar *text,
                  const gint   def, ...);


/******************************************************************************
*                                                                             *
* ja:メニュー/ツールバー関数群                                                *
*                                                                             *
******************************************************************************/
/*  ja:メニューを作成する
        entries,メニュー構造体
    accel_group,アクセルグループ                                            */
void
misc_create_menu (MiscCreateMenuEntry *entries,
                  GtkAccelGroup       *accel_group);


/*  ja:メニューを検索する
    entries,メニュー構造体
       path,パス
        RET,メニューアイテム                                                */
GtkWidget *
misc_find_menu (MiscCreateMenuEntry *entries,
                const gchar         *path);


/*  ja:ツールバーを作成する
    entries,ツールバー構造体
        RET,ツールバー                                                      */
GtkWidget *
misc_create_toolbar (MiscCreateToolbarEntry *entries);


/*  ja:ツールバーを検索する
    entries,ツールバー構造体
       path,パス
        RET,ツールアイテム                                                  */
GtkToolItem *
misc_find_toolbar (MiscCreateToolbarEntry *entries,
                   const gchar            *path);


/******************************************************************************
*                                                                             *
* ja:低レベル関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:スクロールバーを設定する
       scroll,スクロールウイジット
         func,シグナル関数
    func_data,データ
          min,最小値
          max,最大値
         page,ページ
          pos,位置                                                          */
void
misc_set_scroll_bar (GtkWidget     *scroll,
                     GtkSignalFunc  func,
                     gpointer       func_data,
                     const gint     min,
                     const gint     max,
                     const gint     page,
                     const gint     pos);


/*  ja:Windowの内容をスクロールする
    widget,ウイジット
        dx,X軸方向の移動
        dy,Y軸方向の移動
         x,スクロールする範囲の右上X座標
         y,スクロールする範囲の右上Y座標
     width,スクロールする範囲の幅
    height,スクロールする範囲の高さ                                         */
void
misc_scroll_window (GtkWidget  *widget,
                    const gint  dx,
                    const gint  dy,
                    const gint  x,
                    const gint  y,
                    const gint  width,
                    const gint  height);


/******************************************************************************
*                                                                             *
* ja:数値文字列関数群                                                         *
*                                                                             *
******************************************************************************/
/*  ja:数値→文字列
    value,数値
    radix,基数
     wide,桁数
     flag,TRUE:符号あり,FALSE:符号なし
      RET,文字列                                                            */
gchar *
misc_str_from_val (const gint value,
                   const gint radix,
                   const gint wide,
                   const gboolean flag);


/*  ja:文字列→数値
    value,数値
      str,文字列
    radix,基数
     flag,TRUE:符号あり,FALSE:符号なし
      RET,TRUE:正常終了,FALSE:エラー                                        */
gboolean
misc_str_to_val (gint           *value,
                 const gchar    *str,
                 const gint      radix,
                 const gboolean  flag);


/*  ja:数値→文字列
     value,数値
    divide,除算値
       RET,文字列                                                           */
gchar *
misc_str_from_float (const gint value,
                     const gint divide);


/*  ja:文字列→数値
     value,数値
    divide,除算値
      text,文字列
       RET,TRUE:正常終了,FALSE:エラー                                       */
gboolean
misc_str_to_float (gint        *value,
                   gint        *divide,
                   const gchar *text);


/*  ja:数列→文字列
    array,数列
     size,要素数
     bits,ビット数
    radix,基数
     wide,桁数
     flag,TRUE:符号あり,FALSE:符号なし
      RET,文字列                                                            */
gchar *
misc_str_from_array (const gpointer *array,
                     const gsize     size,
                     const gint      bits,
                     const gint      radix,
                     const gint      wide,
                     const gboolean  flag);


/*  ja:文字列→数列
     size,要素数
     bits,ビット数
     text,文字列
    radix,基数
     flag,TRUE:符号あり,FALSE:符号なし
      RET,数列                                                              */
gpointer
misc_str_to_array (gsize          *size,
                   const gint      bits,
                   const gchar    *text,
                   const gint      radix,
                   const gboolean  flag);


/******************************************************************************
*                                                                             *
* ja:ISO-10646                                                                *
*                                                                             *
******************************************************************************/
/*  ja:マルチバイト文字列→ワイド文字列
       src,マルチバイト文字列
    srclen,文字数(-1:NULL終了)
       dst,ワイド文字列
    dstlen,文字数
       RET,文字数                                                           */
gssize
misc_multibyte_to_widechar (const gchar  *src,
                            const gssize  srclen,
                            guint16      *dst,
                            const gssize  dstlen);


/*  ja:ワイド文字列→マルチバイト文字列
       src,ワイド文字列
    srclen,文字数(-1:NULL終了)
       dst,マルチバイト文字列
    dstlen,文字数
       RET,文字数                                                           */
gssize
misc_widechar_to_multibyte (const guint16 *src,
                            const gssize   srclen,
                            gchar         *dst,
                            const gssize   dstlen);


/*  ja:マルチバイト文字列→ワイド文字列
    src,マルチバイト文字列
    RET,ワイド文字数,NULL:エラー                                            */
guint16 *
misc_multistring_to_widestring (const gchar *src);


/*  ja:ワイド文字列→マルチバイト文字列
    src,ワイド文字列
    RET,マルチバイト文字列,NULL:エラー                                      */
gchar *
misc_widestring_to_multistring (const guint16 *src);


#ifdef __cplusplus
}
#endif
#endif
