/*
    avicore
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __AVIBASE_H__
#define __AVIBASE_H__


#include "avicore.h"
#include "icm.h"
#include "misc/fileio.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define AVI_EDIT_CACHE 20
#define AVI_PCM_SAMPLES_PER_SEC 1000


typedef struct _AviIndex
{
  goffset offset;
  guint32 size;
  guint32 flags;
} AviIndex;
typedef struct _AviFile
{
  FileIO *fio;                  /* ja:ファイルポインタ */
  gpointer *data;               /* ja:メモリ */
  gchar *name;                  /* ja:ファイル名 */
  gint start, length;           /* ja:有効な範囲 */
  gint entries;                 /* ja:インデックスの数 */
  gint param;                   /* ja:ストリーム番号 */
  AviIndex *index;              /* ja:インデックス */
  /* ja:リスト */
  struct _AviFile *prev, *next;
  /* ja:ビデオ固有 */
  guint32 handler;
  BitmapInfoHeader *bmih;       /* ja:オリジナルのフォーマット */
  /* ja:オーディオ固有 */
  WaveFormatEx *wfx;            /* ja:オリジナルのフォーマット */
} AviFile;
typedef struct _AviBuffer
{
  gpointer data;                /* ja:キャッシュ */
  /* ja:ビデオ固有 */
  gboolean raw;                 /* ja:TRUE:32ビットRAW,FALSE:ビットマップ */
  gint pos;                     /* ja:位置 */
  gint width, height;           /* ja:サイズ(RAW固有) */
} AviBuffer;
struct _AviEdit
{
  gint offset;
  AviFile *file;
  gint type;                    /* ja:AVI_TYPE_VIDEO/AVI_TYPE_AUDIO */
  gint length;                  /* ja:サンプル数 */
  guint32 rate;                 /* ja:rate÷scale=1秒間のフレーム数 */
  guint32 scale;                /* ja:rate=サンプリング周波数,scale=1 */
  guint16 priority;             /* ja:優先度 */
  guint16 language;             /* ja:言語 */
  gchar *name;                  /* ja:名前 */
  AviBuffer buf[AVI_EDIT_CACHE];/* ja:キャッシュ */
  /* ja:ビデオ固有 */
  BitmapInfoHeader *bmih;       /* ja:展開後のフォーマット */
  /* ja:オーディオ固有 */
  WaveFormatEx *wfx;            /* ja:展開後のフォーマット */
};
struct _AviOptions
{
  gint type;                    /* ja:AVI_TYPE_VIDEO/AVI_TYPE_AUDIO */
  /* ja:ビデオ固有 */
  guint32 handler;              /* ja:4文字コード */
  gint key_frame;               /* ja:周期(0:すべてキーフレーム) */
  gint quality;                 /* ja:品質0～10000,-1:デフォルト */
  gsize data_rate;              /* ja:1秒間のサイズ(0:無効) */
  gboolean recompress;          /* ja:TRUE:再圧縮する,FALSE:再圧縮なし */
  gpointer param;               /* ja:オプションデータ */
  gsize param_size;             /* ja:オプションデータのサイズ */
  BitmapInfoHeader *bmih;       /* ja:圧縮後のフォーマット */
  gsize bmih_size;              /* ja:圧縮後のフォーマットのサイズ */
  /* ja:オーディオ固有 */
  WaveFormatEx *wfx;            /* ja:圧縮後のフォーマット */
};
struct _AviSave
{
  gint type;                    /* ja:保存するファイルの種類 */
  /* ja:AVI固有 */
  AviOptions *avi_opt;          /* ja:オプション */
  /* ja:ビットマップ固有 */
  gint stream;                  /* ja:対象ストリーム */
  gint start;                   /* ja:最初のフレーム */
  gint end;                     /* ja:最後のフレーム */
};


extern const guint8 rgb2[8];
extern const guint8 rgb16[64];
extern const guint8 rgb256[1024];


/******************************************************************************
*                                                                             *
* ja:Avi基本                                                                  *
*                                                                             *
******************************************************************************/
/*  ja:AVIファイルを求める
    avi_edit,AVI編集ハンドル
         pos,サンプル番号                                                   */
void
avi_get_file (AviEdit    *avi_edit,
              const gint  pos);


/*  ja:AVIファイルを分離する
    avi_edit,AVI編集ハンドル
         pos,サンプル番号                                                   */
void
avi_split_file (AviEdit    *avi_edit,
                const gint  pos);


/******************************************************************************
*                                                                             *
* ja:AVIファイル構造体関数                                                    *
*                                                                             *
******************************************************************************/
/*  ja:AVIからAVIファイル構造体を求める
        file,ファイル名
       param,ストリーム番号
        type,streamtypeAUDIO/streamtypeVIDEO
        rate,レート
       scale,スケール
    priority,優先度
    language,言語
        name,名前
         RET,AVIファイル構造体,NULL:エラー                                  */
AviFile *
avi_open_file (const gchar  *file,
               const gint    param,
               guint32      *type,
               guint32      *rate,
               guint32      *scale,
               guint16      *priority,
               guint16      *language,
               gchar       **name);


/*  ja:AVIファイル構造体を解放する
    avi_file,AVIファイル構造体
         RET,TRUE:正常終了,FALSE:エラー                                     */
gboolean
avi_release_file (AviFile *avi_file);


/******************************************************************************
*                                                                             *
* ja:AVI入力関数                                                              *
*                                                                             *
******************************************************************************/
/*  ja:AVIのデータのバイト数を取得する
    avi_edit,AVI編集ハンドル
         pos,読み込むサンプル番号
         RET,バイト数                                                       */
gint
avi_read_video_size (AviEdit    *avi_edit,
                     const gint  pos);


/*  ja:AVIのデータを読み込む
    avi_edit,AVI編集ハンドル
         pos,読み込むサンプル番号
      buffer,データを格納するバッファ
         RET,TRUE:正常終了,FALSE:エラー                                     */
gboolean
avi_read_video (AviEdit    *avi_edit,
                const gint  pos,
                gpointer    buffer);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __AVIBASE_H__ */
