/*
    avicore
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __AVIFMT_H__
#define __AVIFMT_H__


#include "chunk.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:ファイル構造体                                                           *
*                                                                             *
******************************************************************************/
#define AVI_FILE_HASINDEX       0x00000010
#define AVI_FILE_MUSTUSEINDEX   0x00000020
#define AVI_FILE_ISINTERLEAVED  0x00000100
#define AVI_FILE_TRUSTCKTYPE    0x00000800
#define AVI_FILE_WASCAPTUREFILE 0x00010000
#define AVI_FILE_COPYRIGHTED    0x00020000
#define AVI_STREAM_DISABLED     0x00000001
#define AVI_STREAM_VIDEO        make4cc('v','i','d','s')
#define AVI_STREAM_AUDIO        make4cc('a','u','d','s')
#define AVI_STREAM_COMP_DIB     make4cc('D','I','B',' ')
#define AVI_IF_LIST             0x00000001
#define AVI_IF_KEYFRAME         0x00000010
#define AVI_IF_NOTIME           0x00000100
#define AVI_IF_COMPUSE          0x0FFF0000
#define AVI_IDX_OF_INDEXES      0x00
#define AVI_IDX_OF_CHUNKS       0x01
#define AVI_IDX_OF_TIMED_CHUNKS 0x02
#define AVI_IDX_OF_SUB_2FIELD   0x03
#define AVI_IDX_IS_DATA         0x80
#define AVI_IDX_SUB_DEFAULT     0x00
#define AVI_IDX_SUB_2FIELD      0x01

#define AMH_SIZE 56 /* en:AVI Main File Header */
#define RECT_SIZE 8 /* en:Rectangle */
#define ASH_SIZE 56 /* en:AVI Stream Header */
#define AIE_SIZE 16 /* en:AVI Index Entry */
#define ABI_SIZE 24 /* en:AVI Base Index */
#define AFI_SIZE 24 /* en:AVI Field Index */
#define ASI_SIZE 24 /* en:AVI Super Index */
#define ABE_SIZE 8  /* en:AVI Field Index Entry */
#define AFE_SIZE 12 /* en:AVI Base Index Entry */
#define ASE_SIZE 16 /* en:AVI Super Index Entry */
#define DML_SIZE 84 /* en:Extended AVI Header */


#ifdef USE_GCC


/* en:AVI Main File Header */
typedef struct _AviMainHeader
{
  guint32 micro_sec_per_frame __attribute__((packed));
  guint32 max_bytes_per_sec __attribute__((packed));
  guint32 padding_granularity __attribute__((packed));
  guint32 flags __attribute__((packed));
  guint32 total_frames __attribute__((packed));
  guint32 initial_frames __attribute__((packed));
  guint32 streams __attribute__((packed));
  guint32 suggested_buffer_size __attribute__((packed));
  guint32 width __attribute__((packed));
  guint32 height __attribute__((packed));
  guint32 reserved[4] __attribute__((packed));
} AviMainHeader;
/* en:Rectangle */
typedef struct _Rect
{
  gint16 left __attribute__((packed));
  gint16 top __attribute__((packed));
  gint16 right __attribute__((packed));
  gint16 bottom __attribute__((packed));
} Rect;
/* en:AVI Stream Header */
typedef struct _AviStreamHeader
{
  guint32 type __attribute__((packed));
  guint32 handler __attribute__((packed));
  guint32 flags __attribute__((packed));
  guint16 priority __attribute__((packed));
  guint16 language __attribute__((packed));
  guint32 initial_frames __attribute__((packed));
  guint32 scale __attribute__((packed));
  guint32 rate __attribute__((packed));
  guint32 start __attribute__((packed));
  guint32 length __attribute__((packed));
  guint32 suggested_buffer_size __attribute__((packed));
  guint32 quality __attribute__((packed));
  guint32 sample_size __attribute__((packed));
  Rect frame __attribute__((packed));
} AviStreamHeader;
/* en:AVI Index Entry */
typedef struct _AviIndexEntry
{
  guint32 ckid __attribute__((packed));
  guint32 flags __attribute__((packed));
  guint32 offset __attribute__((packed));
  guint32 length __attribute__((packed));
} AviIndexEntry;
/* en:AVI Base Index */
typedef struct _AviBaseIndex
{
  guint16 longs __attribute__((packed));
  guint8 sub_type __attribute__((packed));
  guint8 type __attribute__((packed));
  guint32 entries __attribute__((packed));
  guint32 ckid __attribute__((packed));
#ifdef G_HAVE_GINT64
  guint64 offset __attribute__((packed));
#else /* not G_HAVE_GINT64 */
  guint32 offset_low __attribute__((packed));
  guint32 offset_hi __attribute__((packed));
#endif /* not G_HAVE_GINT64 */
  guint32 reserveed __attribute__((packed));
} AviBaseIndex;
typedef AviBaseIndex AviFieldIndex;
typedef AviBaseIndex AviSuperIndex;
/* en:AVI Base Index Entry */
typedef struct _AviBaseIndexEntry
{
  guint32 offset __attribute__((packed));
  guint32 size __attribute__((packed));
} AviBaseIndexEntry;
/* en:AVI Field Index Entry */
typedef struct _AviFieldIndexEntry
{
  guint32 offset __attribute__((packed));
  guint32 size __attribute__((packed));
  guint32 field __attribute__((packed));
} AviFieldIndexEntry;
/* en:AVI Super Index Entry */
typedef struct _AviSuperIndexEntry
{
#ifdef G_HAVE_GINT64
  guint64 offset __attribute__((packed));
#else /* not G_HAVE_GINT64 */
  guint32 offset_low __attribute__((packed));
  guint32 offset_hi __attribute__((packed));
#endif /* not G_HAVE_GINT64 */
  guint32 size __attribute__((packed));
  guint32 duration __attribute__((packed));
} AviSuperIndexEntry;
typedef struct _ODMLExtendedAVIHeader
{
  guint32 total_frames __attribute__((packed));
  guint8 dummy[DML_SIZE-sizeof(guint32)] __attribute__((packed));
} ODMLExtendedAVIHeader;


#else /* not USE_GCC */


typedef struct { guint8 dummy[AMH_SIZE]; } AviMainHeader;
typedef struct { guint8 dummy[RECT_SIZE]; } Rect;
typedef struct { guint8 dummy[ASH_SIZE]; } AviStreamHeader;
typedef struct { guint8 dummy[AIE_SIZE]; } AviIndexEntry;
typedef struct { guint8 dummy[ABI_SIZE]; } AviBaseIndex;
typedef struct { guint8 dummy[AFI_SIZE]; } AviFieldIndex;
typedef struct { guint8 dummy[ASI_SIZE]; } AviSuperIndex;
typedef struct { guint8 dummy[ABE_SIZE]; } AviBaseIndexEntry;
typedef struct { guint8 dummy[AFE_SIZE]; } AviFieldIndexEntry;
typedef struct { guint8 dummy[ASE_SIZE]; } AviSuperIndexEntry;
typedef struct { guint8 dummy[DML_SIZE]; } ODMLExtendedAVIHeader;


#endif /* not USE_GCC */


/******************************************************************************
*                                                                             *
* ja:構造体マクロ                                                             *
*                                                                             *
******************************************************************************/
#define amh_get_micro_sec_per_frame(amh) GUINT32_FROM_LE(*(guint32 *)(amh))
#define amh_get_max_bytes_per_sec(amh)                                      \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+4))
#define amh_get_padding_granularity(amh)                                    \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+8))
#define amh_get_flags(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+12))
#define amh_get_total_frames(amh)                                           \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+16))
#define amh_get_initial_frames(amh)                                         \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+20))
#define amh_get_streams(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+24))
#define amh_get_suggested_buffer_size(amh)                                  \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+28))
#define amh_get_width(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+32))
#define amh_get_height(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+36))
#define amh_set_micro_sec_per_frame(amh,micro_sec_per_frame)                \
                        (*(guint32 *)(amh)=GUINT32_TO_LE(micro_sec_per_frame))
#define amh_set_max_bytes_per_sec(amh,max_bytes_per_sec)                    \
            (*(guint32 *)((guint8 *)(amh)+4)=GUINT32_TO_LE(max_bytes_per_sec))
#define amh_set_padding_granularity(amh,padding_granularity)                \
        (*(guint32 *)((guint8 *)(amh)+8)=GUINT32_TO_LE(padding_granularity))
#define amh_set_flags(amh,flags)                                            \
                        (*(guint32 *)((guint8 *)(amh)+12)=GUINT32_TO_LE(flags))
#define amh_set_total_frames(amh,total_frames)                              \
                (*(guint32 *)((guint8 *)(amh)+16)=GUINT32_TO_LE(total_frames))
#define amh_set_initial_frames(amh,initial_frames)                          \
            (*(guint32 *)((guint8 *)(amh)+20)=GUINT32_TO_LE(initial_frames))
#define amh_set_streams(amh,streams)                                        \
                    (*(guint32 *)((guint8 *)(amh)+24)=GUINT32_TO_LE(streams))
#define amh_set_suggested_buffer_size(amh,suggested_buffer_size)            \
        (*(guint32 *)((guint8 *)(amh)+28)=GUINT32_TO_LE(suggested_buffer_size))
#define amh_set_width(amh,width)                                            \
                        (*(guint32 *)((guint8 *)(amh)+32)=GUINT32_TO_LE(width))
#define amh_set_height(amh,height)                                          \
                    (*(guint32 *)((guint8 *)(amh)+36)=GUINT32_TO_LE(height))


#define ash_get_type(ash) GUINT32_FROM_LE(*(guint32 *)(ash))
#define ash_get_handler(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+4))
#define ash_get_flags(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+8))
#define ash_get_priority(ash) GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+12))
#define ash_get_language(ash) GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+14))
#define ash_get_initial_frames(ash)                                         \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+16))
#define ash_get_scale(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+20))
#define ash_get_rate(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+24))
#define ash_get_start(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+28))
#define ash_get_length(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+32))
#define ash_get_suggested_buffer_size(ash)                                  \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+36))
#define ash_get_quality(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+40))
#define ash_get_sample_size(ash)                                            \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+44))
#define ash_get_frame_left(ash)                                             \
                            GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+48))
#define ash_get_frame_top(ash)                                              \
                            GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+50))
#define ash_get_frame_right(ash)                                            \
                            GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+52))
#define ash_get_frame_bottom(ash)                                           \
                            GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+54))
#define ash_set_type(ash,type) (*(guint32 *)(ash)=GUINT32_TO_LE(type))
#define ash_set_handler(ash,handler)                                        \
                    (*(guint32 *)((guint8 *)(ash)+4)=GUINT32_TO_LE(handler))
#define ash_set_flags(ash,flags)                                            \
                        (*(guint32 *)((guint8 *)(ash)+8)=GUINT32_TO_LE(flags))
#define ash_set_priority(ash,priority)                                      \
                    (*(guint16 *)((guint8 *)(ash)+12)=GUINT16_TO_LE(priority))
#define ash_set_language(ash,language)                                      \
                    (*(guint16 *)((guint8 *)(ash)+14)=GUINT16_TO_LE(language))
#define ash_set_initial_frames(ash,initial_frames)                          \
            (*(guint32 *)((guint8 *)(ash)+16)=GUINT32_TO_LE(initial_frames))
#define ash_set_scale(ash,scale)                                            \
                        (*(guint32 *)((guint8 *)(ash)+20)=GUINT32_TO_LE(scale))
#define ash_set_rate(ash,rate)                                              \
                        (*(guint32 *)((guint8 *)(ash)+24)=GUINT32_TO_LE(rate))
#define ash_set_start(ash,start)                                            \
                        (*(guint32 *)((guint8 *)(ash)+28)=GUINT32_TO_LE(start))
#define ash_set_length(ash,length)                                          \
                    (*(guint32 *)((guint8 *)(ash)+32)=GUINT32_TO_LE(length))
#define ash_set_suggested_buffer_size(ash,suggested_buffer_size)            \
        (*(guint32 *)((guint8 *)(ash)+36)=GUINT32_TO_LE(suggested_buffer_size))
#define ash_set_quality(ash,quality)                                        \
                    (*(guint32 *)((guint8 *)(ash)+40)=GUINT32_TO_LE(quality))
#define ash_set_sample_size(ash,sample_size)                                \
                (*(guint32 *)((guint8 *)(ash)+44)=GUINT32_TO_LE(sample_size))
#define ash_set_frame_left(ash,frame_left)                                  \
                (*(guint16 *)((guint8 *)(ash)+48)=GUINT16_TO_LE(frame_left))
#define ash_set_frame_top(ash,frame_top)                                    \
                (*(guint16 *)((guint8 *)(ash)+50)=GUINT16_TO_LE(frame_top))
#define ash_set_frame_right(ash,frame_right)                                \
                (*(guint16 *)((guint8 *)(ash)+52)=GUINT16_TO_LE(frame_right))
#define ash_set_frame_bottom(ash,frame_bottom)                              \
                (*(guint16 *)((guint8 *)(ash)+54)=GUINT16_TO_LE(frame_bottom))


#define aie_get_ckid(aie) GUINT32_FROM_LE(*(guint32 *)(aie))
#define aie_get_flags(aie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(aie)+4))
#define aie_get_offset(aie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(aie)+8))
#define aie_get_length(aie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(aie)+12))

#define aie_set_type(aie,ckid) (*(guint32 *)(aie)=GUINT32_TO_LE(ckid))
#define aie_set_flags(aie,flags)                                            \
                        (*(guint32 *)((guint8 *)(aie)+4)=GUINT32_TO_LE(flags))
#define aie_set_offset(aie,offset)                                          \
                        (*(guint32 *)((guint8 *)(aie)+8)=GUINT32_TO_LE(offset))
#define aie_set_length(aie,length)                                          \
                    (*(guint32 *)((guint8 *)(aie)+12)=GUINT32_TO_LE(length))


#define abi_get_longs(abi) GUINT16_FROM_LE(*(guint16 *)(abi))
#define abi_get_sub_type(abi) *((guint8 *)(abi)+2)
#define abi_get_type(abi) *((guint8 *)(abi)+3)
#define abi_get_entries(abi) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(abi)+4))
#define abi_get_ckid(abi) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(abi)+8))
#define abi_get_offset_low(abi)                                             \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(abi)+12))
#define abi_get_offset_hi(abi)                                              \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(abi)+16))
#define abi_get_reserve(abi) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(abi)+20))
#ifdef G_HAVE_GINT64
# define abi_get_offset(abi) GUINT64_FROM_LE(*(guint64 *)((guint8 *)(abi)+12))
#endif /* G_HAVE_GINT64 */

#define abi_set_longs(abi,longs) (*(guint16 *)(abi)=GUINT16_TO_LE(longs))
#define abi_set_sub_type(abi,sub_type) (*((guint8 *)(abi)+2)=(sub_type))
#define abi_set_type(abi,type) (*((guint8 *)(abi)+3)=(type))
#define abi_set_entries(abi,entries)                                        \
                    (*(guint32 *)((guint8 *)(abi)+4)=GUINT32_TO_LE(entries))
#define abi_set_ckid(abi,ckid)                                              \
                        (*(guint32 *)((guint8 *)(abi)+8)=GUINT32_TO_LE(ckid))
#define abi_set_offset_low(abi,offset_low)                                  \
                (*(guint32 *)((guint8 *)(abi)+12)=GUINT32_TO_LE(offset_low))
#define abi_set_offset_hi(abi,offset_hi)                                    \
                    (*(guint32 *)((guint8 *)(abi)+16)=GUINT32_TO_LE(offset_hi))
#define abi_set_reserve(abi,reserve)                                        \
                    (*(guint32 *)((guint8 *)(abi)+20)=GUINT32_TO_LE(reserve))
#ifdef G_HAVE_GINT64
# define abi_set_offset(abi,offset)                                         \
                    (*(guint64 *)((guint8 *)(abi)+12)=GUINT64_TO_LE(offset))
#endif /* G_HAVE_GINT64 */


#define afi_get_longs abi_get_longs
#define afi_get_sub_type abi_get_sub_type
#define afi_get_type abi_get_type
#define afi_get_entries abi_get_entries
#define afi_get_ckid abi_get_ckid
#define afi_get_offset_low abi_get_offset_low
#define afi_get_offset_hi abi_get_offset_hi
#define afi_get_reserve abi_get_reserve
#ifdef G_HAVE_GINT64
# define afi_get_offset abi_get_offset
#endif /* G_HAVE_GINT64 */

#define afi_set_longs abi_set_longs
#define afi_set_sub_type abi_set_sub_type
#define afi_set_type abi_set_type
#define afi_set_entries abi_set_entries
#define afi_set_ckid abi_set_ckid
#define afi_set_offset_low abi_set_offset_low
#define afi_set_offset_hi abi_set_offset_hi
#define afi_set_reserve abi_set_reserve
#ifdef G_HAVE_GINT64
# define afi_set_offset abi_set_offset
#endif /* G_HAVE_GINT64 */


#define asi_get_longs abi_get_longs
#define asi_get_sub_type abi_get_sub_type
#define asi_get_type abi_get_type
#define asi_get_entries abi_get_entries
#define asi_get_ckid abi_get_ckid
#define asi_get_reserve1 abi_get_offset_low
#define asi_get_reserve2 abi_get_offset_hi
#define asi_get_reserve3 abi_get_reserve

#define asi_set_longs abi_set_longs
#define asi_set_sub_type abi_set_sub_type
#define asi_set_type abi_set_type
#define asi_set_entries abi_set_entries
#define asi_set_ckid abi_set_ckid
#define asi_set_reserve1 abi_set_offset_low
#define asi_set_reserve2 abi_set_offset_hi
#define asi_set_reserve3 abi_set_reserve


#define abe_get_offset(abe) GUINT32_FROM_LE(*(guint32 *)(abe))
#define abe_get_size(abe) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(abe)+4))

#define abe_set_offset(abe,offset) (*(guint32 *)(abe)=GUINT32_TO_LE(offset))
#define abe_set_size(abe,size)                                              \
                        (*(guint32 *)((guint8 *)(abe)+4)=GUINT32_TO_LE(size))


#define afe_get_offset(afe) GUINT32_FROM_LE(*(guint32 *)(afe))
#define afe_get_size(afe) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(afe)+4))
#define afe_get_field(afe) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(afe)+8))

#define afe_set_offset(afe,offset) (*(guint32 *)(afe)=GUINT32_TO_LE(offset))
#define afe_set_size(afe,size)                                              \
                        (*(guint32 *)((guint8 *)(afe)+4)=GUINT32_TO_LE(size))
#define afe_set_field(afe,field)                                            \
                        (*(guint32 *)((guint8 *)(afe)+8)=GUINT32_TO_LE(field))


#define ase_get_offset_low(ase) GUINT32_FROM_LE(*(guint32 *)(ase))
#define ase_get_offset_hi(ase) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ase)+4))
#define ase_get_size(ase) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ase)+8))
#define ase_get_duration(ase) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ase)+12))
#ifdef G_HAVE_GINT64
# define ase_get_offset(ase) GUINT64_FROM_LE(*(guint64 *)(ase))
#endif /* G_HAVE_GINT64 */

#define ase_set_offset_low(ase,offset_low)                                  \
                        (*(guint32 *)(ase)=GUINT32_TO_LE(offset_low))
#define ase_set_offset_hi(ase,offset_hi)                                    \
                    (*(guint32 *)((guint8 *)(ase)+4)=GUINT32_TO_LE(offset_hi))
#define ase_set_size(ase,size)                                              \
                        (*(guint32 *)((guint8 *)(ase)+8)=GUINT32_TO_LE(size))
#define ase_set_duration(ase,duration)                                      \
                    (*(guint32 *)((guint8 *)(ase)+12)=GUINT32_TO_LE(duration))
#ifdef G_HAVE_GINT64
# define ase_set_offset(ase,offset) (*(guint64 *)(ase)=GUINT64_TO_LE(offset))
#endif /* G_HAVE_GINT64 */


#define dml_get_total_frames(dml) GUINT32_FROM_LE(*(guint32 *)(dml))

#define dml_set_total_frames(dml,total_frames)                              \
                                (*(guint32 *)(dml)=GUINT32_TO_LE(total_frames))


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __AVIFMT_H__ */
