/*
    Video maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "jump.h"


/******************************************************************************
*                                                                             *
* ja:ジャンプダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
typedef struct _JumpDialog
{
  gboolean video, audio;
  gint cursor, select, max;
  guint32 rate, scale;
  GtkWidget *dialog, *check0, *check1, *spin0, *spin1;
} JumpDialog;


/* ja:スピンボタンでリターンが押された */
static void
jump_dialog_activate (GtkWidget  *widget,
                      JumpDialog *jmpdlg)
{
  gboolean video, audio;
  gint cursor, select;

  video = jmpdlg->check0
        && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (jmpdlg->check0));
  audio = jmpdlg->check1
        && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (jmpdlg->check1));
  cursor = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (jmpdlg->spin0));
  select = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (jmpdlg->spin1));
  if (0 <= cursor && cursor <= jmpdlg->max && ((!video && !audio)
                || (0 <= select && select <= jmpdlg->max && cursor != select)))
    gtk_dialog_response (GTK_DIALOG (jmpdlg->dialog), GTK_RESPONSE_OK);
}


/* ja:OKボタンの表示/非表示を判定 */
static void
jump_dialog_ok_sensitive (JumpDialog *jmpdlg)
{
  gboolean video, audio;
  gint cursor, select;

  video = jmpdlg->check0
        && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (jmpdlg->check0));
  audio = jmpdlg->check1
        && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (jmpdlg->check1));
  cursor = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (jmpdlg->spin0));
  select = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (jmpdlg->spin1));
  gtk_dialog_set_response_sensitive (GTK_DIALOG (jmpdlg->dialog),
                                                            GTK_RESPONSE_OK,
            0 <= cursor && cursor <= jmpdlg->max && ((!video && !audio)
            || (0 <= select && select <= jmpdlg->max && cursor != select)));
}


/* ja:チェックボタンが変更された */
static void
jump_dialog_toggled (GtkWidget  *widget,
                     JumpDialog *jmpdlg)
{
  gboolean sensitive;

  sensitive = (jmpdlg->check0
        && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (jmpdlg->check0)))
        || (jmpdlg->check1
        && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (jmpdlg->check1)));
  gtk_widget_set_sensitive (jmpdlg->spin1, sensitive);
  gtk_widget_set_sensitive (g_object_get_data (G_OBJECT (jmpdlg->spin1),
                                                    "user_data"), sensitive);
  jump_dialog_ok_sensitive (jmpdlg);
}


/* ja:スピンボタンが変更された */
static void
jump_dialog_changed (GtkWidget  *widget,
                     JumpDialog *jmpdlg)
{
  gchar *text;
  gint t, value;
  GtkWidget *label;

  value = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget));
  t = (glonglong)value * jmpdlg->scale * 1000 / jmpdlg->rate;
  label = g_object_get_data (G_OBJECT (widget), "user_data");
  text = g_strdup_printf ("%02d:%02d:%02d",
                                t / 60000 % 100, t / 1000 % 60, t / 10 % 100);
  gtk_label_set_text (GTK_LABEL (label), text);
  g_free (text);
  jump_dialog_ok_sensitive (jmpdlg);
}


/*  ja:ジャンプダイアログ表示
    jmpcfg,ジャンプ構造体
       RET.TRUE:OK,FALSE:Cancel                                             */
gboolean
jump_dialog (JumpConfig *jmpcfg)
{
  gboolean result;
  gchar *text, *title;
  gint t;
  GtkStockItem stock_item;
  GtkWidget *label0, *label1, *vbox0, *vbox1, *frame;
  JumpDialog jmpdlg;

  jmpdlg.max = jmpcfg->max;
  jmpdlg.rate = jmpcfg->rate;
  jmpdlg.scale = jmpcfg->scale;
  /* ja:メインウインドウ */
  gtk_stock_lookup (GTK_STOCK_JUMP_TO, &stock_item);
  title = misc_mnemonic_to_text (stock_item.label);
  jmpdlg.dialog = gtk_dialog_new_with_buttons
                            (title,
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            NULL);
  g_free (title);
  g_signal_connect (G_OBJECT (jmpdlg.dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:チェックボタン */
  if (jmpcfg->video)
    {
      jmpdlg.check0 = gtk_check_button_new_with_mnemonic (_("_Video"));
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (jmpdlg.check0),
                jmpcfg->select.stream >= 0
                && (jmpcfg->cursor.stream == 0 || jmpcfg->select.stream == 0));
      g_signal_connect (G_OBJECT (jmpdlg.check0), "toggled",
                                    G_CALLBACK (jump_dialog_toggled), &jmpdlg);
    }
  else
    {
      jmpdlg.check0 = NULL;
    }
  if (jmpcfg->audio)
    {
      jmpdlg.check1 = gtk_check_button_new_with_mnemonic (_("_Audio"));
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (jmpdlg.check1),
                jmpcfg->select.stream >= 0
                && (jmpcfg->cursor.stream == 1 || jmpcfg->select.stream == 1));
      g_signal_connect (G_OBJECT (jmpdlg.check1), "toggled",
                                    G_CALLBACK (jump_dialog_toggled), &jmpdlg);
    }
  else
    {
      jmpdlg.check1 = NULL;
    }
  /* ja:ラベル */
  label0 = gtk_label_new (NULL);
  label1 = gtk_label_new (NULL);
  t = (glonglong)jmpcfg->cursor.frame * jmpcfg->scale * 1000 / jmpcfg->rate;
  text = g_strdup_printf ("%02d:%02d:%02d",
                                t / 60000 % 100, t / 1000 % 60, t / 10 % 100);
  gtk_label_set_text (GTK_LABEL (label0), text);
  g_free (text);
  t = (glonglong)(jmpcfg->select.stream >= 0
                                ? jmpcfg->select.frame : jmpcfg->cursor.frame)
                                        * jmpcfg->scale * 1000 / jmpcfg->rate;
  text = g_strdup_printf ("%02d:%02d:%02d",
                                t / 60000 % 100, t / 1000 % 60, t / 10 % 100);
  gtk_label_set_text (GTK_LABEL (label1), text);
  g_free (text);
  /* ja:スピンボタン */
  jmpdlg.spin0 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                        (jmpcfg->cursor.frame, 0, jmpdlg.max, 1, 5, 0)), 0, 0);
  jmpdlg.spin1 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
    (jmpcfg->select.stream >= 0 ? jmpcfg->select.frame : jmpcfg->cursor.frame,
                                            0, jmpdlg.max, 1, 5, 0)), 0, 0);
  g_object_set_data (G_OBJECT (jmpdlg.spin0), "user_data", label0);
  g_object_set_data (G_OBJECT (jmpdlg.spin1), "user_data", label1);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (jmpdlg.spin0), TRUE);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (jmpdlg.spin1), TRUE);
  g_signal_connect (G_OBJECT (jmpdlg.spin0), "activate",
                                G_CALLBACK (jump_dialog_activate), &jmpdlg);
  g_signal_connect (G_OBJECT (jmpdlg.spin1), "activate",
                                G_CALLBACK (jump_dialog_activate), &jmpdlg);
  g_signal_connect (G_OBJECT (jmpdlg.spin0), "changed",
                                G_CALLBACK (jump_dialog_changed), &jmpdlg);
  g_signal_connect (G_OBJECT (jmpdlg.spin1), "changed",
                                G_CALLBACK (jump_dialog_changed), &jmpdlg);
  /* ja:フレームとボックス */
  vbox0 = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox0), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox0), jmpdlg.spin0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox0), label0, TRUE, TRUE, 0);
  frame = gtk_frame_new (_("Select"));
  vbox1 = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox1), jmpdlg.spin1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, TRUE, TRUE, 0);
  if (jmpdlg.check0 && jmpdlg.check1)
    {
      GtkWidget *hbox;

      hbox = gtk_hbox_new (FALSE, SPACING);
      gtk_box_pack_start (GTK_BOX (hbox), jmpdlg.check0, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), jmpdlg.check1, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    }
  else
    {
      if (jmpdlg.check0)
        gtk_box_pack_start (GTK_BOX (vbox1), jmpdlg.check0, TRUE, TRUE, 0);
      if (jmpdlg.check1)
        gtk_box_pack_start (GTK_BOX (vbox1), jmpdlg.check1, TRUE, TRUE, 0);
    }
  gtk_container_add (GTK_CONTAINER (frame), vbox1);
  gtk_box_pack_start (GTK_BOX (vbox0), frame, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (jmpdlg.dialog)->vbox), vbox0);

  /* ja:表示 */
  if (jmpcfg->select.stream < 0)
    {
      gtk_widget_set_sensitive (jmpdlg.spin1, FALSE);
      gtk_widget_set_sensitive (label1, FALSE);
    }
  gtk_dialog_set_response_sensitive (GTK_DIALOG (jmpdlg.dialog),
                                                    GTK_RESPONSE_OK, FALSE);
  gtk_widget_grab_focus (jmpdlg.spin0);
  gtk_widget_show_all (vbox0);

  result = gtk_dialog_run (GTK_DIALOG (jmpdlg.dialog)) == GTK_RESPONSE_OK;
  if (result)
    {
      gboolean video, audio;
      gint cursor, select;

      video = jmpdlg.check0
        && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (jmpdlg.check0));
      audio = jmpdlg.check1
        && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (jmpdlg.check1));
      cursor = gtk_spin_button_get_value_as_int
                                            (GTK_SPIN_BUTTON (jmpdlg.spin0));
      select = gtk_spin_button_get_value_as_int
                                            (GTK_SPIN_BUTTON (jmpdlg.spin1));
      if (video || audio)
        {
          jmpcfg->cursor.frame = cursor;
          jmpcfg->select.frame = select;
          if (video && audio)
            {
              if (cursor < select)
                {
                  jmpcfg->cursor.stream = 0;
                  jmpcfg->select.stream = 1;
                }
              else
                {
                  jmpcfg->cursor.stream = 1;
                  jmpcfg->select.stream = 0;
                }
            }
          else if (video)
            {
              jmpcfg->cursor.stream = jmpcfg->select.stream = 0;
            }
          else
            {
              jmpcfg->cursor.stream = jmpcfg->select.stream = 1;
            }
        }
      else
        {
          jmpcfg->cursor.frame = cursor;
          jmpcfg->select.stream = -1;
        }
    }
  gtk_widget_destroy (jmpdlg.dialog);

  return result;
}
