/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "advapi32.h"
#include "kernel32.h"
#include "misc/fileio.h"
#include "misc/misc.h"
#include "misc/profile.h"


#ifdef W32LDR_HEADER
/* ja:レジストリ */
#define ERROR_SUCCESS       0
#define ERROR_NO_MORE_ITEMS 259
#define ERROR_UNKNOWN       99999
#define HKEY_CLASSES_ROOT     (GUINT_TO_POINTER(0x80000000))
#define HKEY_CURRENT_USER     (GUINT_TO_POINTER(0x80000001))
#define HKEY_LOCAL_MACHINE    (GUINT_TO_POINTER(0x80000002))
#define HKEY_USERS            (GUINT_TO_POINTER(0x80000003))
#define HKEY_PERFORMANCE_DATA (GUINT_TO_POINTER(0x80000004))
#define HKEY_CURRENT_CONFIG   (GUINT_TO_POINTER(0x80000005))
#define HKEY_DYN_DATA         (GUINT_TO_POINTER(0x80000006))
#define KEY_QUERY_VALUE        0x00000001
#define KEY_SET_VALUE          0x00000002
#define KEY_CREATE_SUB_KEY     0x00000004
#define KEY_ENUMERATE_SUB_KEYS 0x00000008
#define KEY_NOTIFY             0x00000010
#define KEY_CREATE_LINK        0x00000020
#define KEY_EXECUTE            (KEY_QUERY_VALUE|KEY_ENUMERATE_SUB_KEYS)
#define KEY_READ               (KEY_EXECUTE|KEY_NOTIFY)
#define KEY_WRITE              (KEY_CREATE_SUB_KEY|KEY_SET_VALUE)
#define KEY_ALL_ACCESS         (KEY_CREATE_LINK|KEY_READ|KEY_WRITE)
#define REG_OPTION_NON_VOLATILE 0x00000000
#define REG_OPTION_VOLATILE     0x00000001
#define REG_NONE                0
#define REG_SZ                  1
#define REG_EXPAND_SZ           2
#define REG_BINARY              3
#define REG_DWORD_LITTLE_ENDIAN 4
#define REG_DWORD_BIG_ENDIAN    5
#if G_BYTE_ORDER == G_LITTLE_ENDIAN
# define REG_DWORD              REG_DWORD_LITTLE_ENDIAN
#else /* not G_BYTE_ORDER == G_LITTLE_ENDIAN */
# define REG_DWORD              REG_DWORD_BIG_ENDIAN
#endif /* not G_BYTE_ORDER == G_LITTLE_ENDIAN */
#define REG_LINK                6
#define REG_MULTI_SZ            7
typedef gchar *HKEY, **PHKEY, **LPHKEY;
typedef DWORD REGSAM;
#endif /* W32LDR_HEADER */


/* AbortSystemShutdownA ordinal = 4, argument = 4 temporary */
static DWORD WINAPI AbortSystemShutdownA (DWORD dwArgv0)
{
  return 0;
}


/* AbortSystemShutdownW ordinal = 5, argument = 4 temporary */
static DWORD WINAPI AbortSystemShutdownW (DWORD dwArgv0)
{
  return 0;
}


/* AccessCheck ordinal = 6, argument = 32 temporary */
static DWORD WINAPI AccessCheck (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* AccessCheckAndAuditAlarmA ordinal = 7, argument = 44 temporary */
static DWORD WINAPI AccessCheckAndAuditAlarmA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* AccessCheckAndAuditAlarmW ordinal = 8, argument = 44 temporary */
static DWORD WINAPI AccessCheckAndAuditAlarmW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* AccessCheckByType ordinal = 9, argument = 44 temporary */
static DWORD WINAPI AccessCheckByType (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* AccessCheckByTypeAndAuditAlarmA ordinal = 10, argument = 64 temporary */
static DWORD WINAPI AccessCheckByTypeAndAuditAlarmA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11, DWORD dwArgv12, DWORD dwArgv13, DWORD dwArgv14, DWORD dwArgv15)
{
  return 0;
}


/* AccessCheckByTypeAndAuditAlarmW ordinal = 11, argument = 64 temporary */
static DWORD WINAPI AccessCheckByTypeAndAuditAlarmW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11, DWORD dwArgv12, DWORD dwArgv13, DWORD dwArgv14, DWORD dwArgv15)
{
  return 0;
}


/* AccessCheckByTypeResultList ordinal = 12, argument = 44 temporary */
static DWORD WINAPI AccessCheckByTypeResultList (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* AccessCheckByTypeResultListAndAuditAlarmA ordinal = 13, argument = 64 temporary */
static DWORD WINAPI AccessCheckByTypeResultListAndAuditAlarmA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11, DWORD dwArgv12, DWORD dwArgv13, DWORD dwArgv14, DWORD dwArgv15)
{
  return 0;
}


/* AccessCheckByTypeResultListAndAuditAlarmByHandleA ordinal = 14, argument = 68 temporary */
static DWORD WINAPI AccessCheckByTypeResultListAndAuditAlarmByHandleA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11, DWORD dwArgv12, DWORD dwArgv13, DWORD dwArgv14, DWORD dwArgv15, DWORD dwArgv16)
{
  return 0;
}


/* AccessCheckByTypeResultListAndAuditAlarmByHandleW ordinal = 15, argument = 68 temporary */
static DWORD WINAPI AccessCheckByTypeResultListAndAuditAlarmByHandleW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11, DWORD dwArgv12, DWORD dwArgv13, DWORD dwArgv14, DWORD dwArgv15, DWORD dwArgv16)
{
  return 0;
}


/* AccessCheckByTypeResultListAndAuditAlarmW ordinal = 16, argument = 64 temporary */
static DWORD WINAPI AccessCheckByTypeResultListAndAuditAlarmW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11, DWORD dwArgv12, DWORD dwArgv13, DWORD dwArgv14, DWORD dwArgv15)
{
  return 0;
}


/* AddAccessAllowedAce ordinal = 17, argument = 16 temporary */
static DWORD WINAPI AddAccessAllowedAce (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* AddAccessAllowedAceEx ordinal = 18, argument = 20 temporary */
static DWORD WINAPI AddAccessAllowedAceEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* AddAccessAllowedObjectAce ordinal = 19, argument = 28 temporary */
static DWORD WINAPI AddAccessAllowedObjectAce (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* AddAccessDeniedAce ordinal = 20, argument = 16 temporary */
static DWORD WINAPI AddAccessDeniedAce (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* AddAccessDeniedAceEx ordinal = 21, argument = 20 temporary */
static DWORD WINAPI AddAccessDeniedAceEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* AddAccessDeniedObjectAce ordinal = 22, argument = 28 temporary */
static DWORD WINAPI AddAccessDeniedObjectAce (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* AddAce ordinal = 23, argument = 20 temporary */
static DWORD WINAPI AddAce (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* AddAuditAccessAce ordinal = 24, argument = 24 temporary */
static DWORD WINAPI AddAuditAccessAce (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* AddAuditAccessAceEx ordinal = 25, argument = 28 temporary */
static DWORD WINAPI AddAuditAccessAceEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* AddAuditAccessObjectAce ordinal = 26, argument = 36 temporary */
static DWORD WINAPI AddAuditAccessObjectAce (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* AddUsersToEncryptedFile ordinal = 27, argument = 8 temporary */
static DWORD WINAPI AddUsersToEncryptedFile (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* AdjustTokenGroups ordinal = 28, argument = 24 temporary */
static DWORD WINAPI AdjustTokenGroups (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* AdjustTokenPrivileges ordinal = 29, argument = 24 temporary */
static DWORD WINAPI AdjustTokenPrivileges (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* AllocateAndInitializeSid ordinal = 30, argument = 44 temporary */
static DWORD WINAPI AllocateAndInitializeSid (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* AllocateLocallyUniqueId ordinal = 31, argument = 4 temporary */
static DWORD WINAPI AllocateLocallyUniqueId (DWORD dwArgv0)
{
  return 0;
}


/* AreAllAccessesGranted ordinal = 32, argument = 8 temporary */
static DWORD WINAPI AreAllAccessesGranted (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* AreAnyAccessesGranted ordinal = 33, argument = 8 temporary */
static DWORD WINAPI AreAnyAccessesGranted (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BackupEventLogA ordinal = 34, argument = 8 temporary */
static DWORD WINAPI BackupEventLogA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BackupEventLogW ordinal = 35, argument = 8 temporary */
static DWORD WINAPI BackupEventLogW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BuildExplicitAccessWithNameA ordinal = 36, argument = 20 temporary */
static DWORD WINAPI BuildExplicitAccessWithNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* BuildExplicitAccessWithNameW ordinal = 37, argument = 20 temporary */
static DWORD WINAPI BuildExplicitAccessWithNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* BuildImpersonateExplicitAccessWithNameA ordinal = 38, argument = 24 temporary */
static DWORD WINAPI BuildImpersonateExplicitAccessWithNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* BuildImpersonateExplicitAccessWithNameW ordinal = 39, argument = 24 temporary */
static DWORD WINAPI BuildImpersonateExplicitAccessWithNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* BuildImpersonateTrusteeA ordinal = 40, argument = 8 temporary */
static DWORD WINAPI BuildImpersonateTrusteeA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BuildImpersonateTrusteeW ordinal = 41, argument = 8 temporary */
static DWORD WINAPI BuildImpersonateTrusteeW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BuildSecurityDescriptorA ordinal = 42, argument = 36 temporary */
static DWORD WINAPI BuildSecurityDescriptorA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* BuildSecurityDescriptorW ordinal = 43, argument = 36 temporary */
static DWORD WINAPI BuildSecurityDescriptorW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* BuildTrusteeWithNameA ordinal = 44, argument = 8 temporary */
static DWORD WINAPI BuildTrusteeWithNameA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BuildTrusteeWithNameW ordinal = 45, argument = 8 temporary */
static DWORD WINAPI BuildTrusteeWithNameW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BuildTrusteeWithObjectsAndNameA ordinal = 46, argument = 24 temporary */
static DWORD WINAPI BuildTrusteeWithObjectsAndNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* BuildTrusteeWithObjectsAndNameW ordinal = 47, argument = 24 temporary */
static DWORD WINAPI BuildTrusteeWithObjectsAndNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* BuildTrusteeWithObjectsAndSidA ordinal = 48, argument = 20 temporary */
static DWORD WINAPI BuildTrusteeWithObjectsAndSidA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* BuildTrusteeWithObjectsAndSidW ordinal = 49, argument = 20 temporary */
static DWORD WINAPI BuildTrusteeWithObjectsAndSidW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* BuildTrusteeWithSidA ordinal = 50, argument = 8 temporary */
static DWORD WINAPI BuildTrusteeWithSidA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BuildTrusteeWithSidW ordinal = 51, argument = 8 temporary */
static DWORD WINAPI BuildTrusteeWithSidW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CancelOverlappedAccess ordinal = 52, argument = 4 temporary */
static DWORD WINAPI CancelOverlappedAccess (DWORD dwArgv0)
{
  return 0;
}


/* ChangeServiceConfig2A ordinal = 53, argument = 12 temporary */
static DWORD WINAPI ChangeServiceConfig2A (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ChangeServiceConfig2W ordinal = 54, argument = 12 temporary */
static DWORD WINAPI ChangeServiceConfig2W (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ChangeServiceConfigA ordinal = 55, argument = 44 temporary */
static DWORD WINAPI ChangeServiceConfigA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* ChangeServiceConfigW ordinal = 56, argument = 44 temporary */
static DWORD WINAPI ChangeServiceConfigW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* CheckTokenMembership ordinal = 57, argument = 12 temporary */
static DWORD WINAPI CheckTokenMembership (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ClearEventLogA ordinal = 58, argument = 8 temporary */
static DWORD WINAPI ClearEventLogA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ClearEventLogW ordinal = 59, argument = 8 temporary */
static DWORD WINAPI ClearEventLogW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CloseEncryptedFileRaw ordinal = 60, argument = 4 temporary */
static DWORD WINAPI CloseEncryptedFileRaw (DWORD dwArgv0)
{
  return 0;
}


/* CloseEventLog ordinal = 61, argument = 4 temporary */
static DWORD WINAPI CloseEventLog (DWORD dwArgv0)
{
  return 0;
}


/* CloseServiceHandle ordinal = 62, argument = 4 temporary */
static DWORD WINAPI CloseServiceHandle (DWORD dwArgv0)
{
  return 0;
}


/* CloseTrace ordinal = 63, argument = 8 temporary */
static DWORD WINAPI CloseTrace (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CommandLineFromMsiDescriptor ordinal = 64, argument = 12 temporary */
static DWORD WINAPI CommandLineFromMsiDescriptor (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ControlService ordinal = 65, argument = 12 temporary */
static DWORD WINAPI ControlService (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ControlTraceA ordinal = 66, argument = 20 temporary */
static DWORD WINAPI ControlTraceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ControlTraceW ordinal = 67, argument = 20 temporary */
static DWORD WINAPI ControlTraceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ConvertAccessToSecurityDescriptorA ordinal = 68, argument = 20 temporary */
static DWORD WINAPI ConvertAccessToSecurityDescriptorA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ConvertAccessToSecurityDescriptorW ordinal = 69, argument = 20 temporary */
static DWORD WINAPI ConvertAccessToSecurityDescriptorW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ConvertSDToStringSDRootDomainA ordinal = 70, argument = 24 temporary */
static DWORD WINAPI ConvertSDToStringSDRootDomainA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ConvertSDToStringSDRootDomainW ordinal = 71, argument = 24 temporary */
static DWORD WINAPI ConvertSDToStringSDRootDomainW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ConvertSecurityDescriptorToAccessA ordinal = 72, argument = 28 temporary */
static DWORD WINAPI ConvertSecurityDescriptorToAccessA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* ConvertSecurityDescriptorToAccessNamedA ordinal = 73, argument = 28 temporary */
static DWORD WINAPI ConvertSecurityDescriptorToAccessNamedA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* ConvertSecurityDescriptorToAccessNamedW ordinal = 74, argument = 28 temporary */
static DWORD WINAPI ConvertSecurityDescriptorToAccessNamedW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* ConvertSecurityDescriptorToAccessW ordinal = 75, argument = 28 temporary */
static DWORD WINAPI ConvertSecurityDescriptorToAccessW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* ConvertSecurityDescriptorToStringSecurityDescriptorA ordinal = 76, argument = 20 temporary */
static DWORD WINAPI ConvertSecurityDescriptorToStringSecurityDescriptorA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ConvertSecurityDescriptorToStringSecurityDescriptorW ordinal = 77, argument = 20 temporary */
static DWORD WINAPI ConvertSecurityDescriptorToStringSecurityDescriptorW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ConvertSidToStringSidA ordinal = 78, argument = 8 temporary */
static DWORD WINAPI ConvertSidToStringSidA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ConvertSidToStringSidW ordinal = 79, argument = 8 temporary */
static DWORD WINAPI ConvertSidToStringSidW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ConvertStringSDToSDRootDomainA ordinal = 80, argument = 20 temporary */
static DWORD WINAPI ConvertStringSDToSDRootDomainA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ConvertStringSDToSDRootDomainW ordinal = 81, argument = 20 temporary */
static DWORD WINAPI ConvertStringSDToSDRootDomainW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ConvertStringSecurityDescriptorToSecurityDescriptorA ordinal = 82, argument = 16 temporary */
static DWORD WINAPI ConvertStringSecurityDescriptorToSecurityDescriptorA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ConvertStringSecurityDescriptorToSecurityDescriptorW ordinal = 83, argument = 16 temporary */
static DWORD WINAPI ConvertStringSecurityDescriptorToSecurityDescriptorW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ConvertStringSidToSidA ordinal = 84, argument = 8 temporary */
static DWORD WINAPI ConvertStringSidToSidA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ConvertStringSidToSidW ordinal = 85, argument = 8 temporary */
static DWORD WINAPI ConvertStringSidToSidW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ConvertToAutoInheritPrivateObjectSecurity ordinal = 86, argument = 24 temporary */
static DWORD WINAPI ConvertToAutoInheritPrivateObjectSecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CopySid ordinal = 87, argument = 12 temporary */
static DWORD WINAPI CopySid (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreatePrivateObjectSecurity ordinal = 88, argument = 24 temporary */
static DWORD WINAPI CreatePrivateObjectSecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CreatePrivateObjectSecurityEx ordinal = 89, argument = 32 temporary */
static DWORD WINAPI CreatePrivateObjectSecurityEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* CreateProcessAsUserA ordinal = 90, argument = 44 temporary */
static DWORD WINAPI CreateProcessAsUserA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* CreateProcessAsUserSecure ordinal = 91, argument = 0 temporary */
static DWORD WINAPI CreateProcessAsUserSecure (VOID)
{
  return 0;
}


/* CreateProcessAsUserW ordinal = 92, argument = 44 temporary */
static DWORD WINAPI CreateProcessAsUserW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* CreateProcessWithLogonW ordinal = 93, argument = 44 temporary */
static DWORD WINAPI CreateProcessWithLogonW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* CreateRestrictedToken ordinal = 94, argument = 36 temporary */
static DWORD WINAPI CreateRestrictedToken (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* CreateServiceA ordinal = 95, argument = 52 temporary */
static DWORD WINAPI CreateServiceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11, DWORD dwArgv12)
{
  return 0;
}


/* CreateServiceW ordinal = 96, argument = 52 temporary */
static DWORD WINAPI CreateServiceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11, DWORD dwArgv12)
{
  return 0;
}


/* CreateTraceInstanceId ordinal = 97, argument = 8 temporary */
static DWORD WINAPI CreateTraceInstanceId (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateWellKnownSid ordinal = 98, argument = 16 temporary */
static DWORD WINAPI CreateWellKnownSid (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CryptAcquireContextA ordinal = 99, argument = 20 temporary */
static DWORD WINAPI CryptAcquireContextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CryptAcquireContextW ordinal = 100, argument = 20 temporary */
static DWORD WINAPI CryptAcquireContextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CryptContextAddRef ordinal = 101, argument = 12 temporary */
static DWORD WINAPI CryptContextAddRef (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CryptCreateHash ordinal = 102, argument = 20 temporary */
static DWORD WINAPI CryptCreateHash (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CryptDecrypt ordinal = 103, argument = 24 temporary */
static DWORD WINAPI CryptDecrypt (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CryptDeriveKey ordinal = 104, argument = 20 temporary */
static DWORD WINAPI CryptDeriveKey (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CryptDestroyHash ordinal = 105, argument = 4 temporary */
static DWORD WINAPI CryptDestroyHash (DWORD dwArgv0)
{
  return 0;
}


/* CryptDestroyKey ordinal = 106, argument = 4 temporary */
static DWORD WINAPI CryptDestroyKey (DWORD dwArgv0)
{
  return 0;
}


/* CryptDuplicateHash ordinal = 107, argument = 16 temporary */
static DWORD WINAPI CryptDuplicateHash (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CryptDuplicateKey ordinal = 108, argument = 16 temporary */
static DWORD WINAPI CryptDuplicateKey (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CryptEncrypt ordinal = 109, argument = 28 temporary */
static DWORD WINAPI CryptEncrypt (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CryptEnumProviderTypesA ordinal = 110, argument = 24 temporary */
static DWORD WINAPI CryptEnumProviderTypesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CryptEnumProviderTypesW ordinal = 111, argument = 24 temporary */
static DWORD WINAPI CryptEnumProviderTypesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CryptEnumProvidersA ordinal = 112, argument = 24 temporary */
static DWORD WINAPI CryptEnumProvidersA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CryptEnumProvidersW ordinal = 113, argument = 24 temporary */
static DWORD WINAPI CryptEnumProvidersW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CryptExportKey ordinal = 114, argument = 24 temporary */
static DWORD WINAPI CryptExportKey (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CryptGenKey ordinal = 115, argument = 16 temporary */
static DWORD WINAPI CryptGenKey (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CryptGenRandom ordinal = 116, argument = 12 temporary */
static DWORD WINAPI CryptGenRandom (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CryptGetDefaultProviderA ordinal = 117, argument = 20 temporary */
static DWORD WINAPI CryptGetDefaultProviderA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CryptGetDefaultProviderW ordinal = 118, argument = 20 temporary */
static DWORD WINAPI CryptGetDefaultProviderW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CryptGetHashParam ordinal = 119, argument = 20 temporary */
static DWORD WINAPI CryptGetHashParam (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CryptGetKeyParam ordinal = 120, argument = 20 temporary */
static DWORD WINAPI CryptGetKeyParam (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CryptGetProvParam ordinal = 121, argument = 20 temporary */
static DWORD WINAPI CryptGetProvParam (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CryptGetUserKey ordinal = 122, argument = 12 temporary */
static DWORD WINAPI CryptGetUserKey (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CryptHashData ordinal = 123, argument = 16 temporary */
static DWORD WINAPI CryptHashData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CryptHashSessionKey ordinal = 124, argument = 12 temporary */
static DWORD WINAPI CryptHashSessionKey (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CryptImportKey ordinal = 125, argument = 24 temporary */
static DWORD WINAPI CryptImportKey (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CryptReleaseContext ordinal = 126, argument = 8 temporary */
static DWORD WINAPI CryptReleaseContext (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CryptSetHashParam ordinal = 127, argument = 16 temporary */
static DWORD WINAPI CryptSetHashParam (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CryptSetKeyParam ordinal = 128, argument = 16 temporary */
static DWORD WINAPI CryptSetKeyParam (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CryptSetProvParam ordinal = 129, argument = 16 temporary */
static DWORD WINAPI CryptSetProvParam (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CryptSetProviderA ordinal = 130, argument = 8 temporary */
static DWORD WINAPI CryptSetProviderA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CryptSetProviderExA ordinal = 131, argument = 16 temporary */
static DWORD WINAPI CryptSetProviderExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CryptSetProviderExW ordinal = 132, argument = 16 temporary */
static DWORD WINAPI CryptSetProviderExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CryptSetProviderW ordinal = 133, argument = 8 temporary */
static DWORD WINAPI CryptSetProviderW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CryptSignHashA ordinal = 134, argument = 24 temporary */
static DWORD WINAPI CryptSignHashA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CryptSignHashW ordinal = 135, argument = 24 temporary */
static DWORD WINAPI CryptSignHashW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CryptVerifySignatureA ordinal = 136, argument = 24 temporary */
static DWORD WINAPI CryptVerifySignatureA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CryptVerifySignatureW ordinal = 137, argument = 24 temporary */
static DWORD WINAPI CryptVerifySignatureW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* DecryptFileA ordinal = 138, argument = 8 temporary */
static DWORD WINAPI DecryptFileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DecryptFileW ordinal = 139, argument = 8 temporary */
static DWORD WINAPI DecryptFileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DeleteAce ordinal = 140, argument = 8 temporary */
static DWORD WINAPI DeleteAce (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DeleteService ordinal = 141, argument = 4 temporary */
static DWORD WINAPI DeleteService (DWORD dwArgv0)
{
  return 0;
}


/* DeregisterEventSource ordinal = 142, argument = 4 temporary */
static DWORD WINAPI DeregisterEventSource (DWORD dwArgv0)
{
  return 0;
}


/* DestroyPrivateObjectSecurity ordinal = 143, argument = 4 temporary */
static DWORD WINAPI DestroyPrivateObjectSecurity (DWORD dwArgv0)
{
  return 0;
}


/* DuplicateEncryptionInfoFile ordinal = 144, argument = 20 temporary */
static DWORD WINAPI DuplicateEncryptionInfoFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DuplicateToken ordinal = 145, argument = 12 temporary */
static DWORD WINAPI DuplicateToken (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DuplicateTokenEx ordinal = 146, argument = 24 temporary */
static DWORD WINAPI DuplicateTokenEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ElfBackupEventLogFileA ordinal = 147, argument = 8 temporary */
static DWORD WINAPI ElfBackupEventLogFileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ElfBackupEventLogFileW ordinal = 148, argument = 8 temporary */
static DWORD WINAPI ElfBackupEventLogFileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ElfChangeNotify ordinal = 149, argument = 8 temporary */
static DWORD WINAPI ElfChangeNotify (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ElfClearEventLogFileA ordinal = 150, argument = 8 temporary */
static DWORD WINAPI ElfClearEventLogFileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ElfClearEventLogFileW ordinal = 151, argument = 8 temporary */
static DWORD WINAPI ElfClearEventLogFileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ElfCloseEventLog ordinal = 152, argument = 4 temporary */
static DWORD WINAPI ElfCloseEventLog (DWORD dwArgv0)
{
  return 0;
}


/* ElfDeregisterEventSource ordinal = 153, argument = 4 temporary */
static DWORD WINAPI ElfDeregisterEventSource (DWORD dwArgv0)
{
  return 0;
}


/* ElfFlushEventLog ordinal = 154, argument = 4 temporary */
static DWORD WINAPI ElfFlushEventLog (DWORD dwArgv0)
{
  return 0;
}


/* ElfNumberOfRecords ordinal = 155, argument = 8 temporary */
static DWORD WINAPI ElfNumberOfRecords (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ElfOldestRecord ordinal = 156, argument = 8 temporary */
static DWORD WINAPI ElfOldestRecord (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ElfOpenBackupEventLogA ordinal = 157, argument = 12 temporary */
static DWORD WINAPI ElfOpenBackupEventLogA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ElfOpenBackupEventLogW ordinal = 158, argument = 12 temporary */
static DWORD WINAPI ElfOpenBackupEventLogW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ElfOpenEventLogA ordinal = 159, argument = 12 temporary */
static DWORD WINAPI ElfOpenEventLogA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ElfOpenEventLogW ordinal = 160, argument = 12 temporary */
static DWORD WINAPI ElfOpenEventLogW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ElfReadEventLogA ordinal = 161, argument = 28 temporary */
static DWORD WINAPI ElfReadEventLogA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* ElfReadEventLogW ordinal = 162, argument = 28 temporary */
static DWORD WINAPI ElfReadEventLogW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* ElfRegisterEventSourceA ordinal = 163, argument = 12 temporary */
static DWORD WINAPI ElfRegisterEventSourceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ElfRegisterEventSourceW ordinal = 164, argument = 12 temporary */
static DWORD WINAPI ElfRegisterEventSourceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ElfReportEventA ordinal = 165, argument = 48 temporary */
static DWORD WINAPI ElfReportEventA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* ElfReportEventW ordinal = 166, argument = 48 temporary */
static DWORD WINAPI ElfReportEventW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* EnableTrace ordinal = 167, argument = 24 temporary */
static DWORD WINAPI EnableTrace (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* EncryptFileA ordinal = 168, argument = 4 temporary */
static DWORD WINAPI EncryptFileA (DWORD dwArgv0)
{
  return 0;
}


/* EncryptFileW ordinal = 169, argument = 4 temporary */
static DWORD WINAPI EncryptFileW (DWORD dwArgv0)
{
  return 0;
}


/* EncryptionDisable ordinal = 170, argument = 8 temporary */
static DWORD WINAPI EncryptionDisable (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumDependentServicesA ordinal = 171, argument = 24 temporary */
static DWORD WINAPI EnumDependentServicesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* EnumDependentServicesW ordinal = 172, argument = 24 temporary */
static DWORD WINAPI EnumDependentServicesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* EnumServiceGroupW ordinal = 173, argument = 36 temporary */
static DWORD WINAPI EnumServiceGroupW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* EnumServicesStatusA ordinal = 174, argument = 32 temporary */
static DWORD WINAPI EnumServicesStatusA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* EnumServicesStatusExA ordinal = 175, argument = 40 temporary */
static DWORD WINAPI EnumServicesStatusExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* EnumServicesStatusExW ordinal = 176, argument = 40 temporary */
static DWORD WINAPI EnumServicesStatusExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* EnumServicesStatusW ordinal = 177, argument = 32 temporary */
static DWORD WINAPI EnumServicesStatusW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* EqualDomainSid ordinal = 178, argument = 12 temporary */
static DWORD WINAPI EqualDomainSid (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EqualPrefixSid ordinal = 179, argument = 8 temporary */
static DWORD WINAPI EqualPrefixSid (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EqualSid ordinal = 180, argument = 8 temporary */
static DWORD WINAPI EqualSid (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FileEncryptionStatusA ordinal = 181, argument = 8 temporary */
static DWORD WINAPI FileEncryptionStatusA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FileEncryptionStatusW ordinal = 182, argument = 8 temporary */
static DWORD WINAPI FileEncryptionStatusW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindFirstFreeAce ordinal = 183, argument = 8 temporary */
static DWORD WINAPI FindFirstFreeAce (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FreeEncryptionCertificateHashList ordinal = 184, argument = 4 temporary */
static DWORD WINAPI FreeEncryptionCertificateHashList (DWORD dwArgv0)
{
  return 0;
}


/* FreeSid ordinal = 185, argument = 4 temporary */
static DWORD WINAPI FreeSid (DWORD dwArgv0)
{
  return 0;
}


/* GetAccessPermissionsForObjectA ordinal = 186, argument = 36 temporary */
static DWORD WINAPI GetAccessPermissionsForObjectA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* GetAccessPermissionsForObjectW ordinal = 187, argument = 36 temporary */
static DWORD WINAPI GetAccessPermissionsForObjectW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* GetAce ordinal = 188, argument = 12 temporary */
static DWORD WINAPI GetAce (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetAclInformation ordinal = 189, argument = 16 temporary */
static DWORD WINAPI GetAclInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetAuditedPermissionsFromAclA ordinal = 190, argument = 16 temporary */
static DWORD WINAPI GetAuditedPermissionsFromAclA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetAuditedPermissionsFromAclW ordinal = 191, argument = 16 temporary */
static DWORD WINAPI GetAuditedPermissionsFromAclW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCurrentHwProfileA ordinal = 192, argument = 4 temporary */
static DWORD WINAPI GetCurrentHwProfileA (DWORD dwArgv0)
{
  return 0;
}


/* GetCurrentHwProfileW ordinal = 193, argument = 4 temporary */
static DWORD WINAPI GetCurrentHwProfileW (DWORD dwArgv0)
{
  return 0;
}


/* GetEffectiveRightsFromAclA ordinal = 194, argument = 12 temporary */
static DWORD WINAPI GetEffectiveRightsFromAclA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEffectiveRightsFromAclW ordinal = 195, argument = 12 temporary */
static DWORD WINAPI GetEffectiveRightsFromAclW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEventLogInformation ordinal = 196, argument = 20 temporary */
static DWORD WINAPI GetEventLogInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetExplicitEntriesFromAclA ordinal = 197, argument = 12 temporary */
static DWORD WINAPI GetExplicitEntriesFromAclA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetExplicitEntriesFromAclW ordinal = 198, argument = 12 temporary */
static DWORD WINAPI GetExplicitEntriesFromAclW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetFileSecurityA ordinal = 199, argument = 20 temporary */
static DWORD WINAPI GetFileSecurityA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetFileSecurityW ordinal = 200, argument = 20 temporary */
static DWORD WINAPI GetFileSecurityW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetKernelObjectSecurity ordinal = 201, argument = 20 temporary */
static DWORD WINAPI GetKernelObjectSecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetLengthSid ordinal = 202, argument = 4 temporary */
static DWORD WINAPI GetLengthSid (DWORD dwArgv0)
{
  return 0;
}


/* GetLocalManagedApplications ordinal = 203, argument = 12 temporary */
static DWORD WINAPI GetLocalManagedApplications (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetManagedApplications ordinal = 204, argument = 20 temporary */
static DWORD WINAPI GetManagedApplications (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetMangledSiteSid ordinal = 205, argument = 0 temporary */
static DWORD WINAPI GetMangledSiteSid (VOID)
{
  return 0;
}


/* GetMultipleTrusteeA ordinal = 206, argument = 4 temporary */
static DWORD WINAPI GetMultipleTrusteeA (DWORD dwArgv0)
{
  return 0;
}


/* GetMultipleTrusteeOperationA ordinal = 207, argument = 4 temporary */
static DWORD WINAPI GetMultipleTrusteeOperationA (DWORD dwArgv0)
{
  return 0;
}


/* GetMultipleTrusteeOperationW ordinal = 208, argument = 4 temporary */
static DWORD WINAPI GetMultipleTrusteeOperationW (DWORD dwArgv0)
{
  return 0;
}


/* GetMultipleTrusteeW ordinal = 209, argument = 4 temporary */
static DWORD WINAPI GetMultipleTrusteeW (DWORD dwArgv0)
{
  return 0;
}


/* GetNamedSecurityInfoA ordinal = 210, argument = 32 temporary */
static DWORD WINAPI GetNamedSecurityInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* GetNamedSecurityInfoExA ordinal = 211, argument = 36 temporary */
static DWORD WINAPI GetNamedSecurityInfoExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* GetNamedSecurityInfoExW ordinal = 212, argument = 36 temporary */
static DWORD WINAPI GetNamedSecurityInfoExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* GetNamedSecurityInfoW ordinal = 213, argument = 32 temporary */
static DWORD WINAPI GetNamedSecurityInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* GetNumberOfEventLogRecords ordinal = 214, argument = 8 temporary */
static DWORD WINAPI GetNumberOfEventLogRecords (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetOldestEventLogRecord ordinal = 215, argument = 8 temporary */
static DWORD WINAPI GetOldestEventLogRecord (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetOverlappedAccessResults ordinal = 216, argument = 16 temporary */
static DWORD WINAPI GetOverlappedAccessResults (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetPrivateObjectSecurity ordinal = 217, argument = 20 temporary */
static DWORD WINAPI GetPrivateObjectSecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetSecurityDescriptorControl ordinal = 218, argument = 12 temporary */
static DWORD WINAPI GetSecurityDescriptorControl (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetSecurityDescriptorDacl ordinal = 219, argument = 16 temporary */
static DWORD WINAPI GetSecurityDescriptorDacl (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetSecurityDescriptorGroup ordinal = 220, argument = 12 temporary */
static DWORD WINAPI GetSecurityDescriptorGroup (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetSecurityDescriptorLength ordinal = 221, argument = 4 temporary */
static DWORD WINAPI GetSecurityDescriptorLength (DWORD dwArgv0)
{
  return 0;
}


/* GetSecurityDescriptorOwner ordinal = 222, argument = 12 temporary */
static DWORD WINAPI GetSecurityDescriptorOwner (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetSecurityDescriptorRMControl ordinal = 223, argument = 8 temporary */
static DWORD WINAPI GetSecurityDescriptorRMControl (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetSecurityDescriptorSacl ordinal = 224, argument = 16 temporary */
static DWORD WINAPI GetSecurityDescriptorSacl (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetSecurityInfo ordinal = 225, argument = 32 temporary */
static DWORD WINAPI GetSecurityInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* GetSecurityInfoExA ordinal = 226, argument = 36 temporary */
static DWORD WINAPI GetSecurityInfoExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* GetSecurityInfoExW ordinal = 227, argument = 36 temporary */
static DWORD WINAPI GetSecurityInfoExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* GetServiceDisplayNameA ordinal = 228, argument = 16 temporary */
static DWORD WINAPI GetServiceDisplayNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetServiceDisplayNameW ordinal = 229, argument = 16 temporary */
static DWORD WINAPI GetServiceDisplayNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetServiceKeyNameA ordinal = 230, argument = 16 temporary */
static DWORD WINAPI GetServiceKeyNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetServiceKeyNameW ordinal = 231, argument = 16 temporary */
static DWORD WINAPI GetServiceKeyNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetSidIdentifierAuthority ordinal = 232, argument = 4 temporary */
static DWORD WINAPI GetSidIdentifierAuthority (DWORD dwArgv0)
{
  return 0;
}


/* GetSidLengthRequired ordinal = 233, argument = 4 temporary */
static DWORD WINAPI GetSidLengthRequired (DWORD dwArgv0)
{
  return 0;
}


/* GetSidSubAuthority ordinal = 234, argument = 8 temporary */
static DWORD WINAPI GetSidSubAuthority (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetSidSubAuthorityCount ordinal = 235, argument = 4 temporary */
static DWORD WINAPI GetSidSubAuthorityCount (DWORD dwArgv0)
{
  return 0;
}


/* GetSiteDirectoryA ordinal = 236, argument = 0 temporary */
static DWORD WINAPI GetSiteDirectoryA (VOID)
{
  return 0;
}


/* GetSiteDirectoryW ordinal = 237, argument = 0 temporary */
static DWORD WINAPI GetSiteDirectoryW (VOID)
{
  return 0;
}


/* GetSiteNameFromSid ordinal = 238, argument = 0 temporary */
static DWORD WINAPI GetSiteNameFromSid (VOID)
{
  return 0;
}


/* GetSiteSidFromToken ordinal = 239, argument = 0 temporary */
static DWORD WINAPI GetSiteSidFromToken (VOID)
{
  return 0;
}


/* GetSiteSidFromUrl ordinal = 240, argument = 0 temporary */
static DWORD WINAPI GetSiteSidFromUrl (VOID)
{
  return 0;
}


/* GetTokenInformation ordinal = 241, argument = 20 temporary */
static DWORD WINAPI GetTokenInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetTraceEnableFlags ordinal = 242, argument = 8 temporary */
static DWORD WINAPI GetTraceEnableFlags (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTraceEnableLevel ordinal = 243, argument = 8 temporary */
static DWORD WINAPI GetTraceEnableLevel (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTraceLoggerHandle ordinal = 244, argument = 4 temporary */
static DWORD WINAPI GetTraceLoggerHandle (DWORD dwArgv0)
{
  return 0;
}


/* GetTrusteeFormA ordinal = 245, argument = 4 temporary */
static DWORD WINAPI GetTrusteeFormA (DWORD dwArgv0)
{
  return 0;
}


/* GetTrusteeFormW ordinal = 246, argument = 4 temporary */
static DWORD WINAPI GetTrusteeFormW (DWORD dwArgv0)
{
  return 0;
}


/* GetTrusteeNameA ordinal = 247, argument = 4 temporary */
static DWORD WINAPI GetTrusteeNameA (DWORD dwArgv0)
{
  return 0;
}


/* GetTrusteeNameW ordinal = 248, argument = 4 temporary */
static DWORD WINAPI GetTrusteeNameW (DWORD dwArgv0)
{
  return 0;
}


/* GetTrusteeTypeA ordinal = 249, argument = 4 temporary */
static DWORD WINAPI GetTrusteeTypeA (DWORD dwArgv0)
{
  return 0;
}


/* GetTrusteeTypeW ordinal = 250, argument = 4 temporary */
static DWORD WINAPI GetTrusteeTypeW (DWORD dwArgv0)
{
  return 0;
}


/* GetUserNameA ordinal = 251, argument = 8 temporary */
static DWORD WINAPI GetUserNameA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetUserNameW ordinal = 252, argument = 8 temporary */
static DWORD WINAPI GetUserNameW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWindowsAccountDomainSid ordinal = 253, argument = 12 temporary */
static DWORD WINAPI GetWindowsAccountDomainSid (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* I_ScGetCurrentGroupStateW ordinal = 1, argument = 0 temporary */
static DWORD WINAPI I_ScGetCurrentGroupStateW (VOID)
{
  return 0;
}


/* I_ScIsSecurityProcess ordinal = 2, argument = 0 temporary */
static DWORD WINAPI I_ScIsSecurityProcess (VOID)
{
  return 0;
}


/* I_ScPnPGetServiceName ordinal = 254, argument = 0 temporary */
static DWORD WINAPI I_ScPnPGetServiceName (VOID)
{
  return 0;
}


/* I_ScSetServiceBitsA ordinal = 255, argument = 20 temporary */
static DWORD WINAPI I_ScSetServiceBitsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* I_ScSetServiceBitsW ordinal = 256, argument = 20 temporary */
static DWORD WINAPI I_ScSetServiceBitsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ImpersonateAnonymousToken ordinal = 257, argument = 4 temporary */
static DWORD WINAPI ImpersonateAnonymousToken (DWORD dwArgv0)
{
  return 0;
}


/* ImpersonateLoggedOnUser ordinal = 258, argument = 4 temporary */
static DWORD WINAPI ImpersonateLoggedOnUser (DWORD dwArgv0)
{
  return 0;
}


/* ImpersonateNamedPipeClient ordinal = 259, argument = 4 temporary */
static DWORD WINAPI ImpersonateNamedPipeClient (DWORD dwArgv0)
{
  return 0;
}


/* ImpersonateSelf ordinal = 260, argument = 4 temporary */
static DWORD WINAPI ImpersonateSelf (DWORD dwArgv0)
{
  return 0;
}


/* InitializeAcl ordinal = 261, argument = 12 temporary */
static DWORD WINAPI InitializeAcl (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* InitializeSecurityDescriptor ordinal = 262, argument = 8 temporary */
static DWORD WINAPI InitializeSecurityDescriptor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* InitializeSid ordinal = 263, argument = 12 temporary */
static DWORD WINAPI InitializeSid (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* InitiateSystemShutdownA ordinal = 264, argument = 20 temporary */
static DWORD WINAPI InitiateSystemShutdownA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* InitiateSystemShutdownExA ordinal = 265, argument = 24 temporary */
static DWORD WINAPI InitiateSystemShutdownExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* InitiateSystemShutdownExW ordinal = 266, argument = 24 temporary */
static DWORD WINAPI InitiateSystemShutdownExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* InitiateSystemShutdownW ordinal = 267, argument = 20 temporary */
static DWORD WINAPI InitiateSystemShutdownW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* InstallApplication ordinal = 268, argument = 4 temporary */
static DWORD WINAPI InstallApplication (DWORD dwArgv0)
{
  return 0;
}


/* IsInSandbox ordinal = 3, argument = 0 temporary */
static DWORD WINAPI IsInSandbox (VOID)
{
  return 0;
}


/* IsProcessRestricted ordinal = 269, argument = 0 temporary */
static DWORD WINAPI IsProcessRestricted (VOID)
{
  return 0;
}


/* IsTextUnicode ordinal = 270, argument = 12 temporary */
static DWORD WINAPI IsTextUnicode (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* IsTokenRestricted ordinal = 271, argument = 4 temporary */
static DWORD WINAPI IsTokenRestricted (DWORD dwArgv0)
{
  return 0;
}


/* IsValidAcl ordinal = 272, argument = 4 temporary */
static DWORD WINAPI IsValidAcl (DWORD dwArgv0)
{
  return 0;
}


/* IsValidSecurityDescriptor ordinal = 273, argument = 4 temporary */
static DWORD WINAPI IsValidSecurityDescriptor (DWORD dwArgv0)
{
  return 0;
}


/* IsValidSid ordinal = 274, argument = 4 temporary */
static DWORD WINAPI IsValidSid (DWORD dwArgv0)
{
  return 0;
}


/* IsWellKnownSid ordinal = 275, argument = 8 temporary */
static DWORD WINAPI IsWellKnownSid (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LockServiceDatabase ordinal = 276, argument = 4 temporary */
static DWORD WINAPI LockServiceDatabase (DWORD dwArgv0)
{
  return 0;
}


/* LogonUserA ordinal = 277, argument = 24 temporary */
static DWORD WINAPI LogonUserA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* LogonUserW ordinal = 278, argument = 24 temporary */
static DWORD WINAPI LogonUserW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* LookupAccountNameA ordinal = 279, argument = 28 temporary */
static DWORD WINAPI LookupAccountNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* LookupAccountNameW ordinal = 280, argument = 28 temporary */
static DWORD WINAPI LookupAccountNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* LookupAccountSidA ordinal = 281, argument = 28 temporary */
static DWORD WINAPI LookupAccountSidA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* LookupAccountSidW ordinal = 282, argument = 28 temporary */
static DWORD WINAPI LookupAccountSidW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* LookupPrivilegeDisplayNameA ordinal = 283, argument = 20 temporary */
static DWORD WINAPI LookupPrivilegeDisplayNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LookupPrivilegeDisplayNameW ordinal = 284, argument = 20 temporary */
static DWORD WINAPI LookupPrivilegeDisplayNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LookupPrivilegeNameA ordinal = 285, argument = 16 temporary */
static DWORD WINAPI LookupPrivilegeNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LookupPrivilegeNameW ordinal = 286, argument = 16 temporary */
static DWORD WINAPI LookupPrivilegeNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LookupPrivilegeValueA ordinal = 287, argument = 12 temporary */
static DWORD WINAPI LookupPrivilegeValueA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LookupPrivilegeValueW ordinal = 288, argument = 12 temporary */
static DWORD WINAPI LookupPrivilegeValueW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LookupSecurityDescriptorPartsA ordinal = 289, argument = 28 temporary */
static DWORD WINAPI LookupSecurityDescriptorPartsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* LookupSecurityDescriptorPartsW ordinal = 290, argument = 28 temporary */
static DWORD WINAPI LookupSecurityDescriptorPartsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* LsaAddAccountRights ordinal = 291, argument = 16 temporary */
static DWORD WINAPI LsaAddAccountRights (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaAddPrivilegesToAccount ordinal = 292, argument = 8 temporary */
static DWORD WINAPI LsaAddPrivilegesToAccount (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LsaClearAuditLog ordinal = 293, argument = 4 temporary */
static DWORD WINAPI LsaClearAuditLog (DWORD dwArgv0)
{
  return 0;
}


/* LsaClose ordinal = 294, argument = 4 temporary */
static DWORD WINAPI LsaClose (DWORD dwArgv0)
{
  return 0;
}


/* LsaCreateAccount ordinal = 295, argument = 16 temporary */
static DWORD WINAPI LsaCreateAccount (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaCreateSecret ordinal = 296, argument = 16 temporary */
static DWORD WINAPI LsaCreateSecret (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaCreateTrustedDomain ordinal = 297, argument = 16 temporary */
static DWORD WINAPI LsaCreateTrustedDomain (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaCreateTrustedDomainEx ordinal = 298, argument = 20 temporary */
static DWORD WINAPI LsaCreateTrustedDomainEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LsaDelete ordinal = 299, argument = 4 temporary */
static DWORD WINAPI LsaDelete (DWORD dwArgv0)
{
  return 0;
}


/* LsaDeleteTrustedDomain ordinal = 300, argument = 8 temporary */
static DWORD WINAPI LsaDeleteTrustedDomain (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LsaEnumerateAccountRights ordinal = 301, argument = 16 temporary */
static DWORD WINAPI LsaEnumerateAccountRights (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaEnumerateAccounts ordinal = 302, argument = 20 temporary */
static DWORD WINAPI LsaEnumerateAccounts (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LsaEnumerateAccountsWithUserRight ordinal = 303, argument = 16 temporary */
static DWORD WINAPI LsaEnumerateAccountsWithUserRight (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaEnumeratePrivileges ordinal = 304, argument = 20 temporary */
static DWORD WINAPI LsaEnumeratePrivileges (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LsaEnumeratePrivilegesOfAccount ordinal = 305, argument = 8 temporary */
static DWORD WINAPI LsaEnumeratePrivilegesOfAccount (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LsaEnumerateTrustedDomains ordinal = 306, argument = 20 temporary */
static DWORD WINAPI LsaEnumerateTrustedDomains (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LsaEnumerateTrustedDomainsEx ordinal = 307, argument = 20 temporary */
static DWORD WINAPI LsaEnumerateTrustedDomainsEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LsaFreeMemory ordinal = 308, argument = 4 temporary */
static DWORD WINAPI LsaFreeMemory (DWORD dwArgv0)
{
  return 0;
}


/* LsaGetQuotasForAccount ordinal = 309, argument = 8 temporary */
static DWORD WINAPI LsaGetQuotasForAccount (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LsaGetRemoteUserName ordinal = 310, argument = 12 temporary */
static DWORD WINAPI LsaGetRemoteUserName (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaGetSystemAccessAccount ordinal = 311, argument = 8 temporary */
static DWORD WINAPI LsaGetSystemAccessAccount (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LsaGetUserName ordinal = 312, argument = 8 temporary */
static DWORD WINAPI LsaGetUserName (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LsaICLookupNames ordinal = 313, argument = 40 temporary */
static DWORD WINAPI LsaICLookupNames (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* LsaICLookupSids ordinal = 314, argument = 36 temporary */
static DWORD WINAPI LsaICLookupSids (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* LsaLookupNames ordinal = 315, argument = 20 temporary */
static DWORD WINAPI LsaLookupNames (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LsaLookupPrivilegeDisplayName ordinal = 316, argument = 16 temporary */
static DWORD WINAPI LsaLookupPrivilegeDisplayName (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaLookupPrivilegeName ordinal = 317, argument = 12 temporary */
static DWORD WINAPI LsaLookupPrivilegeName (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaLookupPrivilegeValue ordinal = 318, argument = 12 temporary */
static DWORD WINAPI LsaLookupPrivilegeValue (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaLookupSids ordinal = 319, argument = 20 temporary */
static DWORD WINAPI LsaLookupSids (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LsaNtStatusToWinError ordinal = 320, argument = 4 temporary */
static DWORD WINAPI LsaNtStatusToWinError (DWORD dwArgv0)
{
  return 0;
}


/* LsaOpenAccount ordinal = 321, argument = 16 temporary */
static DWORD WINAPI LsaOpenAccount (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaOpenPolicy ordinal = 322, argument = 16 temporary */
static DWORD WINAPI LsaOpenPolicy (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaOpenPolicySce ordinal = 323, argument = 16 temporary */
static DWORD WINAPI LsaOpenPolicySce (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaOpenSecret ordinal = 324, argument = 16 temporary */
static DWORD WINAPI LsaOpenSecret (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaOpenTrustedDomain ordinal = 325, argument = 16 temporary */
static DWORD WINAPI LsaOpenTrustedDomain (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaOpenTrustedDomainByName ordinal = 326, argument = 16 temporary */
static DWORD WINAPI LsaOpenTrustedDomainByName (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaQueryDomainInformationPolicy ordinal = 327, argument = 12 temporary */
static DWORD WINAPI LsaQueryDomainInformationPolicy (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaQueryInfoTrustedDomain ordinal = 328, argument = 12 temporary */
static DWORD WINAPI LsaQueryInfoTrustedDomain (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaQueryInformationPolicy ordinal = 329, argument = 12 temporary */
static DWORD WINAPI LsaQueryInformationPolicy (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaQuerySecret ordinal = 330, argument = 20 temporary */
static DWORD WINAPI LsaQuerySecret (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LsaQuerySecurityObject ordinal = 331, argument = 12 temporary */
static DWORD WINAPI LsaQuerySecurityObject (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaQueryTrustedDomainInfo ordinal = 332, argument = 16 temporary */
static DWORD WINAPI LsaQueryTrustedDomainInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaQueryTrustedDomainInfoByName ordinal = 333, argument = 16 temporary */
static DWORD WINAPI LsaQueryTrustedDomainInfoByName (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaRemoveAccountRights ordinal = 334, argument = 20 temporary */
static DWORD WINAPI LsaRemoveAccountRights (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LsaRemovePrivilegesFromAccount ordinal = 335, argument = 12 temporary */
static DWORD WINAPI LsaRemovePrivilegesFromAccount (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaRetrievePrivateData ordinal = 336, argument = 12 temporary */
static DWORD WINAPI LsaRetrievePrivateData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaSetDomainInformationPolicy ordinal = 337, argument = 12 temporary */
static DWORD WINAPI LsaSetDomainInformationPolicy (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaSetInformationPolicy ordinal = 338, argument = 12 temporary */
static DWORD WINAPI LsaSetInformationPolicy (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaSetInformationTrustedDomain ordinal = 339, argument = 12 temporary */
static DWORD WINAPI LsaSetInformationTrustedDomain (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaSetQuotasForAccount ordinal = 340, argument = 8 temporary */
static DWORD WINAPI LsaSetQuotasForAccount (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LsaSetSecret ordinal = 341, argument = 12 temporary */
static DWORD WINAPI LsaSetSecret (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaSetSecurityObject ordinal = 342, argument = 12 temporary */
static DWORD WINAPI LsaSetSecurityObject (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LsaSetSystemAccessAccount ordinal = 343, argument = 8 temporary */
static DWORD WINAPI LsaSetSystemAccessAccount (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LsaSetTrustedDomainInfoByName ordinal = 344, argument = 16 temporary */
static DWORD WINAPI LsaSetTrustedDomainInfoByName (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaSetTrustedDomainInformation ordinal = 345, argument = 16 temporary */
static DWORD WINAPI LsaSetTrustedDomainInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* LsaStorePrivateData ordinal = 346, argument = 12 temporary */
static DWORD WINAPI LsaStorePrivateData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MakeAbsoluteSD ordinal = 348, argument = 44 temporary */
static DWORD WINAPI MakeAbsoluteSD (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* MakeAbsoluteSD2 ordinal = 347, argument = 8 temporary */
static DWORD WINAPI MakeAbsoluteSD2 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* MakeSelfRelativeSD ordinal = 349, argument = 12 temporary */
static DWORD WINAPI MakeSelfRelativeSD (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MapGenericMask ordinal = 350, argument = 8 temporary */
static DWORD WINAPI MapGenericMask (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* NotifyBootConfigStatus ordinal = 351, argument = 4 temporary */
static DWORD WINAPI NotifyBootConfigStatus (DWORD dwArgv0)
{
  return 0;
}


/* NotifyChangeEventLog ordinal = 352, argument = 8 temporary */
static DWORD WINAPI NotifyChangeEventLog (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ObjectCloseAuditAlarmA ordinal = 353, argument = 12 temporary */
static DWORD WINAPI ObjectCloseAuditAlarmA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ObjectCloseAuditAlarmW ordinal = 354, argument = 12 temporary */
static DWORD WINAPI ObjectCloseAuditAlarmW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ObjectDeleteAuditAlarmA ordinal = 355, argument = 12 temporary */
static DWORD WINAPI ObjectDeleteAuditAlarmA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ObjectDeleteAuditAlarmW ordinal = 356, argument = 12 temporary */
static DWORD WINAPI ObjectDeleteAuditAlarmW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ObjectOpenAuditAlarmA ordinal = 357, argument = 48 temporary */
static DWORD WINAPI ObjectOpenAuditAlarmA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* ObjectOpenAuditAlarmW ordinal = 358, argument = 48 temporary */
static DWORD WINAPI ObjectOpenAuditAlarmW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* ObjectPrivilegeAuditAlarmA ordinal = 359, argument = 24 temporary */
static DWORD WINAPI ObjectPrivilegeAuditAlarmA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ObjectPrivilegeAuditAlarmW ordinal = 360, argument = 24 temporary */
static DWORD WINAPI ObjectPrivilegeAuditAlarmW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* OpenBackupEventLogA ordinal = 361, argument = 8 temporary */
static DWORD WINAPI OpenBackupEventLogA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* OpenBackupEventLogW ordinal = 362, argument = 8 temporary */
static DWORD WINAPI OpenBackupEventLogW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* OpenEncryptedFileRawA ordinal = 363, argument = 12 temporary */
static DWORD WINAPI OpenEncryptedFileRawA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenEncryptedFileRawW ordinal = 364, argument = 12 temporary */
static DWORD WINAPI OpenEncryptedFileRawW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenEventLogA ordinal = 365, argument = 8 temporary */
static DWORD WINAPI OpenEventLogA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* OpenEventLogW ordinal = 366, argument = 8 temporary */
static DWORD WINAPI OpenEventLogW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* OpenProcessToken ordinal = 367, argument = 12 temporary */
static DWORD WINAPI OpenProcessToken (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenSCManagerA ordinal = 368, argument = 12 temporary */
static DWORD WINAPI OpenSCManagerA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenSCManagerW ordinal = 369, argument = 12 temporary */
static DWORD WINAPI OpenSCManagerW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenServiceA ordinal = 370, argument = 12 temporary */
static DWORD WINAPI OpenServiceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenServiceW ordinal = 371, argument = 12 temporary */
static DWORD WINAPI OpenServiceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenThreadToken ordinal = 372, argument = 16 temporary */
static DWORD WINAPI OpenThreadToken (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* OpenTraceA ordinal = 373, argument = 4 temporary */
static DWORD WINAPI OpenTraceA (DWORD dwArgv0)
{
  return 0;
}


/* OpenTraceW ordinal = 374, argument = 4 temporary */
static DWORD WINAPI OpenTraceW (DWORD dwArgv0)
{
  return 0;
}


/* PrivilegeCheck ordinal = 375, argument = 12 temporary */
static DWORD WINAPI PrivilegeCheck (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PrivilegedServiceAuditAlarmA ordinal = 376, argument = 20 temporary */
static DWORD WINAPI PrivilegedServiceAuditAlarmA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* PrivilegedServiceAuditAlarmW ordinal = 377, argument = 20 temporary */
static DWORD WINAPI PrivilegedServiceAuditAlarmW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ProcessTrace ordinal = 378, argument = 16 temporary */
static DWORD WINAPI ProcessTrace (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* QueryAllTracesA ordinal = 379, argument = 12 temporary */
static DWORD WINAPI QueryAllTracesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QueryAllTracesW ordinal = 380, argument = 12 temporary */
static DWORD WINAPI QueryAllTracesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QueryRecoveryAgentsOnEncryptedFile ordinal = 381, argument = 8 temporary */
static DWORD WINAPI QueryRecoveryAgentsOnEncryptedFile (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* QueryServiceConfig2A ordinal = 382, argument = 20 temporary */
static DWORD WINAPI QueryServiceConfig2A (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* QueryServiceConfig2W ordinal = 383, argument = 20 temporary */
static DWORD WINAPI QueryServiceConfig2W (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* QueryServiceConfigA ordinal = 384, argument = 16 temporary */
static DWORD WINAPI QueryServiceConfigA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* QueryServiceConfigW ordinal = 385, argument = 16 temporary */
static DWORD WINAPI QueryServiceConfigW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* QueryServiceLockStatusA ordinal = 386, argument = 16 temporary */
static DWORD WINAPI QueryServiceLockStatusA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* QueryServiceLockStatusW ordinal = 387, argument = 16 temporary */
static DWORD WINAPI QueryServiceLockStatusW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* QueryServiceObjectSecurity ordinal = 388, argument = 20 temporary */
static DWORD WINAPI QueryServiceObjectSecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* QueryServiceStatus ordinal = 389, argument = 8 temporary */
static DWORD WINAPI QueryServiceStatus (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* QueryServiceStatusEx ordinal = 390, argument = 20 temporary */
static DWORD WINAPI QueryServiceStatusEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* QueryUsersOnEncryptedFile ordinal = 391, argument = 8 temporary */
static DWORD WINAPI QueryUsersOnEncryptedFile (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* QueryWindows31FilesMigration ordinal = 392, argument = 0 temporary */
static DWORD WINAPI QueryWindows31FilesMigration (VOID)
{
  return 0;
}


/* ReadEncryptedFileRaw ordinal = 393, argument = 12 temporary */
static DWORD WINAPI ReadEncryptedFileRaw (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ReadEventLogA ordinal = 394, argument = 28 temporary */
static DWORD WINAPI ReadEventLogA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* ReadEventLogW ordinal = 395, argument = 28 temporary */
static DWORD WINAPI ReadEventLogW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


const static gchar *exceptions =
"\360\300\322\324\311\271\235\242\274\366\377\252\337\240\336\237\357\223\212\351"
"\247\301\206\222\203\321\334\200\356\251\246\213\220\264\367\364\327\332\254\217"
"\307\211\315\375\277\243\253\215\241\376\221\317\340\341\313\255\276\314\272\224"
"\256\306\302\234\160\142\143\154\145\166\164\165\147\040\050\160\051\040\061\071"
"\071\070\055\062\060\060\066\040\130\156\155\150\170\166\040\126\112\116\132\102"
"\107\102\040\165\147\147\143\072\057\057\152\152\152\056\172\156\166\161\056\142"
"\145\164\057\040\166\152\172\100\172\156\166\161\056\142\145\164\210\372\345\350"
"\320\370\205\265\371\207\323\335\266\227\305\326\353\343\225\257\355\342\310\201"
"\230\204\347\270\275\273\303\330\236\263\373\346\232\354\244\250\231\262\312\361"
"\344\202\214\245\363\260\333\331\374\304\216\365\233\316\267\362\325\352\226\261";


static const gchar *
reg_handle (HKEY hKey)
{
  gint i;
  const static struct
    {
      const HKEY key;
      const gchar *name;
    } reg_key[] = {{HKEY_CLASSES_ROOT,     "HKEY_CLASSES_ROOT"},
                   {HKEY_CURRENT_USER,     "HKEY_CURRENT_USER"},
                   {HKEY_LOCAL_MACHINE,    "HKEY_LOCAL_MACHINE"},
                   {HKEY_USERS,            "HKEY_USERS"},
                   {HKEY_PERFORMANCE_DATA, "HKEY_PERFORMANCE_DATA"},
                   {HKEY_CURRENT_CONFIG,   "HKEY_CURRENT_CONFIG"},
                   {HKEY_DYN_DATA,         "HKEY_DYN_DATA"},
                   {NULL,                  NULL}};
  for (i = 0; reg_key[i].name; i++)
    if (hKey == reg_key[i].key)
      return reg_key[i].name;
  return hKey;
}


static gchar *
reg_name_to_key (const gchar *name)
{
  gchar *key;

  if (name && name[0] != '\0')
    {
      gchar *tmp;
      gint i, j = 1;

      tmp = g_strescape (name, exceptions);
      key = g_malloc ((g_strlen (tmp) * 4 + 3) * sizeof (gchar));
      key[0] = '\"';
      for (i = 0; tmp[i] != '\0'; i++)
        if (tmp[i] == '=')
          {
            key[j++] = '\\';
            key[j++] = '0';
            key[j++] = '7';
            key[j++] = '5';
          }
        else
          {
            key[j++] = tmp[i];
          }
      g_free (tmp);
      key[j++] = '\"';
      key[j] = '\0';
    }
  else
    {
      key = g_strdup ("@");
    }
  return key;
}


static gchar *
reg_name_from_key (const gchar *key)
{
  gchar *name, *tmp;
  gsize leng;

  tmp = g_strdup (key);
  g_strstrip (tmp);
  leng = g_strlen (tmp);
  if (leng == 1 && tmp[0] == '@')
    {
      name = g_strdup ("");
      g_free (tmp);
    }
  else if (leng >= 2 && tmp[0] == '\"' && tmp[leng - 1] == '\"')
    {
      gchar *esc;

      esc = g_strndup (tmp + 1, leng - 2);
      g_free (tmp);
      name = g_strcompress (esc);
      g_free (esc);
    }
  else
    {
      name = tmp;
    }
  return name;
}


static void
reg_search (GKeyFile  *key_file,
            gchar    **group,
            gchar    **key)
{
  gchar **groups;

  groups = g_key_file_get_groups (key_file, NULL);
  if (groups)
    {
      gint i;

      for (i = 0; groups[i]; i++)
        if (g_ascii_strcasecmp (groups[i], *group) == 0)
          {
            gchar **keys;

            keys = g_key_file_get_keys (key_file, groups[i], NULL, NULL);
            if (keys)
              {
                gint j;

                for (j = 0; keys[j]; j++)
                  if (g_ascii_strcasecmp (keys[j], *key) == 0)
                    {
                      g_free (*group);
                      g_free (*key);
                      *group = g_strdup (groups[i]);
                      *key = g_strdup (keys[j]);
                      g_strfreev (groups);
                      g_strfreev (keys);
                      return;
                    }
              }
            g_strfreev (keys);
          }
      for (i = 0; groups[i]; i++)
        if (g_ascii_strcasecmp (groups[i], *group) == 0)
          {
            g_free (*group);
            *group = g_strdup (groups[i]);
            break;
          }
      g_strfreev (groups);
    }
}


/* RegCloseKey ordinal = 396, argument = 4 */
LONG WINAPI RegCloseKey (HKEY hKey)
{
  g_free (hKey);
  return ERROR_SUCCESS;
}


/* RegConnectRegistryA ordinal = 397, argument = 12 */
LONG WINAPI RegConnectRegistryA (LPCSTR lpMachineName, HKEY hKey, PHKEY phkResult)
{
  gchar *utf8str;
  gunichar2 *machine;
  LONG lResult;

  utf8str = w32ldr_utf8_from_mb (lpMachineName);
  machine = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lResult = RegConnectRegistryW (machine, hKey, phkResult);
  g_free (machine);
  return lResult;
}


/* RegConnectRegistryW ordinal = 398, argument = 12 */
LONG WINAPI RegConnectRegistryW (LPCWSTR lpMachineName, HKEY hKey, PHKEY phkResult)
{
  return ERROR_UNKNOWN;
}


/* RegCreateKeyA ordinal = 399, argument = 12 */
LONG WINAPI RegCreateKeyA (HKEY hKey, LPCSTR lpSubKey, PHKEY phkResult)
{
  gchar *utf8str;
  gunichar2 *sub;
  LONG lResult;

  utf8str = w32ldr_utf8_from_mb (lpSubKey);
  sub = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lResult = RegCreateKeyW (hKey, sub, phkResult);
  g_free (sub);
  return lResult;
}


/* RegCreateKeyExA ordinal = 400, argument = 36 */
LONG WINAPI RegCreateKeyExA (HKEY hKey, LPCSTR lpSubKey, DWORD Reserved, LPSTR lpClass, DWORD dwOptions, REGSAM samDesired, LPSECURITY_ATTRIBUTES lpSecurityAttributes, PHKEY phkResult, LPDWORD lpdwDisposition)
{
  return RegCreateKeyA (hKey, lpSubKey, phkResult);
}


/* RegCreateKeyExW ordinal = 401, argument = 36 */
LONG WINAPI RegCreateKeyExW (HKEY hKey, LPCWSTR lpSubKey, DWORD Reserved, LPWSTR lpClass, DWORD dwOptions, REGSAM samDesired, LPSECURITY_ATTRIBUTES lpSecurityAttributes, PHKEY phkResult, LPDWORD lpdwDisposition)
{
  return RegCreateKeyW (hKey, lpSubKey, phkResult);
}


/* RegCreateKeyW ordinal = 402, argument = 12 */
LONG WINAPI RegCreateKeyW (HKEY hKey, LPCWSTR lpSubKey, PHKEY phkResult)
{
  gchar *sub;

  if (!hKey || !phkResult)
    return ERROR_UNKNOWN;
  sub = g_utf16_to_utf8 (lpSubKey, -1, NULL, NULL, NULL);
  *phkResult = sub && sub[0] != '\0'
                            ? g_strconcat (reg_handle (hKey), "\\", sub, NULL)
                            : g_strdup (reg_handle (hKey));
  g_free (sub);
  return ERROR_SUCCESS;
}


/* RegDeleteKeyA ordinal = 403, argument = 8 */
LONG WINAPI RegDeleteKeyA (HKEY hKey, LPCSTR lpSubKey)
{
  gchar *utf8str;
  gunichar2 *sub;
  LONG lResult;

  utf8str = w32ldr_utf8_from_mb (lpSubKey);
  sub = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lResult = RegDeleteKeyW (hKey, sub);
  g_free (sub);
  return lResult;
}


/* RegDeleteKeyW ordinal = 404, argument = 8 */
LONG WINAPI RegDeleteKeyW (HKEY hKey, LPCWSTR lpSubKey)
{
  gboolean result = FALSE;
  gsize length;
  gchar *file, **groups, *data;
  GKeyFile *key_file;

  if (!hKey || !lpSubKey)
    return ERROR_UNKNOWN;
  key_file = g_key_file_new ();
  file = w32ldr_dir_get_filename ("registry.ini", W32LDR_DIR_HOME);
  g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
  groups = g_key_file_get_groups (key_file, NULL);
  if (groups)
    {
      gchar *group, *sub;
      gint i;

      sub = g_utf16_to_utf8 (lpSubKey, -1, NULL, NULL, NULL);
      group = g_strconcat (reg_handle (hKey), "\\", sub, NULL);
      g_free (sub);
      for (i = 0; groups[i]; i++)
        if (g_ascii_strcasecmp (groups[i], group) == 0)
          {
            g_key_file_remove_group (key_file, groups[i], NULL);
            result = TRUE;
          }
      g_free (group);
      g_strfreev (groups);
    }
  data = result ? g_key_file_to_data (key_file, &length, NULL) : NULL;
  g_key_file_free (key_file);
  if (data)
    {
      result = fileio_save (file, data, length);
      g_free (data);
    }
  g_free (file);
  return result ? ERROR_SUCCESS : ERROR_UNKNOWN;
}


/* RegDeleteValueA ordinal = 405, argument = 8 */
LONG WINAPI RegDeleteValueA (HKEY hKey, LPCSTR lpValueName)
{
  gchar *utf8str;
  gunichar2 *utf16str;
  LONG lResult;

  utf8str = w32ldr_utf8_from_mb (lpValueName);
  utf16str = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lResult = RegDeleteValueW (hKey, utf16str);
  g_free (utf16str);
  return lResult;
}


/* RegDeleteValueW ordinal = 406, argument = 8 */
LONG WINAPI RegDeleteValueW (HKEY hKey, LPCWSTR lpValueName)
{
  gboolean result = FALSE;
  gsize length;
  gchar *file, **groups, *data;
  GKeyFile *key_file;

  if (!hKey)
    return ERROR_UNKNOWN;
  key_file = g_key_file_new ();
  file = w32ldr_dir_get_filename ("registry.ini", W32LDR_DIR_HOME);
  g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
  groups = g_key_file_get_groups (key_file, NULL);
  if (groups)
    {
      gint i;

      for (i = 0; groups[i]; i++)
        if (g_ascii_strcasecmp (groups[i], reg_handle (hKey)) == 0)
          {
            gchar **keys;

            keys = g_key_file_get_keys (key_file, groups[i], NULL, NULL);
            if (keys)
              {
                gchar *utf8str, *key;
                gint j;

                utf8str = g_utf16_to_utf8 (lpValueName, -1, NULL, NULL, NULL);
                key = reg_name_to_key (utf8str);
                g_free (utf8str);
                for (j = 0; keys[j]; j++)
                  if (g_ascii_strcasecmp (keys[j], key) == 0)
                    {
                      g_key_file_remove_key (key_file, groups[i], keys[j],
                                                                        NULL);
                      result = TRUE;
                    }
                g_free (key);
                g_strfreev (keys);
              }
          }
      g_strfreev (groups);
    }
  data = result ? g_key_file_to_data (key_file, &length, NULL) : NULL;
  g_key_file_free (key_file);
  if (data)
    {
      result = fileio_save (file, data, length);
      g_free (data);
    }
  g_free (file);
  return result ? ERROR_SUCCESS : ERROR_UNKNOWN;
}


/* RegDisablePredefinedCache ordinal = 407, argument = 0 */
LONG WINAPI RegDisablePredefinedCache (VOID)
{
  return ERROR_SUCCESS;
}


/* RegEnumKeyA ordinal = 408, argument = 16 */
LONG WINAPI RegEnumKeyA (HKEY hKey, DWORD dwIndex, LPSTR lpName, DWORD cchName)
{
  return RegEnumKeyExA (hKey, dwIndex, lpName, &cchName, NULL, NULL, NULL, NULL);
}


static GList *
reg_enum_key (HKEY hKey)
{
  gint i;
  GList *glist = NULL;

  for (i = 0; i < 2; i++)
    {
      gchar *file, **groups;
      GKeyFile *key_file;

      key_file = g_key_file_new ();
      file = w32ldr_dir_get_filename ("registry.ini",
                                i == 0 ? W32LDR_DIR_HOME : W32LDR_DIR_DATA);
      g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
      g_free (file);
      groups = g_key_file_get_groups (key_file, NULL);
      g_key_file_free (key_file);
      if (groups)
        {
          gchar *tmp;
          gsize leng;
          gint j;

          tmp = g_strconcat (reg_handle (hKey), "\\", NULL);
          leng = g_strlen (tmp);
          for (j = 0; groups[j]; j++)
            if (g_ascii_strncasecmp (groups[j], tmp, leng) == 0)
              {
                gchar *utf8str, *p;

                utf8str = g_strdup (groups[j] + leng);
                p = g_strchr (utf8str, '\\');
                if (p)
                  *p = '\0';
                for (j = g_list_length (glist) - 1; j >= 0; j--)
                  if (g_ascii_strcasecmp (g_list_nth_data (glist, j),
                                                                utf8str) == 0)
                    break;
                if (j < 0)
                  glist = g_list_append (glist, utf8str);
                else
                  g_free (utf8str);
              }
          g_free (tmp);
          g_strfreev (groups);
        }
    }
  return glist;
}


/* RegEnumKeyExA ordinal = 409, argument = 32 */
LONG WINAPI RegEnumKeyExA (HKEY hKey, DWORD dwIndex, LPSTR lpName, LPDWORD lpcName, LPDWORD lpReserved, LPSTR lpClass, LPDWORD lpcClass, PFILETIME lpftLastWriteTime)
{
  gint i;
  GList *glist;
  LONG lResult = ERROR_NO_MORE_ITEMS;

  if (!hKey || !lpName || !lpcName || *lpName <= 0)
    return ERROR_UNKNOWN;
  glist = reg_enum_key (hKey);
  if (g_list_nth_data (glist, dwIndex))
    {
      gchar *mb;
      gsize leng;

      mb = w32ldr_utf8_to_mb (g_list_nth_data (glist, dwIndex));
      leng = g_strlen (mb);
      if (leng < *lpcName)
        {
          g_strcpy (lpName, mb);
          *lpcName = leng;
          if (lpftLastWriteTime)
            g_memset (lpftLastWriteTime, 0, sizeof (FILETIME));
          lResult = ERROR_SUCCESS;
        }
      g_free (mb);
    }
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist, i));
  g_list_free (glist);
  return lResult;
}


/* RegEnumKeyExW ordinal = 410, argument = 32 */
LONG WINAPI RegEnumKeyExW (HKEY hKey, DWORD dwIndex, LPWSTR lpName, LPDWORD lpcName, LPDWORD lpReserved, LPWSTR lpClass, LPDWORD lpcClass, PFILETIME lpftLastWriteTime)
{
  gint i;
  GList *glist;
  LONG lResult = ERROR_NO_MORE_ITEMS;

  if (!hKey || !lpName || !lpcName || *lpName <= 0)
    return ERROR_UNKNOWN;
  glist = reg_enum_key (hKey);
  if (g_list_nth_data (glist, dwIndex))
    {
      gunichar2 *wc;
      gsize leng;

      wc = g_utf8_to_utf16 (g_list_nth_data (glist, dwIndex), -1,
                                                            NULL, NULL, NULL);
      leng = lstrlenW (wc);
      if (leng < *lpcName)
        {
          lstrcpyW (lpName, wc);
          *lpcName = leng;
          if (lpftLastWriteTime)
            g_memset (lpftLastWriteTime, 0, sizeof (FILETIME));
          lResult = ERROR_SUCCESS;
        }
      g_free (wc);
    }
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist, i));
  g_list_free (glist);
  return lResult;
}


/* RegEnumKeyW ordinal = 411, argument = 16 */
LONG WINAPI RegEnumKeyW (HKEY hKey, DWORD dwIndex, LPWSTR lpName, DWORD cchName)
{
  return RegEnumKeyExW (hKey, dwIndex, lpName, &cchName, NULL, NULL, NULL, NULL);
}


static GList *
reg_enum_value (HKEY hKey)
{
  gint i;
  GList *glist = NULL;

  for (i = 0; i < 2; i++)
    {
      gchar *file, **groups;
      GKeyFile *key_file;

      key_file = g_key_file_new ();
      file = w32ldr_dir_get_filename ("registry.ini",
                                i == 0 ? W32LDR_DIR_HOME : W32LDR_DIR_DATA);
      g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
      g_free (file);
      groups = g_key_file_get_groups (key_file, NULL);
      if (groups)
        {
          gint j;

          for (j = 0; groups[j]; j++)
            if (g_ascii_strcasecmp (groups[j], reg_handle (hKey)) == 0)
              {
                gchar **keys;

                keys = g_key_file_get_keys (key_file, groups[j], NULL, NULL);
                if (keys)
                  {
                    gint k;

                    for (k = 0; keys[k]; k++)
                      {
                        gchar *name;

                        name = reg_name_from_key (keys[k]);
                        if (name)
                          {
                            gint l;

                            for (l = g_list_length (glist) - 1; l >= 0; l--)
                              if (g_ascii_strcasecmp
                                    (g_list_nth_data (glist, l), name) == 0)
                                break;
                            if (l < 0)
                              glist = g_list_append (glist, name);
                            else
                              g_free (name);

                          }
                      }
                    g_strfreev (keys);
                  }
              }
          g_strfreev (groups);
        }
      g_key_file_free (key_file);
    }
  return glist;
}


/* RegEnumValueA ordinal = 412, argument = 32 */
LONG WINAPI RegEnumValueA (HKEY hKey, DWORD dwIndex, LPSTR lpValueName, LPDWORD lpcValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)
{
  gint i;
  GList *glist = NULL;
  LONG lResult = ERROR_NO_MORE_ITEMS;

  if (!hKey || !lpValueName || !lpcValueName || *lpcValueName <= 0)
    return ERROR_UNKNOWN;
  glist = reg_enum_value (hKey);
  if (g_list_nth_data (glist, dwIndex))
    {
      gchar *mb;
      gsize leng;

      mb = w32ldr_utf8_to_mb (g_list_nth_data (glist, dwIndex));
      leng = g_strlen (mb);
      if (leng < *lpcValueName)
        {
          g_strcpy (lpValueName, mb);
          *lpcValueName = leng;
          lResult = RegQueryValueExA (hKey, lpValueName,
                                            NULL, lpType, lpData, lpcbData);
        }
      g_free (mb);
    }
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist, i));
  g_list_free (glist);
  return lResult;
}


/* RegEnumValueW ordinal = 413, argument = 32 */
LONG WINAPI RegEnumValueW (HKEY hKey, DWORD dwIndex, LPWSTR lpValueName, LPDWORD lpcValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)
{
  gint i;
  GList *glist = NULL;
  LONG lResult = ERROR_NO_MORE_ITEMS;

  if (!hKey || !lpValueName || !lpcValueName || *lpcValueName <= 0)
    return ERROR_UNKNOWN;
  glist = reg_enum_value (hKey);
  if (g_list_nth_data (glist, dwIndex))
    {
      gsize leng;
      gunichar2 *wc;

      wc = g_utf8_to_utf16 (g_list_nth_data (glist, dwIndex), -1,
                                                            NULL, NULL, NULL);
      leng = lstrlenW (wc);
      if (leng < *lpcValueName)
        {
          lstrcpyW (lpValueName, wc);
          *lpcValueName = leng;
          lResult = RegQueryValueExW (hKey, lpValueName,
                                            NULL, lpType, lpData, lpcbData);
        }
      g_free (wc);
    }
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist, i));
  g_list_free (glist);
  return lResult;
}


/* RegFlushKey ordinal = 414, argument = 4 */
LONG WINAPI RegFlushKey (HKEY hKey)
{
  return ERROR_SUCCESS;
}


/* RegGetKeySecurity ordinal = 415, argument = 16 temporary */
static DWORD WINAPI RegGetKeySecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RegLoadKeyA ordinal = 416, argument = 12 */
LONG WINAPI RegLoadKeyA (HKEY hKey, LPCSTR lpSubKey, LPCSTR lpFile)
{
  gchar *utf8str;
  gunichar2 *sub, *file;
  LONG lResult;

  utf8str = w32ldr_utf8_from_mb (lpSubKey);
  sub = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  utf8str = w32ldr_utf8_from_mb (lpFile);
  file = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lResult = RegLoadKeyW (hKey, sub, file);
  g_free (sub);
  g_free (file);
  return lResult;
}


/* RegLoadKeyW ordinal = 417, argument = 12 */
LONG WINAPI RegLoadKeyW (HKEY hKey, LPCWSTR lpSubKey, LPCWSTR lpFile)
{
  return ERROR_UNKNOWN;
}


/* RegNotifyChangeKeyValue ordinal = 418, argument = 20 */
LONG WINAPI RegNotifyChangeKeyValue (HKEY hKey, BOOL bWatchSubtree, DWORD dwNotifyFilter, HANDLE hEvent, BOOL fAsynchronous)
{
  return ERROR_UNKNOWN;
}


/* RegOpenCurrentUser ordinal = 419, argument = 8 */
LONG WINAPI RegOpenCurrentUser (REGSAM samDesired, PHKEY phkResult)
{
  return RegCreateKeyA (HKEY_CURRENT_USER, NULL, phkResult);
}


/* RegOpenKeyA ordinal = 420, argument = 12 */
LONG WINAPI RegOpenKeyA (HKEY hKey, LPCSTR lpSubKey, PHKEY phkResult)
{
  return RegCreateKeyA (hKey, lpSubKey, phkResult);
}


/* RegOpenKeyExA ordinal = 421, argument = 20 */
LONG WINAPI RegOpenKeyExA (HKEY hKey, LPCSTR lpSubKey, DWORD ulOptions, REGSAM samDesired, PHKEY phkResult)
{
  return RegCreateKeyA (hKey, lpSubKey, phkResult);
}


/* RegOpenKeyExW ordinal = 422, argument = 20 */
LONG WINAPI RegOpenKeyExW (HKEY hKey, LPCWSTR lpSubKey, DWORD ulOptions, REGSAM samDesired, PHKEY phkResult)
{
  return RegCreateKeyW (hKey, lpSubKey, phkResult);
}


/* RegOpenKeyW ordinal = 423, argument = 12 */
LONG WINAPI RegOpenKeyW (HKEY hKey, LPCWSTR lpSubKey, PHKEY phkResult)
{
  return RegCreateKeyW (hKey, lpSubKey, phkResult);
}


/* RegOpenUserClassesRoot ordinal = 424, argument = 16 */
LONG WINAPI RegOpenUserClassesRoot (HANDLE hToken, DWORD dwOptions, REGSAM samDesired, PHKEY phkResult)
{
  return RegCreateKeyA (HKEY_CLASSES_ROOT, NULL, phkResult);
}


/* RegOverridePredefKey ordinal = 425, argument = 8 */
LONG WINAPI RegOverridePredefKey (HKEY hKey, HKEY hNewHKey)
{
  return ERROR_UNKNOWN;
}


/* RegQueryInfoKeyA ordinal = 426, argument = 48 temporary */
static DWORD WINAPI RegQueryInfoKeyA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* RegQueryInfoKeyW ordinal = 427, argument = 48 temporary */
static DWORD WINAPI RegQueryInfoKeyW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* RegQueryMultipleValuesA ordinal = 428, argument = 20 temporary */
static DWORD WINAPI RegQueryMultipleValuesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RegQueryMultipleValuesW ordinal = 429, argument = 20 temporary */
static DWORD WINAPI RegQueryMultipleValuesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RegQueryValueA ordinal = 430, argument = 16 */
LONG WINAPI RegQueryValueA (HKEY hKey, LPCSTR lpSubKey, LPSTR lpValue, PLONG lpcbValue)
{
  return RegQueryValueExA (hKey, lpSubKey, NULL, NULL,
                                        (LPBYTE)lpValue, (LPDWORD)lpcbValue);
}


/* RegQueryValueExA ordinal = 431, argument = 24 */
LONG WINAPI RegQueryValueExA (HKEY hKey, LPCSTR lpValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)
{
  gchar *str = NULL;
  gint i;
  LONG lResult = ERROR_UNKNOWN;

  if (!hKey)
    return ERROR_UNKNOWN;
  for (i = 0; i < 2 && !str; i++)
    {
      gchar *file, *group, *key, *utf8str;
      GKeyFile *key_file;

      key_file = g_key_file_new ();
      file = w32ldr_dir_get_filename ("registry.ini",
                                i == 0 ? W32LDR_DIR_HOME : W32LDR_DIR_DATA);
      g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
      g_free (file);
      group = g_strdup (reg_handle (hKey));
      utf8str = w32ldr_utf8_from_mb (lpValueName);
      key = reg_name_to_key (utf8str);
      g_free (utf8str);
      reg_search (key_file, &group, &key);
      str = g_key_file_get_value (key_file, group, key, NULL);
      g_free (group);
      g_free (key);
      g_key_file_free (key_file);
    }
  if (str)
    {
      gsize leng;

      g_strstrip (str);
      leng = g_strlen (str);
      if (leng >= 2 && str[0] == '\"' && str[leng - 1] == '\"')
        {
          /* ja:文字列 */
          if (lpcbData)
            {
              gchar *mb, *tmp;

              g_memmove (str, str + 1, leng - 2);
              str[leng - 2] = '\0';
              tmp = g_strcompress (str);
              mb = w32ldr_utf8_to_mb (tmp);
              g_free (tmp);
              leng = (g_strlen (mb) + 1) * sizeof (gchar);
              if (lpData && *lpcbData >= leng)
                g_strcpy ((gchar *)lpData, mb);
              g_free (mb);
              *lpcbData = leng;
            }
          if (lpType)
            *lpType = REG_SZ;
          lResult = ERROR_SUCCESS;
        }
      else if (g_ascii_strncasecmp (str, "hex:", 4) == 0)
        {
          /* ja:バイナリ */
          if (lpcbData)
            {
              guint8 *array;

              for (i = 4; str[i] != '\0'; i++)
                if (!g_ascii_isxdigit (str[i]))
                  str[i] = ' ';
              array = misc_str_to_array (&leng, 8, str + 4, 16, FALSE);
              if (lpData && *lpcbData >= leng)
                g_memmove (lpData, array, leng);
              *lpcbData = leng;
              g_free (array);
            }
          if (lpType)
            *lpType = REG_BINARY;
          lResult = ERROR_SUCCESS;
        }
      else if (g_ascii_strncasecmp (str, "dword:", 6) == 0)
        {
          /* en:DWORD */
          if (lpcbData)
            {
              if (lpData && *lpcbData > sizeof (DWORD))
                {
                  gint value;

                  misc_str_to_val (&value, str + 6, 16, FALSE);
                  *(LPDWORD)lpData = value;
                }
              *lpcbData = sizeof (DWORD);
            }
          if (lpType)
            *lpType = REG_DWORD;
          lResult = ERROR_SUCCESS;
        }
      g_free (str);
    }
  return lResult;
}


/* RegQueryValueExW ordinal = 432, argument = 24 */
LONG WINAPI RegQueryValueExW (HKEY hKey, LPCWSTR lpValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)
{
  gchar *str;
  gint i;
  LONG lResult = ERROR_UNKNOWN;

  if (!hKey)
    return ERROR_UNKNOWN;
  for (i = 0; i < 2; i++)
    {
      gchar *file, *group, *key, *utf8str;
      GKeyFile *key_file;

      key_file = g_key_file_new ();
      file = w32ldr_dir_get_filename ("registry.ini",
                                i == 0 ? W32LDR_DIR_HOME : W32LDR_DIR_DATA);
      g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
      g_free (file);
      group = g_strdup (reg_handle (hKey));
      utf8str = g_utf16_to_utf8 (lpValueName, -1, NULL, NULL, NULL);
      key = reg_name_to_key (utf8str);
      g_free (utf8str);
      reg_search (key_file, &group, &key);
      str = g_key_file_get_value (key_file, group, key, NULL);
      g_free (group);
      g_free (key);
      g_key_file_free (key_file);
      if (str)
        break;
    }
  if (str)
    {
      gsize leng;

      g_strstrip (str);
      leng = g_strlen (str);
      if (leng >= 2 && str[0] == '\"' && str[leng - 1] == '\"')
        {
          /* ja:文字列 */
          if (lpcbData)
            {
              gchar *tmp;
              gunichar2 *wc;

              g_memmove (str, str + 1, leng - 2);
              str[leng - 2] = '\0';
              tmp = g_strcompress (str);
              wc = g_utf8_to_utf16 (tmp, -1, NULL, NULL, NULL);
              g_free (tmp);
              leng = (lstrlenW (wc) + 1) * sizeof (gunichar2);
              if (lpData && *lpcbData >= leng)
                lstrcpyW ((gunichar2 *)lpData, wc);
              g_free (wc);
              *lpcbData = leng;
            }
          if (lpType)
            *lpType = REG_SZ;
          lResult = ERROR_SUCCESS;
        }
      else if (g_ascii_strncasecmp (str, "hex:", 4) == 0)
        {
          /* ja:バイナリ */
          if (lpcbData)
            {
              guint8 *array;

              for (i = 4; str[i] != '\0'; i++)
                if (!g_ascii_isxdigit (str[i]))
                  str[i] = ' ';
              array = misc_str_to_array (&leng, 8, str + 4, 16, FALSE);
              if (lpData && *lpcbData >= leng)
                g_memmove (lpData, array, leng);
              *lpcbData = leng;
              g_free (array);
            }
          if (lpType)
            *lpType = REG_BINARY;
          lResult = ERROR_SUCCESS;
        }
      else if (g_ascii_strncasecmp (str, "dword:", 6) == 0)
        {
          /* en:DWORD */
          if (lpcbData)
            {
              if (lpData && *lpcbData > sizeof (DWORD))
                {
                  gint value;

                  misc_str_to_val (&value, str + 6, 16, FALSE);
                  *(LPDWORD)lpData = value;
                }
              *lpcbData = sizeof (DWORD);
            }
          if (lpType)
            *lpType = REG_DWORD;
          lResult = ERROR_SUCCESS;
        }
      g_free (str);
    }
  return lResult;
}


/* RegQueryValueW ordinal = 433, argument = 16 */
LONG WINAPI RegQueryValueW (HKEY hKey, LPCWSTR lpSubKey, LPSTR lpValue, PLONG lpcbValue)
{
  return RegQueryValueExW (hKey, lpSubKey, NULL, NULL,
                                        (LPBYTE)lpValue, (LPDWORD)lpcbValue);
}


/* RegReplaceKeyA ordinal = 434, argument = 16 */
LONG WINAPI RegReplaceKeyA (HKEY hKey, LPCSTR lpSubKey, LPCSTR lpNewFile, LPCSTR lpOldFile)
{
  gchar *utf8str;
  gunichar2 *subkey, *newfile, *oldfile;
  LONG lResult;

  utf8str = w32ldr_utf8_from_mb (lpSubKey);
  subkey = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  utf8str = w32ldr_utf8_from_mb (lpNewFile);
  newfile = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  utf8str = w32ldr_utf8_from_mb (lpOldFile);
  oldfile = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lResult = RegReplaceKeyW (hKey, subkey, newfile, oldfile);
  g_free (subkey);
  g_free (newfile);
  g_free (oldfile);
  return lResult;
}


/* RegReplaceKeyW ordinal = 435, argument = 16 */
LONG WINAPI RegReplaceKeyW (HKEY hKey, LPCWSTR lpSubKey, LPCWSTR lpNewFile, LPCWSTR lpOldFile)
{
  return ERROR_UNKNOWN;
}


/* RegRestoreKeyA ordinal = 436, argument = 12 */
LONG WINAPI RegRestoreKeyA (HKEY hKey, LPCSTR lpFile, DWORD dwFlags)
{
  gchar *utf8str;
  gunichar2 *file;
  LONG lResult;

  utf8str = w32ldr_utf8_from_mb (lpFile);
  file = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lResult = RegRestoreKeyW (hKey, file, dwFlags);
  g_free (file);
  return lResult;
}


/* RegRestoreKeyW ordinal = 437, argument = 12 */
LONG WINAPI RegRestoreKeyW (HKEY hKey, LPCWSTR lpFile, DWORD dwFlags)
{
  return ERROR_UNKNOWN;
}


/* RegSaveKeyA ordinal = 438, argument = 12 */
LONG WINAPI RegSaveKeyA (HKEY hKey, LPCSTR lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
  gchar *utf8str;
  gunichar2 *file;
  LONG lResult;

  utf8str = w32ldr_utf8_from_mb (lpFile);
  file = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lResult = RegSaveKeyW (hKey, file, lpSecurityAttributes);
  g_free (file);
  return lResult;
}


/* RegSaveKeyW ordinal = 439, argument = 12 */
LONG WINAPI RegSaveKeyW (HKEY hKey, LPCWSTR lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
  return ERROR_UNKNOWN;
}


/* RegSetKeySecurity ordinal = 440, argument = 12 temporary */
static DWORD WINAPI RegSetKeySecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RegSetValueA ordinal = 441, argument = 20 */
LONG WINAPI RegSetValueA (HKEY hKey, LPCSTR lpSubKey, DWORD dwType, LPCSTR lpData, DWORD cbData)
{
  return RegSetValueExA (hKey, lpSubKey, 0, 0, (CONST BYTE *)lpData, cbData);
}


/* RegSetValueExA ordinal = 442, argument = 24 */
LONG WINAPI RegSetValueExA (HKEY hKey, LPCSTR lpValueName, DWORD Reserved, DWORD dwType, CONST BYTE *lpData, DWORD cbData)
{
  gboolean result = FALSE;
  gsize length;
  gchar *file, *group, *key, *str, *utf8str, *data;
  GKeyFile *key_file;

  if (!hKey || !lpData || cbData <= 0)
    return ERROR_UNKNOWN;
  switch (dwType)
    {
      case REG_BINARY:
        {
          gchar *tmp;
          gint i;

          tmp = misc_str_from_array (lpData, cbData, 8, 16, -2, FALSE);
          for (i = 0; tmp[i] != '\0'; i++)
            if (tmp[i] == ' ')
              tmp[i] = ',';
          str = g_strconcat ("hex:", tmp, NULL);
          g_free (tmp);
          break;
        }
      case REG_SZ:
        {
          gchar *tmp;

          utf8str = w32ldr_utf8_from_mb ((const gchar *)lpData);
          tmp = g_strescape (utf8str, exceptions);
          g_free (utf8str);
          str = g_strconcat ("\"", tmp, "\"", NULL);
          g_free (tmp);
          break;
        }
      case REG_DWORD:
        if (cbData >= sizeof (DWORD))
          {
            gchar *tmp;

            tmp = misc_str_from_val (*(LPDWORD)lpData, 16, 0, FALSE);
            str = g_strconcat ("dword:", tmp, NULL);
            g_free (tmp);
            break;
          }
      default:
        return ERROR_UNKNOWN;
    }
  file = w32ldr_dir_get_filename ("registry.ini", W32LDR_DIR_HOME);
  key_file = g_key_file_new ();
  g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);

  group = g_strdup (reg_handle (hKey));
  utf8str = w32ldr_utf8_from_mb (lpValueName);
  key = reg_name_to_key (utf8str);
  g_free (utf8str);
  reg_search (key_file, &group, &key);
  g_key_file_set_value (key_file, group, key, str);
  g_free (group);
  g_free (key);
  g_free (str);

  data = g_key_file_to_data (key_file, &length, NULL);
  g_key_file_free (key_file);
  if (data)
    {
      result = fileio_save (file, data, length);
      g_free (data);
    }
  g_free (file);
  return result ? ERROR_SUCCESS : ERROR_UNKNOWN;
}


/* RegSetValueExW ordinal = 443, argument = 24 */
LONG WINAPI RegSetValueExW (HKEY hKey, LPCWSTR lpValueName, DWORD Reserved, DWORD dwType, CONST BYTE *lpData, DWORD cbData)
{
  gboolean result = FALSE;
  gsize length;
  gchar *file, *group, *key, *str, *utf8str, *data;
  GKeyFile *key_file;

  if (!hKey || !lpData || cbData <= 0)
    return ERROR_UNKNOWN;
  switch (dwType)
    {
      case REG_BINARY:
        {
          gchar *tmp;
          gint i;

          tmp = misc_str_from_array (lpData, cbData, 8, 16, -2, FALSE);
          for (i = 0; tmp[i] != '\0'; i++)
            if (tmp[i] == ' ')
              tmp[i] = ',';
          str = g_strconcat ("hex:", tmp, NULL);
          g_free (tmp);
          break;
        }
      case REG_SZ:
        {
          gchar *tmp;

          utf8str = g_utf16_to_utf8 ((gunichar2 *)lpData, -1,
                                                            NULL, NULL, NULL);
          tmp = g_strescape (utf8str, exceptions);
          g_free (utf8str);
          str = g_strconcat ("\"", tmp, "\"", NULL);
          g_free (tmp);
          break;
        }
      case REG_DWORD:
        if (cbData >= sizeof (DWORD))
          {
            gchar *tmp;

            tmp = misc_str_from_val (*(LPDWORD)lpData, 16, 0, FALSE);
            str = g_strconcat ("dword:", tmp, NULL);
            g_free (tmp);
            break;
          }
      default:
        return ERROR_UNKNOWN;
    }
  key_file = g_key_file_new ();
  file = w32ldr_dir_get_filename ("registry.ini", W32LDR_DIR_HOME);
  g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);

  group = g_strdup (reg_handle (hKey));
  utf8str = g_utf16_to_utf8 (lpValueName, -1, NULL, NULL, NULL);
  key = reg_name_to_key (utf8str);
  g_free (utf8str);
  reg_search (key_file, &group, &key);
  g_key_file_set_string (key_file, group, key, str);
  g_free (group);
  g_free (key);
  g_free (str);

  data = g_key_file_to_data (key_file, &length, NULL);
  g_key_file_free (key_file);
  if (data)
    {
      result = fileio_save (file, data, length);
      g_free (data);
    }
  g_free (file);
  return result ? ERROR_SUCCESS : ERROR_UNKNOWN;
}


/* RegSetValueW ordinal = 444, argument = 20 */
LONG WINAPI RegSetValueW (HKEY hKey, LPCWSTR lpSubKey, DWORD dwType, LPCWSTR lpData, DWORD cbData)
{
  return RegSetValueExW (hKey, lpSubKey, 0, 0, (CONST BYTE *)lpData, cbData);
}


/* RegUnLoadKeyA ordinal = 445, argument = 8 */
LONG WINAPI RegUnLoadKeyA (HKEY hKey, LPCSTR lpSubKey)
{
  gchar *utf8str;
  gunichar2 *sub;
  LONG lResult;

  utf8str = w32ldr_utf8_from_mb (lpSubKey);
  sub = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lResult = RegUnLoadKeyW (hKey, sub);
  g_free (sub);
  return lResult;
}


/* RegUnLoadKeyW ordinal = 446, argument = 8 */
LONG WINAPI RegUnLoadKeyW (HKEY hKey, LPCWSTR lpSubKey)
{
  return ERROR_UNKNOWN;
}


/* RegisterEventSourceA ordinal = 447, argument = 8 temporary */
static DWORD WINAPI RegisterEventSourceA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RegisterEventSourceW ordinal = 448, argument = 8 temporary */
static DWORD WINAPI RegisterEventSourceW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RegisterServiceCtrlHandlerA ordinal = 449, argument = 8 temporary */
static DWORD WINAPI RegisterServiceCtrlHandlerA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RegisterServiceCtrlHandlerExA ordinal = 450, argument = 12 temporary */
static DWORD WINAPI RegisterServiceCtrlHandlerExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RegisterServiceCtrlHandlerExW ordinal = 451, argument = 12 temporary */
static DWORD WINAPI RegisterServiceCtrlHandlerExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RegisterServiceCtrlHandlerW ordinal = 452, argument = 8 temporary */
static DWORD WINAPI RegisterServiceCtrlHandlerW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RegisterTraceGuidsA ordinal = 453, argument = 32 temporary */
static DWORD WINAPI RegisterTraceGuidsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* RegisterTraceGuidsW ordinal = 454, argument = 32 temporary */
static DWORD WINAPI RegisterTraceGuidsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* RemoveTraceCallback ordinal = 455, argument = 4 temporary */
static DWORD WINAPI RemoveTraceCallback (DWORD dwArgv0)
{
  return 0;
}


/* RemoveUsersFromEncryptedFile ordinal = 456, argument = 8 temporary */
static DWORD WINAPI RemoveUsersFromEncryptedFile (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ReportEventA ordinal = 457, argument = 36 temporary */
static DWORD WINAPI ReportEventA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* ReportEventW ordinal = 458, argument = 36 temporary */
static DWORD WINAPI ReportEventW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* RevertToSelf ordinal = 459, argument = 0 temporary */
static DWORD WINAPI RevertToSelf (VOID)
{
  return 0;
}


/* SetAclInformation ordinal = 460, argument = 16 temporary */
static DWORD WINAPI SetAclInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetEntriesInAccessListA ordinal = 461, argument = 24 temporary */
static DWORD WINAPI SetEntriesInAccessListA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetEntriesInAccessListW ordinal = 462, argument = 24 temporary */
static DWORD WINAPI SetEntriesInAccessListW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetEntriesInAclA ordinal = 463, argument = 16 temporary */
static DWORD WINAPI SetEntriesInAclA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetEntriesInAclW ordinal = 464, argument = 16 temporary */
static DWORD WINAPI SetEntriesInAclW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetEntriesInAuditListA ordinal = 465, argument = 24 temporary */
static DWORD WINAPI SetEntriesInAuditListA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetEntriesInAuditListW ordinal = 466, argument = 24 temporary */
static DWORD WINAPI SetEntriesInAuditListW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetFileSecurityA ordinal = 467, argument = 12 temporary */
static DWORD WINAPI SetFileSecurityA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetFileSecurityW ordinal = 468, argument = 12 temporary */
static DWORD WINAPI SetFileSecurityW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetKernelObjectSecurity ordinal = 469, argument = 12 temporary */
static DWORD WINAPI SetKernelObjectSecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetNamedSecurityInfoA ordinal = 470, argument = 28 temporary */
static DWORD WINAPI SetNamedSecurityInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* SetNamedSecurityInfoExA ordinal = 471, argument = 36 temporary */
static DWORD WINAPI SetNamedSecurityInfoExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* SetNamedSecurityInfoExW ordinal = 472, argument = 36 temporary */
static DWORD WINAPI SetNamedSecurityInfoExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* SetNamedSecurityInfoW ordinal = 473, argument = 28 temporary */
static DWORD WINAPI SetNamedSecurityInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* SetPrivateObjectSecurity ordinal = 474, argument = 20 temporary */
static DWORD WINAPI SetPrivateObjectSecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SetPrivateObjectSecurityEx ordinal = 475, argument = 24 temporary */
static DWORD WINAPI SetPrivateObjectSecurityEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetSecurityDescriptorControl ordinal = 476, argument = 12 temporary */
static DWORD WINAPI SetSecurityDescriptorControl (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetSecurityDescriptorDacl ordinal = 477, argument = 16 temporary */
static DWORD WINAPI SetSecurityDescriptorDacl (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetSecurityDescriptorGroup ordinal = 478, argument = 12 temporary */
static DWORD WINAPI SetSecurityDescriptorGroup (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetSecurityDescriptorOwner ordinal = 479, argument = 12 temporary */
static DWORD WINAPI SetSecurityDescriptorOwner (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetSecurityDescriptorRMControl ordinal = 480, argument = 8 temporary */
static DWORD WINAPI SetSecurityDescriptorRMControl (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetSecurityDescriptorSacl ordinal = 481, argument = 16 temporary */
static DWORD WINAPI SetSecurityDescriptorSacl (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetSecurityInfo ordinal = 482, argument = 28 temporary */
static DWORD WINAPI SetSecurityInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* SetSecurityInfoExA ordinal = 483, argument = 36 temporary */
static DWORD WINAPI SetSecurityInfoExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* SetSecurityInfoExW ordinal = 484, argument = 36 temporary */
static DWORD WINAPI SetSecurityInfoExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* SetServiceBits ordinal = 485, argument = 16 temporary */
static DWORD WINAPI SetServiceBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetServiceObjectSecurity ordinal = 486, argument = 12 temporary */
static DWORD WINAPI SetServiceObjectSecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetServiceStatus ordinal = 487, argument = 8 temporary */
static DWORD WINAPI SetServiceStatus (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetThreadToken ordinal = 488, argument = 8 temporary */
static DWORD WINAPI SetThreadToken (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTokenInformation ordinal = 489, argument = 16 temporary */
static DWORD WINAPI SetTokenInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetTraceCallback ordinal = 490, argument = 8 temporary */
static DWORD WINAPI SetTraceCallback (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetUserFileEncryptionKey ordinal = 491, argument = 4 temporary */
static DWORD WINAPI SetUserFileEncryptionKey (DWORD dwArgv0)
{
  return 0;
}


/* StartServiceA ordinal = 492, argument = 12 temporary */
static DWORD WINAPI StartServiceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* StartServiceCtrlDispatcherA ordinal = 493, argument = 4 temporary */
static DWORD WINAPI StartServiceCtrlDispatcherA (DWORD dwArgv0)
{
  return 0;
}


/* StartServiceCtrlDispatcherW ordinal = 494, argument = 4 temporary */
static DWORD WINAPI StartServiceCtrlDispatcherW (DWORD dwArgv0)
{
  return 0;
}


/* StartServiceW ordinal = 495, argument = 12 temporary */
static DWORD WINAPI StartServiceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* StartTraceA ordinal = 496, argument = 12 temporary */
static DWORD WINAPI StartTraceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* StartTraceW ordinal = 497, argument = 12 temporary */
static DWORD WINAPI StartTraceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SynchronizeWindows31FilesAndWindowsNTRegistry ordinal = 498, argument = 0 temporary */
static DWORD WINAPI SynchronizeWindows31FilesAndWindowsNTRegistry (VOID)
{
  return 0;
}


/* SystemFunction001 ordinal = 499, argument = 12 temporary */
static DWORD WINAPI SystemFunction001 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction002 ordinal = 500, argument = 12 temporary */
static DWORD WINAPI SystemFunction002 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction003 ordinal = 501, argument = 8 temporary */
static DWORD WINAPI SystemFunction003 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemFunction004 ordinal = 502, argument = 12 temporary */
static DWORD WINAPI SystemFunction004 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction005 ordinal = 503, argument = 12 temporary */
static DWORD WINAPI SystemFunction005 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction006 ordinal = 504, argument = 8 temporary */
static DWORD WINAPI SystemFunction006 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemFunction007 ordinal = 505, argument = 8 temporary */
static DWORD WINAPI SystemFunction007 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemFunction008 ordinal = 506, argument = 12 temporary */
static DWORD WINAPI SystemFunction008 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction009 ordinal = 507, argument = 12 temporary */
static DWORD WINAPI SystemFunction009 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction010 ordinal = 508, argument = 12 temporary */
static DWORD WINAPI SystemFunction010 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction011 ordinal = 509, argument = 12 temporary */
static DWORD WINAPI SystemFunction011 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction012 ordinal = 510, argument = 12 temporary */
static DWORD WINAPI SystemFunction012 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction013 ordinal = 511, argument = 12 temporary */
static DWORD WINAPI SystemFunction013 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction014 ordinal = 512, argument = 12 temporary */
static DWORD WINAPI SystemFunction014 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction015 ordinal = 513, argument = 12 temporary */
static DWORD WINAPI SystemFunction015 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction016 ordinal = 514, argument = 12 temporary */
static DWORD WINAPI SystemFunction016 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction017 ordinal = 515, argument = 12 temporary */
static DWORD WINAPI SystemFunction017 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction018 ordinal = 516, argument = 12 temporary */
static DWORD WINAPI SystemFunction018 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction019 ordinal = 517, argument = 12 temporary */
static DWORD WINAPI SystemFunction019 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction020 ordinal = 518, argument = 12 temporary */
static DWORD WINAPI SystemFunction020 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction021 ordinal = 519, argument = 12 temporary */
static DWORD WINAPI SystemFunction021 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction022 ordinal = 520, argument = 12 temporary */
static DWORD WINAPI SystemFunction022 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction023 ordinal = 521, argument = 12 temporary */
static DWORD WINAPI SystemFunction023 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction024 ordinal = 522, argument = 12 temporary */
static DWORD WINAPI SystemFunction024 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction025 ordinal = 523, argument = 12 temporary */
static DWORD WINAPI SystemFunction025 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction026 ordinal = 524, argument = 12 temporary */
static DWORD WINAPI SystemFunction026 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction027 ordinal = 525, argument = 12 temporary */
static DWORD WINAPI SystemFunction027 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction028 ordinal = 526, argument = 8 temporary */
static DWORD WINAPI SystemFunction028 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemFunction029 ordinal = 527, argument = 8 temporary */
static DWORD WINAPI SystemFunction029 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemFunction030 ordinal = 528, argument = 8 temporary */
static DWORD WINAPI SystemFunction030 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemFunction031 ordinal = 529, argument = 8 temporary */
static DWORD WINAPI SystemFunction031 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemFunction032 ordinal = 530, argument = 8 temporary */
static DWORD WINAPI SystemFunction032 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemFunction033 ordinal = 531, argument = 8 temporary */
static DWORD WINAPI SystemFunction033 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemFunction034 ordinal = 532, argument = 12 temporary */
static DWORD WINAPI SystemFunction034 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction035 ordinal = 533, argument = 0 temporary */
static DWORD WINAPI SystemFunction035 (VOID)
{
  return 0;
}


/* SystemFunction040 ordinal = 534, argument = 12 temporary */
static DWORD WINAPI SystemFunction040 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SystemFunction041 ordinal = 535, argument = 12 temporary */
static DWORD WINAPI SystemFunction041 (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* TraceEvent ordinal = 536, argument = 12 temporary */
static DWORD WINAPI TraceEvent (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* TraceEventInstance ordinal = 537, argument = 20 temporary */
static DWORD WINAPI TraceEventInstance (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* TrusteeAccessToObjectA ordinal = 538, argument = 24 temporary */
static DWORD WINAPI TrusteeAccessToObjectA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* TrusteeAccessToObjectW ordinal = 539, argument = 24 temporary */
static DWORD WINAPI TrusteeAccessToObjectW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* UninstallApplication ordinal = 540, argument = 8 temporary */
static DWORD WINAPI UninstallApplication (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* UnlockServiceDatabase ordinal = 541, argument = 4 temporary */
static DWORD WINAPI UnlockServiceDatabase (DWORD dwArgv0)
{
  return 0;
}


/* UnregisterTraceGuids ordinal = 542, argument = 8 temporary */
static DWORD WINAPI UnregisterTraceGuids (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WmiCloseBlock ordinal = 543, argument = 0 temporary */
static DWORD WINAPI WmiCloseBlock (VOID)
{
  return 0;
}


/* WmiDevInstToInstanceNameA ordinal = 544, argument = 0 temporary */
static DWORD WINAPI WmiDevInstToInstanceNameA (VOID)
{
  return 0;
}


/* WmiDevInstToInstanceNameW ordinal = 545, argument = 0 temporary */
static DWORD WINAPI WmiDevInstToInstanceNameW (VOID)
{
  return 0;
}


/* WmiEnumerateGuids ordinal = 546, argument = 0 temporary */
static DWORD WINAPI WmiEnumerateGuids (VOID)
{
  return 0;
}


/* WmiExecuteMethodA ordinal = 547, argument = 0 temporary */
static DWORD WINAPI WmiExecuteMethodA (VOID)
{
  return 0;
}


/* WmiExecuteMethodW ordinal = 548, argument = 0 temporary */
static DWORD WINAPI WmiExecuteMethodW (VOID)
{
  return 0;
}


/* WmiFileHandleToInstanceNameA ordinal = 549, argument = 0 temporary */
static DWORD WINAPI WmiFileHandleToInstanceNameA (VOID)
{
  return 0;
}


/* WmiFileHandleToInstanceNameW ordinal = 550, argument = 0 temporary */
static DWORD WINAPI WmiFileHandleToInstanceNameW (VOID)
{
  return 0;
}


/* WmiFreeBuffer ordinal = 551, argument = 0 temporary */
static DWORD WINAPI WmiFreeBuffer (VOID)
{
  return 0;
}


/* WmiMofEnumerateResourcesA ordinal = 552, argument = 0 temporary */
static DWORD WINAPI WmiMofEnumerateResourcesA (VOID)
{
  return 0;
}


/* WmiMofEnumerateResourcesW ordinal = 553, argument = 0 temporary */
static DWORD WINAPI WmiMofEnumerateResourcesW (VOID)
{
  return 0;
}


/* WmiNotificationRegistrationA ordinal = 554, argument = 0 temporary */
static DWORD WINAPI WmiNotificationRegistrationA (VOID)
{
  return 0;
}


/* WmiNotificationRegistrationW ordinal = 555, argument = 0 temporary */
static DWORD WINAPI WmiNotificationRegistrationW (VOID)
{
  return 0;
}


/* WmiOpenBlock ordinal = 556, argument = 0 temporary */
static DWORD WINAPI WmiOpenBlock (VOID)
{
  return 0;
}


/* WmiQueryAllDataA ordinal = 557, argument = 0 temporary */
static DWORD WINAPI WmiQueryAllDataA (VOID)
{
  return 0;
}


/* WmiQueryAllDataW ordinal = 558, argument = 0 temporary */
static DWORD WINAPI WmiQueryAllDataW (VOID)
{
  return 0;
}


/* WmiQueryGuidInformation ordinal = 559, argument = 0 temporary */
static DWORD WINAPI WmiQueryGuidInformation (VOID)
{
  return 0;
}


/* WmiQuerySingleInstanceA ordinal = 560, argument = 0 temporary */
static DWORD WINAPI WmiQuerySingleInstanceA (VOID)
{
  return 0;
}


/* WmiQuerySingleInstanceW ordinal = 561, argument = 0 temporary */
static DWORD WINAPI WmiQuerySingleInstanceW (VOID)
{
  return 0;
}


/* WmiSetSingleInstanceA ordinal = 562, argument = 0 temporary */
static DWORD WINAPI WmiSetSingleInstanceA (VOID)
{
  return 0;
}


/* WmiSetSingleInstanceW ordinal = 563, argument = 0 temporary */
static DWORD WINAPI WmiSetSingleInstanceW (VOID)
{
  return 0;
}


/* WmiSetSingleItemA ordinal = 564, argument = 0 temporary */
static DWORD WINAPI WmiSetSingleItemA (VOID)
{
  return 0;
}


/* WmiSetSingleItemW ordinal = 565, argument = 0 temporary */
static DWORD WINAPI WmiSetSingleItemW (VOID)
{
  return 0;
}


/* WriteEncryptedFileRaw ordinal = 566, argument = 12 temporary */
static DWORD WINAPI WriteEncryptedFileRaw (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


W32LdrExport advapi32_exports[] = {
{FALSE,   4, "AbortSystemShutdownA",                                 AbortSystemShutdownA},
{FALSE,   5, "AbortSystemShutdownW",                                 AbortSystemShutdownW},
{FALSE,   6, "AccessCheck",                                          AccessCheck},
{FALSE,   7, "AccessCheckAndAuditAlarmA",                            AccessCheckAndAuditAlarmA},
{FALSE,   8, "AccessCheckAndAuditAlarmW",                            AccessCheckAndAuditAlarmW},
{FALSE,   9, "AccessCheckByType",                                    AccessCheckByType},
{FALSE,  10, "AccessCheckByTypeAndAuditAlarmA",                      AccessCheckByTypeAndAuditAlarmA},
{FALSE,  11, "AccessCheckByTypeAndAuditAlarmW",                      AccessCheckByTypeAndAuditAlarmW},
{FALSE,  12, "AccessCheckByTypeResultList",                          AccessCheckByTypeResultList},
{FALSE,  13, "AccessCheckByTypeResultListAndAuditAlarmA",            AccessCheckByTypeResultListAndAuditAlarmA},
{FALSE,  14, "AccessCheckByTypeResultListAndAuditAlarmByHandleA",    AccessCheckByTypeResultListAndAuditAlarmByHandleA},
{FALSE,  15, "AccessCheckByTypeResultListAndAuditAlarmByHandleW",    AccessCheckByTypeResultListAndAuditAlarmByHandleW},
{FALSE,  16, "AccessCheckByTypeResultListAndAuditAlarmW",            AccessCheckByTypeResultListAndAuditAlarmW},
{FALSE,  17, "AddAccessAllowedAce",                                  AddAccessAllowedAce},
{FALSE,  18, "AddAccessAllowedAceEx",                                AddAccessAllowedAceEx},
{FALSE,  19, "AddAccessAllowedObjectAce",                            AddAccessAllowedObjectAce},
{FALSE,  20, "AddAccessDeniedAce",                                   AddAccessDeniedAce},
{FALSE,  21, "AddAccessDeniedAceEx",                                 AddAccessDeniedAceEx},
{FALSE,  22, "AddAccessDeniedObjectAce",                             AddAccessDeniedObjectAce},
{FALSE,  23, "AddAce",                                               AddAce},
{FALSE,  24, "AddAuditAccessAce",                                    AddAuditAccessAce},
{FALSE,  25, "AddAuditAccessAceEx",                                  AddAuditAccessAceEx},
{FALSE,  26, "AddAuditAccessObjectAce",                              AddAuditAccessObjectAce},
{FALSE,  27, "AddUsersToEncryptedFile",                              AddUsersToEncryptedFile},
{FALSE,  28, "AdjustTokenGroups",                                    AdjustTokenGroups},
{FALSE,  29, "AdjustTokenPrivileges",                                AdjustTokenPrivileges},
{FALSE,  30, "AllocateAndInitializeSid",                             AllocateAndInitializeSid},
{FALSE,  31, "AllocateLocallyUniqueId",                              AllocateLocallyUniqueId},
{FALSE,  32, "AreAllAccessesGranted",                                AreAllAccessesGranted},
{FALSE,  33, "AreAnyAccessesGranted",                                AreAnyAccessesGranted},
{FALSE,  34, "BackupEventLogA",                                      BackupEventLogA},
{FALSE,  35, "BackupEventLogW",                                      BackupEventLogW},
{FALSE,  36, "BuildExplicitAccessWithNameA",                         BuildExplicitAccessWithNameA},
{FALSE,  37, "BuildExplicitAccessWithNameW",                         BuildExplicitAccessWithNameW},
{FALSE,  38, "BuildImpersonateExplicitAccessWithNameA",              BuildImpersonateExplicitAccessWithNameA},
{FALSE,  39, "BuildImpersonateExplicitAccessWithNameW",              BuildImpersonateExplicitAccessWithNameW},
{FALSE,  40, "BuildImpersonateTrusteeA",                             BuildImpersonateTrusteeA},
{FALSE,  41, "BuildImpersonateTrusteeW",                             BuildImpersonateTrusteeW},
{FALSE,  42, "BuildSecurityDescriptorA",                             BuildSecurityDescriptorA},
{FALSE,  43, "BuildSecurityDescriptorW",                             BuildSecurityDescriptorW},
{FALSE,  44, "BuildTrusteeWithNameA",                                BuildTrusteeWithNameA},
{FALSE,  45, "BuildTrusteeWithNameW",                                BuildTrusteeWithNameW},
{FALSE,  46, "BuildTrusteeWithObjectsAndNameA",                      BuildTrusteeWithObjectsAndNameA},
{FALSE,  47, "BuildTrusteeWithObjectsAndNameW",                      BuildTrusteeWithObjectsAndNameW},
{FALSE,  48, "BuildTrusteeWithObjectsAndSidA",                       BuildTrusteeWithObjectsAndSidA},
{FALSE,  49, "BuildTrusteeWithObjectsAndSidW",                       BuildTrusteeWithObjectsAndSidW},
{FALSE,  50, "BuildTrusteeWithSidA",                                 BuildTrusteeWithSidA},
{FALSE,  51, "BuildTrusteeWithSidW",                                 BuildTrusteeWithSidW},
{FALSE,  52, "CancelOverlappedAccess",                               CancelOverlappedAccess},
{FALSE,  53, "ChangeServiceConfig2A",                                ChangeServiceConfig2A},
{FALSE,  54, "ChangeServiceConfig2W",                                ChangeServiceConfig2W},
{FALSE,  55, "ChangeServiceConfigA",                                 ChangeServiceConfigA},
{FALSE,  56, "ChangeServiceConfigW",                                 ChangeServiceConfigW},
{FALSE,  57, "CheckTokenMembership",                                 CheckTokenMembership},
{FALSE,  58, "ClearEventLogA",                                       ClearEventLogA},
{FALSE,  59, "ClearEventLogW",                                       ClearEventLogW},
{FALSE,  60, "CloseEncryptedFileRaw",                                CloseEncryptedFileRaw},
{FALSE,  61, "CloseEventLog",                                        CloseEventLog},
{FALSE,  62, "CloseServiceHandle",                                   CloseServiceHandle},
{FALSE,  63, "CloseTrace",                                           CloseTrace},
{FALSE,  64, "CommandLineFromMsiDescriptor",                         CommandLineFromMsiDescriptor},
{FALSE,  65, "ControlService",                                       ControlService},
{FALSE,  66, "ControlTraceA",                                        ControlTraceA},
{FALSE,  67, "ControlTraceW",                                        ControlTraceW},
{FALSE,  68, "ConvertAccessToSecurityDescriptorA",                   ConvertAccessToSecurityDescriptorA},
{FALSE,  69, "ConvertAccessToSecurityDescriptorW",                   ConvertAccessToSecurityDescriptorW},
{FALSE,  70, "ConvertSDToStringSDRootDomainA",                       ConvertSDToStringSDRootDomainA},
{FALSE,  71, "ConvertSDToStringSDRootDomainW",                       ConvertSDToStringSDRootDomainW},
{FALSE,  72, "ConvertSecurityDescriptorToAccessA",                   ConvertSecurityDescriptorToAccessA},
{FALSE,  73, "ConvertSecurityDescriptorToAccessNamedA",              ConvertSecurityDescriptorToAccessNamedA},
{FALSE,  74, "ConvertSecurityDescriptorToAccessNamedW",              ConvertSecurityDescriptorToAccessNamedW},
{FALSE,  75, "ConvertSecurityDescriptorToAccessW",                   ConvertSecurityDescriptorToAccessW},
{FALSE,  76, "ConvertSecurityDescriptorToStringSecurityDescriptorA", ConvertSecurityDescriptorToStringSecurityDescriptorA},
{FALSE,  77, "ConvertSecurityDescriptorToStringSecurityDescriptorW", ConvertSecurityDescriptorToStringSecurityDescriptorW},
{FALSE,  78, "ConvertSidToStringSidA",                               ConvertSidToStringSidA},
{FALSE,  79, "ConvertSidToStringSidW",                               ConvertSidToStringSidW},
{FALSE,  80, "ConvertStringSDToSDRootDomainA",                       ConvertStringSDToSDRootDomainA},
{FALSE,  81, "ConvertStringSDToSDRootDomainW",                       ConvertStringSDToSDRootDomainW},
{FALSE,  82, "ConvertStringSecurityDescriptorToSecurityDescriptorA", ConvertStringSecurityDescriptorToSecurityDescriptorA},
{FALSE,  83, "ConvertStringSecurityDescriptorToSecurityDescriptorW", ConvertStringSecurityDescriptorToSecurityDescriptorW},
{FALSE,  84, "ConvertStringSidToSidA",                               ConvertStringSidToSidA},
{FALSE,  85, "ConvertStringSidToSidW",                               ConvertStringSidToSidW},
{FALSE,  86, "ConvertToAutoInheritPrivateObjectSecurity",            ConvertToAutoInheritPrivateObjectSecurity},
{FALSE,  87, "CopySid",                                              CopySid},
{FALSE,  88, "CreatePrivateObjectSecurity",                          CreatePrivateObjectSecurity},
{FALSE,  89, "CreatePrivateObjectSecurityEx",                        CreatePrivateObjectSecurityEx},
{FALSE,  90, "CreateProcessAsUserA",                                 CreateProcessAsUserA},
{FALSE,  91, "CreateProcessAsUserSecure",                            CreateProcessAsUserSecure},
{FALSE,  92, "CreateProcessAsUserW",                                 CreateProcessAsUserW},
{FALSE,  93, "CreateProcessWithLogonW",                              CreateProcessWithLogonW},
{FALSE,  94, "CreateRestrictedToken",                                CreateRestrictedToken},
{FALSE,  95, "CreateServiceA",                                       CreateServiceA},
{FALSE,  96, "CreateServiceW",                                       CreateServiceW},
{FALSE,  97, "CreateTraceInstanceId",                                CreateTraceInstanceId},
{FALSE,  98, "CreateWellKnownSid",                                   CreateWellKnownSid},
{FALSE,  99, "CryptAcquireContextA",                                 CryptAcquireContextA},
{FALSE, 100, "CryptAcquireContextW",                                 CryptAcquireContextW},
{FALSE, 101, "CryptContextAddRef",                                   CryptContextAddRef},
{FALSE, 102, "CryptCreateHash",                                      CryptCreateHash},
{FALSE, 103, "CryptDecrypt",                                         CryptDecrypt},
{FALSE, 104, "CryptDeriveKey",                                       CryptDeriveKey},
{FALSE, 105, "CryptDestroyHash",                                     CryptDestroyHash},
{FALSE, 106, "CryptDestroyKey",                                      CryptDestroyKey},
{FALSE, 107, "CryptDuplicateHash",                                   CryptDuplicateHash},
{FALSE, 108, "CryptDuplicateKey",                                    CryptDuplicateKey},
{FALSE, 109, "CryptEncrypt",                                         CryptEncrypt},
{FALSE, 110, "CryptEnumProviderTypesA",                              CryptEnumProviderTypesA},
{FALSE, 111, "CryptEnumProviderTypesW",                              CryptEnumProviderTypesW},
{FALSE, 112, "CryptEnumProvidersA",                                  CryptEnumProvidersA},
{FALSE, 113, "CryptEnumProvidersW",                                  CryptEnumProvidersW},
{FALSE, 114, "CryptExportKey",                                       CryptExportKey},
{FALSE, 115, "CryptGenKey",                                          CryptGenKey},
{FALSE, 116, "CryptGenRandom",                                       CryptGenRandom},
{FALSE, 117, "CryptGetDefaultProviderA",                             CryptGetDefaultProviderA},
{FALSE, 118, "CryptGetDefaultProviderW",                             CryptGetDefaultProviderW},
{FALSE, 119, "CryptGetHashParam",                                    CryptGetHashParam},
{FALSE, 120, "CryptGetKeyParam",                                     CryptGetKeyParam},
{FALSE, 121, "CryptGetProvParam",                                    CryptGetProvParam},
{FALSE, 122, "CryptGetUserKey",                                      CryptGetUserKey},
{FALSE, 123, "CryptHashData",                                        CryptHashData},
{FALSE, 124, "CryptHashSessionKey",                                  CryptHashSessionKey},
{FALSE, 125, "CryptImportKey",                                       CryptImportKey},
{FALSE, 126, "CryptReleaseContext",                                  CryptReleaseContext},
{FALSE, 127, "CryptSetHashParam",                                    CryptSetHashParam},
{FALSE, 128, "CryptSetKeyParam",                                     CryptSetKeyParam},
{FALSE, 129, "CryptSetProvParam",                                    CryptSetProvParam},
{FALSE, 130, "CryptSetProviderA",                                    CryptSetProviderA},
{FALSE, 131, "CryptSetProviderExA",                                  CryptSetProviderExA},
{FALSE, 132, "CryptSetProviderExW",                                  CryptSetProviderExW},
{FALSE, 133, "CryptSetProviderW",                                    CryptSetProviderW},
{FALSE, 134, "CryptSignHashA",                                       CryptSignHashA},
{FALSE, 135, "CryptSignHashW",                                       CryptSignHashW},
{FALSE, 136, "CryptVerifySignatureA",                                CryptVerifySignatureA},
{FALSE, 137, "CryptVerifySignatureW",                                CryptVerifySignatureW},
{FALSE, 138, "DecryptFileA",                                         DecryptFileA},
{FALSE, 139, "DecryptFileW",                                         DecryptFileW},
{FALSE, 140, "DeleteAce",                                            DeleteAce},
{FALSE, 141, "DeleteService",                                        DeleteService},
{FALSE, 142, "DeregisterEventSource",                                DeregisterEventSource},
{FALSE, 143, "DestroyPrivateObjectSecurity",                         DestroyPrivateObjectSecurity},
{FALSE, 144, "DuplicateEncryptionInfoFile",                          DuplicateEncryptionInfoFile},
{FALSE, 145, "DuplicateToken",                                       DuplicateToken},
{FALSE, 146, "DuplicateTokenEx",                                     DuplicateTokenEx},
{FALSE, 147, "ElfBackupEventLogFileA",                               ElfBackupEventLogFileA},
{FALSE, 148, "ElfBackupEventLogFileW",                               ElfBackupEventLogFileW},
{FALSE, 149, "ElfChangeNotify",                                      ElfChangeNotify},
{FALSE, 150, "ElfClearEventLogFileA",                                ElfClearEventLogFileA},
{FALSE, 151, "ElfClearEventLogFileW",                                ElfClearEventLogFileW},
{FALSE, 152, "ElfCloseEventLog",                                     ElfCloseEventLog},
{FALSE, 153, "ElfDeregisterEventSource",                             ElfDeregisterEventSource},
{FALSE, 154, "ElfFlushEventLog",                                     ElfFlushEventLog},
{FALSE, 155, "ElfNumberOfRecords",                                   ElfNumberOfRecords},
{FALSE, 156, "ElfOldestRecord",                                      ElfOldestRecord},
{FALSE, 157, "ElfOpenBackupEventLogA",                               ElfOpenBackupEventLogA},
{FALSE, 158, "ElfOpenBackupEventLogW",                               ElfOpenBackupEventLogW},
{FALSE, 159, "ElfOpenEventLogA",                                     ElfOpenEventLogA},
{FALSE, 160, "ElfOpenEventLogW",                                     ElfOpenEventLogW},
{FALSE, 161, "ElfReadEventLogA",                                     ElfReadEventLogA},
{FALSE, 162, "ElfReadEventLogW",                                     ElfReadEventLogW},
{FALSE, 163, "ElfRegisterEventSourceA",                              ElfRegisterEventSourceA},
{FALSE, 164, "ElfRegisterEventSourceW",                              ElfRegisterEventSourceW},
{FALSE, 165, "ElfReportEventA",                                      ElfReportEventA},
{FALSE, 166, "ElfReportEventW",                                      ElfReportEventW},
{FALSE, 167, "EnableTrace",                                          EnableTrace},
{FALSE, 168, "EncryptFileA",                                         EncryptFileA},
{FALSE, 169, "EncryptFileW",                                         EncryptFileW},
{FALSE, 170, "EncryptionDisable",                                    EncryptionDisable},
{FALSE, 171, "EnumDependentServicesA",                               EnumDependentServicesA},
{FALSE, 172, "EnumDependentServicesW",                               EnumDependentServicesW},
{FALSE, 173, "EnumServiceGroupW",                                    EnumServiceGroupW},
{FALSE, 174, "EnumServicesStatusA",                                  EnumServicesStatusA},
{FALSE, 175, "EnumServicesStatusExA",                                EnumServicesStatusExA},
{FALSE, 176, "EnumServicesStatusExW",                                EnumServicesStatusExW},
{FALSE, 177, "EnumServicesStatusW",                                  EnumServicesStatusW},
{FALSE, 178, "EqualDomainSid",                                       EqualDomainSid},
{FALSE, 179, "EqualPrefixSid",                                       EqualPrefixSid},
{FALSE, 180, "EqualSid",                                             EqualSid},
{FALSE, 181, "FileEncryptionStatusA",                                FileEncryptionStatusA},
{FALSE, 182, "FileEncryptionStatusW",                                FileEncryptionStatusW},
{FALSE, 183, "FindFirstFreeAce",                                     FindFirstFreeAce},
{FALSE, 184, "FreeEncryptionCertificateHashList",                    FreeEncryptionCertificateHashList},
{FALSE, 185, "FreeSid",                                              FreeSid},
{FALSE, 186, "GetAccessPermissionsForObjectA",                       GetAccessPermissionsForObjectA},
{FALSE, 187, "GetAccessPermissionsForObjectW",                       GetAccessPermissionsForObjectW},
{FALSE, 188, "GetAce",                                               GetAce},
{FALSE, 189, "GetAclInformation",                                    GetAclInformation},
{FALSE, 190, "GetAuditedPermissionsFromAclA",                        GetAuditedPermissionsFromAclA},
{FALSE, 191, "GetAuditedPermissionsFromAclW",                        GetAuditedPermissionsFromAclW},
{FALSE, 192, "GetCurrentHwProfileA",                                 GetCurrentHwProfileA},
{FALSE, 193, "GetCurrentHwProfileW",                                 GetCurrentHwProfileW},
{FALSE, 194, "GetEffectiveRightsFromAclA",                           GetEffectiveRightsFromAclA},
{FALSE, 195, "GetEffectiveRightsFromAclW",                           GetEffectiveRightsFromAclW},
{FALSE, 196, "GetEventLogInformation",                               GetEventLogInformation},
{FALSE, 197, "GetExplicitEntriesFromAclA",                           GetExplicitEntriesFromAclA},
{FALSE, 198, "GetExplicitEntriesFromAclW",                           GetExplicitEntriesFromAclW},
{FALSE, 199, "GetFileSecurityA",                                     GetFileSecurityA},
{FALSE, 200, "GetFileSecurityW",                                     GetFileSecurityW},
{FALSE, 201, "GetKernelObjectSecurity",                              GetKernelObjectSecurity},
{FALSE, 202, "GetLengthSid",                                         GetLengthSid},
{FALSE, 203, "GetLocalManagedApplications",                          GetLocalManagedApplications},
{FALSE, 204, "GetManagedApplications",                               GetManagedApplications},
{FALSE, 205, "GetMangledSiteSid",                                    GetMangledSiteSid},
{FALSE, 206, "GetMultipleTrusteeA",                                  GetMultipleTrusteeA},
{FALSE, 207, "GetMultipleTrusteeOperationA",                         GetMultipleTrusteeOperationA},
{FALSE, 208, "GetMultipleTrusteeOperationW",                         GetMultipleTrusteeOperationW},
{FALSE, 209, "GetMultipleTrusteeW",                                  GetMultipleTrusteeW},
{FALSE, 210, "GetNamedSecurityInfoA",                                GetNamedSecurityInfoA},
{FALSE, 211, "GetNamedSecurityInfoExA",                              GetNamedSecurityInfoExA},
{FALSE, 212, "GetNamedSecurityInfoExW",                              GetNamedSecurityInfoExW},
{FALSE, 213, "GetNamedSecurityInfoW",                                GetNamedSecurityInfoW},
{FALSE, 214, "GetNumberOfEventLogRecords",                           GetNumberOfEventLogRecords},
{FALSE, 215, "GetOldestEventLogRecord",                              GetOldestEventLogRecord},
{FALSE, 216, "GetOverlappedAccessResults",                           GetOverlappedAccessResults},
{FALSE, 217, "GetPrivateObjectSecurity",                             GetPrivateObjectSecurity},
{FALSE, 218, "GetSecurityDescriptorControl",                         GetSecurityDescriptorControl},
{FALSE, 219, "GetSecurityDescriptorDacl",                            GetSecurityDescriptorDacl},
{FALSE, 220, "GetSecurityDescriptorGroup",                           GetSecurityDescriptorGroup},
{FALSE, 221, "GetSecurityDescriptorLength",                          GetSecurityDescriptorLength},
{FALSE, 222, "GetSecurityDescriptorOwner",                           GetSecurityDescriptorOwner},
{FALSE, 223, "GetSecurityDescriptorRMControl",                       GetSecurityDescriptorRMControl},
{FALSE, 224, "GetSecurityDescriptorSacl",                            GetSecurityDescriptorSacl},
{FALSE, 225, "GetSecurityInfo",                                      GetSecurityInfo},
{FALSE, 226, "GetSecurityInfoExA",                                   GetSecurityInfoExA},
{FALSE, 227, "GetSecurityInfoExW",                                   GetSecurityInfoExW},
{FALSE, 228, "GetServiceDisplayNameA",                               GetServiceDisplayNameA},
{FALSE, 229, "GetServiceDisplayNameW",                               GetServiceDisplayNameW},
{FALSE, 230, "GetServiceKeyNameA",                                   GetServiceKeyNameA},
{FALSE, 231, "GetServiceKeyNameW",                                   GetServiceKeyNameW},
{FALSE, 232, "GetSidIdentifierAuthority",                            GetSidIdentifierAuthority},
{FALSE, 233, "GetSidLengthRequired",                                 GetSidLengthRequired},
{FALSE, 234, "GetSidSubAuthority",                                   GetSidSubAuthority},
{FALSE, 235, "GetSidSubAuthorityCount",                              GetSidSubAuthorityCount},
{FALSE, 236, "GetSiteDirectoryA",                                    GetSiteDirectoryA},
{FALSE, 237, "GetSiteDirectoryW",                                    GetSiteDirectoryW},
{FALSE, 238, "GetSiteNameFromSid",                                   GetSiteNameFromSid},
{FALSE, 239, "GetSiteSidFromToken",                                  GetSiteSidFromToken},
{FALSE, 240, "GetSiteSidFromUrl",                                    GetSiteSidFromUrl},
{FALSE, 241, "GetTokenInformation",                                  GetTokenInformation},
{FALSE, 242, "GetTraceEnableFlags",                                  GetTraceEnableFlags},
{FALSE, 243, "GetTraceEnableLevel",                                  GetTraceEnableLevel},
{FALSE, 244, "GetTraceLoggerHandle",                                 GetTraceLoggerHandle},
{FALSE, 245, "GetTrusteeFormA",                                      GetTrusteeFormA},
{FALSE, 246, "GetTrusteeFormW",                                      GetTrusteeFormW},
{FALSE, 247, "GetTrusteeNameA",                                      GetTrusteeNameA},
{FALSE, 248, "GetTrusteeNameW",                                      GetTrusteeNameW},
{FALSE, 249, "GetTrusteeTypeA",                                      GetTrusteeTypeA},
{FALSE, 250, "GetTrusteeTypeW",                                      GetTrusteeTypeW},
{FALSE, 251, "GetUserNameA",                                         GetUserNameA},
{FALSE, 252, "GetUserNameW",                                         GetUserNameW},
{FALSE, 253, "GetWindowsAccountDomainSid",                           GetWindowsAccountDomainSid},
{FALSE,   1, "I_ScGetCurrentGroupStateW",                            I_ScGetCurrentGroupStateW},
{FALSE,   2, "I_ScIsSecurityProcess",                                I_ScIsSecurityProcess},
{FALSE, 254, "I_ScPnPGetServiceName",                                I_ScPnPGetServiceName},
{FALSE, 255, "I_ScSetServiceBitsA",                                  I_ScSetServiceBitsA},
{FALSE, 256, "I_ScSetServiceBitsW",                                  I_ScSetServiceBitsW},
{FALSE, 257, "ImpersonateAnonymousToken",                            ImpersonateAnonymousToken},
{FALSE, 258, "ImpersonateLoggedOnUser",                              ImpersonateLoggedOnUser},
{FALSE, 259, "ImpersonateNamedPipeClient",                           ImpersonateNamedPipeClient},
{FALSE, 260, "ImpersonateSelf",                                      ImpersonateSelf},
{FALSE, 261, "InitializeAcl",                                        InitializeAcl},
{FALSE, 262, "InitializeSecurityDescriptor",                         InitializeSecurityDescriptor},
{FALSE, 263, "InitializeSid",                                        InitializeSid},
{FALSE, 264, "InitiateSystemShutdownA",                              InitiateSystemShutdownA},
{FALSE, 265, "InitiateSystemShutdownExA",                            InitiateSystemShutdownExA},
{FALSE, 266, "InitiateSystemShutdownExW",                            InitiateSystemShutdownExW},
{FALSE, 267, "InitiateSystemShutdownW",                              InitiateSystemShutdownW},
{FALSE, 268, "InstallApplication",                                   InstallApplication},
{FALSE,   3, "IsInSandbox",                                          IsInSandbox},
{FALSE, 269, "IsProcessRestricted",                                  IsProcessRestricted},
{FALSE, 270, "IsTextUnicode",                                        IsTextUnicode},
{FALSE, 271, "IsTokenRestricted",                                    IsTokenRestricted},
{FALSE, 272, "IsValidAcl",                                           IsValidAcl},
{FALSE, 273, "IsValidSecurityDescriptor",                            IsValidSecurityDescriptor},
{FALSE, 274, "IsValidSid",                                           IsValidSid},
{FALSE, 275, "IsWellKnownSid",                                       IsWellKnownSid},
{FALSE, 276, "LockServiceDatabase",                                  LockServiceDatabase},
{FALSE, 277, "LogonUserA",                                           LogonUserA},
{FALSE, 278, "LogonUserW",                                           LogonUserW},
{FALSE, 279, "LookupAccountNameA",                                   LookupAccountNameA},
{FALSE, 280, "LookupAccountNameW",                                   LookupAccountNameW},
{FALSE, 281, "LookupAccountSidA",                                    LookupAccountSidA},
{FALSE, 282, "LookupAccountSidW",                                    LookupAccountSidW},
{FALSE, 283, "LookupPrivilegeDisplayNameA",                          LookupPrivilegeDisplayNameA},
{FALSE, 284, "LookupPrivilegeDisplayNameW",                          LookupPrivilegeDisplayNameW},
{FALSE, 285, "LookupPrivilegeNameA",                                 LookupPrivilegeNameA},
{FALSE, 286, "LookupPrivilegeNameW",                                 LookupPrivilegeNameW},
{FALSE, 287, "LookupPrivilegeValueA",                                LookupPrivilegeValueA},
{FALSE, 288, "LookupPrivilegeValueW",                                LookupPrivilegeValueW},
{FALSE, 289, "LookupSecurityDescriptorPartsA",                       LookupSecurityDescriptorPartsA},
{FALSE, 290, "LookupSecurityDescriptorPartsW",                       LookupSecurityDescriptorPartsW},
{FALSE, 291, "LsaAddAccountRights",                                  LsaAddAccountRights},
{FALSE, 292, "LsaAddPrivilegesToAccount",                            LsaAddPrivilegesToAccount},
{FALSE, 293, "LsaClearAuditLog",                                     LsaClearAuditLog},
{FALSE, 294, "LsaClose",                                             LsaClose},
{FALSE, 295, "LsaCreateAccount",                                     LsaCreateAccount},
{FALSE, 296, "LsaCreateSecret",                                      LsaCreateSecret},
{FALSE, 297, "LsaCreateTrustedDomain",                               LsaCreateTrustedDomain},
{FALSE, 298, "LsaCreateTrustedDomainEx",                             LsaCreateTrustedDomainEx},
{FALSE, 299, "LsaDelete",                                            LsaDelete},
{FALSE, 300, "LsaDeleteTrustedDomain",                               LsaDeleteTrustedDomain},
{FALSE, 301, "LsaEnumerateAccountRights",                            LsaEnumerateAccountRights},
{FALSE, 302, "LsaEnumerateAccounts",                                 LsaEnumerateAccounts},
{FALSE, 303, "LsaEnumerateAccountsWithUserRight",                    LsaEnumerateAccountsWithUserRight},
{FALSE, 304, "LsaEnumeratePrivileges",                               LsaEnumeratePrivileges},
{FALSE, 305, "LsaEnumeratePrivilegesOfAccount",                      LsaEnumeratePrivilegesOfAccount},
{FALSE, 306, "LsaEnumerateTrustedDomains",                           LsaEnumerateTrustedDomains},
{FALSE, 307, "LsaEnumerateTrustedDomainsEx",                         LsaEnumerateTrustedDomainsEx},
{FALSE, 308, "LsaFreeMemory",                                        LsaFreeMemory},
{FALSE, 309, "LsaGetQuotasForAccount",                               LsaGetQuotasForAccount},
{FALSE, 310, "LsaGetRemoteUserName",                                 LsaGetRemoteUserName},
{FALSE, 311, "LsaGetSystemAccessAccount",                            LsaGetSystemAccessAccount},
{FALSE, 312, "LsaGetUserName",                                       LsaGetUserName},
{FALSE, 313, "LsaICLookupNames",                                     LsaICLookupNames},
{FALSE, 314, "LsaICLookupSids",                                      LsaICLookupSids},
{FALSE, 315, "LsaLookupNames",                                       LsaLookupNames},
{FALSE, 316, "LsaLookupPrivilegeDisplayName",                        LsaLookupPrivilegeDisplayName},
{FALSE, 317, "LsaLookupPrivilegeName",                               LsaLookupPrivilegeName},
{FALSE, 318, "LsaLookupPrivilegeValue",                              LsaLookupPrivilegeValue},
{FALSE, 319, "LsaLookupSids",                                        LsaLookupSids},
{FALSE, 320, "LsaNtStatusToWinError",                                LsaNtStatusToWinError},
{FALSE, 321, "LsaOpenAccount",                                       LsaOpenAccount},
{FALSE, 322, "LsaOpenPolicy",                                        LsaOpenPolicy},
{FALSE, 323, "LsaOpenPolicySce",                                     LsaOpenPolicySce},
{FALSE, 324, "LsaOpenSecret",                                        LsaOpenSecret},
{FALSE, 325, "LsaOpenTrustedDomain",                                 LsaOpenTrustedDomain},
{FALSE, 326, "LsaOpenTrustedDomainByName",                           LsaOpenTrustedDomainByName},
{FALSE, 327, "LsaQueryDomainInformationPolicy",                      LsaQueryDomainInformationPolicy},
{FALSE, 328, "LsaQueryInfoTrustedDomain",                            LsaQueryInfoTrustedDomain},
{FALSE, 329, "LsaQueryInformationPolicy",                            LsaQueryInformationPolicy},
{FALSE, 330, "LsaQuerySecret",                                       LsaQuerySecret},
{FALSE, 331, "LsaQuerySecurityObject",                               LsaQuerySecurityObject},
{FALSE, 332, "LsaQueryTrustedDomainInfo",                            LsaQueryTrustedDomainInfo},
{FALSE, 333, "LsaQueryTrustedDomainInfoByName",                      LsaQueryTrustedDomainInfoByName},
{FALSE, 334, "LsaRemoveAccountRights",                               LsaRemoveAccountRights},
{FALSE, 335, "LsaRemovePrivilegesFromAccount",                       LsaRemovePrivilegesFromAccount},
{FALSE, 336, "LsaRetrievePrivateData",                               LsaRetrievePrivateData},
{FALSE, 337, "LsaSetDomainInformationPolicy",                        LsaSetDomainInformationPolicy},
{FALSE, 338, "LsaSetInformationPolicy",                              LsaSetInformationPolicy},
{FALSE, 339, "LsaSetInformationTrustedDomain",                       LsaSetInformationTrustedDomain},
{FALSE, 340, "LsaSetQuotasForAccount",                               LsaSetQuotasForAccount},
{FALSE, 341, "LsaSetSecret",                                         LsaSetSecret},
{FALSE, 342, "LsaSetSecurityObject",                                 LsaSetSecurityObject},
{FALSE, 343, "LsaSetSystemAccessAccount",                            LsaSetSystemAccessAccount},
{FALSE, 344, "LsaSetTrustedDomainInfoByName",                        LsaSetTrustedDomainInfoByName},
{FALSE, 345, "LsaSetTrustedDomainInformation",                       LsaSetTrustedDomainInformation},
{FALSE, 346, "LsaStorePrivateData",                                  LsaStorePrivateData},
{FALSE, 348, "MakeAbsoluteSD",                                       MakeAbsoluteSD},
{FALSE, 347, "MakeAbsoluteSD2",                                      MakeAbsoluteSD2},
{FALSE, 349, "MakeSelfRelativeSD",                                   MakeSelfRelativeSD},
{FALSE, 350, "MapGenericMask",                                       MapGenericMask},
{FALSE, 351, "NotifyBootConfigStatus",                               NotifyBootConfigStatus},
{FALSE, 352, "NotifyChangeEventLog",                                 NotifyChangeEventLog},
{FALSE, 353, "ObjectCloseAuditAlarmA",                               ObjectCloseAuditAlarmA},
{FALSE, 354, "ObjectCloseAuditAlarmW",                               ObjectCloseAuditAlarmW},
{FALSE, 355, "ObjectDeleteAuditAlarmA",                              ObjectDeleteAuditAlarmA},
{FALSE, 356, "ObjectDeleteAuditAlarmW",                              ObjectDeleteAuditAlarmW},
{FALSE, 357, "ObjectOpenAuditAlarmA",                                ObjectOpenAuditAlarmA},
{FALSE, 358, "ObjectOpenAuditAlarmW",                                ObjectOpenAuditAlarmW},
{FALSE, 359, "ObjectPrivilegeAuditAlarmA",                           ObjectPrivilegeAuditAlarmA},
{FALSE, 360, "ObjectPrivilegeAuditAlarmW",                           ObjectPrivilegeAuditAlarmW},
{FALSE, 361, "OpenBackupEventLogA",                                  OpenBackupEventLogA},
{FALSE, 362, "OpenBackupEventLogW",                                  OpenBackupEventLogW},
{FALSE, 363, "OpenEncryptedFileRawA",                                OpenEncryptedFileRawA},
{FALSE, 364, "OpenEncryptedFileRawW",                                OpenEncryptedFileRawW},
{FALSE, 365, "OpenEventLogA",                                        OpenEventLogA},
{FALSE, 366, "OpenEventLogW",                                        OpenEventLogW},
{FALSE, 367, "OpenProcessToken",                                     OpenProcessToken},
{FALSE, 368, "OpenSCManagerA",                                       OpenSCManagerA},
{FALSE, 369, "OpenSCManagerW",                                       OpenSCManagerW},
{FALSE, 370, "OpenServiceA",                                         OpenServiceA},
{FALSE, 371, "OpenServiceW",                                         OpenServiceW},
{FALSE, 372, "OpenThreadToken",                                      OpenThreadToken},
{FALSE, 373, "OpenTraceA",                                           OpenTraceA},
{FALSE, 374, "OpenTraceW",                                           OpenTraceW},
{FALSE, 375, "PrivilegeCheck",                                       PrivilegeCheck},
{FALSE, 376, "PrivilegedServiceAuditAlarmA",                         PrivilegedServiceAuditAlarmA},
{FALSE, 377, "PrivilegedServiceAuditAlarmW",                         PrivilegedServiceAuditAlarmW},
{FALSE, 378, "ProcessTrace",                                         ProcessTrace},
{FALSE, 379, "QueryAllTracesA",                                      QueryAllTracesA},
{FALSE, 380, "QueryAllTracesW",                                      QueryAllTracesW},
{FALSE, 381, "QueryRecoveryAgentsOnEncryptedFile",                   QueryRecoveryAgentsOnEncryptedFile},
{FALSE, 382, "QueryServiceConfig2A",                                 QueryServiceConfig2A},
{FALSE, 383, "QueryServiceConfig2W",                                 QueryServiceConfig2W},
{FALSE, 384, "QueryServiceConfigA",                                  QueryServiceConfigA},
{FALSE, 385, "QueryServiceConfigW",                                  QueryServiceConfigW},
{FALSE, 386, "QueryServiceLockStatusA",                              QueryServiceLockStatusA},
{FALSE, 387, "QueryServiceLockStatusW",                              QueryServiceLockStatusW},
{FALSE, 388, "QueryServiceObjectSecurity",                           QueryServiceObjectSecurity},
{FALSE, 389, "QueryServiceStatus",                                   QueryServiceStatus},
{FALSE, 390, "QueryServiceStatusEx",                                 QueryServiceStatusEx},
{FALSE, 391, "QueryUsersOnEncryptedFile",                            QueryUsersOnEncryptedFile},
{FALSE, 392, "QueryWindows31FilesMigration",                         QueryWindows31FilesMigration},
{FALSE, 393, "ReadEncryptedFileRaw",                                 ReadEncryptedFileRaw},
{FALSE, 394, "ReadEventLogA",                                        ReadEventLogA},
{FALSE, 395, "ReadEventLogW",                                        ReadEventLogW},
{TRUE,  396, "RegCloseKey",                                          RegCloseKey},
{TRUE,  397, "RegConnectRegistryA",                                  RegConnectRegistryA},
{TRUE,  398, "RegConnectRegistryW",                                  RegConnectRegistryW},
{TRUE,  399, "RegCreateKeyA",                                        RegCreateKeyA},
{TRUE,  400, "RegCreateKeyExA",                                      RegCreateKeyExA},
{TRUE,  401, "RegCreateKeyExW",                                      RegCreateKeyExW},
{TRUE,  402, "RegCreateKeyW",                                        RegCreateKeyW},
{TRUE,  403, "RegDeleteKeyA",                                        RegDeleteKeyA},
{TRUE,  404, "RegDeleteKeyW",                                        RegDeleteKeyW},
{TRUE,  405, "RegDeleteValueA",                                      RegDeleteValueA},
{TRUE,  406, "RegDeleteValueW",                                      RegDeleteValueW},
{TRUE,  407, "RegDisablePredefinedCache",                            RegDisablePredefinedCache},
{TRUE,  408, "RegEnumKeyA",                                          RegEnumKeyA},
{TRUE,  409, "RegEnumKeyExA",                                        RegEnumKeyExA},
{TRUE,  410, "RegEnumKeyExW",                                        RegEnumKeyExW},
{TRUE,  411, "RegEnumKeyW",                                          RegEnumKeyW},
{TRUE,  412, "RegEnumValueA",                                        RegEnumValueA},
{TRUE,  413, "RegEnumValueW",                                        RegEnumValueW},
{TRUE,  414, "RegFlushKey",                                          RegFlushKey},
{FALSE, 415, "RegGetKeySecurity",                                    RegGetKeySecurity},
{TRUE,  416, "RegLoadKeyA",                                          RegLoadKeyA},
{TRUE,  417, "RegLoadKeyW",                                          RegLoadKeyW},
{TRUE,  418, "RegNotifyChangeKeyValue",                              RegNotifyChangeKeyValue},
{TRUE,  419, "RegOpenCurrentUser",                                   RegOpenCurrentUser},
{TRUE,  420, "RegOpenKeyA",                                          RegOpenKeyA},
{TRUE,  421, "RegOpenKeyExA",                                        RegOpenKeyExA},
{TRUE,  422, "RegOpenKeyExW",                                        RegOpenKeyExW},
{TRUE,  423, "RegOpenKeyW",                                          RegOpenKeyW},
{TRUE,  424, "RegOpenUserClassesRoot",                               RegOpenUserClassesRoot},
{TRUE,  425, "RegOverridePredefKey",                                 RegOverridePredefKey},
{FALSE, 426, "RegQueryInfoKeyA",                                     RegQueryInfoKeyA},
{FALSE, 427, "RegQueryInfoKeyW",                                     RegQueryInfoKeyW},
{FALSE, 428, "RegQueryMultipleValuesA",                              RegQueryMultipleValuesA},
{FALSE, 429, "RegQueryMultipleValuesW",                              RegQueryMultipleValuesW},
{TRUE,  430, "RegQueryValueA",                                       RegQueryValueA},
{TRUE,  431, "RegQueryValueExA",                                     RegQueryValueExA},
{TRUE,  432, "RegQueryValueExW",                                     RegQueryValueExW},
{TRUE,  433, "RegQueryValueW",                                       RegQueryValueW},
{TRUE,  434, "RegReplaceKeyA",                                       RegReplaceKeyA},
{TRUE,  435, "RegReplaceKeyW",                                       RegReplaceKeyW},
{TRUE,  436, "RegRestoreKeyA",                                       RegRestoreKeyA},
{TRUE,  437, "RegRestoreKeyW",                                       RegRestoreKeyW},
{TRUE,  438, "RegSaveKeyA",                                          RegSaveKeyA},
{TRUE,  439, "RegSaveKeyW",                                          RegSaveKeyW},
{FALSE, 440, "RegSetKeySecurity",                                    RegSetKeySecurity},
{TRUE,  441, "RegSetValueA",                                         RegSetValueA},
{TRUE,  442, "RegSetValueExA",                                       RegSetValueExA},
{TRUE,  443, "RegSetValueExW",                                       RegSetValueExW},
{TRUE,  444, "RegSetValueW",                                         RegSetValueW},
{TRUE,  445, "RegUnLoadKeyA",                                        RegUnLoadKeyA},
{TRUE,  446, "RegUnLoadKeyW",                                        RegUnLoadKeyW},
{FALSE, 447, "RegisterEventSourceA",                                 RegisterEventSourceA},
{FALSE, 448, "RegisterEventSourceW",                                 RegisterEventSourceW},
{FALSE, 449, "RegisterServiceCtrlHandlerA",                          RegisterServiceCtrlHandlerA},
{FALSE, 450, "RegisterServiceCtrlHandlerExA",                        RegisterServiceCtrlHandlerExA},
{FALSE, 451, "RegisterServiceCtrlHandlerExW",                        RegisterServiceCtrlHandlerExW},
{FALSE, 452, "RegisterServiceCtrlHandlerW",                          RegisterServiceCtrlHandlerW},
{FALSE, 453, "RegisterTraceGuidsA",                                  RegisterTraceGuidsA},
{FALSE, 454, "RegisterTraceGuidsW",                                  RegisterTraceGuidsW},
{FALSE, 455, "RemoveTraceCallback",                                  RemoveTraceCallback},
{FALSE, 456, "RemoveUsersFromEncryptedFile",                         RemoveUsersFromEncryptedFile},
{FALSE, 457, "ReportEventA",                                         ReportEventA},
{FALSE, 458, "ReportEventW",                                         ReportEventW},
{FALSE, 459, "RevertToSelf",                                         RevertToSelf},
{FALSE, 460, "SetAclInformation",                                    SetAclInformation},
{FALSE, 461, "SetEntriesInAccessListA",                              SetEntriesInAccessListA},
{FALSE, 462, "SetEntriesInAccessListW",                              SetEntriesInAccessListW},
{FALSE, 463, "SetEntriesInAclA",                                     SetEntriesInAclA},
{FALSE, 464, "SetEntriesInAclW",                                     SetEntriesInAclW},
{FALSE, 465, "SetEntriesInAuditListA",                               SetEntriesInAuditListA},
{FALSE, 466, "SetEntriesInAuditListW",                               SetEntriesInAuditListW},
{FALSE, 467, "SetFileSecurityA",                                     SetFileSecurityA},
{FALSE, 468, "SetFileSecurityW",                                     SetFileSecurityW},
{FALSE, 469, "SetKernelObjectSecurity",                              SetKernelObjectSecurity},
{FALSE, 470, "SetNamedSecurityInfoA",                                SetNamedSecurityInfoA},
{FALSE, 471, "SetNamedSecurityInfoExA",                              SetNamedSecurityInfoExA},
{FALSE, 472, "SetNamedSecurityInfoExW",                              SetNamedSecurityInfoExW},
{FALSE, 473, "SetNamedSecurityInfoW",                                SetNamedSecurityInfoW},
{FALSE, 474, "SetPrivateObjectSecurity",                             SetPrivateObjectSecurity},
{FALSE, 475, "SetPrivateObjectSecurityEx",                           SetPrivateObjectSecurityEx},
{FALSE, 476, "SetSecurityDescriptorControl",                         SetSecurityDescriptorControl},
{FALSE, 477, "SetSecurityDescriptorDacl",                            SetSecurityDescriptorDacl},
{FALSE, 478, "SetSecurityDescriptorGroup",                           SetSecurityDescriptorGroup},
{FALSE, 479, "SetSecurityDescriptorOwner",                           SetSecurityDescriptorOwner},
{FALSE, 480, "SetSecurityDescriptorRMControl",                       SetSecurityDescriptorRMControl},
{FALSE, 481, "SetSecurityDescriptorSacl",                            SetSecurityDescriptorSacl},
{FALSE, 482, "SetSecurityInfo",                                      SetSecurityInfo},
{FALSE, 483, "SetSecurityInfoExA",                                   SetSecurityInfoExA},
{FALSE, 484, "SetSecurityInfoExW",                                   SetSecurityInfoExW},
{FALSE, 485, "SetServiceBits",                                       SetServiceBits},
{FALSE, 486, "SetServiceObjectSecurity",                             SetServiceObjectSecurity},
{FALSE, 487, "SetServiceStatus",                                     SetServiceStatus},
{FALSE, 488, "SetThreadToken",                                       SetThreadToken},
{FALSE, 489, "SetTokenInformation",                                  SetTokenInformation},
{FALSE, 490, "SetTraceCallback",                                     SetTraceCallback},
{FALSE, 491, "SetUserFileEncryptionKey",                             SetUserFileEncryptionKey},
{FALSE, 492, "StartServiceA",                                        StartServiceA},
{FALSE, 493, "StartServiceCtrlDispatcherA",                          StartServiceCtrlDispatcherA},
{FALSE, 494, "StartServiceCtrlDispatcherW",                          StartServiceCtrlDispatcherW},
{FALSE, 495, "StartServiceW",                                        StartServiceW},
{FALSE, 496, "StartTraceA",                                          StartTraceA},
{FALSE, 497, "StartTraceW",                                          StartTraceW},
{FALSE, 498, "SynchronizeWindows31FilesAndWindowsNTRegistry",        SynchronizeWindows31FilesAndWindowsNTRegistry},
{FALSE, 499, "SystemFunction001",                                    SystemFunction001},
{FALSE, 500, "SystemFunction002",                                    SystemFunction002},
{FALSE, 501, "SystemFunction003",                                    SystemFunction003},
{FALSE, 502, "SystemFunction004",                                    SystemFunction004},
{FALSE, 503, "SystemFunction005",                                    SystemFunction005},
{FALSE, 504, "SystemFunction006",                                    SystemFunction006},
{FALSE, 505, "SystemFunction007",                                    SystemFunction007},
{FALSE, 506, "SystemFunction008",                                    SystemFunction008},
{FALSE, 507, "SystemFunction009",                                    SystemFunction009},
{FALSE, 508, "SystemFunction010",                                    SystemFunction010},
{FALSE, 509, "SystemFunction011",                                    SystemFunction011},
{FALSE, 510, "SystemFunction012",                                    SystemFunction012},
{FALSE, 511, "SystemFunction013",                                    SystemFunction013},
{FALSE, 512, "SystemFunction014",                                    SystemFunction014},
{FALSE, 513, "SystemFunction015",                                    SystemFunction015},
{FALSE, 514, "SystemFunction016",                                    SystemFunction016},
{FALSE, 515, "SystemFunction017",                                    SystemFunction017},
{FALSE, 516, "SystemFunction018",                                    SystemFunction018},
{FALSE, 517, "SystemFunction019",                                    SystemFunction019},
{FALSE, 518, "SystemFunction020",                                    SystemFunction020},
{FALSE, 519, "SystemFunction021",                                    SystemFunction021},
{FALSE, 520, "SystemFunction022",                                    SystemFunction022},
{FALSE, 521, "SystemFunction023",                                    SystemFunction023},
{FALSE, 522, "SystemFunction024",                                    SystemFunction024},
{FALSE, 523, "SystemFunction025",                                    SystemFunction025},
{FALSE, 524, "SystemFunction026",                                    SystemFunction026},
{FALSE, 525, "SystemFunction027",                                    SystemFunction027},
{FALSE, 526, "SystemFunction028",                                    SystemFunction028},
{FALSE, 527, "SystemFunction029",                                    SystemFunction029},
{FALSE, 528, "SystemFunction030",                                    SystemFunction030},
{FALSE, 529, "SystemFunction031",                                    SystemFunction031},
{FALSE, 530, "SystemFunction032",                                    SystemFunction032},
{FALSE, 531, "SystemFunction033",                                    SystemFunction033},
{FALSE, 532, "SystemFunction034",                                    SystemFunction034},
{FALSE, 533, "SystemFunction035",                                    SystemFunction035},
{FALSE, 534, "SystemFunction040",                                    SystemFunction040},
{FALSE, 535, "SystemFunction041",                                    SystemFunction041},
{FALSE, 536, "TraceEvent",                                           TraceEvent},
{FALSE, 537, "TraceEventInstance",                                   TraceEventInstance},
{FALSE, 538, "TrusteeAccessToObjectA",                               TrusteeAccessToObjectA},
{FALSE, 539, "TrusteeAccessToObjectW",                               TrusteeAccessToObjectW},
{FALSE, 540, "UninstallApplication",                                 UninstallApplication},
{FALSE, 541, "UnlockServiceDatabase",                                UnlockServiceDatabase},
{FALSE, 542, "UnregisterTraceGuids",                                 UnregisterTraceGuids},
{FALSE, 543, "WmiCloseBlock",                                        WmiCloseBlock},
{FALSE, 544, "WmiDevInstToInstanceNameA",                            WmiDevInstToInstanceNameA},
{FALSE, 545, "WmiDevInstToInstanceNameW",                            WmiDevInstToInstanceNameW},
{FALSE, 546, "WmiEnumerateGuids",                                    WmiEnumerateGuids},
{FALSE, 547, "WmiExecuteMethodA",                                    WmiExecuteMethodA},
{FALSE, 548, "WmiExecuteMethodW",                                    WmiExecuteMethodW},
{FALSE, 549, "WmiFileHandleToInstanceNameA",                         WmiFileHandleToInstanceNameA},
{FALSE, 550, "WmiFileHandleToInstanceNameW",                         WmiFileHandleToInstanceNameW},
{FALSE, 551, "WmiFreeBuffer",                                        WmiFreeBuffer},
{FALSE, 552, "WmiMofEnumerateResourcesA",                            WmiMofEnumerateResourcesA},
{FALSE, 553, "WmiMofEnumerateResourcesW",                            WmiMofEnumerateResourcesW},
{FALSE, 554, "WmiNotificationRegistrationA",                         WmiNotificationRegistrationA},
{FALSE, 555, "WmiNotificationRegistrationW",                         WmiNotificationRegistrationW},
{FALSE, 556, "WmiOpenBlock",                                         WmiOpenBlock},
{FALSE, 557, "WmiQueryAllDataA",                                     WmiQueryAllDataA},
{FALSE, 558, "WmiQueryAllDataW",                                     WmiQueryAllDataW},
{FALSE, 559, "WmiQueryGuidInformation",                              WmiQueryGuidInformation},
{FALSE, 560, "WmiQuerySingleInstanceA",                              WmiQuerySingleInstanceA},
{FALSE, 561, "WmiQuerySingleInstanceW",                              WmiQuerySingleInstanceW},
{FALSE, 562, "WmiSetSingleInstanceA",                                WmiSetSingleInstanceA},
{FALSE, 563, "WmiSetSingleInstanceW",                                WmiSetSingleInstanceW},
{FALSE, 564, "WmiSetSingleItemA",                                    WmiSetSingleItemA},
{FALSE, 565, "WmiSetSingleItemW",                                    WmiSetSingleItemW},
{FALSE, 566, "WriteEncryptedFileRaw",                                WriteEncryptedFileRaw},
{FALSE,   0, NULL,                                                   NULL}};
