/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __COMMCTRL_H__
#define __COMMCTRL_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "user32.h"

/* ja:共通 */
#define CCS_TOP              0x00000001
#define CCS_NOMOVEY          0x00000002
#define CCS_BOTTOM           0x00000003
#define CCS_NORESIZE         0x00000004
#define CCS_NOPARENTALIGN    0x00000008
#define CCS_ADJUSTABLE       0x00000020
#define CCS_NODIVIDER        0x00000040
#define CCS_VERT             0x00000080
#define CCS_LEFT             (CCS_VERT|CCS_TOP)
#define CCS_RIGHT            (CCS_VERT|CCS_BOTTOM)
#define CCS_NOMOVEX          (CCS_VERT|CCS_NOMOVEY)
#define CCM_FIRST            0x2000
#define CCM_SETBKCOLOR       (CCM_FIRST+1)
#define CCM_SETCOLORSCHEME   (CCM_FIRST+2)
#define CCM_GETCOLORSCHEME   (CCM_FIRST+3)
#define CCM_GETDROPTARGET    (CCM_FIRST+4)
#define CCM_SETUNICODEFORMAT (CCM_FIRST+5)
#define CCM_GETUNICODEFORMAT (CCM_FIRST+6)
#define CCM_SETVERSION       (CCM_FIRST+7)
#define CCM_GETVERSION       (CCM_FIRST+8)
#define CCM_SETNOTIFYWINDOW  (CCM_FIRST+9)
#define CCM_SETWINDOWTHEME   (CCM_FIRST+11)
#define CCM_DPISCALE         (CCM_FIRST+12)

/* ja:ツールバー */
#define TBSTATE_CHECKED       0x01
#define TBSTATE_PRESSED       0x02
#define TBSTATE_ENABLED       0x04
#define TBSTATE_HIDDEN        0x08
#define TBSTATE_INDETERMINATE 0x10
#define TBSTATE_WRAP          0x20
#define TBSTYLE_BUTTON     0x00
#define TBSTYLE_SEP        0x01
#define TBSTYLE_CHECK      0x02
#define TBSTYLE_GROUP      0x04
#define TBSTYLE_CHECKGROUP (TBSTYLE_GROUP|TBSTYLE_CHECK)
#define TBSTYLE_TOOLTIPS 0x0100
#define TBSTYLE_WRAPABLE 0x0200
#define TBSTYLE_ALTDRAG  0x0400
#define TB_ENABLEBUTTON          (WM_USER+1)
#define TB_CHECKBUTTON           (WM_USER+2)
#define TB_PRESSBUTTON           (WM_USER+3)
#define TB_HIDEBUTTON            (WM_USER+4)
#define TB_INDETERMINATE         (WM_USER+5)
#define TB_MARKBUTTON            (WM_USER+6)
#define TB_ISBUTTONENABLED       (WM_USER+9)
#define TB_ISBUTTONCHECKED       (WM_USER+10)
#define TB_ISBUTTONPRESSED       (WM_USER+11)
#define TB_ISBUTTONHIDDEN        (WM_USER+12)
#define TB_ISBUTTONINDETERMINATE (WM_USER+13)
#define TB_ISBUTTONHIGHLIGHTED   (WM_USER+14)
#define TB_SETSTATE              (WM_USER+17)
#define TB_GETSTATE              (WM_USER+18)
#define TB_ADDBITMAP             (WM_USER+19)
#define TB_ADDBUTTONSA           (WM_USER+20)
#define TB_ADDBUTTONSW           (WM_USER+68)
#define TB_HITTEST               (WM_USER+69)
#define TB_INSERTBUTTONA         (WM_USER+21)
#define TB_INSERTBUTTONW         (WM_USER+67)
#define TB_DELETEBUTTON          (WM_USER+22)
#define TB_GETBUTTON             (WM_USER+23)
#define TB_BUTTONCOUNT           (WM_USER+24)
#define TB_COMMANDTOINDEX        (WM_USER+25)
#define TB_SAVERESTOREA          (WM_USER+26)
#define TB_SAVERESTOREW          (WM_USER+76)
#define TB_CUSTOMIZE             (WM_USER+27)
#define TB_ADDSTRINGA            (WM_USER+28)
#define TB_ADDSTRINGW            (WM_USER+77)
#define TB_GETITEMRECT           (WM_USER+29)
#define TB_BUTTONSTRUCTSIZE      (WM_USER+30)
#define TB_SETBUTTONSIZE         (WM_USER+31)
#define TB_SETBITMAPSIZE         (WM_USER+32)
#define TB_AUTOSIZE              (WM_USER+33)
#define TB_GETTOOLTIPS           (WM_USER+35)
#define TB_SETTOOLTIPS           (WM_USER+36)
#define TB_SETPARENT             (WM_USER+37)
#define TB_SETROWS               (WM_USER+39)
#define TB_GETROWS               (WM_USER+40)
#define TB_GETBITMAPFLAGS        (WM_USER+41)
#define TB_SETCMDID              (WM_USER+42)
#define TB_CHANGEBITMAP          (WM_USER+43)
#define TB_GETBITMAP             (WM_USER+44)
#define TB_GETBUTTONTEXTA        (WM_USER+45)
#define TB_GETBUTTONTEXTW        (WM_USER+75)
#define TB_REPLACEBITMAP         (WM_USER+46)
#define TB_SETINDENT             (WM_USER+47)
#define TB_SETIMAGELIST          (WM_USER+48)
#define TB_GETIMAGELIST          (WM_USER+49)
#define TB_LOADIMAGES            (WM_USER+50)
#define TB_GETRECT               (WM_USER+51)
#define TB_SETHOTIMAGELIST       (WM_USER+52)
#define TB_GETHOTIMAGELIST       (WM_USER+53)
#define TB_SETDISABLEDIMAGELIST  (WM_USER+54)
#define TB_GETDISABLEDIMAGELIST  (WM_USER+55)
#define TB_SETSTYLE              (WM_USER+56)
#define TB_GETSTYLE              (WM_USER+57)
#define TB_GETBUTTONSIZE         (WM_USER+58)
#define TB_SETBUTTONWIDTH        (WM_USER+59)
#define TB_SETMAXTEXTROWS        (WM_USER+60)
#define TB_GETTEXTROWS           (WM_USER+61)
#define TB_GETOBJECT             (WM_USER+62)
#define TB_GETBUTTONINFOW        (WM_USER+63)
#define TB_GETBUTTONINFOA        (WM_USER+65)
#define TB_SETBUTTONINFOW        (WM_USER+64)
#define TB_SETBUTTONINFOA        (WM_USER+66)
#define TB_SETDRAWTEXTFLAGS      (WM_USER+70)
#define TB_GETHOTITEM            (WM_USER+71)
#define TB_SETHOTITEM            (WM_USER+72)
#define TB_SETANCHORHIGHLIGHT    (WM_USER+73)
#define TB_GETANCHORHIGHLIGHT    (WM_USER+74)
#define TB_MAPACCELERATORA       (WM_USER+78)
#define TB_MAPACCELERATORW       (WM_USER+90)
#define TB_GETINSERTMARK         (WM_USER+79)
#define TB_SETINSERTMARK         (WM_USER+80)
#define TB_INSERTMARKHITTEST     (WM_USER+81)
#define TB_MOVEBUTTON            (WM_USER+82)
#define TB_GETMAXSIZE            (WM_USER+83)
#define TB_SETEXTENDEDSTYLE      (WM_USER+84)
#define TB_GETEXTENDEDSTYLE      (WM_USER+85)
#define TB_GETPADDING            (WM_USER+86)
#define TB_SETPADDING            (WM_USER+87)
#define TB_SETINSERTMARKCOLOR    (WM_USER+88)
#define TB_GETINSERTMARKCOLOR    (WM_USER+89)
#define TB_SETCOLORSCHEME        CCM_SETCOLORSCHEME
#define TB_GETCOLORSCHEME        CCM_GETCOLORSCHEME
#define TB_SETUNICODEFORMAT      CCM_SETUNICODEFORMAT
#define TB_GETUNICODEFORMAT      CCM_GETUNICODEFORMAT
#define TB_GETSTRINGW            (WM_USER+91)
#define TB_GETSTRINGA            (WM_USER+92)
#ifdef UNICODE
# define TB_GETSTRING      TB_GETSTRINGW
# define TB_ADDBUTTONS     TB_ADDBUTTONSW
# define TB_INSERTBUTTON   TB_INSERTBUTTONW
# define TB_SAVERESTORE    TB_SAVERESTOREW
# define TB_ADDSTRING      TB_ADDSTRINGW
# define TB_GETBUTTONTEXT  TB_GETBUTTONTEXTW
# define TB_GETBUTTONINFO  TB_GETBUTTONINFOW
# define TB_SETBUTTONINFO  TB_SETBUTTONINFOW
# define TB_MAPACCELERATOR TB_MAPACCELERATORW
#else /* not UNICODE */
# define TB_GETSTRING      TB_GETSTRINGA
# define TB_ADDBUTTONS     TB_ADDBUTTONSA
# define TB_INSERTBUTTON   TB_INSERTBUTTONA
# define TB_SAVERESTORE    TB_SAVERESTOREA
# define TB_ADDSTRING      TB_ADDSTRINGA
# define TB_GETBUTTONTEXT  TB_GETBUTTONTEXTA
# define TB_GETBUTTONINFO  TB_GETBUTTONINFOA
# define TB_SETBUTTONINFO  TB_SETBUTTONINFOA
# define TB_MAPACCELERATOR TB_MAPACCELERATORA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _TBBUTTON
{
  INT iBitmap;
  INT idCommand;
  BYTE fsState;
  BYTE fsStyle;
  BYTE bReserved[2];
  DWORD dwData;
  INT iString;
} TBBUTTON, *PTBBUTTON, *LPTBBUTTON;
#include "poppack.h"
typedef CONST TBBUTTON  *PCTBBUTTON, *LPCTBBUTTON;

/* ja:ツールチップ */
#define TTN_FIRST        (-520)
#define TTN_LAST         (-549)
#define TTN_SHOW         (TTN_FIRST-1)
#define TTN_POP          (TTN_FIRST-2)
#define TTN_NEEDTEXTA    (TTN_FIRST-0)
#define TTN_NEEDTEXTW    (TTN_FIRST-10)
#define TTN_GETDISPINFOA TTN_NEEDTEXTA
#define TTN_GETDISPINFOW TTN_NEEDTEXTW
#ifdef UNICODE
# define TTN_NEEDTEXT TTN_NEEDTEXTW
# define TTN_GETDISPINFO TTN_GETDISPINFOW
#else /* not UNICODE */
# define TTN_NEEDTEXT TTN_GETDISPINFOA
# define TTN_GETDISPINFO TTN_GETDISPINFOA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _TOOLTIPTEXTA
{
  NMHDR hdr;
  LPSTR lpszText;
  CHAR szText[80];
  HINSTANCE hinst;
  UINT uFlags;
} TOOLTIPTEXTA, *PTOOLTIPTEXTA, *LPTOOLTIPTEXTA;
typedef struct _TOOLTIPTEXTW
{
  NMHDR hdr;
  LPWSTR lpszText;
  WCHAR szText[80];
  HINSTANCE hinst;
  UINT uFlags;
} TOOLTIPTEXTW, *PTOOLTIPTEXTW, *LPTOOLTIPTEXTW;
#include "poppack.h"
#ifdef UNICODE
# define TOOLTIPTEXT TOOLTIPTEXTW
# define PTOOLTIPTEXT PTOOLTIPTEXTW
# define LPTOOLTIPTEXT LPTOOLTIPTEXTW
#else /* not UNICODE */
# define TOOLTIPTEXT TOOLTIPTEXTA
# define PTOOLTIPTEXT PTOOLTIPTEXTA
# define LPTOOLTIPTEXT LPTOOLTIPTEXTA
#endif /* not UNICODE */

/* ja:ステータスウインドウ */
#define STATUSCLASSNAMEA "msctls_statusbar32"
#define STATUSCLASSNAMEW (w32ldr_tchar_to_wc("msctls_statusbar32"))
#ifdef UNICODE
# define STATUSCLASSNAME STATUSCLASSNAMEW
#else /* not UNICODE */
# define STATUSCLASSNAME STATUSCLASSNAMEA
#endif /* not UNICODE */
#define SB_SETTEXTA       (WM_USER+1)
#define SB_SETTEXTW       (WM_USER+11)
#define SB_GETTEXTA       (WM_USER+2)
#define SB_GETTEXTW       (WM_USER+13)
#define SB_GETTEXTLENGTHA (WM_USER+3)
#define SB_GETTEXTLENGTHW (WM_USER+12)
#define SB_SETPARTS       (WM_USER+4)
#define SB_GETPARTS       (WM_USER+6)
#define SB_GETBORDERS     (WM_USER+7)
#define SB_SETMINHEIGHT   (WM_USER+8)
#define SB_SIMPLE         (WM_USER+9)
#define SB_GETRECT        (WM_USER+10)
#ifdef UNICODE
# define SB_SETTEXT       SB_SETTEXTW
# define SB_GETTEXT       SB_GETTEXTW
# define SB_GETTEXTLENGTH SB_GETTEXTLENGTHW
#else /* not UNICODE */
# define SB_SETTEXT       SB_SETTEXTA
# define SB_GETTEXT       SB_GETTEXTA
# define SB_GETTEXTLENGTH SB_GETTEXTLENGTHA
#endif /* not UNICODE */
#define SBT_NOBORDERS  0x0100
#define SBT_POPOUT     0x0200
#define SBT_RTLREADING 0x0400

/* ja:プロパティシート */
#define WC_PROPSHEETA "SysPropertySheet"
#define WC_PROPSHEETW (w32ldr_tchar_to_wc("SysPropertySheet"))
#ifdef UNICODE
# define WC_PROPSHEET WC_PROPSHEETW
#else /* not UNICODE */
# define WC_PROPSHEET WC_PROPSHEETA
#endif /* not UNICODE */
#define PSN_FIRST       (-200)
#define PSN_LAST        (-299)
#define PSN_SETACTIVE   (PSN_FIRST-0)
#define PSN_KILLACTIVE  (PSN_FIRST-1)
#define PSN_APPLY       (PSN_FIRST-2)
#define PSN_RESET       (PSN_FIRST-3)
#define PSN_HELP        (PSN_FIRST-5)
#define PSN_QUERYCANCEL (PSN_FIRST-9)

struct _PROPSHEETPAGEA;
struct _PROPSHEETPAGEW;
typedef LPVOID HPROPSHEETPAGE;
typedef INT (CALLBACK *PFNPROPSHEETCALLBACK)(HWND, UINT, LPARAM);
typedef UINT (CALLBACK *LPFNPSPCALLBACKA)(HWND, UINT, struct _PROPSHEETPAGEA*);
typedef UINT (CALLBACK *LPFNPSPCALLBACKW)(HWND, UINT, struct _PROPSHEETPAGEW*);
#ifdef UNICODE
# define LPFNPSPCALLBACK LPFNPSPCALLBACKW
#else /* not UNICODE */
# define LPFNPSPCALLBACK LPFNPSPCALLBACKA
#endif /* not UNICODE */

#define PSP_DEFAULT      0x0000
#define PSP_DLGINDIRECT  0x0001
#define PSP_USEHICON     0x0002
#define PSP_USEICONID    0x0004
#define PSP_USETITLE     0x0008
#define PSP_RTLREADING   0x0010
#define PSP_HASHELP      0x0020
#define PSP_USEREFPARENT 0x0040
#define PSP_USECALLBACK  0x0080
#include "pshpack1.h"
typedef struct _PROPSHEETPAGEA
{
  DWORD dwSize;
  DWORD dwFlags;
  HINSTANCE hInstance;
  union
  {
    LPCSTR pszTemplate;
    LPCDLGTEMPLATE pResource;
  };
  union
  {
    HICON hIcon;
    LPCSTR pszIcon;
  };
  LPCSTR pszTitle;
  DLGPROC pfnDlgProc;
  LPARAM lParam;
  LPFNPSPCALLBACKA pfnCallback;
  UINT *pcRefParent;
} PROPSHEETPAGEA, *PPROPSHEETPAGEA, *LPPROPSHEETPAGEA;
typedef CONST PPROPSHEETPAGEA PCPROPSHEETPAGEA;
typedef CONST LPPROPSHEETPAGEA LPCPROPSHEETPAGEA;
typedef struct _PROPSHEETPAGEW
{
  DWORD dwSize;
  DWORD dwFlags;
  HINSTANCE hInstance;
  union
  {
    LPCWSTR pszTemplate;
    LPCDLGTEMPLATE pResource;
  };
  union
  {
    HICON hIcon;
    LPCWSTR pszIcon;
  };
  LPCWSTR pszTitle;
  DLGPROC pfnDlgProc;
  LPARAM lParam;
  LPFNPSPCALLBACKW pfnCallback;
  UINT *pcRefParent;
} PROPSHEETPAGEW, *PPROPSHEETPAGEW, *LPPROPSHEETPAGEW;
typedef CONST PPROPSHEETPAGEW PCPROPSHEETPAGEW;
typedef CONST LPPROPSHEETPAGEW LPCPROPSHEETPAGEW;
#include "poppack.h"
#ifdef UNICODE
# define PROPSHEETPAGE PROPSHEETPAGEW
# define PPROPSHEETPAGE PPROPSHEETPAGEW
# define LPPROPSHEETPAGE LPPROPSHEETPAGEW
# define PCPROPSHEETPAGE PCPROPSHEETPAGEW
# define LPCPROPSHEETPAGE LPCPROPSHEETPAGEW
#else /* not UNICODE */
# define PROPSHEETPAGE PROPSHEETPAGEA
# define PPROPSHEETPAGE PPROPSHEETPAGEA
# define LPPROPSHEETPAGE LPPROPSHEETPAGEA
# define PCPROPSHEETPAGE PCPROPSHEETPAGEA
# define LPCPROPSHEETPAGE LPCPROPSHEETPAGEA
#endif /* not UNICODE */

#define PSH_DEFAULT         0x0000
#define PSH_PROPTITLE       0x0001
#define PSH_USEHICON        0x0002
#define PSH_USEICONID       0x0004
#define PSH_PROPSHEETPAGE   0x0008
#define PSH_WIZARDHASFINISH 0x0010
#define PSH_WIZARD          0x0020
#define PSH_USEPSTARTPAGE   0x0040
#define PSH_NOAPPLYNOW      0x0080
#define PSH_USECALLBACK     0x0100
#define PSH_HASHELP         0x0200
#define PSH_MODELESS        0x0400
#define PSH_RTLREADING      0x0800
#include "pshpack1.h"
typedef struct _PROPSHEETHEADERA
{
  DWORD dwSize;
  DWORD dwFlags;
  HWND hwndParent;
  HINSTANCE hInstance;
  union
  {
    HICON hIcon;
    LPCSTR pszIcon;
  };
  LPCSTR pszCaption;
  UINT nPages;
  union
  {
    UINT nStartPage;
    LPCSTR pStartPage;
  };
  union
  {
    LPPROPSHEETPAGEA ppsp;
    HPROPSHEETPAGE *phpage;
  };
  PFNPROPSHEETCALLBACK pfnCallback;
} PROPSHEETHEADERA, *PPROPSHEETHEADERA, *LPPROPSHEETHEADERA;
typedef const PPROPSHEETHEADERA PCPROPSHEETHEADERA;
typedef const LPPROPSHEETHEADERA LPCPROPSHEETHEADERA;
typedef struct _PROPSHEETHEADERW
{
  DWORD dwSize;
  DWORD dwFlags;
  HWND hwndParent;
  HINSTANCE hInstance;
  union
  {
    HICON hIcon;
    LPCWSTR pszIcon;
  };
  LPCWSTR pszCaption;
  UINT nPages;
  union
  {
    UINT nStartPage;
    LPCWSTR pStartPage;
  };
  union
  {
    LPPROPSHEETPAGEW ppsp;
    HPROPSHEETPAGE *phpage;
  };
  PFNPROPSHEETCALLBACK pfnCallback;
} PROPSHEETHEADERW, *PPROPSHEETHEADERW, *LPPROPSHEETHEADERW;
typedef const PPROPSHEETHEADERW PCPROPSHEETHEADERW;
typedef const LPPROPSHEETHEADERW LPCPROPSHEETHEADERW;
#include "poppack.h"
#ifdef UNICODE
# define PROPSHEETHEADER PROPSHEETHEADERW
# define PPROPSHEETHEADER PPROPSHEETHEADERW
# define LPPROPSHEETHEADER LPPROPSHEETHEADERW
# define PCPROPSHEETHEADER PCPROPSHEETHEADERW
# define LPCPROPSHEETHEADER LPCPROPSHEETHEADERW
#else /* not UNICODE */
# define PROPSHEETHEADER PROPSHEETHEADERA
# define PPROPSHEETHEADER PPROPSHEETHEADERA
# define LPPROPSHEETHEADER LPPROPSHEETHEADERA
# define PCPROPSHEETHEADER PCPROPSHEETHEADERA
# define LPCPROPSHEETHEADER LPCPROPSHEETHEADERA
#endif /* not UNICODE */

/* ja:イメージリスト */
typedef LPVOID HIMAGELIST;

/* ja:リストビュー */
#define WC_LISTVIEWA "SysListView32"
#define WC_LISTVIEWW (w32ldr_tchar_to_wc("SysListView32"))
#ifdef UNICODE
# define WC_LISTVIEW WC_LISTVIEWW
#else /* not UNICODE */
# define WC_LISTVIEW WC_LISTVIEWA
#endif /* not UNICODE */
#define LVS_ICON                     0x0000
#define LVS_REPORT                   0x0001
#define LVS_SMALLICON                0x0002
#define LVS_LIST                     0x0003
#define LVS_TYPEMASK                 0x0003
#define LVS_SINGLESEL                0x0004
#define LVS_SHOWSELALWAYS            0x0008
#define LVS_SORTASCENDING            0x0010
#define LVS_SORTDESCENDING           0x0020
#define LVS_SHAREIMAGELISTS          0x0040
#define LVS_NOLABELWRAP              0x0080
#define LVS_AUTOARRANGE              0x0100
#define LVS_EDITLABELS               0x0200
#define LVS_OWNERDATA                0x1000
#define LVS_NOSCROLL                 0x2000
#define LVS_TYPESTYLEMASK            0xfc00
#define LVS_ALIGNTOP                 0x0000
#define LVS_ALIGNLEFT                0x0800
#define LVS_ALIGNMASK                0x0c00
#define LVS_OWNERDRAWFIXED           0x0400
#define LVS_NOCOLUMNHEADER           0x4000
#define LVS_NOSORTHEADER             0x8000
#define LVS_EX_GRIDLINES             0x0001
#define LVS_EX_SUBITEMIMAGES         0x0002
#define LVS_EX_CHECKBOXES            0x0004
#define LVS_EX_TRACKSELECT           0x0008
#define LVS_EX_HEADERDRAGDROP        0x0010
#define LVS_EX_FULLROWSELECT         0x0020
#define LVS_EX_ONECLICKACTIVATE      0x0040
#define LVS_EX_TWOCLICKACTIVATE      0x0080
#define LVS_EX_FLATSB                0x0100
#define LVS_EX_REGIONAL              0x0200
#define LVS_EX_INFOTIP               0x0400
#define LVS_EX_UNDERLINEHOT          0x0800
#define LVS_EX_UNDERLINECOLD         0x1000
#define LVS_EX_MULTIWORKAREAS        0x2000
#define LVS_EX_LABELTIP              0x4000
#define LVS_EX_BORDERSELECT          0x8000
#define LVS_EX_DOUBLEBUFFER          0x00010000
#define LVS_EX_HIDELABELS            0x00020000
#define LVS_EX_SINGLEROW             0x00040000
#define LVS_EX_SNAPTOGRID            0x00080000
#define LVS_EX_SIMPLESELECT          0x00100000
#define LVM_FIRST                    0x1000
#define LVM_GETBKCOLOR               (LVM_FIRST+0)
#define LVM_SETBKCOLOR               (LVM_FIRST+1)
#define LVM_GETIMAGELIST             (LVM_FIRST+2)
#define LVM_SETIMAGELIST             (LVM_FIRST+3)
#define LVM_GETITEMCOUNT             (LVM_FIRST+4)
#define LVM_GETITEMA                 (LVM_FIRST+5)
#define LVM_GETITEMW                 (LVM_FIRST+75)
#define LVM_SETITEMA                 (LVM_FIRST+6)
#define LVM_SETITEMW                 (LVM_FIRST+76)
#define LVM_INSERTITEMA              (LVM_FIRST+7)
#define LVM_INSERTITEMW              (LVM_FIRST+77)
#define LVM_DELETEITEM               (LVM_FIRST+8)
#define LVM_DELETEALLITEMS           (LVM_FIRST+9)
#define LVM_GETCALLBACKMASK          (LVM_FIRST+10)
#define LVM_SETCALLBACKMASK          (LVM_FIRST+11)
#define LVM_GETNEXTITEM              (LVM_FIRST+12)
#define LVM_FINDITEMA                (LVM_FIRST+13)
#define LVM_FINDITEMW                (LVM_FIRST+83)
#define LVM_GETITEMRECT              (LVM_FIRST+14)
#define LVM_SETITEMPOSITION          (LVM_FIRST+15)
#define LVM_GETITEMPOSITION          (LVM_FIRST+16)
#define LVM_GETSTRINGWIDTHA          (LVM_FIRST+17)
#define LVM_GETSTRINGWIDTHW          (LVM_FIRST+87)
#define LVM_HITTEST                  (LVM_FIRST+18)
#define LVM_ENSUREVISIBLE            (LVM_FIRST+19)
#define LVM_SCROLL                   (LVM_FIRST+20)
#define LVM_REDRAWITEMS              (LVM_FIRST+21)
#define LVM_ARRANGE                  (LVM_FIRST+22)
#define LVM_EDITLABELA               (LVM_FIRST+23)
#define LVM_EDITLABELW               (LVM_FIRST+118)
#define LVM_GETEDITCONTROL           (LVM_FIRST+24)
#define LVM_GETCOLUMNA               (LVM_FIRST+25)
#define LVM_GETCOLUMNW               (LVM_FIRST+95)
#define LVM_SETCOLUMNA               (LVM_FIRST+26)
#define LVM_SETCOLUMNW               (LVM_FIRST+96)
#define LVM_INSERTCOLUMNA            (LVM_FIRST+27)
#define LVM_INSERTCOLUMNW            (LVM_FIRST+97)
#define LVM_DELETECOLUMN             (LVM_FIRST+28)
#define LVM_GETCOLUMNWIDTH           (LVM_FIRST+29)
#define LVM_SETCOLUMNWIDTH           (LVM_FIRST+30)
#define LVM_GETHEADER                (LVM_FIRST+31)
#define LVM_CREATEDRAGIMAGE          (LVM_FIRST+33)
#define LVM_GETVIEWRECT              (LVM_FIRST+34)
#define LVM_GETTEXTCOLOR             (LVM_FIRST+35)
#define LVM_SETTEXTCOLOR             (LVM_FIRST+36)
#define LVM_GETTEXTBKCOLOR           (LVM_FIRST+37)
#define LVM_SETTEXTBKCOLOR           (LVM_FIRST+38)
#define LVM_GETTOPINDEX              (LVM_FIRST+39)
#define LVM_GETCOUNTPERPAGE          (LVM_FIRST+40)
#define LVM_GETORIGIN                (LVM_FIRST+41)
#define LVM_UPDATE                   (LVM_FIRST+42)
#define LVM_SETITEMSTATE             (LVM_FIRST+43)
#define LVM_GETITEMSTATE             (LVM_FIRST+44)
#define LVM_GETITEMTEXTA             (LVM_FIRST+45)
#define LVM_GETITEMTEXTW             (LVM_FIRST+115)
#define LVM_SETITEMTEXTA             (LVM_FIRST+46)
#define LVM_SETITEMTEXTW             (LVM_FIRST+116)
#define LVM_SETITEMCOUNT             (LVM_FIRST+47)
#define LVM_SORTITEMS                (LVM_FIRST+48)
#define LVM_SETITEMPOSITION32        (LVM_FIRST+49)
#define LVM_GETSELECTEDCOUNT         (LVM_FIRST+50)
#define LVM_GETITEMSPACING           (LVM_FIRST+51)
#define LVM_GETISEARCHSTRINGA        (LVM_FIRST+52)
#define LVM_GETISEARCHSTRINGW        (LVM_FIRST+117)
#define LVM_SETICONSPACING           (LVM_FIRST+53)
#define LVM_SETEXTENDEDLISTVIEWSTYLE (LVM_FIRST+54)
#define LVM_GETEXTENDEDLISTVIEWSTYLE (LVM_FIRST+55)
#define LVM_GETSUBITEMRECT           (LVM_FIRST+56)
#define LVM_SUBITEMHITTEST           (LVM_FIRST+57)
#define LVM_SETCOLUMNORDERARRAY      (LVM_FIRST+58)
#define LVM_GETCOLUMNORDERARRAY      (LVM_FIRST+59)
#define LVM_SETHOTITEM               (LVM_FIRST+60)
#define LVM_GETHOTITEM               (LVM_FIRST+61)
#define LVM_SETHOTCURSOR             (LVM_FIRST+62)
#define LVM_GETHOTCURSOR             (LVM_FIRST+63)
#define LVM_APPROXIMATEVIEWRECT      (LVM_FIRST+64)
#define LVM_SETWORKAREAS             (LVM_FIRST+65)
#define LVM_GETSELECTIONMARK         (LVM_FIRST+66)
#define LVM_SETSELECTIONMARK         (LVM_FIRST+67)
#define LVM_SETBKIMAGEA              (LVM_FIRST+68)
#define LVM_SETBKIMAGEW              (LVM_FIRST+138)
#define LVM_GETBKIMAGEA              (LVM_FIRST+69)
#define LVM_GETBKIMAGEW              (LVM_FIRST+139)
#define LVM_GETWORKAREAS             (LVM_FIRST+70)
#define LVM_SETHOVERTIME             (LVM_FIRST+71)
#define LVM_GETHOVERTIME             (LVM_FIRST+72)
#define LVM_GETNUMBEROFWORKAREAS     (LVM_FIRST+73)
#define LVM_SETTOOLTIPS              (LVM_FIRST+74)
#define LVM_GETTOOLTIPS              (LVM_FIRST+78)
#define LVM_GETUNICODEFORMAT         CCM_GETUNICODEFORMAT
#define LVM_SETUNICODEFORMAT         CCM_SETUNICODEFORMAT
#define LVM_SETSELECTEDCOLUMN        (LVM_FIRST+140)
#define LVM_SETTILEWIDTH             (LVM_FIRST+141)
#define LVM_SETVIEW                  (LVM_FIRST+142)
#define LVM_GETVIEW                  (LVM_FIRST+143)
#define LVM_INSERTGROUP              (LVM_FIRST+145)
#define LVM_SETGROUPINFO             (LVM_FIRST+147)
#define LVM_GETGROUPINFO             (LVM_FIRST+149)
#define LVM_REMOVEGROUP              (LVM_FIRST+150)
#define LVM_MOVEGROUP                (LVM_FIRST+151)
#define LVM_MOVEITEMTOGROUP          (LVM_FIRST+154)
#define LVM_SETGROUPMETRICS          (LVM_FIRST+155)
#define LVM_GETGROUPMETRICS          (LVM_FIRST+156)
#define LVM_ENABLEGROUPVIEW          (LVM_FIRST+157)
#define LVM_SORTGROUPS               (LVM_FIRST+158)
#define LVM_INSERTGROUPSORTED        (LVM_FIRST+159)
#define LVM_REMOVEALLGROUPS          (LVM_FIRST+160)
#define LVM_HASGROUP                 (LVM_FIRST+161)
#define LVM_SETTILEVIEWINFO          (LVM_FIRST+162)
#define LVM_GETTILEVIEWINFO          (LVM_FIRST+163)
#define LVM_SETTILEINFO              (LVM_FIRST+164)
#define LVM_GETTILEINFO              (LVM_FIRST+165)
#define LVM_SETINSERTMARK            (LVM_FIRST+166)
#define LVM_GETINSERTMARK            (LVM_FIRST+167)
#define LVM_INSERTMARKHITTEST        (LVM_FIRST+168)
#define LVM_GETINSERTMARKRECT        (LVM_FIRST+169)
#define LVM_SETINSERTMARKCOLOR       (LVM_FIRST+170)
#define LVM_GETINSERTMARKCOLOR       (LVM_FIRST+171)
#define LVM_SETINFOTIP               (LVM_FIRST+173)
#define LVM_GETSELECTEDCOLUMN        (LVM_FIRST+174)
#define LVM_ISGROUPVIEWENABLED       (LVM_FIRST+175)
#define LVM_GETOUTLINECOLOR          (LVM_FIRST+176)
#define LVM_SETOUTLINECOLOR          (LVM_FIRST+177)
#define LVM_CANCELEDITLABEL          (LVM_FIRST+179)
#define LVM_MAPINDEXTOID             (LVM_FIRST+180)
#define LVM_MAPIDTOINDEX             (LVM_FIRST+181)
#ifdef UNICODE
# define LVM_GETITEM          LVM_GETITEMW
# define LVM_SETITEM          LVM_SETITEMW
# define LVM_INSERTITEM       LVM_INSERTITEMW
# define LVM_FINDITEM         LVM_FINDITEMW
# define LVM_GETSTRINGWIDTH   LVM_GETSTRINGWIDTHW
# define LVM_EDITLABEL        LVM_EDITLABELW
# define LVM_GETCOLUMN        LVM_GETCOLUMNW
# define LVM_SETCOLUMN        LVM_SETCOLUMNW
# define LVM_INSERTCOLUMN     LVM_INSERTCOLUMNW
# define LVM_GETITEMTEXT      LVM_GETITEMTEXTW
# define LVM_SETITEMTEXT      LVM_SETITEMTEXTW
# define LVM_GETISEARCHSTRING LVM_GETISEARCHSTRINGW
# define LVM_SETBKIMAGE       LVM_SETBKIMAGEW
# define LVM_GETBKIMAGE       LVM_GETBKIMAGE
#else /* not UNICODE */
# define LVM_GETITEM          LVM_GETITEMA
# define LVM_SETITEM          LVM_SETITEMA
# define LVM_INSERTITEM       LVM_INSERTITEMA
# define LVM_FINDITEM         LVM_FINDITEMA
# define LVM_GETSTRINGWIDTH   LVM_GETSTRINGWIDTHA
# define LVM_EDITLABEL        LVM_EDITLABELA
# define LVM_GETCOLUMN        LVM_GETCOLUMNA
# define LVM_SETCOLUMN        LVM_SETCOLUMNA
# define LVM_INSERTCOLUMN     LVM_INSERTCOLUMNA
# define LVM_GETITEMTEXT      LVM_GETITEMTEXTA
# define LVM_SETITEMTEXT      LVM_SETITEMTEXTA
# define LVM_GETISEARCHSTRING LVM_GETISEARCHSTRINGA
# define LVM_SETBKIMAGE       LVM_SETBKIMAGEA
# define LVM_GETBKIMAGE       LVM_GETBKIMAGE
#endif /* not UNICODE */
#define LVN_FIRST           (-100)
#define LVN_LAST            (-199)
#define LVN_ITEMCHANGING    (LVN_FIRST-0)
#define LVN_ITEMCHANGED     (LVN_FIRST-1)
#define LVN_INSERTITEM      (LVN_FIRST-2)
#define LVN_DELETEITEM      (LVN_FIRST-3)
#define LVN_DELETEALLITEMS  (LVN_FIRST-4)
#define LVN_BEGINLABELEDITA (LVN_FIRST-5)
#define LVN_BEGINLABELEDITW (LVN_FIRST-75)
#define LVN_ENDLABELEDITA   (LVN_FIRST-6)
#define LVN_ENDLABELEDITW   (LVN_FIRST-76)
#define LVN_COLUMNCLICK     (LVN_FIRST-8)
#define LVN_BEGINDRAG       (LVN_FIRST-9)
#define LVN_BEGINRDRAG      (LVN_FIRST-11)
#define LVN_GETDISPINFOA    (LVN_FIRST-50)
#define LVN_GETDISPINFOW    (LVN_FIRST-77)
#define LVN_SETDISPINFOA    (LVN_FIRST-51)
#define LVN_SETDISPINFOW    (LVN_FIRST-78)
#define LVN_KEYDOWN         (LVN_FIRST-55)
#ifdef UNICODE
#define LVN_BEGINLABELEDIT LVN_BEGINLABELEDITW
#define LVN_ENDLABELEDIT   LVN_ENDLABELEDITW
#define LVN_GETDISPINFO    LVN_GETDISPINFOW
#define LVN_SETDISPINFO    LVN_SETDISPINFOW
#else /* not UNICODE */
#define LVN_BEGINLABELEDIT LVN_BEGINLABELEDITA
#define LVN_ENDLABELEDIT   LVN_ENDLABELEDITA
#define LVN_GETDISPINFO    LVN_GETDISPINFOA
#define LVN_SETDISPINFO    LVN_SETDISPINFOA
#endif /* not UNICODE */
typedef struct _NM_LISTVIEW
{
  NMHDR hdr;
  INT iItem;
  INT iSubItem;
  UINT uNewState;
  UINT uOldState;
  UINT uChanged;
  POINT ptAction;
  LPARAM lParam;
} NM_LISTVIEW, *PNM_LISTVIEW, *LPNM_LISTVIEW;

#define LVSIL_NORMAL      0
#define LVSIL_SMALL       1
#define LVSIL_STATE       2
#define LVIR_BOUNDS       0x0000
#define LVIR_ICON         0x0001
#define LVIR_LABEL        0x0002
#define LVIR_SELECTBOUNDS 0x0003
#define LVNI_FOCUSED      0x0001
#define LVNI_SELECTED     0x0002
#define LVNI_CUT          0x0004
#define LVNI_DROPHILITED  0x0008
#define LVNI_ALL          0x0000
#define LVNI_ABOVE        0x0100
#define LVNI_BELOW        0x0200
#define LVNI_TOLEFT       0x0400
#define LVNI_TORIGHT      0x0800

#define LVCF_FMT      0x0001
#define LVCF_WIDTH    0x0002
#define LVCF_TEXT     0x0004
#define LVCF_SUBITEM  0x0008
#define LVCFMT_LEFT   0x0000
#define LVCFMT_RIGHT  0x0001
#define LVCFMT_CENTER 0x0002
#include "pshpack1.h"
typedef struct _LV_COLUMNA
{
  UINT mask;
  INT fmt;
  INT cx;
  LPSTR pszText;
  INT cchTextMax;
  INT iSubItem;
  INT iImage;
  INT iOrder;
} LV_COLUMNA, *PLV_COLUMNA, *LPLV_COLUMNA;
typedef struct _LV_COLUMNW
{
  UINT mask;
  INT fmt;
  INT cx;
  LPWSTR pszText;
  INT cchTextMax;
  INT iSubItem;
  INT iImage;
  INT iOrder;
} LV_COLUMNW, *PLV_COLUMNW, *LPLV_COLUMNW;
#include "poppack.h"
#ifdef UNICODE
# define LV_COLUMN LV_COLUMNW
# define PLV_COLUMN PLV_COLUMNW
# define LPLV_COLUMN LPLV_COLUMNW
#else /* not UNICODE */
# define LV_COLUMN LV_COLUMNA
# define PLV_COLUMN PLV_COLUMNA
# define LPLV_COLUMN LPLV_COLUMNA
#endif /* not UNICODE */

#define LVFI_PARAM     0x0001
#define LVFI_STRING    0x0002
#define LVFI_PARTIAL   0x0008
#define LVFI_WRAP      0x0020
#define LVFI_NEARESTXY 0x0040
#include "pshpack1.h"
typedef struct _LV_FINDINFOA
{
  UINT flags;
  LPCSTR psz;
  LPARAM lParam;
  POINT pt;
  UINT vkDirection;
} LV_FINDINFOA, *PLV_FINDINFOA, *LPLV_FINDINFOA;
typedef struct _LV_FINDINFOW
{
  UINT flags;
  LPCWSTR psz;
  LPARAM lParam;
  POINT pt;
  UINT vkDirection;
} LV_FINDINFOW, *PLV_FINDINFOW, *LPLV_FINDINFOW;
#include "poppack.h"
#ifdef UNICODE
# define LV_FINDINFO LV_FINDINFOW
# define PLV_FINDINFO PLV_FINDINFOW
# define LPLV_FINDINFO LPLV_FINDINFOW
#else /* not UNICODE */
# define LV_FINDINFO LV_FINDINFOA
# define PLV_FINDINFO PLV_FINDINFOA
# define LPLV_FINDINFO LPLV_FINDINFOA
#endif /* not UNICODE */

#define LVIF_TEXT           0x0001
#define LVIF_IMAGE          0x0002
#define LVIF_PARAM          0x0004
#define LVIF_STATE          0x0008
#define LVIF_DI_SETITEM     0x1000
#define LVIS_FOCUSED        0x0001
#define LVIS_SELECTED       0x0002
#define LVIS_DROPHILITED    0x0008
#define LVIS_OVERLAYMASK    0x0f00
#define LVIS_STATEIMAGEMASK 0xf000
#include "pshpack1.h"
typedef struct _LV_ITEMA
{
  UINT mask;
  INT iItem;
  INT iSubItem;
  UINT state;
  UINT stateMask;
  LPSTR pszText;
  INT cchTextMax;
  INT iImage;
  LPARAM lParam;
  INT iIndent;
  INT iGroupId;
  UINT cColumns;
  PUINT puColumns;
} LV_ITEMA, *PLV_ITEMA, *LPLV_ITEMA;
typedef struct _LV_ITEMW
{
  UINT mask;
  INT iItem;
  INT iSubItem;
  UINT state;
  UINT stateMask;
  LPWSTR pszText;
  INT cchTextMax;
  INT iImage;
  LPARAM lParam;
  INT iIndent;
  INT iGroupId;
  UINT cColumns;
  PUINT puColumns;
} LV_ITEMW, *PLV_ITEMW, *LPLV_ITEMW;
#include "poppack.h"
#ifdef UNICODE
# define LV_ITEM LV_ITEMW
# define PLV_ITEM PLV_ITEMW
# define LPLV_ITEM LPLV_ITEMW
#else /* not UNICODE */
# define LV_ITEM LV_ITEMA
# define PLV_ITEM PLV_ITEMA
# define LPLV_ITEM LPLV_ITEMA
#endif /* not UNICODE */

/* ja:ツリービュー */
#define WC_TREEVIEWA "SysTreeView32"
#define WC_TREEVIEWW (w32ldr_tchar_to_wc("SysTreeView32"))
#ifdef UNICODE
# define WC_TREEVIEW WC_TREEVIEWW
#else /* not UNICODE */
# define WC_TREEVIEW WC_TREEVIEWA
#endif /* not UNICODE */
#define TV_FIRST                0x1100
#define TVM_INSERTITEMA         (TV_FIRST+0)
#define TVM_INSERTITEMW         (TV_FIRST+50)
#define TVM_DELETEITEM          (TV_FIRST+1)
#define TVM_EXPAND              (TV_FIRST+2)
#define TVM_GETITEMRECT         (TV_FIRST+4)
#define TVM_GETCOUNT            (TV_FIRST+5)
#define TVM_GETINDENT           (TV_FIRST+6)
#define TVM_SETINDENT           (TV_FIRST+7)
#define TVM_GETIMAGELIST        (TV_FIRST+8)
#define TVM_SETIMAGELIST        (TV_FIRST+9)
#define TVM_GETNEXTITEM         (TV_FIRST+10)
#define TVM_SELECTITEM          (TV_FIRST+11)
#define TVM_GETITEMA            (TV_FIRST+12)
#define TVM_GETITEMW            (TV_FIRST+62)
#define TVM_SETITEMA            (TV_FIRST+13)
#define TVM_SETITEMW            (TV_FIRST+63)
#define TVM_EDITLABELA          (TV_FIRST+14)
#define TVM_EDITLABELW          (TV_FIRST+65)
#define TVM_GETEDITCONTROL      (TV_FIRST+15)
#define TVM_GETVISIBLECOUNT     (TV_FIRST+16)
#define TVM_HITTEST             (TV_FIRST+17)
#define TVM_CREATEDRAGIMAGE     (TV_FIRST+18)
#define TVM_SORTCHILDREN        (TV_FIRST+19)
#define TVM_ENSUREVISIBLE       (TV_FIRST+20)
#define TVM_SORTCHILDRENCB      (TV_FIRST+21)
#define TVM_ENDEDITLABELNOW     (TV_FIRST+22)
#define TVM_GETISEARCHSTRINGA   (TV_FIRST+23)
#define TVM_GETISEARCHSTRINGW   (TV_FIRST+64)
#define TVM_SETTOOLTIPS         (TV_FIRST+24)
#define TVM_GETTOOLTIPS         (TV_FIRST+25)
#define TVM_SETINSERTMARK       (TV_FIRST+26)
#define TVM_SETITEMHEIGHT       (TV_FIRST+27)
#define TVM_GETITEMHEIGHT       (TV_FIRST+28)
#define TVM_SETBKCOLOR          (TV_FIRST+29)
#define TVM_SETTEXTCOLOR        (TV_FIRST+30)
#define TVM_GETBKCOLOR          (TV_FIRST+31)
#define TVM_GETTEXTCOLOR        (TV_FIRST+32)
#define TVM_SETSCROLLTIME       (TV_FIRST+33)
#define TVM_GETSCROLLTIME       (TV_FIRST+34)
#define TVM_UNKNOWN35           (TV_FIRST+35)
#define TVM_UNKNOWN36           (TV_FIRST+36)
#define TVM_SETINSERTMARKCOLOR  (TV_FIRST+37)
#define TVM_GETINSERTMARKCOLOR  (TV_FIRST+38)
#define TVM_GETITEMSTATE        (TV_FIRST+39)
#define TVM_SETLINECOLOR        (TV_FIRST+40)
#define TVM_GETLINECOLOR        (TV_FIRST+41)
#define TVM_SETUNICODEFORMAT    CCM_SETUNICODEFORMAT
#define TVM_GETUNICODEFORMAT    CCM_GETUNICODEFORMAT
#define TVM_MAPACCIDTOHTREEITEM (TV_FIRST+42)
#define TVM_MAPHTREEITEMTOACCID (TV_FIRST+43)
#ifdef UNICODE
# define TVM_INSERTITEM       TVM_INSERTITEMW
# define TVM_GETITEM          TVM_GETITEMW
# define TVM_SETITEM          TVM_SETITEMW
# define TVM_EDITLABEL        TVM_EDITLABELW
# define TVM_GETISEARCHSTRING TVM_GETISEARCHSTRINGW
#else /* not UNICODE */
# define TVM_INSERTITEM       TVM_INSERTITEMA
# define TVM_GETITEM          TVM_GETITEMA
# define TVM_SETITEM          TVM_SETITEMA
# define TVM_EDITLABEL        TVM_EDITLABELA
# define TVM_GETISEARCHSTRING TVM_GETISEARCHSTRINGA
#endif /* not UNICODE */
#define TVN_FIRST               (-400)
#define TVN_LAST                (-499)
#define TVN_SELCHANGINGA        (TVN_FIRST-1)
#define TVN_SELCHANGINGW        (TVN_FIRST-50)
#define TVN_SELCHANGEDA         (TVN_FIRST-2)
#define TVN_SELCHANGEDW         (TVN_FIRST-51)
#define TVN_GETDISPINFOA        (TVN_FIRST-3)
#define TVN_GETDISPINFOW        (TVN_FIRST-52)
#define TVN_SETDISPINFOA        (TVN_FIRST-4)
#define TVN_SETDISPINFOW        (TVN_FIRST-53)
#define TVN_ITEMEXPANDINGA      (TVN_FIRST-5)
#define TVN_ITEMEXPANDINGW      (TVN_FIRST-54)
#define TVN_ITEMEXPANDEDA       (TVN_FIRST-6)
#define TVN_ITEMEXPANDEDW       (TVN_FIRST-55)
#define TVN_BEGINDRAGA          (TVN_FIRST-7)
#define TVN_BEGINDRAGW          (TVN_FIRST-56)
#define TVN_BEGINRDRAGA         (TVN_FIRST-8)
#define TVN_BEGINRDRAGW         (TVN_FIRST-57)
#define TVN_DELETEITEMA         (TVN_FIRST-9)
#define TVN_DELETEITEMW         (TVN_FIRST-58)
#define TVN_BEGINLABELEDITA     (TVN_FIRST-10)
#define TVN_BEGINLABELEDITW     (TVN_FIRST-59)
#define TVN_ENDLABELEDITA       (TVN_FIRST-11)
#define TVN_ENDLABELEDITW       (TVN_FIRST-60)
#define TVN_KEYDOWN             (TVN_FIRST-12)
#ifdef UNICODE
# define TVN_SELCHANGING    TVN_SELCHANGINGW
# define TVN_SELCHANGED     TVN_SELCHANGEDW
# define TVN_GETDISPINFO    TVN_GETDISPINFOW
# define TVN_SETDISPINFO    TVN_SETDISPINFOW
# define TVN_ITEMEXPANDING  TVN_ITEMEXPANDINGW
# define TVN_ITEMEXPANDED   TVN_ITEMEXPANDEDW
# define TVN_BEGINDRAG      TVN_BEGINDRAGW
# define TVN_BEGINRDRAG     TVN_BEGINRDRAGW
# define TVN_DELETEITEM     TVN_DELETEITEMW
# define TVN_BEGINLABELEDIT TVN_BEGINLABELEDITW
# define TVN_ENDLABELEDIT   TVN_ENDLABELEDITW
#else /* not UNICODE */
# define TVN_SELCHANGING    TVN_SELCHANGINGA
# define TVN_SELCHANGED     TVN_SELCHANGEDA
# define TVN_GETDISPINFO    TVN_GETDISPINFOA
# define TVN_SETDISPINFO    TVN_SETDISPINFOA
# define TVN_ITEMEXPANDING  TVN_ITEMEXPANDINGA
# define TVN_ITEMEXPANDED   TVN_ITEMEXPANDEDA
# define TVN_BEGINDRAG      TVN_BEGINDRAGA
# define TVN_BEGINRDRAG     TVN_BEGINRDRAGA
# define TVN_DELETEITEM     TVN_DELETEITEMA
# define TVN_BEGINLABELEDIT TVN_BEGINLABELEDITA
# define TVN_ENDLABELEDIT   TVN_ENDLABELEDITA
#endif /* not UNICODE */

#define TVSIL_NORMAL 0
#define TVSIL_STATE  2

#define TVGN_ROOT            0
#define TVGN_NEXT            1
#define TVGN_PREVIOUS        2
#define TVGN_PARENT          3
#define TVGN_CHILD           4
#define TVGN_FIRSTVISIBLE    5
#define TVGN_NEXTVISIBLE     6
#define TVGN_PREVIOUSVISIBLE 7
#define TVGN_DROPHILITE      8
#define TVGN_CARET           9

#define TVHT_NOWHERE         0x0001
#define TVHT_ONITEMICON      0x0002
#define TVHT_ONITEMLABEL     0x0004
#define TVHT_ONITEMINDENT    0x0008
#define TVHT_ONITEMBUTTON    0x0010
#define TVHT_ONITEMRIGHT     0x0020
#define TVHT_ONITEMSTATEICON 0x0040
#define TVHT_ONITEM          0x0046
#define TVHT_ABOVE           0x0100
#define TVHT_BELOW           0x0200
#define TVHT_TORIGHT         0x0400
#define TVHT_TOLEFT          0x0800

#define TVI_ROOT  ((HTREEITEM)0xffff0000)
#define TVI_FIRST ((HTREEITEM)0xffff0001)
#define TVI_LAST  ((HTREEITEM)0xffff0002)
#define TVI_SORT  ((HTREEITEM)0xffff0003)

typedef LPVOID HTREEITEM;

#define TVIF_TEXT           0x0001
#define TVIF_IMAGE          0x0002
#define TVIF_PARAM          0x0004
#define TVIF_STATE          0x0008
#define TVIF_HANDLE         0x0010
#define TVIF_SELECTEDIMAGE  0x0020
#define TVIF_CHILDREN       0x0040
#define TVIS_FOCUSED        0x0001
#define TVIS_SELECTED       0x0002
#define TVIS_CUT            0x0004
#define TVIS_DROPHILITED    0x0008
#define TVIS_BOLD           0x0010
#define TVIS_EXPANDED       0x0020
#define TVIS_EXPANDEDONCE   0x0040
#define TVIS_OVERLAYMASK    0x0f00
#define TVIS_STATEIMAGEMASK 0xf000
#define TVIS_USERMASK       TVIS_STATEIMAGEMASK
#include "pshpack1.h"
typedef struct _TV_ITEMA
{
  UINT mask;
  HTREEITEM hItem;
  UINT state;
  UINT stateMask;
  LPSTR pszText;
  INT cchTextMax;
  INT iImage;
  INT iSelectedImage;
  INT cChildren;
  LPARAM lParam;
} TV_ITEMA, *PTV_ITEMA, *LPTV_ITEMA;
typedef struct _TV_ITEMW
{
  UINT mask;
  HTREEITEM hItem;
  UINT state;
  UINT stateMask;
  LPWSTR pszText;
  INT cchTextMax;
  INT iImage;
  INT iSelectedImage;
  INT cChildren;
  LPARAM lParam;
} TV_ITEMW, *PTV_ITEMW, *LPTV_ITEMW;
#include "poppack.h"
#ifdef UNICODE
# define TV_ITEM TV_ITEMW
# define PTV_ITEM PTV_ITEMW
# define LPTV_ITEM LPTV_ITEMW
#else /* not UNICODE */
# define TV_ITEM TV_ITEMA
# define PTV_ITEM PTV_ITEMA
# define LPTV_ITEM LPTV_ITEMA
#endif /* not UNICODE */

#include "pshpack1.h"
typedef struct _TV_INSERTSTRUCTA
{
  HTREEITEM hParent;
  HTREEITEM hInsertAfter;
  TV_ITEMA item;
} TV_INSERTSTRUCTA, *PTV_INSERTSTRUCTA, *LPTV_INSERTSTRUCTA;
typedef struct _TVINSERTSTRUCTW
{
  HTREEITEM hParent;
  HTREEITEM hInsertAfter;
  TV_ITEMW item;
} TV_INSERTSTRUCTW, *PTV_INSERTSTRUCTW, *LPTV_INSERTSTRUCTW;
#include "poppack.h"
#ifdef UNICODE
# define TV_INSERTSTRUCT TV_INSERTSTRUCTW
# define PTV_INSERTSTRUCT PTV_INSERTSTRUCTW
# define LPTV_INSERTSTRUCT LPTV_INSERTSTRUCTW
#else /* not UNICODE */
# define TV_INSERTSTRUCT TV_INSERTSTRUCTA
# define PTV_INSERTSTRUCT PTV_INSERTSTRUCTA
# define LPTV_INSERTSTRUCT LPTV_INSERTSTRUCTA
#endif /* not UNICODE */

#include "pshpack1.h"
typedef struct _TV_HITTESTINFO
{
  POINT pt;
  UINT flags;
  HTREEITEM hItem;
} TV_HITTESTINFO, *PTV_HITTESTINFO, *LPTV_HITTESTINFO;

typedef struct _NM_TREEVIEWA
{
  NMHDR hdr;
  UINT action;
  TV_ITEMA itemOld;
  TV_ITEMA itemNew;
  POINT ptDrag;
} NM_TREEVIEWA, *PNM_TREEVIEWA, *LPNM_TREEVIEWA;
typedef struct _NM_TREEVIEWW
{
  NMHDR hdr;
  UINT action;
  TV_ITEMW itemOld;
  TV_ITEMW itemNew;
  POINT ptDrag;
} NM_TREEVIEWW, *PNM_TREEVIEWW, *LPNM_TREEVIEWW;
#include "poppack.h"
#ifdef UNICODE
# define NM_TREEVIEW NM_TREEVIEWW
# define PNM_TREEVIEW PNM_TREEVIEWW
# define LPNM_TREEVIEW LPNM_TREEVIEWW
#else /* not UNICODE */
# define NM_TREEVIEW NM_TREEVIEWA
# define PNM_TREEVIEW PNM_TREEVIEWA
# define LPNM_TREEVIEW LPNM_TREEVIEWA
#endif /* not UNICODE */

/* ja:プログレスコントロール */
#define PROGRESS_CLASSA "msctls_progress32"
#define PROGRESS_CLASSW (w32ldr_tchar_to_wc("msctls_progress32"))
#ifdef UNICODE
# define PROGRESS_CLASS PROGRESS_CLASSW
#else /* not UNICODE */
# define PROGRESS_CLASS PROGRESS_CLASSA
#endif /* not UNICODE */
#define PBM_SETRANGE    (WM_USER+1)
#define PBM_SETPOS      (WM_USER+2)
#define PBM_DELTAPOS    (WM_USER+3)
#define PBM_SETSTEP     (WM_USER+4)
#define PBM_STEPIT      (WM_USER+5)
#define PBM_SETRANGE32  (WM_USER+6)
#define PBM_GETRANGE    (WM_USER+7)
#define PBM_GETPOS      (WM_USER+8)
#define PBM_SETBARCOLOR (WM_USER+9)
#define PBM_SETMARQUEE  (WM_USER+10)
#define PBM_SETBKCOLOR  CCM_SETBKCOLOR
#define PBS_SMOOTH      0x01
#define PBS_VERTICAL    0x04
#define PBS_MARQUEE     0x08
#include "pshpack1.h"
typedef struct _PBRANGE
{
  INT iLow;
  INT iHigh;
} PBRANGE, *PPBRANGE,  *LPPBRANGE;
#include "poppack.h"

/* ja:スピンボタンコントロール */
#define UPDOWN_CLASSA "msctls_updown32"
#define UPDOWN_CLASSW (w32ldr_tchar_to_wc("msctls_updown32"))
#ifdef UNICODE
# define UPDOWN_CLASS UPDOWN_CLASSW
#else /* not UNICODE */
# define UPDOWN_CLASS UPDOWN_CLASSA
#endif /* not UNICODE */
#define UDM_SETRANGE (WM_USER+101)
#define UDM_GETRANGE (WM_USER+102)
#define UDM_SETPOS   (WM_USER+103)
#define UDM_GETPOS   (WM_USER+104)
#define UDM_SETBUDDY (WM_USER+105)
#define UDM_GETBUDDY (WM_USER+106)
#define UDM_SETACCEL (WM_USER+107)
#define UDM_GETACCEL (WM_USER+108)
#define UDM_SETBASE  (WM_USER+109)
#define UDM_GETBASE  (WM_USER+110)


extern W32LdrExport commctrl_exports[];


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __COMMCTRL_H__ */
