/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __MSVCRT_H__
#define __MSVCRT_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#ifndef _BSD_SOURCE
# define _BSD_SOURCE
#endif /* not _BSD_SOURCE */
#ifndef _GNU_SOURCE
# define _GNU_SOURCE
#endif /* not _GNU_SOURCE */
#ifndef _XOPEN_SOURCE
# define _XOPEN_SOURCE
#endif /* not _XOPEN_SOURCE */
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#ifdef HAVE_ALLOCA_H
# include <alloca.h>
#endif /* HAVE_ALLOCA_H */
#ifdef HAVE_COMPLEX_H
# include <complex.h>
#endif /* HAVE_COMPLEX_H */
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif /* HAVE_FCNTL_H */
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif /* HAVE_SYS_STAT_H */
#ifdef HAVE_SYS_TIMEB_H
# include <sys/timeb.h>
#endif /* HAVE_SYS_TIMEB_H */
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif /* HAVE_UNISTD_H */
#ifdef HAVE_UTIME_H
# include <utime.h>
#endif /* HAVE_UTIME_H */

#ifndef _alloca
# define _alloca alloca
#endif /* not _alloca */
#ifndef _cabs
# define _cabs cabs
#endif /* not _cabs */
#ifndef _close
# define _close close
#endif /* not _close */
#ifndef _copysign
# define _copysign copysign
#endif /* not _copysign */
#ifndef _dup
# define _dup dup
#endif /* not _dup */
#ifndef _dup2
# define _dup2 dup2
#endif /* not _dup2 */
#ifndef _ecvt
# define _ecvt ecvt
#endif /* not _ecvt */
#ifndef _fcloseall
# define _fcloseall fcloseall
#endif /* not _fcloseall */
#ifndef _fcvt
# define _fcvt fcvt
#endif /* not _fcvt */
#ifndef _fileno
# define _fileno fileno
#endif /* not _fileno */
#ifndef _finite
# define _finite finite
#endif /* not _finite */
#ifndef _fstat
# define _fstat fstat
#endif /* not _fstat */
#ifndef _ftime
# define _ftime ftime
#endif /* not _ftime */
#ifndef _gcvt
# define _gcvt gcvt
#endif /* not _gcvt */
#ifndef _getpid
# define _getpid getpid
#endif /* not _getpid */
#ifndef _getw
# define _getw getw
#endif /* not _getw */
#ifndef _hypot
# define _hypot hypot
#endif /* not _hypot */
#ifndef __isascii
# define __isascii isascii
#endif /* not __isascii */
#ifndef _isascii
# define _isascii isascii
#endif /* not _isascii */
#ifndef _isnan
# define _isnan isnan
#endif /* not _isnan */
#ifndef _lfind
# define _lfind lfind
#endif /* not _lfind */
#ifndef _lsearch
# define _lsearch lsearch
#endif /* not _lsearch */
#ifndef _lseek
# define _lseek lseek
#endif /* not _lseek */
#ifndef _lseek64
# define _lseek64 lseek64
#endif /* not _lseek64 */
#ifndef __max
# define __max max
#endif /* not __max */
#ifndef _max
# define _max max
#endif /* not _max */
#ifndef __min
# define __min min
#endif /* not _min */
#ifndef _min
# define _min min
#endif /* not _min */
#ifndef _nextafter
# define _nextafter nextafter
#endif /* not _nextafter */
#ifndef __pclose
# define __pclose pclose
#endif /* not __pclose */
#ifndef _pclose
# define _pclose pclose
#endif /* not _pclose */
#ifndef _pipe
# define _pipe pipe
#endif /* not _pipe */
#ifndef _isatty
# define _isatty isatty
#endif /* not _isatty */
#ifndef _read
# define _read read
#endif /* not _read */
#ifndef _snprintf
# define _snprintf snprintf
#endif /* not _snprintf */
#ifndef _strdup
# define _strdup strdup
#endif /* not _strdup */
#ifndef _swab
# define _swab swab
#endif /* not _swab */
#ifndef __toascii
# define __toascii toascii
#endif /* not __toascii */
#ifndef _toascii
# define _toascii toascii
#endif /* not __toascii */
#ifndef _tolower
# define _tolower tolower
#endif /* not _tolower */
#ifndef _toupper
# define _toupper toupper
#endif /* not _toupper */
#ifndef _tzset
# define _tzset tzset
#endif /* not _tzset */
#ifndef _umask
# define _umask umask
#endif /* not _umask */
#ifndef _vsnprintf
# define _vsnprintf vsnprintf
#endif /* not _vsnprintf */
#ifndef _write
# define _write write
#endif /* not _write */

#define atoi64 _atoi64
#define beginthread _beginthread
#define beginthreadex _beginthreadex
#define c_exit _c_exit
#define cexit _cexit
#define cgets _cgets
#define chdrive _chdrive
#define chgsign _chgsign
#define chsize _chsize
#define clearfp _clearfp
#define commit _commit
#define control87 _control87
#define controlfp _controlfp
#define cprintf _cprintf
#define cputs _cputs
#define cscanf _cscanf
#define cwait _cwait
#define endthread _endthread
#define endthreadex _endthreadex
#define eof _eof
#define expand _expand
#define fgetchar _fgetchar
#define fgetwchar _fgetwchar
#define filelength _filelength
#define filelengthi64 _filelengthi64
#define findclose _findclose
#define findfirst _findfirst
#define findfirsti64 _findfirsti64
#define findnext _findnext
#define findnexti64 _findnexti64
#define flushall _flushall
#define fpclass _fpclass
#define fpieee_flt _fpieee_flt
#define fpreset _fpreset
#define fsopen _fsopen
#define fstati64 _fstati64
#define fullpath _fullpath
#define futime _futime
#define futime64 _futime64
#define get_osfhandle _get_osfhandle
#define get_sbh_threshold _get_sbh_threshold
#define getch _getch
#define getche _getche
#define getdcwd _getdcwd
#define getdrive _getdrive
#define getmbcp _getmbcp
#define heapadd _heapadd
#define heapchk _heapchk
#define heapmin _heapmin
#define heapset _heapset
#define heapwalk _heapwalk
#define i64toa _i64toa
#define i64tow _i64tow
#define inp _inp
#define inpw _inpw
#define inpd _inpd
#define iscsym __iscsym
#define _iscsym __iscsym
#define iscsymf __iscsymf
#define _iscsymf __iscsymf
#define ismbbalnum _ismbbalnum
#define ismbbalpha _ismbbalpha
#define ismbbgraph _ismbbgraph
#define ismbbkalnum _ismbbkalnum
#define ismbbkana _ismbbkana
#define ismbbkprint _ismbbkprint
#define ismbbkpunct _ismbbkpunct
#define ismbblead _ismbblead
#define ismbbprint _ismbbprint
#define ismbbpunct _ismbbpunct
#define ismbbtrail _ismbbtrail
#define ismbcalnum _ismbcalnum
#define ismbcalpha _ismbcalpha
#define ismbcdigit _ismbcdigit
#define ismbcgraph _ismbcgraph
#define ismbchira _ismbchira
#define ismbckata _ismbckata
#define ismbcl0 _ismbcl0
#define ismbcl1 _ismbcl1
#define ismbcl2 _ismbcl2
#define ismbclegal _ismbclegal
#define ismbclower _ismbclower
#define ismbcprint _ismbcprint
#define ismbcpunct _ismbcpunct
#define ismbcspace _ismbcspace
#define ismbcsymbol _ismbcsymbol
#define ismbcupper _ismbcupper
#define ismbslead _ismbslead
#define ismbstrail _ismbstrail
#define itoa _itoa
#define itow _itow
#define kbhit _kbhit
#define locking _locking
#define lrotl _lrotl
#define lrotr _lrotr
#define ltoa _ltoa
#define ltow _ltow
#define makepath _makepath
#define mbbtombc _mbbtombc
#define mbbtype _mbbtype
#define mbccpy _mbccpy
#define mbcjistojms _mbcjistojms
#define mbcjmstojis _mbcjmstojis
#define mbclen _mbclen
#define mbctohira _mbctohira
#define mbctokata _mbctokata
#define mbctolower _mbctolower
#define mbctombb _mbctombb
#define mbctoupper _mbctoupper
#define mbsbtype msvcrt_mbsbtype
#define mbscat _mbscat
#define mbschr _mbschr
#define mbscmp _mbscmp
#define mbscoll _mbscoll
#define mbscpy _mbscpy
#define mbscspn _mbscspn
#define mbsdec _mbsdec
#define mbsdup _mbsdup
#define mbsicmp _mbsicmp
#define mbsicoll _mbsicoll
#define mbsinc _mbsinc
#define mbslen _mbslen
#define mbslwr _mbslwr
#define mbsnbcat _mbsnbcat
#define mbsnbcmp _mbsnbcmp
#define mbsnbcnt _mbsnbcnt
#define mbsnbcoll _mbsnbcoll
#define mbsnbcpy _mbsnbcpy
#define mbsnbicoll _mbsnbicoll
#define mbsnbicmp _mbsnbicmp
#define mbsnbset _mbsnbset
#define mbsncat _mbsncat
#define mbsnccnt _mbsnccnt
#define mbsncmp _mbsncmp
#define mbsncoll _mbsncoll
#define mbsncpy _mbsncpy
#define mbsnextc _mbsnextc
#define mbsnicmp _mbsnicmp
#define mbsnicoll _mbsnicoll
#define mbsninc _mbsninc
#define mbsnset _mbsnset
#define mbspbrk _mbspbrk
#define mbsrchr _mbsrchr
#define mbsrev _mbsrev
#define mbsset _mbsset
#define mbsspn _mbsspn
#define mbsspnp _mbsspnp
#define mbsstr _mbsstr
#define mbstok _mbstok
#define mbstrlen _mbstrlen
#define mbsupr _mbsupr
#define memicmp _memicmp
#define msize _msize
#define open_osfhandle _open_osfhandle
#define outp _outp
#define outpd _outpd
#define outpw _outpw
#define putch _putch
#define putw _putw
#define putws _putws
#define rmtmp _rmtmp
#define rotl _rotl
#define rotr _rotr
#define scalb _scalb
#define searchenv _searchenv
#define set_sbh_threshold _set_sbh_threshold
#define setmaxstdio _setmaxstdio
#define setmbcp _setmbcp
#define setmode _setmode
#define snwprintf _snwprintf
#define sopen _sopen
#define spawnl _spawnl
#define spawnle _spawnle
#define spawnlp _spawnlp
#define spawnlpe _spawnlpe
#define spawnv _spawnv
#define spawnve _spawnve
#define spawnvp _spawnvp
#define spawnvpe _spawnvpe
#define splitpath _splitpath
#define stati64 _stati64
#define statusfp _statusfp
#define strdate _strdate
#define stricmp _stricmp
#define stricoll _stricoll
#define strlwr _strlwr
#define strncoll _strncoll
#define strnicmp _strnicmp
#define strnicoll _strnicoll
#define strnset _strnset
#define strrev _strrev
#define strset _strset
#define strtime _strtime
#define strupr _strupr
#define tell _tell
#define telli64 _telli64
#define tempnam _tempnam
#define ui64toa _ui64toa
#define ui64tow _ui64tow
#define ultoa _ultoa
#define ultow _ultow
#define ungetch _ungetch
#define vsnwprintf _vsnwprintf
#define waccess _waccess
#define wasctime _wasctime
#define wchdir _wchdir
#define wchmod _wchmod
#define wcreat _wcreat
#define wcsdup _wcsdup
#define wcsicmp _wcsicmp
#define wcsicoll _wcsicoll
#define wcslwr _wcslwr
#define wcsncoll _wcsncoll
#define wcsnicmp _wcsnicmp
#define wcsnicoll _wcsnicoll
#define wcsnset _wcsnset
#define wcsrev _wcsrev
#define wcsset _wcsset
#define wcsupr _wcsupr
#define wexec _wexec
#define wexecl _wexecl
#define wexecle _wexecle
#define wexeclp _wexeclp
#define wexeclpe _wexeclpe
#define wexecv _wexecv
#define wexecve _wexecve
#define wexecvp _wexecvp
#define wexecvpe _wexecvpe
#define wfdopen _wfdopen
#define wfindfirst _wfindfirst
#define wfindfirsti64 _wfindfirsti64
#define wfindnext _wfindnext
#define wfindnexti64 _wfindnexti64
#define wfopen _wfopen
#define wfreopen _wfreopen
#define wfsopen _wfsopen
#define wfullpath _wfullpath
#define wgetcwd _wgetcwd
#define wgetdcwd _wgetdcwd
#define wgetenv _wgetenv
#define wmakepath _wmakepath
#define wmkdir _wmkdir
#define wmktemp _wmktemp
#define wopen _wopen
#define wperror _wperror
#define wpopen _wpopen
#define wputenv _wputenv
#define wremove _wremove
#define wrename _wrename
#define wrmdir _wrmdir
#define wscanf _wscanf
#define wsearchenv _wsearchenv
#define wsetlocale _wsetlocale
#define wsopen _wsopen
#define wspawnl _wspawnl
#define wspawnle _wspawnle
#define wspawnlp _wspawnlp
#define wspawnlpe _wspawnlpe
#define wspawnv _wspawnv
#define wspawnve _wspawnve
#define wspawnvp _wspawnvp
#define wspawnvpe _wspawnvpe
#define wsplitpath _wsplitpath
#define wstat _wstat
#define wstati64 _wstati64
#define wstrdate _wstrdate
#define wstrtime _wstrtime
#define wsystem _wsystem
#define wtempnam _wtempnam
#define wtmpnam _wtmpnam
#define wtoi _wtoi
#define wtol _wtol
#define wunlink _wunlink
#define wutime _wutime

#ifndef HAVE_STRCOLL
# define strcoll msvcrt_strcoll
#endif  /* not HAVE_STRCOLL */
#ifndef HAVE_STRFTIME
# define strftime msvcrt_strftime
#endif /* not HAVE_STRFTIME */
#ifndef HAVE_UTIME
# define utime _utime
#endif /* not HAVE_UTIME */
#ifndef HAVE_VPRINTF
# define vfprintf msvcrt_vfprintf
# define vprintf msvcrt_vprintf
# define vsprintf msvcrt_vsprintf
#endif /* not HAVE_VPRINTF */


extern W32LdrExport msvcrt_exports[];


gint CDECL _access (const gchar *path, gint mode);
glonglong CDECL _atoi64 (const char *string);
CDECL unsigned int _clearfp (void);
char CDECL *_i64toa (glonglong value, char *string, int radix);
unsigned int CDECL _mbcjistojms (unsigned int c);
unsigned int CDECL _mbcjmstojis (unsigned int c);
unsigned char CDECL *_mbschr (const unsigned char *string, unsigned int c);
int CDECL _mbscmp (const unsigned char *string1, const unsigned char *string2);
int CDECL _mbsicmp (const unsigned char *string1, const unsigned char *string2);
size_t CDECL _mbslen (const unsigned char *string);
unsigned char CDECL *_mbslwr (unsigned char *string);
int CDECL _mbsncmp (const unsigned char *string1, const unsigned char *string2, size_t count);
unsigned char CDECL *_mbsrchr (const unsigned char *string, unsigned int c);
unsigned char CDECL *_mbsstr (const unsigned char *string1, const unsigned char *string2);
unsigned char CDECL *_mbsupr (unsigned char *string);
int CDECL _mkdir (const char *dirname);
void CDECL *_onexit (void *arg1);
int CDECL _stricmp (const char *string1, const char *string2);
char CDECL *_strlwr (char *string);
int CDECL _strnicmp (const char *string1, const char *string2, size_t count);
char CDECL *_strrev (char *string);
char CDECL *_strupr (char *string);
char CDECL *_ui64toa (gulonglong value, char *string, int radix);
int CDECL _unlink (const char *filename);
gint CDECL _waccess (const gunichar2 *path, gint mode);
gunichar2 CDECL *_wcsrev (gunichar2 *string);
int CDECL _wmkdir (const gunichar2 *dirname);
int CDECL _wunlink (const gunichar2 *filename);
int CDECL isleadbyte (int c);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MSVCRT_H__ */
