/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __OLE32_H__
#define __OLE32_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "pshpack1.h"
typedef struct _GUID
{
  LONG Data1;
  SHORT Data2;
  SHORT Data3;
  CHAR Data4[8];
} GUID, *LPGUID, CLSID, *LPCLSID, IID, *LPIID, FMTID, *LPFMTID;
#include "poppack.h"
typedef LONG HRESULT;
typedef VOID *LPUNKNOWN;
typedef LPWSTR LPOLESTR;
#define REFGUID  const GUID* const
#define REFCLSID const CLSID* const
#define REFIID   const IID* const
#define REFFMTID const FMTID* const
#define CLASS_E_NOAGGREGATION 0x80040110L
#define S_FALSE ((HRESULT)1L)


extern W32LdrExport ole32_exports[];


HRESULT WINAPI CoCreateInstance (REFCLSID rclsid, LPUNKNOWN pUnkOuter, DWORD dwClsContext, REFIID iid, LPVOID *ppv);
void WINAPI CoFreeUnusedLibraries (void);
HRESULT WINAPI CoInitialize (LPVOID lpReserved);
LPVOID WINAPI CoTaskMemAlloc (ULONG size);
void WINAPI CoTaskMemFree (LPVOID ptr);
void WINAPI CoUninitialize (void);
INT WINAPI StringFromGUID2 (REFGUID id, LPOLESTR str, INT cmax);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __OLE32_H__ */
