/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "rasapi32.h"


#ifdef W32LDR_HEADER
#include "kernel32.h"

#define RAS_MaxCallbackNumber RAS_MaxPhoneNumber
#define RAS_MaxDeviceName     128
#define RAS_MaxDeviceType     16
#define RAS_MaxEntryName      256
#define RAS_MaxPhoneNumber    128

#define RASBASE                600
#define ERROR_BUFFER_TOO_SMALL (RASBASE+3)
#define ERROR_INVALID_SIZE     (RASBASE+32)

typedef LPVOID HRASCONN, *LPHRASCONN;

#include "pshpack4.h"
typedef struct _RASCONNA
{
  DWORD dwSize;
  HRASCONN hrasconn;
  CHAR szEntryName[RAS_MaxEntryName + 1];
  CHAR szDeviceType[RAS_MaxDeviceType + 1];
  CHAR szDeviceName[RAS_MaxDeviceName + 1];
  CHAR szPhonebook[MAX_PATH];
  DWORD dwSubEntry;
} RASCONNA, *LPRASCONNA;
typedef struct _RASCONNW
{
  DWORD dwSize;
  HRASCONN hrasconn;
  WCHAR szEntryName[RAS_MaxEntryName + 1];
  WCHAR szDeviceType[RAS_MaxDeviceType + 1];
  WCHAR szDeviceName[RAS_MaxDeviceName + 1];
  WCHAR szPhonebook[MAX_PATH];
  DWORD dwSubEntry;
} RASCONNW, *LPRASCONNW;
#include "poppack.h"
#ifdef UNICODE
# define RASCONN RASCONNW
# define LPRASCONN LPRASCONNW
#else /* not UNICODE */
# define RASCONN RASCONNA
# define LPRASCONN LPRASCONNA
#endif /* not UNICODE */

#include "pshpack4.h"
typedef struct _RASENTRYNAMEA
{
  DWORD dwSize;
  CHAR szEntryName[RAS_MaxEntryName + 1];
} RASENTRYNAMEA, *LPRASENTRYNAMEA;
typedef struct _RASENTRYNAMEW
{
  DWORD dwSize;
  WCHAR szEntryName[RAS_MaxEntryName + 1];
} RASENTRYNAMEW, *LPRASENTRYNAMEW;
#include "poppack.h"
#ifdef UNICODE
# define RASENTRYNAME RASENTRYNAMEW
# define LPRASENTRYNAME LPRASENTRYNAMEW
#else /* not UNICODE */
# define RASENTRYNAME RASENTRYNAMEA
# define LPRASENTRYNAME LPRASENTRYNAMEA
#endif /* not UNICODE */

#define UNLEN 256
#define PWLEN 256
#define DNLEN 15
#include "pshpack4.h"
typedef struct _RASDIALPARAMSA
{
  DWORD dwSize;
  CHAR szEntryName[RAS_MaxEntryName + 1];
  CHAR szPhoneNumber[RAS_MaxPhoneNumber + 1];
  CHAR szCallbackNumber[RAS_MaxCallbackNumber + 1];
  CHAR szUserName[UNLEN + 1];
  CHAR szPassword[PWLEN + 1];
  CHAR szDomain[DNLEN + 1];
  DWORD dwSubEntry;
  DWORD dwCallbackId;
} RASDIALPARAMSA, *LPRASDIALPARAMSA;
typedef struct _RASDIALPARAMSW
{
  DWORD dwSize;
  WCHAR szEntryName[RAS_MaxEntryName + 1];
  WCHAR szPhoneNumber[RAS_MaxPhoneNumber + 1];
  WCHAR szCallbackNumber[RAS_MaxCallbackNumber + 1];
  WCHAR szUserName[UNLEN + 1];
  WCHAR szPassword[PWLEN + 1];
  WCHAR szDomain[DNLEN + 1];
  DWORD dwSubEntry;
  DWORD dwCallbackId;
} RASDIALPARAMSW, *LPRASDIALPARAMSW;
#include "poppack.h"
#ifdef UNICODE
# define RASDIALPARAMS RASDIALPARAMSW
# define LPRASDIALPARAMS LPRASDIALPARAMSW
#else /* not UNICODE */
# define RASDIALPARAMS RASDIALPARAMSA
# define LPRASDIALPARAMS LPRASDIALPARAMSA
#endif /* not UNICODE */

#define RASCS_PAUSED 0x1000
#define RASCS_DONE   0x2000
typedef enum _RASCONNSTATE
{
  RASCS_OpenPort = 0,
  RASCS_PortOpened,
  RASCS_ConnectDevice,
  RASCS_DeviceConnected,
  RASCS_AllDevicesConnected,
  RASCS_Authenticate,
  RASCS_AuthNotify,
  RASCS_AuthRetry,
  RASCS_AuthCallback,
  RASCS_AuthChangePassword,
  RASCS_AuthProject,
  RASCS_AuthLinkSpeed,
  RASCS_AuthAck,
  RASCS_ReAuthenticate,
  RASCS_Authenticated,
  RASCS_PrepareForCallback,
  RASCS_WaitForModemReset,
  RASCS_WaitForCallback,
  RASCS_Projected,
  RASCS_StartAuthentication,
  RASCS_CallbackComplete,
  RASCS_LogonNetwork,
  RASCS_SubEntryConnected,
  RASCS_SubEntryDisconnected,
  RASCS_Interactive = RASCS_PAUSED,
  RASCS_RetryAuthentication,
  RASCS_CallbackSetByCaller,
  RASCS_PasswordExpired,
  RASCS_Connected = RASCS_DONE,
  RASCS_Disconnected
} RASCONNSTATE, *LPRASCONNSTATE;
#include "pshpack4.h"
typedef struct _RASCONNSTATUSA
{
  DWORD dwSize;
  RASCONNSTATE rasconnstate;
  DWORD dwError;
  CHAR szDeviceType[RAS_MaxDeviceType + 1];
  CHAR szDeviceName[RAS_MaxDeviceName + 1];
} RASCONNSTATUSA, *LPRASCONNSTATUSA;
typedef struct _RASCONNSTATUSW
{
  DWORD dwSize;
  RASCONNSTATE rasconnstate;
  DWORD dwError;
  WCHAR szDeviceType[RAS_MaxDeviceType + 1];
  WCHAR szDeviceName[RAS_MaxDeviceName + 1];
} RASCONNSTATUSW, *LPRASCONNSTATUSW;
#include "poppack.h"
#ifdef UNICODE
# define RASCONNSTATUS RASCONNSTATUSW
# define LPRASCONNSTATUS LPRASCONNSTATUSW
#else /* not UNICODE */
# define RASCONNSTATUS RASCONNSTATUSA
# define LPRASCONNSTATUS LPRASCONNSTATUSA
#endif /* not UNICODE */

#include "pshpack4.h"
typedef struct _RASDIALEXTENSIONS
{
  DWORD dwSize;
  DWORD dwfOptions;
  HWND hwndParent;
  ULONG_PTR reserved;
} RASDIALEXTENSIONS, *LPRASDIALEXTENSIONS;
#include "poppack.h"
#endif /* W32LDR_HEADER */


/* DDMGetPhonebookInfo ordinal = 1, argument = 44 temporary */
static DWORD WINAPI DDMGetPhonebookInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* DwCloneEntry ordinal = 2, argument = 12 temporary */
static DWORD WINAPI DwCloneEntry (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DwDeleteSubEntry ordinal = 3, argument = 12 temporary */
static DWORD WINAPI DwDeleteSubEntry (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DwEnumEntriesForAllUsers ordinal = 4, argument = 12 temporary */
static DWORD WINAPI DwEnumEntriesForAllUsers (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DwEnumEntryDetails ordinal = 5, argument = 16 temporary */
static DWORD WINAPI DwEnumEntryDetails (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DwRasUninitialize ordinal = 6, argument = 0 temporary */
static DWORD WINAPI DwRasUninitialize (VOID)
{
  return 0;
}


/* DwSetEntryPropertiesPrivate ordinal = 7, argument = 0 temporary */
static DWORD WINAPI DwSetEntryPropertiesPrivate (VOID)
{
  return 0;
}


/* FreeSharedAccessApplication ordinal = 8, argument = 0 temporary */
static DWORD WINAPI FreeSharedAccessApplication (VOID)
{
  return 0;
}


/* FreeSharedAccessServer ordinal = 9, argument = 0 temporary */
static DWORD WINAPI FreeSharedAccessServer (VOID)
{
  return 0;
}


/* RasAutoDialSharedConnection ordinal = 10, argument = 0 temporary */
static DWORD WINAPI RasAutoDialSharedConnection (VOID)
{
  return 0;
}


/* RasAutodialAddressToNetwork ordinal = 11, argument = 12 temporary */
static DWORD WINAPI RasAutodialAddressToNetwork (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasAutodialEntryToNetwork ordinal = 12, argument = 12 temporary */
static DWORD WINAPI RasAutodialEntryToNetwork (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasClearConnectionStatistics ordinal = 13, argument = 4 temporary */
static DWORD WINAPI RasClearConnectionStatistics (DWORD dwArgv0)
{
  return 0;
}


/* RasClearLinkStatistics ordinal = 14, argument = 8 temporary */
static DWORD WINAPI RasClearLinkStatistics (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasConnectionNotificationA ordinal = 15, argument = 12 temporary */
static DWORD WINAPI RasConnectionNotificationA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasConnectionNotificationW ordinal = 16, argument = 12 temporary */
static DWORD WINAPI RasConnectionNotificationW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasCreatePhonebookEntryA ordinal = 17, argument = 8 temporary */
static DWORD WINAPI RasCreatePhonebookEntryA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasCreatePhonebookEntryW ordinal = 18, argument = 8 temporary */
static DWORD WINAPI RasCreatePhonebookEntryW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasDeleteEntryA ordinal = 19, argument = 8 temporary */
static DWORD WINAPI RasDeleteEntryA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasDeleteEntryW ordinal = 20, argument = 8 temporary */
static DWORD WINAPI RasDeleteEntryW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasDialA ordinal = 21, argument = 24 temporary */
static DWORD WINAPI RasDialA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* RasDialW ordinal = 22, argument = 24 temporary */
static DWORD WINAPI RasDialW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* RasDialWow ordinal = 23, argument = 20 temporary */
static DWORD WINAPI RasDialWow (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasEditPhonebookEntryA ordinal = 24, argument = 12 temporary */
static DWORD WINAPI RasEditPhonebookEntryA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasEditPhonebookEntryW ordinal = 25, argument = 12 temporary */
static DWORD WINAPI RasEditPhonebookEntryW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasEnumAutodialAddressesA ordinal = 26, argument = 12 temporary */
static DWORD WINAPI RasEnumAutodialAddressesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasEnumAutodialAddressesW ordinal = 27, argument = 12 temporary */
static DWORD WINAPI RasEnumAutodialAddressesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasEnumConnectionsA ordinal = 28, argument = 12 temporary */
static DWORD WINAPI RasEnumConnectionsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasEnumConnectionsW ordinal = 29, argument = 12 temporary */
static DWORD WINAPI RasEnumConnectionsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasEnumConnectionsWow ordinal = 30, argument = 12 temporary */
static DWORD WINAPI RasEnumConnectionsWow (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasEnumDevicesA ordinal = 31, argument = 12 temporary */
static DWORD WINAPI RasEnumDevicesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasEnumDevicesW ordinal = 32, argument = 12 temporary */
static DWORD WINAPI RasEnumDevicesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasEnumEntriesA ordinal = 33, argument = 20 temporary */
static DWORD WINAPI RasEnumEntriesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasEnumEntriesW ordinal = 34, argument = 20 temporary */
static DWORD WINAPI RasEnumEntriesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasEnumEntriesWow ordinal = 35, argument = 20 temporary */
static DWORD WINAPI RasEnumEntriesWow (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasFreeEapUserIdentityA ordinal = 36, argument = 4 temporary */
static DWORD WINAPI RasFreeEapUserIdentityA (DWORD dwArgv0)
{
  return 0;
}


/* RasFreeEapUserIdentityW ordinal = 37, argument = 4 temporary */
static DWORD WINAPI RasFreeEapUserIdentityW (DWORD dwArgv0)
{
  return 0;
}


/* RasFreeLanConnTable ordinal = 38, argument = 0 temporary */
static DWORD WINAPI RasFreeLanConnTable (VOID)
{
  return 0;
}


/* RasFreeSharedAccessSettings ordinal = 39, argument = 0 temporary */
static DWORD WINAPI RasFreeSharedAccessSettings (VOID)
{
  return 0;
}


/* RasGetAutodialAddressA ordinal = 40, argument = 20 temporary */
static DWORD WINAPI RasGetAutodialAddressA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasGetAutodialAddressW ordinal = 41, argument = 20 temporary */
static DWORD WINAPI RasGetAutodialAddressW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasGetAutodialEnableA ordinal = 42, argument = 8 temporary */
static DWORD WINAPI RasGetAutodialEnableA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasGetAutodialEnableW ordinal = 43, argument = 8 temporary */
static DWORD WINAPI RasGetAutodialEnableW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasGetAutodialParamA ordinal = 44, argument = 12 temporary */
static DWORD WINAPI RasGetAutodialParamA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetAutodialParamW ordinal = 45, argument = 12 temporary */
static DWORD WINAPI RasGetAutodialParamW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetConnectResponse ordinal = 46, argument = 8 temporary */
static DWORD WINAPI RasGetConnectResponse (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasGetConnectStatusA ordinal = 47, argument = 8 temporary */
static DWORD WINAPI RasGetConnectStatusA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasGetConnectStatusW ordinal = 48, argument = 8 temporary */
static DWORD WINAPI RasGetConnectStatusW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasGetConnectStatusWow ordinal = 49, argument = 8 temporary */
static DWORD WINAPI RasGetConnectStatusWow (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasGetConnectionStatistics ordinal = 50, argument = 8 temporary */
static DWORD WINAPI RasGetConnectionStatistics (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasGetCountryInfoA ordinal = 51, argument = 8 temporary */
static DWORD WINAPI RasGetCountryInfoA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasGetCountryInfoW ordinal = 52, argument = 8 temporary */
static DWORD WINAPI RasGetCountryInfoW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasGetCredentialsA ordinal = 53, argument = 12 temporary */
static DWORD WINAPI RasGetCredentialsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetCredentialsW ordinal = 54, argument = 12 temporary */
static DWORD WINAPI RasGetCredentialsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetCustomAuthDataA ordinal = 55, argument = 16 temporary */
static DWORD WINAPI RasGetCustomAuthDataA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RasGetCustomAuthDataW ordinal = 56, argument = 16 temporary */
static DWORD WINAPI RasGetCustomAuthDataW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RasGetEapUserDataA ordinal = 57, argument = 20 temporary */
static DWORD WINAPI RasGetEapUserDataA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasGetEapUserDataW ordinal = 58, argument = 20 temporary */
static DWORD WINAPI RasGetEapUserDataW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasGetEapUserIdentityA ordinal = 59, argument = 20 temporary */
static DWORD WINAPI RasGetEapUserIdentityA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasGetEapUserIdentityW ordinal = 60, argument = 20 temporary */
static DWORD WINAPI RasGetEapUserIdentityW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasGetEntryDialParamsA ordinal = 61, argument = 12 temporary */
static DWORD WINAPI RasGetEntryDialParamsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetEntryDialParamsW ordinal = 62, argument = 12 temporary */
static DWORD WINAPI RasGetEntryDialParamsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetEntryHrasconnA ordinal = 63, argument = 12 temporary */
static DWORD WINAPI RasGetEntryHrasconnA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetEntryHrasconnW ordinal = 64, argument = 12 temporary */
static DWORD WINAPI RasGetEntryHrasconnW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetEntryPropertiesA ordinal = 65, argument = 24 temporary */
static DWORD WINAPI RasGetEntryPropertiesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* RasGetEntryPropertiesW ordinal = 66, argument = 24 temporary */
static DWORD WINAPI RasGetEntryPropertiesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* RasGetErrorStringA ordinal = 67, argument = 12 temporary */
static DWORD WINAPI RasGetErrorStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetErrorStringW ordinal = 68, argument = 12 temporary */
static DWORD WINAPI RasGetErrorStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetErrorStringWow ordinal = 69, argument = 12 temporary */
static DWORD WINAPI RasGetErrorStringWow (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetHport ordinal = 70, argument = 4 temporary */
static DWORD WINAPI RasGetHport (DWORD dwArgv0)
{
  return 0;
}


/* RasGetLinkStatistics ordinal = 71, argument = 12 temporary */
static DWORD WINAPI RasGetLinkStatistics (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetProjectionInfoA ordinal = 72, argument = 16 temporary */
static DWORD WINAPI RasGetProjectionInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RasGetProjectionInfoW ordinal = 73, argument = 16 temporary */
static DWORD WINAPI RasGetProjectionInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RasGetSubEntryHandleA ordinal = 74, argument = 12 temporary */
static DWORD WINAPI RasGetSubEntryHandleA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetSubEntryHandleW ordinal = 75, argument = 12 temporary */
static DWORD WINAPI RasGetSubEntryHandleW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasGetSubEntryPropertiesA ordinal = 76, argument = 28 temporary */
static DWORD WINAPI RasGetSubEntryPropertiesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* RasGetSubEntryPropertiesW ordinal = 77, argument = 28 temporary */
static DWORD WINAPI RasGetSubEntryPropertiesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* RasHangUpA ordinal = 78, argument = 4 temporary */
static DWORD WINAPI RasHangUpA (DWORD dwArgv0)
{
  return 0;
}


/* RasHangUpW ordinal = 79, argument = 4 temporary */
static DWORD WINAPI RasHangUpW (DWORD dwArgv0)
{
  return 0;
}


/* RasHangUpWow ordinal = 80, argument = 4 temporary */
static DWORD WINAPI RasHangUpWow (DWORD dwArgv0)
{
  return 0;
}


/* RasInvokeEapUI ordinal = 81, argument = 16 temporary */
static DWORD WINAPI RasInvokeEapUI (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RasIsRouterConnection ordinal = 82, argument = 4 temporary */
static DWORD WINAPI RasIsRouterConnection (DWORD dwArgv0)
{
  return 0;
}


/* RasIsSharedConnection ordinal = 83, argument = 8 temporary */
static DWORD WINAPI RasIsSharedConnection (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasLoadSharedAccessSettings ordinal = 84, argument = 0 temporary */
static DWORD WINAPI RasLoadSharedAccessSettings (VOID)
{
  return 0;
}


/* RasNameFromSharedConnection ordinal = 85, argument = 0 temporary */
static DWORD WINAPI RasNameFromSharedConnection (VOID)
{
  return 0;
}


/* RasQueryLanConnTable ordinal = 86, argument = 0 temporary */
static DWORD WINAPI RasQueryLanConnTable (VOID)
{
  return 0;
}


/* RasQueryRedialOnLinkFailure ordinal = 87, argument = 12 temporary */
static DWORD WINAPI RasQueryRedialOnLinkFailure (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasQuerySharedAutoDial ordinal = 88, argument = 4 temporary */
static DWORD WINAPI RasQuerySharedAutoDial (DWORD dwArgv0)
{
  return 0;
}


/* RasQuerySharedConnection ordinal = 89, argument = 4 temporary */
static DWORD WINAPI RasQuerySharedConnection (DWORD dwArgv0)
{
  return 0;
}


/* RasQuerySharedConnectionCredentials ordinal = 90, argument = 0 temporary */
static DWORD WINAPI RasQuerySharedConnectionCredentials (VOID)
{
  return 0;
}


/* RasQuerySharedPrivateLan ordinal = 91, argument = 0 temporary */
static DWORD WINAPI RasQuerySharedPrivateLan (VOID)
{
  return 0;
}


/* RasQuerySharedPrivateLanAddress ordinal = 92, argument = 0 temporary */
static DWORD WINAPI RasQuerySharedPrivateLanAddress (VOID)
{
  return 0;
}


/* RasRenameEntryA ordinal = 93, argument = 12 temporary */
static DWORD WINAPI RasRenameEntryA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasRenameEntryW ordinal = 94, argument = 12 temporary */
static DWORD WINAPI RasRenameEntryW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasSaveSharedAccessSettings ordinal = 95, argument = 0 temporary */
static DWORD WINAPI RasSaveSharedAccessSettings (VOID)
{
  return 0;
}


/* RasSetAutodialAddressA ordinal = 96, argument = 20 temporary */
static DWORD WINAPI RasSetAutodialAddressA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasSetAutodialAddressW ordinal = 97, argument = 20 temporary */
static DWORD WINAPI RasSetAutodialAddressW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasSetAutodialEnableA ordinal = 98, argument = 8 temporary */
static DWORD WINAPI RasSetAutodialEnableA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasSetAutodialEnableW ordinal = 99, argument = 8 temporary */
static DWORD WINAPI RasSetAutodialEnableW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasSetAutodialParamA ordinal = 100, argument = 12 temporary */
static DWORD WINAPI RasSetAutodialParamA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasSetAutodialParamW ordinal = 101, argument = 12 temporary */
static DWORD WINAPI RasSetAutodialParamW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasSetCredentialsA ordinal = 102, argument = 16 temporary */
static DWORD WINAPI RasSetCredentialsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RasSetCredentialsW ordinal = 103, argument = 16 temporary */
static DWORD WINAPI RasSetCredentialsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RasSetCustomAuthDataA ordinal = 104, argument = 16 temporary */
static DWORD WINAPI RasSetCustomAuthDataA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RasSetCustomAuthDataW ordinal = 105, argument = 16 temporary */
static DWORD WINAPI RasSetCustomAuthDataW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RasSetEapUserDataA ordinal = 106, argument = 20 temporary */
static DWORD WINAPI RasSetEapUserDataA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasSetEapUserDataW ordinal = 107, argument = 20 temporary */
static DWORD WINAPI RasSetEapUserDataW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RasSetEntryDialParamsA ordinal = 108, argument = 12 temporary */
static DWORD WINAPI RasSetEntryDialParamsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasSetEntryDialParamsW ordinal = 109, argument = 12 temporary */
static DWORD WINAPI RasSetEntryDialParamsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasSetEntryPropertiesA ordinal = 110, argument = 24 temporary */
static DWORD WINAPI RasSetEntryPropertiesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* RasSetEntryPropertiesW ordinal = 111, argument = 24 temporary */
static DWORD WINAPI RasSetEntryPropertiesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* RasSetOldPassword ordinal = 112, argument = 8 temporary */
static DWORD WINAPI RasSetOldPassword (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasSetSharedAutoDial ordinal = 113, argument = 4 temporary */
static DWORD WINAPI RasSetSharedAutoDial (DWORD dwArgv0)
{
  return 0;
}


/* RasSetSharedConnectionCredentials ordinal = 114, argument = 0 temporary */
static DWORD WINAPI RasSetSharedConnectionCredentials (VOID)
{
  return 0;
}


/* RasSetSubEntryPropertiesA ordinal = 115, argument = 28 temporary */
static DWORD WINAPI RasSetSubEntryPropertiesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* RasSetSubEntryPropertiesW ordinal = 116, argument = 28 temporary */
static DWORD WINAPI RasSetSubEntryPropertiesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* RasShareConnection ordinal = 117, argument = 0 temporary */
static DWORD WINAPI RasShareConnection (VOID)
{
  return 0;
}


/* RasUnshareConnection ordinal = 118, argument = 0 temporary */
static DWORD WINAPI RasUnshareConnection (VOID)
{
  return 0;
}


/* RasValidateEntryNameA ordinal = 119, argument = 8 temporary */
static DWORD WINAPI RasValidateEntryNameA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasValidateEntryNameW ordinal = 120, argument = 8 temporary */
static DWORD WINAPI RasValidateEntryNameW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasfileClose ordinal = 121, argument = 4 temporary */
static DWORD WINAPI RasfileClose (DWORD dwArgv0)
{
  return 0;
}


/* RasfileDeleteLine ordinal = 122, argument = 4 temporary */
static DWORD WINAPI RasfileDeleteLine (DWORD dwArgv0)
{
  return 0;
}


/* RasfileFindFirstLine ordinal = 123, argument = 12 temporary */
static DWORD WINAPI RasfileFindFirstLine (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasfileFindLastLine ordinal = 124, argument = 12 temporary */
static DWORD WINAPI RasfileFindLastLine (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasfileFindMarkedLine ordinal = 125, argument = 8 temporary */
static DWORD WINAPI RasfileFindMarkedLine (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasfileFindNextKeyLine ordinal = 126, argument = 12 temporary */
static DWORD WINAPI RasfileFindNextKeyLine (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasfileFindNextLine ordinal = 127, argument = 12 temporary */
static DWORD WINAPI RasfileFindNextLine (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasfileFindPrevLine ordinal = 128, argument = 12 temporary */
static DWORD WINAPI RasfileFindPrevLine (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasfileFindSectionLine ordinal = 129, argument = 12 temporary */
static DWORD WINAPI RasfileFindSectionLine (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasfileGetKeyValueFields ordinal = 130, argument = 12 temporary */
static DWORD WINAPI RasfileGetKeyValueFields (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasfileGetLine ordinal = 131, argument = 4 temporary */
static DWORD WINAPI RasfileGetLine (DWORD dwArgv0)
{
  return 0;
}


/* RasfileGetLineMark ordinal = 132, argument = 4 temporary */
static DWORD WINAPI RasfileGetLineMark (DWORD dwArgv0)
{
  return 0;
}


/* RasfileGetLineText ordinal = 133, argument = 8 temporary */
static DWORD WINAPI RasfileGetLineText (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasfileGetLineType ordinal = 134, argument = 4 temporary */
static DWORD WINAPI RasfileGetLineType (DWORD dwArgv0)
{
  return 0;
}


/* RasfileGetSectionName ordinal = 135, argument = 8 temporary */
static DWORD WINAPI RasfileGetSectionName (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasfileInsertLine ordinal = 136, argument = 12 temporary */
static DWORD WINAPI RasfileInsertLine (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasfileLoad ordinal = 137, argument = 16 temporary */
static DWORD WINAPI RasfileLoad (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RasfileLoadInfo ordinal = 138, argument = 8 temporary */
static DWORD WINAPI RasfileLoadInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasfilePutKeyValueFields ordinal = 139, argument = 12 temporary */
static DWORD WINAPI RasfilePutKeyValueFields (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RasfilePutLineMark ordinal = 140, argument = 8 temporary */
static DWORD WINAPI RasfilePutLineMark (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasfilePutLineText ordinal = 141, argument = 8 temporary */
static DWORD WINAPI RasfilePutLineText (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasfilePutSectionName ordinal = 142, argument = 8 temporary */
static DWORD WINAPI RasfilePutSectionName (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RasfileWrite ordinal = 143, argument = 8 temporary */
static DWORD WINAPI RasfileWrite (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SharedAccessResponseListToString ordinal = 144, argument = 8 temporary */
static DWORD WINAPI SharedAccessResponseListToString (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SharedAccessResponseStringToList ordinal = 145, argument = 12 temporary */
static DWORD WINAPI SharedAccessResponseStringToList (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* UnInitializeRAS ordinal = 146, argument = 0 temporary */
static DWORD WINAPI UnInitializeRAS (VOID)
{
  return 0;
}


W32LdrExport rasapi32_exports[] = {
{FALSE,   1, "DDMGetPhonebookInfo",                 DDMGetPhonebookInfo},
{FALSE,   2, "DwCloneEntry",                        DwCloneEntry},
{FALSE,   3, "DwDeleteSubEntry",                    DwDeleteSubEntry},
{FALSE,   4, "DwEnumEntriesForAllUsers",            DwEnumEntriesForAllUsers},
{FALSE,   5, "DwEnumEntryDetails",                  DwEnumEntryDetails},
{FALSE,   6, "DwRasUninitialize",                   DwRasUninitialize},
{FALSE,   7, "DwSetEntryPropertiesPrivate",         DwSetEntryPropertiesPrivate},
{FALSE,   8, "FreeSharedAccessApplication",         FreeSharedAccessApplication},
{FALSE,   9, "FreeSharedAccessServer",              FreeSharedAccessServer},
{FALSE,  10, "RasAutoDialSharedConnection",         RasAutoDialSharedConnection},
{FALSE,  11, "RasAutodialAddressToNetwork",         RasAutodialAddressToNetwork},
{FALSE,  12, "RasAutodialEntryToNetwork",           RasAutodialEntryToNetwork},
{FALSE,  13, "RasClearConnectionStatistics",        RasClearConnectionStatistics},
{FALSE,  14, "RasClearLinkStatistics",              RasClearLinkStatistics},
{FALSE,  15, "RasConnectionNotificationA",          RasConnectionNotificationA},
{FALSE,  16, "RasConnectionNotificationW",          RasConnectionNotificationW},
{FALSE,  17, "RasCreatePhonebookEntryA",            RasCreatePhonebookEntryA},
{FALSE,  18, "RasCreatePhonebookEntryW",            RasCreatePhonebookEntryW},
{FALSE,  19, "RasDeleteEntryA",                     RasDeleteEntryA},
{FALSE,  20, "RasDeleteEntryW",                     RasDeleteEntryW},
{FALSE,  21, "RasDialA",                            RasDialA},
{FALSE,  22, "RasDialW",                            RasDialW},
{FALSE,  23, "RasDialWow",                          RasDialWow},
{FALSE,  24, "RasEditPhonebookEntryA",              RasEditPhonebookEntryA},
{FALSE,  25, "RasEditPhonebookEntryW",              RasEditPhonebookEntryW},
{FALSE,  26, "RasEnumAutodialAddressesA",           RasEnumAutodialAddressesA},
{FALSE,  27, "RasEnumAutodialAddressesW",           RasEnumAutodialAddressesW},
{FALSE,  28, "RasEnumConnectionsA",                 RasEnumConnectionsA},
{FALSE,  29, "RasEnumConnectionsW",                 RasEnumConnectionsW},
{FALSE,  30, "RasEnumConnectionsWow",               RasEnumConnectionsWow},
{FALSE,  31, "RasEnumDevicesA",                     RasEnumDevicesA},
{FALSE,  32, "RasEnumDevicesW",                     RasEnumDevicesW},
{FALSE,  33, "RasEnumEntriesA",                     RasEnumEntriesA},
{FALSE,  34, "RasEnumEntriesW",                     RasEnumEntriesW},
{FALSE,  35, "RasEnumEntriesWow",                   RasEnumEntriesWow},
{FALSE,  36, "RasFreeEapUserIdentityA",             RasFreeEapUserIdentityA},
{FALSE,  37, "RasFreeEapUserIdentityW",             RasFreeEapUserIdentityW},
{FALSE,  38, "RasFreeLanConnTable",                 RasFreeLanConnTable},
{FALSE,  39, "RasFreeSharedAccessSettings",         RasFreeSharedAccessSettings},
{FALSE,  40, "RasGetAutodialAddressA",              RasGetAutodialAddressA},
{FALSE,  41, "RasGetAutodialAddressW",              RasGetAutodialAddressW},
{FALSE,  42, "RasGetAutodialEnableA",               RasGetAutodialEnableA},
{FALSE,  43, "RasGetAutodialEnableW",               RasGetAutodialEnableW},
{FALSE,  44, "RasGetAutodialParamA",                RasGetAutodialParamA},
{FALSE,  45, "RasGetAutodialParamW",                RasGetAutodialParamW},
{FALSE,  46, "RasGetConnectResponse",               RasGetConnectResponse},
{FALSE,  47, "RasGetConnectStatusA",                RasGetConnectStatusA},
{FALSE,  48, "RasGetConnectStatusW",                RasGetConnectStatusW},
{FALSE,  49, "RasGetConnectStatusWow",              RasGetConnectStatusWow},
{FALSE,  50, "RasGetConnectionStatistics",          RasGetConnectionStatistics},
{FALSE,  51, "RasGetCountryInfoA",                  RasGetCountryInfoA},
{FALSE,  52, "RasGetCountryInfoW",                  RasGetCountryInfoW},
{FALSE,  53, "RasGetCredentialsA",                  RasGetCredentialsA},
{FALSE,  54, "RasGetCredentialsW",                  RasGetCredentialsW},
{FALSE,  55, "RasGetCustomAuthDataA",               RasGetCustomAuthDataA},
{FALSE,  56, "RasGetCustomAuthDataW",               RasGetCustomAuthDataW},
{FALSE,  57, "RasGetEapUserDataA",                  RasGetEapUserDataA},
{FALSE,  58, "RasGetEapUserDataW",                  RasGetEapUserDataW},
{FALSE,  59, "RasGetEapUserIdentityA",              RasGetEapUserIdentityA},
{FALSE,  60, "RasGetEapUserIdentityW",              RasGetEapUserIdentityW},
{FALSE,  61, "RasGetEntryDialParamsA",              RasGetEntryDialParamsA},
{FALSE,  62, "RasGetEntryDialParamsW",              RasGetEntryDialParamsW},
{FALSE,  63, "RasGetEntryHrasconnA",                RasGetEntryHrasconnA},
{FALSE,  64, "RasGetEntryHrasconnW",                RasGetEntryHrasconnW},
{FALSE,  65, "RasGetEntryPropertiesA",              RasGetEntryPropertiesA},
{FALSE,  66, "RasGetEntryPropertiesW",              RasGetEntryPropertiesW},
{FALSE,  67, "RasGetErrorStringA",                  RasGetErrorStringA},
{FALSE,  68, "RasGetErrorStringW",                  RasGetErrorStringW},
{FALSE,  69, "RasGetErrorStringWow",                RasGetErrorStringWow},
{FALSE,  70, "RasGetHport",                         RasGetHport},
{FALSE,  71, "RasGetLinkStatistics",                RasGetLinkStatistics},
{FALSE,  72, "RasGetProjectionInfoA",               RasGetProjectionInfoA},
{FALSE,  73, "RasGetProjectionInfoW",               RasGetProjectionInfoW},
{FALSE,  74, "RasGetSubEntryHandleA",               RasGetSubEntryHandleA},
{FALSE,  75, "RasGetSubEntryHandleW",               RasGetSubEntryHandleW},
{FALSE,  76, "RasGetSubEntryPropertiesA",           RasGetSubEntryPropertiesA},
{FALSE,  77, "RasGetSubEntryPropertiesW",           RasGetSubEntryPropertiesW},
{FALSE,  78, "RasHangUpA",                          RasHangUpA},
{FALSE,  79, "RasHangUpW",                          RasHangUpW},
{FALSE,  80, "RasHangUpWow",                        RasHangUpWow},
{FALSE,  81, "RasInvokeEapUI",                      RasInvokeEapUI},
{FALSE,  82, "RasIsRouterConnection",               RasIsRouterConnection},
{FALSE,  83, "RasIsSharedConnection",               RasIsSharedConnection},
{FALSE,  84, "RasLoadSharedAccessSettings",         RasLoadSharedAccessSettings},
{FALSE,  85, "RasNameFromSharedConnection",         RasNameFromSharedConnection},
{FALSE,  86, "RasQueryLanConnTable",                RasQueryLanConnTable},
{FALSE,  87, "RasQueryRedialOnLinkFailure",         RasQueryRedialOnLinkFailure},
{FALSE,  88, "RasQuerySharedAutoDial",              RasQuerySharedAutoDial},
{FALSE,  89, "RasQuerySharedConnection",            RasQuerySharedConnection},
{FALSE,  90, "RasQuerySharedConnectionCredentials", RasQuerySharedConnectionCredentials},
{FALSE,  91, "RasQuerySharedPrivateLan",            RasQuerySharedPrivateLan},
{FALSE,  92, "RasQuerySharedPrivateLanAddress",     RasQuerySharedPrivateLanAddress},
{FALSE,  93, "RasRenameEntryA",                     RasRenameEntryA},
{FALSE,  94, "RasRenameEntryW",                     RasRenameEntryW},
{FALSE,  95, "RasSaveSharedAccessSettings",         RasSaveSharedAccessSettings},
{FALSE,  96, "RasSetAutodialAddressA",              RasSetAutodialAddressA},
{FALSE,  97, "RasSetAutodialAddressW",              RasSetAutodialAddressW},
{FALSE,  98, "RasSetAutodialEnableA",               RasSetAutodialEnableA},
{FALSE,  99, "RasSetAutodialEnableW",               RasSetAutodialEnableW},
{FALSE, 100, "RasSetAutodialParamA",                RasSetAutodialParamA},
{FALSE, 101, "RasSetAutodialParamW",                RasSetAutodialParamW},
{FALSE, 102, "RasSetCredentialsA",                  RasSetCredentialsA},
{FALSE, 103, "RasSetCredentialsW",                  RasSetCredentialsW},
{FALSE, 104, "RasSetCustomAuthDataA",               RasSetCustomAuthDataA},
{FALSE, 105, "RasSetCustomAuthDataW",               RasSetCustomAuthDataW},
{FALSE, 106, "RasSetEapUserDataA",                  RasSetEapUserDataA},
{FALSE, 107, "RasSetEapUserDataW",                  RasSetEapUserDataW},
{FALSE, 108, "RasSetEntryDialParamsA",              RasSetEntryDialParamsA},
{FALSE, 109, "RasSetEntryDialParamsW",              RasSetEntryDialParamsW},
{FALSE, 110, "RasSetEntryPropertiesA",              RasSetEntryPropertiesA},
{FALSE, 111, "RasSetEntryPropertiesW",              RasSetEntryPropertiesW},
{FALSE, 112, "RasSetOldPassword",                   RasSetOldPassword},
{FALSE, 113, "RasSetSharedAutoDial",                RasSetSharedAutoDial},
{FALSE, 114, "RasSetSharedConnectionCredentials",   RasSetSharedConnectionCredentials},
{FALSE, 115, "RasSetSubEntryPropertiesA",           RasSetSubEntryPropertiesA},
{FALSE, 116, "RasSetSubEntryPropertiesW",           RasSetSubEntryPropertiesW},
{FALSE, 117, "RasShareConnection",                  RasShareConnection},
{FALSE, 118, "RasUnshareConnection",                RasUnshareConnection},
{FALSE, 119, "RasValidateEntryNameA",               RasValidateEntryNameA},
{FALSE, 120, "RasValidateEntryNameW",               RasValidateEntryNameW},
{FALSE, 121, "RasfileClose",                        RasfileClose},
{FALSE, 122, "RasfileDeleteLine",                   RasfileDeleteLine},
{FALSE, 123, "RasfileFindFirstLine",                RasfileFindFirstLine},
{FALSE, 124, "RasfileFindLastLine",                 RasfileFindLastLine},
{FALSE, 125, "RasfileFindMarkedLine",               RasfileFindMarkedLine},
{FALSE, 126, "RasfileFindNextKeyLine",              RasfileFindNextKeyLine},
{FALSE, 127, "RasfileFindNextLine",                 RasfileFindNextLine},
{FALSE, 128, "RasfileFindPrevLine",                 RasfileFindPrevLine},
{FALSE, 129, "RasfileFindSectionLine",              RasfileFindSectionLine},
{FALSE, 130, "RasfileGetKeyValueFields",            RasfileGetKeyValueFields},
{FALSE, 131, "RasfileGetLine",                      RasfileGetLine},
{FALSE, 132, "RasfileGetLineMark",                  RasfileGetLineMark},
{FALSE, 133, "RasfileGetLineText",                  RasfileGetLineText},
{FALSE, 134, "RasfileGetLineType",                  RasfileGetLineType},
{FALSE, 135, "RasfileGetSectionName",               RasfileGetSectionName},
{FALSE, 136, "RasfileInsertLine",                   RasfileInsertLine},
{FALSE, 137, "RasfileLoad",                         RasfileLoad},
{FALSE, 138, "RasfileLoadInfo",                     RasfileLoadInfo},
{FALSE, 139, "RasfilePutKeyValueFields",            RasfilePutKeyValueFields},
{FALSE, 140, "RasfilePutLineMark",                  RasfilePutLineMark},
{FALSE, 141, "RasfilePutLineText",                  RasfilePutLineText},
{FALSE, 142, "RasfilePutSectionName",               RasfilePutSectionName},
{FALSE, 143, "RasfileWrite",                        RasfileWrite},
{FALSE, 144, "SharedAccessResponseListToString",    SharedAccessResponseListToString},
{FALSE, 145, "SharedAccessResponseStringToList",    SharedAccessResponseStringToList},
{FALSE, 146, "UnInitializeRAS",                     UnInitializeRAS},
{FALSE,   0, NULL,                                  NULL}};
