/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "user32.h"
#if GLIB_CHECK_VERSION(2,2,0)
# include <glib/gprintf.h>
#endif /* GLIB_CHECK_VERSION(2,2,0) */
#include <gdk/gdkkeysyms.h>
#include "kernel32.h"
#include "misc/misc.h"
#include "misc/pixbuf.h"


#ifdef W32LDR_HEADER
#include "gdi32.h"
/* ja:システム */
#define COLOR_SCROLLBAR               0
#define COLOR_BACKGROUND              1
#define COLOR_DESKTOP                 COLOR_BACKGROUND
#define COLOR_ACTIVECAPTION           2
#define COLOR_INACTIVECAPTION         3
#define COLOR_MENU                    4
#define COLOR_WINDOW                  5
#define COLOR_WINDOWFRAME             6
#define COLOR_MENUTEXT                7
#define COLOR_WINDOWTEXT              8
#define COLOR_CAPTIONTEXT             9
#define COLOR_ACTIVEBORDER            10
#define COLOR_INACTIVEBORDER          11
#define COLOR_APPWORKSPACE            12
#define COLOR_HIGHLIGHT               13
#define COLOR_HIGHLIGHTTEXT           14
#define COLOR_BTNFACE                 15
#define COLOR_3DFACE                  COLOR_BTNFACE
#define COLOR_BTNSHADOW               16
#define COLOR_3DSHADOW                COLOR_BTNSHADOW
#define COLOR_GRAYTEXT                17
#define COLOR_BTNTEXT                 18
#define COLOR_INACTIVECAPTIONTEXT     19
#define COLOR_BTNHIGHLIGHT            20
#define COLOR_3DHIGHLIGHT             COLOR_BTNHIGHLIGHT
#define COLOR_3DHILIGHT               COLOR_BTNHIGHLIGHT
#define COLOR_BTNHILIGHT              COLOR_BTNHIGHLIGHT
#define COLOR_3DDKSHADOW              21
#define COLOR_3DLIGHT                 22
#define COLOR_INFOTEXT                23
#define COLOR_INFOBK                  24
#define COLOR_ALTERNATEBTNFACE        25
#define COLOR_HOTLIGHT                26
#define COLOR_GRADIENTACTIVECAPTION   27
#define COLOR_GRADIENTINACTIVECAPTION 28
#define COLOR_MENUHILIGHT             29
#define COLOR_MENUBAR                 30
#define SM_CXSCREEN          0
#define SM_CYSCREEN          1
#define SM_CXVSCROLL         2
#define SM_CYHSCROLL         3
#define SM_CYCAPTION         4
#define SM_CXBORDER          5
#define SM_CYBORDER          6
#define SM_CXDLGFRAME        7
#define SM_CYDLGFRAME        8
#define SM_CYVTHUMB          9
#define SM_CXHTHUMB          10
#define SM_CXICON            11
#define SM_CYICON            12
#define SM_CXCURSOR          13
#define SM_CYCURSOR          14
#define SM_CYMENU            15
#define SM_CXFULLSCREEN      16
#define SM_CYFULLSCREEN      17
#define SM_CYKANJIWINDOW     18
#define SM_MOUSEPRESENT      19
#define SM_CYVSCROLL         20
#define SM_CXHSCROLL         21
#define SM_DEBUG             22
#define SM_SWAPBUTTON        23
#define SM_RESERVED1         24
#define SM_RESERVED2         25
#define SM_RESERVED3         26
#define SM_RESERVED4         27
#define SM_CXMIN             28
#define SM_CYMIN             29
#define SM_CXSIZE            30
#define SM_CYSIZE            31
#define SM_CXFRAME           32
#define SM_CYFRAME           33
#define SM_CXMINTRACK        34
#define SM_CYMINTRACK        35
#define SM_CXDOUBLECLK       36
#define SM_CYDOUBLECLK       37
#define SM_CXICONSPACING     38
#define SM_CYICONSPACING     39
#define SM_MENUDROPALIGNMENT 40
#define SM_PENWINDOWS        41
#define SM_DBCSENABLED       42
#define SM_CMOUSEBUTTONS     43
#define SM_CXFIXEDFRAME      SM_CXDLGFRAME
#define SM_CYFIXEDFRAME      SM_CYDLGFRAME
#define SM_CXSIZEFRAME       SM_CXFRAME
#define SM_CYSIZEFRAME       SM_CYFRAME
#define SM_SECURE            44
#define SM_CXEDGE            45
#define SM_CYEDGE            46
#define SM_CXMINSPACING      47
#define SM_CYMINSPACING      48
#define SM_CXSMICON          49
#define SM_CYSMICON          50
#define SM_CYSMCAPTION       51
#define SM_CXSMSIZE          52
#define SM_CYSMSIZE          53
#define SM_CXMENUSIZE        54
#define SM_CYMENUSIZE        55
#define SM_ARRANGE           56
#define SM_CXMINIMIZED       57
#define SM_CYMINIMIZED       58
#define SM_CXMAXTRACK        59
#define SM_CYMAXTRACK        60
#define SM_CXMAXIMIZED       61
#define SM_CYMAXIMIZED       62
#define SM_NETWORK           63
#define SM_CLEANBOOT         67
#define SM_CXDRAG            68
#define SM_CYDRAG            69
#define SM_SHOWSOUNDS        70
#define SM_CXMENUCHECK       71
#define SM_CYMENUCHECK       72
#define SM_SLOWMACHINE       73
#define SM_MIDEASTENABLED    74
#define SM_MOUSEWHEELPRESENT 75
#define SM_XVIRTUALSCREEN    76
#define SM_YVIRTUALSCREEN    77
#define SM_CXVIRTUALSCREEN   78
#define SM_CYVIRTUALSCREEN   79
#define SM_CMONITORS         80
#define SM_SAMEDISPLAYFORMAT 81
#define SM_IMMENABLED        82
#define SM_CXFOCUSBORDER     83
#define SM_CYFOCUSBORDER     84
#define SM_TABLETPC          86
#define SM_MEDIACENTER       87
#define SM_STARTER           88
#define SM_SERVERR2          89
#define SM_CMETRICS          90
#define SPI_GETBEEP               1
#define SPI_SETBEEP               2
#define SPI_GETMOUSE              3
#define SPI_SETMOUSE              4
#define SPI_GETBORDER             5
#define SPI_SETBORDER             6
#define SPI_GETKEYBOARDSPEED      10
#define SPI_SETKEYBOARDSPEED      11
#define SPI_LANGDRIVER            12
#define SPI_ICONHORIZONTALSPACING 13
#define SPI_GETSCREENSAVETIMEOUT  14
#define SPI_SETSCREENSAVETIMEOUT  15
#define SPI_GETSCREENSAVEACTIVE   16
#define SPI_SETSCREENSAVEACTIVE   17
#define SPI_GETGRIDGRANULARITY    18
#define SPI_SETGRIDGRANULARITY    19
#define SPI_SETDESKWALLPAPER      20
#define SPI_SETDESKPATTERN        21
#define SPI_GETKEYBOARDDELAY      22
#define SPI_SETKEYBOARDDELAY      23
#define SPI_ICONVERTICALSPACING   24
#define SPI_GETICONTITLEWRAP      25
#define SPI_SETICONTITLEWRAP      26
#define SPI_GETMENUDROPALIGNMENT  27
#define SPI_SETMENUDROPALIGNMENT  28
#define SPI_SETDOUBLECLKWIDTH     29
#define SPI_SETDOUBLECLKHEIGHT    30
#define SPI_GETICONTITLELOGFONT   31
#define SPI_SETDOUBLECLICKTIME    32
#define SPI_SETMOUSEBUTTONSWAP    33
#define SPI_SETICONTITLELOGFONT   34
#define SPI_GETFASTTASKSWITCH     35
#define SPI_SETFASTTASKSWITCH     36
#define SPI_SETDRAGFULLWINDOWS    37
#define SPI_GETDRAGFULLWINDOWS    38
#define SPI_GETNONCLIENTMETRICS   41
#define SPI_SETNONCLIENTMETRICS   42
#define SPI_GETMINIMIZEDMETRICS   43
#define SPI_SETMINIMIZEDMETRICS   44
#define SPI_GETICONMETRICS        45
#define SPI_SETICONMETRICS        46
#define SPI_SETWORKAREA           47
#define SPI_GETWORKAREA           48
#define SPI_SETPENWINDOWS         49
#define SPI_GETFILTERKEYS         50
#define SPI_SETFILTERKEYS         51
#define SPI_GETTOGGLEKEYS         52
#define SPI_SETTOGGLEKEYS         53
#define SPI_GETMOUSEKEYS          54
#define SPI_SETMOUSEKEYS          55
#define SPI_GETSHOWSOUNDS         56
#define SPI_SETSHOWSOUNDS         57
#define SPI_GETSTICKYKEYS         58
#define SPI_SETSTICKYKEYS         59
#define SPI_GETACCESSTIMEOUT      60
#define SPI_SETACCESSTIMEOUT      61
#define SPI_GETSERIALKEYS         62
#define SPI_SETSERIALKEYS         63
#define SPI_GETSOUNDSENTRY        64
#define SPI_SETSOUNDSENTRY        65
#define SPI_GETHIGHCONTRAST       66
#define SPI_SETHIGHCONTRAST       67
#define SPI_GETKEYBOARDPREF       68
#define SPI_SETKEYBOARDPREF       69
#define SPI_GETSCREENREADER       70
#define SPI_SETSCREENREADER       71
#define SPI_GETANIMATION          72
#define SPI_SETANIMATION          73
#define SPI_GETFONTSMOOTHING      74
#define SPI_SETFONTSMOOTHING      75
#define SPI_SETDRAGWIDTH          76
#define SPI_SETDRAGHEIGHT         77
#define SPI_SETHANDHELD           78
#define SPI_GETLOWPOWERTIMEOUT    79
#define SPI_GETPOWEROFFTIMEOUT    80
#define SPI_SETLOWPOWERTIMEOUT    81
#define SPI_SETPOWEROFFTIMEOUT    82
#define SPI_GETLOWPOWERACTIVE     83
#define SPI_GETPOWEROFFACTIVE     84
#define SPI_SETLOWPOWERACTIVE     85
#define SPI_SETPOWEROFFACTIVE     86
#define SPI_SETCURSORS            87
#define SPI_SETICONS              88
#define SPI_GETDEFAULTINPUTLANG   89
#define SPI_SETDEFAULTINPUTLANG   90
#define SPI_SETLANGTOGGLE         91
#define SPI_GETWINDOWSEXTENSION   92
#define SPI_SETMOUSETRAILS        93
#define SPI_GETMOUSETRAILS        94
#define SPI_GETSNAPTODEFBUTTON    95
#define SPI_SETSNAPTODEFBUTTON    96
#define SPI_SETSCREENSAVERRUNNING 97
#define SPI_SCREENSAVERRUNNING    SPI_SETSCREENSAVERRUNNING
#define SPI_GETMOUSEHOVERWIDTH    98
#define SPI_SETMOUSEHOVERWIDTH    99
#define SPI_GETMOUSEHOVERHEIGHT   100
#define SPI_SETMOUSEHOVERHEIGHT   101
#define SPI_GETMOUSEHOVERTIME     102
#define SPI_SETMOUSEHOVERTIME     103
#define SPI_GETWHEELSCROLLLINES   104
#define SPI_SETWHEELSCROLLLINES   105
#define SPI_GETMENUSHOWDELAY      106
#define SPI_SETMENUSHOWDELAY      107
#define SPI_GETSHOWIMEUI          110
#define SPI_SETSHOWIMEUI          111
#define SPI_GETMOUSESPEED         112
#define SPI_SETMOUSESPEED         113
#define SPI_GETSCREENSAVERRUNNING 114
#define SPI_GETDESKWALLPAPER      115

/* ja:描画 */
#include "pshpack1.h"
typedef struct _POINT
{
  LONG x;
  LONG y;
} POINT, *PPOINT, *LPPOINT;
typedef struct _RECT
{
  LONG left;
  LONG top;
  LONG right;
  LONG bottom;
} RECT, *PRECT, *LPRECT;
typedef const RECT *LPCRECT;
typedef struct _PAINTSTRUCT
{
  HDC hdc;
  BOOL fErase;
  RECT rcPaint;
  BOOL fRestore;
  BOOL fIncUpdate;
  BYTE rgbReserved[32];
} PAINTSTRUCT, *PPAINTSTRUCT, *LPPAINTSTRUCT;
#include "poppack.h"
/* ja:ウエイト */
#define WAIT_TIMEOUT 0x00000102
#define INFINITE     0xffffffff
/* ja:アイコン */
typedef LPVOID HICON;
/* ja:カーソル */
#define IDC_ARROW       MAKEINTRESOURCE(32512)
#define IDC_IBEAM       MAKEINTRESOURCE(32513)
#define IDC_WAIT        MAKEINTRESOURCE(32514)
#define IDC_CROSS       MAKEINTRESOURCE(32515)
#define IDC_UPARROW     MAKEINTRESOURCE(32516)
#define IDC_SIZE        MAKEINTRESOURCE(32640)
#define IDC_ICON        MAKEINTRESOURCE(32641)
#define IDC_SIZENWSE    MAKEINTRESOURCE(32642)
#define IDC_SIZENESW    MAKEINTRESOURCE(32643)
#define IDC_SIZEWE      MAKEINTRESOURCE(32644)
#define IDC_SIZENS      MAKEINTRESOURCE(32645)
#define IDC_SIZEALL     MAKEINTRESOURCE(32646)
#define IDC_NO          MAKEINTRESOURCE(32648)
#define IDC_HAND        MAKEINTRESOURCE(32649)
#define IDC_APPSTARTING MAKEINTRESOURCE(32650)
#define IDC_HELP        MAKEINTRESOURCE(32651)
typedef LPVOID HCURSOR;
/* ja:ビットマップ */
typedef GdkPixbuf *HBITMAP;
#include "pshpack1.h"
typedef struct _BITMAPINFOHEADER
{
  DWORD biSize;
  LONG biWidth;
  LONG biHeight;
  WORD biPlanes;
  WORD biBitCount;
  DWORD biCompression;
  DWORD biSizeImage;
  LONG biXPelsPerMeter;
  LONG biYPelsPerMeter;
  DWORD biClrUsed;
  DWORD biClrImportant;
} BITMAPINFOHEADER, *PBITMAPINFOHEADER, *LPBITMAPINFOHEADER;
#include "poppack.h"
/* ja:メニュー */
#define MF_INSERT          0x00000000
#define MF_CHANGE          0x00000080
#define MF_APPEND          0x00000100
#define MF_DELETE          0x00000200
#define MF_REMOVE          0x00001000
#define MF_BYCOMMAND       0x00000000
#define MF_BYPOSITION      0x00000400
#define MF_SEPARATOR       0x00000800
#define MF_ENABLED         0x00000000
#define MF_GRAYED          0x00000001
#define MF_DISABLED        0x00000002
#define MF_UNCHECKED       0x00000000
#define MF_CHECKED         0x00000008
#define MF_USECHECKBITMAPS 0x00000200
#define MF_STRING          0x00000000
#define MF_BITMAP          0x00000004
#define MF_OWNERDRAW       0x00000100
#define MF_POPUP           0x00000010
#define MF_MENUBARBREAK    0x00000020
#define MF_MENUBREAK       0x00000040
#define MF_UNHILITE        0x00000000
#define MF_HILITE          0x00000080
#define MF_DEFAULT         0x00001000
#define MF_SYSMENU         0x00002000
#define MF_HELP            0x00004000
#define MF_RIGHTJUSTIFY    0x00004000
#define MF_MOUSESELECT     0x00008000
#define MF_END             0x00000080
#define MIIM_STATE      0x00000001
#define MIIM_ID         0x00000002
#define MIIM_SUBMENU    0x00000004
#define MIIM_CHECKMARKS 0x00000008
#define MIIM_TYPE       0x00000010
#define MIIM_DATA       0x00000020
#define MIIM_STRING     0x00000040
#define MIIM_BITMAP     0x00000080
#define MIIM_FTYPE      0x00000100
#define TPM_LEFTBUTTON   0x0000
#define TPM_RIGHTBUTTON  0x0002
#define TPM_LEFTALIGN    0x0000
#define TPM_CENTERALIGN  0x0004
#define TPM_RIGHTALIGN   0x0008
#define TPM_TOPALIGN     0x0000
#define TPM_VCENTERALIGN 0x0010
#define TPM_BOTTOMALIGN  0x0020
#define TPM_HORIZONTAL   0x0000
#define TPM_VERTICAL     0x0040
#define TPM_RETURNCMD    0x0100
typedef LPVOID HMENU;
#include "pshpack1.h"
typedef struct _MENUITEMINFOA
{
  UINT cbSize;
  UINT fMask;
  UINT fType;
  UINT fState;
  UINT wID;
  HMENU hSubMenu;
  HBITMAP hbmpChecked;
  HBITMAP hbmpUnchecked;
  ULONG_PTR dwItemData;
  LPSTR dwTypeData;
  UINT cch;
  HBITMAP hbmpItem;
} MENUITEMINFOA, *PMENUITEMINFOA, *LPMENUITEMINFOA;
typedef struct _MENUITEMINFOW
{
  UINT cbSize;
  UINT fMask;
  UINT fType;
  UINT fState;
  UINT wID;
  HMENU hSubMenu;
  HBITMAP hbmpChecked;
  HBITMAP hbmpUnchecked;
  ULONG_PTR dwItemData;
  LPWSTR dwTypeData;
  UINT cch;
  HBITMAP hbmpItem;
} MENUITEMINFOW, *PMENUITEMINFOW, *LPMENUITEMINFOW;
#include "poppack.h"
#ifdef UNICODE
# define MENUITEMINFO MENUITEMINFOW
# define PMENUITEMINFO PMENUITEMINFOW
# define LPMENUITEMINFO LPMENUITEMINFOW
#else /* not UNICODE */
# define MENUITEMINFO MENUITEMINFOA
# define PMENUITEMINFO PMENUITEMINFOA
# define LPMENUITEMINFO LPMENUITEMINFOA
#endif /* not UNICODE */
/* ja:アクセラレータ */
typedef LPVOID HACCEL;
/* ja:クリップボード */
#define CF_TEXT        1
#define CF_OEMTEXT     7
#define CF_UNICODETEXT 13
/* ja:メッセージ */
#define PM_NOREMOVE 0x0000
#define PM_REMOVE   0x0001
#include "pshpack1.h"
typedef struct _MSG
{
  HWND hwnd;
  UINT message;
  WPARAM wParam;
  LPARAM lParam;
  DWORD time;
  POINT pt;
} MSG, *PMSG, *LPMSG;
#include "poppack.h"
/* ja:ウインドウ */
#define HWND_DESKTOP NULL
#define CW_USEDEFAULT ((INT)0x80000000)
#define GWL_USERDATA   (-21)
#define GWL_EXSTYLE    (-20)
#define GWL_STYLE      (-16)
#define GWL_ID         (-12)
#define GWL_HWNDPARENT (-8)
#define GWL_HINSTANCE  (-6)
#define GWL_WNDPROC    (-4)
#define DWL_MSGRESULT 0
#define DWL_DLGPROC   4
#define DWL_USER      8
#define GW_HWNDFIRST 0
#define GW_HWNDLAST  1
#define GW_HWNDNEXT  2
#define GW_HWNDPREV  3
#define GW_OWNER     4
#define GW_CHILD     5
#define SW_HIDE            0
#define SW_SHOWNORMAL      1
#define SW_NORMAL          1
#define SW_SHOWMINIMIZED   2
#define SW_SHOWMAXIMIZED   3
#define SW_MAXIMIZE        3
#define SW_SHOWNOACTIVATE  4
#define SW_SHOW            5
#define SW_MINIMIZE        6
#define SW_SHOWMINNOACTIVE 7
#define SW_SHOWNA          8
#define SW_RESTORE         9
#define SW_SHOWDEFAULT     10
#define SW_FORCEMINIMIZE   11
#define SW_MAX             11
#define SW_NORMALNA        0xcc
#define HWND_TOP       ((HWND)0)
#define HWND_BOTTOM    ((HWND)1)
#define HWND_TOPMOST   ((HWND)-1)
#define HWND_NOTOPMOST ((HWND)-2)
#define HWND_MESSAGE   ((HWND)-3)
#define SWP_NOSIZE         0x0001
#define SWP_NOMOVE         0x0002
#define SWP_NOZORDER       0x0004
#define SWP_NOREDRAW       0x0008
#define SWP_NOACTIVATE     0x0010
#define SWP_FRAMECHANGED   0x0020
#define SWP_SHOWWINDOW     0x0040
#define SWP_HIDEWINDOW     0x0080
#define SWP_NOCOPYBITS     0x0100
#define SWP_NOOWNERZORDER  0x0200
#define SWP_DRAWFRAME      SWP_FRAMECHANGED
#define SWP_NOREPOSITION   SWP_NOOWNERZORDER
#define SWP_NOSENDCHANGING 0x0400
#define SWP_DEFERERASE     0x2000
#define SWP_ASYNCWINDOWPOS 0x4000
#define WS_OVERLAPPED          0x00000000
#define WS_POPUP               0x80000000
#define WS_CHILD               0x40000000
#define WS_MINIMIZE            0x20000000
#define WS_VISIBLE             0x10000000
#define WS_DISABLED            0x08000000
#define WS_CLIPSIBLINGS        0x04000000
#define WS_CLIPCHILDREN        0x02000000
#define WS_MAXIMIZE            0x01000000
#define WS_CAPTION             0x00c00000
#define WS_BORDER              0x00800000
#define WS_DLGFRAME            0x00400000
#define WS_VSCROLL             0x00200000
#define WS_HSCROLL             0x00100000
#define WS_SYSMENU             0x00080000
#define WS_THICKFRAME          0x00040000
#define WS_GROUP               0x00020000
#define WS_TABSTOP             0x00010000
#define WS_MINIMIZEBOX         0x00020000
#define WS_MAXIMIZEBOX         0x00010000
#define WS_TILED               WS_OVERLAPPED
#define WS_ICONIC              WS_MINIMIZE
#define WS_SIZEBOX             WS_THICKFRAME
#define WS_OVERLAPPEDWINDOW    (WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_MINIMIZEBOX|WS_MAXIMIZEBOX)
#define WS_POPUPWINDOW         (WS_POPUP|WS_BORDER|WS_SYSMENU)
#define WS_CHILDWINDOW         (WS_CHILD)
#define WS_TILEDWINDOW         (WS_OVERLAPPEDWINDOW)
#define WS_EX_DLGMODALFRAME    0x00000001
#define WS_EX_DRAGDETECT       0x00000002
#define WS_EX_NOPARENTNOTIFY   0x00000004
#define WS_EX_TOPMOST          0x00000008
#define WS_EX_ACCEPTFILES      0x00000010
#define WS_EX_TRANSPARENT      0x00000020
#define WS_EX_MDICHILD         0x00000040
#define WS_EX_TOOLWINDOW       0x00000080
#define WS_EX_WINDOWEDGE       0x00000100
#define WS_EX_CLIENTEDGE       0x00000200
#define WS_EX_CONTEXTHELP      0x00000400
#define WS_EX_RIGHT            0x00001000
#define WS_EX_LEFT             0x00000000
#define WS_EX_RTLREADING       0x00002000
#define WS_EX_LTRREADING       0x00000000
#define WS_EX_LEFTSCROLLBAR    0x00004000
#define WS_EX_RIGHTSCROLLBAR   0x00000000
#define WS_EX_CONTROLPARENT    0x00010000
#define WS_EX_STATICEDGE       0x00020000
#define WS_EX_APPWINDOW        0x00040000
#define WS_EX_LAYOUTRTL        0x00400000
#define WS_EX_NOINHERITLAYOUT  0x00100000
#define WS_EX_OVERLAPPEDWINDOW (WS_EX_WINDOWEDGE|WS_EX_CLIENTEDGE)
#define WS_EX_PALETTEWINDOW    (WS_EX_WINDOWEDGE|WS_EX_TOOLWINDOW|WS_EX_TOPMOST)
#define WS_EX_LAYERED          0x00080000L
#define WS_EX_TRAYWINDOW       0x80000000L
typedef LRESULT (CALLBACK *WNDPROC)(HWND, UINT, WPARAM, LPARAM);
typedef INT_PTR (CALLBACK *DLGPROC)(HWND, UINT, WPARAM, LPARAM);
typedef BOOL CALLBACK (*WNDENUMPROC)(HWND, LPARAM);
#include "pshpack1.h"
typedef struct _WNDCLASSEXA
{
  UINT cbSize;
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCSTR lpszMenuName;
  LPCSTR lpszClassName;
  HICON hIconSm;
} WNDCLASSEXA, *PWNDCLASSEXA, *LPWNDCLASSEXA;
typedef struct _WNDCLASSEXW
{
  UINT cbSize;
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCWSTR lpszMenuName;
  LPCWSTR lpszClassName;
  HICON hIconSm;
} WNDCLASSEXW, *PWNDCLASSEXW, *LPWNDCLASSEXW;
#include "poppack.h"
#ifdef UNICODE
# define WNDCLASSEX WNDCLASSEXW
# define PWNDCLASSEX PWNDCLASSEXW
# define LPWNDCLASSEX LPWNDCLASSEXW
#else /* not UNICODE */
# define WNDCLASSEX WNDCLASSEXA
# define PWNDCLASSEX PWNDCLASSEXA
# define LPWNDCLASSEX LPWNDCLASSEXA
#endif /* not UNICODE */
/* ja:メッセージ */
#define WM_NULL                   0x0000
#define WM_CREATE                 0x0001
#define WM_DESTROY                0x0002
#define WM_MOVE                   0x0003
#define WM_SIZEWAIT               0x0004
#define WM_SIZE                   0x0005
#define WM_ACTIVATE               0x0006
#define WM_SETFOCUS               0x0007
#define WM_KILLFOCUS              0x0008
#define WM_SETVISIBLE             0x0009
#define WM_ENABLE                 0x000a
#define WM_SETREDRAW              0x000b
#define WM_SETTEXT                0x000c
#define WM_GETTEXT                0x000d
#define WM_GETTEXTLENGTH          0x000e
#define WM_PAINT                  0x000f
#define WM_CLOSE                  0x0010
#define WM_QUERYENDSESSION        0x0011
#define WM_QUIT                   0x0012
#define WM_QUERYOPEN              0x0013
#define WM_ERASEBKGND             0x0014
#define WM_SYSCOLORCHANGE         0x0015
#define WM_ENDSESSION             0x0016
#define WM_SYSTEMERROR            0x0017
#define WM_SHOWWINDOW             0x0018
#define WM_CTLCOLOR               0x0019
#define WM_WININICHANGE           0x001a
#define WM_SETTINGCHANGE          WM_WININICHANGE
#define WM_DEVMODECHANGE          0x001b
#define WM_ACTIVATEAPP            0x001c
#define WM_FONTCHANGE             0x001d
#define WM_TIMECHANGE             0x001e
#define WM_CANCELMODE             0x001f
#define WM_SETCURSOR              0x0020
#define WM_MOUSEACTIVATE          0x0021
#define WM_CHILDACTIVATE          0x0022
#define WM_QUEUESYNC              0x0023
#define WM_GETMINMAXINFO          0x0024
#define WM_PAINTICON              0x0026
#define WM_ICONERASEBKGND         0x0027
#define WM_NEXTDLGCTL             0x0028
#define WM_ALTTABACTIVE           0x0029
#define WM_SPOOLERSTATUS          0x002a
#define WM_DRAWITEM               0x002b
#define WM_MEASUREITEM            0x002c
#define WM_DELETEITEM             0x002d
#define WM_VKEYTOITEM             0x002e
#define WM_CHARTOITEM             0x002f
#define WM_SETFONT                0x0030
#define WM_GETFONT                0x0031
#define WM_SETHOTKEY              0x0032
#define WM_GETHOTKEY              0x0033
#define WM_FILESYSCHANGE          0x0034
#define WM_ISACTIVEICON           0x0035
#define WM_QUERYPARKICON          0x0036
#define WM_QUERYDRAGICON          0x0037
#define WM_QUERYSAVESTATE         0x0038
#define WM_COMPAREITEM            0x0039
#define WM_TESTING                0x003a
#define WM_GETOBJECT              0x003d
#define WM_ACTIVATESHELLWINDOW    0x003e
#define WM_COMPACTING             0x0041
#define WM_COMMNOTIFY             0x0044
#define WM_WINDOWPOSCHANGING      0x0046
#define WM_WINDOWPOSCHANGED       0x0047
#define WM_POWER                  0x0048
#define WM_COPYDATA               0x004a
#define WM_CANCELJOURNAL          0x004b
#define WM_NOTIFY                 0x004e
#define WM_INPUTLANGCHANGEREQUEST 0x0050
#define WM_INPUTLANGCHANGE        0x0051
#define WM_TCARD                  0x0052
#define WM_HELP                   0x0053
#define WM_USERCHANGED            0x0054
#define WM_NOTIFYFORMAT           0x0055
#define WM_CONTEXTMENU            0x007b
#define WM_STYLECHANGING          0x007c
#define WM_STYLECHANGED           0x007d
#define WM_DISPLAYCHANGE          0x007e
#define WM_GETICON                0x007f
#define WM_SETICON                0x0080
#define WM_NCCREATE               0x0081
#define WM_NCDESTROY              0x0082
#define WM_NCCALCSIZE             0x0083
#define WM_NCHITTEST              0x0084
#define WM_NCPAINT                0x0085
#define WM_NCACTIVATE             0x0086
#define WM_GETDLGCODE             0x0087
#define WM_SYNCPAINT              0x0088
#define WM_SYNCTASK               0x0089
#define WM_NCMOUSEMOVE            0x00a0
#define WM_NCLBUTTONDOWN          0x00a1
#define WM_NCLBUTTONUP            0x00a2
#define WM_NCLBUTTONDBLCLK        0x00a3
#define WM_NCRBUTTONDOWN          0x00a4
#define WM_NCRBUTTONUP            0x00a5
#define WM_NCRBUTTONDBLCLK        0x00a6
#define WM_NCMBUTTONDOWN          0x00a7
#define WM_NCMBUTTONUP            0x00a8
#define WM_NCMBUTTONDBLCLK        0x00a9
#define WM_NCXBUTTONDOWN          0x00ab
#define WM_NCXBUTTONUP            0x00ac
#define WM_NCXBUTTONDBLCLK        0x00ad
#define WM_KEYDOWN                0x0100
#define WM_KEYFIRST               WM_KEYDOWN
#define WM_KEYUP                  0x0101
#define WM_CHAR                   0x0102
#define WM_DEADCHAR               0x0103
#define WM_SYSKEYDOWN             0x0104
#define WM_SYSKEYUP               0x0105
#define WM_SYSCHAR                0x0106
#define WM_SYSDEADCHAR            0x0107
#define WM_KEYLAST                0x0108
#define WM_IME_STARTCOMPOSITION   0x010d
#define WM_IME_ENDCOMPOSITION     0x010e
#define WM_IME_COMPOSITION        0x010f
#define WM_IME_KEYLAST            WM_IME_COMPOSITION
#define WM_INITDIALOG             0x0110
#define WM_COMMAND                0x0111
#define WM_SYSCOMMAND             0x0112
#define WM_TIMER                  0x0113
#define WM_HSCROLL                0x0114
#define WM_VSCROLL                0x0115
#define WM_INITMENU               0x0116
#define WM_INITMENUPOPUP          0x0117
#define WM_SYSTIMER               0x0118
#define WM_MENUSELECT             0x011f
#define WM_MENUCHAR               0x0120
#define WM_ENTERIDLE              0x0121
#define WM_MENURBUTTONUP          0x0122
#define WM_MENUDRAG               0x0123
#define WM_MENUGETOBJECT          0x0124
#define WM_UNINITMENUPOPUP        0x0125
#define WM_MENUCOMMAND            0x0126
#define WM_CHANGEUISTATE          0x0127
#define WM_UPDATEUISTATE          0x0128
#define WM_QUERYUISTATE           0x0129
#define WM_LBTRACKPOINT           0x0131
#define WM_CTLCOLORMSGBOX         0x0132
#define WM_CTLCOLOREDIT           0x0133
#define WM_CTLCOLORLISTBOX        0x0134
#define WM_CTLCOLORBTN            0x0135
#define WM_CTLCOLORDLG            0x0136
#define WM_CTLCOLORSCROLLBAR      0x0137
#define WM_CTLCOLORSTATIC         0x0138
#define WM_MOUSEMOVE              0x0200
#define WM_MOUSEFIRST             WM_MOUSEMOVE
#define WM_LBUTTONDOWN            0x0201
#define WM_LBUTTONUP              0x0202
#define WM_LBUTTONDBLCLK          0x0203
#define WM_RBUTTONDOWN            0x0204
#define WM_RBUTTONUP              0x0205
#define WM_RBUTTONDBLCLK          0x0206
#define WM_MBUTTONDOWN            0x0207
#define WM_MBUTTONUP              0x0208
#define WM_MBUTTONDBLCLK          0x0209
#define WM_MOUSEWHEEL             0x020a
#define WM_XBUTTONDOWN            0x020b
#define WM_XBUTTONUP              0x020c
#define WM_XBUTTONDBLCLK          0x020d
#define WM_MOUSELAST              0x020d
#define WM_PARENTNOTIFY           0x0210
#define WM_ENTERMENULOOP          0x0211
#define WM_EXITMENULOOP           0x0212
#define WM_NEXTMENU               0x0213
#define WM_SIZING                 0x0214
#define WM_CAPTURECHANGED         0x0215
#define WM_MOVING                 0x0216
#define WM_POWERBROADCAST         0x0218
#define WM_DEVICECHANGE           0x0219
#define WM_MDICREATE              0x0220
#define WM_MDIDESTROY             0x0221
#define WM_MDIACTIVATE            0x0222
#define WM_MDIRESTORE             0x0223
#define WM_MDINEXT                0x0224
#define WM_MDIMAXIMIZE            0x0225
#define WM_MDITILE                0x0226
#define WM_MDICASCADE             0x0227
#define WM_MDIICONARRANGE         0x0228
#define WM_MDIGETACTIVE           0x0229
#define WM_MDIREFRESHMENU         0x0234
#define WM_DROPOBJECT             0x022a
#define WM_QUERYDROPOBJECT        0x022b
#define WM_BEGINDRAG              0x022c
#define WM_DRAGLOOP               0x022d
#define WM_DRAGSELECT             0x022e
#define WM_DRAGMOVE               0x022f
#define WM_MDISETMENU             0x0230
#define WM_ENTERSIZEMOVE          0x0231
#define WM_EXITSIZEMOVE           0x0232
#define WM_DROPFILES              0x0233
#define WM_IME_SETCONTEXT         0x0281
#define WM_IME_NOTIFY             0x0282
#define WM_IME_CONTROL            0x0283
#define WM_IME_COMPOSITIONFULL    0x0284
#define WM_IME_SELECT             0x0285
#define WM_IME_CHAR               0x0286
#define WM_IME_REQUEST            0x0288
#define WM_IME_KEYDOWN            0x0290
#define WM_IME_KEYUP              0x0291
#define WM_CUT                    0x0300
#define WM_COPY                   0x0301
#define WM_PASTE                  0x0302
#define WM_CLEAR                  0x0303
#define WM_UNDO                   0x0304
#define WM_RENDERFORMAT           0x0305
#define WM_RENDERALLFORMATS       0x0306
#define WM_DESTROYCLIPBOARD       0x0307
#define WM_DRAWCLIPBOARD          0x0308
#define WM_PAINTCLIPBOARD         0x0309
#define WM_VSCROLLCLIPBOARD       0x030a
#define WM_SIZECLIPBOARD          0x030b
#define WM_ASKCBFORMATNAME        0x030c
#define WM_CHANGECBCHAIN          0x030d
#define WM_HSCROLLCLIPBOARD       0x030e
#define WM_QUERYNEWPALETTE        0x030f
#define WM_PALETTEISCHANGING      0x0310
#define WM_PALETTECHANGED         0x0311
#define WM_HOTKEY                 0x0312
#define WM_PRINT                  0x0317
#define WM_PRINTCLIENT            0x0318
#define WM_THEMECHANGED           0x031a
#define WM_PENWINFIRST            0x0380
#define WM_PENWINLAST             0x038f
#define WM_USER                   0x0400
#define WM_APP                    0x8000
  /* en:WM_NOTIFY */
#include "pshpack1.h"
typedef struct _NMHDR
{
  HWND hwndFrom;
  UINT_PTR idFrom;
  UINT code;
} NMHDR, *PNMHDR, *LPNMHDR;
#include "poppack.h"
  /* en:WM_[LMR]BUTTONDBLCLK/WM_[LMR]BUTTONDOWN/WM_[LMR]BUTTONUP */
#define MK_LBUTTON  0x0001
#define MK_RBUTTON  0x0002
#define MK_SHIFT    0x0004
#define MK_CONTROL  0x0008
#define MK_MBUTTON  0x0010
  /* ja:マウスメッセージ */
#define XBUTTON1 0x0001
#define XBUTTON2 0x0002
#define WHEEL_DELTA      120
#define WHEEL_PAGESCROLL (UINT_MAX)
#define GET_WHEEL_DELTA_WPARAM(wParam) ((SHORT)HIWORD(wParam))
  /* en:WM_MOVING/WM_SIZING wParam */
#define WMSZ_LEFT        1
#define WMSZ_RIGHT       2
#define WMSZ_TOP         3
#define WMSZ_TOPLEFT     4
#define WMSZ_TOPRIGHT    5
#define WMSZ_BOTTOM      6
#define WMSZ_BOTTOMLEFT  7
#define WMSZ_BOTTOMRIGHT 8
  /* en:WM_SIZE wParam */
#define SIZE_RESTORED  0
#define SIZE_MINIMIZED 1
#define SIZE_MAXIMIZED 2
#define SIZE_MAXSHOW   3
#define SIZE_MAXHIDE   4
  /* en:WM_POWERBROADCAST wParam */
#define PBT_APMQUERYSUSPEND       0x0000
#define PBT_APMQUERYSTANDBY       0x0001
#define PBT_APMQUERYSUSPENDFAILED 0x0002
#define PBT_APMQUERYSTANDBYFAILED 0x0003
#define PBT_APMSUSPEND            0x0004
#define PBT_APMSTANDBY            0x0005
#define PBT_APMRESUMECRITICAL     0x0006
#define PBT_APMRESUMESUSPEND      0x0007
#define PBT_APMRESUMESTANDBY      0x0008
#define PBT_APMBATTERYLOW         0x0009
#define PBT_APMPOWERSTATUSCHANGE  0x000a
#define PBT_APMOEMEVENT           0x000b
#define PBT_APMRESUMEAUTOMATIC    0x0012
  /* en:WM_H/VSCROLL */
#define SB_LINEUP        0
#define SB_LINELEFT      0
#define SB_LINEDOWN      1
#define SB_LINERIGHT     1
#define SB_PAGEUP        2
#define SB_PAGELEFT      2
#define SB_PAGEDOWN      3
#define SB_PAGERIGHT     3
#define SB_THUMBPOSITION 4
#define SB_THUMBTRACK    5
#define SB_TOP           6
#define SB_LEFT          6
#define SB_BOTTOM        7
#define SB_RIGHT         7
#define SB_ENDSCROLL     8
  /* ja:スクロールバー */
#define SB_HORZ 0
#define SB_VERT 1
#define SB_CTL  2
#define SB_BOTH 3
  /* ja:WM_SYSCOMMANDパラメータ */
#define SC_SIZE         0xf000
#define SC_MOVE         0xf010
#define SC_MINIMIZE     0xf020
#define SC_MAXIMIZE     0xf030
#define SC_NEXTWINDOW   0xf040
#define SC_PREVWINDOW   0xf050
#define SC_CLOSE        0xf060
#define SC_VSCROLL      0xf070
#define SC_HSCROLL      0xf080
#define SC_MOUSEMENU    0xf090
#define SC_KEYMENU      0xf100
#define SC_ARRANGE      0xf110
#define SC_RESTORE      0xf120
#define SC_TASKLIST     0xf130
#define SC_SCREENSAVE   0xf140
#define SC_HOTKEY       0xf150
#define SC_DEFAULT      0xf160
#define SC_MONITORPOWER 0xf170
#define SC_CONTEXTHELP  0xf180
#define SC_SEPARATOR    0xf00f
#define SC_ICON         SC_MINIMIZE
#define SC_ZOOM         SC_MAXIMIZE
/* ja:ダイアログ */
#define DialogBoxA(a,b,c,d) DialogBoxParamA(a,b,c,d,0)
#define DialogBoxW(a,b,c,d) DialogBoxParamW(a,b,c,d,0)
#ifdef UNICODE
# define DialogBox(a,b,c,d) DialogBoxParamW(a,b,c,d,0)
#else /* not UNICODE */
# define DialogBox(a,b,c,d) DialogBoxParamA(a,b,c,d,0)
#endif /* not UNICODE */
#define DS_ABSALIGN      0x0001
#define DS_SYSMODAL      0x0002
#define DS_3DLOOK        0x0004
#define DS_FIXEDSYS      0x0008
#define DS_NOFAILCREATE  0x0010
#define DS_LOCALEDIT     0x0020
#define DS_SETFONT       0x0040
#define DS_MODALFRAME    0x0080
#define DS_NOIDLEMSG     0x0100
#define DS_SETFOREGROUND 0x0200
#define DS_CONTROL       0x0400
#define DS_CENTER        0x0800
#define DS_CENTERMOUSE   0x1000
#define DS_CONTEXTHELP   0x2000
#define DS_USEPIXELS     0x8000
#define DS_SHELLFONT     (DS_SETFONT|DS_FIXEDSYS)
#define DM_GETDEFID      (WM_USER+0)
#define DM_SETDEFID      (WM_USER+1)
#define DM_REPOSITION    (WM_USER+2)
#define DC_HASDEFID      0x534b
#include "pshpack2.h"
typedef struct _DLGTEMPLATE
{
  DWORD style;
  DWORD exstyle;
  WORD cdit;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
} DLGTEMPLATE, *PDLGTEMPLATE, *LPDLGTEMPLATE;
typedef CONST DLGTEMPLATE *PCDLGTEMPLATE, *LPCDLGTEMPLATE;
typedef struct _DLGITEMTEMPLATE
{
  DWORD style;
  DWORD exstyle;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
  WORD ID;
} DLGITEMTEMPLATE, *PDLGITEMTEMPLATE, *LPDLGITEMTEMPLATE;
typedef CONST DLGITEMTEMPLATE *PCDLGITEMTEMPLATE, *LCPDLGITEMTEMPLATE;
typedef struct _DLGTEMPLATEEX
{
  WORD dlgVer;
  WORD signature;
  DWORD helpID;
  DWORD exstyle;
  DWORD style;
  WORD cdit;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
} DLGTEMPLATEEX, *PDLGTEMPLATEEX, *LPDLGTEMPLATEEX;
typedef CONST DLGTEMPLATEEX *PCDLGTEMPLATEEX, *LPCDLGTEMPLATEEX;
typedef struct _DLGITEMTEMPLATEEX
{
  DWORD helpID;
  DWORD exstyle;
  DWORD style;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
  WORD ID;
} DLGITEMTEMPLATEEX, *PDLGITEMTEMPLATEEX, *LPDLGITEMTEMPLATEEX;
typedef CONST DLGITEMTEMPLATEEX *PCDLGITEMTEMPLATEEX, *LPCDLGITEMTEMPLATEEX;
#include "poppack.h"
/* ja:ボタンコントロール */
#define BS_PUSHBUTTON          0x00000000
#define BS_DEFPUSHBUTTON       0x00000001
#define BS_CHECKBOX            0x00000002
#define BS_AUTOCHECKBOX        0x00000003
#define BS_RADIOBUTTON         0x00000004
#define BS_3STATE              0x00000005
#define BS_AUTO3STATE          0x00000006
#define BS_GROUPBOX            0x00000007
#define BS_USERBUTTON          0x00000008
#define BS_AUTORADIOBUTTON     0x00000009
#define BS_OWNERDRAW           0x0000000b
#define BS_TYPEMASK            0x0000000f
#define BS_LEFTTEXT            0x00000020
#define BS_RIGHTBUTTON         BS_LEFTTEXT
#define BS_TEXT                0x00000000L
#define BS_ICON                0x00000040
#define BS_BITMAP              0x00000080
#define BS_LEFT                0x00000100
#define BS_RIGHT               0x00000200
#define BS_CENTER              0x00000300
#define BS_TOP                 0x00000400
#define BS_BOTTOM              0x00000800
#define BS_VCENTER             0x00000c00
#define BS_PUSHLIKE            0x00001000
#define BS_MULTILINE           0x00002000
#define BS_NOTIFY              0x00004000
#define BS_FLAT                0x00008000
#define BM_GETCHECK            0x00f0
#define BM_SETCHECK            0x00f1
#define BM_GETSTATE            0x00f2
#define BM_SETSTATE            0x00f3
#define BM_SETSTYLE            0x00f4
#define BM_CLICK               0x00f5
#define BM_GETIMAGE            0x00f6
#define BM_SETIMAGE            0x00f7
#define BN_CLICKED             0
#define BN_PAINT               1
#define BN_HILITE              2
#define BN_PUSHED              BN_HILITE
#define BN_UNHILITE            3
#define BN_UNPUSHED            BN_UNHILITE
#define BN_DISABLE             4
#define BN_DOUBLECLICKED       5
#define BN_DBLCLK              BN_DOUBLECLICKED
#define BN_SETFOCUS            6
#define BN_KILLFOCUS           7
#define BST_UNCHECKED          0x0000
#define BST_CHECKED            0x0001
#define BST_INDETERMINATE      0x0002
#define BST_PUSHED             0x0004
#define BST_FOCUS              0x0008
/* ja:コンボボックスコントロール */
#define CBS_SIMPLE               0x0001
#define CBS_DROPDOWN             0x0002
#define CBS_DROPDOWNLIST         0x0003
#define CBS_OWNERDRAWFIXED       0x0010
#define CBS_OWNERDRAWVARIABLE    0x0020
#define CBS_AUTOHSCROLL          0x0040
#define CBS_OEMCONVERT           0x0080
#define CBS_SORT                 0x0100
#define CBS_HASSTRINGS           0x0200
#define CBS_NOINTEGRALHEIGHT     0x0400
#define CBS_DISABLENOSCROLL      0x0800
#define CBS_UPPERCASE            0x2000
#define CBS_LOWERCASE            0x4000
#define CB_GETEDITSEL            0x0140
#define CB_LIMITTEXT             0x0141
#define CB_SETEDITSEL            0x0142
#define CB_ADDSTRING             0x0143
#define CB_DELETESTRING          0x0144
#define CB_DIR                   0x0145
#define CB_GETCOUNT              0x0146
#define CB_GETCURSEL             0x0147
#define CB_GETLBTEXT             0x0148
#define CB_GETLBTEXTLEN          0x0149
#define CB_INSERTSTRING          0x014a
#define CB_RESETCONTENT          0x014b
#define CB_FINDSTRING            0x014c
#define CB_SELECTSTRING          0x014d
#define CB_SETCURSEL             0x014e
#define CB_SHOWDROPDOWN          0x014f
#define CB_GETITEMDATA           0x0150
#define CB_SETITEMDATA           0x0151
#define CB_GETDROPPEDCONTROLRECT 0x0152
#define CB_SETITEMHEIGHT         0x0153
#define CB_GETITEMHEIGHT         0x0154
#define CB_SETEXTENDEDUI         0x0155
#define CB_GETEXTENDEDUI         0x0156
#define CB_GETDROPPEDSTATE       0x0157
#define CB_FINDSTRINGEXACT       0x0158
#define CB_SETLOCALE             0x0159
#define CB_GETLOCALE             0x015a
#define CB_GETTOPINDEX           0x015b
#define CB_SETTOPINDEX           0x015c
#define CB_GETHORIZONTALEXTENT   0x015d
#define CB_SETHORIZONTALEXTENT   0x015e
#define CB_GETDROPPEDWIDTH       0x015f
#define CB_SETDROPPEDWIDTH       0x0160
#define CB_INITSTORAGE           0x0161
#define CB_MULTIPLEADDSTRING     0x0163
#define CB_GETCOMBOBOXINFO       0x0164
#define CB_MSGMAX                0x0165
#define CBN_ERRSPACE             (-1)
#define CBN_SELCHANGE            1
#define CBN_DBLCLK               2
#define CBN_SETFOCUS             3
#define CBN_KILLFOCUS            4
#define CBN_EDITCHANGE           5
#define CBN_EDITUPDATE           6
#define CBN_DROPDOWN             7
#define CBN_CLOSEUP              8
#define CBN_SELENDOK             9
#define CBN_SELENDCANCEL         10
#define CB_OKAY                  0
#define CB_ERR                   (-1)
#define CB_ERRSPACE              (-2)
/* ja:エディトリストコントロール */
#define ES_LEFT                0x0000
#define ES_CENTER              0x0001
#define ES_RIGHT               0x0002
#define ES_MULTILINE           0x0004
#define ES_UPPERCASE           0x0008
#define ES_LOWERCASE           0x0010
#define ES_PASSWORD            0x0020
#define ES_AUTOVSCROLL         0x0040
#define ES_AUTOHSCROLL         0x0080
#define ES_NOHIDESEL           0x0100
#define ES_OEMCONVERT          0x0400
#define ES_READONLY            0x0800
#define ES_WANTRETURN          0x1000
#define ES_NUMBER              0x2000
#define EM_GETSEL              0x00b0
#define EM_SETSEL              0x00b1
#define EM_GETRECT             0x00b2
#define EM_SETRECT             0x00b3
#define EM_SETRECTNP           0x00b4
#define EM_SCROLL              0x00b5
#define EM_LINESCROLL          0x00b6
#define EM_SCROLLCARET         0x00b7
#define EM_GETMODIFY           0x00b8
#define EM_SETMODIFY           0x00b9
#define EM_GETLINECOUNT        0x00ba
#define EM_LINEINDEX           0x00bb
#define EM_SETHANDLE           0x00bc
#define EM_GETHANDLE           0x00bd
#define EM_GETTHUMB            0x00be
#define EM_LINELENGTH          0x00c1
#define EM_REPLACESEL          0x00c2
#define EM_GETLINE             0x00c4
#define EM_LIMITTEXT           0x00c5
#define EM_CANUNDO             0x00c6
#define EM_UNDO                0x00c7
#define EM_FMTLINES            0x00c8
#define EM_LINEFROMCHAR        0x00c9
#define EM_SETTABSTOPS         0x00cb
#define EM_SETPASSWORDCHAR     0x00cc
#define EM_EMPTYUNDOBUFFER     0x00cd
#define EM_GETFIRSTVISIBLELINE 0x00ce
#define EM_SETREADONLY         0x00cf
#define EM_SETWORDBREAKPROC    0x00d0
#define EM_GETWORDBREAKPROC    0x00d1
#define EM_GETPASSWORDCHAR     0x00d2
#define EM_SETMARGINS          0x00d3
#define EM_GETMARGINS          0x00d4
#define EM_SETLIMITTEXT        EM_LIMITTEXT
#define EM_GETLIMITTEXT        0x00d5
#define EM_POSFROMCHAR         0x00d6
#define EM_CHARFROMPOS         0x00d7
#define EM_SETIMESTATUS        0x00d8
#define EM_GETIMESTATUS        0x00d9
#define EN_SETFOCUS            0x0100
#define EN_KILLFOCUS           0x0200
#define EN_CHANGE              0x0300
#define EN_UPDATE              0x0400
#define EN_ERRSPACE            0x0500
#define EN_MAXTEXT             0x0501
#define EN_HSCROLL             0x0601
#define EN_VSCROLL             0x0602
#define EN_ALIGN_LTR_EC        0x0700
#define EN_ALIGN_RTL_EC        0x0701
#define EC_LEFTMARGIN          0x0001
#define EC_RIGHTMARGIN         0x0002
#define EC_USEFONTINFO         0xffff
/* ja:リストコントロール */
#define LBS_NOTIFY             0x0001
#define LBS_SORT               0x0002
#define LBS_NOREDRAW           0x0004
#define LBS_MULTIPLESEL        0x0008
#define LBS_OWNERDRAWFIXED     0x0010
#define LBS_OWNERDRAWVARIABLE  0x0020
#define LBS_HASSTRINGS         0x0040
#define LBS_USETABSTOPS        0x0080
#define LBS_NOINTEGRALHEIGHT   0x0100
#define LBS_MULTICOLUMN        0x0200
#define LBS_WANTKEYBOARDINPUT  0x0400
#define LBS_EXTENDEDSEL        0x0800
#define LBS_DISABLENOSCROLL    0x1000
#define LBS_NODATA             0x2000
#define LBS_NOSEL              0x4000
#define LBS_COMBOBOX           0x8000
#define LBS_STANDARD           (LBS_NOTIFY|LBS_SORT|WS_VSCROLL|WS_BORDER)
#define LB_ADDSTRING           0x0180
#define LB_INSERTSTRING        0x0181
#define LB_DELETESTRING        0x0182
#define LB_SELITEMRANGEEX      0x0183
#define LB_RESETCONTENT        0x0184
#define LB_SETSEL              0x0185
#define LB_SETCURSEL           0x0186
#define LB_GETSEL              0x0187
#define LB_GETCURSEL           0x0188
#define LB_GETTEXT             0x0189
#define LB_GETTEXTLEN          0x018a
#define LB_GETCOUNT            0x018b
#define LB_SELECTSTRING        0x018c
#define LB_DIR                 0x018d
#define LB_GETTOPINDEX         0x018e
#define LB_FINDSTRING          0x018f
#define LB_GETSELCOUNT         0x0190
#define LB_GETSELITEMS         0x0191
#define LB_SETTABSTOPS         0x0192
#define LB_GETHORIZONTALEXTENT 0x0193
#define LB_SETHORIZONTALEXTENT 0x0194
#define LB_SETCOLUMNWIDTH      0x0195
#define LB_ADDFILE             0x0196
#define LB_SETTOPINDEX         0x0197
#define LB_GETITEMRECT         0x0198
#define LB_GETITEMDATA         0x0199
#define LB_SETITEMDATA         0x019a
#define LB_SELITEMRANGE        0x019b
#define LB_SETANCHORINDEX      0x019c
#define LB_GETANCHORINDEX      0x019d
#define LB_SETCARETINDEX       0x019e
#define LB_GETCARETINDEX       0x019f
#define LB_SETITEMHEIGHT       0x01a0
#define LB_GETITEMHEIGHT       0x01a1
#define LB_FINDSTRINGEXACT     0x01a2
#define LB_SETLOCALE           0x01a5
#define LB_GETLOCALE           0x01a6
#define LB_SETCOUNT            0x01a7
#define LB_INITSTORAGE         0x01a8
#define LB_ITEMFROMPOINT       0x01a9
#define LB_MSGMAX              0x01b0
#define LB_MULTIPLEADDSTRING   0x01b1
#define LB_GETLISTBOXINFO      0x01b2
#define LBN_ERRSPACE           (-2)
#define LBN_SELCHANGE          1
#define LBN_DBLCLK             2
#define LBN_SELCANCEL          3
#define LBN_SETFOCUS           4
#define LBN_KILLFOCUS          5
#define LB_OKAY                0
#define LB_ERR                 (-1)
#define LB_ERRSPACE            (-2)
/* ja:スタティックコントロール */
#define SS_LEFT            0x00000000
#define SS_CENTER          0x00000001
#define SS_RIGHT           0x00000002
#define SS_ICON            0x00000003
#define SS_BLACKRECT       0x00000004
#define SS_GRAYRECT        0x00000005
#define SS_WHITERECT       0x00000006
#define SS_BLACKFRAME      0x00000007
#define SS_GRAYFRAME       0x00000008
#define SS_WHITEFRAME      0x00000009
#define SS_USERITEM        0x0000000a
#define SS_SIMPLE          0x0000000b
#define SS_LEFTNOWORDWRAP  0x0000000c
#define SS_OWNERDRAW       0x0000000d
#define SS_BITMAP          0x0000000e
#define SS_ENHMETAFILE     0x0000000f
#define SS_ETCHEDHORZ      0x00000010
#define SS_ETCHEDVERT      0x00000011
#define SS_ETCHEDFRAME     0x00000012
#define SS_TYPEMASK        0x0000001f
#define SS_REALSIZECONTROL 0x00000040
#define SS_NOPREFIX        0x00000080
#define SS_NOTIFY          0x00000100
#define SS_CENTERIMAGE     0x00000200
#define SS_RIGHTJUST       0x00000400
#define SS_REALSIZEIMAGE   0x00000800
#define SS_SUNKEN          0x00001000
#define SS_EDITCONTROL     0x00002000
#define SS_ENDELLIPSIS     0x00004000
#define SS_PATHELLIPSIS    0x00008000
#define SS_WORDELLIPSIS    0x0000c000
#define SS_ELLIPSISMASK    0x0000c000
#define STM_SETICON        0x0170
#define STM_GETICON        0x0171
#define STM_SETIMAGE       0x0172
#define STM_GETIMAGE       0x0173
#define STM_MSGMAX         0x0174
#define STN_CLICKED        0
#define STN_DBLCLK         1
#define STN_ENABLE         2
#define STN_DISABLE        3
/* ja:スクロールバーコントロール */
#define SBS_HORZ                    0x0000
#define SBS_VERT                    0x0001
#define SBS_TYPEMASK                0x0001
#define SBS_TOPALIGN                0x0002
#define SBS_LEFTALIGN               0x0002
#define SBS_BOTTOMALIGN             0x0004
#define SBS_RIGHTALIGN              0x0004
#define SBS_SIZEBOXTOPLEFTALIGN     0x0002
#define SBS_SIZEBOXBOTTOMRIGHTALIGN 0x0004
#define SBS_SIZEBOX                 0x0008
#define SBS_SIZEGRIP                0x0010
#define SBM_SETPOS                  0x00e0
#define SBM_GETPOS                  0x00e1
#define SBM_SETRANGE                0x00e2
#define SBM_GETRANGE                0x00e3
#define SBM_ENABLE_ARROWS           0x00e4
#define SBM_SETRANGEREDRAW          0x00e6
#define SBM_SETSCROLLINFO           0x00e9
#define SBM_GETSCROLLINFO           0x00ea
#define SBM_GETSCROLLBARINFO        0x00eb
/* ja:メッセージボックス */
#define MB_OK                   0x00000000
#define MB_OKCANCEL             0x00000001
#define MB_ABORTRETRYIGNORE     0x00000002
#define MB_YESNOCANCEL          0x00000003
#define MB_YESNO                0x00000004
#define MB_RETRYCANCEL          0x00000005
#define MB_TYPEMASK             0x0000000F
#define MB_ICONHAND             0x00000010
#define MB_ICONQUESTION         0x00000020
#define MB_ICONEXCLAMATION      0x00000030
#define MB_ICONASTERISK         0x00000040
#define MB_USERICON             0x00000080
#define MB_ICONMASK             0x000000F0
#define MB_ICONINFORMATION      MB_ICONASTERISK
#define MB_ICONSTOP             MB_ICONHAND
#define MB_ICONWARNING          MB_ICONEXCLAMATION
#define MB_ICONERROR            MB_ICONHAND
#define MB_DEFBUTTON1           0x00000000
#define MB_DEFBUTTON2           0x00000100
#define MB_DEFBUTTON3           0x00000200
#define MB_DEFBUTTON4           0x00000300
#define MB_DEFMASK              0x00000f00
#define MB_APPLMODAL            0x00000000
#define MB_SYSTEMMODAL          0x00001000
#define MB_TASKMODAL            0x00002000
#define MB_MODEMASK             0x00003000
#define MB_HELP                 0x00004000
#define MB_NOFOCUS              0x00008000
#define MB_MISCMASK             0x0000C000
#define MB_SETFOREGROUND        0x00010000
#define MB_DEFAULT_DESKTOP_ONLY 0x00020000
#define MB_SERVICE_NOTIFICATION 0x00040000
#define MB_TOPMOST              0x00040000
#define MB_RIGHT                0x00080000
#define MB_RTLREADING           0x00100000
/* ID */
#define IDOK       1
#define IDCANCEL   2
#define IDABORT    3
#define IDRETRY    4
#define IDIGNORE   5
#define IDYES      6
#define IDNO       7
#define IDCLOSE    8
#define IDHELP     9
#define IDTRYAGAIN 10
#define IDCONTINUE 11
#endif /* W32LDR_HEADER */


typedef struct _W32LdrWndExtraData
{
  DWORD dwStyle;
  DWORD dwExStyle;
  WNDPROC lpfnWndProc;
  HINSTANCE hInstance;
  HWND hWndParent;
  WORD wID;
  DWORD dwUserData;
  DLGPROC lpDialogFunc;
  LRESULT lResult;
  DWORD dwUser;
  GtkWidget **child, **sister;
} W32LdrWndExtraData;


/* ActivateKeyboardLayout ordinal = 1, argument = 8 temporary */
static DWORD WINAPI ActivateKeyboardLayout (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* AdjustWindowRect ordinal = 2, argument = 12 temporary */
static DWORD WINAPI AdjustWindowRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AdjustWindowRectEx ordinal = 3, argument = 16 temporary */
static DWORD WINAPI AdjustWindowRectEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* AlignRects ordinal = 4, argument = 0 temporary */
static DWORD WINAPI AlignRects (VOID)
{
  return 0;
}


/* AllowSetForegroundWindow ordinal = 5, argument = 4 temporary */
static DWORD WINAPI AllowSetForegroundWindow (DWORD dwArgv0)
{
  return 0;
}


/* AnimateWindow ordinal = 6, argument = 12 temporary */
static DWORD WINAPI AnimateWindow (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AnyPopup ordinal = 7, argument = 0 temporary */
static DWORD WINAPI AnyPopup (VOID)
{
  return 0;
}


/* AppendMenuA ordinal = 8, argument = 16 temporary */
static DWORD WINAPI AppendMenuA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* AppendMenuW ordinal = 9, argument = 16 temporary */
static DWORD WINAPI AppendMenuW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ArrangeIconicWindows ordinal = 10, argument = 4 temporary */
static DWORD WINAPI ArrangeIconicWindows (DWORD dwArgv0)
{
  return 0;
}


/* AttachThreadInput ordinal = 11, argument = 12 temporary */
static DWORD WINAPI AttachThreadInput (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* BeginDeferWindowPos ordinal = 12, argument = 4 temporary */
static DWORD WINAPI BeginDeferWindowPos (DWORD dwArgv0)
{
  return 0;
}


/* BeginPaint ordinal = 13, argument = 8 */
HDC WINAPI BeginPaint (HWND hWnd, LPPAINTSTRUCT lpPaint)
{
  return NULL;
}


/* BlockInput ordinal = 14, argument = 4 temporary */
static DWORD WINAPI BlockInput (DWORD dwArgv0)
{
  return 0;
}


/* BringWindowToTop ordinal = 15, argument = 4 temporary */
static DWORD WINAPI BringWindowToTop (DWORD dwArgv0)
{
  return 0;
}


/* BroadcastSystemMessage ordinal = 16, argument = 20 temporary */
/* DWORD WINAPI BroadcastSystemMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4) */


/* BroadcastSystemMessageA ordinal = 17, argument = 20 temporary */
static DWORD WINAPI BroadcastSystemMessageA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* BroadcastSystemMessageW ordinal = 18, argument = 20 temporary */
static DWORD WINAPI BroadcastSystemMessageW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CallMsgFilter ordinal = 19, argument = 8 temporary */
/* DWORD WINAPI CallMsgFilter (DWORD dwArgv0, DWORD dwArgv1) */


/* CallMsgFilterA ordinal = 20, argument = 8 temporary */
static DWORD WINAPI CallMsgFilterA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CallMsgFilterW ordinal = 21, argument = 8 temporary */
static DWORD WINAPI CallMsgFilterW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CallNextHookEx ordinal = 22, argument = 16 temporary */
static DWORD WINAPI CallNextHookEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CallWindowProcA ordinal = 23, argument = 20 temporary */
static DWORD WINAPI CallWindowProcA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CallWindowProcW ordinal = 24, argument = 20 temporary */
static DWORD WINAPI CallWindowProcW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CascadeChildWindows ordinal = 25, argument = 8 temporary */
static DWORD WINAPI CascadeChildWindows (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CascadeWindows ordinal = 26, argument = 20 temporary */
static DWORD WINAPI CascadeWindows (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ChangeClipboardChain ordinal = 27, argument = 8 temporary */
static DWORD WINAPI ChangeClipboardChain (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ChangeDisplaySettingsA ordinal = 28, argument = 8 temporary */
static DWORD WINAPI ChangeDisplaySettingsA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ChangeDisplaySettingsExA ordinal = 29, argument = 20 temporary */
static DWORD WINAPI ChangeDisplaySettingsExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ChangeDisplaySettingsExW ordinal = 30, argument = 20 temporary */
static DWORD WINAPI ChangeDisplaySettingsExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ChangeDisplaySettingsW ordinal = 31, argument = 8 temporary */
static DWORD WINAPI ChangeDisplaySettingsW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ChangeMenuA ordinal = 32, argument = 20 temporary */
static DWORD WINAPI ChangeMenuA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ChangeMenuW ordinal = 33, argument = 20 temporary */
static DWORD WINAPI ChangeMenuW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CharLowerA ordinal = 34, argument = 4 */
LPSTR WINAPI CharLowerA (LPSTR lpsz)
{
  gchar *utf8str, *mb;

  if (GPOINTER_TO_INT (lpsz) < 0x10000)
    return GINT_TO_POINTER (g_unichar_toupper (GPOINTER_TO_INT (lpsz)));
  utf8str = w32ldr_utf8_from_mb (lpsz);
  g_utf8_strdown (utf8str, -1);
  mb = w32ldr_utf8_to_mb (utf8str);
  g_free (utf8str);
  g_strcpy (lpsz, mb);
  g_free (mb);
  return lpsz;
}


/* CharLowerBuffA ordinal = 35, argument = 8 temporary */
static DWORD WINAPI CharLowerBuffA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CharLowerBuffW ordinal = 36, argument = 8 temporary */
static DWORD WINAPI CharLowerBuffW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CharLowerW ordinal = 37, argument = 4 */
LPWSTR WINAPI CharLowerW (LPWSTR lpsz)
{
  gchar *utf8str;
  gunichar2 *wc;

  if (GPOINTER_TO_INT (lpsz) < 0x10000)
    return GINT_TO_POINTER (g_unichar_toupper (GPOINTER_TO_INT (lpsz)));
  utf8str = g_utf16_to_utf8 (lpsz, -1, NULL, NULL, NULL);
  g_utf8_strdown (utf8str, -1);
  wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lstrcpyW (lpsz, wc);
  g_free (wc);
  return lpsz;
}


/* CharNextA ordinal = 38, argument = 4 temporary */
static DWORD WINAPI CharNextA (DWORD dwArgv0)
{
  return 0;
}


/* CharNextExA ordinal = 39, argument = 12 temporary */
static DWORD WINAPI CharNextExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CharNextW ordinal = 40, argument = 4 temporary */
static DWORD WINAPI CharNextW (DWORD dwArgv0)
{
  return 0;
}


/* CharPrevA ordinal = 41, argument = 8 temporary */
static DWORD WINAPI CharPrevA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CharPrevExA ordinal = 42, argument = 16 temporary */
static DWORD WINAPI CharPrevExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CharPrevW ordinal = 43, argument = 8 temporary */
static DWORD WINAPI CharPrevW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CharToOemA ordinal = 44, argument = 8 temporary */
static DWORD WINAPI CharToOemA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CharToOemBuffA ordinal = 45, argument = 12 temporary */
static DWORD WINAPI CharToOemBuffA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CharToOemBuffW ordinal = 46, argument = 12 temporary */
static DWORD WINAPI CharToOemBuffW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CharToOemW ordinal = 47, argument = 8 temporary */
static DWORD WINAPI CharToOemW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CharUpperA ordinal = 48, argument = 4 */
LPSTR WINAPI CharUpperA (LPSTR lpsz)
{
  gchar *utf8str, *mb;

  if (GPOINTER_TO_INT (lpsz) < 0x10000)
    return GINT_TO_POINTER (g_unichar_toupper (GPOINTER_TO_INT (lpsz)));
  utf8str = w32ldr_utf8_from_mb (lpsz);
  g_utf8_strup (utf8str, -1);
  mb = w32ldr_utf8_to_mb (utf8str);
  g_free (utf8str);
  g_strcpy (lpsz, mb);
  g_free (mb);
  return lpsz;
}


/* CharUpperBuffA ordinal = 49, argument = 8 temporary */
static DWORD WINAPI CharUpperBuffA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CharUpperBuffW ordinal = 50, argument = 8 temporary */
static DWORD WINAPI CharUpperBuffW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CharUpperW ordinal = 51, argument = 4 */
LPWSTR WINAPI CharUpperW (LPWSTR lpsz)
{
  gchar *utf8str;
  gunichar2 *wc;

  if (GPOINTER_TO_INT (lpsz) < 0x10000)
    return GINT_TO_POINTER (g_unichar_toupper (GPOINTER_TO_INT (lpsz)));
  utf8str = g_utf16_to_utf8 (lpsz, -1, NULL, NULL, NULL);
  g_utf8_strup (utf8str, -1);
  wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  lstrcpyW (lpsz, wc);
  g_free (wc);
  return lpsz;
}


/* CheckDlgButton ordinal = 52, argument = 12 */
BOOL WINAPI CheckDlgButton (HWND hDlg, INT nIDButton, UINT uCheck)
{
  GtkWidget *widget;

  if (uCheck != BST_INDETERMINATE && (widget = GetDlgItem (hDlg, nIDButton)))
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
                                                        uCheck == BST_CHECKED);
      return TRUE;
    }
  return FALSE;
}


/* CheckMenuItem ordinal = 53, argument = 12 temporary */
static DWORD WINAPI CheckMenuItem (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CheckMenuRadioItem ordinal = 54, argument = 20 temporary */
static DWORD WINAPI CheckMenuRadioItem (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CheckRadioButton ordinal = 55, argument = 16 */
BOOL WINAPI CheckRadioButton (HWND hDlg, INT nIDFirstButton, INT nIDLastButton, INT nIDCheckButton)
{
  gint i;

  for (i = nIDFirstButton; i <= nIDLastButton; i++)
    {
      GtkWidget *widget;

      widget = GetDlgItem (hDlg, i);
      if (widget)
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
                                                        i == nIDCheckButton);
    }
  return TRUE;
}


/* ChildWindowFromPoint ordinal = 56, argument = 12 temporary */
static DWORD WINAPI ChildWindowFromPoint (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ChildWindowFromPointEx ordinal = 57, argument = 16 temporary */
static DWORD WINAPI ChildWindowFromPointEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CliImmSetHotKey ordinal = 58, argument = 0 temporary */
static DWORD WINAPI CliImmSetHotKey (VOID)
{
  return 0;
}


/* ClientThreadSetup ordinal = 59, argument = 0 temporary */
static DWORD WINAPI ClientThreadSetup (VOID)
{
  return 0;
}


/* ClientToScreen ordinal = 60, argument = 8 temporary */
static DWORD WINAPI ClientToScreen (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ClipCursor ordinal = 61, argument = 4 temporary */
static DWORD WINAPI ClipCursor (DWORD dwArgv0)
{
  return 0;
}


/* CloseClipboard ordinal = 62, argument = 0 temporary */
static DWORD WINAPI CloseClipboard (VOID)
{
  return 0;
}


/* CloseDesktop ordinal = 63, argument = 4 temporary */
static DWORD WINAPI CloseDesktop (DWORD dwArgv0)
{
  return 0;
}


/* CloseWindow ordinal = 64, argument = 4 temporary */
static DWORD WINAPI CloseWindow (DWORD dwArgv0)
{
  return 0;
}


/* CloseWindowStation ordinal = 65, argument = 4 temporary */
static DWORD WINAPI CloseWindowStation (DWORD dwArgv0)
{
  return 0;
}


/* CopyAcceleratorTableA ordinal = 66, argument = 12 temporary */
static DWORD WINAPI CopyAcceleratorTableA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CopyAcceleratorTableW ordinal = 67, argument = 12 temporary */
static DWORD WINAPI CopyAcceleratorTableW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CopyIcon ordinal = 68, argument = 4 temporary */
static DWORD WINAPI CopyIcon (DWORD dwArgv0)
{
  return 0;
}


/* CopyImage ordinal = 69, argument = 20 temporary */
static DWORD WINAPI CopyImage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CopyRect ordinal = 70, argument = 8 temporary */
static DWORD WINAPI CopyRect (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CountClipboardFormats ordinal = 71, argument = 0 temporary */
static DWORD WINAPI CountClipboardFormats (VOID)
{
  return 0;
}


/* CreateAcceleratorTableA ordinal = 72, argument = 8 temporary */
static DWORD WINAPI CreateAcceleratorTableA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateAcceleratorTableW ordinal = 73, argument = 8 temporary */
static DWORD WINAPI CreateAcceleratorTableW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateCaret ordinal = 74, argument = 16 temporary */
static DWORD WINAPI CreateCaret (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateCursor ordinal = 75, argument = 28 temporary */
static DWORD WINAPI CreateCursor (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CreateDesktopA ordinal = 76, argument = 24 temporary */
static DWORD WINAPI CreateDesktopA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CreateDesktopW ordinal = 77, argument = 24 temporary */
static DWORD WINAPI CreateDesktopW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CreateDialogIndirectParamA ordinal = 78, argument = 20 temporary */
static DWORD WINAPI CreateDialogIndirectParamA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CreateDialogIndirectParamAorW ordinal = 79, argument = 0 temporary */
static DWORD WINAPI CreateDialogIndirectParamAorW (VOID)
{
  return 0;
}


/* CreateDialogIndirectParamW ordinal = 80, argument = 20 temporary */
static DWORD WINAPI CreateDialogIndirectParamW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CreateDialogParamA ordinal = 81, argument = 20 temporary */
static DWORD WINAPI CreateDialogParamA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CreateDialogParamW ordinal = 82, argument = 20 temporary */
static DWORD WINAPI CreateDialogParamW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CreateIcon ordinal = 83, argument = 28 temporary */
static DWORD WINAPI CreateIcon (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CreateIconFromResource ordinal = 84, argument = 16 temporary */
static DWORD WINAPI CreateIconFromResource (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateIconFromResourceEx ordinal = 85, argument = 28 temporary */
static DWORD WINAPI CreateIconFromResourceEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CreateIconIndirect ordinal = 86, argument = 4 temporary */
static DWORD WINAPI CreateIconIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreateMDIWindowA ordinal = 87, argument = 40 temporary */
static DWORD WINAPI CreateMDIWindowA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* CreateMDIWindowW ordinal = 88, argument = 40 temporary */
static DWORD WINAPI CreateMDIWindowW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* CreateMenu ordinal = 89, argument = 0 temporary */
static DWORD WINAPI CreateMenu (VOID)
{
  return 0;
}


/* CreatePopupMenu ordinal = 90, argument = 0 temporary */
static DWORD WINAPI CreatePopupMenu (VOID)
{
  return 0;
}


/* CreateWindowExA ordinal = 91, argument = 48 temporary */
static DWORD WINAPI CreateWindowExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* CreateWindowExW ordinal = 92, argument = 48 temporary */
static DWORD WINAPI CreateWindowExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* CreateWindowStationA ordinal = 93, argument = 16 temporary */
static DWORD WINAPI CreateWindowStationA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateWindowStationW ordinal = 94, argument = 16 temporary */
static DWORD WINAPI CreateWindowStationW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CtxInitUser32 ordinal = 95, argument = 0 temporary */
static DWORD WINAPI CtxInitUser32 (VOID)
{
  return 0;
}


/* DdeAbandonTransaction ordinal = 96, argument = 12 temporary */
static DWORD WINAPI DdeAbandonTransaction (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DdeAccessData ordinal = 97, argument = 8 temporary */
static DWORD WINAPI DdeAccessData (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DdeAddData ordinal = 98, argument = 16 temporary */
static DWORD WINAPI DdeAddData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DdeClientTransaction ordinal = 99, argument = 32 temporary */
static DWORD WINAPI DdeClientTransaction (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* DdeCmpStringHandles ordinal = 100, argument = 8 temporary */
static DWORD WINAPI DdeCmpStringHandles (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DdeConnect ordinal = 101, argument = 16 temporary */
static DWORD WINAPI DdeConnect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DdeConnectList ordinal = 102, argument = 20 temporary */
static DWORD WINAPI DdeConnectList (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DdeCreateDataHandle ordinal = 103, argument = 28 temporary */
static DWORD WINAPI DdeCreateDataHandle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* DdeCreateStringHandleA ordinal = 104, argument = 12 temporary */
static DWORD WINAPI DdeCreateStringHandleA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DdeCreateStringHandleW ordinal = 105, argument = 12 temporary */
static DWORD WINAPI DdeCreateStringHandleW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DdeDisconnect ordinal = 106, argument = 4 temporary */
static DWORD WINAPI DdeDisconnect (DWORD dwArgv0)
{
  return 0;
}


/* DdeDisconnectList ordinal = 107, argument = 4 temporary */
static DWORD WINAPI DdeDisconnectList (DWORD dwArgv0)
{
  return 0;
}


/* DdeEnableCallback ordinal = 108, argument = 12 temporary */
static DWORD WINAPI DdeEnableCallback (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DdeFreeDataHandle ordinal = 109, argument = 4 temporary */
static DWORD WINAPI DdeFreeDataHandle (DWORD dwArgv0)
{
  return 0;
}


/* DdeFreeStringHandle ordinal = 110, argument = 8 temporary */
static DWORD WINAPI DdeFreeStringHandle (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DdeGetData ordinal = 111, argument = 16 temporary */
static DWORD WINAPI DdeGetData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DdeGetLastError ordinal = 112, argument = 4 temporary */
static DWORD WINAPI DdeGetLastError (DWORD dwArgv0)
{
  return 0;
}


/* DdeGetQualityOfService ordinal = 113, argument = 0 temporary */
static DWORD WINAPI DdeGetQualityOfService (VOID)
{
  return 0;
}


/* DdeImpersonateClient ordinal = 114, argument = 4 temporary */
static DWORD WINAPI DdeImpersonateClient (DWORD dwArgv0)
{
  return 0;
}


/* DdeInitializeA ordinal = 115, argument = 16 temporary */
static DWORD WINAPI DdeInitializeA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DdeInitializeW ordinal = 116, argument = 16 temporary */
static DWORD WINAPI DdeInitializeW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DdeKeepStringHandle ordinal = 117, argument = 8 temporary */
static DWORD WINAPI DdeKeepStringHandle (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DdeNameService ordinal = 118, argument = 16 temporary */
static DWORD WINAPI DdeNameService (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DdePostAdvise ordinal = 119, argument = 12 temporary */
static DWORD WINAPI DdePostAdvise (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DdeQueryConvInfo ordinal = 120, argument = 12 temporary */
static DWORD WINAPI DdeQueryConvInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DdeQueryNextServer ordinal = 121, argument = 8 temporary */
static DWORD WINAPI DdeQueryNextServer (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DdeQueryStringA ordinal = 122, argument = 20 temporary */
static DWORD WINAPI DdeQueryStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DdeQueryStringW ordinal = 123, argument = 20 temporary */
static DWORD WINAPI DdeQueryStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DdeReconnect ordinal = 124, argument = 4 temporary */
static DWORD WINAPI DdeReconnect (DWORD dwArgv0)
{
  return 0;
}


/* DdeSetQualityOfService ordinal = 125, argument = 12 temporary */
static DWORD WINAPI DdeSetQualityOfService (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DdeSetUserHandle ordinal = 126, argument = 12 temporary */
static DWORD WINAPI DdeSetUserHandle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DdeUnaccessData ordinal = 127, argument = 4 temporary */
static DWORD WINAPI DdeUnaccessData (DWORD dwArgv0)
{
  return 0;
}


/* DdeUninitialize ordinal = 128, argument = 4 temporary */
static DWORD WINAPI DdeUninitialize (DWORD dwArgv0)
{
  return 0;
}


/* DefDlgProcA ordinal = 129, argument = 16 temporary */
static DWORD WINAPI DefDlgProcA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DefDlgProcW ordinal = 130, argument = 16 temporary */
static DWORD WINAPI DefDlgProcW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DefFrameProcA ordinal = 131, argument = 20 temporary */
static DWORD WINAPI DefFrameProcA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DefFrameProcW ordinal = 132, argument = 20 temporary */
static DWORD WINAPI DefFrameProcW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DefMDIChildProcA ordinal = 133, argument = 16 temporary */
static DWORD WINAPI DefMDIChildProcA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DefMDIChildProcW ordinal = 134, argument = 16 temporary */
static DWORD WINAPI DefMDIChildProcW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


static LRESULT WINAPI DefWindowProcU (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  switch (Msg)
    {
      case BM_GETCHECK:
        return gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hWnd))
                                                ? BST_CHECKED : BST_UNCHECKED;
      case BM_SETCHECK:
        if (wParam != BST_INDETERMINATE)
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hWnd),
                                                        wParam == BST_CHECKED);
        return 0;
      case BM_GETSTATE:
        return (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hWnd))
                                                ? BST_CHECKED : BST_UNCHECKED)
                            | (GTK_WIDGET_HAS_FOCUS (hWnd) ? BST_FOCUS : 0);
      case BM_SETSTATE:
        return 0;
      case BM_SETSTYLE:
        {
          W32LdrWndExtraData *wed;

          wed = g_object_get_data (G_OBJECT (hWnd), "user_data");
          wed->dwStyle = wParam;
          switch (wed->dwStyle & 0x00000300L)
            {
              case BS_LEFT:
                gtk_label_set_justify (GTK_LABEL (gtk_bin_get_child
                                        (GTK_BIN (hWnd))), GTK_JUSTIFY_LEFT);
                break;
              case BS_RIGHT:
                gtk_label_set_justify (GTK_LABEL (gtk_bin_get_child
                                        (GTK_BIN (hWnd))), GTK_JUSTIFY_RIGHT);
                break;
              case BS_CENTER:
                gtk_label_set_justify (GTK_LABEL (gtk_bin_get_child
                                        (GTK_BIN (hWnd))), GTK_JUSTIFY_CENTER);
            }
          return 0;
        }
      case BM_CLICK:
        gtk_button_clicked (GTK_BUTTON (hWnd));
        return 0;
      case BM_GETIMAGE:
      case BM_SETIMAGE:
        return GPOINTER_TO_INT (NULL);
#if GTK_CHECK_VERSION(2,4,0)
      case CB_GETEDITSEL:
        {
          gint st, ed;
          W32LdrWndExtraData *wed;

          wed = g_object_get_data (G_OBJECT (hWnd), "user_data");
          if ((wed->dwStyle & 0xf) == CBS_DROPDOWNLIST
                || !gtk_editable_get_selection_bounds
                (GTK_EDITABLE (gtk_bin_get_child (GTK_BIN (hWnd))), &st, &ed))
            st = ed = -1;
          if (wParam)
            *(LPDWORD)GINT_TO_POINTER (wParam) = st;
          if (lParam)
            *(LPDWORD)GINT_TO_POINTER (lParam) = ed;
          return MAKELRESULT (st, ed);
        }
      case CB_LIMITTEXT:
        {
          W32LdrWndExtraData *wed;

          wed = g_object_get_data (G_OBJECT (hWnd), "user_data");
          if ((wed->dwStyle & 0xf) != CBS_DROPDOWNLIST)
            gtk_entry_set_max_length
                            (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (hWnd))),
                                                wParam > 0 ? wParam : 0xfffe);
        }
        return TRUE;
      case CB_SETEDITSEL:
        {
          W32LdrWndExtraData *wed;

          wed = g_object_get_data (G_OBJECT (hWnd), "user_data");
          if ((wed->dwStyle & 0xf) != CBS_DROPDOWNLIST)
            gtk_editable_select_region
                            (GTK_EDITABLE (gtk_bin_get_child (GTK_BIN (hWnd))),
                                                            wParam, lParam);
        }
        return TRUE;
      case CB_DELETESTRING:
        {
          GtkListStore *store;
          GtkTreeIter iter;

          store = GTK_LIST_STORE (gtk_combo_box_get_model
                                                    (GTK_COMBO_BOX (hWnd)));
          if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, wParam))
            {
              gtk_list_store_remove (store, &iter);
              return DefWindowProc (hWnd, CB_GETCOUNT, 0, 0);
            }
        }
        return CB_ERR;
      case CB_DIR:
        return CB_ERR;
      case CB_GETCOUNT:
        {
          GtkTreeModel *model;

          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          return gtk_tree_model_iter_n_children (model, NULL);
        }
      case CB_GETCURSEL:
        return gtk_combo_box_get_active (GTK_COMBO_BOX (hWnd));
      case CB_RESETCONTENT:
        {
          GtkListStore *store;

          store = GTK_LIST_STORE (gtk_combo_box_get_model
                                                    (GTK_COMBO_BOX (hWnd)));
          gtk_list_store_clear (store);
        }
        return CB_OKAY;
      case CB_SELECTSTRING:
        return DefWindowProc (hWnd, CB_SETCURSEL,
                    DefWindowProc (hWnd, CB_FINDSTRING, wParam, lParam), 0);
      case CB_SETCURSEL:
        gtk_combo_box_set_active (GTK_COMBO_BOX (hWnd), wParam);
        return wParam;
      case CB_SHOWDROPDOWN:
        return TRUE;
      case CB_GETITEMDATA:
        {
          GtkTreeIter iter;
          GtkTreeModel *model;
          LRESULT lResult = CB_ERR;

          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            gtk_tree_model_get (model, &iter, 1, &lResult, -1);
          return lResult;
        }
      case CB_SETITEMDATA:
        {
          GtkListStore *store;
          GtkTreeIter iter;

          store = GTK_LIST_STORE (gtk_combo_box_get_model
                                                    (GTK_COMBO_BOX (hWnd)));
          if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, wParam))
            {
              gtk_list_store_set (store, &iter, 1, lParam, -1);
              return CB_OKAY;
            }
        }
        return CB_ERR;
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_GETEDITSEL:
        {
          gint st, ed;
          if (!gtk_editable_get_selection_bounds
                            (GTK_EDITABLE (GTK_COMBO (hWnd)->entry), &st, &ed))
            st = ed = -1;
          if (wParam)
            *(LPDWORD)GINT_TO_POINTER (wParam) = st;
          if (lParam)
            *(LPDWORD)GINT_TO_POINTER (lParam) = ed;
          return MAKELRESULT (st, ed);
        }
      case CB_LIMITTEXT:
        gtk_entry_set_max_length (GTK_ENTRY (GTK_COMBO (hWnd)->entry),
                                                wParam > 0 ? wParam : 0xfffe);
        return TRUE;
      case CB_SETEDITSEL:
        gtk_editable_select_region (GTK_EDITABLE (GTK_COMBO (hWnd)->entry),
                                                            wParam, lParam);
        return TRUE;
      case CB_DELETESTRING:
        gtk_list_clear_items (GTK_LIST (GTK_COMBO (hWnd)->list),
                                                        wParam, wParam + 1);
        return DefWindowProc (hWnd, CB_GETCOUNT, 0, 0);
      case CB_DIR:
        return CB_ERR;
      case CB_GETCOUNT:
        {
          GList *glist;
          LRESULT lResult;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          lResult = g_list_length (glist);
          g_list_free (glist);
          return lResult;
        }
      case CB_GETCURSEL:
        {
          const gchar *text;
          gint i, length;
          GList *glist;

          text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (hWnd)->entry));
          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          length = g_list_length (glist);
          for (i = 0; i < length; i++)
            if (g_strcmp (gtk_label_get_text (GTK_LABEL (gtk_bin_get_child
                        (GTK_BIN (g_list_nth_data (glist, i))))), text) == 0)
              break;
          g_list_free (glist);
          return i < length ? i : CB_ERR;
        }
      case CB_RESETCONTENT:
        gtk_list_clear_items (GTK_LIST (GTK_COMBO (hWnd)->list), 0, G_MAXINT);
        return CB_OKAY;
      case CB_SELECTSTRING:
        return DefWindowProc (hWnd, CB_SETCURSEL,
                    DefWindowProc (hWnd, CB_FINDSTRING, wParam, lParam), 0);
      case CB_SETCURSEL:
        {
          GList *glist;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          if (glist)
            {
              gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (hWnd)->entry),
                            gtk_label_get_text (GTK_LABEL (gtk_bin_get_child
                                (GTK_BIN (g_list_nth_data (glist, wParam))))));
              g_list_free (glist);
            }
        }
        return wParam;
      case CB_SHOWDROPDOWN:
        return TRUE;
      case CB_GETITEMDATA:
        {
          GList *glist;
          LRESULT lResult;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          lResult = GPOINTER_TO_INT (g_object_get_data
                    (G_OBJECT (g_list_nth_data (glist, wParam)), "user_data"));
          g_list_free (glist);
          return lResult;
        }
      case CB_SETITEMDATA:
        {
          GList *glist;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          g_object_set_data (G_OBJECT (g_list_nth_data (glist, wParam)),
                                        "user_data", GINT_TO_POINTER (lParam));
          g_list_free (glist);
        }
        return CB_OKAY;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_GETDROPPEDCONTROLRECT:
        return CB_ERR;
      case CB_SETITEMHEIGHT:
        return CB_ERR;
      case CB_GETITEMHEIGHT:
        return CB_ERR;
      case CB_SETEXTENDEDUI:
        return CB_ERR;
      case CB_GETEXTENDEDUI:
        return FALSE;
      case CB_GETDROPPEDSTATE:
        return FALSE;
      case CB_SETLOCALE:
        return CB_ERR;
      case CB_GETLOCALE:
        return CB_OKAY;
      case CB_GETTOPINDEX:
        return CB_OKAY;
      case CB_SETTOPINDEX:
        return CB_ERR;
      case CB_GETHORIZONTALEXTENT:
        return CB_OKAY;
      case CB_SETHORIZONTALEXTENT:
        return CB_ERR;
      case CB_GETDROPPEDWIDTH:
        return CB_OKAY;
      case CB_SETDROPPEDWIDTH:
        return CB_ERR;
      case CB_INITSTORAGE:
        return CB_ERR;
      case SBM_SETPOS:
        {
          gdouble value;

          value = gtk_range_get_value (GTK_RANGE (hWnd));
          gtk_range_set_value (GTK_RANGE (hWnd), wParam);
          return value;
        }
      case SBM_GETPOS:
        return gtk_range_get_value (GTK_RANGE (hWnd));
      case SBM_SETRANGE:
        gtk_range_set_range (GTK_RANGE (hWnd), wParam, lParam);
        return gtk_range_get_value (GTK_RANGE (hWnd));
      case SBM_GETRANGE:
        {
          GtkAdjustment *adjustment;

          adjustment = gtk_range_get_adjustment (GTK_RANGE (hWnd));
          *(LPINT)GINT_TO_POINTER (wParam) = adjustment->lower;
          *(LPINT)GINT_TO_POINTER (lParam) = adjustment->upper;
        }
        return TRUE;
      case SBM_ENABLE_ARROWS:
        return FALSE;
      case SBM_SETRANGEREDRAW:
        return DefWindowProc (hWnd, SBM_SETRANGE, wParam, lParam);
      case SBM_SETSCROLLINFO:
        return gtk_range_get_value (GTK_RANGE (hWnd));
      case SBM_GETSCROLLINFO:
        return FALSE;
      case WM_ENABLE:
        {
          gint i;
          W32LdrWndExtraData *wed;

          gtk_widget_set_sensitive (GTK_WIDGET (hWnd), wParam);
          wed = g_object_get_data (G_OBJECT (hWnd), "user_data");
          if (wed && wed->sister)
            for (i = 0; wed->sister[i]; i++)
              gtk_widget_set_sensitive (wed->sister[i], wParam);
          return 0;
        }
      case WM_SHOWWINDOW:
        {
          gint i;
          W32LdrWndExtraData *wed;

          if (wParam)
            gtk_widget_show (GTK_WIDGET (hWnd));
          else
            gtk_widget_hide (GTK_WIDGET (hWnd));
          wed = g_object_get_data (G_OBJECT (hWnd), "user_data");
          if (wed && wed->sister)
            for (i = 0; wed->sister[i]; i++)
              {
                if (wParam)
                  gtk_widget_show (wed->sister[i]);
                else
                  gtk_widget_hide (wed->sister[i]);
              }
          return 0;
        }
    }
  return 0;
}


/* DefWindowProcA ordinal = 135, argument = 16 */
LRESULT WINAPI DefWindowProcA (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  switch (Msg)
    {
#if GTK_CHECK_VERSION(2,4,0)
      case CB_ADDSTRING:
        {
          gchar *utf8str;
          GtkListStore *store;
          GtkTreeIter iter;

          store = GTK_LIST_STORE (gtk_combo_box_get_model
                                                    (GTK_COMBO_BOX (hWnd)));
          gtk_list_store_append (store, &iter);
          utf8str = w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          gtk_list_store_set (store, &iter, 0, utf8str, 1, 0, -1);
          g_free (utf8str);
          return DefWindowProc (hWnd, CB_GETCOUNT, 0, 0) - 1;
        }
      case CB_GETLBTEXT:
        {
          GtkTreeIter iter;
          GtkTreeModel *model;

          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            {
              gchar *mb, *utf8str;

              gtk_tree_model_get (model, &iter, 0, &utf8str, -1);
              mb = w32ldr_utf8_to_mb (utf8str);
              g_free (utf8str);
              g_strcpy (GINT_TO_POINTER (lParam), mb);
              g_free (mb);
              return g_strlen (GINT_TO_POINTER (lParam));
            }
        }
        return CB_ERR;
      case CB_GETLBTEXTLEN:
        {
          GtkTreeIter iter;
          GtkTreeModel *model;
          LRESULT lResult = CB_ERR;

          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            {
              gchar *mb, *utf8str;

              gtk_tree_model_get (model, &iter, 0, &utf8str, -1);
              mb = w32ldr_utf8_to_mb (utf8str);
              g_free (utf8str);
              lResult = g_strlen (mb);
              g_free (mb);
            }
          return lResult;
        }
      case CB_INSERTSTRING:
        {
          gchar *utf8str;
          GtkListStore *store;
          GtkTreeIter iter;

          store = GTK_LIST_STORE (gtk_combo_box_get_model
                                                    (GTK_COMBO_BOX (hWnd)));
          gtk_list_store_insert (store, &iter, wParam);
          utf8str = w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          gtk_list_store_set (store, &iter, 0, utf8str, 1, 0, -1);
          g_free (utf8str);
          return wParam;
        }
      case CB_FINDSTRING:
        {
          gchar *utf8str;
          gint i, length;
          GtkTreeModel *model;

          utf8str = w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          length = gtk_tree_model_iter_n_children (model, NULL);
          for (i = wParam + 1; i < length; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strncasecmp (utf8str, tmp,
                                                        g_strlen (utf8str));
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          for (i = 0; i <= wParam; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strncasecmp (utf8str, tmp,
                                                        g_strlen (utf8str));
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          g_free (utf8str);
        }
        return CB_ERR;
      case CB_FINDSTRINGEXACT:
        {
          gchar *utf8str;
          gint i, length;
          GtkTreeModel *model;

          utf8str = w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          length = gtk_tree_model_iter_n_children (model, NULL);
          for (i = wParam + 1; i < length; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strcasecmp (utf8str, tmp);
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          for (i = 0; i <= wParam; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strcasecmp (utf8str, tmp);
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          g_free (utf8str);
        }
        return CB_ERR;
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_ADDSTRING:
        {
          gchar *utf8str;
          GtkWidget *list_item;

          utf8str = w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          list_item = gtk_list_item_new_with_label (utf8str);
          g_free (utf8str);
          gtk_widget_show (list_item);
          gtk_container_add (GTK_CONTAINER (GTK_COMBO (hWnd)->list),
                                                                    list_item);
          gtk_widget_queue_resize (GTK_WIDGET (hWnd));
          return DefWindowProc (hWnd, CB_GETCOUNT, 0, 0) - 1;
        }
      case CB_GETLBTEXT:
        {
          gchar *mb;
          GList *glist;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          mb = w32ldr_utf8_to_mb
                            (gtk_label_get_text (GTK_LABEL (gtk_bin_get_child
                                (GTK_BIN (g_list_nth_data (glist, wParam))))));
          g_list_free (glist);
          g_strcpy (GINT_TO_POINTER (lParam), mb);
          g_free (mb);
          return g_strlen (GINT_TO_POINTER (lParam));
        }
      case CB_GETLBTEXTLEN:
        {
          gchar *mb;
          GList *glist;
          LRESULT lResult;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          mb = w32ldr_utf8_to_mb
                            (gtk_label_get_text (GTK_LABEL (gtk_bin_get_child
                                (GTK_BIN (g_list_nth_data (glist, wParam))))));
          g_list_free (glist);
          lResult = g_strlen (mb);
          g_free (mb);
          return lResult;
        }
      case CB_INSERTSTRING:
        {
          gchar *utf8str;
          GtkWidget *list_item;

          utf8str = w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          list_item = gtk_list_item_new_with_label (utf8str);
          g_free (utf8str);
          gtk_widget_show (list_item);
          gtk_container_add (GTK_CONTAINER (GTK_COMBO (hWnd)->list),
                                                                    list_item);
          return DefWindowProc (hWnd, CB_GETCOUNT, 0, 0) - 1;
        }
      case CB_FINDSTRING:
        {
          gchar *utf8str;
          gint i, length;
          GList *glist;

          utf8str = w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          length = g_list_length (glist);
          for (i = wParam + 1; i < length; i++)
            if (g_ascii_strncasecmp (gtk_label_get_text (GTK_LABEL
                (gtk_bin_get_child (GTK_BIN (g_list_nth_data (glist, i))))),
                                            utf8str, g_strlen (utf8str)) == 0)
              {
                g_list_free (glist);
                g_free (utf8str);
                return i;
              }
          for (i = 0; i <= wParam; i++)
            if (g_ascii_strncasecmp (gtk_label_get_text (GTK_LABEL
                (gtk_bin_get_child (GTK_BIN (g_list_nth_data (glist, i))))),
                                            utf8str, g_strlen (utf8str)) == 0)
              {
                g_list_free (glist);
                g_free (utf8str);
                return i;
              }
          g_list_free (glist);
          g_free (utf8str);
          return CB_ERR;
        }
      case CB_FINDSTRINGEXACT:
        {
          gchar *utf8str;
          gint i, length;
          GList *glist;

          utf8str = w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          length = g_list_length (glist);
          for (i = wParam + 1; i < length; i++)
            if (g_ascii_strcasecmp (gtk_label_get_text (GTK_LABEL
                (gtk_bin_get_child (GTK_BIN (g_list_nth_data (glist, i))))),
                                                                utf8str) == 0)
              {
                g_list_free (glist);
                g_free (utf8str);
                return i;
              }
          for (i = 0; i <= wParam; i++)
            if (g_ascii_strcasecmp (gtk_label_get_text (GTK_LABEL
                (gtk_bin_get_child (GTK_BIN (g_list_nth_data (glist, i))))),
                                                                utf8str) == 0)
              {
                g_list_free (glist);
                g_free (utf8str);
                return i;
              }
          g_list_free (glist);
          g_free (utf8str);
          return CB_ERR;
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case WM_GETTEXT:
        {
          const gchar *utf8str = NULL;

          if (GTK_IS_BUTTON (hWnd) || GTK_IS_CHECK_BUTTON (hWnd)
                                                || GTK_IS_RADIO_BUTTON (hWnd))
            utf8str = gtk_label_get_text
                            (GTK_LABEL (gtk_bin_get_child (GTK_BIN (hWnd))));
          else if (GTK_IS_LABEL (hWnd))
            utf8str = gtk_label_get_text (GTK_LABEL (hWnd));
          else if (GTK_IS_WINDOW (hWnd))
            utf8str = gtk_window_get_title (GTK_WINDOW (hWnd));
          if (wParam > 0 && lParam && utf8str)
            {
              gchar *mb;

              mb = w32ldr_utf8_to_mb (utf8str);
              g_strncpy (GINT_TO_POINTER (lParam), mb, wParam);
              g_free (mb);
              return g_strlen (GINT_TO_POINTER (lParam));
            }
        }
        return 0;
      case WM_SETTEXT:
        {
          gchar *utf8str;

          utf8str = w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          if (GTK_IS_BUTTON (hWnd) || GTK_IS_CHECK_BUTTON (hWnd)
                                                || GTK_IS_RADIO_BUTTON (hWnd))
            gtk_label_set_text (GTK_LABEL (gtk_bin_get_child (GTK_BIN (hWnd))),
                                                                    utf8str);
          else if (GTK_IS_LABEL (hWnd))
            gtk_label_set_text (GTK_LABEL (hWnd), utf8str);
          else if (GTK_IS_WINDOW (hWnd))
            gtk_window_set_title (GTK_WINDOW (hWnd), utf8str);
          g_free (utf8str);
        }
        return TRUE;
    }
  return DefWindowProcU (hWnd, Msg, wParam, lParam);
}


/* DefWindowProcW ordinal = 136, argument = 16 */
LRESULT WINAPI DefWindowProcW (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  return DefWindowProcU (hWnd, Msg, wParam, lParam);
}


/* DeferWindowPos ordinal = 137, argument = 32 temporary */
static DWORD WINAPI DeferWindowPos (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* DeleteMenu ordinal = 138, argument = 12 temporary */
static DWORD WINAPI DeleteMenu (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DeregisterShellHookWindow ordinal = 139, argument = 4 temporary */
static DWORD WINAPI DeregisterShellHookWindow (DWORD dwArgv0)
{
  return 0;
}


/* DestroyAcceleratorTable ordinal = 140, argument = 4 temporary */
static DWORD WINAPI DestroyAcceleratorTable (DWORD dwArgv0)
{
  return 0;
}


/* DestroyCaret ordinal = 141, argument = 0 temporary */
static DWORD WINAPI DestroyCaret (VOID)
{
  return 0;
}


/* DestroyCursor ordinal = 142, argument = 4 temporary */
static DWORD WINAPI DestroyCursor (DWORD dwArgv0)
{
  return 0;
}


/* DestroyIcon ordinal = 143, argument = 4 temporary */
static DWORD WINAPI DestroyIcon (DWORD dwArgv0)
{
  return 0;
}


/* DestroyMenu ordinal = 144, argument = 4 temporary */
static DWORD WINAPI DestroyMenu (DWORD dwArgv0)
{
  return 0;
}


/* DestroyWindow ordinal = 145, argument = 4 */
BOOL WINAPI DestroyWindow (HWND hWnd)
{
  if (!hWnd)
    return FALSE;
  gtk_widget_destroy (GTK_WIDGET (hWnd));
  return TRUE;
}


/* DeviceEventWorker ordinal = 146, argument = 0 temporary */
static DWORD WINAPI DeviceEventWorker (VOID)
{
  return 0;
}


/* ja:ボタンが押されたとき */
#define dialog_button_toggled dialog_button_clicked
static void
dialog_button_clicked (GtkWidget *widget,
                       gpointer   user_data)
{
  W32LdrWndExtraData *wed;

  wed = g_object_get_data (G_OBJECT (widget), "user_data");
  wed->lpDialogFunc (wed->hWndParent, WM_COMMAND,
                MAKEWPARAM (wed->wID, BN_CLICKED), GPOINTER_TO_INT (widget));
}


/* ja:閉じるボタンが押された */
static gboolean
dialog_delete (GtkWidget          *widget,
               GdkEvent           *event,
               W32LdrWndExtraData *wed)
{
  wed->lpDialogFunc (widget, WM_COMMAND,
                    MAKEWPARAM (IDCANCEL, BN_CLICKED), GPOINTER_TO_INT (NULL));
  return TRUE;
}


/* ja:ESCが押された */
static gboolean
dialog_key_press (GtkWidget          *widget,
                  GdkEventKey        *event,
                  W32LdrWndExtraData *wed)
{
  if (event->keyval == GDK_Escape)
    wed->lpDialogFunc (widget, WM_COMMAND,
                    MAKEWPARAM (IDCANCEL, BN_CLICKED), GPOINTER_TO_INT (NULL));
  return FALSE;
}


/* ja:破棄 */
static void
dialog_widget_destroy (GtkWidget *widget,
                       gpointer   user_data)
{
  W32LdrWndExtraData *wed;

  wed = g_object_get_data (G_OBJECT (widget), "user_data");
  g_free (wed->child);
  g_free (wed->sister);
  g_free (wed);
}


static gunichar2 *
dlg_string_next (gunichar2 *data)
{
  if (*data == 0xffff)
    {
      data += 2;
    }
  else
    {
      while (*data != '\0')
        data++;
      data++;
    }
  return data;
}
#define DLG_STRING_NEXT(data) ((data)=dlg_string_next(data))
#define DLG_ALINMENT_DWORD(data,base)                                       \
    ((data)=(gunichar2 *)((((gint)(data)-(gint)(base)+3)/4)*4+(gint)(base)))


/* DialogBoxIndirectParamA ordinal = 147, argument = 20 */
INT WINAPI DialogBoxIndirectParamA (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam)
{
  gboolean extended;
  gchar *title;
  gunichar2 *data;
  gint i, width = 0, height = 0, cdit = 0;
  guint key = GDK_VoidSymbol;
  PangoLayout *layout;
  GtkAccelGroup *accel;
  GtkWidget *dialog, *fixed, *focus = NULL, *radio = NULL;
  INT nResult;
  DLGTEMPLATE DialogTemplate;
  DLGITEMTEMPLATE DialogItem;
  W32LdrWndExtraData *dlg, *wed;

  if (!lpDialogTemplate || !lpDialogFunc)
    return -1;

  if (((LPCDLGTEMPLATEEX)lpDialogTemplate)->dlgVer == 1
                && ((LPCDLGTEMPLATEEX)lpDialogTemplate)->signature == 0xffff)
    {
      extended = TRUE;
      DialogTemplate.style = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->style;
      DialogTemplate.exstyle = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->exstyle;
      DialogTemplate.cdit = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->cdit;
      DialogTemplate.x = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->x;
      DialogTemplate.y = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->y;
      DialogTemplate.cx = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->cx;
      DialogTemplate.cy = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->cy;
      data = (gunichar2 *)((LPCDLGTEMPLATEEX)lpDialogTemplate + 1);
    }
  else
    {
      extended = FALSE;
      g_memmove (&DialogTemplate, lpDialogTemplate, sizeof (DLGTEMPLATE));
      data = (gunichar2 *)(lpDialogTemplate + 1);
    }
  /* en:Menu name */
  DLG_STRING_NEXT (data);
  /* en:Class name */
  DLG_STRING_NEXT (data);
  /* en:Dialog Title */
  title = *data != 0xffff
                        ? g_utf16_to_utf8 (data, -1, NULL, NULL, NULL) : NULL;
  DLG_STRING_NEXT (data);
  if (DialogTemplate.style & DS_SETFONT)
    {
      /* en:Font Point Weight Italic Charset */
      data += extended ? 3 : 1;
      /* en:Font Face */
      DLG_STRING_NEXT (data);
    }

  dlg = g_malloc (sizeof (W32LdrWndExtraData));
  dlg->dwStyle = DialogTemplate.style;
  dlg->dwExStyle = DialogTemplate.exstyle;
  dlg->lpfnWndProc = DefWindowProc;
  dlg->hInstance = hInstance;
  dlg->hWndParent = hWndParent;
  dlg->wID = 0;
  dlg->dwUserData = 0;
  dlg->lpDialogFunc = lpDialogFunc;
  dlg->lResult = -1;
  dlg->dwUser = 0;
  dlg->child = g_malloc ((DialogTemplate.cdit + 1) * sizeof (GtkWidget *));
  dlg->sister = NULL;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  if (title)
    {
      gtk_window_set_title (GTK_WINDOW (dialog), title);
      g_free (title);
    }
  g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                        G_CALLBACK (dialog_key_press), dlg);
  g_signal_connect (G_OBJECT (dialog), "delete-event",
                                        G_CALLBACK (dialog_delete), dlg);
  g_signal_connect (G_OBJECT (dialog), "destroy", gtk_main_quit, NULL);
  g_object_set_data (G_OBJECT (dialog), "user_data", dlg);
  /* ja:アクセラレータキー */
  accel = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (dialog), accel);
  /* ja:フォント */
  layout = gtk_widget_create_pango_layout (dialog, NULL);
  for (i = 0; i < 128; i++)
    if (g_unichar_isprint (i))
      {
        gint w, h;

        pango_layout_set_text (layout, (const char *)&i, 1);
        pango_layout_get_pixel_size (layout, &w, &h);
        if (width < w)
          width = w;
        if (height < h)
          height = h;
      }
  width = MIN ((height + 1) / 2, width);
  /* ja:フィクスト */
  fixed = gtk_fixed_new ();
  gtk_widget_set_size_request (fixed,
                DialogTemplate.cx * width / 4, DialogTemplate.cy * height / 8);
  gtk_container_add (GTK_CONTAINER (dialog), fixed);

  for (i = 0; i < DialogTemplate.cdit; i++)
    {
      gint j;
      guint16 atom;
      GtkWidget *widget = NULL;

      /* en:Dialog Item */
      DLG_ALINMENT_DWORD (data, lpDialogTemplate);
      if (extended)
        {
          DialogItem.style = ((LPDLGITEMTEMPLATEEX)data)->style;
          DialogItem.exstyle = ((LPDLGITEMTEMPLATEEX)data)->exstyle;
          DialogItem.x = ((LPDLGITEMTEMPLATEEX)data)->x;
          DialogItem.y = ((LPDLGITEMTEMPLATEEX)data)->y;
          DialogItem.cx = ((LPDLGITEMTEMPLATEEX)data)->cx;
          DialogItem.cy = ((LPDLGITEMTEMPLATEEX)data)->cy;
          DialogItem.ID = ((LPDLGITEMTEMPLATEEX)data)->ID;
          data = (gunichar2 *)(((LPDLGITEMTEMPLATEEX)data) + 1);
          DLG_ALINMENT_DWORD (data, lpDialogTemplate);
        }
      else
        {
          g_memmove (&DialogItem, data, sizeof (DLGITEMTEMPLATE));
          data = (gunichar2 *)(((LPDLGITEMTEMPLATE)data) + 1);
        }
      /* en:Class name */
      atom = *data == 0xffff ? data[1] : 0;
      DLG_STRING_NEXT (data);
      /* en:Dialog Title */
      title = *data != 0xffff
                        ? g_utf16_to_utf8 (data, -1, NULL, NULL, NULL) : NULL;
      DLG_STRING_NEXT (data);
      /* en:Creation Data */
      data = (gunichar2 *)((guint8 *)data + (*data + sizeof (guint16)));

      wed = g_malloc (sizeof (W32LdrWndExtraData));
      wed->dwStyle = DialogItem.style;
      wed->dwExStyle = DialogItem.exstyle;
      wed->lpfnWndProc = DefWindowProc;
      wed->hInstance = hInstance;
      wed->hWndParent = dialog;
      wed->wID = DialogItem.ID;
      wed->dwUserData = 0;
      wed->lpDialogFunc = lpDialogFunc;
      wed->lResult = -1;
      wed->dwUser = 0;
      wed->child = NULL;
      wed->sister = NULL;

      if (atom != 0x0080
                    || (DialogItem.style & BS_TYPEMASK) != BS_AUTORADIOBUTTON)
        radio = NULL;

      switch (atom)
        {
          case 0x0080:/* ja:ボタン */
            switch (DialogItem.style & BS_TYPEMASK)
              {
                case BS_PUSHBUTTON:
                case BS_DEFPUSHBUTTON:
                  widget = gtk_button_new_with_label ("");
                  g_signal_connect (G_OBJECT (widget), "clicked",
                                    G_CALLBACK (dialog_button_clicked), NULL);
                  break;
                case BS_AUTOCHECKBOX:
                  widget = gtk_check_button_new_with_label ("");
                  g_signal_connect (G_OBJECT (widget), "toggled",
                                    G_CALLBACK (dialog_button_toggled), NULL);
                  break;
                case BS_AUTORADIOBUTTON:
                  widget = radio ? gtk_radio_button_new_with_label_from_widget
                                                (GTK_RADIO_BUTTON (radio), "")
                                : gtk_radio_button_new_with_label (NULL, "");
                  g_signal_connect (G_OBJECT (widget), "toggled",
                                    G_CALLBACK (dialog_button_toggled), NULL);
                  radio = widget;
                  break;
                default:
                  g_print ("Unsupported Dialog Item Button.\n");
              }
            if (widget)
              {
                if (title)
                  for (j = 0; title[j] != '\0'; j++)
                    if (title[j] == '&')
                      title[j] = '_';
                key = gtk_label_parse_uline (GTK_LABEL (gtk_bin_get_child
                                (GTK_BIN (widget))), title ? title : "Button");
                if (key != GDK_VoidSymbol)
                  {
                    gtk_widget_add_accelerator (widget, "clicked",
                                                accel, key, GDK_MOD1_MASK, 0);
                    key = GDK_VoidSymbol;
                  }
                switch (DialogItem.style & 0x00000300)
                  {
                    case BS_LEFT:
                      gtk_label_set_justify (GTK_LABEL (gtk_bin_get_child
                                    (GTK_BIN (widget))), GTK_JUSTIFY_LEFT);
                      break;
                    case BS_RIGHT:
                      gtk_label_set_justify (GTK_LABEL (gtk_bin_get_child
                                    (GTK_BIN (widget))), GTK_JUSTIFY_RIGHT);
                      break;
                    case BS_CENTER:
                      gtk_label_set_justify (GTK_LABEL (gtk_bin_get_child
                                    (GTK_BIN (widget))), GTK_JUSTIFY_CENTER);
                  }
                gtk_widget_set_size_request (widget,
                        DialogItem.cx * width / 4, DialogItem.cy * height / 8);
                if (focus)
                  focus = widget;
              }
            break;
          case 0x0081:/* ja:エディト */
            g_print ("Unsupported Dialog Item Edit.\n");
            break;
          case 0x0082:/* ja:スタティック */
            switch (DialogItem.style & SS_TYPEMASK)
              {
                case SS_LEFT:
                case SS_CENTER:
                case SS_RIGHT:
                case SS_LEFTNOWORDWRAP:
                  if ((DialogItem.style & SS_NOPREFIX) || !title)
                    {
                      widget = gtk_label_new (title ? title : "Static");
                      key = GDK_VoidSymbol;
                    }
                  else
                    {
                      widget = gtk_label_new ("");
                      for (j = 0; title[j] != '\0'; j++)
                        if (title[j] == '&')
                          title[j] = '_';
                      key = gtk_label_parse_uline (GTK_LABEL (widget), title);
                    }
                  switch (DialogItem.style & SS_TYPEMASK)
                    {
                      case SS_CENTER:
                        gtk_label_set_justify (GTK_LABEL (widget),
                                                        GTK_JUSTIFY_CENTER);
                        break;
                      case SS_RIGHT:
                        gtk_label_set_justify (GTK_LABEL (widget),
                                                        GTK_JUSTIFY_RIGHT);
                        break;
                      default:
                        gtk_label_set_justify (GTK_LABEL (widget),
                                                            GTK_JUSTIFY_LEFT);
                    }
                  gtk_label_set_line_wrap (GTK_LABEL (widget),
                        (DialogItem.style & SS_TYPEMASK) != SS_LEFTNOWORDWRAP);
                  break;
                default:
                  g_print ("Unsupported Dialog Item Static.\n");
              }
            if (widget)
              gtk_widget_set_size_request (widget,
                        DialogItem.cx * width / 4, DialogItem.cy * height / 8);
            break;
          case 0x0083:/* ja:リストボックス */
            g_print ("Unsupported Dialog Item ListBox.\n");
            break;
          case 0x0084:/* ja:スクロールバー */
            switch (DialogItem.style & SBS_TYPEMASK)
              {
                case SBS_HORZ:
                  widget = gtk_hscrollbar_new
                    (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 0, 1, 1, 1)));
                  break;
                case SBS_VERT:
                  widget = gtk_hscrollbar_new
                    (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 0, 1, 1, 1)));
                  break;
                default:
                  g_print ("Unsupported Dialog Item ScrollBar.\n");
              }
            if (widget)
              gtk_widget_set_size_request (widget,
                        DialogItem.cx * width / 4, DialogItem.cy * height / 8);
            break;
          case 0x0085:/* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
            {
              GtkCellRenderer *renderer;
              GtkListStore *store;

              store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
              widget = (DialogItem.style & 0xf) == CBS_DROPDOWNLIST
                        ? gtk_combo_box_new_with_model (GTK_TREE_MODEL (store))
                        : gtk_combo_box_entry_new_with_model
                                                (GTK_TREE_MODEL (store), 0);
              g_object_unref (store);
              renderer = gtk_cell_renderer_text_new ();
              gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (widget),
                                                            renderer, TRUE);
              gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (widget),
                                                    renderer, "text", 0, NULL);
              if (key != GDK_VoidSymbol)
                {
                  gtk_widget_add_accelerator
                                (gtk_bin_get_child (GTK_BIN (widget)),
                                "grab-focus", accel, key, GDK_MOD1_MASK, 0);
                  key = GDK_VoidSymbol;
                }
              if (!focus)
                focus = (DialogItem.style & 0xf) == CBS_DROPDOWNLIST
                            ? widget : gtk_bin_get_child (GTK_BIN (widget));
            }
#else /* not GTK_CHECK_VERSION(2,4,0) */
            widget = gtk_combo_new ();
            gtk_editable_set_editable
                                (GTK_EDITABLE (GTK_COMBO (widget)->entry),
                                (DialogItem.style & 0xf) != CBS_DROPDOWNLIST);
            if (key != GDK_VoidSymbol)
              {
                gtk_widget_add_accelerator (GTK_COMBO (widget)->entry,
                                "grab-focus", accel, key, GDK_MOD1_MASK, 0);
                key = GDK_VoidSymbol;
              }
            if (!focus)
              focus = GTK_COMBO (widget)->entry;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
            break;
          case 0x0000:/* ja:ユーザ定義 */
            g_print ("User-defined Dialog Item.\n");
            break;
          default:
            g_print ("Unknown Dialog Item.\n");
        }
      g_free (title);
      if (widget)
        {
          g_signal_connect_after (G_OBJECT (widget), "destroy",
                                    G_CALLBACK (dialog_widget_destroy), NULL);
          g_object_set_data (G_OBJECT (widget), "user_data", wed);
          gtk_fixed_put (GTK_FIXED (fixed), widget,
                        DialogItem.x * width / 4, DialogItem.y * height / 8);
          if (DialogItem.style & WS_DISABLED)
            gtk_widget_set_sensitive (widget, FALSE);
          if (DialogItem.style & WS_VISIBLE)
            gtk_widget_show (widget);
          if (wed->sister)
            for (j = 0; wed->sister[j]; j++)
              {
                if (DialogItem.style & WS_DISABLED)
                  gtk_widget_set_sensitive (wed->sister[j], FALSE);
                if (DialogItem.style & WS_VISIBLE)
                  gtk_widget_show (wed->sister[j]);
              }
           dlg->child[cdit++] = widget;
        }
      else
        {
          g_free (wed);
        }
    }
  if (dlg->child)
    dlg->child[cdit] = NULL;

  /* ja:ダイアログ */
  if (hWndParent)
    gtk_window_set_transient_for (GTK_WINDOW (dialog),
                                                    GTK_WINDOW (hWndParent));
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_type_hint (GTK_WINDOW (dialog), GDK_WINDOW_TYPE_HINT_DIALOG);
  /* ja:表示 */
  if (focus)
    gtk_widget_grab_focus (focus);
  gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show (fixed);
  gtk_widget_show (dialog);
  lpDialogFunc (dialog, WM_INITDIALOG, GPOINTER_TO_INT (focus), dwInitParam);
  gtk_main ();

  nResult = dlg->lResult;
  g_free (dlg->child);
  g_free (dlg);
  return nResult;
}


/* DialogBoxIndirectParamAorW ordinal = 148, argument = 0 temporary */
static DWORD WINAPI DialogBoxIndirectParamAorW (VOID)
{
  return 0;
}


/* DialogBoxIndirectParamW ordinal = 149, argument = 20 */
INT WINAPI DialogBoxIndirectParamW (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam)
{
  return DialogBoxIndirectParamW (hInstance, lpDialogTemplate, hWndParent, lpDialogFunc, dwInitParam);
}


/* DialogBoxParamA ordinal = 150, argument = 20 */
INT WINAPI DialogBoxParamA (HINSTANCE hInstance, LPCSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam)
{
  LPCDLGTEMPLATE lpDialogTemplate;
  HRSRC hRsrc;

  return (hRsrc = FindResourceA (hInstance, lpTemplateName, (LPCSTR)RT_DIALOG))
                        && (lpDialogTemplate = LoadResource (hInstance, hRsrc))
        ? DialogBoxIndirectParam (hInstance, lpDialogTemplate,
                                hWndParent, lpDialogFunc, dwInitParam) : -1;
}


/* DialogBoxParamW ordinal = 151, argument = 20 */
INT WINAPI DialogBoxParamW (HINSTANCE hInstance, LPCWSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam)
{
  LPCDLGTEMPLATE lpDialogTemplate;
  HRSRC hRsrc;

  return (hRsrc = FindResourceW
                            (hInstance, lpTemplateName, (LPCWSTR)RT_DIALOG))
                        && (lpDialogTemplate = LoadResource (hInstance, hRsrc))
        ? DialogBoxIndirectParam (hInstance, lpDialogTemplate,
                                hWndParent, lpDialogFunc, dwInitParam) : -1;
}


/* DispatchMessageA ordinal = 152, argument = 4 temporary */
static DWORD WINAPI DispatchMessageA (DWORD dwArgv0)
{
  return 0;
}


/* DispatchMessageW ordinal = 153, argument = 4 temporary */
static DWORD WINAPI DispatchMessageW (DWORD dwArgv0)
{
  return 0;
}


/* DlgDirListA ordinal = 154, argument = 20 temporary */
static DWORD WINAPI DlgDirListA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DlgDirListComboBoxA ordinal = 155, argument = 20 temporary */
static DWORD WINAPI DlgDirListComboBoxA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DlgDirListComboBoxW ordinal = 156, argument = 20 temporary */
static DWORD WINAPI DlgDirListComboBoxW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DlgDirListW ordinal = 157, argument = 20 temporary */
static DWORD WINAPI DlgDirListW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DlgDirSelectComboBoxExA ordinal = 158, argument = 16 temporary */
static DWORD WINAPI DlgDirSelectComboBoxExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DlgDirSelectComboBoxExW ordinal = 159, argument = 16 temporary */
static DWORD WINAPI DlgDirSelectComboBoxExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DlgDirSelectExA ordinal = 160, argument = 16 temporary */
static DWORD WINAPI DlgDirSelectExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DlgDirSelectExW ordinal = 161, argument = 16 temporary */
static DWORD WINAPI DlgDirSelectExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DragDetect ordinal = 162, argument = 12 temporary */
static DWORD WINAPI DragDetect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DragObject ordinal = 163, argument = 20 temporary */
static DWORD WINAPI DragObject (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DrawAnimatedRects ordinal = 164, argument = 16 temporary */
static DWORD WINAPI DrawAnimatedRects (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DrawCaption ordinal = 165, argument = 16 temporary */
static DWORD WINAPI DrawCaption (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DrawCaptionTempA ordinal = 166, argument = 0 temporary */
static DWORD WINAPI DrawCaptionTempA (VOID)
{
  return 0;
}


/* DrawCaptionTempW ordinal = 167, argument = 0 temporary */
static DWORD WINAPI DrawCaptionTempW (VOID)
{
  return 0;
}


/* DrawEdge ordinal = 168, argument = 16 temporary */
static DWORD WINAPI DrawEdge (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DrawFocusRect ordinal = 169, argument = 8 temporary */
static DWORD WINAPI DrawFocusRect (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DrawFrame ordinal = 170, argument = 16 temporary */
static DWORD WINAPI DrawFrame (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DrawFrameControl ordinal = 171, argument = 16 temporary */
static DWORD WINAPI DrawFrameControl (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DrawIcon ordinal = 172, argument = 16 temporary */
static DWORD WINAPI DrawIcon (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DrawIconEx ordinal = 173, argument = 36 temporary */
static DWORD WINAPI DrawIconEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* DrawMenuBar ordinal = 174, argument = 4 temporary */
static DWORD WINAPI DrawMenuBar (DWORD dwArgv0)
{
  return 0;
}


/* DrawMenuBarTemp ordinal = 175, argument = 0 temporary */
static DWORD WINAPI DrawMenuBarTemp (VOID)
{
  return 0;
}


/* DrawStateA ordinal = 176, argument = 40 temporary */
static DWORD WINAPI DrawStateA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* DrawStateW ordinal = 177, argument = 40 temporary */
static DWORD WINAPI DrawStateW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* DrawTextA ordinal = 178, argument = 20 temporary */
static DWORD WINAPI DrawTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* DrawTextExA ordinal = 179, argument = 24 temporary */
static DWORD WINAPI DrawTextExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* DrawTextExW ordinal = 180, argument = 24 temporary */
static DWORD WINAPI DrawTextExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* DrawTextW ordinal = 181, argument = 20 temporary */
static DWORD WINAPI DrawTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EditWndProc ordinal = 182, argument = 16 temporary */
static DWORD WINAPI EditWndProc (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EmptyClipboard ordinal = 183, argument = 0 temporary */
static DWORD WINAPI EmptyClipboard (VOID)
{
  return 0;
}


/* EnableMenuItem ordinal = 184, argument = 12 temporary */
static DWORD WINAPI EnableMenuItem (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnableScrollBar ordinal = 185, argument = 12 temporary */
static DWORD WINAPI EnableScrollBar (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnableWindow ordinal = 186, argument = 8 */
BOOL WINAPI EnableWindow (HWND hWnd, BOOL bEnable)
{
  if (!hWnd)
    return FALSE;
  SendMessage (hWnd, WM_ENABLE, bEnable, 0);
  return TRUE;
}


/* EndDeferWindowPos ordinal = 187, argument = 4 temporary */
static DWORD WINAPI EndDeferWindowPos (DWORD dwArgv0)
{
  return 0;
}


/* EndDialog ordinal = 188, argument = 8 */
BOOL WINAPI EndDialog (HWND hDlg, INT nResult)
{
  W32LdrWndExtraData *wed;

  if (hDlg && (wed = g_object_get_data (G_OBJECT (hDlg), "user_data")))
    {
      wed->lResult = nResult;
      gtk_widget_destroy (GTK_WIDGET (hDlg));
      return TRUE;
    }
  return FALSE;
}


/* EndMenu ordinal = 189, argument = 0 temporary */
static DWORD WINAPI EndMenu (VOID)
{
  return 0;
}


/* EndPaint ordinal = 190, argument = 8 */
BOOL WINAPI EndPaint (HWND hWnd, LPPAINTSTRUCT lpPaint)
{
  return FALSE;
}


/* EndTask ordinal = 191, argument = 12 temporary */
static DWORD WINAPI EndTask (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumChildWindows ordinal = 192, argument = 12 temporary */
static DWORD WINAPI EnumChildWindows (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumClipboardFormats ordinal = 193, argument = 4 temporary */
static DWORD WINAPI EnumClipboardFormats (DWORD dwArgv0)
{
  return 0;
}


/* EnumDesktopWindows ordinal = 194, argument = 12 temporary */
static DWORD WINAPI EnumDesktopWindows (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumDesktopsA ordinal = 195, argument = 12 temporary */
static DWORD WINAPI EnumDesktopsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumDesktopsW ordinal = 196, argument = 12 temporary */
static DWORD WINAPI EnumDesktopsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumDisplayDevicesA ordinal = 197, argument = 16 temporary */
static DWORD WINAPI EnumDisplayDevicesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumDisplayDevicesW ordinal = 198, argument = 16 temporary */
static DWORD WINAPI EnumDisplayDevicesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumDisplayMonitors ordinal = 199, argument = 16 temporary */
static DWORD WINAPI EnumDisplayMonitors (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumDisplaySettingsA ordinal = 200, argument = 12 temporary */
static DWORD WINAPI EnumDisplaySettingsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumDisplaySettingsExA ordinal = 201, argument = 16 temporary */
static DWORD WINAPI EnumDisplaySettingsExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumDisplaySettingsExW ordinal = 202, argument = 16 temporary */
static DWORD WINAPI EnumDisplaySettingsExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumDisplaySettingsW ordinal = 203, argument = 12 temporary */
static DWORD WINAPI EnumDisplaySettingsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumPropsA ordinal = 204, argument = 8 temporary */
static DWORD WINAPI EnumPropsA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumPropsExA ordinal = 205, argument = 12 temporary */
static DWORD WINAPI EnumPropsExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumPropsExW ordinal = 206, argument = 12 temporary */
static DWORD WINAPI EnumPropsExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumPropsW ordinal = 207, argument = 8 temporary */
static DWORD WINAPI EnumPropsW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumThreadWindows ordinal = 208, argument = 12 */
BOOL WINAPI EnumThreadWindows (DWORD dwThreadId, WNDENUMPROC lpfn, LPARAM lParam)
{
  return TRUE;
}


/* EnumWindowStationsA ordinal = 209, argument = 8 temporary */
static DWORD WINAPI EnumWindowStationsA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumWindowStationsW ordinal = 210, argument = 8 temporary */
static DWORD WINAPI EnumWindowStationsW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumWindows ordinal = 211, argument = 8 temporary */
static DWORD WINAPI EnumWindows (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EqualRect ordinal = 212, argument = 8 temporary */
static DWORD WINAPI EqualRect (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ExcludeUpdateRgn ordinal = 213, argument = 8 temporary */
static DWORD WINAPI ExcludeUpdateRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ExitWindowsEx ordinal = 214, argument = 8 temporary */
static DWORD WINAPI ExitWindowsEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FillRect ordinal = 215, argument = 12 temporary */
static DWORD WINAPI FillRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindWindowA ordinal = 216, argument = 8 temporary */
static DWORD WINAPI FindWindowA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindWindowExA ordinal = 217, argument = 16 temporary */
static DWORD WINAPI FindWindowExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FindWindowExW ordinal = 218, argument = 16 temporary */
static DWORD WINAPI FindWindowExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FindWindowW ordinal = 219, argument = 8 temporary */
static DWORD WINAPI FindWindowW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FlashWindow ordinal = 220, argument = 8 temporary */
static DWORD WINAPI FlashWindow (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FlashWindowEx ordinal = 221, argument = 4 temporary */
static DWORD WINAPI FlashWindowEx (DWORD dwArgv0)
{
  return 0;
}


/* FrameRect ordinal = 222, argument = 12 temporary */
static DWORD WINAPI FrameRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FreeDDElParam ordinal = 223, argument = 8 temporary */
static DWORD WINAPI FreeDDElParam (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetActiveWindow ordinal = 224, argument = 0 temporary */
static DWORD WINAPI GetActiveWindow (VOID)
{
  return 0;
}


/* GetAltTabInfo ordinal = 225, argument = 20 temporary */
/* DWORD WINAPI GetAltTabInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4) */


/* GetAltTabInfoA ordinal = 226, argument = 20 temporary */
static DWORD WINAPI GetAltTabInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetAltTabInfoW ordinal = 227, argument = 20 temporary */
static DWORD WINAPI GetAltTabInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetAncestor ordinal = 228, argument = 8 temporary */
static DWORD WINAPI GetAncestor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetAppCompatFlags ordinal = 230, argument = 0 temporary */
static DWORD WINAPI GetAppCompatFlags (VOID)
{
  return 0;
}


/* GetAppCompatFlags2 ordinal = 229, argument = 0 temporary */
static DWORD WINAPI GetAppCompatFlags2 (VOID)
{
  return 0;
}


/* GetAsyncKeyState ordinal = 231, argument = 4 temporary */
static DWORD WINAPI GetAsyncKeyState (DWORD dwArgv0)
{
  return 0;
}


/* GetCapture ordinal = 232, argument = 0 temporary */
static DWORD WINAPI GetCapture (VOID)
{
  return 0;
}


/* GetCaretBlinkTime ordinal = 233, argument = 0 temporary */
static DWORD WINAPI GetCaretBlinkTime (VOID)
{
  return 0;
}


/* GetCaretPos ordinal = 234, argument = 4 temporary */
static DWORD WINAPI GetCaretPos (DWORD dwArgv0)
{
  return 0;
}


/* GetClassInfoA ordinal = 235, argument = 12 temporary */
static DWORD WINAPI GetClassInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetClassInfoExA ordinal = 236, argument = 12 temporary */
static DWORD WINAPI GetClassInfoExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetClassInfoExW ordinal = 237, argument = 12 temporary */
static DWORD WINAPI GetClassInfoExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetClassInfoW ordinal = 238, argument = 12 temporary */
static DWORD WINAPI GetClassInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetClassLongA ordinal = 239, argument = 8 temporary */
static DWORD WINAPI GetClassLongA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetClassLongW ordinal = 240, argument = 8 temporary */
static DWORD WINAPI GetClassLongW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetClassNameA ordinal = 241, argument = 12 temporary */
static DWORD WINAPI GetClassNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetClassNameW ordinal = 242, argument = 12 temporary */
static DWORD WINAPI GetClassNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetClassWord ordinal = 243, argument = 8 temporary */
static DWORD WINAPI GetClassWord (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetClientRect ordinal = 244, argument = 8 */
BOOL WINAPI GetClientRect (HWND hWnd, LPRECT lpRect)
{
  gint width, height;

  if (GTK_IS_WINDOW (hWnd))
    gdk_window_get_size (gtk_bin_get_child (GTK_BIN (hWnd))->window,
                                                            &width, &height);
  else
    gdk_window_get_size (GTK_WIDGET (hWnd)->window, &width, &height);
  lpRect->left = 0;
  lpRect->top = 0;
  lpRect->right = width;
  lpRect->bottom = height;
  return TRUE;
}


/* GetClipCursor ordinal = 245, argument = 4 temporary */
static DWORD WINAPI GetClipCursor (DWORD dwArgv0)
{
  return 0;
}


/* GetClipboardData ordinal = 246, argument = 4 temporary */
static DWORD WINAPI GetClipboardData (DWORD dwArgv0)
{
  return 0;
}


/* GetClipboardFormatNameA ordinal = 247, argument = 12 temporary */
static DWORD WINAPI GetClipboardFormatNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetClipboardFormatNameW ordinal = 248, argument = 12 temporary */
static DWORD WINAPI GetClipboardFormatNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetClipboardOwner ordinal = 249, argument = 0 temporary */
static DWORD WINAPI GetClipboardOwner (VOID)
{
  return 0;
}


/* GetClipboardSequenceNumber ordinal = 250, argument = 0 temporary */
static DWORD WINAPI GetClipboardSequenceNumber (VOID)
{
  return 0;
}


/* GetClipboardViewer ordinal = 251, argument = 0 temporary */
static DWORD WINAPI GetClipboardViewer (VOID)
{
  return 0;
}


/* GetComboBoxInfo ordinal = 252, argument = 8 temporary */
static DWORD WINAPI GetComboBoxInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCursor ordinal = 253, argument = 0 temporary */
static DWORD WINAPI GetCursor (VOID)
{
  return 0;
}


/* GetCursorFrameInfo ordinal = 254, argument = 0 temporary */
static DWORD WINAPI GetCursorFrameInfo (VOID)
{
  return 0;
}


/* GetCursorInfo ordinal = 255, argument = 4 temporary */
static DWORD WINAPI GetCursorInfo (DWORD dwArgv0)
{
  return 0;
}


/* GetCursorPos ordinal = 256, argument = 4 temporary */
static DWORD WINAPI GetCursorPos (DWORD dwArgv0)
{
  return 0;
}


/* GetDC ordinal = 257, argument = 4 */
HDC WINAPI GetDC (HWND hWnd)
{
  return NULL;
}


/* GetDCEx ordinal = 258, argument = 12 temporary */
static DWORD WINAPI GetDCEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetDesktopWindow ordinal = 259, argument = 0 */
HWND WINAPI GetDesktopWindow (VOID)
{
  return NULL;
}


/* GetDialogBaseUnits ordinal = 260, argument = 0 temporary */
static DWORD WINAPI GetDialogBaseUnits (VOID)
{
  return 0;
}


/* GetDlgCtrlID ordinal = 261, argument = 4 */
INT WINAPI GetDlgCtrlID (HWND hWndCtl)
{
  W32LdrWndExtraData *wed;

  return hWndCtl && (wed = g_object_get_data (G_OBJECT (hWndCtl), "user_data"))
                                                                ? wed->wID : 0;
}


/* GetDlgItem ordinal = 262, argument = 8 */
HWND WINAPI GetDlgItem (HWND hDlg, INT nIDDlgItem)
{
  gint i;
  W32LdrWndExtraData *dlg;

  if (hDlg && (dlg = g_object_get_data (G_OBJECT (hDlg), "user_data")))
    for (i = 0; dlg->child[i]; i++)
      {
        W32LdrWndExtraData *wed;

        wed = g_object_get_data (G_OBJECT (dlg->child[i]), "user_data");
        if (wed && wed->wID == (WORD)nIDDlgItem)
          return dlg->child[i];
      }
  return NULL;
}


/* GetDlgItemInt ordinal = 263, argument = 16 */
UINT WINAPI GetDlgItemInt (HWND hDlg, INT nIDDlgItem, BOOL *lpTranslated, BOOL bSigned)
{
  gboolean result;
  const gchar *text;
  gint value = 0;
  GtkWidget *widget;

  text = (widget = GetDlgItem (hDlg, nIDDlgItem))
                ? gtk_label_get_text (GTK_LABEL (GTK_IS_BUTTON (widget)
                || GTK_IS_CHECK_BUTTON (widget) || GTK_IS_RADIO_BUTTON (widget)
                    ? gtk_bin_get_child (GTK_BIN (widget)) : widget)) : NULL;
  result = text ? misc_str_to_val (&value, text, 10, bSigned) : FALSE;
  if (lpTranslated)
    *lpTranslated = result;
  return value;
}


/* GetDlgItemTextA ordinal = 264, argument = 16 temporary */
static DWORD WINAPI GetDlgItemTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetDlgItemTextW ordinal = 265, argument = 16 temporary */
static DWORD WINAPI GetDlgItemTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetDoubleClickTime ordinal = 266, argument = 0 temporary */
static DWORD WINAPI GetDoubleClickTime (VOID)
{
  return 0;
}


/* GetFocus ordinal = 267, argument = 0 */
HWND WINAPI GetFocus (VOID)
{
  return NULL;
}


/* GetForegroundWindow ordinal = 268, argument = 0 temporary */
static DWORD WINAPI GetForegroundWindow (VOID)
{
  return 0;
}


/* GetGUIThreadInfo ordinal = 269, argument = 8 temporary */
static DWORD WINAPI GetGUIThreadInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetGuiResources ordinal = 270, argument = 8 temporary */
static DWORD WINAPI GetGuiResources (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetIconInfo ordinal = 271, argument = 8 temporary */
static DWORD WINAPI GetIconInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetInputDesktop ordinal = 272, argument = 0 temporary */
static DWORD WINAPI GetInputDesktop (VOID)
{
  return 0;
}


/* GetInputState ordinal = 273, argument = 0 temporary */
static DWORD WINAPI GetInputState (VOID)
{
  return 0;
}


/* GetInternalWindowPos ordinal = 274, argument = 0 temporary */
static DWORD WINAPI GetInternalWindowPos (VOID)
{
  return 0;
}


/* GetKBCodePage ordinal = 275, argument = 0 temporary */
static DWORD WINAPI GetKBCodePage (VOID)
{
  return 0;
}


/* GetKeyNameTextA ordinal = 276, argument = 12 temporary */
static DWORD WINAPI GetKeyNameTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetKeyNameTextW ordinal = 277, argument = 12 temporary */
static DWORD WINAPI GetKeyNameTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetKeyState ordinal = 278, argument = 4 temporary */
static DWORD WINAPI GetKeyState (DWORD dwArgv0)
{
  return 0;
}


/* GetKeyboardLayout ordinal = 279, argument = 4 temporary */
static DWORD WINAPI GetKeyboardLayout (DWORD dwArgv0)
{
  return 0;
}


/* GetKeyboardLayoutList ordinal = 280, argument = 8 temporary */
static DWORD WINAPI GetKeyboardLayoutList (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetKeyboardLayoutNameA ordinal = 281, argument = 4 temporary */
static DWORD WINAPI GetKeyboardLayoutNameA (DWORD dwArgv0)
{
  return 0;
}


/* GetKeyboardLayoutNameW ordinal = 282, argument = 4 temporary */
static DWORD WINAPI GetKeyboardLayoutNameW (DWORD dwArgv0)
{
  return 0;
}


/* GetKeyboardState ordinal = 283, argument = 4 temporary */
static DWORD WINAPI GetKeyboardState (DWORD dwArgv0)
{
  return 0;
}


/* GetKeyboardType ordinal = 284, argument = 4 */
INT WINAPI GetKeyboardType (INT nTypeFlag)
{
  return 0;
}


/* GetLastActivePopup ordinal = 285, argument = 4 temporary */
static DWORD WINAPI GetLastActivePopup (DWORD dwArgv0)
{
  return 0;
}


/* GetLastInputInfo ordinal = 286, argument = 4 temporary */
static DWORD WINAPI GetLastInputInfo (DWORD dwArgv0)
{
  return 0;
}


/* GetListBoxInfo ordinal = 287, argument = 4 temporary */
static DWORD WINAPI GetListBoxInfo (DWORD dwArgv0)
{
  return 0;
}


/* GetMenu ordinal = 288, argument = 4 temporary */
static DWORD WINAPI GetMenu (DWORD dwArgv0)
{
  return 0;
}


/* GetMenuBarInfo ordinal = 289, argument = 16 temporary */
static DWORD WINAPI GetMenuBarInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetMenuCheckMarkDimensions ordinal = 290, argument = 0 temporary */
static DWORD WINAPI GetMenuCheckMarkDimensions (VOID)
{
  return 0;
}


/* GetMenuContextHelpId ordinal = 291, argument = 4 temporary */
static DWORD WINAPI GetMenuContextHelpId (DWORD dwArgv0)
{
  return 0;
}


/* GetMenuDefaultItem ordinal = 292, argument = 12 temporary */
static DWORD WINAPI GetMenuDefaultItem (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetMenuInfo ordinal = 293, argument = 8 temporary */
static DWORD WINAPI GetMenuInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetMenuItemCount ordinal = 294, argument = 4 temporary */
static DWORD WINAPI GetMenuItemCount (DWORD dwArgv0)
{
  return 0;
}


/* GetMenuItemID ordinal = 295, argument = 8 temporary */
static DWORD WINAPI GetMenuItemID (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetMenuItemInfoA ordinal = 296, argument = 16 temporary */
static DWORD WINAPI GetMenuItemInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetMenuItemInfoW ordinal = 297, argument = 16 temporary */
static DWORD WINAPI GetMenuItemInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetMenuItemRect ordinal = 298, argument = 16 temporary */
static DWORD WINAPI GetMenuItemRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetMenuState ordinal = 299, argument = 12 temporary */
static DWORD WINAPI GetMenuState (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetMenuStringA ordinal = 300, argument = 20 temporary */
static DWORD WINAPI GetMenuStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetMenuStringW ordinal = 301, argument = 20 temporary */
static DWORD WINAPI GetMenuStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetMessageA ordinal = 302, argument = 16 temporary */
static DWORD WINAPI GetMessageA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetMessageExtraInfo ordinal = 303, argument = 0 temporary */
static DWORD WINAPI GetMessageExtraInfo (VOID)
{
  return 0;
}


/* GetMessagePos ordinal = 304, argument = 0 temporary */
static DWORD WINAPI GetMessagePos (VOID)
{
  return 0;
}


/* GetMessageTime ordinal = 305, argument = 0 temporary */
static DWORD WINAPI GetMessageTime (VOID)
{
  return 0;
}


/* GetMessageW ordinal = 306, argument = 16 temporary */
static DWORD WINAPI GetMessageW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetMonitorInfoA ordinal = 307, argument = 8 temporary */
static DWORD WINAPI GetMonitorInfoA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetMonitorInfoW ordinal = 308, argument = 8 temporary */
static DWORD WINAPI GetMonitorInfoW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetMouseMovePointsEx ordinal = 309, argument = 20 temporary */
static DWORD WINAPI GetMouseMovePointsEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetNextDlgGroupItem ordinal = 310, argument = 12 temporary */
static DWORD WINAPI GetNextDlgGroupItem (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetNextDlgTabItem ordinal = 311, argument = 12 temporary */
static DWORD WINAPI GetNextDlgTabItem (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetOpenClipboardWindow ordinal = 312, argument = 0 temporary */
static DWORD WINAPI GetOpenClipboardWindow (VOID)
{
  return 0;
}


/* GetParent ordinal = 313, argument = 4 temporary */
static DWORD WINAPI GetParent (DWORD dwArgv0)
{
  return 0;
}


/* GetPriorityClipboardFormat ordinal = 314, argument = 8 temporary */
static DWORD WINAPI GetPriorityClipboardFormat (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetProcessDefaultLayout ordinal = 315, argument = 4 temporary */
static DWORD WINAPI GetProcessDefaultLayout (DWORD dwArgv0)
{
  return 0;
}


/* GetProcessWindowStation ordinal = 316, argument = 0 temporary */
static DWORD WINAPI GetProcessWindowStation (VOID)
{
  return 0;
}


/* GetProgmanWindow ordinal = 317, argument = 0 temporary */
static DWORD WINAPI GetProgmanWindow (VOID)
{
  return 0;
}


/* GetPropA ordinal = 318, argument = 8 temporary */
static DWORD WINAPI GetPropA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetPropW ordinal = 319, argument = 8 temporary */
static DWORD WINAPI GetPropW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetQueueStatus ordinal = 320, argument = 4 temporary */
static DWORD WINAPI GetQueueStatus (DWORD dwArgv0)
{
  return 0;
}


/* GetScrollBarInfo ordinal = 321, argument = 12 temporary */
static DWORD WINAPI GetScrollBarInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetScrollInfo ordinal = 322, argument = 12 temporary */
static DWORD WINAPI GetScrollInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetScrollPos ordinal = 323, argument = 8 */
INT WINAPI GetScrollPos (HWND hWnd, INT nBar)
{
  return nBar==SB_CTL ? SendMessage (hWnd, SBM_GETPOS, 0, 0) : 0;
}


/* GetScrollRange ordinal = 324, argument = 16 */
BOOL WINAPI GetScrollRange (HWND hWnd, INT nBar, LPINT lpMinPos, LPINT lpMaxPos)
{
  if (nBar != SB_CTL)
    return FALSE;
  SendMessage (hWnd, SBM_GETRANGE,
                    GPOINTER_TO_INT (lpMinPos), GPOINTER_TO_INT (lpMaxPos));
  return TRUE;
}


/* GetShellWindow ordinal = 325, argument = 0 temporary */
static DWORD WINAPI GetShellWindow (VOID)
{
  return 0;
}


/* GetSubMenu ordinal = 326, argument = 8 temporary */
static DWORD WINAPI GetSubMenu (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetSysColor ordinal = 327, argument = 4 */
DWORD WINAPI GetSysColor (int nIndex)
{
  switch (nIndex)
    {
      case COLOR_SCROLLBAR:               return 0xccdddd;
      case COLOR_BACKGROUND:              return 0xaa6633;
      case COLOR_ACTIVECAPTION:           return 0x662200;
      case COLOR_INACTIVECAPTION:         return 0x888888;
      case COLOR_MENU:                    return 0xccdddd;
      case COLOR_WINDOW:                  return 0xffffff;
      case COLOR_WINDOWFRAME:             return 0x000000;
      case COLOR_MENUTEXT:                return 0x000000;
      case COLOR_WINDOWTEXT:              return 0x000000;
      case COLOR_CAPTIONTEXT:             return 0xffffff;
      case COLOR_ACTIVEBORDER:            return 0xccdddd;
      case COLOR_INACTIVEBORDER:          return 0xccdddd;
      case COLOR_APPWORKSPACE:            return 0x888888;
      case COLOR_HIGHLIGHT:               return 0x662200;
      case COLOR_HIGHLIGHTTEXT:           return 0xffffff;
      case COLOR_BTNFACE:                 return 0xccdddd;
      case COLOR_BTNSHADOW:               return 0x888888;
      case COLOR_GRAYTEXT:                return 0x888888;
      case COLOR_BTNTEXT:                 return 0x000000;
      case COLOR_INACTIVECAPTIONTEXT:     return 0xccdddd;
      case COLOR_BTNHIGHLIGHT:            return 0xffffff;
      case COLOR_3DDKSHADOW:              return 0x444444;
      case COLOR_3DLIGHT:                 return 0xccdddd;
      case COLOR_INFOTEXT:                return 0x000000;
      case COLOR_INFOBK:                  return 0xeeffff;
      case COLOR_ALTERNATEBTNFACE:        return 0xbbbbbb;
      case COLOR_HOTLIGHT:                return 0xff0000;
      case COLOR_GRADIENTACTIVECAPTION:   return 0xffccaa;
      case COLOR_GRADIENTINACTIVECAPTION: return 0xcccccc;
      case COLOR_MENUHILIGHT:             return 0x000000;
      case COLOR_MENUBAR:                 return 0x000000;
    }
  return 0;
}


/* GetSysColorBrush ordinal = 328, argument = 4 temporary */
static DWORD WINAPI GetSysColorBrush (DWORD dwArgv0)
{
  return 0;
}


/* GetSystemMenu ordinal = 329, argument = 8 temporary */
static DWORD WINAPI GetSystemMenu (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetSystemMetrics ordinal = 330, argument = 4 */
INT WINAPI GetSystemMetrics (INT nIndex)
{
  return 0;
}


/* GetTabbedTextExtentA ordinal = 331, argument = 20 temporary */
static DWORD WINAPI GetTabbedTextExtentA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetTabbedTextExtentW ordinal = 332, argument = 20 temporary */
static DWORD WINAPI GetTabbedTextExtentW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetTaskmanWindow ordinal = 333, argument = 0 temporary */
static DWORD WINAPI GetTaskmanWindow (VOID)
{
  return 0;
}


/* GetThreadDesktop ordinal = 334, argument = 4 temporary */
static DWORD WINAPI GetThreadDesktop (DWORD dwArgv0)
{
  return 0;
}


/* GetTitleBarInfo ordinal = 335, argument = 8 temporary */
static DWORD WINAPI GetTitleBarInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTopWindow ordinal = 336, argument = 4 temporary */
static DWORD WINAPI GetTopWindow (DWORD dwArgv0)
{
  return 0;
}


/* GetUpdateRect ordinal = 337, argument = 12 temporary */
static DWORD WINAPI GetUpdateRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetUpdateRgn ordinal = 338, argument = 12 temporary */
static DWORD WINAPI GetUpdateRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetUserObjectInformationA ordinal = 339, argument = 20 temporary */
static DWORD WINAPI GetUserObjectInformationA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetUserObjectInformationW ordinal = 340, argument = 20 temporary */
static DWORD WINAPI GetUserObjectInformationW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetUserObjectSecurity ordinal = 341, argument = 20 temporary */
static DWORD WINAPI GetUserObjectSecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetWinStationInfo ordinal = 342, argument = 0 temporary */
static DWORD WINAPI GetWinStationInfo (VOID)
{
  return 0;
}


/* GetWindow ordinal = 343, argument = 8 temporary */
static DWORD WINAPI GetWindow (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWindowContextHelpId ordinal = 344, argument = 4 temporary */
static DWORD WINAPI GetWindowContextHelpId (DWORD dwArgv0)
{
  return 0;
}


/* GetWindowDC ordinal = 345, argument = 4 temporary */
static DWORD WINAPI GetWindowDC (DWORD dwArgv0)
{
  return 0;
}


/* GetWindowInfo ordinal = 346, argument = 8 temporary */
static DWORD WINAPI GetWindowInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWindowLongA ordinal = 347, argument = 8 */
LONG WINAPI GetWindowLongA (HWND hWnd, INT nIndex)
{
  W32LdrWndExtraData *wed;

  wed = g_object_get_data (G_OBJECT (hWnd), "user_data");
  if (wed)
    switch (nIndex)
      {
        case GWL_USERDATA:  return wed->dwUserData;
        case GWL_EXSTYLE:   return wed->dwExStyle;
        case GWL_STYLE:     return wed->dwStyle;
        case GWL_ID:        return wed->wID;
        case GWL_HWNDPARENT:return (LONG)wed->hWndParent;
        case GWL_HINSTANCE: return (LONG)wed->hInstance;
        case GWL_WNDPROC:   return (LONG)wed->lpfnWndProc;
        case DWL_MSGRESULT: return wed->lResult;
        case DWL_DLGPROC:   return (LONG)wed->lpDialogFunc;
        case DWL_USER:      return wed->dwUser;
    }
  return 0;
}


/* GetWindowLongW ordinal = 348, argument = 8 */
LONG WINAPI GetWindowLongW (HWND hWnd, INT nIndex)
{
  return GetWindowLongA (hWnd, nIndex);
}


/* GetWindowModuleFileName ordinal = 349, argument = 12 temporary */
/* DWORD WINAPI GetWindowModuleFileName (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2) */


/* GetWindowModuleFileNameA ordinal = 350, argument = 12 temporary */
static DWORD WINAPI GetWindowModuleFileNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetWindowModuleFileNameW ordinal = 351, argument = 12 temporary */
static DWORD WINAPI GetWindowModuleFileNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetWindowPlacement ordinal = 352, argument = 8 temporary */
static DWORD WINAPI GetWindowPlacement (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWindowRect ordinal = 353, argument = 8 */
BOOL WINAPI GetWindowRect (HWND hWnd, LPRECT lpRect)
{
  gint x, y, width, height;

  if (!hWnd)
    return FALSE;
  gdk_window_get_root_origin (GTK_WIDGET (hWnd)->window, &x, &y);
  gdk_window_get_size (GTK_WIDGET (hWnd)->window, &width, &height);
  lpRect->left = x;
  lpRect->top = y;
  lpRect->right = x + width;
  lpRect->bottom = y + height;
  return TRUE;
}


/* GetWindowRgn ordinal = 354, argument = 8 temporary */
static DWORD WINAPI GetWindowRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWindowTextA ordinal = 355, argument = 12 */
INT WINAPI GetWindowTextA (HWND hWnd, LPSTR lpString, INT nMaxCount)
{
  return SendMessageA (hWnd, WM_GETTEXT,
                                        nMaxCount, GPOINTER_TO_INT (lpString));
}


/* GetWindowTextLengthA ordinal = 356, argument = 4 temporary */
static DWORD WINAPI GetWindowTextLengthA (DWORD dwArgv0)
{
  return 0;
}


/* GetWindowTextLengthW ordinal = 357, argument = 4 temporary */
static DWORD WINAPI GetWindowTextLengthW (DWORD dwArgv0)
{
  return 0;
}


/* GetWindowTextW ordinal = 358, argument = 12 */
INT WINAPI GetWindowTextW (HWND hWnd, LPWSTR lpString, INT nMaxCount)
{
  return SendMessageW (hWnd, WM_GETTEXT,
                                        nMaxCount, GPOINTER_TO_INT (lpString));
}


/* GetWindowThreadProcessId ordinal = 359, argument = 8 temporary */
static DWORD WINAPI GetWindowThreadProcessId (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWindowWord ordinal = 360, argument = 8 temporary */
static DWORD WINAPI GetWindowWord (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GrayStringA ordinal = 361, argument = 36 temporary */
static DWORD WINAPI GrayStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* GrayStringW ordinal = 362, argument = 36 temporary */
static DWORD WINAPI GrayStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* HideCaret ordinal = 363, argument = 4 temporary */
static DWORD WINAPI HideCaret (DWORD dwArgv0)
{
  return 0;
}


/* HiliteMenuItem ordinal = 364, argument = 16 temporary */
static DWORD WINAPI HiliteMenuItem (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* IMPGetIMEA ordinal = 365, argument = 8 temporary */
static DWORD WINAPI IMPGetIMEA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IMPGetIMEW ordinal = 366, argument = 8 temporary */
static DWORD WINAPI IMPGetIMEW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IMPQueryIMEA ordinal = 367, argument = 4 temporary */
static DWORD WINAPI IMPQueryIMEA (DWORD dwArgv0)
{
  return 0;
}


/* IMPQueryIMEW ordinal = 368, argument = 4 temporary */
static DWORD WINAPI IMPQueryIMEW (DWORD dwArgv0)
{
  return 0;
}


/* IMPSetIMEA ordinal = 369, argument = 8 temporary */
static DWORD WINAPI IMPSetIMEA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IMPSetIMEW ordinal = 370, argument = 8 temporary */
static DWORD WINAPI IMPSetIMEW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ImpersonateDdeClientWindow ordinal = 371, argument = 8 temporary */
static DWORD WINAPI ImpersonateDdeClientWindow (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* InSendMessage ordinal = 372, argument = 0 temporary */
static DWORD WINAPI InSendMessage (VOID)
{
  return 0;
}


/* InSendMessageEx ordinal = 373, argument = 4 temporary */
static DWORD WINAPI InSendMessageEx (DWORD dwArgv0)
{
  return 0;
}


/* InflateRect ordinal = 374, argument = 12 temporary */
static DWORD WINAPI InflateRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* InitializeLpkHooks ordinal = 375, argument = 0 temporary */
static DWORD WINAPI InitializeLpkHooks (VOID)
{
  return 0;
}


/* InitializeWin32EntryTable ordinal = 376, argument = 0 temporary */
static DWORD WINAPI InitializeWin32EntryTable (VOID)
{
  return 0;
}


/* InsertMenuA ordinal = 377, argument = 20 temporary */
static DWORD WINAPI InsertMenuA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* InsertMenuItemA ordinal = 378, argument = 16 temporary */
static DWORD WINAPI InsertMenuItemA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* InsertMenuItemW ordinal = 379, argument = 16 temporary */
static DWORD WINAPI InsertMenuItemW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* InsertMenuW ordinal = 380, argument = 20 temporary */
static DWORD WINAPI InsertMenuW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* InternalGetWindowText ordinal = 381, argument = 12 temporary */
static DWORD WINAPI InternalGetWindowText (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* IntersectRect ordinal = 382, argument = 12 temporary */
static DWORD WINAPI IntersectRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* InvalidateRect ordinal = 383, argument = 12 */
BOOL WINAPI InvalidateRect (HWND hWnd, CONST RECT *lpRect, BOOL bErase)
{
  if (!hWnd)
    return FALSE;
  if (lpRect)
    {
      GdkRectangle rc;

      rc.x = lpRect->left;
      rc.y = lpRect->top;
      rc.width = lpRect->right - lpRect->left;
      rc.height = lpRect->bottom - lpRect->top;
      gtk_widget_draw (GTK_WIDGET (hWnd), &rc);
    }
  else
    {
      gtk_widget_draw (GTK_WIDGET (hWnd), NULL);
    }
  return TRUE;
}


/* InvalidateRgn ordinal = 384, argument = 12 temporary */
static DWORD WINAPI InvalidateRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* InvertRect ordinal = 385, argument = 8 temporary */
static DWORD WINAPI InvertRect (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsCharAlphaA ordinal = 386, argument = 4 temporary */
static DWORD WINAPI IsCharAlphaA (DWORD dwArgv0)
{
  return 0;
}


/* IsCharAlphaNumericA ordinal = 387, argument = 4 temporary */
static DWORD WINAPI IsCharAlphaNumericA (DWORD dwArgv0)
{
  return 0;
}


/* IsCharAlphaNumericW ordinal = 388, argument = 4 temporary */
static DWORD WINAPI IsCharAlphaNumericW (DWORD dwArgv0)
{
  return 0;
}


/* IsCharAlphaW ordinal = 389, argument = 4 temporary */
static DWORD WINAPI IsCharAlphaW (DWORD dwArgv0)
{
  return 0;
}


/* IsCharLowerA ordinal = 390, argument = 4 temporary */
static DWORD WINAPI IsCharLowerA (DWORD dwArgv0)
{
  return 0;
}


/* IsCharLowerW ordinal = 391, argument = 4 temporary */
static DWORD WINAPI IsCharLowerW (DWORD dwArgv0)
{
  return 0;
}


/* IsCharUpperA ordinal = 392, argument = 4 temporary */
static DWORD WINAPI IsCharUpperA (DWORD dwArgv0)
{
  return 0;
}


/* IsCharUpperW ordinal = 393, argument = 4 temporary */
static DWORD WINAPI IsCharUpperW (DWORD dwArgv0)
{
  return 0;
}


/* IsChild ordinal = 394, argument = 8 temporary */
static DWORD WINAPI IsChild (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsClipboardFormatAvailable ordinal = 395, argument = 4 temporary */
static DWORD WINAPI IsClipboardFormatAvailable (DWORD dwArgv0)
{
  return 0;
}


/* IsDialogMessage ordinal = 396, argument = 8 temporary */
/* DWORD WINAPI IsDialogMessage (DWORD dwArgv0, DWORD dwArgv1) */


/* IsDialogMessageA ordinal = 397, argument = 8 temporary */
static DWORD WINAPI IsDialogMessageA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsDialogMessageW ordinal = 398, argument = 8 temporary */
static DWORD WINAPI IsDialogMessageW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsDlgButtonChecked ordinal = 399, argument = 8 */
UINT WINAPI IsDlgButtonChecked (HWND hDlg, INT nIDButton)
{
  return SendDlgItemMessage (hDlg, nIDButton, BM_GETCHECK, 0, 0);
}


/* IsHungAppWindow ordinal = 400, argument = 4 temporary */
static DWORD WINAPI IsHungAppWindow (DWORD dwArgv0)
{
  return 0;
}


/* IsIconic ordinal = 401, argument = 4 temporary */
static DWORD WINAPI IsIconic (DWORD dwArgv0)
{
  return 0;
}


/* IsMenu ordinal = 402, argument = 4 temporary */
static DWORD WINAPI IsMenu (DWORD dwArgv0)
{
  return 0;
}


/* IsRectEmpty ordinal = 403, argument = 4 */
BOOL WINAPI IsRectEmpty (CONST RECT *lprc)
{
  return lprc->left < lprc->right && lprc->top < lprc->bottom;
}


/* IsWindow ordinal = 404, argument = 4 temporary */
static DWORD WINAPI IsWindow (DWORD dwArgv0)
{
  return 0;
}


/* IsWindowEnabled ordinal = 405, argument = 4 temporary */
static DWORD WINAPI IsWindowEnabled (DWORD dwArgv0)
{
  return 0;
}


/* IsWindowUnicode ordinal = 406, argument = 4 temporary */
static DWORD WINAPI IsWindowUnicode (DWORD dwArgv0)
{
  return 0;
}


/* IsWindowVisible ordinal = 407, argument = 4 temporary */
static DWORD WINAPI IsWindowVisible (DWORD dwArgv0)
{
  return 0;
}


/* IsZoomed ordinal = 408, argument = 4 temporary */
static DWORD WINAPI IsZoomed (DWORD dwArgv0)
{
  return 0;
}


/* KillSystemTimer ordinal = 409, argument = 0 temporary */
static DWORD WINAPI KillSystemTimer (VOID)
{
  return 0;
}


/* KillTimer ordinal = 410, argument = 8 temporary */
static DWORD WINAPI KillTimer (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadAcceleratorsA ordinal = 411, argument = 8 temporary */
static DWORD WINAPI LoadAcceleratorsA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadAcceleratorsW ordinal = 412, argument = 8 temporary */
static DWORD WINAPI LoadAcceleratorsW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadBitmapA ordinal = 413, argument = 8 */
HBITMAP WINAPI LoadBitmapA (HINSTANCE hInstance, LPCSTR lpBitmapName)
{
  BitmapInfoHeader *bmih;
  HRSRC hRsrc;

  return (hRsrc = FindResourceA (hInstance,lpBitmapName,
                                                MAKEINTRESOURCEA (RT_BITMAP)))
                                    && (bmih = LoadResource (hInstance, hRsrc))
                                            ? pixbuf_from_bitmap (bmih) : NULL;
}


/* LoadBitmapW ordinal = 414, argument = 8 */
HBITMAP WINAPI LoadBitmapW (HINSTANCE hInstance, LPCWSTR lpBitmapName)
{
  BitmapInfoHeader *bmih;
  HRSRC hRsrc;

  return (hRsrc = FindResourceW (hInstance,lpBitmapName,
                                                MAKEINTRESOURCEW (RT_BITMAP)))
                                    && (bmih = LoadResource (hInstance, hRsrc))
                                            ? pixbuf_from_bitmap (bmih) : NULL;
}


/* LoadCursorA ordinal = 415, argument = 8 temporary */
static DWORD WINAPI LoadCursorA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadCursorFromFileA ordinal = 416, argument = 4 temporary */
static DWORD WINAPI LoadCursorFromFileA (DWORD dwArgv0)
{
  return 0;
}


/* LoadCursorFromFileW ordinal = 417, argument = 4 temporary */
static DWORD WINAPI LoadCursorFromFileW (DWORD dwArgv0)
{
  return 0;
}


/* LoadCursorW ordinal = 418, argument = 8 temporary */
static DWORD WINAPI LoadCursorW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadIconA ordinal = 419, argument = 8 temporary */
static DWORD WINAPI LoadIconA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadIconW ordinal = 420, argument = 8 temporary */
static DWORD WINAPI LoadIconW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadImageA ordinal = 421, argument = 24 temporary */
static DWORD WINAPI LoadImageA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* LoadImageW ordinal = 422, argument = 24 temporary */
static DWORD WINAPI LoadImageW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* LoadKeyboardLayoutA ordinal = 423, argument = 8 temporary */
static DWORD WINAPI LoadKeyboardLayoutA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadKeyboardLayoutEx ordinal = 424, argument = 0 temporary */
static DWORD WINAPI LoadKeyboardLayoutEx (VOID)
{
  return 0;
}


/* LoadKeyboardLayoutW ordinal = 425, argument = 8 temporary */
static DWORD WINAPI LoadKeyboardLayoutW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadLocalFonts ordinal = 426, argument = 0 temporary */
static DWORD WINAPI LoadLocalFonts (VOID)
{
  return 0;
}


/* LoadMenuA ordinal = 427, argument = 8 temporary */
static DWORD WINAPI LoadMenuA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadMenuIndirectA ordinal = 428, argument = 4 temporary */
static DWORD WINAPI LoadMenuIndirectA (DWORD dwArgv0)
{
  return 0;
}


/* LoadMenuIndirectW ordinal = 429, argument = 4 temporary */
static DWORD WINAPI LoadMenuIndirectW (DWORD dwArgv0)
{
  return 0;
}


/* LoadMenuW ordinal = 430, argument = 8 temporary */
static DWORD WINAPI LoadMenuW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadRemoteFonts ordinal = 431, argument = 0 temporary */
static DWORD WINAPI LoadRemoteFonts (VOID)
{
  return 0;
}


/* LoadStringA ordinal = 432, argument = 16 */
INT WINAPI LoadStringA (HINSTANCE hInstance, UINT uID, LPSTR lpBuffer, INT nBufferMax)
{
  gunichar2 *data;
  HRSRC hRsrc;

  if (!lpBuffer || nBufferMax <= 0)
    return 0;
  if ((hRsrc = FindResourceA (hInstance,
                                MAKEINTRESOURCEA (((uID >> 4) & 0xffff) + 1),
                                MAKEINTRESOURCEA (RT_STRING)))
                                && (data = LoadResource (hInstance, hRsrc)))
    {
      gsize leng;
      gint i;

      for (i = 0; i < (uID & 0x0f); i++)
        data += *data + 1;
      leng = WideCharToMultiByte (CP_ACP, 0, data + 1, *data,
                                        lpBuffer, nBufferMax - 1, NULL, NULL);
      lpBuffer[leng] = '\0';
    }

  return g_strlen (lpBuffer);
}


/* LoadStringW ordinal = 433, argument = 16 */
INT WINAPI LoadStringW (HINSTANCE hInstance, UINT uID, LPWSTR lpBuffer, INT nBufferMax)
{
  gunichar2 *data;
  HRSRC hRsrc;

  if (!lpBuffer || nBufferMax <= 0)
    return 0;
  if ((hRsrc = FindResourceW (hInstance,
                                MAKEINTRESOURCEW (((uID >> 4) & 0xffff) + 1),
                                MAKEINTRESOURCEW (RT_STRING)))
                                && (data = LoadResource (hInstance, hRsrc)))
    {
      gsize leng;
      gint i;

      for (i = 0; i < (uID & 0x0f); i++)
        data += *data + 1;
      leng = MIN (nBufferMax - 1, *data);
      g_memmove (lpBuffer, data + 1, leng * sizeof (gunichar2));
      lpBuffer[leng] = '\0';
    }

  return lstrlenW (lpBuffer);
}


/* LockSetForegroundWindow ordinal = 434, argument = 4 temporary */
static DWORD WINAPI LockSetForegroundWindow (DWORD dwArgv0)
{
  return 0;
}


/* LockWindowStation ordinal = 435, argument = 0 temporary */
static DWORD WINAPI LockWindowStation (VOID)
{
  return 0;
}


/* LockWindowUpdate ordinal = 436, argument = 4 temporary */
static DWORD WINAPI LockWindowUpdate (DWORD dwArgv0)
{
  return 0;
}


/* LockWorkStation ordinal = 437, argument = 0 temporary */
static DWORD WINAPI LockWorkStation (VOID)
{
  return 0;
}


/* LookupIconIdFromDirectory ordinal = 438, argument = 8 temporary */
static DWORD WINAPI LookupIconIdFromDirectory (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LookupIconIdFromDirectoryEx ordinal = 439, argument = 20 temporary */
static DWORD WINAPI LookupIconIdFromDirectoryEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* MBToWCSEx ordinal = 440, argument = 0 temporary */
static DWORD WINAPI MBToWCSEx (VOID)
{
  return 0;
}


/* MB_GetString ordinal = 441, argument = 0 temporary */
static DWORD WINAPI MB_GetString (VOID)
{
  return 0;
}


/* MapDialogRect ordinal = 442, argument = 8 temporary */
static DWORD WINAPI MapDialogRect (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* MapVirtualKeyA ordinal = 443, argument = 8 temporary */
static DWORD WINAPI MapVirtualKeyA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* MapVirtualKeyExA ordinal = 444, argument = 12 temporary */
static DWORD WINAPI MapVirtualKeyExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MapVirtualKeyExW ordinal = 445, argument = 12 temporary */
static DWORD WINAPI MapVirtualKeyExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MapVirtualKeyW ordinal = 446, argument = 8 temporary */
static DWORD WINAPI MapVirtualKeyW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* MapWindowPoints ordinal = 447, argument = 16 */
INT WINAPI MapWindowPoints (HWND hWndFrom, HWND hWndTo, LPPOINT lpPoints, UINT cPoints)
{
  gint i, cx, cy, dx, dy, sx, sy;

  gdk_window_get_root_origin (GTK_WIDGET (hWndFrom)->window, &sx, &sy);
  gdk_window_get_root_origin (GTK_WIDGET (hWndTo)->window, &dx, &dy);
  cx = sx - dx;
  cy = sy - dy;
  for (i = 0; i < cPoints; i++)
    {
      lpPoints[i].x += cx;
      lpPoints[i].y += cy;
    }
  return MAKELONG (cx, cy);
}


/* MenuItemFromPoint ordinal = 448, argument = 16 temporary */
static DWORD WINAPI MenuItemFromPoint (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* MenuWindowProcA ordinal = 449, argument = 0 temporary */
static DWORD WINAPI MenuWindowProcA (VOID)
{
  return 0;
}


/* MenuWindowProcW ordinal = 450, argument = 0 temporary */
static DWORD WINAPI MenuWindowProcW (VOID)
{
  return 0;
}


/* MessageBeep ordinal = 451, argument = 4 */
BOOL WINAPI MessageBeep (UINT uType)
{
  return TRUE;
}


/* MessageBoxA ordinal = 452, argument = 16 */
INT WINAPI MessageBoxA (HWND hWnd, LPCSTR lpText, LPCSTR lpCaption, UINT uType)
{
  gchar *text, *title;
  gunichar2 *wtext, *wtitle;
  INT nResult;

  text = w32ldr_utf8_from_mb (lpText);
  title = w32ldr_utf8_from_mb (lpCaption);
  wtext = g_utf8_to_utf16 (text, -1, NULL, NULL, NULL);
  wtitle = g_utf8_to_utf16 (title, -1, NULL, NULL, NULL);
  g_free (text);
  g_free (title);
  nResult = MessageBoxW (hWnd, wtext, wtitle, uType);
  g_free (wtext);
  g_free (wtitle);
  return nResult;
}


/* MessageBoxExA ordinal = 453, argument = 20 */
INT WINAPI MessageBoxExA (HWND hWnd, LPCSTR lpText, LPCSTR lpCaption, UINT uType, WORD wLanguageId)
{
  return MessageBoxA (hWnd, lpText, lpCaption, uType);
}


/* MessageBoxExW ordinal = 454, argument = 20 */
INT WINAPI MessageBoxExW (HWND hWnd, LPCWSTR lpText, LPCWSTR lpCaption, UINT uType, WORD wLanguageId)
{
  return MessageBoxW (hWnd, lpText, lpCaption, uType);
}


/* MessageBoxIndirectA ordinal = 455, argument = 4 temporary */
static DWORD WINAPI MessageBoxIndirectA (DWORD dwArgv0)
{
  return 0;
}


/* MessageBoxIndirectW ordinal = 456, argument = 4 temporary */
static DWORD WINAPI MessageBoxIndirectW (DWORD dwArgv0)
{
  return 0;
}


/* MessageBoxW ordinal = 457, argument = 16 */
INT WINAPI MessageBoxW (HWND hWnd, LPCWSTR lpText, LPCWSTR lpCaption, UINT uType)
{
  gchar *text, *title;
  gint result;
  GtkMessageType mssage;
  GtkWidget *dialog;

  text = g_utf16_to_utf8 (lpText, -1, NULL, NULL, NULL);
  title = g_utf16_to_utf8 (lpCaption, -1, NULL, NULL, NULL);
  switch (uType & MB_ICONMASK)
    {
      case MB_ICONHAND:        mssage = GTK_MESSAGE_WARNING; break;
      case MB_ICONQUESTION:    mssage = GTK_MESSAGE_QUESTION; break;
      case MB_ICONEXCLAMATION: mssage = GTK_MESSAGE_WARNING; break;
      default:                 mssage = GTK_MESSAGE_INFO;
    }
  dialog = gtk_message_dialog_new (hWnd ? GTK_WINDOW (hWnd) : NULL,
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            mssage, GTK_BUTTONS_NONE, text);
  gtk_window_set_title (GTK_WINDOW (dialog), title);
  g_free (text);
  g_free (title);

  switch (uType & MB_TYPEMASK)
    {
      case MB_ABORTRETRYIGNORE:
        gtk_dialog_add_buttons (GTK_DIALOG (dialog),
                                        "_Retry", GTK_RESPONSE_ACCEPT,
                                        "_Ignore", GTK_RESPONSE_REJECT,
                                        "_Abort", GTK_RESPONSE_CANCEL,
                                        NULL);
        break;
      case MB_OK:
        gtk_dialog_add_buttons (GTK_DIALOG (dialog),
                                        GTK_STOCK_OK, GTK_RESPONSE_OK,
                                        NULL);
        break;
      case MB_OKCANCEL:
        gtk_dialog_add_buttons (GTK_DIALOG (dialog),
                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                        GTK_STOCK_OK, GTK_RESPONSE_OK,
                                        NULL);
        break;
      case MB_RETRYCANCEL:
        gtk_dialog_add_buttons (GTK_DIALOG (dialog),
                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                        "_Retry", GTK_RESPONSE_ACCEPT,
                                        NULL);
        break;
      case MB_YESNO:
        gtk_dialog_add_buttons (GTK_DIALOG (dialog),
                                        GTK_STOCK_NO, GTK_RESPONSE_NO,
                                        GTK_STOCK_YES, GTK_RESPONSE_YES,
                                        NULL);
        break;
      case MB_YESNOCANCEL:
        gtk_dialog_add_buttons (GTK_DIALOG (dialog),
                                        GTK_STOCK_NO, GTK_RESPONSE_NO,
                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                        GTK_STOCK_YES, GTK_RESPONSE_YES,
                                        NULL);
    }
  result = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
  switch (uType & MB_TYPEMASK)
    {
      case MB_ABORTRETRYIGNORE:
        switch (result)
          {
            case  GTK_RESPONSE_ACCEPT: return IDRETRY;
            case  GTK_RESPONSE_REJECT: return IDIGNORE;
          }
        return IDABORT;
      case MB_OK:
        return IDOK;
      case MB_OKCANCEL:
        return result == GTK_RESPONSE_OK ? IDOK : IDCANCEL;
      case MB_RETRYCANCEL:
        return result == GTK_RESPONSE_ACCEPT ? IDRETRY : IDCANCEL;
      case MB_YESNO:
        return result == GTK_RESPONSE_YES ? IDYES : IDNO;
      case MB_YESNOCANCEL:
        switch (result)
          {
            case  GTK_RESPONSE_YES: return IDYES;
            case  GTK_RESPONSE_NO:  return IDNO;
          }
    }
  return IDCANCEL;
}


/* ModifyMenuA ordinal = 458, argument = 20 temporary */
static DWORD WINAPI ModifyMenuA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ModifyMenuW ordinal = 459, argument = 20 temporary */
static DWORD WINAPI ModifyMenuW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* MonitorFromPoint ordinal = 460, argument = 12 temporary */
static DWORD WINAPI MonitorFromPoint (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MonitorFromRect ordinal = 461, argument = 8 temporary */
static DWORD WINAPI MonitorFromRect (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* MonitorFromWindow ordinal = 462, argument = 8 temporary */
static DWORD WINAPI MonitorFromWindow (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* MoveWindow ordinal = 463, argument = 24 */
BOOL WINAPI MoveWindow (HWND hWnd, INT X, INT Y, INT nWidth, INT nHeight, BOOL bRepaint)
{
  return FALSE;
}


/* MsgWaitForMultipleObjects ordinal = 464, argument = 20 temporary */
static DWORD WINAPI MsgWaitForMultipleObjects (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* MsgWaitForMultipleObjectsEx ordinal = 465, argument = 20 temporary */
static DWORD WINAPI MsgWaitForMultipleObjectsEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* NotifyWinEvent ordinal = 466, argument = 16 temporary */
static DWORD WINAPI NotifyWinEvent (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* OemKeyScan ordinal = 467, argument = 4 temporary */
static DWORD WINAPI OemKeyScan (DWORD dwArgv0)
{
  return 0;
}


/* OemToCharA ordinal = 468, argument = 8 temporary */
static DWORD WINAPI OemToCharA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* OemToCharBuffA ordinal = 469, argument = 12 temporary */
static DWORD WINAPI OemToCharBuffA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OemToCharBuffW ordinal = 470, argument = 12 temporary */
static DWORD WINAPI OemToCharBuffW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OemToCharW ordinal = 471, argument = 8 temporary */
static DWORD WINAPI OemToCharW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* OffsetRect ordinal = 472, argument = 12 */
BOOL WINAPI OffsetRect (LPRECT lprc, INT dx, INT dy)
{
  lprc->left += dx;
  lprc->top += dy;
  lprc->right += dx;
  lprc->bottom += dy;
  return TRUE;
}


/* OpenClipboard ordinal = 473, argument = 4 temporary */
static DWORD WINAPI OpenClipboard (DWORD dwArgv0)
{
  return 0;
}


/* OpenDesktopA ordinal = 474, argument = 16 temporary */
static DWORD WINAPI OpenDesktopA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* OpenDesktopW ordinal = 475, argument = 16 temporary */
static DWORD WINAPI OpenDesktopW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* OpenIcon ordinal = 476, argument = 4 temporary */
static DWORD WINAPI OpenIcon (DWORD dwArgv0)
{
  return 0;
}


/* OpenInputDesktop ordinal = 477, argument = 12 temporary */
static DWORD WINAPI OpenInputDesktop (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenWindowStationA ordinal = 478, argument = 12 temporary */
static DWORD WINAPI OpenWindowStationA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenWindowStationW ordinal = 479, argument = 12 temporary */
static DWORD WINAPI OpenWindowStationW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PackDDElParam ordinal = 480, argument = 12 temporary */
static DWORD WINAPI PackDDElParam (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PaintDesktop ordinal = 481, argument = 4 temporary */
static DWORD WINAPI PaintDesktop (DWORD dwArgv0)
{
  return 0;
}


/* PeekMessageA ordinal = 482, argument = 20 temporary */
static DWORD WINAPI PeekMessageA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* PeekMessageW ordinal = 483, argument = 20 temporary */
static DWORD WINAPI PeekMessageW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* PostMessageA ordinal = 484, argument = 16 temporary */
static DWORD WINAPI PostMessageA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PostMessageW ordinal = 485, argument = 16 temporary */
static DWORD WINAPI PostMessageW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PostQuitMessage ordinal = 486, argument = 4 temporary */
static DWORD WINAPI PostQuitMessage (DWORD dwArgv0)
{
  return 0;
}


/* PostThreadMessageA ordinal = 487, argument = 16 temporary */
static DWORD WINAPI PostThreadMessageA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PostThreadMessageW ordinal = 488, argument = 16 temporary */
static DWORD WINAPI PostThreadMessageW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PrivateExtractIconExA ordinal = 489, argument = 0 temporary */
static DWORD WINAPI PrivateExtractIconExA (VOID)
{
  return 0;
}


/* PrivateExtractIconExW ordinal = 490, argument = 0 temporary */
static DWORD WINAPI PrivateExtractIconExW (VOID)
{
  return 0;
}


/* PrivateExtractIconsA ordinal = 491, argument = 32 temporary */
static DWORD WINAPI PrivateExtractIconsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* PrivateExtractIconsW ordinal = 492, argument = 32 temporary */
static DWORD WINAPI PrivateExtractIconsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* PrivateSetDbgTag ordinal = 493, argument = 0 temporary */
static DWORD WINAPI PrivateSetDbgTag (VOID)
{
  return 0;
}


/* PrivateSetRipFlags ordinal = 494, argument = 0 temporary */
static DWORD WINAPI PrivateSetRipFlags (VOID)
{
  return 0;
}


/* PtInRect ordinal = 495, argument = 12 temporary */
static DWORD WINAPI PtInRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QuerySendMessage ordinal = 496, argument = 0 temporary */
static DWORD WINAPI QuerySendMessage (VOID)
{
  return 0;
}


/* QueryUserCounters ordinal = 497, argument = 0 temporary */
static DWORD WINAPI QueryUserCounters (VOID)
{
  return 0;
}


/* RealChildWindowFromPoint ordinal = 498, argument = 12 temporary */
static DWORD WINAPI RealChildWindowFromPoint (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RealGetWindowClass ordinal = 499, argument = 12 temporary */
/* DWORD WINAPI RealGetWindowClass (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2) */


/* RealGetWindowClassA ordinal = 500, argument = 12 temporary */
static DWORD WINAPI RealGetWindowClassA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RealGetWindowClassW ordinal = 501, argument = 12 temporary */
static DWORD WINAPI RealGetWindowClassW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RedrawWindow ordinal = 502, argument = 16 temporary */
static DWORD WINAPI RedrawWindow (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RegisterClassA ordinal = 503, argument = 4 temporary */
static DWORD WINAPI RegisterClassA (DWORD dwArgv0)
{
  return 0;
}


/* RegisterClassExA ordinal = 504, argument = 4 temporary */
static DWORD WINAPI RegisterClassExA (DWORD dwArgv0)
{
  return 0;
}


/* RegisterClassExW ordinal = 505, argument = 4 temporary */
static DWORD WINAPI RegisterClassExW (DWORD dwArgv0)
{
  return 0;
}


/* RegisterClassW ordinal = 506, argument = 4 temporary */
static DWORD WINAPI RegisterClassW (DWORD dwArgv0)
{
  return 0;
}


/* RegisterClipboardFormatA ordinal = 507, argument = 4 temporary */
static DWORD WINAPI RegisterClipboardFormatA (DWORD dwArgv0)
{
  return 0;
}


/* RegisterClipboardFormatW ordinal = 508, argument = 4 temporary */
static DWORD WINAPI RegisterClipboardFormatW (DWORD dwArgv0)
{
  return 0;
}


/* RegisterDeviceNotificationA ordinal = 509, argument = 12 temporary */
static DWORD WINAPI RegisterDeviceNotificationA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RegisterDeviceNotificationW ordinal = 510, argument = 12 temporary */
static DWORD WINAPI RegisterDeviceNotificationW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RegisterHotKey ordinal = 511, argument = 16 temporary */
static DWORD WINAPI RegisterHotKey (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RegisterLogonProcess ordinal = 512, argument = 0 temporary */
static DWORD WINAPI RegisterLogonProcess (VOID)
{
  return 0;
}


/* RegisterServicesProcess ordinal = 513, argument = 0 temporary */
static DWORD WINAPI RegisterServicesProcess (VOID)
{
  return 0;
}


/* RegisterShellHookWindow ordinal = 514, argument = 4 temporary */
static DWORD WINAPI RegisterShellHookWindow (DWORD dwArgv0)
{
  return 0;
}


/* RegisterSystemThread ordinal = 515, argument = 0 temporary */
static DWORD WINAPI RegisterSystemThread (VOID)
{
  return 0;
}


/* RegisterTasklist ordinal = 516, argument = 0 temporary */
static DWORD WINAPI RegisterTasklist (VOID)
{
  return 0;
}


/* RegisterWindowMessageA ordinal = 517, argument = 4 temporary */
static DWORD WINAPI RegisterWindowMessageA (DWORD dwArgv0)
{
  return 0;
}


/* RegisterWindowMessageW ordinal = 518, argument = 4 temporary */
static DWORD WINAPI RegisterWindowMessageW (DWORD dwArgv0)
{
  return 0;
}


/* ReleaseCapture ordinal = 519, argument = 0 temporary */
static DWORD WINAPI ReleaseCapture (VOID)
{
  return 0;
}


/* ReleaseDC ordinal = 520, argument = 8 */
INT WINAPI ReleaseDC (HWND hWnd, HDC hDC)
{
  return 0;
}


/* RemoveMenu ordinal = 521, argument = 12 temporary */
static DWORD WINAPI RemoveMenu (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RemovePropA ordinal = 522, argument = 8 temporary */
static DWORD WINAPI RemovePropA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RemovePropW ordinal = 523, argument = 8 temporary */
static DWORD WINAPI RemovePropW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ReplyMessage ordinal = 524, argument = 4 temporary */
static DWORD WINAPI ReplyMessage (DWORD dwArgv0)
{
  return 0;
}


/* ResolveDesktopForWOW ordinal = 525, argument = 0 temporary */
static DWORD WINAPI ResolveDesktopForWOW (VOID)
{
  return 0;
}


/* ReuseDDElParam ordinal = 526, argument = 20 temporary */
static DWORD WINAPI ReuseDDElParam (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ScreenToClient ordinal = 527, argument = 8 */
BOOL WINAPI ScreenToClient (HWND hWnd, LPPOINT lpPoint)
{
  return FALSE;
}


/* ScrollChildren ordinal = 528, argument = 0 temporary */
static DWORD WINAPI ScrollChildren (VOID)
{
  return 0;
}


/* ScrollDC ordinal = 529, argument = 28 temporary */
static DWORD WINAPI ScrollDC (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* ScrollWindow ordinal = 530, argument = 20 temporary */
static DWORD WINAPI ScrollWindow (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ScrollWindowEx ordinal = 531, argument = 32 temporary */
static DWORD WINAPI ScrollWindowEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* SendDlgItemMessageA ordinal = 532, argument = 20 */
LONG WINAPI SendDlgItemMessageA (HWND hDlg, INT nIDDlgItem, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  return SendMessageA (GetDlgItem (hDlg, nIDDlgItem), Msg, wParam, lParam);
}


/* SendDlgItemMessageW ordinal = 533, argument = 20 */
LONG WINAPI SendDlgItemMessageW (HWND hDlg, INT nIDDlgItem, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  return SendMessageW (GetDlgItem (hDlg, nIDDlgItem), Msg, wParam, lParam);
}


/* SendIMEMessageExA ordinal = 534, argument = 8 temporary */
static DWORD WINAPI SendIMEMessageExA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SendIMEMessageExW ordinal = 535, argument = 8 temporary */
static DWORD WINAPI SendIMEMessageExW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SendInput ordinal = 536, argument = 12 temporary */
static DWORD WINAPI SendInput (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SendMessageA ordinal = 537, argument = 16 */
LRESULT WINAPI SendMessageA (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  return hWnd ? ((W32LdrWndExtraData *)g_object_get_data (G_OBJECT (hWnd),
                    "user_data"))->lpfnWndProc (hWnd, Msg, wParam, lParam) : 0;
}


/* SendMessageCallbackA ordinal = 538, argument = 24 temporary */
static DWORD WINAPI SendMessageCallbackA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SendMessageCallbackW ordinal = 539, argument = 24 temporary */
static DWORD WINAPI SendMessageCallbackW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SendMessageTimeoutA ordinal = 540, argument = 28 temporary */
static DWORD WINAPI SendMessageTimeoutA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* SendMessageTimeoutW ordinal = 541, argument = 28 temporary */
static DWORD WINAPI SendMessageTimeoutW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* SendMessageW ordinal = 542, argument = 16 */
LRESULT WINAPI SendMessageW (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  return SendMessageA (hWnd, Msg, wParam, lParam);
}


/* SendNotifyMessageA ordinal = 543, argument = 16 temporary */
static DWORD WINAPI SendNotifyMessageA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SendNotifyMessageW ordinal = 544, argument = 16 temporary */
static DWORD WINAPI SendNotifyMessageW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetActiveWindow ordinal = 545, argument = 4 temporary */
static DWORD WINAPI SetActiveWindow (DWORD dwArgv0)
{
  return 0;
}


/* SetCapture ordinal = 546, argument = 4 temporary */
static DWORD WINAPI SetCapture (DWORD dwArgv0)
{
  return 0;
}


/* SetCaretBlinkTime ordinal = 547, argument = 4 temporary */
static DWORD WINAPI SetCaretBlinkTime (DWORD dwArgv0)
{
  return 0;
}


/* SetCaretPos ordinal = 548, argument = 8 temporary */
static DWORD WINAPI SetCaretPos (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetClassLongA ordinal = 549, argument = 12 temporary */
static DWORD WINAPI SetClassLongA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetClassLongW ordinal = 550, argument = 12 temporary */
static DWORD WINAPI SetClassLongW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetClassWord ordinal = 551, argument = 12 temporary */
static DWORD WINAPI SetClassWord (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetClipboardData ordinal = 552, argument = 8 temporary */
static DWORD WINAPI SetClipboardData (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetClipboardViewer ordinal = 553, argument = 4 temporary */
static DWORD WINAPI SetClipboardViewer (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleReserveKeys ordinal = 554, argument = 0 temporary */
static DWORD WINAPI SetConsoleReserveKeys (VOID)
{
  return 0;
}


/* SetCursor ordinal = 555, argument = 4 temporary */
static DWORD WINAPI SetCursor (DWORD dwArgv0)
{
  return 0;
}


/* SetCursorContents ordinal = 556, argument = 0 temporary */
static DWORD WINAPI SetCursorContents (VOID)
{
  return 0;
}


/* SetCursorPos ordinal = 557, argument = 8 temporary */
static DWORD WINAPI SetCursorPos (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetDebugErrorLevel ordinal = 558, argument = 4 temporary */
static DWORD WINAPI SetDebugErrorLevel (DWORD dwArgv0)
{
  return 0;
}


/* SetDeskWallpaper ordinal = 559, argument = 4 temporary */
static DWORD WINAPI SetDeskWallpaper (DWORD dwArgv0)
{
  return 0;
}


/* SetDlgItemInt ordinal = 560, argument = 16 */
BOOL WINAPI SetDlgItemInt (HWND hDlg, INT nIDDlgItem, UINT uValue, BOOL bSigned)
{
  gchar *text;
  BOOL fResult;

  text = misc_str_from_val (uValue, 10, 0, bSigned);
  fResult = SendDlgItemMessage (hDlg, nIDDlgItem,
                                        WM_SETTEXT, 0, GPOINTER_TO_INT (text));
  g_free (text);
  return fResult;
}


/* SetDlgItemTextA ordinal = 561, argument = 12 temporary */
static BOOL WINAPI SetDlgItemTextA (HWND hDlg, INT nIDDlgItem, LPCSTR lpString)
{
  return SendDlgItemMessageA (hDlg, nIDDlgItem,
                                    WM_SETTEXT, 0, GPOINTER_TO_INT (lpString));
}


/* SetDlgItemTextW ordinal = 562, argument = 12 */
BOOL WINAPI SetDlgItemTextW (HWND hDlg, INT nIDDlgItem, LPCWSTR lpString)
{
  return SendDlgItemMessageA (hDlg, nIDDlgItem,
                                    WM_SETTEXT, 0, GPOINTER_TO_INT (lpString));
}


/* SetDoubleClickTime ordinal = 563, argument = 4 temporary */
static DWORD WINAPI SetDoubleClickTime (DWORD dwArgv0)
{
  return 0;
}


/* SetFocus ordinal = 564, argument = 4 */
HWND WINAPI SetFocus (HWND hWnd)
{
  gtk_widget_grab_focus (GTK_WIDGET (hWnd));
  return hWnd;
}


/* SetForegroundWindow ordinal = 565, argument = 4 temporary */
static DWORD WINAPI SetForegroundWindow (DWORD dwArgv0)
{
  return 0;
}


/* SetInternalWindowPos ordinal = 566, argument = 0 temporary */
static DWORD WINAPI SetInternalWindowPos (VOID)
{
  return 0;
}


/* SetKeyboardState ordinal = 567, argument = 4 temporary */
static DWORD WINAPI SetKeyboardState (DWORD dwArgv0)
{
  return 0;
}


/* SetLastErrorEx ordinal = 568, argument = 8 temporary */
static DWORD WINAPI SetLastErrorEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetLayeredWindowAttributes ordinal = 569, argument = 16 temporary */
static DWORD WINAPI SetLayeredWindowAttributes (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetLogonNotifyWindow ordinal = 570, argument = 0 temporary */
static DWORD WINAPI SetLogonNotifyWindow (VOID)
{
  return 0;
}


/* SetMenu ordinal = 571, argument = 8 temporary */
static DWORD WINAPI SetMenu (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMenuContextHelpId ordinal = 572, argument = 8 temporary */
static DWORD WINAPI SetMenuContextHelpId (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMenuDefaultItem ordinal = 573, argument = 12 temporary */
static DWORD WINAPI SetMenuDefaultItem (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetMenuInfo ordinal = 574, argument = 8 temporary */
static DWORD WINAPI SetMenuInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMenuItemBitmaps ordinal = 575, argument = 20 temporary */
static DWORD WINAPI SetMenuItemBitmaps (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SetMenuItemInfoA ordinal = 576, argument = 16 temporary */
static DWORD WINAPI SetMenuItemInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetMenuItemInfoW ordinal = 577, argument = 16 temporary */
static DWORD WINAPI SetMenuItemInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetMessageExtraInfo ordinal = 578, argument = 4 temporary */
static DWORD WINAPI SetMessageExtraInfo (DWORD dwArgv0)
{
  return 0;
}


/* SetMessageQueue ordinal = 579, argument = 4 temporary */
static DWORD WINAPI SetMessageQueue (DWORD dwArgv0)
{
  return 0;
}


/* SetParent ordinal = 580, argument = 8 temporary */
static DWORD WINAPI SetParent (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetProcessDefaultLayout ordinal = 581, argument = 4 temporary */
static DWORD WINAPI SetProcessDefaultLayout (DWORD dwArgv0)
{
  return 0;
}


/* SetProcessWindowStation ordinal = 582, argument = 4 temporary */
static DWORD WINAPI SetProcessWindowStation (DWORD dwArgv0)
{
  return 0;
}


/* SetProgmanWindow ordinal = 583, argument = 0 temporary */
static DWORD WINAPI SetProgmanWindow (VOID)
{
  return 0;
}


/* SetPropA ordinal = 584, argument = 12 temporary */
static DWORD WINAPI SetPropA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetPropW ordinal = 585, argument = 12 temporary */
static DWORD WINAPI SetPropW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetRect ordinal = 586, argument = 20 temporary */
static DWORD WINAPI SetRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SetRectEmpty ordinal = 587, argument = 4 temporary */
static DWORD WINAPI SetRectEmpty (DWORD dwArgv0)
{
  return 0;
}


/* SetScrollInfo ordinal = 588, argument = 16 temporary */
static DWORD WINAPI SetScrollInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetScrollPos ordinal = 589, argument = 16 */
INT WINAPI SetScrollPos (HWND hWnd, INT nBar, INT nPos, BOOL bRedraw)
{
  return nBar == SB_CTL ? SendMessage (hWnd, SBM_SETPOS, nPos, bRedraw) : 0;
}


/* SetScrollRange ordinal = 590, argument = 20 */
BOOL WINAPI SetScrollRange (HWND hWnd, INT nBar, INT nMinPos, INT nMaxPos, BOOL bRedraw)
{
  if (nBar != SB_CTL)
    return FALSE;
  SendMessage (hWnd, bRedraw ? SBM_SETRANGEREDRAW : SBM_SETRANGE,
                                                            nMinPos, nMaxPos);
  return TRUE;
}


/* SetShellWindow ordinal = 591, argument = 4 temporary */
static DWORD WINAPI SetShellWindow (DWORD dwArgv0)
{
  return 0;
}


/* SetShellWindowEx ordinal = 592, argument = 0 temporary */
static DWORD WINAPI SetShellWindowEx (VOID)
{
  return 0;
}


/* SetSysColors ordinal = 593, argument = 12 temporary */
static DWORD WINAPI SetSysColors (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetSysColorsTemp ordinal = 594, argument = 0 temporary */
static DWORD WINAPI SetSysColorsTemp (VOID)
{
  return 0;
}


/* SetSystemCursor ordinal = 595, argument = 8 temporary */
static DWORD WINAPI SetSystemCursor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetSystemMenu ordinal = 596, argument = 0 temporary */
static DWORD WINAPI SetSystemMenu (VOID)
{
  return 0;
}


/* SetSystemTimer ordinal = 597, argument = 0 temporary */
static DWORD WINAPI SetSystemTimer (VOID)
{
  return 0;
}


/* SetTaskmanWindow ordinal = 598, argument = 0 temporary */
static DWORD WINAPI SetTaskmanWindow (VOID)
{
  return 0;
}


/* SetThreadDesktop ordinal = 599, argument = 4 temporary */
static DWORD WINAPI SetThreadDesktop (DWORD dwArgv0)
{
  return 0;
}


/* SetTimer ordinal = 600, argument = 16 temporary */
static DWORD WINAPI SetTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetUserObjectInformationA ordinal = 601, argument = 16 temporary */
static DWORD WINAPI SetUserObjectInformationA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetUserObjectInformationW ordinal = 602, argument = 16 temporary */
static DWORD WINAPI SetUserObjectInformationW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetUserObjectSecurity ordinal = 603, argument = 12 temporary */
static DWORD WINAPI SetUserObjectSecurity (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetWinEventHook ordinal = 604, argument = 28 temporary */
static DWORD WINAPI SetWinEventHook (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* SetWindowContextHelpId ordinal = 605, argument = 8 temporary */
static DWORD WINAPI SetWindowContextHelpId (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetWindowLongA ordinal = 606, argument = 12 */
LONG WINAPI SetWindowLongA (HWND hWnd, INT nIndex, LONG dwNewLong)
{
  LONG lOld;
  W32LdrWndExtraData *wed;

  lOld = GetWindowLongA (hWnd, nIndex);
  wed = g_object_get_data (G_OBJECT (hWnd), "user_data");
  if (wed)
    switch (nIndex)
      {
        case GWL_USERDATA:   wed->dwUserData = dwNewLong;            break;
        case GWL_EXSTYLE:    wed->dwExStyle = dwNewLong;             break;
        case GWL_STYLE:      wed->dwStyle = dwNewLong;               break;
        case GWL_ID:         wed->wID = dwNewLong;                   break;
        case GWL_HWNDPARENT: wed->hWndParent = (HWND)dwNewLong;      break;
        case GWL_HINSTANCE:  wed->hInstance = (HINSTANCE)dwNewLong;  break;
        case GWL_WNDPROC:    wed->lpfnWndProc = (WNDPROC)dwNewLong;  break;
        case DWL_MSGRESULT:  wed->lResult = dwNewLong;               break;
        case DWL_DLGPROC:    wed->lpDialogFunc = (DLGPROC)dwNewLong; break;
        case DWL_USER:       wed->dwUser = dwNewLong;
    }
  return lOld;
}


/* SetWindowLongW ordinal = 607, argument = 12 */
LONG WINAPI SetWindowLongW (HWND hWnd, INT nIndex, LONG dwNewLong)
{
  return SetWindowLongA (hWnd, nIndex, dwNewLong);
}


/* SetWindowPlacement ordinal = 608, argument = 8 temporary */
static DWORD WINAPI SetWindowPlacement (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetWindowPos ordinal = 609, argument = 28 */
BOOL WINAPI SetWindowPos (HWND hWnd, HWND hWndInsertAfter, INT X, INT Y, INT cx, INT cy, UINT uFlags)
{
  return FALSE;
}


/* SetWindowRgn ordinal = 610, argument = 12 temporary */
static DWORD WINAPI SetWindowRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetWindowStationUser ordinal = 611, argument = 0 temporary */
static DWORD WINAPI SetWindowStationUser (VOID)
{
  return 0;
}


/* SetWindowTextA ordinal = 612, argument = 8 */
BOOL WINAPI SetWindowTextA (HWND hWnd, LPCSTR lpString)
{
  return SendMessageA (hWnd, WM_SETTEXT, 0, GPOINTER_TO_INT (lpString));
}


/* SetWindowTextW ordinal = 613, argument = 8 */
BOOL WINAPI SetWindowTextW (HWND hWnd, LPCWSTR lpString)
{
  return SendMessageW (hWnd, WM_SETTEXT, 0, GPOINTER_TO_INT (lpString));
}


/* SetWindowWord ordinal = 614, argument = 12 temporary */
static DWORD WINAPI SetWindowWord (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetWindowsHookA ordinal = 615, argument = 8 temporary */
static DWORD WINAPI SetWindowsHookA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetWindowsHookExA ordinal = 616, argument = 16 temporary */
static DWORD WINAPI SetWindowsHookExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetWindowsHookExW ordinal = 617, argument = 16 temporary */
static DWORD WINAPI SetWindowsHookExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetWindowsHookW ordinal = 618, argument = 8 temporary */
static DWORD WINAPI SetWindowsHookW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ShowCaret ordinal = 619, argument = 4 temporary */
static DWORD WINAPI ShowCaret (DWORD dwArgv0)
{
  return 0;
}


/* ShowCursor ordinal = 620, argument = 4 temporary */
static DWORD WINAPI ShowCursor (DWORD dwArgv0)
{
  return 0;
}


/* ShowOwnedPopups ordinal = 621, argument = 8 temporary */
static DWORD WINAPI ShowOwnedPopups (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ShowScrollBar ordinal = 622, argument = 12 temporary */
static DWORD WINAPI ShowScrollBar (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ShowStartGlass ordinal = 623, argument = 0 temporary */
static DWORD WINAPI ShowStartGlass (VOID)
{
  return 0;
}


/* ShowWindow ordinal = 624, argument = 8 */
BOOL WINAPI ShowWindow (HWND hWnd, INT nCmdShow)
{
  if (hWnd)
    return FALSE;
  SendMessage (hWnd, WM_SHOWWINDOW, nCmdShow != SW_HIDE, 0);
  return TRUE;
}


/* ShowWindowAsync ordinal = 625, argument = 8 temporary */
static DWORD WINAPI ShowWindowAsync (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SoftModalMessageBox ordinal = 626, argument = 0 temporary */
static DWORD WINAPI SoftModalMessageBox (VOID)
{
  return 0;
}


/* SubtractRect ordinal = 627, argument = 12 temporary */
static DWORD WINAPI SubtractRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SwapMouseButton ordinal = 628, argument = 4 temporary */
static DWORD WINAPI SwapMouseButton (DWORD dwArgv0)
{
  return 0;
}


/* SwitchDesktop ordinal = 629, argument = 4 temporary */
static DWORD WINAPI SwitchDesktop (DWORD dwArgv0)
{
  return 0;
}


/* SwitchToThisWindow ordinal = 630, argument = 8 temporary */
static DWORD WINAPI SwitchToThisWindow (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemParametersInfoA ordinal = 631, argument = 16 */
BOOL WINAPI SystemParametersInfoA (UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni)
{
  if (uiAction == SPI_GETWORKAREA && pvParam)
    {
      gint x, y, width, height, depth;
      LPRECT lprcWorkArea;

      gdk_window_get_geometry (gdk_get_default_root_window (),
                                            &x, &y, &width, &height, &depth);
      lprcWorkArea = pvParam;
      lprcWorkArea->left = x;
      lprcWorkArea->top = y;
      lprcWorkArea->right = x + width - 1;
      lprcWorkArea->bottom = y + height - 1;
      return TRUE;
    }
  return FALSE;
}


/* SystemParametersInfoW ordinal = 632, argument = 16 */
BOOL WINAPI SystemParametersInfoW (UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni)
{
  return SystemParametersInfoA (uiAction, uiParam, pvParam, fWinIni);
}


/* TabbedTextOutA ordinal = 633, argument = 32 temporary */
static DWORD WINAPI TabbedTextOutA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* TabbedTextOutW ordinal = 634, argument = 32 temporary */
static DWORD WINAPI TabbedTextOutW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* TileChildWindows ordinal = 635, argument = 8 temporary */
static DWORD WINAPI TileChildWindows (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* TileWindows ordinal = 636, argument = 20 temporary */
static DWORD WINAPI TileWindows (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ToAscii ordinal = 637, argument = 20 temporary */
static DWORD WINAPI ToAscii (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ToAsciiEx ordinal = 638, argument = 24 temporary */
static DWORD WINAPI ToAsciiEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ToUnicode ordinal = 639, argument = 24 temporary */
static DWORD WINAPI ToUnicode (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ToUnicodeEx ordinal = 640, argument = 28 temporary */
static DWORD WINAPI ToUnicodeEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* TrackMouseEvent ordinal = 641, argument = 4 temporary */
static DWORD WINAPI TrackMouseEvent (DWORD dwArgv0)
{
  return 0;
}


/* TrackPopupMenu ordinal = 642, argument = 28 temporary */
static DWORD WINAPI TrackPopupMenu (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* TrackPopupMenuEx ordinal = 643, argument = 24 temporary */
static DWORD WINAPI TrackPopupMenuEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* TranslateAccelerator ordinal = 644, argument = 12 temporary */
/* DWORD WINAPI TranslateAccelerator (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2) */


/* TranslateAcceleratorA ordinal = 645, argument = 12 temporary */
static DWORD WINAPI TranslateAcceleratorA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* TranslateAcceleratorW ordinal = 646, argument = 12 temporary */
static DWORD WINAPI TranslateAcceleratorW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* TranslateMDISysAccel ordinal = 647, argument = 8 temporary */
static DWORD WINAPI TranslateMDISysAccel (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* TranslateMessage ordinal = 648, argument = 4 temporary */
static DWORD WINAPI TranslateMessage (DWORD dwArgv0)
{
  return 0;
}


/* TranslateMessageEx ordinal = 649, argument = 0 temporary */
static DWORD WINAPI TranslateMessageEx (VOID)
{
  return 0;
}


/* UnhookWinEvent ordinal = 650, argument = 4 temporary */
static DWORD WINAPI UnhookWinEvent (DWORD dwArgv0)
{
  return 0;
}


/* UnhookWindowsHook ordinal = 651, argument = 8 temporary */
static DWORD WINAPI UnhookWindowsHook (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* UnhookWindowsHookEx ordinal = 652, argument = 4 temporary */
static DWORD WINAPI UnhookWindowsHookEx (DWORD dwArgv0)
{
  return 0;
}


/* UnionRect ordinal = 653, argument = 12 temporary */
static DWORD WINAPI UnionRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* UnloadKeyboardLayout ordinal = 654, argument = 4 temporary */
static DWORD WINAPI UnloadKeyboardLayout (DWORD dwArgv0)
{
  return 0;
}


/* UnlockWindowStation ordinal = 655, argument = 0 temporary */
static DWORD WINAPI UnlockWindowStation (VOID)
{
  return 0;
}


/* UnpackDDElParam ordinal = 656, argument = 16 temporary */
static DWORD WINAPI UnpackDDElParam (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* UnregisterClassA ordinal = 657, argument = 8 temporary */
static DWORD WINAPI UnregisterClassA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* UnregisterClassW ordinal = 658, argument = 8 temporary */
static DWORD WINAPI UnregisterClassW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* UnregisterDeviceNotification ordinal = 659, argument = 4 temporary */
static DWORD WINAPI UnregisterDeviceNotification (DWORD dwArgv0)
{
  return 0;
}


/* UnregisterHotKey ordinal = 660, argument = 8 temporary */
static DWORD WINAPI UnregisterHotKey (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* UpdateLayeredWindow ordinal = 661, argument = 36 temporary */
static DWORD WINAPI UpdateLayeredWindow (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* UpdatePerUserSystemParameters ordinal = 662, argument = 0 temporary */
static DWORD WINAPI UpdatePerUserSystemParameters (VOID)
{
  return 0;
}


/* UpdateWindow ordinal = 663, argument = 4 temporary */
static DWORD WINAPI UpdateWindow (DWORD dwArgv0)
{
  return 0;
}


/* User32InitializeImmEntryTable ordinal = 664, argument = 0 temporary */
static DWORD WINAPI User32InitializeImmEntryTable (VOID)
{
  return 0;
}


/* UserClientDllInitialize ordinal = 665, argument = 0 temporary */
static DWORD WINAPI UserClientDllInitialize (VOID)
{
  return 0;
}


/* UserHandleGrantAccess ordinal = 666, argument = 12 temporary */
static DWORD WINAPI UserHandleGrantAccess (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* UserLpkPSMTextOut ordinal = 667, argument = 0 temporary */
static DWORD WINAPI UserLpkPSMTextOut (VOID)
{
  return 0;
}


/* UserLpkTabbedTextOut ordinal = 668, argument = 0 temporary */
static DWORD WINAPI UserLpkTabbedTextOut (VOID)
{
  return 0;
}


/* UserRealizePalette ordinal = 669, argument = 0 temporary */
static DWORD WINAPI UserRealizePalette (VOID)
{
  return 0;
}


/* UserRegisterWowHandlers ordinal = 670, argument = 0 temporary */
static DWORD WINAPI UserRegisterWowHandlers (VOID)
{
  return 0;
}


/* VRipOutput ordinal = 671, argument = 0 temporary */
static DWORD WINAPI VRipOutput (VOID)
{
  return 0;
}


/* VTagOutput ordinal = 672, argument = 0 temporary */
static DWORD WINAPI VTagOutput (VOID)
{
  return 0;
}


/* ValidateRect ordinal = 673, argument = 8 temporary */
static DWORD WINAPI ValidateRect (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ValidateRgn ordinal = 674, argument = 8 temporary */
static DWORD WINAPI ValidateRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* VkKeyScanA ordinal = 675, argument = 4 temporary */
static DWORD WINAPI VkKeyScanA (DWORD dwArgv0)
{
  return 0;
}


/* VkKeyScanExA ordinal = 676, argument = 8 temporary */
static DWORD WINAPI VkKeyScanExA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* VkKeyScanExW ordinal = 677, argument = 8 temporary */
static DWORD WINAPI VkKeyScanExW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* VkKeyScanW ordinal = 678, argument = 4 temporary */
static DWORD WINAPI VkKeyScanW (DWORD dwArgv0)
{
  return 0;
}


/* WCSToMBEx ordinal = 679, argument = 0 temporary */
static DWORD WINAPI WCSToMBEx (VOID)
{
  return 0;
}


/* WINNLSEnableIME ordinal = 680, argument = 8 temporary */
static DWORD WINAPI WINNLSEnableIME (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WINNLSGetEnableStatus ordinal = 681, argument = 4 temporary */
static DWORD WINAPI WINNLSGetEnableStatus (DWORD dwArgv0)
{
  return 0;
}


/* WINNLSGetIMEHotkey ordinal = 682, argument = 4 temporary */
static DWORD WINAPI WINNLSGetIMEHotkey (DWORD dwArgv0)
{
  return 0;
}


/* WaitForInputIdle ordinal = 683, argument = 8 temporary */
static DWORD WINAPI WaitForInputIdle (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WaitMessage ordinal = 684, argument = 0 temporary */
static DWORD WINAPI WaitMessage (VOID)
{
  return 0;
}


/* Win32PoolAllocationStats ordinal = 685, argument = 0 temporary */
static DWORD WINAPI Win32PoolAllocationStats (VOID)
{
  return 0;
}


/* WinHelpA ordinal = 686, argument = 16 */
BOOL WINAPI WinHelpA (HWND hWndMain, LPCSTR lpszHelp, UINT uCommand, DWORD dwData)
{
  return FALSE;
}


/* WinHelpW ordinal = 687, argument = 16 */
BOOL WINAPI WinHelpW (HWND hWndMain, LPCWSTR lpszHelp, UINT uCommand, DWORD dwData)
{
  return FALSE;
}


/* WindowFromDC ordinal = 688, argument = 4 temporary */
static DWORD WINAPI WindowFromDC (DWORD dwArgv0)
{
  return 0;
}


/* WindowFromPoint ordinal = 689, argument = 8 temporary */
static DWORD WINAPI WindowFromPoint (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* keybd_event ordinal = 690, argument = 16 temporary */
static DWORD WINAPI keybd_event (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mouse_event ordinal = 691, argument = 20 temporary */
static DWORD WINAPI mouse_event (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* wsprintfA ordinal = 692, argument = 0 */
INT WINAPIV wsprintfA (LPSTR lpOutput, LPCSTR lpFormat, ...)
{
#if GLIB_CHECK_VERSION(2,2,0) || defined (HAVE_VPRINTF)
  va_list arglist;

  va_start (arglist, lpFormat);
# if GLIB_CHECK_VERSION(2,2,0)
  g_vsprintf (lpOutput, lpFormat, arglist);
# else /* not GLIB_CHECK_VERSION(2,2,0) */
  vsprintf (lpOutput, lpFormat, arglist);
# endif /* not GLIB_CHECK_VERSION(2,2,0) */
  va_end (arglist);
#else /* not GLIB_CHECK_VERSION(2,2,0) || defined (HAVE_VPRINTF) */
  if (lpOutput)
    *lpOutput = '\0';
#endif /* not GLIB_CHECK_VERSION(2,2,0) || defined (HAVE_VPRINTF) */
  return g_strlen (lpOutput);
}


/* wsprintfW ordinal = 693, argument = 0 */
INT WINAPIV wsprintfW (LPWSTR lpOutput, LPCWSTR lpFormat, ...)
{
  if (lpOutput)
    *lpOutput = '\0';
  return 0;
}


/* wvsprintfA ordinal = 694, argument = 12 */
INT WINAPI wvsprintfA (LPSTR lpOutput, LPCSTR lpFormat, va_list arglist)
{
#if GLIB_CHECK_VERSION(2,2,0)
  return g_vsprintf (lpOutput, lpFormat, arglist);
#elif defined HAVE_VPRINTF
  return vsprintf (lpOutput, lpFormat, arglist);
#else /* not GLIB_CHECK_VERSION(2,2,0) || defined (HAVE_VPRINTF) */
  if (lpOutput)
    *lpOutput = '\0';
  return 0;
#endif /* not GLIB_CHECK_VERSION(2,2,0) || defined (HAVE_VPRINTF) */
}


/* wvsprintfW ordinal = 695, argument = 12 */
INT WINAPI wvsprintfW (LPSTR lpOutput, LPCSTR lpFormat, va_list arglist)
{
  if (lpOutput)
    *lpOutput = '\0';
  return 0;
}


W32LdrExport user32_exports[] = {
{FALSE,   1, "ActivateKeyboardLayout",        ActivateKeyboardLayout},
{FALSE,   2, "AdjustWindowRect",              AdjustWindowRect},
{FALSE,   3, "AdjustWindowRectEx",            AdjustWindowRectEx},
{FALSE,   4, "AlignRects",                    AlignRects},
{FALSE,   5, "AllowSetForegroundWindow",      AllowSetForegroundWindow},
{FALSE,   6, "AnimateWindow",                 AnimateWindow},
{FALSE,   7, "AnyPopup",                      AnyPopup},
{FALSE,   8, "AppendMenuA",                   AppendMenuA},
{FALSE,   9, "AppendMenuW",                   AppendMenuW},
{FALSE,  10, "ArrangeIconicWindows",          ArrangeIconicWindows},
{FALSE,  11, "AttachThreadInput",             AttachThreadInput},
{FALSE,  12, "BeginDeferWindowPos",           BeginDeferWindowPos},
{TRUE,   13, "BeginPaint",                    BeginPaint},
{FALSE,  14, "BlockInput",                    BlockInput},
{FALSE,  15, "BringWindowToTop",              BringWindowToTop},
{FALSE,  16, "BroadcastSystemMessage",        BroadcastSystemMessageA},
{FALSE,  17, "BroadcastSystemMessageA",       BroadcastSystemMessageA},
{FALSE,  18, "BroadcastSystemMessageW",       BroadcastSystemMessageW},
{FALSE,  19, "CallMsgFilter",                 CallMsgFilterA},
{FALSE,  20, "CallMsgFilterA",                CallMsgFilterA},
{FALSE,  21, "CallMsgFilterW",                CallMsgFilterW},
{FALSE,  22, "CallNextHookEx",                CallNextHookEx},
{FALSE,  23, "CallWindowProcA",               CallWindowProcA},
{FALSE,  24, "CallWindowProcW",               CallWindowProcW},
{FALSE,  25, "CascadeChildWindows",           CascadeChildWindows},
{FALSE,  26, "CascadeWindows",                CascadeWindows},
{FALSE,  27, "ChangeClipboardChain",          ChangeClipboardChain},
{FALSE,  28, "ChangeDisplaySettingsA",        ChangeDisplaySettingsA},
{FALSE,  29, "ChangeDisplaySettingsExA",      ChangeDisplaySettingsExA},
{FALSE,  30, "ChangeDisplaySettingsExW",      ChangeDisplaySettingsExW},
{FALSE,  31, "ChangeDisplaySettingsW",        ChangeDisplaySettingsW},
{FALSE,  32, "ChangeMenuA",                   ChangeMenuA},
{FALSE,  33, "ChangeMenuW",                   ChangeMenuW},
{TRUE,   34, "CharLowerA",                    CharLowerA},
{FALSE,  35, "CharLowerBuffA",                CharLowerBuffA},
{FALSE,  36, "CharLowerBuffW",                CharLowerBuffW},
{TRUE,   37, "CharLowerW",                    CharLowerW},
{FALSE,  38, "CharNextA",                     CharNextA},
{FALSE,  39, "CharNextExA",                   CharNextExA},
{FALSE,  40, "CharNextW",                     CharNextW},
{FALSE,  41, "CharPrevA",                     CharPrevA},
{FALSE,  42, "CharPrevExA",                   CharPrevExA},
{FALSE,  43, "CharPrevW",                     CharPrevW},
{FALSE,  44, "CharToOemA",                    CharToOemA},
{FALSE,  45, "CharToOemBuffA",                CharToOemBuffA},
{FALSE,  46, "CharToOemBuffW",                CharToOemBuffW},
{FALSE,  47, "CharToOemW",                    CharToOemW},
{TRUE,   48, "CharUpperA",                    CharUpperA},
{FALSE,  49, "CharUpperBuffA",                CharUpperBuffA},
{FALSE,  50, "CharUpperBuffW",                CharUpperBuffW},
{TRUE,   51, "CharUpperW",                    CharUpperW},
{TRUE,   52, "CheckDlgButton",                CheckDlgButton},
{FALSE,  53, "CheckMenuItem",                 CheckMenuItem},
{FALSE,  54, "CheckMenuRadioItem",            CheckMenuRadioItem},
{TRUE,   55, "CheckRadioButton",              CheckRadioButton},
{FALSE,  56, "ChildWindowFromPoint",          ChildWindowFromPoint},
{FALSE,  57, "ChildWindowFromPointEx",        ChildWindowFromPointEx},
{FALSE,  58, "CliImmSetHotKey",               CliImmSetHotKey},
{FALSE,  59, "ClientThreadSetup",             ClientThreadSetup},
{FALSE,  60, "ClientToScreen",                ClientToScreen},
{FALSE,  61, "ClipCursor",                    ClipCursor},
{FALSE,  62, "CloseClipboard",                CloseClipboard},
{FALSE,  63, "CloseDesktop",                  CloseDesktop},
{FALSE,  64, "CloseWindow",                   CloseWindow},
{FALSE,  65, "CloseWindowStation",            CloseWindowStation},
{FALSE,  66, "CopyAcceleratorTableA",         CopyAcceleratorTableA},
{FALSE,  67, "CopyAcceleratorTableW",         CopyAcceleratorTableW},
{FALSE,  68, "CopyIcon",                      CopyIcon},
{FALSE,  69, "CopyImage",                     CopyImage},
{FALSE,  70, "CopyRect",                      CopyRect},
{FALSE,  71, "CountClipboardFormats",         CountClipboardFormats},
{FALSE,  72, "CreateAcceleratorTableA",       CreateAcceleratorTableA},
{FALSE,  73, "CreateAcceleratorTableW",       CreateAcceleratorTableW},
{FALSE,  74, "CreateCaret",                   CreateCaret},
{FALSE,  75, "CreateCursor",                  CreateCursor},
{FALSE,  76, "CreateDesktopA",                CreateDesktopA},
{FALSE,  77, "CreateDesktopW",                CreateDesktopW},
{FALSE,  78, "CreateDialogIndirectParamA",    CreateDialogIndirectParamA},
{FALSE,  79, "CreateDialogIndirectParamAorW", CreateDialogIndirectParamAorW},
{FALSE,  80, "CreateDialogIndirectParamW",    CreateDialogIndirectParamW},
{FALSE,  81, "CreateDialogParamA",            CreateDialogParamA},
{FALSE,  82, "CreateDialogParamW",            CreateDialogParamW},
{FALSE,  83, "CreateIcon",                    CreateIcon},
{FALSE,  84, "CreateIconFromResource",        CreateIconFromResource},
{FALSE,  85, "CreateIconFromResourceEx",      CreateIconFromResourceEx},
{FALSE,  86, "CreateIconIndirect",            CreateIconIndirect},
{FALSE,  87, "CreateMDIWindowA",              CreateMDIWindowA},
{FALSE,  88, "CreateMDIWindowW",              CreateMDIWindowW},
{FALSE,  89, "CreateMenu",                    CreateMenu},
{FALSE,  90, "CreatePopupMenu",               CreatePopupMenu},
{FALSE,  91, "CreateWindowExA",               CreateWindowExA},
{FALSE,  92, "CreateWindowExW",               CreateWindowExW},
{FALSE,  93, "CreateWindowStationA",          CreateWindowStationA},
{FALSE,  94, "CreateWindowStationW",          CreateWindowStationW},
{FALSE,  95, "CtxInitUser32",                 CtxInitUser32},
{FALSE,  96, "DdeAbandonTransaction",         DdeAbandonTransaction},
{FALSE,  97, "DdeAccessData",                 DdeAccessData},
{FALSE,  98, "DdeAddData",                    DdeAddData},
{FALSE,  99, "DdeClientTransaction",          DdeClientTransaction},
{FALSE, 100, "DdeCmpStringHandles",           DdeCmpStringHandles},
{FALSE, 101, "DdeConnect",                    DdeConnect},
{FALSE, 102, "DdeConnectList",                DdeConnectList},
{FALSE, 103, "DdeCreateDataHandle",           DdeCreateDataHandle},
{FALSE, 104, "DdeCreateStringHandleA",        DdeCreateStringHandleA},
{FALSE, 105, "DdeCreateStringHandleW",        DdeCreateStringHandleW},
{FALSE, 106, "DdeDisconnect",                 DdeDisconnect},
{FALSE, 107, "DdeDisconnectList",             DdeDisconnectList},
{FALSE, 108, "DdeEnableCallback",             DdeEnableCallback},
{FALSE, 109, "DdeFreeDataHandle",             DdeFreeDataHandle},
{FALSE, 110, "DdeFreeStringHandle",           DdeFreeStringHandle},
{FALSE, 111, "DdeGetData",                    DdeGetData},
{FALSE, 112, "DdeGetLastError",               DdeGetLastError},
{FALSE, 113, "DdeGetQualityOfService",        DdeGetQualityOfService},
{FALSE, 114, "DdeImpersonateClient",          DdeImpersonateClient},
{FALSE, 115, "DdeInitializeA",                DdeInitializeA},
{FALSE, 116, "DdeInitializeW",                DdeInitializeW},
{FALSE, 117, "DdeKeepStringHandle",           DdeKeepStringHandle},
{FALSE, 118, "DdeNameService",                DdeNameService},
{FALSE, 119, "DdePostAdvise",                 DdePostAdvise},
{FALSE, 120, "DdeQueryConvInfo",              DdeQueryConvInfo},
{FALSE, 121, "DdeQueryNextServer",            DdeQueryNextServer},
{FALSE, 122, "DdeQueryStringA",               DdeQueryStringA},
{FALSE, 123, "DdeQueryStringW",               DdeQueryStringW},
{FALSE, 124, "DdeReconnect",                  DdeReconnect},
{FALSE, 125, "DdeSetQualityOfService",        DdeSetQualityOfService},
{FALSE, 126, "DdeSetUserHandle",              DdeSetUserHandle},
{FALSE, 127, "DdeUnaccessData",               DdeUnaccessData},
{FALSE, 128, "DdeUninitialize",               DdeUninitialize},
{FALSE, 129, "DefDlgProcA",                   DefDlgProcA},
{FALSE, 130, "DefDlgProcW",                   DefDlgProcW},
{FALSE, 131, "DefFrameProcA",                 DefFrameProcA},
{FALSE, 132, "DefFrameProcW",                 DefFrameProcW},
{FALSE, 133, "DefMDIChildProcA",              DefMDIChildProcA},
{FALSE, 134, "DefMDIChildProcW",              DefMDIChildProcW},
{TRUE,  135, "DefWindowProcA",                DefWindowProcA},
{TRUE,  136, "DefWindowProcW",                DefWindowProcW},
{FALSE, 137, "DeferWindowPos",                DeferWindowPos},
{FALSE, 138, "DeleteMenu",                    DeleteMenu},
{FALSE, 139, "DeregisterShellHookWindow",     DeregisterShellHookWindow},
{FALSE, 140, "DestroyAcceleratorTable",       DestroyAcceleratorTable},
{FALSE, 141, "DestroyCaret",                  DestroyCaret},
{FALSE, 142, "DestroyCursor",                 DestroyCursor},
{FALSE, 143, "DestroyIcon",                   DestroyIcon},
{FALSE, 144, "DestroyMenu",                   DestroyMenu},
{TRUE,  145, "DestroyWindow",                 DestroyWindow},
{FALSE, 146, "DeviceEventWorker",             DeviceEventWorker},
{TRUE,  147, "DialogBoxIndirectParamA",       DialogBoxIndirectParamA},
{FALSE, 148, "DialogBoxIndirectParamAorW",    DialogBoxIndirectParamAorW},
{TRUE,  149, "DialogBoxIndirectParamW",       DialogBoxIndirectParamW},
{TRUE,  150, "DialogBoxParamA",               DialogBoxParamA},
{TRUE,  151, "DialogBoxParamW",               DialogBoxParamW},
{FALSE, 152, "DispatchMessageA",              DispatchMessageA},
{FALSE, 153, "DispatchMessageW",              DispatchMessageW},
{FALSE, 154, "DlgDirListA",                   DlgDirListA},
{FALSE, 155, "DlgDirListComboBoxA",           DlgDirListComboBoxA},
{FALSE, 156, "DlgDirListComboBoxW",           DlgDirListComboBoxW},
{FALSE, 157, "DlgDirListW",                   DlgDirListW},
{FALSE, 158, "DlgDirSelectComboBoxExA",       DlgDirSelectComboBoxExA},
{FALSE, 159, "DlgDirSelectComboBoxExW",       DlgDirSelectComboBoxExW},
{FALSE, 160, "DlgDirSelectExA",               DlgDirSelectExA},
{FALSE, 161, "DlgDirSelectExW",               DlgDirSelectExW},
{FALSE, 162, "DragDetect",                    DragDetect},
{FALSE, 163, "DragObject",                    DragObject},
{FALSE, 164, "DrawAnimatedRects",             DrawAnimatedRects},
{FALSE, 165, "DrawCaption",                   DrawCaption},
{FALSE, 166, "DrawCaptionTempA",              DrawCaptionTempA},
{FALSE, 167, "DrawCaptionTempW",              DrawCaptionTempW},
{FALSE, 168, "DrawEdge",                      DrawEdge},
{FALSE, 169, "DrawFocusRect",                 DrawFocusRect},
{FALSE, 170, "DrawFrame",                     DrawFrame},
{FALSE, 171, "DrawFrameControl",              DrawFrameControl},
{FALSE, 172, "DrawIcon",                      DrawIcon},
{FALSE, 173, "DrawIconEx",                    DrawIconEx},
{FALSE, 174, "DrawMenuBar",                   DrawMenuBar},
{FALSE, 175, "DrawMenuBarTemp",               DrawMenuBarTemp},
{FALSE, 176, "DrawStateA",                    DrawStateA},
{FALSE, 177, "DrawStateW",                    DrawStateW},
{FALSE, 178, "DrawTextA",                     DrawTextA},
{FALSE, 179, "DrawTextExA",                   DrawTextExA},
{FALSE, 180, "DrawTextExW",                   DrawTextExW},
{FALSE, 181, "DrawTextW",                     DrawTextW},
{FALSE, 182, "EditWndProc",                   EditWndProc},
{FALSE, 183, "EmptyClipboard",                EmptyClipboard},
{FALSE, 184, "EnableMenuItem",                EnableMenuItem},
{FALSE, 185, "EnableScrollBar",               EnableScrollBar},
{TRUE,  186, "EnableWindow",                  EnableWindow},
{FALSE, 187, "EndDeferWindowPos",             EndDeferWindowPos},
{TRUE,  188, "EndDialog",                     EndDialog},
{FALSE, 189, "EndMenu",                       EndMenu},
{TRUE,  190, "EndPaint",                      EndPaint},
{FALSE, 191, "EndTask",                       EndTask},
{FALSE, 192, "EnumChildWindows",              EnumChildWindows},
{FALSE, 193, "EnumClipboardFormats",          EnumClipboardFormats},
{FALSE, 194, "EnumDesktopWindows",            EnumDesktopWindows},
{FALSE, 195, "EnumDesktopsA",                 EnumDesktopsA},
{FALSE, 196, "EnumDesktopsW",                 EnumDesktopsW},
{FALSE, 197, "EnumDisplayDevicesA",           EnumDisplayDevicesA},
{FALSE, 198, "EnumDisplayDevicesW",           EnumDisplayDevicesW},
{FALSE, 199, "EnumDisplayMonitors",           EnumDisplayMonitors},
{FALSE, 200, "EnumDisplaySettingsA",          EnumDisplaySettingsA},
{FALSE, 201, "EnumDisplaySettingsExA",        EnumDisplaySettingsExA},
{FALSE, 202, "EnumDisplaySettingsExW",        EnumDisplaySettingsExW},
{FALSE, 203, "EnumDisplaySettingsW",          EnumDisplaySettingsW},
{FALSE, 204, "EnumPropsA",                    EnumPropsA},
{FALSE, 205, "EnumPropsExA",                  EnumPropsExA},
{FALSE, 206, "EnumPropsExW",                  EnumPropsExW},
{FALSE, 207, "EnumPropsW",                    EnumPropsW},
{TRUE,  208, "EnumThreadWindows",             EnumThreadWindows},
{FALSE, 209, "EnumWindowStationsA",           EnumWindowStationsA},
{FALSE, 210, "EnumWindowStationsW",           EnumWindowStationsW},
{FALSE, 211, "EnumWindows",                   EnumWindows},
{FALSE, 212, "EqualRect",                     EqualRect},
{FALSE, 213, "ExcludeUpdateRgn",              ExcludeUpdateRgn},
{FALSE, 214, "ExitWindowsEx",                 ExitWindowsEx},
{FALSE, 215, "FillRect",                      FillRect},
{FALSE, 216, "FindWindowA",                   FindWindowA},
{FALSE, 217, "FindWindowExA",                 FindWindowExA},
{FALSE, 218, "FindWindowExW",                 FindWindowExW},
{FALSE, 219, "FindWindowW",                   FindWindowW},
{FALSE, 220, "FlashWindow",                   FlashWindow},
{FALSE, 221, "FlashWindowEx",                 FlashWindowEx},
{FALSE, 222, "FrameRect",                     FrameRect},
{FALSE, 223, "FreeDDElParam",                 FreeDDElParam},
{FALSE, 224, "GetActiveWindow",               GetActiveWindow},
{FALSE, 225, "GetAltTabInfo",                 GetAltTabInfoA},
{FALSE, 226, "GetAltTabInfoA",                GetAltTabInfoA},
{FALSE, 227, "GetAltTabInfoW",                GetAltTabInfoW},
{FALSE, 228, "GetAncestor",                   GetAncestor},
{FALSE, 230, "GetAppCompatFlags",             GetAppCompatFlags},
{FALSE, 229, "GetAppCompatFlags2",            GetAppCompatFlags2},
{FALSE, 231, "GetAsyncKeyState",              GetAsyncKeyState},
{FALSE, 232, "GetCapture",                    GetCapture},
{FALSE, 233, "GetCaretBlinkTime",             GetCaretBlinkTime},
{FALSE, 234, "GetCaretPos",                   GetCaretPos},
{FALSE, 235, "GetClassInfoA",                 GetClassInfoA},
{FALSE, 236, "GetClassInfoExA",               GetClassInfoExA},
{FALSE, 237, "GetClassInfoExW",               GetClassInfoExW},
{FALSE, 238, "GetClassInfoW",                 GetClassInfoW},
{FALSE, 239, "GetClassLongA",                 GetClassLongA},
{FALSE, 240, "GetClassLongW",                 GetClassLongW},
{FALSE, 241, "GetClassNameA",                 GetClassNameA},
{FALSE, 242, "GetClassNameW",                 GetClassNameW},
{FALSE, 243, "GetClassWord",                  GetClassWord},
{TRUE,  244, "GetClientRect",                 GetClientRect},
{FALSE, 245, "GetClipCursor",                 GetClipCursor},
{FALSE, 246, "GetClipboardData",              GetClipboardData},
{FALSE, 247, "GetClipboardFormatNameA",       GetClipboardFormatNameA},
{FALSE, 248, "GetClipboardFormatNameW",       GetClipboardFormatNameW},
{FALSE, 249, "GetClipboardOwner",             GetClipboardOwner},
{FALSE, 250, "GetClipboardSequenceNumber",    GetClipboardSequenceNumber},
{FALSE, 251, "GetClipboardViewer",            GetClipboardViewer},
{FALSE, 252, "GetComboBoxInfo",               GetComboBoxInfo},
{FALSE, 253, "GetCursor",                     GetCursor},
{FALSE, 254, "GetCursorFrameInfo",            GetCursorFrameInfo},
{FALSE, 255, "GetCursorInfo",                 GetCursorInfo},
{FALSE, 256, "GetCursorPos",                  GetCursorPos},
{TRUE,  257, "GetDC",                         GetDC},
{FALSE, 258, "GetDCEx",                       GetDCEx},
{TRUE,  259, "GetDesktopWindow",              GetDesktopWindow},
{FALSE, 260, "GetDialogBaseUnits",            GetDialogBaseUnits},
{TRUE,  261, "GetDlgCtrlID",                  GetDlgCtrlID},
{TRUE,  262, "GetDlgItem",                    GetDlgItem},
{TRUE,  263, "GetDlgItemInt",                 GetDlgItemInt},
{FALSE, 264, "GetDlgItemTextA",               GetDlgItemTextA},
{FALSE, 265, "GetDlgItemTextW",               GetDlgItemTextW},
{FALSE, 266, "GetDoubleClickTime",            GetDoubleClickTime},
{TRUE,  267, "GetFocus",                      GetFocus},
{FALSE, 268, "GetForegroundWindow",           GetForegroundWindow},
{FALSE, 269, "GetGUIThreadInfo",              GetGUIThreadInfo},
{FALSE, 270, "GetGuiResources",               GetGuiResources},
{FALSE, 271, "GetIconInfo",                   GetIconInfo},
{FALSE, 272, "GetInputDesktop",               GetInputDesktop},
{FALSE, 273, "GetInputState",                 GetInputState},
{FALSE, 274, "GetInternalWindowPos",          GetInternalWindowPos},
{FALSE, 275, "GetKBCodePage",                 GetKBCodePage},
{FALSE, 276, "GetKeyNameTextA",               GetKeyNameTextA},
{FALSE, 277, "GetKeyNameTextW",               GetKeyNameTextW},
{FALSE, 278, "GetKeyState",                   GetKeyState},
{FALSE, 279, "GetKeyboardLayout",             GetKeyboardLayout},
{FALSE, 280, "GetKeyboardLayoutList",         GetKeyboardLayoutList},
{FALSE, 281, "GetKeyboardLayoutNameA",        GetKeyboardLayoutNameA},
{FALSE, 282, "GetKeyboardLayoutNameW",        GetKeyboardLayoutNameW},
{FALSE, 283, "GetKeyboardState",              GetKeyboardState},
{TRUE,  284, "GetKeyboardType",               GetKeyboardType},
{FALSE, 285, "GetLastActivePopup",            GetLastActivePopup},
{FALSE, 286, "GetLastInputInfo",              GetLastInputInfo},
{FALSE, 287, "GetListBoxInfo",                GetListBoxInfo},
{FALSE, 288, "GetMenu",                       GetMenu},
{FALSE, 289, "GetMenuBarInfo",                GetMenuBarInfo},
{FALSE, 290, "GetMenuCheckMarkDimensions",    GetMenuCheckMarkDimensions},
{FALSE, 291, "GetMenuContextHelpId",          GetMenuContextHelpId},
{FALSE, 292, "GetMenuDefaultItem",            GetMenuDefaultItem},
{FALSE, 293, "GetMenuInfo",                   GetMenuInfo},
{FALSE, 294, "GetMenuItemCount",              GetMenuItemCount},
{FALSE, 295, "GetMenuItemID",                 GetMenuItemID},
{FALSE, 296, "GetMenuItemInfoA",              GetMenuItemInfoA},
{FALSE, 297, "GetMenuItemInfoW",              GetMenuItemInfoW},
{FALSE, 298, "GetMenuItemRect",               GetMenuItemRect},
{FALSE, 299, "GetMenuState",                  GetMenuState},
{FALSE, 300, "GetMenuStringA",                GetMenuStringA},
{FALSE, 301, "GetMenuStringW",                GetMenuStringW},
{FALSE, 302, "GetMessageA",                   GetMessageA},
{FALSE, 303, "GetMessageExtraInfo",           GetMessageExtraInfo},
{FALSE, 304, "GetMessagePos",                 GetMessagePos},
{FALSE, 305, "GetMessageTime",                GetMessageTime},
{FALSE, 306, "GetMessageW",                   GetMessageW},
{FALSE, 307, "GetMonitorInfoA",               GetMonitorInfoA},
{FALSE, 308, "GetMonitorInfoW",               GetMonitorInfoW},
{FALSE, 309, "GetMouseMovePointsEx",          GetMouseMovePointsEx},
{FALSE, 310, "GetNextDlgGroupItem",           GetNextDlgGroupItem},
{FALSE, 311, "GetNextDlgTabItem",             GetNextDlgTabItem},
{FALSE, 312, "GetOpenClipboardWindow",        GetOpenClipboardWindow},
{FALSE, 313, "GetParent",                     GetParent},
{FALSE, 314, "GetPriorityClipboardFormat",    GetPriorityClipboardFormat},
{FALSE, 315, "GetProcessDefaultLayout",       GetProcessDefaultLayout},
{FALSE, 316, "GetProcessWindowStation",       GetProcessWindowStation},
{FALSE, 317, "GetProgmanWindow",              GetProgmanWindow},
{FALSE, 318, "GetPropA",                      GetPropA},
{FALSE, 319, "GetPropW",                      GetPropW},
{FALSE, 320, "GetQueueStatus",                GetQueueStatus},
{FALSE, 321, "GetScrollBarInfo",              GetScrollBarInfo},
{FALSE, 322, "GetScrollInfo",                 GetScrollInfo},
{TRUE,  323, "GetScrollPos",                  GetScrollPos},
{TRUE,  324, "GetScrollRange",                GetScrollRange},
{FALSE, 325, "GetShellWindow",                GetShellWindow},
{FALSE, 326, "GetSubMenu",                    GetSubMenu},
{TRUE,  327, "GetSysColor",                   GetSysColor},
{FALSE, 328, "GetSysColorBrush",              GetSysColorBrush},
{FALSE, 329, "GetSystemMenu",                 GetSystemMenu},
{TRUE,  330, "GetSystemMetrics",              GetSystemMetrics},
{FALSE, 331, "GetTabbedTextExtentA",          GetTabbedTextExtentA},
{FALSE, 332, "GetTabbedTextExtentW",          GetTabbedTextExtentW},
{FALSE, 333, "GetTaskmanWindow",              GetTaskmanWindow},
{FALSE, 334, "GetThreadDesktop",              GetThreadDesktop},
{FALSE, 335, "GetTitleBarInfo",               GetTitleBarInfo},
{FALSE, 336, "GetTopWindow",                  GetTopWindow},
{FALSE, 337, "GetUpdateRect",                 GetUpdateRect},
{FALSE, 338, "GetUpdateRgn",                  GetUpdateRgn},
{FALSE, 339, "GetUserObjectInformationA",     GetUserObjectInformationA},
{FALSE, 340, "GetUserObjectInformationW",     GetUserObjectInformationW},
{FALSE, 341, "GetUserObjectSecurity",         GetUserObjectSecurity},
{FALSE, 342, "GetWinStationInfo",             GetWinStationInfo},
{FALSE, 343, "GetWindow",                     GetWindow},
{FALSE, 344, "GetWindowContextHelpId",        GetWindowContextHelpId},
{FALSE, 345, "GetWindowDC",                   GetWindowDC},
{FALSE, 346, "GetWindowInfo",                 GetWindowInfo},
{TRUE,  347, "GetWindowLongA",                GetWindowLongA},
{TRUE,  348, "GetWindowLongW",                GetWindowLongW},
{FALSE, 349, "GetWindowModuleFileName",       GetWindowModuleFileNameA},
{FALSE, 350, "GetWindowModuleFileNameA",      GetWindowModuleFileNameA},
{FALSE, 351, "GetWindowModuleFileNameW",      GetWindowModuleFileNameW},
{FALSE, 352, "GetWindowPlacement",            GetWindowPlacement},
{TRUE,  353, "GetWindowRect",                 GetWindowRect},
{FALSE, 354, "GetWindowRgn",                  GetWindowRgn},
{TRUE,  355, "GetWindowTextA",                GetWindowTextA},
{FALSE, 356, "GetWindowTextLengthA",          GetWindowTextLengthA},
{FALSE, 357, "GetWindowTextLengthW",          GetWindowTextLengthW},
{TRUE,  358, "GetWindowTextW",                GetWindowTextW},
{FALSE, 359, "GetWindowThreadProcessId",      GetWindowThreadProcessId},
{FALSE, 360, "GetWindowWord",                 GetWindowWord},
{FALSE, 361, "GrayStringA",                   GrayStringA},
{FALSE, 362, "GrayStringW",                   GrayStringW},
{FALSE, 363, "HideCaret",                     HideCaret},
{FALSE, 364, "HiliteMenuItem",                HiliteMenuItem},
{FALSE, 365, "IMPGetIMEA",                    IMPGetIMEA},
{FALSE, 366, "IMPGetIMEW",                    IMPGetIMEW},
{FALSE, 367, "IMPQueryIMEA",                  IMPQueryIMEA},
{FALSE, 368, "IMPQueryIMEW",                  IMPQueryIMEW},
{FALSE, 369, "IMPSetIMEA",                    IMPSetIMEA},
{FALSE, 370, "IMPSetIMEW",                    IMPSetIMEW},
{FALSE, 371, "ImpersonateDdeClientWindow",    ImpersonateDdeClientWindow},
{FALSE, 372, "InSendMessage",                 InSendMessage},
{FALSE, 373, "InSendMessageEx",               InSendMessageEx},
{FALSE, 374, "InflateRect",                   InflateRect},
{FALSE, 375, "InitializeLpkHooks",            InitializeLpkHooks},
{FALSE, 376, "InitializeWin32EntryTable",     InitializeWin32EntryTable},
{FALSE, 377, "InsertMenuA",                   InsertMenuA},
{FALSE, 378, "InsertMenuItemA",               InsertMenuItemA},
{FALSE, 379, "InsertMenuItemW",               InsertMenuItemW},
{FALSE, 380, "InsertMenuW",                   InsertMenuW},
{FALSE, 381, "InternalGetWindowText",         InternalGetWindowText},
{FALSE, 382, "IntersectRect",                 IntersectRect},
{TRUE,  383, "InvalidateRect",                InvalidateRect},
{FALSE, 384, "InvalidateRgn",                 InvalidateRgn},
{FALSE, 385, "InvertRect",                    InvertRect},
{FALSE, 386, "IsCharAlphaA",                  IsCharAlphaA},
{FALSE, 387, "IsCharAlphaNumericA",           IsCharAlphaNumericA},
{FALSE, 388, "IsCharAlphaNumericW",           IsCharAlphaNumericW},
{FALSE, 389, "IsCharAlphaW",                  IsCharAlphaW},
{FALSE, 390, "IsCharLowerA",                  IsCharLowerA},
{FALSE, 391, "IsCharLowerW",                  IsCharLowerW},
{FALSE, 392, "IsCharUpperA",                  IsCharUpperA},
{FALSE, 393, "IsCharUpperW",                  IsCharUpperW},
{FALSE, 394, "IsChild",                       IsChild},
{FALSE, 395, "IsClipboardFormatAvailable",    IsClipboardFormatAvailable},
{FALSE, 396, "IsDialogMessage",               IsDialogMessageA},
{FALSE, 397, "IsDialogMessageA",              IsDialogMessageA},
{FALSE, 398, "IsDialogMessageW",              IsDialogMessageW},
{TRUE,  399, "IsDlgButtonChecked",            IsDlgButtonChecked},
{FALSE, 400, "IsHungAppWindow",               IsHungAppWindow},
{FALSE, 401, "IsIconic",                      IsIconic},
{FALSE, 402, "IsMenu",                        IsMenu},
{TRUE,  403, "IsRectEmpty",                   IsRectEmpty},
{FALSE, 404, "IsWindow",                      IsWindow},
{FALSE, 405, "IsWindowEnabled",               IsWindowEnabled},
{FALSE, 406, "IsWindowUnicode",               IsWindowUnicode},
{FALSE, 407, "IsWindowVisible",               IsWindowVisible},
{FALSE, 408, "IsZoomed",                      IsZoomed},
{FALSE, 409, "KillSystemTimer",               KillSystemTimer},
{FALSE, 410, "KillTimer",                     KillTimer},
{FALSE, 411, "LoadAcceleratorsA",             LoadAcceleratorsA},
{FALSE, 412, "LoadAcceleratorsW",             LoadAcceleratorsW},
{TRUE,  413, "LoadBitmapA",                   LoadBitmapA},
{TRUE,  414, "LoadBitmapW",                   LoadBitmapW},
{FALSE, 415, "LoadCursorA",                   LoadCursorA},
{FALSE, 416, "LoadCursorFromFileA",           LoadCursorFromFileA},
{FALSE, 417, "LoadCursorFromFileW",           LoadCursorFromFileW},
{FALSE, 418, "LoadCursorW",                   LoadCursorW},
{FALSE, 419, "LoadIconA",                     LoadIconA},
{FALSE, 420, "LoadIconW",                     LoadIconW},
{FALSE, 421, "LoadImageA",                    LoadImageA},
{FALSE, 422, "LoadImageW",                    LoadImageW},
{FALSE, 423, "LoadKeyboardLayoutA",           LoadKeyboardLayoutA},
{FALSE, 424, "LoadKeyboardLayoutEx",          LoadKeyboardLayoutEx},
{FALSE, 425, "LoadKeyboardLayoutW",           LoadKeyboardLayoutW},
{FALSE, 426, "LoadLocalFonts",                LoadLocalFonts},
{FALSE, 427, "LoadMenuA",                     LoadMenuA},
{FALSE, 428, "LoadMenuIndirectA",             LoadMenuIndirectA},
{FALSE, 429, "LoadMenuIndirectW",             LoadMenuIndirectW},
{FALSE, 430, "LoadMenuW",                     LoadMenuW},
{FALSE, 431, "LoadRemoteFonts",               LoadRemoteFonts},
{TRUE,  432, "LoadStringA",                   LoadStringA},
{TRUE,  433, "LoadStringW",                   LoadStringW},
{FALSE, 434, "LockSetForegroundWindow",       LockSetForegroundWindow},
{FALSE, 435, "LockWindowStation",             LockWindowStation},
{FALSE, 436, "LockWindowUpdate",              LockWindowUpdate},
{FALSE, 437, "LockWorkStation",               LockWorkStation},
{FALSE, 438, "LookupIconIdFromDirectory",     LookupIconIdFromDirectory},
{FALSE, 439, "LookupIconIdFromDirectoryEx",   LookupIconIdFromDirectoryEx},
{FALSE, 440, "MBToWCSEx",                     MBToWCSEx},
{FALSE, 441, "MB_GetString",                  MB_GetString},
{FALSE, 442, "MapDialogRect",                 MapDialogRect},
{FALSE, 443, "MapVirtualKeyA",                MapVirtualKeyA},
{FALSE, 444, "MapVirtualKeyExA",              MapVirtualKeyExA},
{FALSE, 445, "MapVirtualKeyExW",              MapVirtualKeyExW},
{FALSE, 446, "MapVirtualKeyW",                MapVirtualKeyW},
{TRUE,  447, "MapWindowPoints",               MapWindowPoints},
{FALSE, 448, "MenuItemFromPoint",             MenuItemFromPoint},
{FALSE, 449, "MenuWindowProcA",               MenuWindowProcA},
{FALSE, 450, "MenuWindowProcW",               MenuWindowProcW},
{TRUE,  451, "MessageBeep",                   MessageBeep},
{TRUE,  452, "MessageBoxA",                   MessageBoxA},
{TRUE,  453, "MessageBoxExA",                 MessageBoxExA},
{TRUE,  454, "MessageBoxExW",                 MessageBoxExW},
{FALSE, 455, "MessageBoxIndirectA",           MessageBoxIndirectA},
{FALSE, 456, "MessageBoxIndirectW",           MessageBoxIndirectW},
{TRUE,  457, "MessageBoxW",                   MessageBoxW},
{FALSE, 458, "ModifyMenuA",                   ModifyMenuA},
{FALSE, 459, "ModifyMenuW",                   ModifyMenuW},
{FALSE, 460, "MonitorFromPoint",              MonitorFromPoint},
{FALSE, 461, "MonitorFromRect",               MonitorFromRect},
{FALSE, 462, "MonitorFromWindow",             MonitorFromWindow},
{TRUE,  463, "MoveWindow",                    MoveWindow},
{FALSE, 464, "MsgWaitForMultipleObjects",     MsgWaitForMultipleObjects},
{FALSE, 465, "MsgWaitForMultipleObjectsEx",   MsgWaitForMultipleObjectsEx},
{FALSE, 466, "NotifyWinEvent",                NotifyWinEvent},
{FALSE, 467, "OemKeyScan",                    OemKeyScan},
{FALSE, 468, "OemToCharA",                    OemToCharA},
{FALSE, 469, "OemToCharBuffA",                OemToCharBuffA},
{FALSE, 470, "OemToCharBuffW",                OemToCharBuffW},
{FALSE, 471, "OemToCharW",                    OemToCharW},
{TRUE,  472, "OffsetRect",                    OffsetRect},
{FALSE, 473, "OpenClipboard",                 OpenClipboard},
{FALSE, 474, "OpenDesktopA",                  OpenDesktopA},
{FALSE, 475, "OpenDesktopW",                  OpenDesktopW},
{FALSE, 476, "OpenIcon",                      OpenIcon},
{FALSE, 477, "OpenInputDesktop",              OpenInputDesktop},
{FALSE, 478, "OpenWindowStationA",            OpenWindowStationA},
{FALSE, 479, "OpenWindowStationW",            OpenWindowStationW},
{FALSE, 480, "PackDDElParam",                 PackDDElParam},
{FALSE, 481, "PaintDesktop",                  PaintDesktop},
{FALSE, 482, "PeekMessageA",                  PeekMessageA},
{FALSE, 483, "PeekMessageW",                  PeekMessageW},
{FALSE, 484, "PostMessageA",                  PostMessageA},
{FALSE, 485, "PostMessageW",                  PostMessageW},
{FALSE, 486, "PostQuitMessage",               PostQuitMessage},
{FALSE, 487, "PostThreadMessageA",            PostThreadMessageA},
{FALSE, 488, "PostThreadMessageW",            PostThreadMessageW},
{FALSE, 489, "PrivateExtractIconExA",         PrivateExtractIconExA},
{FALSE, 490, "PrivateExtractIconExW",         PrivateExtractIconExW},
{FALSE, 491, "PrivateExtractIconsA",          PrivateExtractIconsA},
{FALSE, 492, "PrivateExtractIconsW",          PrivateExtractIconsW},
{FALSE, 493, "PrivateSetDbgTag",              PrivateSetDbgTag},
{FALSE, 494, "PrivateSetRipFlags",            PrivateSetRipFlags},
{FALSE, 495, "PtInRect",                      PtInRect},
{FALSE, 496, "QuerySendMessage",              QuerySendMessage},
{FALSE, 497, "QueryUserCounters",             QueryUserCounters},
{FALSE, 498, "RealChildWindowFromPoint",      RealChildWindowFromPoint},
{FALSE, 499, "RealGetWindowClass",            RealGetWindowClassA},
{FALSE, 500, "RealGetWindowClassA",           RealGetWindowClassA},
{FALSE, 501, "RealGetWindowClassW",           RealGetWindowClassW},
{FALSE, 502, "RedrawWindow",                  RedrawWindow},
{FALSE, 503, "RegisterClassA",                RegisterClassA},
{FALSE, 504, "RegisterClassExA",              RegisterClassExA},
{FALSE, 505, "RegisterClassExW",              RegisterClassExW},
{FALSE, 506, "RegisterClassW",                RegisterClassW},
{FALSE, 507, "RegisterClipboardFormatA",      RegisterClipboardFormatA},
{FALSE, 508, "RegisterClipboardFormatW",      RegisterClipboardFormatW},
{FALSE, 509, "RegisterDeviceNotificationA",   RegisterDeviceNotificationA},
{FALSE, 510, "RegisterDeviceNotificationW",   RegisterDeviceNotificationW},
{FALSE, 511, "RegisterHotKey",                RegisterHotKey},
{FALSE, 512, "RegisterLogonProcess",          RegisterLogonProcess},
{FALSE, 513, "RegisterServicesProcess",       RegisterServicesProcess},
{FALSE, 514, "RegisterShellHookWindow",       RegisterShellHookWindow},
{FALSE, 515, "RegisterSystemThread",          RegisterSystemThread},
{FALSE, 516, "RegisterTasklist",              RegisterTasklist},
{FALSE, 517, "RegisterWindowMessageA",        RegisterWindowMessageA},
{FALSE, 518, "RegisterWindowMessageW",        RegisterWindowMessageW},
{FALSE, 519, "ReleaseCapture",                ReleaseCapture},
{TRUE,  520, "ReleaseDC",                     ReleaseDC},
{FALSE, 521, "RemoveMenu",                    RemoveMenu},
{FALSE, 522, "RemovePropA",                   RemovePropA},
{FALSE, 523, "RemovePropW",                   RemovePropW},
{FALSE, 524, "ReplyMessage",                  ReplyMessage},
{FALSE, 525, "ResolveDesktopForWOW",          ResolveDesktopForWOW},
{FALSE, 526, "ReuseDDElParam",                ReuseDDElParam},
{TRUE,  527, "ScreenToClient",                ScreenToClient},
{FALSE, 528, "ScrollChildren",                ScrollChildren},
{FALSE, 529, "ScrollDC",                      ScrollDC},
{FALSE, 530, "ScrollWindow",                  ScrollWindow},
{FALSE, 531, "ScrollWindowEx",                ScrollWindowEx},
{TRUE,  532, "SendDlgItemMessageA",           SendDlgItemMessageA},
{TRUE,  533, "SendDlgItemMessageW",           SendDlgItemMessageW},
{FALSE, 534, "SendIMEMessageExA",             SendIMEMessageExA},
{FALSE, 535, "SendIMEMessageExW",             SendIMEMessageExW},
{FALSE, 536, "SendInput",                     SendInput},
{TRUE,  537, "SendMessageA",                  SendMessageA},
{FALSE, 538, "SendMessageCallbackA",          SendMessageCallbackA},
{FALSE, 539, "SendMessageCallbackW",          SendMessageCallbackW},
{FALSE, 540, "SendMessageTimeoutA",           SendMessageTimeoutA},
{FALSE, 541, "SendMessageTimeoutW",           SendMessageTimeoutW},
{TRUE,  542, "SendMessageW",                  SendMessageW},
{FALSE, 543, "SendNotifyMessageA",            SendNotifyMessageA},
{FALSE, 544, "SendNotifyMessageW",            SendNotifyMessageW},
{FALSE, 545, "SetActiveWindow",               SetActiveWindow},
{FALSE, 546, "SetCapture",                    SetCapture},
{FALSE, 547, "SetCaretBlinkTime",             SetCaretBlinkTime},
{FALSE, 548, "SetCaretPos",                   SetCaretPos},
{FALSE, 549, "SetClassLongA",                 SetClassLongA},
{FALSE, 550, "SetClassLongW",                 SetClassLongW},
{FALSE, 551, "SetClassWord",                  SetClassWord},
{FALSE, 552, "SetClipboardData",              SetClipboardData},
{FALSE, 553, "SetClipboardViewer",            SetClipboardViewer},
{FALSE, 554, "SetConsoleReserveKeys",         SetConsoleReserveKeys},
{FALSE, 555, "SetCursor",                     SetCursor},
{FALSE, 556, "SetCursorContents",             SetCursorContents},
{FALSE, 557, "SetCursorPos",                  SetCursorPos},
{FALSE, 558, "SetDebugErrorLevel",            SetDebugErrorLevel},
{FALSE, 559, "SetDeskWallpaper",              SetDeskWallpaper},
{TRUE,  560, "SetDlgItemInt",                 SetDlgItemInt},
{FALSE, 561, "SetDlgItemTextA",               SetDlgItemTextA},
{TRUE,  562, "SetDlgItemTextW",               SetDlgItemTextW},
{FALSE, 563, "SetDoubleClickTime",            SetDoubleClickTime},
{TRUE,  564, "SetFocus",                      SetFocus},
{FALSE, 565, "SetForegroundWindow",           SetForegroundWindow},
{FALSE, 566, "SetInternalWindowPos",          SetInternalWindowPos},
{FALSE, 567, "SetKeyboardState",              SetKeyboardState},
{FALSE, 568, "SetLastErrorEx",                SetLastErrorEx},
{FALSE, 569, "SetLayeredWindowAttributes",    SetLayeredWindowAttributes},
{FALSE, 570, "SetLogonNotifyWindow",          SetLogonNotifyWindow},
{FALSE, 571, "SetMenu",                       SetMenu},
{FALSE, 572, "SetMenuContextHelpId",          SetMenuContextHelpId},
{FALSE, 573, "SetMenuDefaultItem",            SetMenuDefaultItem},
{FALSE, 574, "SetMenuInfo",                   SetMenuInfo},
{FALSE, 575, "SetMenuItemBitmaps",            SetMenuItemBitmaps},
{FALSE, 576, "SetMenuItemInfoA",              SetMenuItemInfoA},
{FALSE, 577, "SetMenuItemInfoW",              SetMenuItemInfoW},
{FALSE, 578, "SetMessageExtraInfo",           SetMessageExtraInfo},
{FALSE, 579, "SetMessageQueue",               SetMessageQueue},
{FALSE, 580, "SetParent",                     SetParent},
{FALSE, 581, "SetProcessDefaultLayout",       SetProcessDefaultLayout},
{FALSE, 582, "SetProcessWindowStation",       SetProcessWindowStation},
{FALSE, 583, "SetProgmanWindow",              SetProgmanWindow},
{FALSE, 584, "SetPropA",                      SetPropA},
{FALSE, 585, "SetPropW",                      SetPropW},
{FALSE, 586, "SetRect",                       SetRect},
{FALSE, 587, "SetRectEmpty",                  SetRectEmpty},
{FALSE, 588, "SetScrollInfo",                 SetScrollInfo},
{TRUE,  589, "SetScrollPos",                  SetScrollPos},
{TRUE,  590, "SetScrollRange",                SetScrollRange},
{FALSE, 591, "SetShellWindow",                SetShellWindow},
{FALSE, 592, "SetShellWindowEx",              SetShellWindowEx},
{FALSE, 593, "SetSysColors",                  SetSysColors},
{FALSE, 594, "SetSysColorsTemp",              SetSysColorsTemp},
{FALSE, 595, "SetSystemCursor",               SetSystemCursor},
{FALSE, 596, "SetSystemMenu",                 SetSystemMenu},
{FALSE, 597, "SetSystemTimer",                SetSystemTimer},
{FALSE, 598, "SetTaskmanWindow",              SetTaskmanWindow},
{FALSE, 599, "SetThreadDesktop",              SetThreadDesktop},
{FALSE, 600, "SetTimer",                      SetTimer},
{FALSE, 601, "SetUserObjectInformationA",     SetUserObjectInformationA},
{FALSE, 602, "SetUserObjectInformationW",     SetUserObjectInformationW},
{FALSE, 603, "SetUserObjectSecurity",         SetUserObjectSecurity},
{FALSE, 604, "SetWinEventHook",               SetWinEventHook},
{FALSE, 605, "SetWindowContextHelpId",        SetWindowContextHelpId},
{TRUE,  606, "SetWindowLongA",                SetWindowLongA},
{TRUE,  607, "SetWindowLongW",                SetWindowLongW},
{FALSE, 608, "SetWindowPlacement",            SetWindowPlacement},
{TRUE,  609, "SetWindowPos",                  SetWindowPos},
{FALSE, 610, "SetWindowRgn",                  SetWindowRgn},
{FALSE, 611, "SetWindowStationUser",          SetWindowStationUser},
{TRUE,  612, "SetWindowTextA",                SetWindowTextA},
{TRUE,  613, "SetWindowTextW",                SetWindowTextW},
{FALSE, 614, "SetWindowWord",                 SetWindowWord},
{FALSE, 615, "SetWindowsHookA",               SetWindowsHookA},
{FALSE, 616, "SetWindowsHookExA",             SetWindowsHookExA},
{FALSE, 617, "SetWindowsHookExW",             SetWindowsHookExW},
{FALSE, 618, "SetWindowsHookW",               SetWindowsHookW},
{FALSE, 619, "ShowCaret",                     ShowCaret},
{FALSE, 620, "ShowCursor",                    ShowCursor},
{FALSE, 621, "ShowOwnedPopups",               ShowOwnedPopups},
{FALSE, 622, "ShowScrollBar",                 ShowScrollBar},
{FALSE, 623, "ShowStartGlass",                ShowStartGlass},
{TRUE,  624, "ShowWindow",                    ShowWindow},
{FALSE, 625, "ShowWindowAsync",               ShowWindowAsync},
{FALSE, 626, "SoftModalMessageBox",           SoftModalMessageBox},
{FALSE, 627, "SubtractRect",                  SubtractRect},
{FALSE, 628, "SwapMouseButton",               SwapMouseButton},
{FALSE, 629, "SwitchDesktop",                 SwitchDesktop},
{FALSE, 630, "SwitchToThisWindow",            SwitchToThisWindow},
{TRUE,  631, "SystemParametersInfoA",         SystemParametersInfoA},
{TRUE,  632, "SystemParametersInfoW",         SystemParametersInfoW},
{FALSE, 633, "TabbedTextOutA",                TabbedTextOutA},
{FALSE, 634, "TabbedTextOutW",                TabbedTextOutW},
{FALSE, 635, "TileChildWindows",              TileChildWindows},
{FALSE, 636, "TileWindows",                   TileWindows},
{FALSE, 637, "ToAscii",                       ToAscii},
{FALSE, 638, "ToAsciiEx",                     ToAsciiEx},
{FALSE, 639, "ToUnicode",                     ToUnicode},
{FALSE, 640, "ToUnicodeEx",                   ToUnicodeEx},
{FALSE, 641, "TrackMouseEvent",               TrackMouseEvent},
{FALSE, 642, "TrackPopupMenu",                TrackPopupMenu},
{FALSE, 643, "TrackPopupMenuEx",              TrackPopupMenuEx},
{FALSE, 644, "TranslateAccelerator",          TranslateAcceleratorA},
{FALSE, 645, "TranslateAcceleratorA",         TranslateAcceleratorA},
{FALSE, 646, "TranslateAcceleratorW",         TranslateAcceleratorW},
{FALSE, 647, "TranslateMDISysAccel",          TranslateMDISysAccel},
{FALSE, 648, "TranslateMessage",              TranslateMessage},
{FALSE, 649, "TranslateMessageEx",            TranslateMessageEx},
{FALSE, 650, "UnhookWinEvent",                UnhookWinEvent},
{FALSE, 651, "UnhookWindowsHook",             UnhookWindowsHook},
{FALSE, 652, "UnhookWindowsHookEx",           UnhookWindowsHookEx},
{FALSE, 653, "UnionRect",                     UnionRect},
{FALSE, 654, "UnloadKeyboardLayout",          UnloadKeyboardLayout},
{FALSE, 655, "UnlockWindowStation",           UnlockWindowStation},
{FALSE, 656, "UnpackDDElParam",               UnpackDDElParam},
{FALSE, 657, "UnregisterClassA",              UnregisterClassA},
{FALSE, 658, "UnregisterClassW",              UnregisterClassW},
{FALSE, 659, "UnregisterDeviceNotification",  UnregisterDeviceNotification},
{FALSE, 660, "UnregisterHotKey",              UnregisterHotKey},
{FALSE, 661, "UpdateLayeredWindow",           UpdateLayeredWindow},
{FALSE, 662, "UpdatePerUserSystemParameters", UpdatePerUserSystemParameters},
{FALSE, 663, "UpdateWindow",                  UpdateWindow},
{FALSE, 664, "User32InitializeImmEntryTable", User32InitializeImmEntryTable},
{FALSE, 665, "UserClientDllInitialize",       UserClientDllInitialize},
{FALSE, 666, "UserHandleGrantAccess",         UserHandleGrantAccess},
{FALSE, 667, "UserLpkPSMTextOut",             UserLpkPSMTextOut},
{FALSE, 668, "UserLpkTabbedTextOut",          UserLpkTabbedTextOut},
{FALSE, 669, "UserRealizePalette",            UserRealizePalette},
{FALSE, 670, "UserRegisterWowHandlers",       UserRegisterWowHandlers},
{FALSE, 671, "VRipOutput",                    VRipOutput},
{FALSE, 672, "VTagOutput",                    VTagOutput},
{FALSE, 673, "ValidateRect",                  ValidateRect},
{FALSE, 674, "ValidateRgn",                   ValidateRgn},
{FALSE, 675, "VkKeyScanA",                    VkKeyScanA},
{FALSE, 676, "VkKeyScanExA",                  VkKeyScanExA},
{FALSE, 677, "VkKeyScanExW",                  VkKeyScanExW},
{FALSE, 678, "VkKeyScanW",                    VkKeyScanW},
{FALSE, 679, "WCSToMBEx",                     WCSToMBEx},
{FALSE, 680, "WINNLSEnableIME",               WINNLSEnableIME},
{FALSE, 681, "WINNLSGetEnableStatus",         WINNLSGetEnableStatus},
{FALSE, 682, "WINNLSGetIMEHotkey",            WINNLSGetIMEHotkey},
{FALSE, 683, "WaitForInputIdle",              WaitForInputIdle},
{FALSE, 684, "WaitMessage",                   WaitMessage},
{FALSE, 685, "Win32PoolAllocationStats",      Win32PoolAllocationStats},
{TRUE,  686, "WinHelpA",                      WinHelpA},
{TRUE,  687, "WinHelpW",                      WinHelpW},
{FALSE, 688, "WindowFromDC",                  WindowFromDC},
{FALSE, 689, "WindowFromPoint",               WindowFromPoint},
{FALSE, 690, "keybd_event",                   keybd_event},
{FALSE, 691, "mouse_event",                   mouse_event},
{TRUE,  692, "wsprintfA",                     wsprintfA},
{TRUE,  693, "wsprintfW",                     wsprintfW},
{TRUE,  694, "wvsprintfA",                    wvsprintfA},
{TRUE,  695, "wvsprintfW",                    wvsprintfW},
{FALSE,   0, NULL,                            NULL}};
