/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __WINSOCK_H__
#define __WINSOCK_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif /* HAVE_ARPA_INET_H */
#ifdef HAVE_ARPA_NAMESER_H
# include <arpa/nameser.h>
#endif /* HAVE_ARPA_NAMESER_H */
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif /* HAVE_NETDB_H */
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif /* HAVE_NETINET_IN_H */
#ifdef HAVE_RESOLV_H
# include <resolv.h>
#endif /* HAVE_RESOLV_H */
#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif /* HAVE_SYS_SELECT_H */
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif /* HAVE_SYS_SOCKET_H */
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#endif /* HAVE_SYS_TIME_H */
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif /* HAVE_UNISTD_H */

#define ERROR_INVALID_HANDLE    6
#define ERROR_NOT_ENOUGH_MEMORY 8
#define INVALID_SOCKET          (SOCKET)(~0)
#define MAXGETHOSTSTRUCT        1024
#define SOCKET_ERROR            (-1)
#define TCP_NODELAY             1

#define FD_READ    0x00000001
#define FD_WRITE   0x00000002
#define FD_OOB     0x00000004
#define FD_ACCEPT  0x00000008
#define FD_CONNECT 0x00000010
#define FD_CLOSE   0x00000020

typedef UINT_PTR SOCKET;

#define WSADESCRIPTION_LEN 256
#define WSASYS_STATUS_LEN 128
#include "pshpack1.h"
typedef struct _WSAData
{
  WORD wVersion;
  WORD wHighVersion;
  CHAR szDescription[WSADESCRIPTION_LEN + 1];
  CHAR szSystemStatus[WSASYS_STATUS_LEN + 1];
  WORD iMaxSockets;
  WORD iMaxUdpDg;
  LPSTR lpVendorInfo;
} WSADATA, *PWSADATA, *LPWSADATA;
#include "poppack.h"

#define WSABASEERR             10000
#define WSAEINTR               (WSABASEERR+4)
#define WSAEBADF               (WSABASEERR+9)
#define WSAEACCES              (WSABASEERR+13)
#define WSAEFAULT              (WSABASEERR+14)
#define WSAEINVAL              (WSABASEERR+22)
#define WSAEMFILE              (WSABASEERR+24)
#define WSAEWOULDBLOCK         (WSABASEERR+35)
#define WSAEINPROGRESS         (WSABASEERR+36)
#define WSAEALREADY            (WSABASEERR+37)
#define WSAENOTSOCK            (WSABASEERR+38)
#define WSAEDESTADDRREQ        (WSABASEERR+39)
#define WSAEMSGSIZE            (WSABASEERR+40)
#define WSAEPROTOTYPE          (WSABASEERR+41)
#define WSAENOPROTOOPT         (WSABASEERR+42)
#define WSAEPROTONOSUPPORT     (WSABASEERR+43)
#define WSAESOCKTNOSUPPORT     (WSABASEERR+44)
#define WSAEOPNOTSUPP          (WSABASEERR+45)
#define WSAEPFNOSUPPORT        (WSABASEERR+46)
#define WSAEAFNOSUPPORT        (WSABASEERR+47)
#define WSAEADDRINUSE          (WSABASEERR+48)
#define WSAEADDRNOTAVAIL       (WSABASEERR+49)
#define WSAENETDOWN            (WSABASEERR+50)
#define WSAENETUNREACH         (WSABASEERR+51)
#define WSAENETRESET           (WSABASEERR+52)
#define WSAECONNABORTED        (WSABASEERR+53)
#define WSAECONNRESET          (WSABASEERR+54)
#define WSAENOBUFS             (WSABASEERR+55)
#define WSAEISCONN             (WSABASEERR+56)
#define WSAENOTCONN            (WSABASEERR+57)
#define WSAESHUTDOWN           (WSABASEERR+58)
#define WSAETOOMANYREFS        (WSABASEERR+59)
#define WSAETIMEDOUT           (WSABASEERR+60)
#define WSAECONNREFUSED        (WSABASEERR+61)
#define WSAELOOP               (WSABASEERR+62)
#define WSAENAMETOOLONG        (WSABASEERR+63)
#define WSAEHOSTDOWN           (WSABASEERR+64)
#define WSAEHOSTUNREACH        (WSABASEERR+65)
#define WSAENOTEMPTY           (WSABASEERR+66)
#define WSAEPROCLIM            (WSABASEERR+67)
#define WSAEUSERS              (WSABASEERR+68)
#define WSAEDQUOT              (WSABASEERR+69)
#define WSAESTALE              (WSABASEERR+70)
#define WSAEREMOTE             (WSABASEERR+71)
#define WSAEDISCON             (WSABASEERR+101)
#define WSASYSNOTREADY         (WSABASEERR+91)
#define WSAVERNOTSUPPORTED     (WSABASEERR+92)
#define WSANOTINITIALISED      (WSABASEERR+93)
#define WSAEDISCON             (WSABASEERR+101)
#define WSAENOMORE             (WSABASEERR+102)
#define WSAECANCELLED          (WSABASEERR+103)
#define WSAEINVALIDPROCTABLE   (WSABASEERR+104)
#define WSAEINVALIDPROVIDER    (WSABASEERR+105)
#define WSAEPROVIDERFAILEDINIT (WSABASEERR+106)
#define WSASYSCALLFAILURE      (WSABASEERR+107)
#define WSASERVICE_NOT_FOUND   (WSABASEERR+108)
#define WSATYPE_NOT_FOUND      (WSABASEERR+109)
#define WSA_E_NO_MORE          (WSABASEERR+110)
#define WSA_E_CANCELLED        (WSABASEERR+111)
#define WSAEREFUSED            (WSABASEERR+112)
#define WSAHOST_NOT_FOUND      (WSABASEERR+1001)
#define WSATRY_AGAIN           (WSABASEERR+1002)
#define WSANO_RECOVERY         (WSABASEERR+1003)
#define WSANO_DATA             (WSABASEERR+1004)


extern W32LdrExport winsock_exports[];


int WINAPI WSACleanup (void);
int WINAPI WSAGetLastError (void);
int WINAPI WSAStartup (WORD wVersionRequested, LPWSADATA lpWSAData);
int WINAPI closesocket (int sockfd);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WINSOCK_H__ */
