#!/usr/bin/perl
#
#   w32loader
#   copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

foreach (<STDIN>) {
  chomp;
  if (not $macro and /^#include\s+"(\w+)\.h"$/) {
    $export="$1_exports";
    $macro="__$1_H__";
    $macro=~tr/a-z/A-Z/;
  } elsif (/#ifdef\s+W32LDR_HEADER$/) {
    $header=1;
  } elsif (/#endif\s*\/\*\s+W32LDR_HEADER\s+\*\/$/) {
    undef $header;
  } elsif ($header) {
    $head.="$_\n";
  } elsif (/^\s*\/\*\s+(\w+)\s+ordinal\s*=\s*\d+,\s*argument\s*=\s*\d+\s+\*\/\s*$/) {
    $name=$1;
  } elsif ($name) {
    if (not /^\s*static\s+/) {
      exit -1 if $proto{$name};
      push @api,$name;
      $proto{$name}=$_;
    }
    undef $name;
  }
}
exit -1 if not $macro or $header or $name;
for (my $i=$#api;$i>=0;$i--) {
  if ($proto{"$api[$i]A"} and $proto{"$api[$i]W"}) {
    delete $proto{$api[$i]};
    splice @api,$i,1;
  }
}
for (my $i=0;$i<@api;$i++) {
  if ($api[$i]=~/^(\w+)(A|W)$/) {
    for (my $j=$i+1;$j<@api;$j++) {
      if ($api[$j] eq "$1A" or $api[$j] eq "$1W") {
        push @define,$1;
        last;
      }
    }
  }
}
$year=(localtime)[5]+1900;
print <<EOF;
/*
    w32loader
    copyright (c) 1998-$year Kazuki Iwamoto http://www.maid.org/ iwm\@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef $macro
#define $macro


#include "w32ldr.h"


G_BEGIN_DECLS


EOF
undef $year;
print "$head\n\n" if $head;
print "extern W32LdrExport w32ldr_$export\[\];\n";
if (@api) {
  print "\n\n";
  foreach (@api) {
    print $proto{$_};
    print ';' unless $proto{$_}=~/^\s*\/\*.*?\*\/\s*$/;
    print "\n";
  }
  undef @api;
  undef %proto;
}
if (@define) {
  print "\n\n#ifdef UNICODE\n";
  foreach (@define) {
    print "# define $_ ${_}W\n";
  }
  print "#else /* not UNICODE*/\n";
  foreach (@define) {
    print "# define $_ ${_}A\n";
  }
  print "#endif /* not UNICODE */\n";
  undef @define;
}
print <<EOF;


G_END_DECLS


#endif /* $macro */
EOF
