/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __RASAPI32_H__
#define __RASAPI32_H__


#include "w32ldr.h"


G_BEGIN_DECLS


#include "kernel32.h"

#define RAS_MaxCallbackNumber RAS_MaxPhoneNumber
#define RAS_MaxDeviceName     128
#define RAS_MaxDeviceType     16
#define RAS_MaxEntryName      256
#define RAS_MaxPhoneNumber    128

#define RASBASE                600
#define ERROR_BUFFER_TOO_SMALL (RASBASE+3)
#define ERROR_INVALID_SIZE     (RASBASE+32)

typedef LPVOID HRASCONN, *LPHRASCONN;

#include "pshpack4.h"
typedef struct _RASCONNA
{
  DWORD dwSize;
  HRASCONN hrasconn;
  CHAR szEntryName[RAS_MaxEntryName + 1];
  CHAR szDeviceType[RAS_MaxDeviceType + 1];
  CHAR szDeviceName[RAS_MaxDeviceName + 1];
  CHAR szPhonebook[MAX_PATH];
  DWORD dwSubEntry;
} RASCONNA, *LPRASCONNA;
typedef struct _RASCONNW
{
  DWORD dwSize;
  HRASCONN hrasconn;
  WCHAR szEntryName[RAS_MaxEntryName + 1];
  WCHAR szDeviceType[RAS_MaxDeviceType + 1];
  WCHAR szDeviceName[RAS_MaxDeviceName + 1];
  WCHAR szPhonebook[MAX_PATH];
  DWORD dwSubEntry;
} RASCONNW, *LPRASCONNW;
#include "poppack.h"
#ifdef UNICODE
# define RASCONN RASCONNW
# define LPRASCONN LPRASCONNW
#else /* not UNICODE */
# define RASCONN RASCONNA
# define LPRASCONN LPRASCONNA
#endif /* not UNICODE */

#include "pshpack4.h"
typedef struct _RASENTRYNAMEA
{
  DWORD dwSize;
  CHAR szEntryName[RAS_MaxEntryName + 1];
} RASENTRYNAMEA, *LPRASENTRYNAMEA;
typedef struct _RASENTRYNAMEW
{
  DWORD dwSize;
  WCHAR szEntryName[RAS_MaxEntryName + 1];
} RASENTRYNAMEW, *LPRASENTRYNAMEW;
#include "poppack.h"
#ifdef UNICODE
# define RASENTRYNAME RASENTRYNAMEW
# define LPRASENTRYNAME LPRASENTRYNAMEW
#else /* not UNICODE */
# define RASENTRYNAME RASENTRYNAMEA
# define LPRASENTRYNAME LPRASENTRYNAMEA
#endif /* not UNICODE */

#define UNLEN 256
#define PWLEN 256
#define DNLEN 15
#include "pshpack4.h"
typedef struct _RASDIALPARAMSA
{
  DWORD dwSize;
  CHAR szEntryName[RAS_MaxEntryName + 1];
  CHAR szPhoneNumber[RAS_MaxPhoneNumber + 1];
  CHAR szCallbackNumber[RAS_MaxCallbackNumber + 1];
  CHAR szUserName[UNLEN + 1];
  CHAR szPassword[PWLEN + 1];
  CHAR szDomain[DNLEN + 1];
  DWORD dwSubEntry;
  DWORD dwCallbackId;
} RASDIALPARAMSA, *LPRASDIALPARAMSA;
typedef struct _RASDIALPARAMSW
{
  DWORD dwSize;
  WCHAR szEntryName[RAS_MaxEntryName + 1];
  WCHAR szPhoneNumber[RAS_MaxPhoneNumber + 1];
  WCHAR szCallbackNumber[RAS_MaxCallbackNumber + 1];
  WCHAR szUserName[UNLEN + 1];
  WCHAR szPassword[PWLEN + 1];
  WCHAR szDomain[DNLEN + 1];
  DWORD dwSubEntry;
  DWORD dwCallbackId;
} RASDIALPARAMSW, *LPRASDIALPARAMSW;
#include "poppack.h"
#ifdef UNICODE
# define RASDIALPARAMS RASDIALPARAMSW
# define LPRASDIALPARAMS LPRASDIALPARAMSW
#else /* not UNICODE */
# define RASDIALPARAMS RASDIALPARAMSA
# define LPRASDIALPARAMS LPRASDIALPARAMSA
#endif /* not UNICODE */

#define RASCS_PAUSED 0x1000
#define RASCS_DONE   0x2000
typedef enum _RASCONNSTATE
{
  RASCS_OpenPort = 0,
  RASCS_PortOpened,
  RASCS_ConnectDevice,
  RASCS_DeviceConnected,
  RASCS_AllDevicesConnected,
  RASCS_Authenticate,
  RASCS_AuthNotify,
  RASCS_AuthRetry,
  RASCS_AuthCallback,
  RASCS_AuthChangePassword,
  RASCS_AuthProject,
  RASCS_AuthLinkSpeed,
  RASCS_AuthAck,
  RASCS_ReAuthenticate,
  RASCS_Authenticated,
  RASCS_PrepareForCallback,
  RASCS_WaitForModemReset,
  RASCS_WaitForCallback,
  RASCS_Projected,
  RASCS_StartAuthentication,
  RASCS_CallbackComplete,
  RASCS_LogonNetwork,
  RASCS_SubEntryConnected,
  RASCS_SubEntryDisconnected,
  RASCS_Interactive = RASCS_PAUSED,
  RASCS_RetryAuthentication,
  RASCS_CallbackSetByCaller,
  RASCS_PasswordExpired,
  RASCS_Connected = RASCS_DONE,
  RASCS_Disconnected
} RASCONNSTATE, *LPRASCONNSTATE;
#include "pshpack4.h"
typedef struct _RASCONNSTATUSA
{
  DWORD dwSize;
  RASCONNSTATE rasconnstate;
  DWORD dwError;
  CHAR szDeviceType[RAS_MaxDeviceType + 1];
  CHAR szDeviceName[RAS_MaxDeviceName + 1];
} RASCONNSTATUSA, *LPRASCONNSTATUSA;
typedef struct _RASCONNSTATUSW
{
  DWORD dwSize;
  RASCONNSTATE rasconnstate;
  DWORD dwError;
  WCHAR szDeviceType[RAS_MaxDeviceType + 1];
  WCHAR szDeviceName[RAS_MaxDeviceName + 1];
} RASCONNSTATUSW, *LPRASCONNSTATUSW;
#include "poppack.h"
#ifdef UNICODE
# define RASCONNSTATUS RASCONNSTATUSW
# define LPRASCONNSTATUS LPRASCONNSTATUSW
#else /* not UNICODE */
# define RASCONNSTATUS RASCONNSTATUSA
# define LPRASCONNSTATUS LPRASCONNSTATUSA
#endif /* not UNICODE */

#include "pshpack4.h"
typedef struct _RASDIALEXTENSIONS
{
  DWORD dwSize;
  DWORD dwfOptions;
  HWND hwndParent;
  ULONG_PTR reserved;
} RASDIALEXTENSIONS, *LPRASDIALEXTENSIONS;
#include "poppack.h"


extern W32LdrExport w32ldr_rasapi32_exports[];


G_END_DECLS


#endif /* __RASAPI32_H__ */
