/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "gdi32.h"
#include "kernel32.h"
#include "misc/pixbuf.h"


#ifdef W32LDR_HEADER
#define RGB(r,g,b) ((COLORREF)((BYTE)(r)|((BYTE)(g)<<8)|((BYTE)(b)<<16)))
#define GetRValue(rgb) ((BYTE)(rgb))
#define GetGValue(rgb) ((BYTE)((rgb)>>8))
#define GetBValue(rgb) ((BYTE)((rgb)>>16))
#define TRANSPARENT 1
#define OPAQUE      2
typedef LPVOID HGDIOBJ;
typedef DWORD COLORREF, *PCOLORREF, *LPCOLORREF;
#include <pshpack1.h>
typedef struct _SIZE
{
  LONG cx;
  LONG cy;
} SIZE, *PSIZE, *LPSIZE;
#include "poppack.h"
/* ja:ラスタオペレーションコード */
#define SRCCOPY     0xcc0020
#define SRCPAINT    0xee0086
#define SRCAND      0x8800c6
#define SRCINVERT   0x660046
#define SRCERASE    0x440328
#define NOTSRCCOPY  0x330008
#define NOTSRCERASE 0x1100a6
#define MERGECOPY   0xc000ca
#define MERGEPAINT  0xbb0226
#define PATCOPY     0xf00021
#define PATPAINT    0xfb0a09
#define PATINVERT   0x5a0049
#define DSTINVERT   0x550009
#define BLACKNESS   0x000042
#define WHITENESS   0xff0062
/* ja:ビットマップ */
#include <pshpack1.h>
typedef struct _BITMAP
{
  LONG bmType;
  LONG bmWidth;
  LONG bmHeight;
  LONG bmWidthBytes;
  WORD bmPlanes;
  WORD bmBitsPixel;
  LPVOID bmBits;
} BITMAP, *PBITMAP, *LPBITMAP;
typedef struct _PALETTEENTRY
{
  BYTE peRed;
  BYTE peGreen;
  BYTE peBlue;
  BYTE peFlags;
} PALETTEENTRY, *PPALETTEENTRY, *LPPALETTEENTRY;
#include "poppack.h"
/* ja:ブラシ */
typedef W32LdrBrush *HBRUSH;
/* ja:ペン */
typedef W32LdrPen *HPEN;
/* ja:フォント */
typedef W32LdrFont *HFONT;
#define FW_DONTCARE   0
#define FW_THIN       100
#define FW_EXTRALIGHT 200
#define FW_LIGHT      300
#define FW_NORMAL     400
#define FW_MEDIUM     500
#define FW_SEMIBOLD   600
#define FW_BOLD       700
#define FW_EXTRABOLD  800
#define FW_HEAVY      900
#define ANSI_CHARSET        0
#define DEFAULT_CHARSET     1
#define SYMBOL_CHARSET      2
#define SHIFTJIS_CHARSET    128
#define HANGEUL_CHARSET     129
#define GB2312_CHARSET      134
#define CHINESEBIG5_CHARSET 136
#define GREEK_CHARSET       161
#define TURKISH_CHARSET     162
#define HEBREW_CHARSET      177
#define ARABIC_CHARSET      178
#define BALTIC_CHARSET      186
#define RUSSIAN_CHARSET     204
#define EASTEUROPE_CHARSET  238
#define THAI_CHARSET        222
#define JOHAB_CHARSET       130
#define MAC_CHARSET         77
#define OEM_CHARSET         255
#define OUT_DEFAULT_PRECIS   0
#define OUT_STRING_PRECIS    1
#define OUT_CHARACTER_PRECIS 2
#define OUT_STROKE_PRECIS    3
#define OUT_TT_PRECIS        4
#define OUT_DEVICE_PRECIS    5
#define OUT_RASTER_PRECIS    6
#define OUT_TT_ONLY_PRECIS   7
#define OUT_OUTLINE_PRECIS   8
#define CLIP_DEFAULT_PRECIS   0x00
#define CLIP_CHARACTER_PRECIS 0x01
#define CLIP_STROKE_PRECIS    0x02
#define CLIP_MASK             0x0f
#define CLIP_LH_ANGLES        0x10
#define CLIP_TT_ALWAYS        0x20
#define CLIP_EMBEDDED         0x80
#define DEFAULT_QUALITY 0
#define DRAFT_QUALITY   1
#define PROOF_QUALITY   2
#define DEFAULT_PITCH  0x00
#define FIXED_PITCH    0x01
#define VARIABLE_PITCH 0x02
#define FF_DONTCARE   0x00
#define FF_ROMAN      0x10
#define FF_SWISS      0x20
#define FF_MODERN     0x30
#define FF_SCRIPT     0x40
#define FF_DECORATIVE 0x50
#define LF_FACESIZE 32
#include <pshpack1.h>
typedef struct _LOGFONTA
{
  LONG lfHeight;
  LONG lfWidth;
  LONG lfEscapement;
  LONG lfOrientation;
  LONG lfWeight;
  BYTE lfItalic;
  BYTE lfUnderline;
  BYTE lfStrikeOut;
  BYTE lfCharSet;
  BYTE lfOutPrecision;
  BYTE lfClipPrecision;
  BYTE lfQuality;
  BYTE lfPitchAndFamily;
  CHAR lfFaceName[LF_FACESIZE];
} LOGFONTA, *PLOGFONTA, *LPLOGFONTA;
typedef struct _LOGFONTW
{
  LONG lfHeight;
  LONG lfWidth;
  LONG lfEscapement;
  LONG lfOrientation;
  LONG lfWeight;
  BYTE lfItalic;
  BYTE lfUnderline;
  BYTE lfStrikeOut;
  BYTE lfCharSet;
  BYTE lfOutPrecision;
  BYTE lfClipPrecision;
  BYTE lfQuality;
  BYTE lfPitchAndFamily;
  WCHAR lfFaceName[LF_FACESIZE];
} LOGFONTW, *PLOGFONTW, *LPLOGFONTW;
#include "poppack.h"
#ifdef UNICODE
# define LOGFONT LOGFONTW
# define PLOGFONT PLOGFONTW
# define LPLOGFONT LPLOGFONTW
#else /* not UNICODE */
# define LOGFONT LOGFONTA
# define PLOGFONT PLOGFONTA
# define LPLOGFONT LPLOGFONTA
#endif /* not UNICODE */
#endif /* W32LDR_HEADER */


#ifndef PANGO_VERSION_CHECK
# define PANGO_VERSION_CHECK(major,minor,micro) 0
#endif /* not PANGO_VERSION_CHECK */


/* AbortDoc ordinal = 1, argument = 4 temporary */
static DWORD WINAPI AbortDoc (DWORD dwArgv0)
{
  return 0;
}


/* AbortPath ordinal = 2, argument = 4 temporary */
static DWORD WINAPI AbortPath (DWORD dwArgv0)
{
  return 0;
}


/* AddFontMemResourceEx ordinal = 3, argument = 16 temporary */
static DWORD WINAPI AddFontMemResourceEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* AddFontResourceA ordinal = 4, argument = 4 temporary */
static DWORD WINAPI AddFontResourceA (DWORD dwArgv0)
{
  return 0;
}


/* AddFontResourceExA ordinal = 5, argument = 12 temporary */
static DWORD WINAPI AddFontResourceExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AddFontResourceExW ordinal = 6, argument = 12 temporary */
static DWORD WINAPI AddFontResourceExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AddFontResourceTracking ordinal = 7, argument = 0 temporary */
static DWORD WINAPI AddFontResourceTracking (VOID)
{
  return 0;
}


/* AddFontResourceW ordinal = 8, argument = 4 temporary */
static DWORD WINAPI AddFontResourceW (DWORD dwArgv0)
{
  return 0;
}


/* AngleArc ordinal = 9, argument = 24 temporary */
static DWORD WINAPI AngleArc (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* AnimatePalette ordinal = 10, argument = 16 temporary */
static DWORD WINAPI AnimatePalette (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* AnyLinkedFonts ordinal = 11, argument = 0 temporary */
static DWORD WINAPI AnyLinkedFonts (VOID)
{
  return 0;
}


/* Arc ordinal = 12, argument = 36 temporary */
static DWORD WINAPI Arc (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* ArcTo ordinal = 13, argument = 36 temporary */
static DWORD WINAPI ArcTo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* BRUSHOBJ_hGetColorTransform ordinal = 14, argument = 0 temporary */
static DWORD WINAPI BRUSHOBJ_hGetColorTransform (VOID)
{
  return 0;
}


/* BRUSHOBJ_pvAllocRbrush ordinal = 15, argument = 0 temporary */
static DWORD WINAPI BRUSHOBJ_pvAllocRbrush (VOID)
{
  return 0;
}


/* BRUSHOBJ_pvGetRbrush ordinal = 16, argument = 0 temporary */
static DWORD WINAPI BRUSHOBJ_pvGetRbrush (VOID)
{
  return 0;
}


/* BRUSHOBJ_ulGetBrushColor ordinal = 17, argument = 0 temporary */
static DWORD WINAPI BRUSHOBJ_ulGetBrushColor (VOID)
{
  return 0;
}


/* BeginPath ordinal = 18, argument = 4 temporary */
static DWORD WINAPI BeginPath (DWORD dwArgv0)
{
  return 0;
}


/* BitBlt ordinal = 19, argument = 36 */
BOOL WINAPI BitBlt (HDC hdcDest, INT nXDest, INT nYDest, INT nWidth, INT nHeight, HDC hdcSrc, INT nXSrc, INT nYSrc, DWORD dwRop)
{
  GdkGC *gc;

  if (!hdcDest || !hdcDest->widget
        || !hdcSrc || (!hdcSrc->widget && !hdcSrc->pixbuf) || dwRop != SRCCOPY)
    return FALSE;
  gc = gdk_gc_new (hdcDest->widget->window);
  if (hdcSrc->widget)
    gdk_draw_drawable (hdcDest->widget->window, gc, hdcSrc->widget->window,
                                        hdcSrc->widget->allocation.x + nXSrc,
                                        hdcSrc->widget->allocation.y + nYSrc,
                                            nXDest, nYDest, nWidth, nHeight);
  else
#if GTK_CHECK_VERSION(2,2,0)
    gdk_draw_pixbuf (hdcDest->widget->window, gc, hdcSrc->pixbuf, nXSrc, nYSrc,
                    nXDest, nYDest, nWidth, nHeight, GDK_RGB_DITHER_MAX, 0, 0);
#else /* not GTK_CHECK_VERSION(2,2,0) */
    gdk_pixbuf_render_to_drawable (hdcSrc->pixbuf, hdcDest->widget->window, gc,
                    nXSrc, nYSrc,
                    nXDest, nYDest, nWidth, nHeight, GDK_RGB_DITHER_MAX, 0, 0);
#endif /* not GTK_CHECK_VERSION(2,2,0) */
  g_object_unref (G_OBJECT (gc));
  return TRUE;
}


/* CLIPOBJ_bEnum ordinal = 20, argument = 0 temporary */
static DWORD WINAPI CLIPOBJ_bEnum (VOID)
{
  return 0;
}


/* CLIPOBJ_cEnumStart ordinal = 21, argument = 0 temporary */
static DWORD WINAPI CLIPOBJ_cEnumStart (VOID)
{
  return 0;
}


/* CLIPOBJ_ppoGetPath ordinal = 22, argument = 0 temporary */
static DWORD WINAPI CLIPOBJ_ppoGetPath (VOID)
{
  return 0;
}


/* CancelDC ordinal = 23, argument = 4 temporary */
static DWORD WINAPI CancelDC (DWORD dwArgv0)
{
  return 0;
}


/* CheckColorsInGamut ordinal = 24, argument = 16 temporary */
static DWORD WINAPI CheckColorsInGamut (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ChoosePixelFormat ordinal = 25, argument = 8 temporary */
static DWORD WINAPI ChoosePixelFormat (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Chord ordinal = 26, argument = 36 temporary */
static DWORD WINAPI Chord (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* CloseEnhMetaFile ordinal = 27, argument = 4 temporary */
static DWORD WINAPI CloseEnhMetaFile (DWORD dwArgv0)
{
  return 0;
}


/* CloseFigure ordinal = 28, argument = 4 temporary */
static DWORD WINAPI CloseFigure (DWORD dwArgv0)
{
  return 0;
}


/* CloseMetaFile ordinal = 29, argument = 4 temporary */
static DWORD WINAPI CloseMetaFile (DWORD dwArgv0)
{
  return 0;
}


/* ColorCorrectPalette ordinal = 30, argument = 16 temporary */
static DWORD WINAPI ColorCorrectPalette (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ColorMatchToTarget ordinal = 31, argument = 12 temporary */
static DWORD WINAPI ColorMatchToTarget (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CombineRgn ordinal = 32, argument = 16 temporary */
static DWORD WINAPI CombineRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CombineTransform ordinal = 33, argument = 12 temporary */
static DWORD WINAPI CombineTransform (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CopyEnhMetaFileA ordinal = 34, argument = 8 temporary */
static DWORD WINAPI CopyEnhMetaFileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CopyEnhMetaFileW ordinal = 35, argument = 8 temporary */
static DWORD WINAPI CopyEnhMetaFileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CopyMetaFileA ordinal = 36, argument = 8 temporary */
static DWORD WINAPI CopyMetaFileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CopyMetaFileW ordinal = 37, argument = 8 temporary */
static DWORD WINAPI CopyMetaFileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateBitmap ordinal = 38, argument = 20 temporary */
static DWORD WINAPI CreateBitmap (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CreateBitmapIndirect ordinal = 39, argument = 4 temporary */
static DWORD WINAPI CreateBitmapIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreateBrushIndirect ordinal = 40, argument = 4 temporary */
static DWORD WINAPI CreateBrushIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreateColorSpaceA ordinal = 41, argument = 4 temporary */
static DWORD WINAPI CreateColorSpaceA (DWORD dwArgv0)
{
  return 0;
}


/* CreateColorSpaceW ordinal = 42, argument = 4 temporary */
static DWORD WINAPI CreateColorSpaceW (DWORD dwArgv0)
{
  return 0;
}


/* CreateCompatibleBitmap ordinal = 43, argument = 12 temporary */
static DWORD WINAPI CreateCompatibleBitmap (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateCompatibleDC ordinal = 44, argument = 4 */
HDC WINAPI CreateCompatibleDC (HDC hDC)
{
  W32LdrDC *w32dc;

  w32dc = g_malloc0 (sizeof (W32LdrDC));
  if (hDC)
    {
      w32dc->transparent = hDC->transparent;
      w32dc->fgcolor = hDC->fgcolor;
      w32dc->bgcolor = hDC->bgcolor;
      if (hDC->pixbuf)
        w32dc->pixbuf = gdk_pixbuf_copy (hDC->pixbuf);
      if (hDC->brush)
        w32dc->brush = w32ldr_brush_copy (hDC->brush);
      if (hDC->font)
        w32dc->font = w32ldr_font_copy (hDC->font);
      if (hDC->pen)
        w32dc->pen = w32ldr_pen_copy (hDC->pen);
    }
  else
    {
      w32dc->bgcolor.red = G_MAXUINT16;
      w32dc->bgcolor.green = G_MAXUINT16;
      w32dc->bgcolor.blue = G_MAXUINT16;
    }
  if (!w32dc->pixbuf)
    w32dc->pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 1, 1);
  if (!w32dc->brush)
    w32dc->brush = w32ldr_brush_new ();
  if (!w32dc->font)
    w32dc->font = w32ldr_font_new ();
  if (!w32dc->pen)
    w32dc->pen = w32ldr_pen_new ();
  return w32dc;
}


/* CreateDCA ordinal = 45, argument = 16 temporary */
static DWORD WINAPI CreateDCA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateDCW ordinal = 46, argument = 16 temporary */
static DWORD WINAPI CreateDCW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateDIBPatternBrush ordinal = 47, argument = 8 temporary */
static DWORD WINAPI CreateDIBPatternBrush (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateDIBPatternBrushPt ordinal = 48, argument = 8 temporary */
static DWORD WINAPI CreateDIBPatternBrushPt (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateDIBSection ordinal = 49, argument = 24 temporary */
static DWORD WINAPI CreateDIBSection (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CreateDIBitmap ordinal = 50, argument = 24 temporary */
static DWORD WINAPI CreateDIBitmap (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CreateDiscardableBitmap ordinal = 51, argument = 12 temporary */
static DWORD WINAPI CreateDiscardableBitmap (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateEllipticRgn ordinal = 52, argument = 16 temporary */
static DWORD WINAPI CreateEllipticRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateEllipticRgnIndirect ordinal = 53, argument = 4 temporary */
static DWORD WINAPI CreateEllipticRgnIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreateEnhMetaFileA ordinal = 54, argument = 16 temporary */
static DWORD WINAPI CreateEnhMetaFileA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateEnhMetaFileW ordinal = 55, argument = 16 temporary */
static DWORD WINAPI CreateEnhMetaFileW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateFontA ordinal = 56, argument = 56 */
HFONT WINAPI CreateFontA (INT nHeight, INT nWidth, INT nEscapement, INT nOrientation, INT nWeight, DWORD dwItalic, DWORD dwUnderline, DWORD dwStrikeOut, DWORD dwCharSet, DWORD dwOutPrecision, DWORD dwClipPrecision, DWORD dwQuality, DWORD dwPitchAndFamily, LPCSTR lpszFaceName)
{
  gchar *utf8str;
  gunichar2 *wc;
  HFONT hFont;

  utf8str = w32ldr_utf8_from_mb (lpszFaceName);
  wc = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  hFont = CreateFontW (nHeight, nWidth, nEscapement, nOrientation, nWeight, dwItalic, dwUnderline, dwStrikeOut, dwCharSet, dwOutPrecision, dwClipPrecision, dwQuality, dwPitchAndFamily, wc);
  g_free (wc);
  return hFont;
}


/* CreateFontIndirectA ordinal = 57, argument = 4 */
HFONT WINAPI CreateFontIndirectA (CONST LOGFONTA *lplf)
{
  return CreateFontA (lplf->lfHeight, lplf->lfWidth, lplf->lfEscapement, lplf->lfOrientation, lplf->lfWeight, lplf->lfItalic, lplf->lfUnderline, lplf->lfStrikeOut, lplf->lfCharSet, lplf->lfOutPrecision, lplf->lfClipPrecision, lplf->lfQuality, lplf->lfPitchAndFamily, lplf->lfFaceName);
}


/* CreateFontIndirectExA ordinal = 58, argument = 4 temporary */
static DWORD WINAPI CreateFontIndirectExA (DWORD dwArgv0)
{
  return 0;
}


/* CreateFontIndirectExW ordinal = 59, argument = 4 temporary */
static DWORD WINAPI CreateFontIndirectExW (DWORD dwArgv0)
{
  return 0;
}


/* CreateFontIndirectW ordinal = 60, argument = 4 */
HFONT WINAPI CreateFontIndirectW (CONST LOGFONTW *lplf)
{
  return CreateFontW (lplf->lfHeight, lplf->lfWidth, lplf->lfEscapement, lplf->lfOrientation, lplf->lfWeight, lplf->lfItalic, lplf->lfUnderline, lplf->lfStrikeOut, lplf->lfCharSet, lplf->lfOutPrecision, lplf->lfClipPrecision, lplf->lfQuality, lplf->lfPitchAndFamily, lplf->lfFaceName);
}


/* CreateFontW ordinal = 61, argument = 56 */
HFONT WINAPI CreateFontW (INT nHeight, INT nWidth, INT nEscapement, INT nOrientation, INT nWeight, DWORD dwItalic, DWORD dwUnderline, DWORD dwStrikeOut, DWORD dwCharSet, DWORD dwOutPrecision, DWORD dwClipPrecision, DWORD dwQuality, DWORD dwPitchAndFamily, LPCWSTR lpszFaceName)
{
  gchar *name;
  PangoFontDescription *desc;

  desc = pango_font_description_new ();
  name = lpszFaceName ? g_utf16_to_utf8 (lpszFaceName, -1, NULL, NULL, NULL)
                      : NULL;
  if (name)
    {
      pango_font_description_set_family (desc, name);
      g_free (name);
    }
  pango_font_description_set_style (desc, dwItalic
                                    ? PANGO_STYLE_NORMAL : PANGO_STYLE_ITALIC);
  pango_font_description_set_variant (desc, PANGO_VARIANT_NORMAL);
  pango_font_description_set_weight (desc, (PangoWeight)nWeight);
  pango_font_description_set_stretch (desc, PANGO_STRETCH_NORMAL);
#if PANGO_VERSION_CHECK(1,8,0)
  if (nHeight >= 0)
    pango_font_description_set_size (desc, nHeight * PANGO_SCALE);
  else
    pango_font_description_set_absolute_size (desc, -nHeight * PANGO_SCALE);
#else /* not PANGO_VERSION_CHECK(1,8,0) */
  pango_font_description_set_size (desc, ABS (nHeight) * PANGO_SCALE);
#endif /* not PANGO_VERSION_CHECK(1,8,0) */
#if PANGO_VERSION_CHECK(1,16,0)
  pango_font_description_set_gravity (desc, PANGO_GRAVITY_AUTO);
#endif /* PANGO_VERSION_CHECK(1,16,0) */
  return w32ldr_font_new_with_description (desc);
}


/* CreateHalftonePalette ordinal = 62, argument = 4 temporary */
static DWORD WINAPI CreateHalftonePalette (DWORD dwArgv0)
{
  return 0;
}


/* CreateHatchBrush ordinal = 63, argument = 8 temporary */
static DWORD WINAPI CreateHatchBrush (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateICA ordinal = 64, argument = 16 temporary */
static DWORD WINAPI CreateICA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateICW ordinal = 65, argument = 16 temporary */
static DWORD WINAPI CreateICW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateMetaFileA ordinal = 66, argument = 4 temporary */
static DWORD WINAPI CreateMetaFileA (DWORD dwArgv0)
{
  return 0;
}


/* CreateMetaFileW ordinal = 67, argument = 4 temporary */
static DWORD WINAPI CreateMetaFileW (DWORD dwArgv0)
{
  return 0;
}


/* CreatePalette ordinal = 68, argument = 4 temporary */
static DWORD WINAPI CreatePalette (DWORD dwArgv0)
{
  return 0;
}


/* CreatePatternBrush ordinal = 69, argument = 4 temporary */
static DWORD WINAPI CreatePatternBrush (DWORD dwArgv0)
{
  return 0;
}


/* CreatePen ordinal = 70, argument = 12 temporary */
static DWORD WINAPI CreatePen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreatePenIndirect ordinal = 71, argument = 4 temporary */
static DWORD WINAPI CreatePenIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreatePolyPolygonRgn ordinal = 72, argument = 16 temporary */
static DWORD WINAPI CreatePolyPolygonRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreatePolygonRgn ordinal = 73, argument = 12 temporary */
static DWORD WINAPI CreatePolygonRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateRectRgn ordinal = 74, argument = 16 temporary */
static DWORD WINAPI CreateRectRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateRectRgnIndirect ordinal = 75, argument = 4 temporary */
static DWORD WINAPI CreateRectRgnIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreateRoundRectRgn ordinal = 76, argument = 24 temporary */
static DWORD WINAPI CreateRoundRectRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CreateScalableFontResourceA ordinal = 77, argument = 16 temporary */
static DWORD WINAPI CreateScalableFontResourceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateScalableFontResourceW ordinal = 78, argument = 16 temporary */
static DWORD WINAPI CreateScalableFontResourceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateSolidBrush ordinal = 79, argument = 4 */
HBRUSH WINAPI CreateSolidBrush (COLORREF crColor)
{
  GdkColor color;

  color.pixel = 0;
  color.red = GetRValue (crColor) * 256;
  color.green = GetGValue (crColor) * 256;
  color.blue = GetBValue (crColor) * 256;
  return w32ldr_brush_new_with_color (&color);
}


/* DPtoLP ordinal = 80, argument = 12 temporary */
static DWORD WINAPI DPtoLP (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DeleteColorSpace ordinal = 81, argument = 4 temporary */
static DWORD WINAPI DeleteColorSpace (DWORD dwArgv0)
{
  return 0;
}


/* DeleteDC ordinal = 82, argument = 4 */
BOOL WINAPI DeleteDC (HDC hDC)
{
  if (!hDC || hDC->widget)
    return FALSE;
  if (hDC->pixbuf)
    g_object_unref (G_OBJECT (hDC->pixbuf));
  if (hDC->brush)
    g_object_unref (G_OBJECT (hDC->brush));
  if (hDC->font)
    g_object_unref (G_OBJECT (hDC->font));
  if (hDC->pen)
    g_object_unref (G_OBJECT (hDC->pen));
  g_free (hDC);
  return TRUE;
}


/* DeleteEnhMetaFile ordinal = 83, argument = 4 temporary */
static DWORD WINAPI DeleteEnhMetaFile (DWORD dwArgv0)
{
  return 0;
}


/* DeleteMetaFile ordinal = 84, argument = 4 temporary */
static DWORD WINAPI DeleteMetaFile (DWORD dwArgv0)
{
  return 0;
}


/* DeleteObject ordinal = 85, argument = 4 */
BOOL WINAPI DeleteObject (HGDIOBJ hObject)
{
  if (hObject && GDK_IS_PIXBUF (hObject))
    {
      g_object_unref (hObject);
      return TRUE;
    }
  return FALSE;
}


/* DescribePixelFormat ordinal = 86, argument = 16 temporary */
static DWORD WINAPI DescribePixelFormat (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DeviceCapabilitiesExA ordinal = 87, argument = 24 temporary */
static DWORD WINAPI DeviceCapabilitiesExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* DeviceCapabilitiesExW ordinal = 88, argument = 24 temporary */
static DWORD WINAPI DeviceCapabilitiesExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* DrawEscape ordinal = 89, argument = 16 temporary */
static DWORD WINAPI DrawEscape (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* Ellipse ordinal = 90, argument = 20 temporary */
static DWORD WINAPI Ellipse (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnableEUDC ordinal = 91, argument = 4 temporary */
static DWORD WINAPI EnableEUDC (DWORD dwArgv0)
{
  return 0;
}


/* EndDoc ordinal = 92, argument = 4 temporary */
static DWORD WINAPI EndDoc (DWORD dwArgv0)
{
  return 0;
}


/* EndFormPage ordinal = 93, argument = 4 temporary */
static DWORD WINAPI EndFormPage (DWORD dwArgv0)
{
  return 0;
}


/* EndPage ordinal = 94, argument = 4 temporary */
static DWORD WINAPI EndPage (DWORD dwArgv0)
{
  return 0;
}


/* EndPath ordinal = 95, argument = 4 temporary */
static DWORD WINAPI EndPath (DWORD dwArgv0)
{
  return 0;
}


/* EngAcquireSemaphore ordinal = 96, argument = 0 temporary */
static DWORD WINAPI EngAcquireSemaphore (VOID)
{
  return 0;
}


/* EngAlphaBlend ordinal = 97, argument = 0 temporary */
static DWORD WINAPI EngAlphaBlend (VOID)
{
  return 0;
}


/* EngAssociateSurface ordinal = 98, argument = 0 temporary */
static DWORD WINAPI EngAssociateSurface (VOID)
{
  return 0;
}


/* EngBitBlt ordinal = 99, argument = 0 temporary */
static DWORD WINAPI EngBitBlt (VOID)
{
  return 0;
}


/* EngCheckAbort ordinal = 100, argument = 0 temporary */
static DWORD WINAPI EngCheckAbort (VOID)
{
  return 0;
}


/* EngComputeGlyphSet ordinal = 101, argument = 0 temporary */
static DWORD WINAPI EngComputeGlyphSet (VOID)
{
  return 0;
}


/* EngCopyBits ordinal = 102, argument = 0 temporary */
static DWORD WINAPI EngCopyBits (VOID)
{
  return 0;
}


/* EngCreateBitmap ordinal = 103, argument = 0 temporary */
static DWORD WINAPI EngCreateBitmap (VOID)
{
  return 0;
}


/* EngCreateClip ordinal = 104, argument = 0 temporary */
static DWORD WINAPI EngCreateClip (VOID)
{
  return 0;
}


/* EngCreateDeviceBitmap ordinal = 105, argument = 0 temporary */
static DWORD WINAPI EngCreateDeviceBitmap (VOID)
{
  return 0;
}


/* EngCreateDeviceSurface ordinal = 106, argument = 0 temporary */
static DWORD WINAPI EngCreateDeviceSurface (VOID)
{
  return 0;
}


/* EngCreatePalette ordinal = 107, argument = 0 temporary */
static DWORD WINAPI EngCreatePalette (VOID)
{
  return 0;
}


/* EngCreateSemaphore ordinal = 108, argument = 0 temporary */
static DWORD WINAPI EngCreateSemaphore (VOID)
{
  return 0;
}


/* EngDeleteClip ordinal = 109, argument = 0 temporary */
static DWORD WINAPI EngDeleteClip (VOID)
{
  return 0;
}


/* EngDeletePalette ordinal = 110, argument = 0 temporary */
static DWORD WINAPI EngDeletePalette (VOID)
{
  return 0;
}


/* EngDeletePath ordinal = 111, argument = 0 temporary */
static DWORD WINAPI EngDeletePath (VOID)
{
  return 0;
}


/* EngDeleteSemaphore ordinal = 112, argument = 0 temporary */
static DWORD WINAPI EngDeleteSemaphore (VOID)
{
  return 0;
}


/* EngDeleteSurface ordinal = 113, argument = 0 temporary */
static DWORD WINAPI EngDeleteSurface (VOID)
{
  return 0;
}


/* EngEraseSurface ordinal = 114, argument = 0 temporary */
static DWORD WINAPI EngEraseSurface (VOID)
{
  return 0;
}


/* EngFillPath ordinal = 115, argument = 0 temporary */
static DWORD WINAPI EngFillPath (VOID)
{
  return 0;
}


/* EngFindResource ordinal = 116, argument = 0 temporary */
static DWORD WINAPI EngFindResource (VOID)
{
  return 0;
}


/* EngFreeModule ordinal = 117, argument = 0 temporary */
static DWORD WINAPI EngFreeModule (VOID)
{
  return 0;
}


/* EngGetCurrentCodePage ordinal = 118, argument = 0 temporary */
static DWORD WINAPI EngGetCurrentCodePage (VOID)
{
  return 0;
}


/* EngGetDriverName ordinal = 119, argument = 0 temporary */
static DWORD WINAPI EngGetDriverName (VOID)
{
  return 0;
}


/* EngGetPrinterDataFileName ordinal = 120, argument = 0 temporary */
static DWORD WINAPI EngGetPrinterDataFileName (VOID)
{
  return 0;
}


/* EngGradientFill ordinal = 121, argument = 0 temporary */
static DWORD WINAPI EngGradientFill (VOID)
{
  return 0;
}


/* EngLineTo ordinal = 122, argument = 0 temporary */
static DWORD WINAPI EngLineTo (VOID)
{
  return 0;
}


/* EngLoadModule ordinal = 123, argument = 0 temporary */
static DWORD WINAPI EngLoadModule (VOID)
{
  return 0;
}


/* EngLockSurface ordinal = 124, argument = 0 temporary */
static DWORD WINAPI EngLockSurface (VOID)
{
  return 0;
}


/* EngMarkBandingSurface ordinal = 125, argument = 0 temporary */
static DWORD WINAPI EngMarkBandingSurface (VOID)
{
  return 0;
}


/* EngMultiByteToUnicodeN ordinal = 126, argument = 0 temporary */
static DWORD WINAPI EngMultiByteToUnicodeN (VOID)
{
  return 0;
}


/* EngMultiByteToWideChar ordinal = 127, argument = 0 temporary */
static DWORD WINAPI EngMultiByteToWideChar (VOID)
{
  return 0;
}


/* EngPaint ordinal = 128, argument = 0 temporary */
static DWORD WINAPI EngPaint (VOID)
{
  return 0;
}


/* EngPlgBlt ordinal = 129, argument = 0 temporary */
static DWORD WINAPI EngPlgBlt (VOID)
{
  return 0;
}


/* EngQueryEMFInfo ordinal = 130, argument = 0 temporary */
static DWORD WINAPI EngQueryEMFInfo (VOID)
{
  return 0;
}


/* EngQueryLocalTime ordinal = 131, argument = 0 temporary */
static DWORD WINAPI EngQueryLocalTime (VOID)
{
  return 0;
}


/* EngReleaseSemaphore ordinal = 132, argument = 0 temporary */
static DWORD WINAPI EngReleaseSemaphore (VOID)
{
  return 0;
}


/* EngStretchBlt ordinal = 133, argument = 0 temporary */
static DWORD WINAPI EngStretchBlt (VOID)
{
  return 0;
}


/* EngStretchBltROP ordinal = 134, argument = 0 temporary */
static DWORD WINAPI EngStretchBltROP (VOID)
{
  return 0;
}


/* EngStrokeAndFillPath ordinal = 135, argument = 0 temporary */
static DWORD WINAPI EngStrokeAndFillPath (VOID)
{
  return 0;
}


/* EngStrokePath ordinal = 136, argument = 0 temporary */
static DWORD WINAPI EngStrokePath (VOID)
{
  return 0;
}


/* EngTextOut ordinal = 137, argument = 0 temporary */
static DWORD WINAPI EngTextOut (VOID)
{
  return 0;
}


/* EngTransparentBlt ordinal = 138, argument = 0 temporary */
static DWORD WINAPI EngTransparentBlt (VOID)
{
  return 0;
}


/* EngUnicodeToMultiByteN ordinal = 139, argument = 0 temporary */
static DWORD WINAPI EngUnicodeToMultiByteN (VOID)
{
  return 0;
}


/* EngUnlockSurface ordinal = 140, argument = 0 temporary */
static DWORD WINAPI EngUnlockSurface (VOID)
{
  return 0;
}


/* EngWideCharToMultiByte ordinal = 141, argument = 0 temporary */
static DWORD WINAPI EngWideCharToMultiByte (VOID)
{
  return 0;
}


/* EnumEnhMetaFile ordinal = 142, argument = 20 temporary */
static DWORD WINAPI EnumEnhMetaFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnumFontFamiliesA ordinal = 143, argument = 16 temporary */
static DWORD WINAPI EnumFontFamiliesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumFontFamiliesExA ordinal = 144, argument = 20 temporary */
static DWORD WINAPI EnumFontFamiliesExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnumFontFamiliesExW ordinal = 145, argument = 20 temporary */
static DWORD WINAPI EnumFontFamiliesExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnumFontFamiliesW ordinal = 146, argument = 16 temporary */
static DWORD WINAPI EnumFontFamiliesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumFontsA ordinal = 147, argument = 16 temporary */
static DWORD WINAPI EnumFontsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumFontsW ordinal = 148, argument = 16 temporary */
static DWORD WINAPI EnumFontsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumICMProfilesA ordinal = 149, argument = 12 temporary */
static DWORD WINAPI EnumICMProfilesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumICMProfilesW ordinal = 150, argument = 12 temporary */
static DWORD WINAPI EnumICMProfilesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumMetaFile ordinal = 151, argument = 16 temporary */
static DWORD WINAPI EnumMetaFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumObjects ordinal = 152, argument = 16 temporary */
static DWORD WINAPI EnumObjects (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EqualRgn ordinal = 153, argument = 8 temporary */
static DWORD WINAPI EqualRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Escape ordinal = 154, argument = 20 temporary */
static DWORD WINAPI Escape (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EudcLoadLinkW ordinal = 155, argument = 16 temporary */
static DWORD WINAPI EudcLoadLinkW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EudcUnloadLinkW ordinal = 156, argument = 8 temporary */
static DWORD WINAPI EudcUnloadLinkW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ExcludeClipRect ordinal = 157, argument = 20 temporary */
static DWORD WINAPI ExcludeClipRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ExtCreatePen ordinal = 158, argument = 20 temporary */
static DWORD WINAPI ExtCreatePen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ExtCreateRegion ordinal = 159, argument = 12 temporary */
static DWORD WINAPI ExtCreateRegion (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExtEscape ordinal = 160, argument = 24 temporary */
static DWORD WINAPI ExtEscape (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ExtFloodFill ordinal = 161, argument = 20 temporary */
static DWORD WINAPI ExtFloodFill (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ExtSelectClipRgn ordinal = 162, argument = 12 temporary */
static DWORD WINAPI ExtSelectClipRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExtTextOutA ordinal = 163, argument = 32 temporary */
static DWORD WINAPI ExtTextOutA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* ExtTextOutW ordinal = 164, argument = 32 temporary */
static DWORD WINAPI ExtTextOutW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* FONTOBJ_cGetAllGlyphHandles ordinal = 165, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_cGetAllGlyphHandles (VOID)
{
  return 0;
}


/* FONTOBJ_cGetGlyphs ordinal = 166, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_cGetGlyphs (VOID)
{
  return 0;
}


/* FONTOBJ_pQueryGlyphAttrs ordinal = 167, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_pQueryGlyphAttrs (VOID)
{
  return 0;
}


/* FONTOBJ_pfdg ordinal = 168, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_pfdg (VOID)
{
  return 0;
}


/* FONTOBJ_pifi ordinal = 169, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_pifi (VOID)
{
  return 0;
}


/* FONTOBJ_pvTrueTypeFontFile ordinal = 170, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_pvTrueTypeFontFile (VOID)
{
  return 0;
}


/* FONTOBJ_pxoGetXform ordinal = 171, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_pxoGetXform (VOID)
{
  return 0;
}


/* FONTOBJ_vGetInfo ordinal = 172, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_vGetInfo (VOID)
{
  return 0;
}


/* FillPath ordinal = 173, argument = 4 temporary */
static DWORD WINAPI FillPath (DWORD dwArgv0)
{
  return 0;
}


/* FillRgn ordinal = 174, argument = 12 temporary */
static DWORD WINAPI FillRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FixBrushOrgEx ordinal = 175, argument = 16 temporary */
static DWORD WINAPI FixBrushOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FlattenPath ordinal = 176, argument = 4 temporary */
static DWORD WINAPI FlattenPath (DWORD dwArgv0)
{
  return 0;
}


/* FloodFill ordinal = 177, argument = 16 temporary */
static DWORD WINAPI FloodFill (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FontIsLinked ordinal = 178, argument = 0 temporary */
static DWORD WINAPI FontIsLinked (VOID)
{
  return 0;
}


/* FrameRgn ordinal = 179, argument = 20 temporary */
static DWORD WINAPI FrameRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GdiAddFontResourceW ordinal = 180, argument = 0 temporary */
static DWORD WINAPI GdiAddFontResourceW (VOID)
{
  return 0;
}


/* GdiAddGlsBounds ordinal = 181, argument = 0 temporary */
static DWORD WINAPI GdiAddGlsBounds (VOID)
{
  return 0;
}


/* GdiAddGlsRecord ordinal = 182, argument = 0 temporary */
static DWORD WINAPI GdiAddGlsRecord (VOID)
{
  return 0;
}


/* GdiAlphaBlend ordinal = 183, argument = 0 temporary */
static DWORD WINAPI GdiAlphaBlend (VOID)
{
  return 0;
}


/* GdiArtificialDecrementDriver ordinal = 184, argument = 8 temporary */
static DWORD WINAPI GdiArtificialDecrementDriver (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GdiCleanCacheDC ordinal = 185, argument = 0 temporary */
static DWORD WINAPI GdiCleanCacheDC (VOID)
{
  return 0;
}


/* GdiComment ordinal = 186, argument = 12 temporary */
static DWORD WINAPI GdiComment (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GdiConsoleTextOut ordinal = 187, argument = 0 temporary */
static DWORD WINAPI GdiConsoleTextOut (VOID)
{
  return 0;
}


/* GdiConvertAndCheckDC ordinal = 188, argument = 0 temporary */
static DWORD WINAPI GdiConvertAndCheckDC (VOID)
{
  return 0;
}


/* GdiConvertBitmap ordinal = 189, argument = 0 temporary */
static DWORD WINAPI GdiConvertBitmap (VOID)
{
  return 0;
}


/* GdiConvertBitmapV5 ordinal = 190, argument = 0 temporary */
static DWORD WINAPI GdiConvertBitmapV5 (VOID)
{
  return 0;
}


/* GdiConvertBrush ordinal = 191, argument = 0 temporary */
static DWORD WINAPI GdiConvertBrush (VOID)
{
  return 0;
}


/* GdiConvertDC ordinal = 192, argument = 0 temporary */
static DWORD WINAPI GdiConvertDC (VOID)
{
  return 0;
}


/* GdiConvertEnhMetaFile ordinal = 193, argument = 0 temporary */
static DWORD WINAPI GdiConvertEnhMetaFile (VOID)
{
  return 0;
}


/* GdiConvertFont ordinal = 194, argument = 0 temporary */
static DWORD WINAPI GdiConvertFont (VOID)
{
  return 0;
}


/* GdiConvertMetaFilePict ordinal = 195, argument = 0 temporary */
static DWORD WINAPI GdiConvertMetaFilePict (VOID)
{
  return 0;
}


/* GdiConvertPalette ordinal = 196, argument = 0 temporary */
static DWORD WINAPI GdiConvertPalette (VOID)
{
  return 0;
}


/* GdiConvertRegion ordinal = 197, argument = 0 temporary */
static DWORD WINAPI GdiConvertRegion (VOID)
{
  return 0;
}


/* GdiConvertToDevmodeW ordinal = 198, argument = 0 temporary */
static DWORD WINAPI GdiConvertToDevmodeW (VOID)
{
  return 0;
}


/* GdiCreateLocalEnhMetaFile ordinal = 199, argument = 0 temporary */
static DWORD WINAPI GdiCreateLocalEnhMetaFile (VOID)
{
  return 0;
}


/* GdiCreateLocalMetaFilePict ordinal = 200, argument = 0 temporary */
static DWORD WINAPI GdiCreateLocalMetaFilePict (VOID)
{
  return 0;
}


/* GdiDeleteLocalDC ordinal = 201, argument = 0 temporary */
static DWORD WINAPI GdiDeleteLocalDC (VOID)
{
  return 0;
}


/* GdiDeleteSpoolFileHandle ordinal = 202, argument = 4 temporary */
static DWORD WINAPI GdiDeleteSpoolFileHandle (DWORD dwArgv0)
{
  return 0;
}


/* GdiDescribePixelFormat ordinal = 203, argument = 0 temporary */
static DWORD WINAPI GdiDescribePixelFormat (VOID)
{
  return 0;
}


/* GdiDllInitialize ordinal = 204, argument = 0 temporary */
static DWORD WINAPI GdiDllInitialize (VOID)
{
  return 0;
}


/* GdiEndDocEMF ordinal = 205, argument = 4 temporary */
static DWORD WINAPI GdiEndDocEMF (DWORD dwArgv0)
{
  return 0;
}


/* GdiEndPageEMF ordinal = 206, argument = 8 temporary */
static DWORD WINAPI GdiEndPageEMF (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GdiEntry1 ordinal = 214, argument = 0 temporary */
static DWORD WINAPI GdiEntry1 (VOID)
{
  return 0;
}


/* GdiEntry10 ordinal = 207, argument = 0 temporary */
static DWORD WINAPI GdiEntry10 (VOID)
{
  return 0;
}


/* GdiEntry11 ordinal = 208, argument = 0 temporary */
static DWORD WINAPI GdiEntry11 (VOID)
{
  return 0;
}


/* GdiEntry12 ordinal = 209, argument = 0 temporary */
static DWORD WINAPI GdiEntry12 (VOID)
{
  return 0;
}


/* GdiEntry13 ordinal = 210, argument = 0 temporary */
static DWORD WINAPI GdiEntry13 (VOID)
{
  return 0;
}


/* GdiEntry14 ordinal = 211, argument = 0 temporary */
static DWORD WINAPI GdiEntry14 (VOID)
{
  return 0;
}


/* GdiEntry15 ordinal = 212, argument = 0 temporary */
static DWORD WINAPI GdiEntry15 (VOID)
{
  return 0;
}


/* GdiEntry16 ordinal = 213, argument = 0 temporary */
static DWORD WINAPI GdiEntry16 (VOID)
{
  return 0;
}


/* GdiEntry2 ordinal = 215, argument = 0 temporary */
static DWORD WINAPI GdiEntry2 (VOID)
{
  return 0;
}


/* GdiEntry3 ordinal = 216, argument = 0 temporary */
static DWORD WINAPI GdiEntry3 (VOID)
{
  return 0;
}


/* GdiEntry4 ordinal = 217, argument = 0 temporary */
static DWORD WINAPI GdiEntry4 (VOID)
{
  return 0;
}


/* GdiEntry5 ordinal = 218, argument = 0 temporary */
static DWORD WINAPI GdiEntry5 (VOID)
{
  return 0;
}


/* GdiEntry6 ordinal = 219, argument = 0 temporary */
static DWORD WINAPI GdiEntry6 (VOID)
{
  return 0;
}


/* GdiEntry7 ordinal = 220, argument = 0 temporary */
static DWORD WINAPI GdiEntry7 (VOID)
{
  return 0;
}


/* GdiEntry8 ordinal = 221, argument = 0 temporary */
static DWORD WINAPI GdiEntry8 (VOID)
{
  return 0;
}


/* GdiEntry9 ordinal = 222, argument = 0 temporary */
static DWORD WINAPI GdiEntry9 (VOID)
{
  return 0;
}


/* GdiFixUpHandle ordinal = 223, argument = 0 temporary */
static DWORD WINAPI GdiFixUpHandle (VOID)
{
  return 0;
}


/* GdiFlush ordinal = 224, argument = 0 temporary */
static DWORD WINAPI GdiFlush (VOID)
{
  return 0;
}


/* GdiFullscreenControl ordinal = 225, argument = 0 temporary */
static DWORD WINAPI GdiFullscreenControl (VOID)
{
  return 0;
}


/* GdiGetBatchLimit ordinal = 226, argument = 0 temporary */
static DWORD WINAPI GdiGetBatchLimit (VOID)
{
  return 0;
}


/* GdiGetCharDimensions ordinal = 227, argument = 0 temporary */
static DWORD WINAPI GdiGetCharDimensions (VOID)
{
  return 0;
}


/* GdiGetCodePage ordinal = 228, argument = 0 temporary */
static DWORD WINAPI GdiGetCodePage (VOID)
{
  return 0;
}


/* GdiGetDC ordinal = 229, argument = 4 temporary */
static DWORD WINAPI GdiGetDC (DWORD dwArgv0)
{
  return 0;
}


/* GdiGetDevmodeForPage ordinal = 230, argument = 16 temporary */
static DWORD WINAPI GdiGetDevmodeForPage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GdiGetLocalBrush ordinal = 231, argument = 0 temporary */
static DWORD WINAPI GdiGetLocalBrush (VOID)
{
  return 0;
}


/* GdiGetLocalDC ordinal = 232, argument = 0 temporary */
static DWORD WINAPI GdiGetLocalDC (VOID)
{
  return 0;
}


/* GdiGetLocalFont ordinal = 233, argument = 0 temporary */
static DWORD WINAPI GdiGetLocalFont (VOID)
{
  return 0;
}


/* GdiGetPageCount ordinal = 234, argument = 4 temporary */
static DWORD WINAPI GdiGetPageCount (DWORD dwArgv0)
{
  return 0;
}


/* GdiGetPageHandle ordinal = 235, argument = 12 temporary */
static DWORD WINAPI GdiGetPageHandle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GdiGetSpoolFileHandle ordinal = 236, argument = 12 temporary */
static DWORD WINAPI GdiGetSpoolFileHandle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GdiGetSpoolMessage ordinal = 237, argument = 0 temporary */
static DWORD WINAPI GdiGetSpoolMessage (VOID)
{
  return 0;
}


/* GdiGradientFill ordinal = 238, argument = 0 temporary */
static DWORD WINAPI GdiGradientFill (VOID)
{
  return 0;
}


/* GdiInitSpool ordinal = 239, argument = 0 temporary */
static DWORD WINAPI GdiInitSpool (VOID)
{
  return 0;
}


/* GdiInitializeLanguagePack ordinal = 240, argument = 0 temporary */
static DWORD WINAPI GdiInitializeLanguagePack (VOID)
{
  return 0;
}


/* GdiIsMetaFileDC ordinal = 241, argument = 0 temporary */
static DWORD WINAPI GdiIsMetaFileDC (VOID)
{
  return 0;
}


/* GdiIsMetaPrintDC ordinal = 242, argument = 0 temporary */
static DWORD WINAPI GdiIsMetaPrintDC (VOID)
{
  return 0;
}


/* GdiIsPlayMetafileDC ordinal = 243, argument = 0 temporary */
static DWORD WINAPI GdiIsPlayMetafileDC (VOID)
{
  return 0;
}


/* GdiPlayDCScript ordinal = 244, argument = 24 temporary */
static DWORD WINAPI GdiPlayDCScript (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GdiPlayEMF ordinal = 245, argument = 20 temporary */
static DWORD WINAPI GdiPlayEMF (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GdiPlayJournal ordinal = 246, argument = 20 temporary */
static DWORD WINAPI GdiPlayJournal (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GdiPlayPageEMF ordinal = 247, argument = 20 temporary */
static DWORD WINAPI GdiPlayPageEMF (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GdiPlayPrivatePageEMF ordinal = 248, argument = 12 temporary */
static DWORD WINAPI GdiPlayPrivatePageEMF (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GdiPlayScript ordinal = 249, argument = 28 temporary */
static DWORD WINAPI GdiPlayScript (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GdiPrinterThunk ordinal = 250, argument = 0 temporary */
static DWORD WINAPI GdiPrinterThunk (VOID)
{
  return 0;
}


/* GdiProcessSetup ordinal = 251, argument = 0 temporary */
static DWORD WINAPI GdiProcessSetup (VOID)
{
  return 0;
}


/* GdiQueryFonts ordinal = 252, argument = 0 temporary */
static DWORD WINAPI GdiQueryFonts (VOID)
{
  return 0;
}


/* GdiQueryTable ordinal = 253, argument = 0 temporary */
static DWORD WINAPI GdiQueryTable (VOID)
{
  return 0;
}


/* GdiRealizationInfo ordinal = 254, argument = 0 temporary */
static DWORD WINAPI GdiRealizationInfo (VOID)
{
  return 0;
}


/* GdiReleaseDC ordinal = 255, argument = 0 temporary */
static DWORD WINAPI GdiReleaseDC (VOID)
{
  return 0;
}


/* GdiReleaseLocalDC ordinal = 256, argument = 0 temporary */
static DWORD WINAPI GdiReleaseLocalDC (VOID)
{
  return 0;
}


/* GdiResetDCEMF ordinal = 257, argument = 8 temporary */
static DWORD WINAPI GdiResetDCEMF (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GdiSetAttrs ordinal = 258, argument = 0 temporary */
static DWORD WINAPI GdiSetAttrs (VOID)
{
  return 0;
}


/* GdiSetBatchLimit ordinal = 259, argument = 4 temporary */
static DWORD WINAPI GdiSetBatchLimit (DWORD dwArgv0)
{
  return 0;
}


/* GdiSetLastError ordinal = 260, argument = 0 temporary */
static DWORD WINAPI GdiSetLastError (VOID)
{
  return 0;
}


/* GdiSetPixelFormat ordinal = 261, argument = 0 temporary */
static DWORD WINAPI GdiSetPixelFormat (VOID)
{
  return 0;
}


/* GdiSetServerAttr ordinal = 262, argument = 0 temporary */
static DWORD WINAPI GdiSetServerAttr (VOID)
{
  return 0;
}


/* GdiStartDocEMF ordinal = 263, argument = 8 temporary */
static DWORD WINAPI GdiStartDocEMF (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GdiStartPageEMF ordinal = 264, argument = 4 temporary */
static DWORD WINAPI GdiStartPageEMF (DWORD dwArgv0)
{
  return 0;
}


/* GdiSwapBuffers ordinal = 265, argument = 0 temporary */
static DWORD WINAPI GdiSwapBuffers (VOID)
{
  return 0;
}


/* GdiTransparentBlt ordinal = 266, argument = 0 temporary */
static DWORD WINAPI GdiTransparentBlt (VOID)
{
  return 0;
}


/* GdiValidateHandle ordinal = 267, argument = 0 temporary */
static DWORD WINAPI GdiValidateHandle (VOID)
{
  return 0;
}


/* GetArcDirection ordinal = 268, argument = 4 temporary */
static DWORD WINAPI GetArcDirection (DWORD dwArgv0)
{
  return 0;
}


/* GetAspectRatioFilterEx ordinal = 269, argument = 8 temporary */
static DWORD WINAPI GetAspectRatioFilterEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetBitmapBits ordinal = 270, argument = 12 temporary */
static DWORD WINAPI GetBitmapBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetBitmapDimensionEx ordinal = 271, argument = 8 temporary */
static DWORD WINAPI GetBitmapDimensionEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetBkColor ordinal = 272, argument = 4 */
COLORREF WINAPI GetBkColor (HDC hDC)
{
  return RGB (hDC->bgcolor.red / 256,
              hDC->bgcolor.green / 256,
              hDC->bgcolor.blue / 256);
}


/* GetBkMode ordinal = 273, argument = 4 */
INT WINAPI GetBkMode (HDC hDC)
{
  return hDC->transparent ? TRANSPARENT : OPAQUE;
}


/* GetBoundsRect ordinal = 274, argument = 12 temporary */
static DWORD WINAPI GetBoundsRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetBrushOrgEx ordinal = 275, argument = 8 temporary */
static DWORD WINAPI GetBrushOrgEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCharABCWidthsA ordinal = 276, argument = 16 temporary */
static DWORD WINAPI GetCharABCWidthsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharABCWidthsFloatA ordinal = 277, argument = 16 temporary */
static DWORD WINAPI GetCharABCWidthsFloatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharABCWidthsFloatW ordinal = 278, argument = 16 temporary */
static DWORD WINAPI GetCharABCWidthsFloatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharABCWidthsI ordinal = 279, argument = 20 temporary */
static DWORD WINAPI GetCharABCWidthsI (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetCharABCWidthsW ordinal = 280, argument = 16 temporary */
static DWORD WINAPI GetCharABCWidthsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidth32A ordinal = 281, argument = 16 temporary */
static DWORD WINAPI GetCharWidth32A (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidth32W ordinal = 282, argument = 16 temporary */
static DWORD WINAPI GetCharWidth32W (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidthA ordinal = 283, argument = 16 temporary */
static DWORD WINAPI GetCharWidthA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidthFloatA ordinal = 284, argument = 16 temporary */
static DWORD WINAPI GetCharWidthFloatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidthFloatW ordinal = 285, argument = 16 temporary */
static DWORD WINAPI GetCharWidthFloatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidthI ordinal = 286, argument = 20 temporary */
static DWORD WINAPI GetCharWidthI (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetCharWidthInfo ordinal = 287, argument = 0 temporary */
static DWORD WINAPI GetCharWidthInfo (VOID)
{
  return 0;
}


/* GetCharWidthW ordinal = 288, argument = 16 temporary */
static DWORD WINAPI GetCharWidthW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharacterPlacementA ordinal = 289, argument = 24 temporary */
static DWORD WINAPI GetCharacterPlacementA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetCharacterPlacementW ordinal = 290, argument = 24 temporary */
static DWORD WINAPI GetCharacterPlacementW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetClipBox ordinal = 291, argument = 8 temporary */
static DWORD WINAPI GetClipBox (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetClipRgn ordinal = 292, argument = 8 temporary */
static DWORD WINAPI GetClipRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetColorAdjustment ordinal = 293, argument = 8 temporary */
static DWORD WINAPI GetColorAdjustment (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetColorSpace ordinal = 294, argument = 4 temporary */
static DWORD WINAPI GetColorSpace (DWORD dwArgv0)
{
  return 0;
}


/* GetCurrentObject ordinal = 295, argument = 8 temporary */
static DWORD WINAPI GetCurrentObject (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCurrentPositionEx ordinal = 296, argument = 8 temporary */
static DWORD WINAPI GetCurrentPositionEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetDCBrushColor ordinal = 297, argument = 4 temporary */
static DWORD WINAPI GetDCBrushColor (DWORD dwArgv0)
{
  return 0;
}


/* GetDCOrgEx ordinal = 298, argument = 8 temporary */
static DWORD WINAPI GetDCOrgEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetDCPenColor ordinal = 299, argument = 4 temporary */
static DWORD WINAPI GetDCPenColor (DWORD dwArgv0)
{
  return 0;
}


/* GetDIBColorTable ordinal = 300, argument = 16 temporary */
static DWORD WINAPI GetDIBColorTable (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetDIBits ordinal = 301, argument = 28 temporary */
static DWORD WINAPI GetDIBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetDeviceCaps ordinal = 302, argument = 8 */
INT WINAPI GetDeviceCaps (HDC hDC, INT nIndex)
{
  return 0;
}


/* GetDeviceGammaRamp ordinal = 303, argument = 8 temporary */
static DWORD WINAPI GetDeviceGammaRamp (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetETM ordinal = 304, argument = 0 temporary */
static DWORD WINAPI GetETM (VOID)
{
  return 0;
}


/* GetEUDCTimeStamp ordinal = 305, argument = 0 temporary */
static DWORD WINAPI GetEUDCTimeStamp (VOID)
{
  return 0;
}


/* GetEUDCTimeStampExW ordinal = 306, argument = 0 temporary */
static DWORD WINAPI GetEUDCTimeStampExW (VOID)
{
  return 0;
}


/* GetEnhMetaFileA ordinal = 307, argument = 4 temporary */
static DWORD WINAPI GetEnhMetaFileA (DWORD dwArgv0)
{
  return 0;
}


/* GetEnhMetaFileBits ordinal = 308, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFileBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFileDescriptionA ordinal = 309, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFileDescriptionA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFileDescriptionW ordinal = 310, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFileDescriptionW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFileHeader ordinal = 311, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFileHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFilePaletteEntries ordinal = 312, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFilePaletteEntries (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFilePixelFormat ordinal = 313, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFilePixelFormat (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFileW ordinal = 314, argument = 4 temporary */
static DWORD WINAPI GetEnhMetaFileW (DWORD dwArgv0)
{
  return 0;
}


/* GetFontAssocStatus ordinal = 315, argument = 4 temporary */
static DWORD WINAPI GetFontAssocStatus (DWORD dwArgv0)
{
  return 0;
}


/* GetFontData ordinal = 316, argument = 20 temporary */
static DWORD WINAPI GetFontData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetFontLanguageInfo ordinal = 317, argument = 4 temporary */
static DWORD WINAPI GetFontLanguageInfo (DWORD dwArgv0)
{
  return 0;
}


/* GetFontResourceInfoW ordinal = 318, argument = 16 temporary */
static DWORD WINAPI GetFontResourceInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetFontUnicodeRanges ordinal = 319, argument = 8 temporary */
static DWORD WINAPI GetFontUnicodeRanges (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetGlyphIndicesA ordinal = 320, argument = 20 temporary */
static DWORD WINAPI GetGlyphIndicesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetGlyphIndicesW ordinal = 321, argument = 20 temporary */
static DWORD WINAPI GetGlyphIndicesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetGlyphOutline ordinal = 322, argument = 28 temporary */
/* DWORD WINAPI GetGlyphOutline (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6) */


/* GetGlyphOutlineA ordinal = 323, argument = 28 temporary */
static DWORD WINAPI GetGlyphOutlineA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetGlyphOutlineW ordinal = 324, argument = 28 temporary */
static DWORD WINAPI GetGlyphOutlineW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetGlyphOutlineWow ordinal = 325, argument = 0 temporary */
static DWORD WINAPI GetGlyphOutlineWow (VOID)
{
  return 0;
}


/* GetGraphicsMode ordinal = 326, argument = 4 temporary */
static DWORD WINAPI GetGraphicsMode (DWORD dwArgv0)
{
  return 0;
}


/* GetHFONT ordinal = 327, argument = 0 temporary */
static DWORD WINAPI GetHFONT (VOID)
{
  return 0;
}


/* GetICMProfileA ordinal = 328, argument = 12 temporary */
static DWORD WINAPI GetICMProfileA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetICMProfileW ordinal = 329, argument = 12 temporary */
static DWORD WINAPI GetICMProfileW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetKerningPairs ordinal = 330, argument = 12 temporary */
/* DWORD WINAPI GetKerningPairs (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2) */


/* GetKerningPairsA ordinal = 331, argument = 12 temporary */
static DWORD WINAPI GetKerningPairsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetKerningPairsW ordinal = 332, argument = 12 temporary */
static DWORD WINAPI GetKerningPairsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetLayout ordinal = 333, argument = 4 temporary */
static DWORD WINAPI GetLayout (DWORD dwArgv0)
{
  return 0;
}


/* GetLogColorSpaceA ordinal = 334, argument = 12 temporary */
static DWORD WINAPI GetLogColorSpaceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetLogColorSpaceW ordinal = 335, argument = 12 temporary */
static DWORD WINAPI GetLogColorSpaceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetMapMode ordinal = 336, argument = 4 temporary */
static DWORD WINAPI GetMapMode (DWORD dwArgv0)
{
  return 0;
}


/* GetMetaFileA ordinal = 337, argument = 4 temporary */
static DWORD WINAPI GetMetaFileA (DWORD dwArgv0)
{
  return 0;
}


/* GetMetaFileBitsEx ordinal = 338, argument = 12 temporary */
static DWORD WINAPI GetMetaFileBitsEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetMetaFileW ordinal = 339, argument = 4 temporary */
static DWORD WINAPI GetMetaFileW (DWORD dwArgv0)
{
  return 0;
}


/* GetMetaRgn ordinal = 340, argument = 8 temporary */
static DWORD WINAPI GetMetaRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetMiterLimit ordinal = 341, argument = 8 temporary */
static DWORD WINAPI GetMiterLimit (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetNearestColor ordinal = 342, argument = 8 */
COLORREF WINAPI GetNearestColor (HDC hDC, COLORREF crColor)
{
  return crColor;
}


/* GetNearestPaletteIndex ordinal = 343, argument = 8 temporary */
static DWORD WINAPI GetNearestPaletteIndex (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetObjectA ordinal = 344, argument = 12 */
INT WINAPI GetObjectA (HGDIOBJ hObject, INT cbBuffer, LPVOID lpvObject)
{
  return GetObjectW (hObject, cbBuffer, lpvObject);
}


/* GetObjectType ordinal = 345, argument = 4 temporary */
static DWORD WINAPI GetObjectType (DWORD dwArgv0)
{
  return 0;
}


/* GetObjectW ordinal = 346, argument = 12 */
INT WINAPI GetObjectW (HGDIOBJ hObject, INT cbBuffer, LPVOID lpvObject)
{
  if (hObject && GDK_IS_PIXBUF (hObject))
    {
      if (!lpvObject)
        return sizeof (BITMAP);
      if (cbBuffer >= sizeof (BITMAP))
        {
          BitmapInfoHeader *bmih;

          bmih = pixbuf_to_bitmap (GDK_PIXBUF (hObject));
          if (bmih)
            {
              LPBITMAP lpBmp;

              lpBmp = lpvObject;
              lpBmp->bmType = 0;
              lpBmp->bmWidth = bmih_get_width (bmih);
              lpBmp->bmHeight = bmih_get_height (bmih);
              lpBmp->bmWidthBytes = (bmih_get_width (bmih) + 1) / 2 * 2;
              lpBmp->bmPlanes = bmih_get_planes (bmih);
              lpBmp->bmBitsPixel = bmih_get_bit_count (bmih);
              lpBmp->bmBits = NULL;
              g_free (bmih);
              return sizeof (BITMAP);
            }
        }
    }
  return 0;
}


/* GetOutlineTextMetricsA ordinal = 347, argument = 12 temporary */
static DWORD WINAPI GetOutlineTextMetricsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetOutlineTextMetricsW ordinal = 348, argument = 12 temporary */
static DWORD WINAPI GetOutlineTextMetricsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetPaletteEntries ordinal = 349, argument = 16 temporary */
static DWORD WINAPI GetPaletteEntries (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetPath ordinal = 350, argument = 16 temporary */
static DWORD WINAPI GetPath (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetPixel ordinal = 351, argument = 12 temporary */
static DWORD WINAPI GetPixel (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetPixelFormat ordinal = 352, argument = 4 temporary */
static DWORD WINAPI GetPixelFormat (DWORD dwArgv0)
{
  return 0;
}


/* GetPolyFillMode ordinal = 353, argument = 4 temporary */
static DWORD WINAPI GetPolyFillMode (DWORD dwArgv0)
{
  return 0;
}


/* GetROP2 ordinal = 354, argument = 4 temporary */
static DWORD WINAPI GetROP2 (DWORD dwArgv0)
{
  return 0;
}


/* GetRandomRgn ordinal = 355, argument = 12 temporary */
static DWORD WINAPI GetRandomRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetRasterizerCaps ordinal = 356, argument = 8 temporary */
static DWORD WINAPI GetRasterizerCaps (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetRegionData ordinal = 357, argument = 12 temporary */
static DWORD WINAPI GetRegionData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetRelAbs ordinal = 358, argument = 8 temporary */
static DWORD WINAPI GetRelAbs (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetRgnBox ordinal = 359, argument = 8 temporary */
static DWORD WINAPI GetRgnBox (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetStockObject ordinal = 360, argument = 4 temporary */
static DWORD WINAPI GetStockObject (DWORD dwArgv0)
{
  return 0;
}


/* GetStretchBltMode ordinal = 361, argument = 4 temporary */
static DWORD WINAPI GetStretchBltMode (DWORD dwArgv0)
{
  return 0;
}


/* GetStringBitmapA ordinal = 362, argument = 0 temporary */
static DWORD WINAPI GetStringBitmapA (VOID)
{
  return 0;
}


/* GetStringBitmapW ordinal = 363, argument = 0 temporary */
static DWORD WINAPI GetStringBitmapW (VOID)
{
  return 0;
}


/* GetSystemPaletteEntries ordinal = 364, argument = 16 */
UINT WINAPI GetSystemPaletteEntries (HDC hDC, UINT iStartIndex, UINT nEntries, LPPALETTEENTRY lppe)
{
  return 0;
}


/* GetSystemPaletteUse ordinal = 365, argument = 4 temporary */
static DWORD WINAPI GetSystemPaletteUse (DWORD dwArgv0)
{
  return 0;
}


/* GetTextAlign ordinal = 366, argument = 4 temporary */
static DWORD WINAPI GetTextAlign (DWORD dwArgv0)
{
  return 0;
}


/* GetTextCharacterExtra ordinal = 367, argument = 4 temporary */
static DWORD WINAPI GetTextCharacterExtra (DWORD dwArgv0)
{
  return 0;
}


/* GetTextCharset ordinal = 368, argument = 4 temporary */
static DWORD WINAPI GetTextCharset (DWORD dwArgv0)
{
  return 0;
}


/* GetTextCharsetInfo ordinal = 369, argument = 12 temporary */
static DWORD WINAPI GetTextCharsetInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetTextColor ordinal = 370, argument = 4 */
COLORREF WINAPI GetTextColor (HDC hDC)
{
  return RGB (hDC->fgcolor.red / 256,
              hDC->fgcolor.green / 256,
              hDC->fgcolor.blue / 256);
}


/* GetTextExtentExPointA ordinal = 371, argument = 28 temporary */
static DWORD WINAPI GetTextExtentExPointA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetTextExtentExPointI ordinal = 372, argument = 28 temporary */
static DWORD WINAPI GetTextExtentExPointI (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetTextExtentExPointW ordinal = 373, argument = 28 temporary */
static DWORD WINAPI GetTextExtentExPointW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetTextExtentExPointWPri ordinal = 374, argument = 0 temporary */
static DWORD WINAPI GetTextExtentExPointWPri (VOID)
{
  return 0;
}


/* GetTextExtentPoint32A ordinal = 375, argument = 16 */
BOOL WINAPI GetTextExtentPoint32A (HDC hDC, LPCSTR lpString, INT cbString, LPSIZE lpSize)
{
  gchar *utf8str;
  gunichar2 *string;
  BOOL fResult;

  utf8str = w32ldr_utf8_from_mb (lpString);
  string = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  fResult = GetTextExtentPoint32W (hDC, string, lstrlenW (string), lpSize);
  g_free (string);
  return fResult;
}


/* GetTextExtentPoint32W ordinal = 376, argument = 16 */
BOOL WINAPI GetTextExtentPoint32W (HDC hDC, LPCWSTR lpString, INT cbString, LPSIZE lpSize)
{
  int w, h;
  gchar *utf8str;
  PangoLayout *layout;
  const PangoFontDescription *desc;

  if (!hDC || !hDC->widget || !lpString || cbString <= 0 || !lpSize)
    return FALSE;
  utf8str = g_utf16_to_utf8 (lpString, cbString, NULL, NULL, NULL);
  layout = gtk_widget_create_pango_layout (hDC->widget, utf8str);
  g_free (utf8str);
  desc = w32ldr_font_get_description (hDC->font);
  if (desc)
    pango_layout_set_font_description (layout, desc);
  pango_layout_get_pixel_size (layout, &w, &h);
  lpSize->cx = w;
  lpSize->cy = h;
  g_object_unref (G_OBJECT (layout));
  return TRUE;
}


/* GetTextExtentPointA ordinal = 377, argument = 16 temporary */
static DWORD WINAPI GetTextExtentPointA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetTextExtentPointI ordinal = 378, argument = 16 temporary */
static DWORD WINAPI GetTextExtentPointI (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetTextExtentPointW ordinal = 379, argument = 16 temporary */
static DWORD WINAPI GetTextExtentPointW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetTextFaceA ordinal = 380, argument = 12 temporary */
static DWORD WINAPI GetTextFaceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetTextFaceAliasW ordinal = 381, argument = 0 temporary */
static DWORD WINAPI GetTextFaceAliasW (VOID)
{
  return 0;
}


/* GetTextFaceW ordinal = 382, argument = 12 temporary */
static DWORD WINAPI GetTextFaceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetTextMetricsA ordinal = 383, argument = 8 temporary */
static DWORD WINAPI GetTextMetricsA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTextMetricsW ordinal = 384, argument = 8 temporary */
static DWORD WINAPI GetTextMetricsW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTransform ordinal = 385, argument = 0 temporary */
static DWORD WINAPI GetTransform (VOID)
{
  return 0;
}


/* GetViewportExtEx ordinal = 386, argument = 8 temporary */
static DWORD WINAPI GetViewportExtEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetViewportOrgEx ordinal = 387, argument = 8 temporary */
static DWORD WINAPI GetViewportOrgEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWinMetaFileBits ordinal = 388, argument = 20 temporary */
static DWORD WINAPI GetWinMetaFileBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetWindowExtEx ordinal = 389, argument = 8 temporary */
static DWORD WINAPI GetWindowExtEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWindowOrgEx ordinal = 390, argument = 8 temporary */
static DWORD WINAPI GetWindowOrgEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWorldTransform ordinal = 391, argument = 8 temporary */
static DWORD WINAPI GetWorldTransform (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* HT_Get8BPPFormatPalette ordinal = 392, argument = 0 temporary */
static DWORD WINAPI HT_Get8BPPFormatPalette (VOID)
{
  return 0;
}


/* HT_Get8BPPMaskPalette ordinal = 393, argument = 0 temporary */
static DWORD WINAPI HT_Get8BPPMaskPalette (VOID)
{
  return 0;
}


/* IntersectClipRect ordinal = 394, argument = 20 temporary */
static DWORD WINAPI IntersectClipRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* InvertRgn ordinal = 395, argument = 8 temporary */
static DWORD WINAPI InvertRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsValidEnhMetaRecord ordinal = 396, argument = 0 temporary */
static DWORD WINAPI IsValidEnhMetaRecord (VOID)
{
  return 0;
}


/* IsValidEnhMetaRecordOffExt ordinal = 397, argument = 0 temporary */
static DWORD WINAPI IsValidEnhMetaRecordOffExt (VOID)
{
  return 0;
}


/* LPtoDP ordinal = 398, argument = 12 temporary */
static DWORD WINAPI LPtoDP (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LineDDA ordinal = 399, argument = 24 temporary */
static DWORD WINAPI LineDDA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* LineTo ordinal = 400, argument = 12 temporary */
static DWORD WINAPI LineTo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MaskBlt ordinal = 401, argument = 48 temporary */
static DWORD WINAPI MaskBlt (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* MirrorRgn ordinal = 402, argument = 0 temporary */
static DWORD WINAPI MirrorRgn (VOID)
{
  return 0;
}


/* ModifyWorldTransform ordinal = 403, argument = 12 temporary */
static DWORD WINAPI ModifyWorldTransform (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MoveToEx ordinal = 404, argument = 16 temporary */
static DWORD WINAPI MoveToEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* NamedEscape ordinal = 405, argument = 0 temporary */
static DWORD WINAPI NamedEscape (VOID)
{
  return 0;
}


/* OffsetClipRgn ordinal = 406, argument = 12 temporary */
static DWORD WINAPI OffsetClipRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OffsetRgn ordinal = 407, argument = 12 temporary */
static DWORD WINAPI OffsetRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OffsetViewportOrgEx ordinal = 408, argument = 16 temporary */
static DWORD WINAPI OffsetViewportOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* OffsetWindowOrgEx ordinal = 409, argument = 16 temporary */
static DWORD WINAPI OffsetWindowOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PATHOBJ_bEnum ordinal = 410, argument = 0 temporary */
static DWORD WINAPI PATHOBJ_bEnum (VOID)
{
  return 0;
}


/* PATHOBJ_bEnumClipLines ordinal = 411, argument = 0 temporary */
static DWORD WINAPI PATHOBJ_bEnumClipLines (VOID)
{
  return 0;
}


/* PATHOBJ_vEnumStart ordinal = 412, argument = 0 temporary */
static DWORD WINAPI PATHOBJ_vEnumStart (VOID)
{
  return 0;
}


/* PATHOBJ_vEnumStartClipLines ordinal = 413, argument = 0 temporary */
static DWORD WINAPI PATHOBJ_vEnumStartClipLines (VOID)
{
  return 0;
}


/* PATHOBJ_vGetBounds ordinal = 414, argument = 0 temporary */
static DWORD WINAPI PATHOBJ_vGetBounds (VOID)
{
  return 0;
}


/* PaintRgn ordinal = 415, argument = 8 temporary */
static DWORD WINAPI PaintRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* PatBlt ordinal = 416, argument = 24 temporary */
static DWORD WINAPI PatBlt (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* PathToRegion ordinal = 417, argument = 4 temporary */
static DWORD WINAPI PathToRegion (DWORD dwArgv0)
{
  return 0;
}


/* Pie ordinal = 418, argument = 36 temporary */
static DWORD WINAPI Pie (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* PlayEnhMetaFile ordinal = 419, argument = 12 temporary */
static DWORD WINAPI PlayEnhMetaFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PlayEnhMetaFileRecord ordinal = 420, argument = 16 temporary */
static DWORD WINAPI PlayEnhMetaFileRecord (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PlayMetaFile ordinal = 421, argument = 8 temporary */
static DWORD WINAPI PlayMetaFile (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* PlayMetaFileRecord ordinal = 422, argument = 16 temporary */
static DWORD WINAPI PlayMetaFileRecord (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PlgBlt ordinal = 423, argument = 40 temporary */
static DWORD WINAPI PlgBlt (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* PolyBezier ordinal = 424, argument = 12 temporary */
static DWORD WINAPI PolyBezier (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PolyBezierTo ordinal = 425, argument = 12 temporary */
static DWORD WINAPI PolyBezierTo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PolyDraw ordinal = 426, argument = 16 temporary */
static DWORD WINAPI PolyDraw (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PolyPatBlt ordinal = 427, argument = 0 temporary */
static DWORD WINAPI PolyPatBlt (VOID)
{
  return 0;
}


/* PolyPolygon ordinal = 428, argument = 16 temporary */
static DWORD WINAPI PolyPolygon (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PolyPolyline ordinal = 429, argument = 16 temporary */
static DWORD WINAPI PolyPolyline (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PolyTextOutA ordinal = 430, argument = 12 temporary */
static DWORD WINAPI PolyTextOutA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PolyTextOutW ordinal = 431, argument = 12 temporary */
static DWORD WINAPI PolyTextOutW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* Polygon ordinal = 432, argument = 12 temporary */
static DWORD WINAPI Polygon (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* Polyline ordinal = 433, argument = 12 temporary */
static DWORD WINAPI Polyline (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PolylineTo ordinal = 434, argument = 12 temporary */
static DWORD WINAPI PolylineTo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PtInRegion ordinal = 435, argument = 12 temporary */
static DWORD WINAPI PtInRegion (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PtVisible ordinal = 436, argument = 12 temporary */
static DWORD WINAPI PtVisible (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QueryFontAssocStatus ordinal = 437, argument = 0 temporary */
static DWORD WINAPI QueryFontAssocStatus (VOID)
{
  return 0;
}


/* RealizePalette ordinal = 438, argument = 4 temporary */
static DWORD WINAPI RealizePalette (DWORD dwArgv0)
{
  return 0;
}


/* RectInRegion ordinal = 439, argument = 8 temporary */
static DWORD WINAPI RectInRegion (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RectVisible ordinal = 440, argument = 8 temporary */
static DWORD WINAPI RectVisible (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Rectangle ordinal = 441, argument = 20 temporary */
static DWORD WINAPI Rectangle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RemoveFontMemResourceEx ordinal = 442, argument = 4 temporary */
static DWORD WINAPI RemoveFontMemResourceEx (DWORD dwArgv0)
{
  return 0;
}


/* RemoveFontResourceA ordinal = 443, argument = 4 temporary */
static DWORD WINAPI RemoveFontResourceA (DWORD dwArgv0)
{
  return 0;
}


/* RemoveFontResourceExA ordinal = 444, argument = 12 temporary */
static DWORD WINAPI RemoveFontResourceExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RemoveFontResourceExW ordinal = 445, argument = 12 temporary */
static DWORD WINAPI RemoveFontResourceExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RemoveFontResourceTracking ordinal = 446, argument = 0 temporary */
static DWORD WINAPI RemoveFontResourceTracking (VOID)
{
  return 0;
}


/* RemoveFontResourceW ordinal = 447, argument = 4 temporary */
static DWORD WINAPI RemoveFontResourceW (DWORD dwArgv0)
{
  return 0;
}


/* ResetDCA ordinal = 448, argument = 8 temporary */
static DWORD WINAPI ResetDCA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ResetDCW ordinal = 449, argument = 8 temporary */
static DWORD WINAPI ResetDCW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ResizePalette ordinal = 450, argument = 8 temporary */
static DWORD WINAPI ResizePalette (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RestoreDC ordinal = 451, argument = 8 temporary */
static DWORD WINAPI RestoreDC (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RoundRect ordinal = 452, argument = 28 temporary */
static DWORD WINAPI RoundRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* STROBJ_bEnum ordinal = 453, argument = 0 temporary */
static DWORD WINAPI STROBJ_bEnum (VOID)
{
  return 0;
}


/* STROBJ_bEnumPositionsOnly ordinal = 454, argument = 0 temporary */
static DWORD WINAPI STROBJ_bEnumPositionsOnly (VOID)
{
  return 0;
}


/* STROBJ_bGetAdvanceWidths ordinal = 455, argument = 0 temporary */
static DWORD WINAPI STROBJ_bGetAdvanceWidths (VOID)
{
  return 0;
}


/* STROBJ_dwGetCodePage ordinal = 456, argument = 0 temporary */
static DWORD WINAPI STROBJ_dwGetCodePage (VOID)
{
  return 0;
}


/* STROBJ_vEnumStart ordinal = 457, argument = 0 temporary */
static DWORD WINAPI STROBJ_vEnumStart (VOID)
{
  return 0;
}


/* SaveDC ordinal = 458, argument = 4 temporary */
static DWORD WINAPI SaveDC (DWORD dwArgv0)
{
  return 0;
}


/* ScaleViewportExtEx ordinal = 459, argument = 24 temporary */
static DWORD WINAPI ScaleViewportExtEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ScaleWindowExtEx ordinal = 460, argument = 24 temporary */
static DWORD WINAPI ScaleWindowExtEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SelectBrushLocal ordinal = 461, argument = 8 temporary */
static DWORD WINAPI SelectBrushLocal (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SelectClipPath ordinal = 462, argument = 8 temporary */
static DWORD WINAPI SelectClipPath (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SelectClipRgn ordinal = 463, argument = 8 temporary */
static DWORD WINAPI SelectClipRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SelectFontLocal ordinal = 464, argument = 8 temporary */
static DWORD WINAPI SelectFontLocal (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SelectObject ordinal = 465, argument = 8 */
HGDIOBJ WINAPI SelectObject (HDC hDC, HGDIOBJ hObject)
{
  HGDIOBJ hObjectOld = NULL;

  if (GDK_IS_PIXBUF (hObject))
    {
      hObjectOld = hDC->pixbuf;
      hDC->pixbuf = hObject;
    }
  else if (W32LDR_IS_BRUSH (hObject))
    {
      hObjectOld = hDC->brush;
      hDC->brush = hObject;
    }
  else if (W32LDR_IS_PEN (hObject))
    {
      hObjectOld = hDC->pen;
      hDC->pen = hObject;
    }
  else if (W32LDR_IS_FONT (hObject))
    {
      hObjectOld = hDC->font;
      hDC->font = hObject;
    }
  return hObjectOld;
}


/* SelectPalette ordinal = 466, argument = 12 temporary */
static DWORD WINAPI SelectPalette (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetAbortProc ordinal = 467, argument = 8 temporary */
static DWORD WINAPI SetAbortProc (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetArcDirection ordinal = 468, argument = 8 temporary */
static DWORD WINAPI SetArcDirection (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetBitmapBits ordinal = 469, argument = 12 temporary */
static DWORD WINAPI SetBitmapBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetBitmapDimensionEx ordinal = 470, argument = 16 temporary */
static DWORD WINAPI SetBitmapDimensionEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetBkColor ordinal = 471, argument = 8 */
COLORREF WINAPI SetBkColor (HDC hDC, COLORREF crColor)
{
  COLORREF bgColor;

  bgColor = RGB (hDC->bgcolor.red / 256,
                 hDC->bgcolor.green / 256,
                 hDC->bgcolor.blue / 256);
  hDC->bgcolor.red = GetRValue (hDC->bgcolor.red) * 256;
  hDC->bgcolor.green = GetGValue (hDC->bgcolor.green) * 256;
  hDC->bgcolor.blue = GetBValue (hDC->bgcolor.blue) * 256;
  return bgColor;
}


/* SetBkMode ordinal = 472, argument = 8 */
INT WINAPI SetBkMode (HDC hDC, INT iBkMode)
{
  gboolean transparent;

  transparent = hDC->transparent;
  hDC->transparent = iBkMode == TRANSPARENT;
  return transparent ? TRANSPARENT : OPAQUE;
}


/* SetBoundsRect ordinal = 473, argument = 12 temporary */
static DWORD WINAPI SetBoundsRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetBrushOrgEx ordinal = 474, argument = 16 temporary */
static DWORD WINAPI SetBrushOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetColorAdjustment ordinal = 475, argument = 8 temporary */
static DWORD WINAPI SetColorAdjustment (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetColorSpace ordinal = 476, argument = 8 temporary */
static DWORD WINAPI SetColorSpace (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetDCBrushColor ordinal = 477, argument = 8 temporary */
static DWORD WINAPI SetDCBrushColor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetDCPenColor ordinal = 478, argument = 8 temporary */
static DWORD WINAPI SetDCPenColor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetDIBColorTable ordinal = 479, argument = 16 temporary */
static DWORD WINAPI SetDIBColorTable (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetDIBits ordinal = 480, argument = 28 temporary */
static DWORD WINAPI SetDIBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* SetDIBitsToDevice ordinal = 481, argument = 48 temporary */
static DWORD WINAPI SetDIBitsToDevice (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* SetDeviceGammaRamp ordinal = 482, argument = 8 temporary */
static DWORD WINAPI SetDeviceGammaRamp (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetEnhMetaFileBits ordinal = 483, argument = 8 temporary */
static DWORD WINAPI SetEnhMetaFileBits (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetFontEnumeration ordinal = 484, argument = 4 temporary */
static DWORD WINAPI SetFontEnumeration (DWORD dwArgv0)
{
  return 0;
}


/* SetGraphicsMode ordinal = 485, argument = 8 temporary */
static DWORD WINAPI SetGraphicsMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetICMMode ordinal = 486, argument = 8 temporary */
static DWORD WINAPI SetICMMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetICMProfileA ordinal = 487, argument = 8 temporary */
static DWORD WINAPI SetICMProfileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetICMProfileW ordinal = 488, argument = 8 temporary */
static DWORD WINAPI SetICMProfileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetLayout ordinal = 489, argument = 8 temporary */
static DWORD WINAPI SetLayout (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetLayoutWidth ordinal = 490, argument = 0 temporary */
static DWORD WINAPI SetLayoutWidth (VOID)
{
  return 0;
}


/* SetMagicColors ordinal = 491, argument = 12 temporary */
static DWORD WINAPI SetMagicColors (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetMapMode ordinal = 492, argument = 8 temporary */
static DWORD WINAPI SetMapMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMapperFlags ordinal = 493, argument = 8 temporary */
static DWORD WINAPI SetMapperFlags (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMetaFileBitsEx ordinal = 494, argument = 8 temporary */
static DWORD WINAPI SetMetaFileBitsEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMetaRgn ordinal = 495, argument = 4 temporary */
static DWORD WINAPI SetMetaRgn (DWORD dwArgv0)
{
  return 0;
}


/* SetMiterLimit ordinal = 496, argument = 12 temporary */
static DWORD WINAPI SetMiterLimit (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetPaletteEntries ordinal = 497, argument = 16 temporary */
static DWORD WINAPI SetPaletteEntries (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetPixel ordinal = 498, argument = 16 temporary */
static DWORD WINAPI SetPixel (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetPixelFormat ordinal = 499, argument = 12 temporary */
static DWORD WINAPI SetPixelFormat (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetPixelV ordinal = 500, argument = 16 temporary */
static DWORD WINAPI SetPixelV (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetPolyFillMode ordinal = 501, argument = 8 temporary */
static DWORD WINAPI SetPolyFillMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetROP2 ordinal = 502, argument = 8 temporary */
static DWORD WINAPI SetROP2 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetRectRgn ordinal = 503, argument = 20 temporary */
static DWORD WINAPI SetRectRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SetRelAbs ordinal = 504, argument = 8 temporary */
static DWORD WINAPI SetRelAbs (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetStretchBltMode ordinal = 505, argument = 8 temporary */
static DWORD WINAPI SetStretchBltMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetSystemPaletteUse ordinal = 506, argument = 8 temporary */
static DWORD WINAPI SetSystemPaletteUse (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTextAlign ordinal = 507, argument = 8 temporary */
static DWORD WINAPI SetTextAlign (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTextCharacterExtra ordinal = 508, argument = 8 temporary */
static DWORD WINAPI SetTextCharacterExtra (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTextColor ordinal = 509, argument = 8 */
COLORREF WINAPI SetTextColor (HDC hDC, COLORREF crColor)
{
  COLORREF fgColor;

  fgColor = RGB (hDC->fgcolor.red / 256,
                 hDC->fgcolor.green / 256,
                 hDC->fgcolor.blue / 256);
  hDC->fgcolor.red = GetRValue (hDC->fgcolor.red) * 256;
  hDC->fgcolor.green = GetGValue (hDC->fgcolor.green) * 256;
  hDC->fgcolor.blue = GetBValue (hDC->fgcolor.blue) * 256;
  return fgColor;
}


/* SetTextJustification ordinal = 510, argument = 12 temporary */
static DWORD WINAPI SetTextJustification (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetViewportExtEx ordinal = 511, argument = 16 temporary */
static DWORD WINAPI SetViewportExtEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetViewportOrgEx ordinal = 512, argument = 16 temporary */
static DWORD WINAPI SetViewportOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetVirtualResolution ordinal = 513, argument = 0 temporary */
static DWORD WINAPI SetVirtualResolution (VOID)
{
  return 0;
}


/* SetWinMetaFileBits ordinal = 514, argument = 16 temporary */
static DWORD WINAPI SetWinMetaFileBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetWindowExtEx ordinal = 515, argument = 16 temporary */
static DWORD WINAPI SetWindowExtEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetWindowOrgEx ordinal = 516, argument = 16 temporary */
static DWORD WINAPI SetWindowOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetWorldTransform ordinal = 517, argument = 8 temporary */
static DWORD WINAPI SetWorldTransform (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* StartDocA ordinal = 518, argument = 8 temporary */
static DWORD WINAPI StartDocA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* StartDocW ordinal = 519, argument = 8 temporary */
static DWORD WINAPI StartDocW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* StartFormPage ordinal = 520, argument = 4 temporary */
static DWORD WINAPI StartFormPage (DWORD dwArgv0)
{
  return 0;
}


/* StartPage ordinal = 521, argument = 4 temporary */
static DWORD WINAPI StartPage (DWORD dwArgv0)
{
  return 0;
}


/* StretchBlt ordinal = 522, argument = 44 temporary */
static DWORD WINAPI StretchBlt (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* StretchDIBits ordinal = 523, argument = 52 temporary */
static DWORD WINAPI StretchDIBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11, DWORD dwArgv12)
{
  return 0;
}


/* StrokeAndFillPath ordinal = 524, argument = 4 temporary */
static DWORD WINAPI StrokeAndFillPath (DWORD dwArgv0)
{
  return 0;
}


/* StrokePath ordinal = 525, argument = 4 temporary */
static DWORD WINAPI StrokePath (DWORD dwArgv0)
{
  return 0;
}


/* SwapBuffers ordinal = 526, argument = 4 temporary */
static DWORD WINAPI SwapBuffers (DWORD dwArgv0)
{
  return 0;
}


/* TextOutA ordinal = 527, argument = 20 */
BOOL WINAPI TextOutA (HDC hDC, INT nXStart, INT nYStart, LPCSTR lpString, INT cbString)
{
  gchar *utf8str;
  gunichar2 *string;
  BOOL fResult;

  utf8str = w32ldr_utf8_from_mb (lpString);
  string = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  fResult = TextOutW (hDC, nXStart, nYStart, string, lstrlenW (string));
  g_free (string);
  return fResult;
}


/* TextOutW ordinal = 528, argument = 20 */
BOOL WINAPI TextOutW (HDC hDC, INT nXStart, INT nYStart, LPCWSTR lpString, INT cbString)
{
  gchar *utf8str;
  GdkGC *gc;
  PangoLayout *layout;
  const PangoFontDescription *desc;

  if (!hDC || !hDC->widget || !hDC->widget->window
                                                || !lpString || cbString <= 0)
    return FALSE;
  utf8str = g_utf16_to_utf8 (lpString, cbString, NULL, NULL, NULL);
  layout = gtk_widget_create_pango_layout (hDC->widget, utf8str);
  g_free (utf8str);
  desc = w32ldr_font_get_description (hDC->font);
  if (desc)
    pango_layout_set_font_description (layout, desc);
  gc = gdk_gc_new (hDC->widget->window);
  gdk_draw_layout_with_colors (hDC->widget->window, gc, nXStart, nYStart,
                                        layout, &hDC->fgcolor, &hDC->bgcolor);
  g_object_unref (G_OBJECT (gc));
  g_object_unref (G_OBJECT (layout));
  return TRUE;
}


/* TranslateCharsetInfo ordinal = 529, argument = 12 temporary */
static DWORD WINAPI TranslateCharsetInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* UnloadNetworkFonts ordinal = 530, argument = 0 temporary */
static DWORD WINAPI UnloadNetworkFonts (VOID)
{
  return 0;
}


/* UnrealizeObject ordinal = 531, argument = 4 temporary */
static DWORD WINAPI UnrealizeObject (DWORD dwArgv0)
{
  return 0;
}


/* UpdateColors ordinal = 532, argument = 4 temporary */
static DWORD WINAPI UpdateColors (DWORD dwArgv0)
{
  return 0;
}


/* UpdateICMRegKeyA ordinal = 533, argument = 16 temporary */
static DWORD WINAPI UpdateICMRegKeyA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* UpdateICMRegKeyW ordinal = 534, argument = 16 temporary */
static DWORD WINAPI UpdateICMRegKeyW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* WidenPath ordinal = 535, argument = 4 temporary */
static DWORD WINAPI WidenPath (DWORD dwArgv0)
{
  return 0;
}


/* XFORMOBJ_bApplyXform ordinal = 536, argument = 0 temporary */
static DWORD WINAPI XFORMOBJ_bApplyXform (VOID)
{
  return 0;
}


/* XFORMOBJ_iGetXform ordinal = 537, argument = 0 temporary */
static DWORD WINAPI XFORMOBJ_iGetXform (VOID)
{
  return 0;
}


/* XLATEOBJ_cGetPalette ordinal = 538, argument = 0 temporary */
static DWORD WINAPI XLATEOBJ_cGetPalette (VOID)
{
  return 0;
}


/* XLATEOBJ_hGetColorTransform ordinal = 539, argument = 0 temporary */
static DWORD WINAPI XLATEOBJ_hGetColorTransform (VOID)
{
  return 0;
}


/* XLATEOBJ_iXlate ordinal = 540, argument = 0 temporary */
static DWORD WINAPI XLATEOBJ_iXlate (VOID)
{
  return 0;
}


/* XLATEOBJ_piVector ordinal = 541, argument = 0 temporary */
static DWORD WINAPI XLATEOBJ_piVector (VOID)
{
  return 0;
}


/* bInitSystemAndFontsDirectoriesW ordinal = 542, argument = 0 temporary */
static DWORD WINAPI bInitSystemAndFontsDirectoriesW (VOID)
{
  return 0;
}


/* bMakePathNameW ordinal = 543, argument = 0 temporary */
static DWORD WINAPI bMakePathNameW (VOID)
{
  return 0;
}


/* cGetTTFFromFOT ordinal = 544, argument = 0 temporary */
static DWORD WINAPI cGetTTFFromFOT (VOID)
{
  return 0;
}


/* gdiPlaySpoolStream ordinal = 545, argument = 24 temporary */
static DWORD WINAPI gdiPlaySpoolStream (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


W32LdrExport w32ldr_gdi32_exports[] = {
{-1,   1, "AbortDoc",                        AbortDoc},
{-1,   2, "AbortPath",                       AbortPath},
{-1,   3, "AddFontMemResourceEx",            AddFontMemResourceEx},
{-1,   4, "AddFontResourceA",                AddFontResourceA},
{-1,   5, "AddFontResourceExA",              AddFontResourceExA},
{-1,   6, "AddFontResourceExW",              AddFontResourceExW},
{-1,   7, "AddFontResourceTracking",         AddFontResourceTracking},
{-1,   8, "AddFontResourceW",                AddFontResourceW},
{-1,   9, "AngleArc",                        AngleArc},
{-1,  10, "AnimatePalette",                  AnimatePalette},
{-1,  11, "AnyLinkedFonts",                  AnyLinkedFonts},
{-1,  12, "Arc",                             Arc},
{-1,  13, "ArcTo",                           ArcTo},
{-1,  14, "BRUSHOBJ_hGetColorTransform",     BRUSHOBJ_hGetColorTransform},
{-1,  15, "BRUSHOBJ_pvAllocRbrush",          BRUSHOBJ_pvAllocRbrush},
{-1,  16, "BRUSHOBJ_pvGetRbrush",            BRUSHOBJ_pvGetRbrush},
{-1,  17, "BRUSHOBJ_ulGetBrushColor",        BRUSHOBJ_ulGetBrushColor},
{-1,  18, "BeginPath",                       BeginPath},
{ 0,  19, "BitBlt",                          BitBlt},
{-1,  20, "CLIPOBJ_bEnum",                   CLIPOBJ_bEnum},
{-1,  21, "CLIPOBJ_cEnumStart",              CLIPOBJ_cEnumStart},
{-1,  22, "CLIPOBJ_ppoGetPath",              CLIPOBJ_ppoGetPath},
{-1,  23, "CancelDC",                        CancelDC},
{-1,  24, "CheckColorsInGamut",              CheckColorsInGamut},
{-1,  25, "ChoosePixelFormat",               ChoosePixelFormat},
{-1,  26, "Chord",                           Chord},
{-1,  27, "CloseEnhMetaFile",                CloseEnhMetaFile},
{-1,  28, "CloseFigure",                     CloseFigure},
{-1,  29, "CloseMetaFile",                   CloseMetaFile},
{-1,  30, "ColorCorrectPalette",             ColorCorrectPalette},
{-1,  31, "ColorMatchToTarget",              ColorMatchToTarget},
{-1,  32, "CombineRgn",                      CombineRgn},
{-1,  33, "CombineTransform",                CombineTransform},
{-1,  34, "CopyEnhMetaFileA",                CopyEnhMetaFileA},
{-1,  35, "CopyEnhMetaFileW",                CopyEnhMetaFileW},
{-1,  36, "CopyMetaFileA",                   CopyMetaFileA},
{-1,  37, "CopyMetaFileW",                   CopyMetaFileW},
{-1,  38, "CreateBitmap",                    CreateBitmap},
{-1,  39, "CreateBitmapIndirect",            CreateBitmapIndirect},
{-1,  40, "CreateBrushIndirect",             CreateBrushIndirect},
{-1,  41, "CreateColorSpaceA",               CreateColorSpaceA},
{-1,  42, "CreateColorSpaceW",               CreateColorSpaceW},
{-1,  43, "CreateCompatibleBitmap",          CreateCompatibleBitmap},
{ 0,  44, "CreateCompatibleDC",              CreateCompatibleDC},
{-1,  45, "CreateDCA",                       CreateDCA},
{-1,  46, "CreateDCW",                       CreateDCW},
{-1,  47, "CreateDIBPatternBrush",           CreateDIBPatternBrush},
{-1,  48, "CreateDIBPatternBrushPt",         CreateDIBPatternBrushPt},
{-1,  49, "CreateDIBSection",                CreateDIBSection},
{-1,  50, "CreateDIBitmap",                  CreateDIBitmap},
{-1,  51, "CreateDiscardableBitmap",         CreateDiscardableBitmap},
{-1,  52, "CreateEllipticRgn",               CreateEllipticRgn},
{-1,  53, "CreateEllipticRgnIndirect",       CreateEllipticRgnIndirect},
{-1,  54, "CreateEnhMetaFileA",              CreateEnhMetaFileA},
{-1,  55, "CreateEnhMetaFileW",              CreateEnhMetaFileW},
{ 0,  56, "CreateFontA",                     CreateFontA},
{ 0,  57, "CreateFontIndirectA",             CreateFontIndirectA},
{-1,  58, "CreateFontIndirectExA",           CreateFontIndirectExA},
{-1,  59, "CreateFontIndirectExW",           CreateFontIndirectExW},
{ 0,  60, "CreateFontIndirectW",             CreateFontIndirectW},
{ 0,  61, "CreateFontW",                     CreateFontW},
{-1,  62, "CreateHalftonePalette",           CreateHalftonePalette},
{-1,  63, "CreateHatchBrush",                CreateHatchBrush},
{-1,  64, "CreateICA",                       CreateICA},
{-1,  65, "CreateICW",                       CreateICW},
{-1,  66, "CreateMetaFileA",                 CreateMetaFileA},
{-1,  67, "CreateMetaFileW",                 CreateMetaFileW},
{-1,  68, "CreatePalette",                   CreatePalette},
{-1,  69, "CreatePatternBrush",              CreatePatternBrush},
{-1,  70, "CreatePen",                       CreatePen},
{-1,  71, "CreatePenIndirect",               CreatePenIndirect},
{-1,  72, "CreatePolyPolygonRgn",            CreatePolyPolygonRgn},
{-1,  73, "CreatePolygonRgn",                CreatePolygonRgn},
{-1,  74, "CreateRectRgn",                   CreateRectRgn},
{-1,  75, "CreateRectRgnIndirect",           CreateRectRgnIndirect},
{-1,  76, "CreateRoundRectRgn",              CreateRoundRectRgn},
{-1,  77, "CreateScalableFontResourceA",     CreateScalableFontResourceA},
{-1,  78, "CreateScalableFontResourceW",     CreateScalableFontResourceW},
{ 0,  79, "CreateSolidBrush",                CreateSolidBrush},
{-1,  80, "DPtoLP",                          DPtoLP},
{-1,  81, "DeleteColorSpace",                DeleteColorSpace},
{ 0,  82, "DeleteDC",                        DeleteDC},
{-1,  83, "DeleteEnhMetaFile",               DeleteEnhMetaFile},
{-1,  84, "DeleteMetaFile",                  DeleteMetaFile},
{ 0,  85, "DeleteObject",                    DeleteObject},
{-1,  86, "DescribePixelFormat",             DescribePixelFormat},
{-1,  87, "DeviceCapabilitiesExA",           DeviceCapabilitiesExA},
{-1,  88, "DeviceCapabilitiesExW",           DeviceCapabilitiesExW},
{-1,  89, "DrawEscape",                      DrawEscape},
{-1,  90, "Ellipse",                         Ellipse},
{-1,  91, "EnableEUDC",                      EnableEUDC},
{-1,  92, "EndDoc",                          EndDoc},
{-1,  93, "EndFormPage",                     EndFormPage},
{-1,  94, "EndPage",                         EndPage},
{-1,  95, "EndPath",                         EndPath},
{-1,  96, "EngAcquireSemaphore",             EngAcquireSemaphore},
{-1,  97, "EngAlphaBlend",                   EngAlphaBlend},
{-1,  98, "EngAssociateSurface",             EngAssociateSurface},
{-1,  99, "EngBitBlt",                       EngBitBlt},
{-1, 100, "EngCheckAbort",                   EngCheckAbort},
{-1, 101, "EngComputeGlyphSet",              EngComputeGlyphSet},
{-1, 102, "EngCopyBits",                     EngCopyBits},
{-1, 103, "EngCreateBitmap",                 EngCreateBitmap},
{-1, 104, "EngCreateClip",                   EngCreateClip},
{-1, 105, "EngCreateDeviceBitmap",           EngCreateDeviceBitmap},
{-1, 106, "EngCreateDeviceSurface",          EngCreateDeviceSurface},
{-1, 107, "EngCreatePalette",                EngCreatePalette},
{-1, 108, "EngCreateSemaphore",              EngCreateSemaphore},
{-1, 109, "EngDeleteClip",                   EngDeleteClip},
{-1, 110, "EngDeletePalette",                EngDeletePalette},
{-1, 111, "EngDeletePath",                   EngDeletePath},
{-1, 112, "EngDeleteSemaphore",              EngDeleteSemaphore},
{-1, 113, "EngDeleteSurface",                EngDeleteSurface},
{-1, 114, "EngEraseSurface",                 EngEraseSurface},
{-1, 115, "EngFillPath",                     EngFillPath},
{-1, 116, "EngFindResource",                 EngFindResource},
{-1, 117, "EngFreeModule",                   EngFreeModule},
{-1, 118, "EngGetCurrentCodePage",           EngGetCurrentCodePage},
{-1, 119, "EngGetDriverName",                EngGetDriverName},
{-1, 120, "EngGetPrinterDataFileName",       EngGetPrinterDataFileName},
{-1, 121, "EngGradientFill",                 EngGradientFill},
{-1, 122, "EngLineTo",                       EngLineTo},
{-1, 123, "EngLoadModule",                   EngLoadModule},
{-1, 124, "EngLockSurface",                  EngLockSurface},
{-1, 125, "EngMarkBandingSurface",           EngMarkBandingSurface},
{-1, 126, "EngMultiByteToUnicodeN",          EngMultiByteToUnicodeN},
{-1, 127, "EngMultiByteToWideChar",          EngMultiByteToWideChar},
{-1, 128, "EngPaint",                        EngPaint},
{-1, 129, "EngPlgBlt",                       EngPlgBlt},
{-1, 130, "EngQueryEMFInfo",                 EngQueryEMFInfo},
{-1, 131, "EngQueryLocalTime",               EngQueryLocalTime},
{-1, 132, "EngReleaseSemaphore",             EngReleaseSemaphore},
{-1, 133, "EngStretchBlt",                   EngStretchBlt},
{-1, 134, "EngStretchBltROP",                EngStretchBltROP},
{-1, 135, "EngStrokeAndFillPath",            EngStrokeAndFillPath},
{-1, 136, "EngStrokePath",                   EngStrokePath},
{-1, 137, "EngTextOut",                      EngTextOut},
{-1, 138, "EngTransparentBlt",               EngTransparentBlt},
{-1, 139, "EngUnicodeToMultiByteN",          EngUnicodeToMultiByteN},
{-1, 140, "EngUnlockSurface",                EngUnlockSurface},
{-1, 141, "EngWideCharToMultiByte",          EngWideCharToMultiByte},
{-1, 142, "EnumEnhMetaFile",                 EnumEnhMetaFile},
{-1, 143, "EnumFontFamiliesA",               EnumFontFamiliesA},
{-1, 144, "EnumFontFamiliesExA",             EnumFontFamiliesExA},
{-1, 145, "EnumFontFamiliesExW",             EnumFontFamiliesExW},
{-1, 146, "EnumFontFamiliesW",               EnumFontFamiliesW},
{-1, 147, "EnumFontsA",                      EnumFontsA},
{-1, 148, "EnumFontsW",                      EnumFontsW},
{-1, 149, "EnumICMProfilesA",                EnumICMProfilesA},
{-1, 150, "EnumICMProfilesW",                EnumICMProfilesW},
{-1, 151, "EnumMetaFile",                    EnumMetaFile},
{-1, 152, "EnumObjects",                     EnumObjects},
{-1, 153, "EqualRgn",                        EqualRgn},
{-1, 154, "Escape",                          Escape},
{-1, 155, "EudcLoadLinkW",                   EudcLoadLinkW},
{-1, 156, "EudcUnloadLinkW",                 EudcUnloadLinkW},
{-1, 157, "ExcludeClipRect",                 ExcludeClipRect},
{-1, 158, "ExtCreatePen",                    ExtCreatePen},
{-1, 159, "ExtCreateRegion",                 ExtCreateRegion},
{-1, 160, "ExtEscape",                       ExtEscape},
{-1, 161, "ExtFloodFill",                    ExtFloodFill},
{-1, 162, "ExtSelectClipRgn",                ExtSelectClipRgn},
{-1, 163, "ExtTextOutA",                     ExtTextOutA},
{-1, 164, "ExtTextOutW",                     ExtTextOutW},
{-1, 165, "FONTOBJ_cGetAllGlyphHandles",     FONTOBJ_cGetAllGlyphHandles},
{-1, 166, "FONTOBJ_cGetGlyphs",              FONTOBJ_cGetGlyphs},
{-1, 167, "FONTOBJ_pQueryGlyphAttrs",        FONTOBJ_pQueryGlyphAttrs},
{-1, 168, "FONTOBJ_pfdg",                    FONTOBJ_pfdg},
{-1, 169, "FONTOBJ_pifi",                    FONTOBJ_pifi},
{-1, 170, "FONTOBJ_pvTrueTypeFontFile",      FONTOBJ_pvTrueTypeFontFile},
{-1, 171, "FONTOBJ_pxoGetXform",             FONTOBJ_pxoGetXform},
{-1, 172, "FONTOBJ_vGetInfo",                FONTOBJ_vGetInfo},
{-1, 173, "FillPath",                        FillPath},
{-1, 174, "FillRgn",                         FillRgn},
{-1, 175, "FixBrushOrgEx",                   FixBrushOrgEx},
{-1, 176, "FlattenPath",                     FlattenPath},
{-1, 177, "FloodFill",                       FloodFill},
{-1, 178, "FontIsLinked",                    FontIsLinked},
{-1, 179, "FrameRgn",                        FrameRgn},
{-1, 180, "GdiAddFontResourceW",             GdiAddFontResourceW},
{-1, 181, "GdiAddGlsBounds",                 GdiAddGlsBounds},
{-1, 182, "GdiAddGlsRecord",                 GdiAddGlsRecord},
{-1, 183, "GdiAlphaBlend",                   GdiAlphaBlend},
{-1, 184, "GdiArtificialDecrementDriver",    GdiArtificialDecrementDriver},
{-1, 185, "GdiCleanCacheDC",                 GdiCleanCacheDC},
{-1, 186, "GdiComment",                      GdiComment},
{-1, 187, "GdiConsoleTextOut",               GdiConsoleTextOut},
{-1, 188, "GdiConvertAndCheckDC",            GdiConvertAndCheckDC},
{-1, 189, "GdiConvertBitmap",                GdiConvertBitmap},
{-1, 190, "GdiConvertBitmapV5",              GdiConvertBitmapV5},
{-1, 191, "GdiConvertBrush",                 GdiConvertBrush},
{-1, 192, "GdiConvertDC",                    GdiConvertDC},
{-1, 193, "GdiConvertEnhMetaFile",           GdiConvertEnhMetaFile},
{-1, 194, "GdiConvertFont",                  GdiConvertFont},
{-1, 195, "GdiConvertMetaFilePict",          GdiConvertMetaFilePict},
{-1, 196, "GdiConvertPalette",               GdiConvertPalette},
{-1, 197, "GdiConvertRegion",                GdiConvertRegion},
{-1, 198, "GdiConvertToDevmodeW",            GdiConvertToDevmodeW},
{-1, 199, "GdiCreateLocalEnhMetaFile",       GdiCreateLocalEnhMetaFile},
{-1, 200, "GdiCreateLocalMetaFilePict",      GdiCreateLocalMetaFilePict},
{-1, 201, "GdiDeleteLocalDC",                GdiDeleteLocalDC},
{-1, 202, "GdiDeleteSpoolFileHandle",        GdiDeleteSpoolFileHandle},
{-1, 203, "GdiDescribePixelFormat",          GdiDescribePixelFormat},
{-1, 204, "GdiDllInitialize",                GdiDllInitialize},
{-1, 205, "GdiEndDocEMF",                    GdiEndDocEMF},
{-1, 206, "GdiEndPageEMF",                   GdiEndPageEMF},
{-1, 214, "GdiEntry1",                       GdiEntry1},
{-1, 207, "GdiEntry10",                      GdiEntry10},
{-1, 208, "GdiEntry11",                      GdiEntry11},
{-1, 209, "GdiEntry12",                      GdiEntry12},
{-1, 210, "GdiEntry13",                      GdiEntry13},
{-1, 211, "GdiEntry14",                      GdiEntry14},
{-1, 212, "GdiEntry15",                      GdiEntry15},
{-1, 213, "GdiEntry16",                      GdiEntry16},
{-1, 215, "GdiEntry2",                       GdiEntry2},
{-1, 216, "GdiEntry3",                       GdiEntry3},
{-1, 217, "GdiEntry4",                       GdiEntry4},
{-1, 218, "GdiEntry5",                       GdiEntry5},
{-1, 219, "GdiEntry6",                       GdiEntry6},
{-1, 220, "GdiEntry7",                       GdiEntry7},
{-1, 221, "GdiEntry8",                       GdiEntry8},
{-1, 222, "GdiEntry9",                       GdiEntry9},
{-1, 223, "GdiFixUpHandle",                  GdiFixUpHandle},
{-1, 224, "GdiFlush",                        GdiFlush},
{-1, 225, "GdiFullscreenControl",            GdiFullscreenControl},
{-1, 226, "GdiGetBatchLimit",                GdiGetBatchLimit},
{-1, 227, "GdiGetCharDimensions",            GdiGetCharDimensions},
{-1, 228, "GdiGetCodePage",                  GdiGetCodePage},
{-1, 229, "GdiGetDC",                        GdiGetDC},
{-1, 230, "GdiGetDevmodeForPage",            GdiGetDevmodeForPage},
{-1, 231, "GdiGetLocalBrush",                GdiGetLocalBrush},
{-1, 232, "GdiGetLocalDC",                   GdiGetLocalDC},
{-1, 233, "GdiGetLocalFont",                 GdiGetLocalFont},
{-1, 234, "GdiGetPageCount",                 GdiGetPageCount},
{-1, 235, "GdiGetPageHandle",                GdiGetPageHandle},
{-1, 236, "GdiGetSpoolFileHandle",           GdiGetSpoolFileHandle},
{-1, 237, "GdiGetSpoolMessage",              GdiGetSpoolMessage},
{-1, 238, "GdiGradientFill",                 GdiGradientFill},
{-1, 239, "GdiInitSpool",                    GdiInitSpool},
{-1, 240, "GdiInitializeLanguagePack",       GdiInitializeLanguagePack},
{-1, 241, "GdiIsMetaFileDC",                 GdiIsMetaFileDC},
{-1, 242, "GdiIsMetaPrintDC",                GdiIsMetaPrintDC},
{-1, 243, "GdiIsPlayMetafileDC",             GdiIsPlayMetafileDC},
{-1, 244, "GdiPlayDCScript",                 GdiPlayDCScript},
{-1, 245, "GdiPlayEMF",                      GdiPlayEMF},
{-1, 246, "GdiPlayJournal",                  GdiPlayJournal},
{-1, 247, "GdiPlayPageEMF",                  GdiPlayPageEMF},
{-1, 248, "GdiPlayPrivatePageEMF",           GdiPlayPrivatePageEMF},
{-1, 249, "GdiPlayScript",                   GdiPlayScript},
{-1, 250, "GdiPrinterThunk",                 GdiPrinterThunk},
{-1, 251, "GdiProcessSetup",                 GdiProcessSetup},
{-1, 252, "GdiQueryFonts",                   GdiQueryFonts},
{-1, 253, "GdiQueryTable",                   GdiQueryTable},
{-1, 254, "GdiRealizationInfo",              GdiRealizationInfo},
{-1, 255, "GdiReleaseDC",                    GdiReleaseDC},
{-1, 256, "GdiReleaseLocalDC",               GdiReleaseLocalDC},
{-1, 257, "GdiResetDCEMF",                   GdiResetDCEMF},
{-1, 258, "GdiSetAttrs",                     GdiSetAttrs},
{-1, 259, "GdiSetBatchLimit",                GdiSetBatchLimit},
{-1, 260, "GdiSetLastError",                 GdiSetLastError},
{-1, 261, "GdiSetPixelFormat",               GdiSetPixelFormat},
{-1, 262, "GdiSetServerAttr",                GdiSetServerAttr},
{-1, 263, "GdiStartDocEMF",                  GdiStartDocEMF},
{-1, 264, "GdiStartPageEMF",                 GdiStartPageEMF},
{-1, 265, "GdiSwapBuffers",                  GdiSwapBuffers},
{-1, 266, "GdiTransparentBlt",               GdiTransparentBlt},
{-1, 267, "GdiValidateHandle",               GdiValidateHandle},
{-1, 268, "GetArcDirection",                 GetArcDirection},
{-1, 269, "GetAspectRatioFilterEx",          GetAspectRatioFilterEx},
{-1, 270, "GetBitmapBits",                   GetBitmapBits},
{-1, 271, "GetBitmapDimensionEx",            GetBitmapDimensionEx},
{ 0, 272, "GetBkColor",                      GetBkColor},
{ 0, 273, "GetBkMode",                       GetBkMode},
{-1, 274, "GetBoundsRect",                   GetBoundsRect},
{-1, 275, "GetBrushOrgEx",                   GetBrushOrgEx},
{-1, 276, "GetCharABCWidthsA",               GetCharABCWidthsA},
{-1, 277, "GetCharABCWidthsFloatA",          GetCharABCWidthsFloatA},
{-1, 278, "GetCharABCWidthsFloatW",          GetCharABCWidthsFloatW},
{-1, 279, "GetCharABCWidthsI",               GetCharABCWidthsI},
{-1, 280, "GetCharABCWidthsW",               GetCharABCWidthsW},
{-1, 281, "GetCharWidth32A",                 GetCharWidth32A},
{-1, 282, "GetCharWidth32W",                 GetCharWidth32W},
{-1, 283, "GetCharWidthA",                   GetCharWidthA},
{-1, 284, "GetCharWidthFloatA",              GetCharWidthFloatA},
{-1, 285, "GetCharWidthFloatW",              GetCharWidthFloatW},
{-1, 286, "GetCharWidthI",                   GetCharWidthI},
{-1, 287, "GetCharWidthInfo",                GetCharWidthInfo},
{-1, 288, "GetCharWidthW",                   GetCharWidthW},
{-1, 289, "GetCharacterPlacementA",          GetCharacterPlacementA},
{-1, 290, "GetCharacterPlacementW",          GetCharacterPlacementW},
{-1, 291, "GetClipBox",                      GetClipBox},
{-1, 292, "GetClipRgn",                      GetClipRgn},
{-1, 293, "GetColorAdjustment",              GetColorAdjustment},
{-1, 294, "GetColorSpace",                   GetColorSpace},
{-1, 295, "GetCurrentObject",                GetCurrentObject},
{-1, 296, "GetCurrentPositionEx",            GetCurrentPositionEx},
{-1, 297, "GetDCBrushColor",                 GetDCBrushColor},
{-1, 298, "GetDCOrgEx",                      GetDCOrgEx},
{-1, 299, "GetDCPenColor",                   GetDCPenColor},
{-1, 300, "GetDIBColorTable",                GetDIBColorTable},
{-1, 301, "GetDIBits",                       GetDIBits},
{ 0, 302, "GetDeviceCaps",                   GetDeviceCaps},
{-1, 303, "GetDeviceGammaRamp",              GetDeviceGammaRamp},
{-1, 304, "GetETM",                          GetETM},
{-1, 305, "GetEUDCTimeStamp",                GetEUDCTimeStamp},
{-1, 306, "GetEUDCTimeStampExW",             GetEUDCTimeStampExW},
{-1, 307, "GetEnhMetaFileA",                 GetEnhMetaFileA},
{-1, 308, "GetEnhMetaFileBits",              GetEnhMetaFileBits},
{-1, 309, "GetEnhMetaFileDescriptionA",      GetEnhMetaFileDescriptionA},
{-1, 310, "GetEnhMetaFileDescriptionW",      GetEnhMetaFileDescriptionW},
{-1, 311, "GetEnhMetaFileHeader",            GetEnhMetaFileHeader},
{-1, 312, "GetEnhMetaFilePaletteEntries",    GetEnhMetaFilePaletteEntries},
{-1, 313, "GetEnhMetaFilePixelFormat",       GetEnhMetaFilePixelFormat},
{-1, 314, "GetEnhMetaFileW",                 GetEnhMetaFileW},
{-1, 315, "GetFontAssocStatus",              GetFontAssocStatus},
{-1, 316, "GetFontData",                     GetFontData},
{-1, 317, "GetFontLanguageInfo",             GetFontLanguageInfo},
{-1, 318, "GetFontResourceInfoW",            GetFontResourceInfoW},
{-1, 319, "GetFontUnicodeRanges",            GetFontUnicodeRanges},
{-1, 320, "GetGlyphIndicesA",                GetGlyphIndicesA},
{-1, 321, "GetGlyphIndicesW",                GetGlyphIndicesW},
{-1, 322, "GetGlyphOutline",                 GetGlyphOutlineA},
{-1, 323, "GetGlyphOutlineA",                GetGlyphOutlineA},
{-1, 324, "GetGlyphOutlineW",                GetGlyphOutlineW},
{-1, 325, "GetGlyphOutlineWow",              GetGlyphOutlineWow},
{-1, 326, "GetGraphicsMode",                 GetGraphicsMode},
{-1, 327, "GetHFONT",                        GetHFONT},
{-1, 328, "GetICMProfileA",                  GetICMProfileA},
{-1, 329, "GetICMProfileW",                  GetICMProfileW},
{-1, 330, "GetKerningPairs",                 GetKerningPairsA},
{-1, 331, "GetKerningPairsA",                GetKerningPairsA},
{-1, 332, "GetKerningPairsW",                GetKerningPairsW},
{-1, 333, "GetLayout",                       GetLayout},
{-1, 334, "GetLogColorSpaceA",               GetLogColorSpaceA},
{-1, 335, "GetLogColorSpaceW",               GetLogColorSpaceW},
{-1, 336, "GetMapMode",                      GetMapMode},
{-1, 337, "GetMetaFileA",                    GetMetaFileA},
{-1, 338, "GetMetaFileBitsEx",               GetMetaFileBitsEx},
{-1, 339, "GetMetaFileW",                    GetMetaFileW},
{-1, 340, "GetMetaRgn",                      GetMetaRgn},
{-1, 341, "GetMiterLimit",                   GetMiterLimit},
{ 0, 342, "GetNearestColor",                 GetNearestColor},
{-1, 343, "GetNearestPaletteIndex",          GetNearestPaletteIndex},
{ 0, 344, "GetObjectA",                      GetObjectA},
{-1, 345, "GetObjectType",                   GetObjectType},
{ 0, 346, "GetObjectW",                      GetObjectW},
{-1, 347, "GetOutlineTextMetricsA",          GetOutlineTextMetricsA},
{-1, 348, "GetOutlineTextMetricsW",          GetOutlineTextMetricsW},
{-1, 349, "GetPaletteEntries",               GetPaletteEntries},
{-1, 350, "GetPath",                         GetPath},
{-1, 351, "GetPixel",                        GetPixel},
{-1, 352, "GetPixelFormat",                  GetPixelFormat},
{-1, 353, "GetPolyFillMode",                 GetPolyFillMode},
{-1, 354, "GetROP2",                         GetROP2},
{-1, 355, "GetRandomRgn",                    GetRandomRgn},
{-1, 356, "GetRasterizerCaps",               GetRasterizerCaps},
{-1, 357, "GetRegionData",                   GetRegionData},
{-1, 358, "GetRelAbs",                       GetRelAbs},
{-1, 359, "GetRgnBox",                       GetRgnBox},
{-1, 360, "GetStockObject",                  GetStockObject},
{-1, 361, "GetStretchBltMode",               GetStretchBltMode},
{-1, 362, "GetStringBitmapA",                GetStringBitmapA},
{-1, 363, "GetStringBitmapW",                GetStringBitmapW},
{ 0, 364, "GetSystemPaletteEntries",         GetSystemPaletteEntries},
{-1, 365, "GetSystemPaletteUse",             GetSystemPaletteUse},
{-1, 366, "GetTextAlign",                    GetTextAlign},
{-1, 367, "GetTextCharacterExtra",           GetTextCharacterExtra},
{-1, 368, "GetTextCharset",                  GetTextCharset},
{-1, 369, "GetTextCharsetInfo",              GetTextCharsetInfo},
{ 0, 370, "GetTextColor",                    GetTextColor},
{-1, 371, "GetTextExtentExPointA",           GetTextExtentExPointA},
{-1, 372, "GetTextExtentExPointI",           GetTextExtentExPointI},
{-1, 373, "GetTextExtentExPointW",           GetTextExtentExPointW},
{-1, 374, "GetTextExtentExPointWPri",        GetTextExtentExPointWPri},
{ 0, 375, "GetTextExtentPoint32A",           GetTextExtentPoint32A},
{ 0, 376, "GetTextExtentPoint32W",           GetTextExtentPoint32W},
{-1, 377, "GetTextExtentPointA",             GetTextExtentPointA},
{-1, 378, "GetTextExtentPointI",             GetTextExtentPointI},
{-1, 379, "GetTextExtentPointW",             GetTextExtentPointW},
{-1, 380, "GetTextFaceA",                    GetTextFaceA},
{-1, 381, "GetTextFaceAliasW",               GetTextFaceAliasW},
{-1, 382, "GetTextFaceW",                    GetTextFaceW},
{-1, 383, "GetTextMetricsA",                 GetTextMetricsA},
{-1, 384, "GetTextMetricsW",                 GetTextMetricsW},
{-1, 385, "GetTransform",                    GetTransform},
{-1, 386, "GetViewportExtEx",                GetViewportExtEx},
{-1, 387, "GetViewportOrgEx",                GetViewportOrgEx},
{-1, 388, "GetWinMetaFileBits",              GetWinMetaFileBits},
{-1, 389, "GetWindowExtEx",                  GetWindowExtEx},
{-1, 390, "GetWindowOrgEx",                  GetWindowOrgEx},
{-1, 391, "GetWorldTransform",               GetWorldTransform},
{-1, 392, "HT_Get8BPPFormatPalette",         HT_Get8BPPFormatPalette},
{-1, 393, "HT_Get8BPPMaskPalette",           HT_Get8BPPMaskPalette},
{-1, 394, "IntersectClipRect",               IntersectClipRect},
{-1, 395, "InvertRgn",                       InvertRgn},
{-1, 396, "IsValidEnhMetaRecord",            IsValidEnhMetaRecord},
{-1, 397, "IsValidEnhMetaRecordOffExt",      IsValidEnhMetaRecordOffExt},
{-1, 398, "LPtoDP",                          LPtoDP},
{-1, 399, "LineDDA",                         LineDDA},
{-1, 400, "LineTo",                          LineTo},
{-1, 401, "MaskBlt",                         MaskBlt},
{-1, 402, "MirrorRgn",                       MirrorRgn},
{-1, 403, "ModifyWorldTransform",            ModifyWorldTransform},
{-1, 404, "MoveToEx",                        MoveToEx},
{-1, 405, "NamedEscape",                     NamedEscape},
{-1, 406, "OffsetClipRgn",                   OffsetClipRgn},
{-1, 407, "OffsetRgn",                       OffsetRgn},
{-1, 408, "OffsetViewportOrgEx",             OffsetViewportOrgEx},
{-1, 409, "OffsetWindowOrgEx",               OffsetWindowOrgEx},
{-1, 410, "PATHOBJ_bEnum",                   PATHOBJ_bEnum},
{-1, 411, "PATHOBJ_bEnumClipLines",          PATHOBJ_bEnumClipLines},
{-1, 412, "PATHOBJ_vEnumStart",              PATHOBJ_vEnumStart},
{-1, 413, "PATHOBJ_vEnumStartClipLines",     PATHOBJ_vEnumStartClipLines},
{-1, 414, "PATHOBJ_vGetBounds",              PATHOBJ_vGetBounds},
{-1, 415, "PaintRgn",                        PaintRgn},
{-1, 416, "PatBlt",                          PatBlt},
{-1, 417, "PathToRegion",                    PathToRegion},
{-1, 418, "Pie",                             Pie},
{-1, 419, "PlayEnhMetaFile",                 PlayEnhMetaFile},
{-1, 420, "PlayEnhMetaFileRecord",           PlayEnhMetaFileRecord},
{-1, 421, "PlayMetaFile",                    PlayMetaFile},
{-1, 422, "PlayMetaFileRecord",              PlayMetaFileRecord},
{-1, 423, "PlgBlt",                          PlgBlt},
{-1, 424, "PolyBezier",                      PolyBezier},
{-1, 425, "PolyBezierTo",                    PolyBezierTo},
{-1, 426, "PolyDraw",                        PolyDraw},
{-1, 427, "PolyPatBlt",                      PolyPatBlt},
{-1, 428, "PolyPolygon",                     PolyPolygon},
{-1, 429, "PolyPolyline",                    PolyPolyline},
{-1, 430, "PolyTextOutA",                    PolyTextOutA},
{-1, 431, "PolyTextOutW",                    PolyTextOutW},
{-1, 432, "Polygon",                         Polygon},
{-1, 433, "Polyline",                        Polyline},
{-1, 434, "PolylineTo",                      PolylineTo},
{-1, 435, "PtInRegion",                      PtInRegion},
{-1, 436, "PtVisible",                       PtVisible},
{-1, 437, "QueryFontAssocStatus",            QueryFontAssocStatus},
{-1, 438, "RealizePalette",                  RealizePalette},
{-1, 439, "RectInRegion",                    RectInRegion},
{-1, 440, "RectVisible",                     RectVisible},
{-1, 441, "Rectangle",                       Rectangle},
{-1, 442, "RemoveFontMemResourceEx",         RemoveFontMemResourceEx},
{-1, 443, "RemoveFontResourceA",             RemoveFontResourceA},
{-1, 444, "RemoveFontResourceExA",           RemoveFontResourceExA},
{-1, 445, "RemoveFontResourceExW",           RemoveFontResourceExW},
{-1, 446, "RemoveFontResourceTracking",      RemoveFontResourceTracking},
{-1, 447, "RemoveFontResourceW",             RemoveFontResourceW},
{-1, 448, "ResetDCA",                        ResetDCA},
{-1, 449, "ResetDCW",                        ResetDCW},
{-1, 450, "ResizePalette",                   ResizePalette},
{-1, 451, "RestoreDC",                       RestoreDC},
{-1, 452, "RoundRect",                       RoundRect},
{-1, 453, "STROBJ_bEnum",                    STROBJ_bEnum},
{-1, 454, "STROBJ_bEnumPositionsOnly",       STROBJ_bEnumPositionsOnly},
{-1, 455, "STROBJ_bGetAdvanceWidths",        STROBJ_bGetAdvanceWidths},
{-1, 456, "STROBJ_dwGetCodePage",            STROBJ_dwGetCodePage},
{-1, 457, "STROBJ_vEnumStart",               STROBJ_vEnumStart},
{-1, 458, "SaveDC",                          SaveDC},
{-1, 459, "ScaleViewportExtEx",              ScaleViewportExtEx},
{-1, 460, "ScaleWindowExtEx",                ScaleWindowExtEx},
{-1, 461, "SelectBrushLocal",                SelectBrushLocal},
{-1, 462, "SelectClipPath",                  SelectClipPath},
{-1, 463, "SelectClipRgn",                   SelectClipRgn},
{-1, 464, "SelectFontLocal",                 SelectFontLocal},
{ 0, 465, "SelectObject",                    SelectObject},
{-1, 466, "SelectPalette",                   SelectPalette},
{-1, 467, "SetAbortProc",                    SetAbortProc},
{-1, 468, "SetArcDirection",                 SetArcDirection},
{-1, 469, "SetBitmapBits",                   SetBitmapBits},
{-1, 470, "SetBitmapDimensionEx",            SetBitmapDimensionEx},
{ 0, 471, "SetBkColor",                      SetBkColor},
{ 0, 472, "SetBkMode",                       SetBkMode},
{-1, 473, "SetBoundsRect",                   SetBoundsRect},
{-1, 474, "SetBrushOrgEx",                   SetBrushOrgEx},
{-1, 475, "SetColorAdjustment",              SetColorAdjustment},
{-1, 476, "SetColorSpace",                   SetColorSpace},
{-1, 477, "SetDCBrushColor",                 SetDCBrushColor},
{-1, 478, "SetDCPenColor",                   SetDCPenColor},
{-1, 479, "SetDIBColorTable",                SetDIBColorTable},
{-1, 480, "SetDIBits",                       SetDIBits},
{-1, 481, "SetDIBitsToDevice",               SetDIBitsToDevice},
{-1, 482, "SetDeviceGammaRamp",              SetDeviceGammaRamp},
{-1, 483, "SetEnhMetaFileBits",              SetEnhMetaFileBits},
{-1, 484, "SetFontEnumeration",              SetFontEnumeration},
{-1, 485, "SetGraphicsMode",                 SetGraphicsMode},
{-1, 486, "SetICMMode",                      SetICMMode},
{-1, 487, "SetICMProfileA",                  SetICMProfileA},
{-1, 488, "SetICMProfileW",                  SetICMProfileW},
{-1, 489, "SetLayout",                       SetLayout},
{-1, 490, "SetLayoutWidth",                  SetLayoutWidth},
{-1, 491, "SetMagicColors",                  SetMagicColors},
{-1, 492, "SetMapMode",                      SetMapMode},
{-1, 493, "SetMapperFlags",                  SetMapperFlags},
{-1, 494, "SetMetaFileBitsEx",               SetMetaFileBitsEx},
{-1, 495, "SetMetaRgn",                      SetMetaRgn},
{-1, 496, "SetMiterLimit",                   SetMiterLimit},
{-1, 497, "SetPaletteEntries",               SetPaletteEntries},
{-1, 498, "SetPixel",                        SetPixel},
{-1, 499, "SetPixelFormat",                  SetPixelFormat},
{-1, 500, "SetPixelV",                       SetPixelV},
{-1, 501, "SetPolyFillMode",                 SetPolyFillMode},
{-1, 502, "SetROP2",                         SetROP2},
{-1, 503, "SetRectRgn",                      SetRectRgn},
{-1, 504, "SetRelAbs",                       SetRelAbs},
{-1, 505, "SetStretchBltMode",               SetStretchBltMode},
{-1, 506, "SetSystemPaletteUse",             SetSystemPaletteUse},
{-1, 507, "SetTextAlign",                    SetTextAlign},
{-1, 508, "SetTextCharacterExtra",           SetTextCharacterExtra},
{ 0, 509, "SetTextColor",                    SetTextColor},
{-1, 510, "SetTextJustification",            SetTextJustification},
{-1, 511, "SetViewportExtEx",                SetViewportExtEx},
{-1, 512, "SetViewportOrgEx",                SetViewportOrgEx},
{-1, 513, "SetVirtualResolution",            SetVirtualResolution},
{-1, 514, "SetWinMetaFileBits",              SetWinMetaFileBits},
{-1, 515, "SetWindowExtEx",                  SetWindowExtEx},
{-1, 516, "SetWindowOrgEx",                  SetWindowOrgEx},
{-1, 517, "SetWorldTransform",               SetWorldTransform},
{-1, 518, "StartDocA",                       StartDocA},
{-1, 519, "StartDocW",                       StartDocW},
{-1, 520, "StartFormPage",                   StartFormPage},
{-1, 521, "StartPage",                       StartPage},
{-1, 522, "StretchBlt",                      StretchBlt},
{-1, 523, "StretchDIBits",                   StretchDIBits},
{-1, 524, "StrokeAndFillPath",               StrokeAndFillPath},
{-1, 525, "StrokePath",                      StrokePath},
{-1, 526, "SwapBuffers",                     SwapBuffers},
{ 0, 527, "TextOutA",                        TextOutA},
{ 0, 528, "TextOutW",                        TextOutW},
{-1, 529, "TranslateCharsetInfo",            TranslateCharsetInfo},
{-1, 530, "UnloadNetworkFonts",              UnloadNetworkFonts},
{-1, 531, "UnrealizeObject",                 UnrealizeObject},
{-1, 532, "UpdateColors",                    UpdateColors},
{-1, 533, "UpdateICMRegKeyA",                UpdateICMRegKeyA},
{-1, 534, "UpdateICMRegKeyW",                UpdateICMRegKeyW},
{-1, 535, "WidenPath",                       WidenPath},
{-1, 536, "XFORMOBJ_bApplyXform",            XFORMOBJ_bApplyXform},
{-1, 537, "XFORMOBJ_iGetXform",              XFORMOBJ_iGetXform},
{-1, 538, "XLATEOBJ_cGetPalette",            XLATEOBJ_cGetPalette},
{-1, 539, "XLATEOBJ_hGetColorTransform",     XLATEOBJ_hGetColorTransform},
{-1, 540, "XLATEOBJ_iXlate",                 XLATEOBJ_iXlate},
{-1, 541, "XLATEOBJ_piVector",               XLATEOBJ_piVector},
{-1, 542, "bInitSystemAndFontsDirectoriesW", bInitSystemAndFontsDirectoriesW},
{-1, 543, "bMakePathNameW",                  bMakePathNameW},
{-1, 544, "cGetTTFFromFOT",                  cGetTTFFromFOT},
{-1, 545, "gdiPlaySpoolStream",              gdiPlaySpoolStream},
{-1,   0, NULL,                              NULL}};
