/*
    w32loader
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "w32brush.h"


/******************************************************************************
*                                                                             *
******************************************************************************/
G_DEFINE_TYPE (W32LdrBrush, w32ldr_brush, G_TYPE_OBJECT);


static void
w32ldr_brush_class_init (W32LdrBrushClass *klass)
{
}


/*  ja:新規作成
    RET,オブジェクト                                                        */
static void
w32ldr_brush_init (W32LdrBrush *w32brush)
{
  w32brush->color.pixel = 0;
  w32brush->color.red = 0;
  w32brush->color.green = 0;
  w32brush->color.blue = 0;
}


/******************************************************************************
*                                                                             *
* ja:ブラシ関数群                                                             *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
W32LdrBrush *
w32ldr_brush_new (void)
{
  return W32LDR_BRUSH (g_object_new (W32LDR_TYPE_BRUSH, NULL));
}


/*  ja:新規作成
    color,色
      RET,オブジェクト                                                      */
W32LdrBrush *
w32ldr_brush_new_with_color (GdkColor *color)
{
  W32LdrBrush *w32brush;

  w32brush = w32ldr_brush_new ();
  w32ldr_brush_set_color (w32brush, color);
  return w32brush;
}


/*  ja:ブラシをコピーする
    w32brush,オブジェクト
         RET,オブジェクト                                                   */
W32LdrBrush *
w32ldr_brush_copy (W32LdrBrush *w32brush)
{
  return W32LDR_IS_BRUSH (w32brush)
                    ? w32ldr_brush_new_with_color (&w32brush->color) : NULL;
}


/*  ja:ブラシの色を取得する
    w32brush,オブジェクト
       color,色                                                             */
void
w32ldr_brush_get_color (W32LdrBrush *w32brush,
                        GdkColor    *color)
{
  if (W32LDR_IS_BRUSH (w32brush) && color)
    *color = w32brush->color;
}


/*  ja:ブラシの色を設定する
    w32brush,オブジェクト
       color,色                                                             */
void
w32ldr_brush_set_color (W32LdrBrush *w32brush,
                        GdkColor    *color)
{
  if (W32LDR_IS_BRUSH (w32brush) && color)
    w32brush->color = *color;
}
