/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32private.h"


/******************************************************************************
*                                                                             *
* ja:ダイアログ関数群                                                         *
*                                                                             *
******************************************************************************/
/* ja:リアライズ */
static void
w32dlg_realize (GtkWidget *widget,
                gpointer   user_data)
{
  W32LdrWindowData *wd;

  g_signal_handlers_disconnect_by_func (G_OBJECT (widget),
                                                    w32dlg_realize, user_data);
  wd = g_object_get_data (G_OBJECT (widget), "user_data");
  if (wd->widechar)
    SendMessageW (widget, WM_INITDIALOG,
                                GPOINTER_TO_INT (wd->focus), wd->dwInitParam);
  else
    SendMessageA (widget, WM_INITDIALOG,
                                GPOINTER_TO_INT (wd->focus), wd->dwInitParam);
}


static gunichar2 *
dlg_string_next (gunichar2 *data)
{
  if (*data == 0xffff)
    {
      data += 2;
    }
  else
    {
      while (*data != '\0')
        data++;
      data++;
    }
  return data;
}


#define DLG_STRING_NEXT(data) ((data)=dlg_string_next(data))
#define DLG_ALINMENT_DWORD(data,base)                                       \
    ((data)=(gunichar2 *)((((gint)(data)-(gint)(base)+3)/4)*4+(gint)(base)))


HWND
w32ldr_CreateDialogIndirectParam (HINSTANCE      hInstance,
                                  LPCDLGTEMPLATE lpDialogTemplate,
                                  HWND           hWndParent,
                                  DLGPROC        lpDialogFunc,
                                  LPARAM         dwInitParam,
                                  const gboolean modal,
                                  const gboolean widechar)
{
  gboolean extended;
  gchar *classname, *windowname;
  gunichar2 *data;
  gint i, width = 0, height = 0;
  GSList *group = NULL;
  GtkWidget *focus = NULL;
  PangoLayout *layout;
  DLGTEMPLATE DialogTemplate;
  DLGITEMTEMPLATE DialogItem;
  HWND hDlg;
  W32LdrWindowData *wd;

  if (!lpDialogTemplate)
    return NULL;

  if (((LPCDLGTEMPLATEEX)lpDialogTemplate)->dlgVer == 1
                && ((LPCDLGTEMPLATEEX)lpDialogTemplate)->signature == 0xffff)
    {
      extended = TRUE;
      DialogTemplate.style = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->style;
      DialogTemplate.exstyle = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->exstyle;
      DialogTemplate.cdit = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->cdit;
      DialogTemplate.x = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->x;
      DialogTemplate.y = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->y;
      DialogTemplate.cx = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->cx;
      DialogTemplate.cy = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->cy;
      data = (gunichar2 *)((LPCDLGTEMPLATEEX)lpDialogTemplate + 1);
    }
  else
    {
      extended = FALSE;
      g_memmove (&DialogTemplate, lpDialogTemplate, sizeof (DLGTEMPLATE));
      data = (gunichar2 *)(lpDialogTemplate + 1);
    }
  /* en:Menu name */
  DLG_STRING_NEXT (data);
  /* en:Class name */
  classname = *data != 0xffff ? g_utf16_to_utf8 (data, -1, NULL, NULL, NULL)
                              : GUINT_TO_POINTER ((guint)data[1]);
  DLG_STRING_NEXT (data);
  /* en:Dialog Title */
  windowname = *data != 0xffff ? g_utf16_to_utf8 (data, -1, NULL, NULL, NULL)
                               : GUINT_TO_POINTER ((guint)data[1]);
  DLG_STRING_NEXT (data);
  if (DialogTemplate.style & DS_SETFONT)
    {
      /* en:Font Point Weight Italic Charset */
      data += extended ? 3 : 1;
      /* en:Font Face */
      DLG_STRING_NEXT (data);
    }

  hDlg = w32ldr_CreateWindowEx (DialogTemplate.exstyle,
                                classname,
                                windowname,
                                modal ? DialogTemplate.style | DS_MODALFRAME
                                      : DialogTemplate.style & ~DS_MODALFRAME,
                                DialogTemplate.x,
                                DialogTemplate.y,
                                DialogTemplate.cx,
                                DialogTemplate.cy,
                                hWndParent,
                                NULL,
                                hInstance,
                                NULL,
                                widechar);

  if (GPOINTER_TO_UINT (classname) > G_MAXUINT16)
    g_free (classname);
  if (GPOINTER_TO_UINT (windowname) > G_MAXUINT16)
    g_free (windowname);

  /* ja:フォント */
  layout = gtk_widget_create_pango_layout (hDlg, NULL);
  for (i = 0; i < 128; i++)
    if (g_unichar_isprint (i))
      {
        gint w, h;

        pango_layout_set_text (layout, (const char *)&i, 1);
        pango_layout_get_pixel_size (layout, &w, &h);
        if (width < w)
          width = w;
        if (height < h)
          height = h;
      }
  width = MIN ((height + 1) / 2, width);
  g_object_unref (G_OBJECT (layout));

  /* ja:ウインドウサイズ */
  if (GTK_IS_WINDOW (hDlg))
    {
      W32LdrOverlapData *od;

      od = g_object_get_data (G_OBJECT (hDlg), "user_data");
      gtk_widget_set_size_request (od->fixed,
                DialogTemplate.cx * width / 4, DialogTemplate.cy * height / 8);
    }
  else
    {
      gtk_widget_set_size_request (hDlg,
                DialogTemplate.cx * width / 4, DialogTemplate.cy * height / 8);
    }

  /* ja:アイテム */
  for (i = 0; i < DialogTemplate.cdit; i++)
    {
      HWND hWnd;

      /* en:Dialog Item */
      DLG_ALINMENT_DWORD (data, lpDialogTemplate);
      if (extended)
        {
          DialogItem.style = ((LPDLGITEMTEMPLATEEX)data)->style;
          DialogItem.exstyle = ((LPDLGITEMTEMPLATEEX)data)->exstyle;
          DialogItem.x = ((LPDLGITEMTEMPLATEEX)data)->x;
          DialogItem.y = ((LPDLGITEMTEMPLATEEX)data)->y;
          DialogItem.cx = ((LPDLGITEMTEMPLATEEX)data)->cx;
          DialogItem.cy = ((LPDLGITEMTEMPLATEEX)data)->cy;
          DialogItem.ID = ((LPDLGITEMTEMPLATEEX)data)->ID;
          data = (gunichar2 *)(((LPDLGITEMTEMPLATEEX)data) + 1);
          DLG_ALINMENT_DWORD (data, lpDialogTemplate);
        }
      else
        {
          g_memmove (&DialogItem, data, sizeof (DLGITEMTEMPLATE));
          data = (gunichar2 *)(((LPDLGITEMTEMPLATE)data) + 1);
        }
      /* en:Class name */
      classname = *data != 0xffff
                                ? g_utf16_to_utf8 (data, -1, NULL, NULL, NULL)
                                : GUINT_TO_POINTER ((guint)data[1]);
      DLG_STRING_NEXT (data);
      /* en:Dialog Title */
      windowname = *data != 0xffff
                                ? g_utf16_to_utf8 (data, -1, NULL, NULL, NULL)
                                : GUINT_TO_POINTER ((guint)data[1]);
      DLG_STRING_NEXT (data);
      /* en:Creation Data */
      data = (gunichar2 *)((guint8 *)data + (*data + sizeof (guint16)));

      hWnd = w32ldr_CreateWindowEx (DialogItem.exstyle,
                                    classname,
                                    windowname,
                                    DialogItem.style | WS_CHILD,
                                    DialogItem.x * width / 4,
                                    DialogItem.y * height / 8,
                                    DialogItem.cx * width / 4,
                                    DialogItem.cy * height / 8,
                                    hDlg,
                                    GUINT_TO_POINTER ((guint)DialogItem.ID),
                                    hInstance,
                                    GUINT_TO_POINTER (dwInitParam),
                                    widechar);

      if (GPOINTER_TO_UINT (classname) > G_MAXUINT16)
        g_free (classname);
      if (GPOINTER_TO_UINT (windowname) > G_MAXUINT16)
        g_free (windowname);

      if (hWnd)
        {
          if (DialogItem.style & WS_GROUP)
            group = NULL;
          if (GTK_IS_RADIO_BUTTON (hWnd))
            {
              if (group)
                gtk_radio_button_set_group (GTK_RADIO_BUTTON (hWnd), group);
              group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (hWnd));
            }

          wd = g_object_get_data (G_OBJECT (hWnd), "user_data");
          if (!focus && wd->focus)
            focus = wd->focus;
        }
    }

  /* ja:ダイアログ */
  wd = g_object_get_data (G_OBJECT (hDlg), "user_data");
  wd->lpDialogFunc = lpDialogFunc;
  wd->dwInitParam = dwInitParam;
  /* ja:表示 */
  if (focus)
    {
      wd->focus = focus;
      gtk_widget_grab_focus (focus);
    }
  if (lpDialogFunc)
    {
      if (GTK_WIDGET_REALIZED (hDlg))
        {
          if (wd->widechar)
            SendMessageW (hDlg, WM_INITDIALOG,
                                GPOINTER_TO_INT (wd->focus), wd->dwInitParam);
          else
            SendMessageA (hDlg, WM_INITDIALOG,
                                GPOINTER_TO_INT (wd->focus), wd->dwInitParam);
        }
      else
        {
          g_signal_connect (G_OBJECT (hDlg), "realize",
                                            G_CALLBACK (w32dlg_realize), NULL);
        }
    }
  return hDlg;
}


/******************************************************************************
*                                                                             *
* ja:ダイアログサポート関数群                                                 *
*                                                                             *
******************************************************************************/
gsize
w32ldr_dialog_get_template_size (LPCDLGTEMPLATE lpDialogTemplate)
{
  gboolean extended;
  gint i;
  gunichar2 *data;
  DLGTEMPLATE DialogTemplate;

  if (!lpDialogTemplate)
    return 0;
  if (((LPCDLGTEMPLATEEX)lpDialogTemplate)->dlgVer == 1
                && ((LPCDLGTEMPLATEEX)lpDialogTemplate)->signature == 0xffff)
    {
      extended = TRUE;
      DialogTemplate.style = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->style;
      DialogTemplate.exstyle = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->exstyle;
      DialogTemplate.cdit = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->cdit;
      DialogTemplate.x = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->x;
      DialogTemplate.y = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->y;
      DialogTemplate.cx = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->cx;
      DialogTemplate.cy = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->cy;
      data = (gunichar2 *)((LPCDLGTEMPLATEEX)lpDialogTemplate + 1);
    }
  else
    {
      extended = FALSE;
      g_memmove (&DialogTemplate, lpDialogTemplate, sizeof (DLGTEMPLATE));
      data = (gunichar2 *)(lpDialogTemplate + 1);
    }
  /* en:Menu name */
  DLG_STRING_NEXT (data);
  /* en:Class name */
  DLG_STRING_NEXT (data);
  /* en:Dialog Title */
  DLG_STRING_NEXT (data);
  if (DialogTemplate.style & DS_SETFONT)
    {
      /* en:Font Point Weight Italic Charset */
      data += extended ? 3 : 1;
      /* en:Font Face */
      DLG_STRING_NEXT (data);
    }
  /* ja:アイテム */
  for (i = 0; i < DialogTemplate.cdit; i++)
    {
      /* en:Dialog Item */
      DLG_ALINMENT_DWORD (data, lpDialogTemplate);
      data = extended ? (gunichar2 *)(((LPDLGITEMTEMPLATEEX)data) + 1)
                      : (gunichar2 *)(((LPDLGITEMTEMPLATE)data) + 1);
      /* en:Class name */
      DLG_STRING_NEXT (data);
      /* en:Dialog Title */
      DLG_STRING_NEXT (data);
      /* en:Creation Data */
      data = (gunichar2 *)((guint8 *)data + (*data + sizeof (guint16)));
    }
  return (guint8 *)data - (guint8 *)lpDialogTemplate;
}


LPDLGTEMPLATE
w32ldr_dialog_dup_template (LPCDLGTEMPLATE lpDialogTemplate)
{
  return g_memdup (lpDialogTemplate,
                        w32ldr_dialog_get_template_size (lpDialogTemplate));
}


gchar *
w32ldr_dialog_get_title (LPCDLGTEMPLATE lpDialogTemplate)
{
  gunichar2 *data;

  if (!lpDialogTemplate)
    return NULL;
  data = ((LPCDLGTEMPLATEEX)lpDialogTemplate)->dlgVer == 1
                && ((LPCDLGTEMPLATEEX)lpDialogTemplate)->signature == 0xffff
                        ? (gunichar2 *)((LPCDLGTEMPLATEEX)lpDialogTemplate + 1)
                        : (gunichar2 *)(lpDialogTemplate + 1);
  /* en:Menu name */
  DLG_STRING_NEXT (data);
  /* en:Class name */
  DLG_STRING_NEXT (data);
  /* en:Dialog Title */
  return *data != 0xffff ? g_utf16_to_utf8 (data, -1, NULL, NULL, NULL)
                         : w32ldr_atom_get_name (data[1]);
}
