/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __W32LDR_H__
#define __W32LDR_H__


#include "windef.h"
#include "w32brush.h"
#include "w32font.h"
#include "w32pen.h"


G_BEGIN_DECLS


typedef struct _W32LdrExport
{
  gint implement;
  guint16 ordinal;
  gchar *name;
  gpointer func;
} W32LdrExport;
typedef struct _W32LdrDC
{
  GtkWidget *widget;
  gboolean transparent;
  GdkColor fgcolor, bgcolor;
  GdkPixbuf *pixbuf;
  W32LdrBrush *brush;
  W32LdrFont *font;
  W32LdrPen *pen;
} W32LdrDC;


/******************************************************************************
*                                                                             *
* ja:モジュール関数群                                                         *
*                                                                             *
******************************************************************************/
/*  ja:既にロードされているモジュールを取得する
    file,モジュール名
     RET,モジュール,NULL:ロードされていない                                 */
gpointer
w32ldr_module_get_library (const gchar *file);


/*  ja:モジュールをロードする
    file,モジュール名
    exec,TRUE:DllMainを実行する,FALSE:ロードのみ
     RET,モジュール,NULL:エラー                                             */
gpointer
w32ldr_module_load_library (const gchar    *file,
                            const gboolean  exec);


/*  ja:モジュールを解放する
    memory,モジュール
       RET,TRUE:正常終了,FALSE:エラー                                       */
gboolean
w32ldr_module_free (gpointer memory);


/*  ja:モジュールの名前を取得する
    memory,モジュール
       RET,名前,NULL:エラー                                                 */
const gchar *
w32ldr_module_get_filename (gpointer memory);


/******************************************************************************
*                                                                             *
* ja:文字列関数群                                                             *
*                                                                             *
******************************************************************************/
/*  ja:UTF-8←MultiByte
     mb,MultiByte
    RET,UTF-8,NULL:エラー                                                   */
gchar *
w32ldr_utf8_from_mb (const gchar *mb);


/*  ja:UTF-8→MultiByte
    utf8str,UTF-8
        RET,MultiByte,NULL:エラー                                           */
gchar *
w32ldr_utf8_to_mb (const gchar *utf8str);


/*  ja:ファイル名←MultiByte
     mb,MultiByte
    RET,ファイル名,NULL:エラー                                              */
gchar *
w32ldr_filename_from_mb (const gchar *mb);


/*  ja:ファイル名→MultiByte
    file,ファイル名
     RET,MultiByte,NULL:エラー                                              */
gchar *
w32ldr_filename_to_mb (const gchar *file);


/*  ja:ファイル名←WideChar
     wc,WideChar
    RET,ファイル名,NULL:エラー                                              */
gchar *
w32ldr_filename_from_wc (const gunichar2 *wc);


/*  ja:ファイル名→WideChar
    file,ファイル名
     RET,WideChar,NULL:エラー                                               */
gunichar2 *
w32ldr_filename_to_wc (const gchar *file);


/******************************************************************************
*                                                                             *
* ja:アトム関数群                                                             *
*                                                                             *
******************************************************************************/
/*  ja:アトムを追加する
    name,名前(UTF-8)
     RET,アトム,0:エラー                                                    */
guint16
w32ldr_atom_add_name (const gchar *name);


/*  ja:アトムを追加する
    name,名前(MultiByte)
     RET,アトム,0:エラー                                                    */
guint16
w32ldr_atom_add_name_mb (const gchar *name);


/*  ja:アトムを追加する
    name,名前(WideChar)
     RET,アトム,0:エラー                                                    */
guint16
w32ldr_atom_add_name_wc (const gunichar2 *name);


/*  ja:アトムをアトムから削除する
    atom,アトム
     RET,TRUE:正常終了,FALSE:エラー                                         */
gboolean
w32ldr_atom_delete_atom (const guint16 atom);


/*  ja:アトムを名前から削除する
    name,名前(UTF-8)
     RET,TRUE:正常終了,FALSE:エラー                                         */
gboolean
w32ldr_atom_delete_name (const gchar *name);


/*  ja:アトムを名前から削除する
    name,名前(MultiByte)
     RET,TRUE:正常終了,FALSE:エラー                                         */
gboolean
w32ldr_atom_delete_name_mb (const gchar *name);


/*  ja:アトムを名前から削除する
    name,名前(WideChar)
     RET,TRUE:正常終了,FALSE:エラー                                         */
gboolean
w32ldr_atom_delete_name_wc (const gunichar2 *name);


/*  ja:アトムを検索する
    name,名前(UTF-8)
     RET,アトム,0:エラー                                                    */
guint16
w32ldr_atom_find_name (const gchar *name);


/*  ja:アトムを追加する
    name,名前(MultiByte)
     RET,アトム,0:エラー                                                    */
guint16
w32ldr_atom_find_name_mb (const gchar *name);


/*  ja:アトムを検索する
    name,名前(WideChar)
     RET,アトム,0:エラー                                                    */
guint16
w32ldr_atom_find_name_wc (const gunichar2 *name);


/*  ja:アトムの名前を取得する
    atom,アトム
     RET,名前(UTF-8),NULL:エラー                                            */
gchar *
w32ldr_atom_get_name (const guint16 atom);


/*  ja:アトムの名前を取得する
    atom,アトム
     RET,名前(MultiByte),NULL:エラー                                        */
gchar *
w32ldr_atom_get_name_mb (const guint16 atom);


/*  ja:アトムの名前を取得する
    atom,アトム
     RET,名前(WideChar),NULL:エラー                                         */
gunichar2 *
w32ldr_atom_get_name_wc (const guint16 atom);


/*  ja:名前から文字列を取得する
    name,名前(UTF-8)
     RET,文字列(UTF-8),NULL:エラー                                          */
gchar *
w32ldr_atom_get_string (const gchar *name);


/*  ja:名前から文字列を取得する
    name,名前(UTF-8)
     RET,文字列(MultiByte),NULL:エラー                                      */
gchar *
w32ldr_atom_get_string_mb (const gchar *name);


/*  ja:名前から文字列を取得する
    name,名前(UTF-8)
     RET,文字列(WideChar),NULL:エラー                                       */
gunichar2 *
w32ldr_atom_get_string_wc (const gchar *name);


G_END_DECLS


#endif /* __W32LDR_H__ */
