/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32private.h"


/******************************************************************************
*                                                                             *
* ja:メニュー関数群                                                           *
*                                                                             *
******************************************************************************/
static LPMENUTEMPLATE
w32ldr_LoadMenu (GtkWidget      *menu,
                 HINSTANCE       hInstance,
                 LPMENUTEMPLATE  lpMenu)
{
  UINT uFlags;

  do
    {
      UINT idNewItem;
      LPWSTR lpszNewItem = NULL;

      uFlags = *lpMenu++;
      idNewItem = uFlags & MF_POPUP ? 0 : *lpMenu++;
      if (uFlags & MFT_BITMAP)
        {
          HBITMAP hBitmap;

          hBitmap = LoadBitmapW (hInstance, lpMenu[0] == 0xffff
                                    ? MAKEINTRESOURCEW (lpMenu[1]) : lpMenu);
          if (hBitmap)
            {
              lpszNewItem = (LPWSTR)hBitmap;
            }
          else
            {
              static WCHAR wDummy = '\0';

              uFlags &= ~MFT_BITMAP;
              lpszNewItem = &wDummy;
            }
        }
      else if (uFlags & MFT_SEPARATOR || *lpMenu == '\0' || *lpMenu == 0xffff)
        {
          uFlags |= MFT_SEPARATOR;
        }
      else if (!(uFlags & MFT_OWNERDRAW))
        {
          lpszNewItem = lpMenu;
        }
      if (uFlags & MFT_OWNERDRAW || *lpMenu == 0xffff)
        lpMenu += 2;
      else
        while (*lpMenu++ != '\0');
      if (uFlags & MF_POPUP)
        {
          GtkWidget *submenu;

          submenu = gtk_menu_new ();
          gtk_widget_show (submenu);
          lpMenu = w32ldr_LoadMenu (submenu, hInstance, lpMenu);
          idNewItem = GPOINTER_TO_UINT (submenu);
        }
      AppendMenuW (menu, uFlags, idNewItem, lpszNewItem);
    }
  while (!(uFlags & MF_END));
  return lpMenu;
}


HMENU
w32ldr_LoadMenuIndirect (HINSTANCE       hInstance,
                         LPCMENUTEMPLATE lpMenuTemplate)
{
  GtkWidget *menu = NULL;

  if (lpMenuTemplate && lpMenuTemplate[0] == 0)
    {
      LPMENUTEMPLATE lpMenu;

      lpMenu = (LPMENUTEMPLATE)((LPBYTE)(lpMenuTemplate + 2)
                                                        + lpMenuTemplate[1]);
      menu = gtk_menu_bar_new ();
      gtk_widget_show (menu);
      w32ldr_LoadMenu (menu, hInstance, lpMenu);
    }
  return menu;
}


/******************************************************************************
*                                                                             *
* ja:メニューサポート関数群                                                   *
*                                                                             *
******************************************************************************/
GdkPixbuf *
w32ldr_menu_get_pixbuf_check (void)
{
  static GdkPixbuf *pixbuf = NULL;
  /* XPM */
  const gchar *check_xpm[] = {
"16 16 18 1",
"   g None",
".  g #000000",
"+  g #BBBBBB",
"@  g #7E7E7E",
"#  g #919191",
"$  g #6E6E6E",
"%  g #A1A1A1",
"&  g #616161",
"*  g #B1B1B1",
"=  g #8A8A8A",
"-  g #9D9D9D",
";  g #6A6A6A",
">  g #797979",
",  g #7A7A7A",
"'  g #757575",
")  g #737373",
"!  g #7B7B7B",
"~  g #595959",
"                ",
"           ..   ",
"          .+@.  ",
"          .#$.  ",
"         .%@.   ",
"   ..    .#&.   ",
"  .*=.  .#@.    ",
"  .--.. .@&.    ",
"   .-=..;@.     ",
"   .-->.,&.     ",
"    .--').      ",
"     .-!~.      ",
"     .--.       ",
"      .>.       ",
"       .        ",
"                "};

  if (pixbuf)
    pixbuf = gdk_pixbuf_new_from_xpm_data (check_xpm);
  return pixbuf;
}


GdkPixbuf *
w32ldr_menu_get_pixbuf_radio (void)
{
  static GdkPixbuf *pixbuf = NULL;
  /* XPM */
  const gchar *radio_xpm[] = {
"16 16 56 1",
"   g None",
".  g #000000",
"+  g #0D0D0D",
"@  g #1F1F1F",
"#  g #2A2A2A",
"$  g #2E2E2E",
"%  g #181818",
"&  g #343434",
"*  g #848484",
"=  g #BABABA",
"-  g #CDCDCD",
";  g #0F0F0F",
">  g #232323",
",  g #3B3B3B",
"'  g #ABABAB",
")  g #CFCFCF",
"!  g #222222",
"~  g #323232",
"{  g #121212",
"]  g #414141",
"^  g #838383",
"/  g #BEBEBE",
"(  g #8F8F8F",
"_  g #303030",
":  g #474747",
"<  g #A2A2A2",
"[  g #AFAFAF",
"}  g #484848",
"|  g #4E4E4E",
"1  g #A1A1A1",
"2  g #131313",
"3  g #FEFEFE",
"4  g #545454",
"5  g #8C8C8C",
"6  g #949494",
"7  g #8D8D8D",
"8  g #525252",
"9  g #5A5A5A",
"0  g #727272",
"a  g #898989",
"b  g #888888",
"c  g #5B5B5B",
"d  g #616161",
"e  g #777777",
"f  g #7E7E7E",
"g  g #1D1D1D",
"h  g #676767",
"i  g #6E6E6E",
"j  g #747474",
"k  g #757575",
"l  g #737373",
"m  g #9E9E9E",
"n  g #6D6D6D",
"o  g #363636",
"p  g #494949",
"q  g #636363",
"     .....      ",
"   .+@#$#@+%    ",
"  .@&*=-=*&@;   ",
" .>,')))))',!~  ",
" {]^///////^]{( ",
"._:<[[[[[[[<:_} ",
".:|111111111|:23",
".4456666666744.3",
".890aabbbab0c823",
".]ddefffffedd]}3",
" ghhhijklihhhgm3",
" %]nnnnnnnnn]o3 ",
"  ;]nnnnnnn]2)3 ",
"   ~@pqnqp@o)3  ",
"    (}2.2}m33   ",
"      33333     "};

  if (pixbuf)
    pixbuf = gdk_pixbuf_new_from_xpm_data (radio_xpm);
  return pixbuf;
}


gint
w32ldr_menu_get_item_pos (GtkWidget   *menu,
                          const guint  item)
{
  gint i;
  GList *glist;

  glist = gtk_container_get_children (GTK_CONTAINER (menu));
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    if (GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (g_list_nth_data (glist,
                                                    i)), "user_data")) == item)
      break;
  g_list_free (glist);
  return i;
}


GtkWidget *
w32ldr_menu_get_item (GtkWidget   *menu,
                      const gint   pos,
                      const guint  flags)
{
  GList *glist;
  GtkWidget *menu_item;

  glist = gtk_container_get_children (GTK_CONTAINER (menu));
  menu_item = g_list_nth_data (glist, flags & MF_BYPOSITION ? pos
                                    : w32ldr_menu_get_item_pos (menu, pos));
  g_list_free (glist);
  return menu_item;
}
