/*
    w32loader
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __W32PRSHT_H__
#define __W32PRSHT_H__


#include "user32.h"


G_BEGIN_DECLS


/* ja:プロパティシート */
#define WC_PROPSHEETA "SysPropertySheet"
#define WC_PROPSHEETW (w32ldr_tchar_to_wc("SysPropertySheet"))
#ifdef UNICODE
# define WC_PROPSHEET WC_PROPSHEETW
#else /* not UNICODE */
# define WC_PROPSHEET WC_PROPSHEETA
#endif /* not UNICODE */
#define PSM_SETCURSEL          (WM_USER+101)
#define PSM_REMOVEPAGE         (WM_USER+102)
#define PSM_ADDPAGE            (WM_USER+103)
#define PSM_CHANGED            (WM_USER+104)
#define PSM_RESTARTWINDOWS     (WM_USER+105)
#define PSM_REBOOTSYSTEM       (WM_USER+106)
#define PSM_CANCELTOCLOSE      (WM_USER+107)
#define PSM_QUERYSIBLINGS      (WM_USER+108)
#define PSM_UNCHANGED          (WM_USER+109)
#define PSM_APPLY              (WM_USER+110)
#define PSM_SETTITLEA          (WM_USER+111)
#define PSM_SETTITLEW          (WM_USER+120)
#define PSM_SETWIZBUTTONS      (WM_USER+112)
#define PSM_PRESSBUTTON        (WM_USER+113)
#define PSM_SETCURSELID        (WM_USER+114)
#define PSM_SETFINISHTEXTA     (WM_USER+115)
#define PSM_SETFINISHTEXTW     (WM_USER+121)
#define PSM_GETTABCONTROL      (WM_USER+116)
#define PSM_ISDIALOGMESSAGE    (WM_USER+117)
#define PSM_GETCURRENTPAGEHWND (WM_USER+118)
#define PSM_INSERTPAGE         (WM_USER+119)
#define PSM_SETHEADERTITLEA    (WM_USER+125)
#define PSM_SETHEADERTITLEW    (WM_USER+126)
#define PSM_SETHEADERSUBTITLEA (WM_USER+127)
#define PSM_SETHEADERSUBTITLEW (WM_USER+128)
#define PSM_HWNDTOINDEX        (WM_USER+129)
#define PSM_INDEXTOHWND        (WM_USER+130)
#define PSM_PAGETOINDEX        (WM_USER+131)
#define PSM_INDEXTOPAGE        (WM_USER+132)
#define PSM_IDTOINDEX          (WM_USER+133)
#define PSM_INDEXTOID          (WM_USER+134)
#define PSM_GETRESULT          (WM_USER+135)
#define PSM_RECALCPAGESIZES    (WM_USER+136)
#ifdef UNICODE
# define PSM_SETTITLE          PSM_SETTITLEW
# define PSM_SETFINISHTEXT     PSM_SETFINISHTEXTW
# define PSM_SETHEADERTITLE    PSM_SETHEADERTITLEW
# define PSM_SETHEADERSUBTITLE PSM_SETHEADERSUBTITLEW
#else /* not UNICODE */
# define PSM_SETTITLE          PSM_SETTITLEA
# define PSM_SETFINISHTEXT     PSM_SETFINISHTEXTA
# define PSM_SETHEADERTITLE    PSM_SETHEADERTITLEA
# define PSM_SETHEADERSUBTITLE PSM_SETHEADERSUBTITLEA
#endif /* not UNICODE */
#define PSN_FIRST       (-200)
#define PSN_LAST        (-299)
#define PSN_SETACTIVE   (PSN_FIRST-0)
#define PSN_KILLACTIVE  (PSN_FIRST-1)
#define PSN_APPLY       (PSN_FIRST-2)
#define PSN_RESET       (PSN_FIRST-3)
#define PSN_HELP        (PSN_FIRST-5)
#define PSN_WIZBACK     (PSN_FIRST-6)
#define PSN_WIZNEXT     (PSN_FIRST-7)
#define PSN_WIZFINISH   (PSN_FIRST-8)
#define PSN_QUERYCANCEL (PSN_FIRST-9)
#define ID_PSRESTARTWINDOWS 2
#define ID_PSREBOOTSYSTEM   (ID_PSRESTARTWINDOWS|1)
#define PSBTN_BACK     0
#define PSBTN_NEXT     1
#define PSBTN_FINISH   2
#define PSBTN_OK       3
#define PSBTN_APPLYNOW 4
#define PSBTN_CANCEL   5
#define PSBTN_HELP     6
#define PSNRET_NOERROR              0
#define PSNRET_INVALID              1
#define PSNRET_INVALID_NOCHANGEPAGE 2
#define PSWIZB_BACK   0x00000001
#define PSWIZB_NEXT   0x00000002
#define PSWIZB_FINISH 0x00000004

typedef GtkWidget *HPROPSHEETPAGE;

#define PSP_DEFAULT      0x0000
#define PSP_DLGINDIRECT  0x0001
#define PSP_USEHICON     0x0002
#define PSP_USEICONID    0x0004
#define PSP_USETITLE     0x0008
#define PSP_RTLREADING   0x0010
#define PSP_HASHELP      0x0020
#define PSP_USEREFPARENT 0x0040
#define PSP_USECALLBACK  0x0080
#define PSPCB_RELEASE 1
#define PSPCB_CREATE  2
struct _PROPSHEETPAGEA;
struct _PROPSHEETPAGEW;
typedef UINT CALLBACK (*LPFNPSPCALLBACKA)(HWND, UINT, struct _PROPSHEETPAGEA*);
typedef UINT CALLBACK (*LPFNPSPCALLBACKW)(HWND, UINT, struct _PROPSHEETPAGEW*);
#include "pshpack1.h"
typedef struct _PROPSHEETPAGEA
{
  DWORD dwSize;
  DWORD dwFlags;
  HINSTANCE hInstance;
  union
  {
    LPCSTR pszTemplate;
    LPCDLGTEMPLATE pResource;
  };
  union
  {
    HICON hIcon;
    LPCSTR pszIcon;
  };
  LPCSTR pszTitle;
  DLGPROC pfnDlgProc;
  LPARAM lParam;
  LPFNPSPCALLBACKA pfnCallback;
  UINT *pcRefParent;
} PROPSHEETPAGEA, *PPROPSHEETPAGEA, *LPPROPSHEETPAGEA;
typedef CONST PPROPSHEETPAGEA PCPROPSHEETPAGEA;
typedef CONST LPPROPSHEETPAGEA LPCPROPSHEETPAGEA;
typedef struct _PROPSHEETPAGEW
{
  DWORD dwSize;
  DWORD dwFlags;
  HINSTANCE hInstance;
  union
  {
    LPCWSTR pszTemplate;
    LPCDLGTEMPLATE pResource;
  };
  union
  {
    HICON hIcon;
    LPCWSTR pszIcon;
  };
  LPCWSTR pszTitle;
  DLGPROC pfnDlgProc;
  LPARAM lParam;
  LPFNPSPCALLBACKW pfnCallback;
  UINT *pcRefParent;
} PROPSHEETPAGEW, *PPROPSHEETPAGEW, *LPPROPSHEETPAGEW;
typedef CONST PPROPSHEETPAGEW PCPROPSHEETPAGEW;
typedef CONST LPPROPSHEETPAGEW LPCPROPSHEETPAGEW;
#include "poppack.h"
#ifdef UNICODE
# define LPFNPSPCALLBACK LPFNPSPCALLBACKA
# define PROPSHEETPAGE PROPSHEETPAGEW
# define PPROPSHEETPAGE PPROPSHEETPAGEW
# define LPPROPSHEETPAGE LPPROPSHEETPAGEW
# define PCPROPSHEETPAGE PCPROPSHEETPAGEW
# define LPCPROPSHEETPAGE LPCPROPSHEETPAGEW
#else /* not UNICODE */
# define LPFNPSPCALLBACK LPFNPSPCALLBACKW
# define PROPSHEETPAGE PROPSHEETPAGEA
# define PPROPSHEETPAGE PPROPSHEETPAGEA
# define LPPROPSHEETPAGE LPPROPSHEETPAGEA
# define PCPROPSHEETPAGE PCPROPSHEETPAGEA
# define LPCPROPSHEETPAGE LPCPROPSHEETPAGEA
#endif /* not UNICODE */

#define PSH_DEFAULT         0x0000
#define PSH_PROPTITLE       0x0001
#define PSH_USEHICON        0x0002
#define PSH_USEICONID       0x0004
#define PSH_PROPSHEETPAGE   0x0008
#define PSH_WIZARDHASFINISH 0x0010
#define PSH_WIZARD          0x0020
#define PSH_USEPSTARTPAGE   0x0040
#define PSH_NOAPPLYNOW      0x0080
#define PSH_USECALLBACK     0x0100
#define PSH_HASHELP         0x0200
#define PSH_MODELESS        0x0400
#define PSH_RTLREADING      0x0800
#define PSCB_INITIALIZED 1
typedef INT CALLBACK (*PFNPROPSHEETCALLBACK)(HWND, UINT, LPARAM);
#include "pshpack1.h"
typedef struct _PROPSHEETHEADERA
{
  DWORD dwSize;
  DWORD dwFlags;
  HWND hwndParent;
  HINSTANCE hInstance;
  union
  {
    HICON hIcon;
    LPCSTR pszIcon;
  };
  LPCSTR pszCaption;
  UINT nPages;
  union
  {
    UINT nStartPage;
    LPCSTR pStartPage;
  };
  union
  {
    LPPROPSHEETPAGEA ppsp;
    HPROPSHEETPAGE *phpage;
  };
  PFNPROPSHEETCALLBACK pfnCallback;
} PROPSHEETHEADERA, *PPROPSHEETHEADERA, *LPPROPSHEETHEADERA;
typedef const PPROPSHEETHEADERA PCPROPSHEETHEADERA;
typedef const LPPROPSHEETHEADERA LPCPROPSHEETHEADERA;
typedef struct _PROPSHEETHEADERW
{
  DWORD dwSize;
  DWORD dwFlags;
  HWND hwndParent;
  HINSTANCE hInstance;
  union
  {
    HICON hIcon;
    LPCWSTR pszIcon;
  };
  LPCWSTR pszCaption;
  UINT nPages;
  union
  {
    UINT nStartPage;
    LPCWSTR pStartPage;
  };
  union
  {
    LPPROPSHEETPAGEW ppsp;
    HPROPSHEETPAGE *phpage;
  };
  PFNPROPSHEETCALLBACK pfnCallback;
} PROPSHEETHEADERW, *PPROPSHEETHEADERW, *LPPROPSHEETHEADERW;
typedef const PPROPSHEETHEADERW PCPROPSHEETHEADERW;
typedef const LPPROPSHEETHEADERW LPCPROPSHEETHEADERW;
#include "poppack.h"
#ifdef UNICODE
# define PROPSHEETHEADER PROPSHEETHEADERW
# define PPROPSHEETHEADER PPROPSHEETHEADERW
# define LPPROPSHEETHEADER LPPROPSHEETHEADERW
# define PCPROPSHEETHEADER PCPROPSHEETHEADERW
# define LPCPROPSHEETHEADER LPCPROPSHEETHEADERW
#else /* not UNICODE */
# define PROPSHEETHEADER PROPSHEETHEADERA
# define PPROPSHEETHEADER PPROPSHEETHEADERA
# define LPPROPSHEETHEADER LPPROPSHEETHEADERA
# define PCPROPSHEETHEADER PCPROPSHEETHEADERA
# define LPCPROPSHEETHEADER LPCPROPSHEETHEADERA
#endif /* not UNICODE */

#define PropSheet_AddPage(hWnd,hPage) SendMessage(hWnd,PSM_ADDPAGE,0,GPOINTER_TO_INT(hPage))
#define PropSheet_Apply(hWnd) SendMessage(hWnd,PSM_APPLY,0,0)
#define PropSheet_CancelToClose(hWnd) SendMessage(hWnd,PSM_CANCELTOCLOSE,0,0)
#define PropSheet_Changed(hWnd,hPage) SendMessage(hWnd,PSM_CHANGED,0,GPOINTER_TO_INT(hPage),0)
#define PropSheet_GetCurrentPageHwnd(hWnd) GINT_TO_POINTER(SendMessage(hWnd,PSM_GETCURRENTPAGEHWND,0,0))
#define PropSheet_GetTabControl(hWnd) GINT_TO_POINTER(SendMessage(hWnd,PSM_GETTABCONTROL,0,0))
#define PropSheet_IsDialogMessage(hWnd,pMsg) SendMessage(hWnd,PSM_ISDIALOGMESAGE,0,GPOINTER_TO_INT(pMsg))
#define PropSheet_PressButton(hWnd,iButton) SendMessage(hWnd,PSM_PRESSBUTTON,ibutton,0)
#define PropSheet_QuerySiblings(hWnd,param1,param2) SendMessage(hWnd,PSM_QUERYSIBLINGS,param1,param2)
#define PropSheet_RebootSystem(hWnd) SendMessage(hWnd,PSM_REBOOTSYSTEM,0,0)
#define PropSheet_RemovePage(hWnd,index,hPage) SendMessage(hWnd,PSM_REMOVEPAGE,index,GPOINTER_TO_INT(hPage))
#define PropSheet_RestartWindows(hWnd) SendMessage(hWnd,PSM_RESTARTWINDOWS,0,0)
#define PropSheet_SetCurSel(hWnd,hPage,index) SendMessage(hWnd,PSM_SETCURSEL,index,GPOINTER_TO_INT(hPage))
#define PropSheet_SetCurSelByID(hWnd,id) SendMessage(hWnd,PSM_SETCURSELID,0,id)
#define PropSheet_SetFinishTextA(hWnd,lpszText) SendMessage(hWnd,PSM_SETFINISHTEXTA,0,GPOINTER_TO_INT(lpszText))
#define PropSheet_SetFinishTextW(hWnd,lpszText) SendMessage(hWnd,PSM_SETFINISHTEXTW,0,GPOINTER_TO_INT(lpszText))
#define PropSheet_SetTitleA(hWnd,dwStyle,lpszText) SendMessage(hWnd,PSM_SETTITLEA,dwStyle,GPOINTER_TO_INT(lpszText))
#define PropSheet_SetTitleW(hWnd,dwStyle,lpszText) SendMessage(hWnd,PSM_SETTITLEW,dwStyle,GPOINTER_TO_INT(lpszText))
#define PropSheet_SetWizButtons(hWnd,dwFlags) SendMessage(hWnd,PSM_SETWIZBUTTONS,0,dwFlags)
#define PropSheet_UnChanged(hWnd,hPage) SendMessage(hWnd,PSM_UNCHANGED,GPOINTER_TO_INT(hPage),0)
#ifdef UNICODE
# define PropSheet_SetFinishText PropSheet_SetFinishTextW
# define PropSheet_SetTitle PropSheet_SetTitleW
#else /* not UNICODE */
# define PropSheet_SetFinishText PropSheet_SetFinishTextA
# define PropSheet_SetTitle PropSheet_SetTitleA
#endif /* not UNICODE */


G_END_DECLS


#endif /* not __W32PRSHT_H__ */
