/*
    w32loader
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __W32WND_H__
#define __W32WND_H__


G_BEGIN_DECLS


#define WS_OVERLAPPED          0x00000000
#define WS_POPUP               0x80000000
#define WS_CHILD               0x40000000
#define WS_MINIMIZE            0x20000000
#define WS_VISIBLE             0x10000000
#define WS_DISABLED            0x08000000
#define WS_CLIPSIBLINGS        0x04000000
#define WS_CLIPCHILDREN        0x02000000
#define WS_MAXIMIZE            0x01000000
#define WS_CAPTION             0x00c00000
#define WS_BORDER              0x00800000
#define WS_DLGFRAME            0x00400000
#define WS_VSCROLL             0x00200000
#define WS_HSCROLL             0x00100000
#define WS_SYSMENU             0x00080000
#define WS_THICKFRAME          0x00040000
#define WS_GROUP               0x00020000
#define WS_TABSTOP             0x00010000
#define WS_MINIMIZEBOX         0x00020000
#define WS_MAXIMIZEBOX         0x00010000
#define WS_TILED               WS_OVERLAPPED
#define WS_ICONIC              WS_MINIMIZE
#define WS_SIZEBOX             WS_THICKFRAME
#define WS_OVERLAPPEDWINDOW    (WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_MINIMIZEBOX|WS_MAXIMIZEBOX)
#define WS_POPUPWINDOW         (WS_POPUP|WS_BORDER|WS_SYSMENU)
#define WS_CHILDWINDOW         WS_CHILD
#define WS_TILEDWINDOW         WS_OVERLAPPEDWINDOW
#define WS_EX_DLGMODALFRAME    0x00000001
#define WS_EX_DRAGDETECT       0x00000002
#define WS_EX_NOPARENTNOTIFY   0x00000004
#define WS_EX_TOPMOST          0x00000008
#define WS_EX_ACCEPTFILES      0x00000010
#define WS_EX_TRANSPARENT      0x00000020
#define WS_EX_MDICHILD         0x00000040
#define WS_EX_TOOLWINDOW       0x00000080
#define WS_EX_WINDOWEDGE       0x00000100
#define WS_EX_CLIENTEDGE       0x00000200
#define WS_EX_CONTEXTHELP      0x00000400
#define WS_EX_RIGHT            0x00001000
#define WS_EX_LEFT             0x00000000
#define WS_EX_RTLREADING       0x00002000
#define WS_EX_LTRREADING       0x00000000
#define WS_EX_LEFTSCROLLBAR    0x00004000
#define WS_EX_RIGHTSCROLLBAR   0x00000000
#define WS_EX_CONTROLPARENT    0x00010000
#define WS_EX_STATICEDGE       0x00020000
#define WS_EX_APPWINDOW        0x00040000
#define WS_EX_LAYOUTRTL        0x00400000
#define WS_EX_NOINHERITLAYOUT  0x00100000
#define WS_EX_OVERLAPPEDWINDOW (WS_EX_WINDOWEDGE|WS_EX_CLIENTEDGE)
#define WS_EX_PALETTEWINDOW    (WS_EX_WINDOWEDGE|WS_EX_TOOLWINDOW|WS_EX_TOPMOST)
#define WS_EX_LAYERED          0x00080000L
#define WS_EX_TRAYWINDOW       0x80000000L
/* ja:メッセージ */
#define WM_NULL                   0x0000
#define WM_CREATE                 0x0001
#define WM_DESTROY                0x0002
#define WM_MOVE                   0x0003
#define WM_SIZEWAIT               0x0004
#define WM_SIZE                   0x0005
#define WM_ACTIVATE               0x0006
#define WM_SETFOCUS               0x0007
#define WM_KILLFOCUS              0x0008
#define WM_SETVISIBLE             0x0009
#define WM_ENABLE                 0x000a
#define WM_SETREDRAW              0x000b
#define WM_SETTEXT                0x000c
#define WM_GETTEXT                0x000d
#define WM_GETTEXTLENGTH          0x000e
#define WM_PAINT                  0x000f
#define WM_CLOSE                  0x0010
#define WM_QUERYENDSESSION        0x0011
#define WM_QUIT                   0x0012
#define WM_QUERYOPEN              0x0013
#define WM_ERASEBKGND             0x0014
#define WM_SYSCOLORCHANGE         0x0015
#define WM_ENDSESSION             0x0016
#define WM_SYSTEMERROR            0x0017
#define WM_SHOWWINDOW             0x0018
#define WM_CTLCOLOR               0x0019
#define WM_WININICHANGE           0x001a
#define WM_SETTINGCHANGE          WM_WININICHANGE
#define WM_DEVMODECHANGE          0x001b
#define WM_ACTIVATEAPP            0x001c
#define WM_FONTCHANGE             0x001d
#define WM_TIMECHANGE             0x001e
#define WM_CANCELMODE             0x001f
#define WM_SETCURSOR              0x0020
#define WM_MOUSEACTIVATE          0x0021
#define WM_CHILDACTIVATE          0x0022
#define WM_QUEUESYNC              0x0023
#define WM_GETMINMAXINFO          0x0024
#define WM_PAINTICON              0x0026
#define WM_ICONERASEBKGND         0x0027
#define WM_NEXTDLGCTL             0x0028
#define WM_ALTTABACTIVE           0x0029
#define WM_SPOOLERSTATUS          0x002a
#define WM_DRAWITEM               0x002b
#define WM_MEASUREITEM            0x002c
#define WM_DELETEITEM             0x002d
#define WM_VKEYTOITEM             0x002e
#define WM_CHARTOITEM             0x002f
#define WM_SETFONT                0x0030
#define WM_GETFONT                0x0031
#define WM_SETHOTKEY              0x0032
#define WM_GETHOTKEY              0x0033
#define WM_FILESYSCHANGE          0x0034
#define WM_ISACTIVEICON           0x0035
#define WM_QUERYPARKICON          0x0036
#define WM_QUERYDRAGICON          0x0037
#define WM_QUERYSAVESTATE         0x0038
#define WM_COMPAREITEM            0x0039
#define WM_TESTING                0x003a
#define WM_GETOBJECT              0x003d
#define WM_ACTIVATESHELLWINDOW    0x003e
#define WM_COMPACTING             0x0041
#define WM_COMMNOTIFY             0x0044
#define WM_WINDOWPOSCHANGING      0x0046
#define WM_WINDOWPOSCHANGED       0x0047
#define WM_POWER                  0x0048
#define WM_COPYDATA               0x004a
#define WM_CANCELJOURNAL          0x004b
#define WM_NOTIFY                 0x004e
#define WM_INPUTLANGCHANGEREQUEST 0x0050
#define WM_INPUTLANGCHANGE        0x0051
#define WM_TCARD                  0x0052
#define WM_HELP                   0x0053
#define WM_USERCHANGED            0x0054
#define WM_NOTIFYFORMAT           0x0055
#define WM_CONTEXTMENU            0x007b
#define WM_STYLECHANGING          0x007c
#define WM_STYLECHANGED           0x007d
#define WM_DISPLAYCHANGE          0x007e
#define WM_GETICON                0x007f
#define WM_SETICON                0x0080
#define WM_NCCREATE               0x0081
#define WM_NCDESTROY              0x0082
#define WM_NCCALCSIZE             0x0083
#define WM_NCHITTEST              0x0084
#define WM_NCPAINT                0x0085
#define WM_NCACTIVATE             0x0086
#define WM_GETDLGCODE             0x0087
#define WM_SYNCPAINT              0x0088
#define WM_SYNCTASK               0x0089
#define WM_NCMOUSEMOVE            0x00a0
#define WM_NCLBUTTONDOWN          0x00a1
#define WM_NCLBUTTONUP            0x00a2
#define WM_NCLBUTTONDBLCLK        0x00a3
#define WM_NCRBUTTONDOWN          0x00a4
#define WM_NCRBUTTONUP            0x00a5
#define WM_NCRBUTTONDBLCLK        0x00a6
#define WM_NCMBUTTONDOWN          0x00a7
#define WM_NCMBUTTONUP            0x00a8
#define WM_NCMBUTTONDBLCLK        0x00a9
#define WM_NCXBUTTONDOWN          0x00ab
#define WM_NCXBUTTONUP            0x00ac
#define WM_NCXBUTTONDBLCLK        0x00ad
#define WM_KEYDOWN                0x0100
#define WM_KEYFIRST               WM_KEYDOWN
#define WM_KEYUP                  0x0101
#define WM_CHAR                   0x0102
#define WM_DEADCHAR               0x0103
#define WM_SYSKEYDOWN             0x0104
#define WM_SYSKEYUP               0x0105
#define WM_SYSCHAR                0x0106
#define WM_SYSDEADCHAR            0x0107
#define WM_KEYLAST                0x0108
#define WM_IME_STARTCOMPOSITION   0x010d
#define WM_IME_ENDCOMPOSITION     0x010e
#define WM_IME_COMPOSITION        0x010f
#define WM_IME_KEYLAST            WM_IME_COMPOSITION
#define WM_INITDIALOG             0x0110
#define WM_COMMAND                0x0111
#define WM_SYSCOMMAND             0x0112
#define WM_TIMER                  0x0113
#define WM_HSCROLL                0x0114
#define WM_VSCROLL                0x0115
#define WM_INITMENU               0x0116
#define WM_INITMENUPOPUP          0x0117
#define WM_SYSTIMER               0x0118
#define WM_MENUSELECT             0x011f
#define WM_MENUCHAR               0x0120
#define WM_ENTERIDLE              0x0121
#define WM_MENURBUTTONUP          0x0122
#define WM_MENUDRAG               0x0123
#define WM_MENUGETOBJECT          0x0124
#define WM_UNINITMENUPOPUP        0x0125
#define WM_MENUCOMMAND            0x0126
#define WM_CHANGEUISTATE          0x0127
#define WM_UPDATEUISTATE          0x0128
#define WM_QUERYUISTATE           0x0129
#define WM_LBTRACKPOINT           0x0131
#define WM_CTLCOLORMSGBOX         0x0132
#define WM_CTLCOLOREDIT           0x0133
#define WM_CTLCOLORLISTBOX        0x0134
#define WM_CTLCOLORBTN            0x0135
#define WM_CTLCOLORDLG            0x0136
#define WM_CTLCOLORSCROLLBAR      0x0137
#define WM_CTLCOLORSTATIC         0x0138
#define WM_MOUSEMOVE              0x0200
#define WM_MOUSEFIRST             WM_MOUSEMOVE
#define WM_LBUTTONDOWN            0x0201
#define WM_LBUTTONUP              0x0202
#define WM_LBUTTONDBLCLK          0x0203
#define WM_RBUTTONDOWN            0x0204
#define WM_RBUTTONUP              0x0205
#define WM_RBUTTONDBLCLK          0x0206
#define WM_MBUTTONDOWN            0x0207
#define WM_MBUTTONUP              0x0208
#define WM_MBUTTONDBLCLK          0x0209
#define WM_MOUSEWHEEL             0x020a
#define WM_XBUTTONDOWN            0x020b
#define WM_XBUTTONUP              0x020c
#define WM_XBUTTONDBLCLK          0x020d
#define WM_MOUSELAST              0x020d
#define WM_PARENTNOTIFY           0x0210
#define WM_ENTERMENULOOP          0x0211
#define WM_EXITMENULOOP           0x0212
#define WM_NEXTMENU               0x0213
#define WM_SIZING                 0x0214
#define WM_CAPTURECHANGED         0x0215
#define WM_MOVING                 0x0216
#define WM_POWERBROADCAST         0x0218
#define WM_DEVICECHANGE           0x0219
#define WM_MDICREATE              0x0220
#define WM_MDIDESTROY             0x0221
#define WM_MDIACTIVATE            0x0222
#define WM_MDIRESTORE             0x0223
#define WM_MDINEXT                0x0224
#define WM_MDIMAXIMIZE            0x0225
#define WM_MDITILE                0x0226
#define WM_MDICASCADE             0x0227
#define WM_MDIICONARRANGE         0x0228
#define WM_MDIGETACTIVE           0x0229
#define WM_MDIREFRESHMENU         0x0234
#define WM_DROPOBJECT             0x022a
#define WM_QUERYDROPOBJECT        0x022b
#define WM_BEGINDRAG              0x022c
#define WM_DRAGLOOP               0x022d
#define WM_DRAGSELECT             0x022e
#define WM_DRAGMOVE               0x022f
#define WM_MDISETMENU             0x0230
#define WM_ENTERSIZEMOVE          0x0231
#define WM_EXITSIZEMOVE           0x0232
#define WM_DROPFILES              0x0233
#define WM_IME_SETCONTEXT         0x0281
#define WM_IME_NOTIFY             0x0282
#define WM_IME_CONTROL            0x0283
#define WM_IME_COMPOSITIONFULL    0x0284
#define WM_IME_SELECT             0x0285
#define WM_IME_CHAR               0x0286
#define WM_IME_REQUEST            0x0288
#define WM_IME_KEYDOWN            0x0290
#define WM_IME_KEYUP              0x0291
#define WM_CUT                    0x0300
#define WM_COPY                   0x0301
#define WM_PASTE                  0x0302
#define WM_CLEAR                  0x0303
#define WM_UNDO                   0x0304
#define WM_RENDERFORMAT           0x0305
#define WM_RENDERALLFORMATS       0x0306
#define WM_DESTROYCLIPBOARD       0x0307
#define WM_DRAWCLIPBOARD          0x0308
#define WM_PAINTCLIPBOARD         0x0309
#define WM_VSCROLLCLIPBOARD       0x030a
#define WM_SIZECLIPBOARD          0x030b
#define WM_ASKCBFORMATNAME        0x030c
#define WM_CHANGECBCHAIN          0x030d
#define WM_HSCROLLCLIPBOARD       0x030e
#define WM_QUERYNEWPALETTE        0x030f
#define WM_PALETTEISCHANGING      0x0310
#define WM_PALETTECHANGED         0x0311
#define WM_HOTKEY                 0x0312
#define WM_PRINT                  0x0317
#define WM_PRINTCLIENT            0x0318
#define WM_THEMECHANGED           0x031a
#define WM_PENWINFIRST            0x0380
#define WM_PENWINLAST             0x038f
#define WM_USER                   0x0400
#define WM_APP                    0x8000
  /* en:WM_[LMR]BUTTONDBLCLK/WM_[LMR]BUTTONDOWN/WM_[LMR]BUTTONUP */
#define MK_LBUTTON  0x0001
#define MK_RBUTTON  0x0002
#define MK_SHIFT    0x0004
#define MK_CONTROL  0x0008
#define MK_MBUTTON  0x0010
  /* ja:マウスメッセージ */
#define XBUTTON1 0x0001
#define XBUTTON2 0x0002
#define WHEEL_DELTA      120
#define WHEEL_PAGESCROLL (UINT_MAX)
#define GET_WHEEL_DELTA_WPARAM(wParam) ((SHORT)HIWORD(wParam))
  /* en:WM_MOVING/WM_SIZING wParam */
#define WMSZ_LEFT        1
#define WMSZ_RIGHT       2
#define WMSZ_TOP         3
#define WMSZ_TOPLEFT     4
#define WMSZ_TOPRIGHT    5
#define WMSZ_BOTTOM      6
#define WMSZ_BOTTOMLEFT  7
#define WMSZ_BOTTOMRIGHT 8
  /* en:WM_SIZE wParam */
#define SIZE_RESTORED  0
#define SIZE_MINIMIZED 1
#define SIZE_MAXIMIZED 2
#define SIZE_MAXSHOW   3
#define SIZE_MAXHIDE   4
  /* en:WM_POWERBROADCAST wParam */
#define PBT_APMQUERYSUSPEND       0x0000
#define PBT_APMQUERYSTANDBY       0x0001
#define PBT_APMQUERYSUSPENDFAILED 0x0002
#define PBT_APMQUERYSTANDBYFAILED 0x0003
#define PBT_APMSUSPEND            0x0004
#define PBT_APMSTANDBY            0x0005
#define PBT_APMRESUMECRITICAL     0x0006
#define PBT_APMRESUMESUSPEND      0x0007
#define PBT_APMRESUMESTANDBY      0x0008
#define PBT_APMBATTERYLOW         0x0009
#define PBT_APMPOWERSTATUSCHANGE  0x000a
#define PBT_APMOEMEVENT           0x000b
#define PBT_APMRESUMEAUTOMATIC    0x0012
  /* ja:WM_SYSCOMMANDパラメータ */
#define SC_SIZE         0xf000
#define SC_MOVE         0xf010
#define SC_MINIMIZE     0xf020
#define SC_MAXIMIZE     0xf030
#define SC_NEXTWINDOW   0xf040
#define SC_PREVWINDOW   0xf050
#define SC_CLOSE        0xf060
#define SC_VSCROLL      0xf070
#define SC_HSCROLL      0xf080
#define SC_MOUSEMENU    0xf090
#define SC_KEYMENU      0xf100
#define SC_ARRANGE      0xf110
#define SC_RESTORE      0xf120
#define SC_TASKLIST     0xf130
#define SC_SCREENSAVE   0xf140
#define SC_HOTKEY       0xf150
#define SC_DEFAULT      0xf160
#define SC_MONITORPOWER 0xf170
#define SC_CONTEXTHELP  0xf180
#define SC_SEPARATOR    0xf00f
#define SC_ICON         SC_MINIMIZE
#define SC_ZOOM         SC_MAXIMIZE
#include "pshpack1.h"
typedef struct _WINDOWPOS
{
  HWND hwnd;
  HWND hwndInsertAfter;
  INT x;
  INT y;
  INT cx;
  INT cy;
  UINT flags;
} WINDOWPOS, *PWINDOWPOS, *LPWINDOWPOS;
#include "poppack.h"


G_END_DECLS


#endif /* not __W32WND_H__ */
