package
{
	import flash.events.Event;
	import flash.events.NetStatusEvent;
	import flash.media.Video;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	
	import org.papervision3d.materials.BitmapFileMaterial;
	import org.papervision3d.materials.VideoStreamMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.view.BasicView;

	/**
	 * Papervision3Dをお試しで使ってみたクラス<br>
	 * ビルドバスにPapervision3Dのライブラリを追加しておくこと。<br>
	 * 
	 * @see http://code.google.com/p/papervision3d/downloads/list
	 * @see http://rainyday.jp/blog/flash/pv3d/PV3D_material.html
	 * @author shiraminekeisuke
	 * 
	 */
	public class PV3DTest extends BasicView
	{
		
		private var _mySphereForRotate:Sphere = null;
		
		private var _myCubeForRotate:Cube = null;
		
		private var _myCubeForStreaming:Cube = null;
		
		public function PV3DTest()
		{
			// drawSphere
//			drawSphere();

			// rotateSphere
//			rotateSphere();
			
			// rotateCube
//			rotateCube();
			
			// rotateCube and Streaming
			rotateCubeAndStreamVideo();
		}
		
		/**
		 * 球を描きます
		 */
		private function drawSphere():void{
			//半径600、縦40分割、横40分割のボール（Sphere）を作る
			var mySphere:Sphere = new Sphere(null, 600, 40, 40);
			
			//3D空間にそれを貼り付ける
			scene.addChild(mySphere);
			
			//表示スタート
			startRendering();
		}
		
		/**
		 * 球を回転させます
		 */
		private function rotateSphere():void{
			
			//カメラのZ座標を-300に設定
			camera.z = -300;
			//カメラのフォーカス。大きい値ほど拡大。
			camera.focus = 200;
			//カメラの倍率。大きい値ほど拡大。
			camera.zoom = 1;
			
			//半径200、縦12分割、横12分割のボール
			this._mySphereForRotate = new Sphere(null, 200, 12, 12);
			
			scene.addChild(this._mySphereForRotate);
			
			startRendering();
		}
		
		/**
		 * 立方体を回転させる
		 */
		private function rotateCube():void{
			
			//カメラのZ座標を-300に設定
			camera.z = -200;
			//カメラのフォーカス。大きい値ほど拡大。
			camera.focus = 200;
			//カメラの倍率。大きい値ほど拡大。
			camera.zoom = 1;
			
			//マテリアルに単色を指定
//			var material:ColorMaterial = new ColorMaterial(Number("0xffffff"));
			
			//マテリアルに画像を指定
			var material:BitmapFileMaterial = new BitmapFileMaterial("bg1.jpg");
			
			var materialList:MaterialsList = new MaterialsList({
				all:material
			});
			
			this._myCubeForRotate = new Cube(materialList, 100, 100, 100, 1, 1, 1, 0, 0);
			
			scene.addChild(this._myCubeForRotate);
			
			startRendering();
			
		}
		
		/**
		 * 立方体に動画を投影する
		 */
		private function rotateCubeAndStreamVideo():void{
			
			//カメラの座標設定
			camera.z = -600;
			
			//コネクションを確保( この辺の処理は http://livedocs.adobe.com/flex/3_jp/langref/index.html を参照 )
			var netConnection:NetConnection = new NetConnection();
			netConnection.addEventListener(NetStatusEvent.NET_STATUS, netStatusEventHandler);
			netConnection.connect(null);
			
			//NetConnectionおよびNetStreamのリスナ
			function netStatusEventHandler(event:NetStatusEvent):void{
				
				switch(event.info.code){
					//うまくConnectionが確立できたらconnectStreamを呼ぶ
					case "NetConnection.Connect.Success":
						connectStream();
						break;
					default:
						//Connectionを張る時以外はステータスを出す
						trace(event.info.code);
						break;
				}
				
			};
			
			//ストリーミングを開始
			function connectStream():void{
				//ストリームを開く準備
				var netStream:NetStream = new NetStream(netConnection);
				netStream.addEventListener(NetStatusEvent.NET_STATUS, netStatusEventHandler);
				netStream.client = new CustomClient();
				
				//ビデオの表示先を準備
				var video:Video = new Video(512, 384);
				video.attachNetStream(netStream);
				
				//ストリームを開く。ココに開きたいファイルの名前を記述。src直下のファイルならファイル名だけ。
				netStream.play("movie.flv");
				
				//マテリアルを作成
				var material:VideoStreamMaterial = new VideoStreamMaterial(video, netStream);
				
				//マテリアルをリストに格納
				var materialList:MaterialsList = new MaterialsList({
					all:material	//すべての面に動画を表示
				});
				
				//Cubeを作成
				_myCubeForStreaming = new Cube(materialList, 512, 512, 384);
				
				//Cubeを表示領域に追加
				scene.addChild(_myCubeForStreaming);
				
				//レンダリング開始
				startRendering();
				
			};
			
		}
		
		
		/**
		 * レンダリングごとに呼ばれるリスナー
		 * @param event
		 * 
		 */
		override protected function onRenderTick(event:Event=null):void{
			
			if(this._mySphereForRotate != null){
				this._mySphereForRotate.rotationX += 0.5;
				this._mySphereForRotate.rotationY += 0.2;
				this._mySphereForRotate.rotationZ += 0.1;
			}
			
			if(this._myCubeForRotate != null){
				this._myCubeForRotate.rotationY += 0.5;
			}
			
			if(this._myCubeForStreaming != null){
				this._myCubeForStreaming.rotationY += 0.5;
			}
			
			super.onRenderTick(event);
		}
		
	}
}