﻿/**
* MikuMikuDance VMD形式の再生制御
*
* @author b2ox
*/
package org.b2ox.pv3d.MikuMikuDance
{
	import org.libspark.betweenas3.BetweenAS3;

	/**
	 * 再生制御
	 */
	public class VMDControllerMix implements IVMDController
	{
		private var _ctr1:IVMDController;
		private var _ctr2:IVMDController;
		private var _tween:ITween;

		/**
		 * 再生時のモデル変形用のPMDControllerを引数に取る
		 * @param	ctr
		 */
		public function VMDControllerMix(ctr1:IVMDController, ctr2:IVMDController):void
		{
			ctr1.mixing = true;
			ctr2.mixing = true;
			this.ctr1 = ctr1;
			this.ctr2 = ctr2;
			_tween = BetweenAS3.parallel(ctr1.tween.clone(), ctr2.tween.clone());
		}

		//-------------------------------------------------
		// 再生用のAPI

		public function get tween():ITween { return _tween; }

		public function get looping():Boolean { return ! _tween.stopOnComplete; }
		public function set looping(loop:Boolean):void { _tween.stopOnComplete = ! loop; }

		public function play():void { _tween.play(); }
		public function stop():void { _tween.stop(); }
		public function togglePause():void { _tween.togglePause(); }
		public function gotoAndPlay(pos:Number):void { _tween.gotoAndPlay(pos); }
		public function gotoAndStop(pos:Number):void { _tween.gotoAndStop(pos); }

		public function get playing():Boolean { return _tween.isPlaying; }

		private var _mixing:Boolean = false;
		public function get mixing():Boolean { return _mixing; }
		public function set mixing(v:Boolean):void { _mixing = v; }
		public function update():void
		{
			if (! _mixing) resetParams();
			applyCurrent();
			if (! _mixing) applyPose();
		}

		public function resetParams():void { ctr1.resetParams(); }
		public function applyPose():void { ctr1.update(); }

		/**
		 * 現在フレームのパラメータを適用する
		 */
		public function applyCurrent():void { ctr1.applyCurrent(); ctr2.applyCurrent(); }
	}
}
