﻿/*
 *  Copyright 2008 tarotarorg
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.tarotaro.flash.pv3d 
{
	import flash.events.Event;
	
	/**
	* @author 太郎
	*/
	public class AnimationMetasequoiaEvent extends Event 
	{
		public static const COMPLETE:String = "AnimationMetasequoiaEvent.COMPLETE";
		public static const PROGRESS:String = "AnimationMetasequoiaEvent.PROGRESS";
		
		private var _totalFrames:Number = 0;
		private var _loadedFrames:Number = 0;

		public function AnimationMetasequoiaEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false) 
		{ 
			super(type, bubbles, cancelable);
			
		} 
		
		public override function clone():Event 
		{ 
			return new AnimationMetasequoiaEvent(type, bubbles, cancelable);
		} 
		
		public override function toString():String 
		{ 
			return formatToString("AnimationMetasequoiaEvent", "type", "bubbles", "cancelable", "eventPhase"); 
		}
		
		public function get totalFrames():Number { return _totalFrames; }
		
		public function get loadedFrames():Number { return _loadedFrames; }
		
		/**
		 * AnimationMetasequoiaのロード完了イベントを作成
		 * @param	frames フレーム数
		 * @param	bubbles
		 * @param	cancelable
		 * @return	新しいAnimationMetasequoiaのロード完了イベント
		 */
		public static function createCompleteEvent(frames:Number,
													bubbles:Boolean = false, 
													cancelable:Boolean=false):AnimationMetasequoiaEvent
		{
				var e:AnimationMetasequoiaEvent = new AnimationMetasequoiaEvent(COMPLETE, bubbles, cancelable);
				e._totalFrames = e._loadedFrames = frames;
				return e;
		}
		
		/**
		 * AnimationMetasequoiaの進捗イベントを作成
		 * @param	totalFrames		総フレーム数
		 * @param	loadedFrames	ロード済みフレーム数
		 * @param	bubbles
		 * @param	cancelable
		 * @return	AnimationMetasequoiaの進捗イベント
		 */
		public static function createProgressEvent(totalFrames:Number,
													loadedFrames:Number = 0, 
													bubbles:Boolean = false, 
													cancelable:Boolean=false):AnimationMetasequoiaEvent 
		{
			var e:AnimationMetasequoiaEvent = new AnimationMetasequoiaEvent(PROGRESS, bubbles, cancelable);
				e._totalFrames = totalFrames;
				e._loadedFrames = loadedFrames;
				return e;
		}
		
	}
	
}