﻿package
{
	import flash.events.Event;
	import flash.filesystem.File;
	import flash.net.FileFilter;
	import mx.controls.TextArea;
	import mx.core.IMXMLObject;
	import mx.managers.PopUpManager;
	import org.libspark.thread.EnterFrameThreadExecutor;
	import org.libspark.thread.Thread;

	/**
	 * ...
	 * @author b2ox
	 */
	public class VMD2ASapp implements IMXMLObject
	{
		private var view:VMD2ASmain;
		private var _log:TextArea = null;
		private var inFile:File = new File();
		private var dlg:MyDialog;

		public function initialized(doc:Object, id:String):void
		{
			if (!Thread.isReady) Thread.initialize(new EnterFrameThreadExecutor());

			view = doc as VMD2ASmain;
			dlg = new MyDialog();
			dlg.addEventListener(Event.COMPLETE, onMyDialogSubmit );
		}

		public function registLog(log:TextArea):void 
		{
			_log = log;
		}

		public function doit():void
		{
			inFile.addEventListener(Event.SELECT, function(event:Event):void { onInFileSelect(); });
			try
			{
				inFile.browseForOpen("Open VMD file", [new FileFilter("VMD file", "*.vmd")]);
			}
			catch(e:Error)
			{
				trace(e.getStackTrace());
			}
		}

		private function log(str:String):void { _log.text += str + "\n"; }

		private function onInFileSelect():void {
			inFile.removeEventListener(Event.SELECT, arguments.callee);
			if (!inFile || inFile.isDirectory) return;

			dlg.class_name = "MyMotion";
			dlg.module_name = "myMotion";
			PopUpManager.addPopUp(dlg, view);
			PopUpManager.centerPopUp(dlg);
		}

		private function onMyDialogSubmit(e:Event):void
		{
			new VMD2AS(inFile, dlg.class_name, dlg.module_name, log).start();
		}

	}
}
