﻿/**
* @author b2ox
*/
package org.b2ox.pv3d.MikuMikuDance
{
	import org.b2ox.betweenas3.FuncTween;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;

	/**
	 * モーションの直列合成
	 */
	public class VMDControllerSerial implements IVMDController
	{
		private var _ctr1:IVMDController;
		private var _ctr2:IVMDController;
		private var _tween:ITween;
		private var _counterTween:ITween;
		private var _updaterTween:ITween;
		private var _duration1:Number;

		/**
		 * IVMDControllerを2つ取り、ctr1, ctr2の順に再生するコントローラを返す
		 * @param	ctr1
		 * @param	ctr2
		 */
		public function VMDControllerSerial(ctr1:IVMDController, ctr2:IVMDController):void
		{
			this._ctr1 = ctr1;
			this._ctr2 = ctr2;
			if ( ctr1.counterTween == null ) throw new Error("引数ctrl1が不正です。");
			if ( ctr2.counterTween == null ) throw new Error("引数ctrl2が不正です。");
			var tw1:ITween = ctr1.counterTween.clone();
			_counterTween = BetweenAS3.serial(tw1, ctr2.counterTween.clone());
			_duration1 = tw1.duration;

			_updaterTween = BetweenAS3.serial(ctr1.updaterTween.clone(), ctr2.updaterTween.clone());

			var _reseterTween:FuncTween = FuncTween.create(function (time:Number):void { resetParams(); }, _counterTween);
			var _applyerTween:FuncTween = FuncTween.create(function (time:Number):void { applyPose(); }, _counterTween);

			_tween = BetweenAS3.parallel(_reseterTween, _counterTween, _updaterTween, _applyerTween);
		}

		//-------------------------------------------------
		// 再生用のAPI

		public function get tween():ITween { return _tween; }
		public function get counterTween():ITween { return _counterTween; }
		public function get updaterTween():ITween { return _updaterTween; }

		public function get looping():Boolean { return ! _tween.stopOnComplete; }
		public function set looping(loop:Boolean):void { _tween.stopOnComplete = ! loop; }

		public function play():void { _tween.play(); }
		public function stop():void { _tween.stop(); }
		public function togglePause():void { _tween.togglePause(); }
		public function gotoAndPlay(pos:Number):void { _tween.gotoAndPlay(pos); }
		public function gotoAndStop(pos:Number):void { _tween.gotoAndStop(pos); }

		public function get playing():Boolean { return _tween.isPlaying; }

		public function update():void
		{
			resetParams();
			applyCurrent();
			applyPose();
		}

		public function resetParams():void { _ctr1.resetParams(); }
		public function applyPose():void {
			( (_tween.position < _duration1) ? _ctr1 : _ctr2 ).applyPose();
		}

		/**
		 * 現在フレームのパラメータを適用する
		 */
		public function applyCurrent():void {
			( (_tween.position < _duration1) ? _ctr1 : _ctr2 ).applyCurrent();
		}
	}
}
