﻿/**
 * MikuMikuDance
 *
 * @author b2ox
 */
package org.b2ox.pv3d.MikuMikuDance.utils
{
	import org.b2ox.pv3d.*;
	import org.b2ox.pv3d.MikuMikuDance.*;

	public class TalkMotion
	{
		private static const mouth:Array = ["あ", "い", "う", "お"];
		public static function create(pmdc:PMDController, talk:String, unit:int=15):VMDController
		{
			var vmd:VMDController = new VMDController(pmdc);
			
			trace("TalkMotion.create: "+talk);
			var frame:int = 0;
			var x:String;
			for each(var c:String in talk.split("")) {
				switch (c) 
				{
					case "あ":
					case "い":
					case "う":
					case "お": {
						for each(x in mouth) vmd.addSkinParam(x, frame, c == x ? 1.0 : 0.0);
					} break;
					case "え": { // "え" は "あ" の 0.5 で代用
						for each(x in mouth) vmd.addSkinParam(x, frame, "あ" == x ? 0.5 : 0.0);
					} break;
					default: {
						for each(x in mouth) vmd.addSkinParam(x, frame, 0.0);
					}
				}
				frame += unit;
			}
			vmd.fixFrameParams();
			return vmd;
		}

	}
}

