﻿/**
* @author b2ox
*/
package org.b2ox.flash3d.MikuMikuDance.debug
{
	import org.b2ox.flash3d.MikuMikuDance.*;
	import org.papervision3d.*;
	import org.papervision3d.core.math.*;
	import org.papervision3d.events.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.primitives.*;

	public class PMDBoneDbg
	{
		//-------------------------------------------------
		// PMDBoneのデバッグ用
		/**
		 * 基点位置に立方体を表示する.
		 * ボーンの種類ごとに違う色になる
		 */
		public static function addCube(bone:PMDBone):void
		{
			var col:int = (255 << 16) | (255 << 8) | 255
			var size:int = 0;
			if (bone.isIKbone) { col = (100 << 16) | (250 << 8) | 100; size = 20; }
			if (bone.isIKchain) { col = (100 << 16) | (100 << 8) | 250; size = 20; }
			if (bone.isIKeffector) { col = (250 << 16) | (100 << 8) | 100; size = 20; }
			if (size == 0) return;
			var cube:Cube = new Cube(new MaterialsList( { all: new ColorMaterial(col,1,true) } ), size, size, size);
			bone.attachModel(cube, "cube:" + bone.name);
			// クリックしたらボーン情報をtraceで出力
			function clicked(ev:InteractiveScene3DEvent):void { trace("Clicked: " + bone.boneInfo); }
			cube.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, clicked );
		}
	}
}