﻿package org.b2ox.math
{
	public class Solver
	{
		/**
		 * a x^2 + b x + c = 0の実根をansに格納し、相異なる実根の個数を返す。
		 * @param	a
		 * @param	b
		 * @param	c
		 * @param	ans 事前に2個分の容量を確保しておくこと
		 * @return
		 */
		public static function solveEquation2D(a:Number, b:Number, c:Number, ans:Vector.<Number>):int
		{
			if (a == 0) {
				if (b == 0) return 0;
				ans[0] = -c / b;
				return 1;
			}
			b /= 2*a;
			c /= a;
			var D:Number = b * b - c;
			if (D == 0) {
				ans[0] = -b;
				return 1;
			}
			if (D < 0) return 0;
			// D > 0
			D = Math.sqrt(D);
			ans[0] = -D - b;
			ans[1] = D - b;
			return 2;
		}

		/**
		 * a x^3 + b x^2 + c x + d = 0の実根をansに格納し、相異なる実根の個数を返す。
		 * @param	a
		 * @param	b
		 * @param	c
		 * @param	d
		 * @param	ans 事前に3個分の容量を確保しておくこと
		 * @return
		 */
		public static function solveEquation3D(a:Number, b:Number, c:Number, d:Number, ans:Vector.<Number>):int
		{
			if (a == 0) return solveEquation2D(b, c, d, ans);

			b /= 3*a;
			c /= a;
			d /= a;
			var b2:Number = b * b;
			var n:int = solveEquation3Dsub(c - 3 * b2, b * (2 * b2 - c) + d, ans);
			for (var i:int = 0; i < n; i++) ans[i] -= b;
			return n;
		}

		/**
		 * x^3 + p x + q = 0の実根をansに格納し、相異なる実根の個数を返す。
		 * @param	p
		 * @param	q
		 * @param	ans 事前に3個分の容量を確保しておくこと
		 * @return
		 */
		private static function solveEquation3Dsub(p:Number, q:Number, ans:Vector.<Number>):int
		{
			var q_2:Number = q / 2;
			var q27_2:Number = 27 * q_2;
			var D:Number = q27_2 * q27_2 + 3 * p;
			if (D == 0) {
				if (q == 0) {
					ans[0] = 0;
					return 1;
				} else {
					q_2 = Math.pow(q_2, 1 / 3);
					ans[0] = -2 * q_2;
					ans[1] = q_2;
					return 2;
				}
			}
			if (D > 0) {
				D = Math.sqrt(D);
				ans[0] = (Math.pow(D - q27_2, 1 / 3) + Math.pow( -D - q27_2, 1 / 3)) / 3;
				return 1;
			}
			// D < 0
			var r:Number = 2 * Math.pow( -3 * p, 1 / 6 ) / 3;
			var theta:Number = Math.atan2( -q27_2, Math.sqrt( -D ) ) / 3;
			var pi2_3:Number = Math.PI * 2 / 3;
			ans[0] = r * Math.cos(theta);
			ans[1] = r * Math.cos(theta + pi2_3);
			ans[2] = r * Math.cos(theta - pi2_3);
			return 3;
		}
	}
}

