#pragma once

#include "StdAfx.h"

#include <comdef.h>
#include <comip.h>

#include "SSAPI.h"
#include "unknown.h"
#include "exception.h"
#include "EventsImpl.h"

class EventHandlerImpl : public IVSSEventHandler, private UnknownImpl {
public:
	HRESULT __stdcall QueryInterface(REFIID riid, void **ppv) throw() try {
		if (!ppv) throw _com_error(E_POINTER);
		*ppv = nullptr;
		if (::IsEqualIID(riid, IID_IUnknown)) { 
			*ppv = static_cast<IUnknown *>(this);
		} else if (::IsEqualIID(riid, IID_IVSSEventHandler)) {
			*ppv = static_cast<IVSSEventHandler *>(this);
		} else {
			throw _com_error(E_NOINTERFACE);
		}
		this->AddRef();
		return S_OK;
	} catch (_com_error &hr) {
		return hr.Error();
	} catch (...) {
		return E_UNEXPECTED;
	}

	ULONG __stdcall AddRef(void) throw() { return UnknownImpl::AddRef(); }

	ULONG __stdcall Release(void) throw() { return UnknownImpl::Release(); }

	HRESULT __stdcall Init(IVSS *pIVSS) throw() try {
		_com_ptr_t<_com_IIID<IVSS, &IID_IVSS>> vss(pIVSS);

		HRESULT hr;

		_com_ptr_t<_com_IIID<IConnectionPointContainer, &IID_IConnectionPointContainer>> cpc;
		hr = vss->QueryInterface(&cpc);
		if (FAILED(hr)) throw _com_error(hr);

		_com_ptr_t<_com_IIID<IConnectionPoint, &IID_IConnectionPoint>> cp;
		hr = cpc->FindConnectionPoint(IID_IVSSEvents, &cp);
		if (FAILED(hr)) throw _com_error(hr);

		EventsImpl *e = new EventsImpl(vss);
		e->AddRef();
		_com_ptr_t<_com_IIID<IUnknown, &IID_IUnknown>> uk;
		hr = e->QueryInterface(IID_IUnknown, reinterpret_cast<void **>(&uk));
		e->Release();
		if (FAILED(hr)) throw _com_error(hr);

		DWORD cookie;
		hr = cp->Advise(uk, &cookie);
		if (FAILED(hr)) throw _com_error(hr);

		return S_OK;
	} catch (_com_error &hr) {
		return hr.Error();
	} catch (...) {
		return E_UNEXPECTED;
	}
};
