#pragma once

#if !defined(WIN32_LEAN_AND_MEAN)
#	define WIN32_LEAN_AND_MEAN
#endif
#if !defined(VC_EXTRALEAN)
#	define VC_EXTRALEAN
#endif
#if !defined(STRICT)
#	define STRICT
#endif

#include <windows.h>
#include <mlang.h>
#include <fstream>
#include <string>
#include <vector>
#include "exception.h"

struct File {
	typedef std::basic_string<TCHAR> tstring;

	const HANDLE Handle;

	File(const tstring &n) : Handle(::CreateFile(n.c_str(), GENERIC_READ,
			FILE_SHARE_READ, nullptr, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0)) {
		if (Handle == INVALID_HANDLE_VALUE) throw _win32_error(::GetLastError());
	}

	~File(void) { CloseHandle(Handle); }

	DWORD GetSize(void) { return ::GetFileSize(Handle, nullptr); }

	std::wstring Read(void) {
		std::vector<char> buf(GetSize());
		DWORD rd;
		if (!::ReadFile(Handle, &buf[0], buf.size(), &rd, nullptr)) throw _win32_error(::GetLastError());

		_com_ptr_t<_com_IIID<IMultiLanguage2, &IID_IMultiLanguage2 >> multil2;
		_com_check(multil2.CreateInstance(CLSID_CMultiLanguage));

		UINT codepage;
		{
			::DetectEncodingInfo deinfo[1];
			int deinfo_size = sizeof(deinfo) / sizeof(deinfo[0]) /* == 1 */;
			int buf_size = buf.size();

			HRESULT hr = multil2->DetectInputCodepage(MLDETECTCP_NONE, 0, &buf[0], &buf_size, deinfo, &deinfo_size);
			if (hr != S_OK) throw _com_error(hr);
			codepage = deinfo[0].nCodePage;
		}
		std::vector<wchar_t> wbuf(GetSize());
		{
			DWORD mode = 0;
			UINT buf_size = buf.size();
			UINT wbuf_size = wbuf.size();
			HRESULT hr = multil2->ConvertStringToUnicode(&mode, codepage, &buf[0], &buf_size, &wbuf[0], &wbuf_size);
			if (hr != S_OK) throw _com_error(hr);
		}
		return std::wstring(wbuf.begin(), wbuf.end());
	}
private:
	File(const File &);
};
