#pragma once

#include "StdAfx.h"

#include <comdef.h>
#include <comip.h>
#include <comutil.h>

#include <string>
#include <set>
#include <algorithm>
#include <iterator>

#include "msscript.h"
#include "exception.h"
#include "safearray.h"

struct JScript {
private:
	_com_ptr_t<_com_IIID<IScriptControl, &IID_IScriptControl>> scriptcontrol;
	std::set<const std::wstring> methods;

private:
	template<typename T> void runScript(const std::wstring &name, T first, T last) {
		SafeArray sa(first, last);
		_variant_t result;
		SAFEARRAY *s = sa.Data;
		_com_check(scriptcontrol->Run(_bstr_t(name.c_str()), &s, result.GetAddress()), scriptcontrol);
	}

public:
	JScript(void) {
		scriptcontrol.CreateInstance(CLSID_ScriptControl);
		_com_ptr_t<_com_IIID<ISupportErrorInfo, &IID_ISupportErrorInfo>> supportErrorInfo;
		scriptcontrol->QueryInterface(&supportErrorInfo);
	}

	void Reset(const std::wstring &code, IDispatch *gloabl) {
		methods.clear();
		_com_check(scriptcontrol->put_Language(_bstr_t(L"JScript")));
		_com_check(scriptcontrol->Reset());
		_com_check(scriptcontrol->put_AllowUI(VARIANT_TRUE));
		_com_check(scriptcontrol->put_UseSafeSubset(VARIANT_FALSE));
		_com_check(scriptcontrol->AddCode(_bstr_t(code.c_str())));
		if (gloabl) {
			_com_check(scriptcontrol->AddObject(_bstr_t(L"vssjscript"), gloabl, VARIANT_TRUE));
		}

		_com_ptr_t<_com_IIID<IScriptProcedureCollection, &IID_IScriptProcedureCollection>> p;
		_com_check(scriptcontrol->get_Procedures(&p));
		_com_ptr_t<_com_IIID<IUnknown, &IID_IUnknown>> u;
		_com_check(p->get__NewEnum(&u));
		_com_ptr_t<_com_IIID<IEnumVARIANT, &IID_IEnumVARIANT>> i;
		_com_check(u->QueryInterface(&i));
		_com_check(i->Reset());
		_variant_t o;
		while (S_OK == i->Next(1, o.GetAddress() , nullptr)) {
			_com_ptr_t<_com_IIID<IUnknown, &IID_IUnknown>> u(o);
			_com_ptr_t<_com_IIID<IScriptProcedure, &IID_IScriptProcedure>> p;
			_com_check(u->QueryInterface(&p));
			_bstr_t name;
			_com_check(p->get_Name(name.GetAddress()));
			methods.insert(name);
		}
	}

	void Eval(const std::wstring &expression) {
		_variant_t result;
		_com_check(scriptcontrol->Eval(_bstr_t(expression.c_str()), result.GetAddress()), scriptcontrol);
	}
public:
	void BeforeAdd(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &Local, const std::wstring &Comment) {
		const std::wstring NAME = L"BeforeAdd";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(Local.c_str())),
			_variant_t(_bstr_t(Comment.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void AfterAdd(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &Local, const std::wstring &Comment) {
		const std::wstring NAME = L"AfterAdd";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(Local.c_str())),
			_variant_t(_bstr_t(Comment.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void BeforeCheckout(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &Local, const std::wstring &Comment) {
		const std::wstring NAME = L"BeforeCheckout";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(Local.c_str())),
			_variant_t(_bstr_t(Comment.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void AfterCheckout(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &Local, const std::wstring &Comment) {
		const std::wstring NAME = L"AfterCheckout";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(Local.c_str())),
			_variant_t(_bstr_t(Comment.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void BeforeCheckin(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &Local, const std::wstring &Comment) {
		const std::wstring NAME = L"BeforeCheckin";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(Local.c_str())),
			_variant_t(_bstr_t(Comment.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void AfterCheckin(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &Local, const std::wstring &Comment) {
		const std::wstring NAME = L"AfterCheckin";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(Local.c_str())),
			_variant_t(_bstr_t(Comment.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void BeforeUndoCheckout(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &Local) {
		const std::wstring NAME = L"BeforeUndoCheckout";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(Local.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void AfterUndoCheckout(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &Local) {
		const std::wstring NAME = L"AfterUndoCheckout";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(Local.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void BeforeRename(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &NewName) {
		const std::wstring NAME = L"BeforeRename";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(NewName.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void AfterRename(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &OldName) {
		const std::wstring NAME = L"AfterRename";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(OldName.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void BeforeBranch(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &Comment) {
		const std::wstring NAME = L"BeforeBranch";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(Comment.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}

	void AfterBranch(const std::wstring &SrcSafeIni, const std::wstring &UserName, const std::wstring &Spec, const long VersionNumber, const std::wstring &Comment) {
		const std::wstring NAME = L"AfterBranch";
		if (methods.find(NAME) == methods.end()) return;
		_variant_t p[] = {
			_variant_t(_bstr_t(SrcSafeIni.c_str())),
			_variant_t(_bstr_t(UserName.c_str())),
			_variant_t(_bstr_t(Spec.c_str())),
			_variant_t(VersionNumber),
			_variant_t(_bstr_t(Comment.c_str())),
		};
		runScript(NAME, p, p + sizeof(p) / sizeof(p[0]));
	}
};
