#pragma once

#if !defined(WIN32_LEAN_AND_MEAN)
#	define WIN32_LEAN_AND_MEAN
#endif
#if !defined(VC_EXTRALEAN)
#	define VC_EXTRALEAN
#endif
#if !defined(STRICT)
#	define STRICT
#endif

#include <windows.h>

class UnknownImpl {
private:
	ULONG count;
	static ULONG serverCount;
protected:
	virtual ~UnknownImpl(void) { }
public:
	UnknownImpl(void) throw() : count(0) { }
	ULONG __stdcall AddRef(void) throw() {
		::InterlockedIncrement(&serverCount);
		return ::InterlockedIncrement(&count);
	}
	ULONG __stdcall Release(void) throw() {
		ULONG r = ::InterlockedDecrement(&count);
		if (r == 0) delete this;
		::InterlockedDecrement(&serverCount);
		return r;
	}
	static ULONG ServerCount() throw() { return serverCount; }
};
