#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include "vssjscript.h"

const int _IID_IVSSEventHandler = 0;


unsigned long sever_count = 0;

HRESULT __stdcall DllGetClassObject(REFCLSID rclsid, REFIID riid, void **ppv) try {
	if (!ppv) throw E_POINTER;
	if (!::IsEqualCLSID(rclsid, CLSID_JsEventHandlerClass)) throw CLASS_E_CLASSNOTAVAILABLE;

	JsEventHandlerClass *instance = new JsEventHandlerClass;
} catch (HRESULT hr) {
	return hr;
} catch (...) {
	return E_UNEXPECTED;
}

HRESULT __stdcall DllCanUnloadNow() {
    return (sever_count == 0) ? S_OK : S_FALSE;
}

// JsEventHandler

JsEventHandler::~JsEventHandler(void) { }

HRESULT __stdcall JsEventHandler::QueryInterface(REFIID riid, void **ppv) try {
	if (!ppv) throw E_POINTER;
	*ppv = 0;
	if (::IsEqualIID(riid, IID_IUnknown)) { 
		*ppv = static_cast<IUnknown *>(this);
	} else if (::IsEqualIID(riid, IID_IVSSEventHandler)) {
		*ppv = static_cast<IVSSEventHandler *>(this);
	} else {
		throw E_NOINTERFACE;
	}
	this->AddRef();
	return S_OK;
} catch (HRESULT hr) {
	return hr;
} catch (...) {
	return E_UNEXPECTED;
}

ULONG __stdcall JsEventHandler::AddRef(void) {
	::InterlockedIncrement(&sever_count);
	return ::InterlockedIncrement(&count);
}

ULONG __stdcall JsEventHandler::Release(void) {
	ULONG r = ::InterlockedDecrement(&count);
	if (r == 0) delete this;
	::InterlockedDecrement(&sever_count);
	return r;
} 

HRESULT __stdcall JsEventHandler::Init(IVSS *pIVSS) try {
	VSS.Attach(pIVSS, false);
	return S_OK;
} catch (HRESULT hr) {
	return hr;
} catch (...) {
	return E_UNEXPECTED;
}

// JsEventHandlerClass

JsEventHandlerClass::~JsEventHandlerClass(void) { }

HRESULT __stdcall JsEventHandlerClass::QueryInterface(REFIID riid, void **ppv) try {
	if (!ppv) throw E_POINTER;
	*ppv = 0;
	if (::IsEqualIID(riid, IID_IUnknown)) { 
		*ppv = static_cast<IUnknown *>(this);
	} else if (::IsEqualIID(riid, IID_IClassFactory)) {
		*ppv = static_cast<IClassFactory *>(this);
	} else {
		throw E_NOINTERFACE;
	}
	this->AddRef();
	return S_OK;
} catch (HRESULT hr) {
	return hr;
} catch (...) {
	return E_UNEXPECTED;
}
	
ULONG __stdcall JsEventHandlerClass::AddRef(void) {
	::InterlockedIncrement(&sever_count);
	return ::InterlockedIncrement(&count);
}

ULONG __stdcall JsEventHandlerClass::Release(void) {
	ULONG r = ::InterlockedDecrement(&count);
	if (r == 0) delete this;
	::InterlockedDecrement(&sever_count);
	return r;
} 

HRESULT __stdcall JsEventHandlerClass::CreateInstance(IUnknown *pUnkOuter, REFIID riid, void **ppv) try {
	if (!ppv) throw E_POINTER;
	*ppv = 0;
	if (pUnkOuter) throw CLASS_E_NOAGGREGATION;
	JsEventHandler *instance = new JsEventHandler();
	instance->AddRef();
	HRESULT hr = instance->QueryInterface(riid, ppv);
	instance->Release();
	return hr;
} catch (HRESULT hr) {
	return hr;
} catch (...) {
	return E_UNEXPECTED;
}
	
HRESULT __stdcall JsEventHandlerClass::LockServer(BOOL fLock) try {

	return S_OK;
} catch (HRESULT hr) {
	return hr;
} catch (...) {
	return E_UNEXPECTED;
}
