/*!
******************************************************************************

	@file	stdio.h

	Copyright (C) 2008 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __STDIO_H__
#define __STDIO_H__

#include <stddef.h>

typedef struct _FILE {
	int		fd;
} FILE;

#define stdin	((FILE *)0x00000001)
#define stdout	((FILE *)0x00000002)
#define stderr	((FILE *)0x00000003)

#ifdef __cplusplus
extern "C" {
#endif

int sprintf( char *str, const char *fmt, ... );
int fprintf( FILE *fp, const char *fmt, ... );
int printf ( const char *fmt, ... );
int putchar( int c );
int puts   ( const char *s );

#ifdef __cplusplus
}
#endif

#endif // !__STDIO_H__
