#include	"compiler.h"
#include	"cpucore.h"
#include	"pccore.h"
#include	"iocore.h"


// ---- I/O

static void IOOUTCALL necio_o0439(UINT port, REG8 dat) {

	necio.port0439 = dat;
	(void)port;
}

#ifdef _VSUN86
int bios_saved = 0;
UINT8 bios_bak[0x8000];
#endif // _VSUN86

static void IOOUTCALL necio_o043d(UINT port, REG8 dat) {

	switch(dat) {
		case 0x10:
			CPU_ITFBANK = 1;
#ifdef _VSUN86
			// Ƃ肠̓RsĂ܂ɂ
			if ( bios_saved == 0 )
			{	// BIOS̓eۑ
				CopyMemory( bios_bak, &mem[0xF8000], 0x8000 );
				bios_saved = 1;
			}
			CopyMemory( &mem[0xF8000], &mem[ITF_ADRS], 0x8000 );
#endif // _VSUN86
			break;

		case 0x12:
			CPU_ITFBANK = 0;
#ifdef _VSUN86
			// Ƃ肠̓RsĂ܂ɂ
			if ( bios_saved == 1 )
			{	// BIOS̓e𕜋A
				CopyMemory( &mem[0xF8000], bios_bak, 0x8000 );
			}
#endif // _VSUN86
			break;
	}
	(void)port;
}


// ---- I/F

void necio_reset(const NP2CFG *pConfig) {

	necio.port0439 = 0xff;

	(void)pConfig;
}

void necio_bind(void) {

	iocore_attachout(0x0439, necio_o0439);

	if (!(pccore.model & PCMODEL_EPSON)) {
		iocore_attachout(0x043d, necio_o043d);
	}
}

