#ifndef __NP2_VSUN86_COMPILER_H__
#define __NP2_VSUN86_COMPILER_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../../vmm/vsun86.h"
#include "../../vmm/syscall.h"
#include "../../vmm/pfemu/vcpu.h"

#define _VSUN86

#define	BYTESEX_LITTLE

#define CPUCALL
#define MEMCALL

typedef int				SINT;
typedef unsigned int	UINT;

typedef char			SINT8;
typedef short			SINT16;
typedef long			SINT32;

typedef unsigned char	UINT8;
typedef unsigned short	UINT16;
typedef unsigned long	UINT32;

typedef int				BOOL;
#define TRUE			1
#define FALSE			0

#ifndef MAX_PATH
#define MAX_PATH		260
#endif // !MAX_PATH

#define OEMCHAR				char
#define OEMTEXT(s)			(s)
#define OEMSPRINTF			sprintf
#define OEMSTRLEN			strlen

#define	__ASSERT(s)

#define ZeroMemory(d,n)		memset( (d), 0, (n) )
#define CopyMemory(d,s,n)	memcpy( (d), (s), (n) )
#define	FillMemory(a,b,c)	memset( (a), (c), (b) )
#define	max(a,b)			(((a) > (b)) ? (a) : (b))
#define	min(a,b)			(((a) < (b)) ? (a) : (b))
#define SPRINTF				sprintf
#define STRLEN				strlen
#define GETTICK				Vsun86_GetTickCount

#define DISABLE_SOUND
#define SUPPORT_ANK
#define SUPPORT_32BPP
#define SUPPORT_PC9821

#include "common.h"
#include "milstr.h"
#include "_memory.h"
#include "rect.h"
#include "lstarray.h"
#include "trace.h"

#endif // !__NP2_VSUN86_COMPILER_H__
