#include "compiler.h"
#include "timemng.h"

BRESULT timemng_gettime( _SYSTIME *systime )
{
	fprintf( stderr, "timemng_gettime()\n" );

	VSUN86_SYSTEM_TIME t;

	if ( systime == NULL )
		return FAILURE;

	if ( Vsun86_GetLocalTime( &t ) != 0 ) {
		fprintf( stderr, "Vsun86_GetLocalTime() failed.\n" );
		return FAILURE;
	}

	systime->year	= t.year;
	systime->month	= t.mon;
	systime->week	= t.wday;
	systime->day	= t.mday;
	systime->hour	= t.hour;
	systime->minute	= t.min;
	systime->second	= t.sec;
	systime->milli	= t.msec;

	return SUCCESS;
}
