/*!
******************************************************************************

	@file	common.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __COMMON_H__
#define __COMMON_H__

#include <stddef.h>
#ifdef	_VSUN86_PCSIM
#ifdef	_MSC_VER
#include "SDL.h"
#else	//!_MSC_VER
#include <SDL/SDL.h>
#endif	//!_MSC_VER
#endif	//_VSUN86_PCSIM

#ifndef u8_u16_u32_u64
#define u8_u16_u32_u64
typedef unsigned char		u8;
typedef unsigned short		u16;
typedef unsigned long		u32;
typedef unsigned long long	u64;
#endif // !u8_u16_u32_u64

#ifdef  __cplusplus
#define EXTERN_C	extern "C"
#else	// __cplusplus
#define EXTERN_C
typedef unsigned char	bool;
#endif	// __cplusplus

#ifndef ALIGN
#define ALIGN(n)	__attribute__((aligned(n)))
#endif // !ALIGN(n)

#define __ASM__		__asm__ __volatile__

#define endian_conv16(w)									\
({															\
	u16 _value;												\
	__ASM__("xchg	%%ah, %%al" : "=a"(_value) : "a"(w) );	\
	_value;													\
})

#define endian_conv32(d)									\
({															\
	u32 _value;												\
	__ASM__("bswap	%%eax" : "=a"(_value) : "a"(d) );		\
	_value;													\
})

#define LE16(w)		(w)
#define BE16(w)		endian_conv16(w)

#define LE32(d)		(d)
#define BE32(d)		endian_conv32(d)

//#define CALLBACK	__cdecl
#define CALLBACK

#endif // !__COMMON_H__
