/*!
******************************************************************************

	@file	scsi.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "scsi.h"
#include "disk.h"
#include "printf.h"

bool scsi_cmd_inquiry( SCSI_DEVICE *dev, SCSI_STD_INQUIRY_DATA *buf )
{
	SCSI_CDB_INQUIRY cdb;

	memset( &cdb, 0, sizeof(SCSI_CDB_INQUIRY) );
	cdb.cmd		  = SCSI_CMD_INQUIRY;
	cdb.alloc_len = endian_conv16( sizeof(SCSI_STD_INQUIRY_DATA) );
	if ( !dev->send_cmd( dev->bus_dev, &cdb, sizeof(cdb), buf, sizeof(SCSI_STD_INQUIRY_DATA), true ) )
		return false;

	vmm_printf( VMM_DEBUG, "\n" );
	vmm_printf( VMM_DEBUG, "[INQUIRY]\n" );
	vmm_printf( VMM_DEBUG, "Device Type ....... %02x\n", buf->dev_type );
	vmm_printf( VMM_DEBUG, "Qualifier ......... %02x\n", buf->qualifier );
	vmm_printf( VMM_DEBUG, "Removable ......... %02x\n", buf->removable );
	vmm_printf( VMM_DEBUG, "Version ........... %02x\n", buf->version );
	vmm_printf( VMM_DEBUG, "Flags ............. %02x %02x %02x\n",
				buf->flags[0], buf->flags[1], buf->flags[2] );
	vmm_printf( VMM_DEBUG, "Vendor ID ......... \"" );
	for ( int i=0; i<8; i++ )
		vmm_printf( VMM_DEBUG, "%c", buf->vendor_id[i] );
	vmm_printf( VMM_DEBUG, "\"\n" );
	vmm_printf( VMM_DEBUG, "Product ID ........ \"" );
	for ( int i=0; i<16; i++ )
		vmm_printf( VMM_DEBUG, "%c", buf->product_id[i] );
	vmm_printf( VMM_DEBUG, "\"\n" );
	vmm_printf( VMM_DEBUG, "Revision .......... \"" );
	for ( int i=0; i<4; i++ )
		vmm_printf( VMM_DEBUG, "%c", buf->revision[i] );
	vmm_printf( VMM_DEBUG, "\"\n" );
	vmm_printf( VMM_DEBUG, "\n" );

	return true;
}

bool scsi_cmd_read_capacity( SCSI_DEVICE *dev, SCSI_DISK_CAPACITY *buf )
{
	SCSI_CDB10 cdb;

	memset( &cdb, 0, sizeof(SCSI_CDB10) );
	cdb.cmd = SCSI_CMD_READ_CAPACITY;
	if ( !dev->send_cmd( dev->bus_dev, &cdb, sizeof(cdb), buf, sizeof(SCSI_DISK_CAPACITY), true ) )
		return false;

	buf->last_block = endian_conv32( buf->last_block );
	buf->block_len  = endian_conv32( buf->block_len  );

	vmm_printf( VMM_DEBUG, "[READ CAPACITY(10)]\n" );
	vmm_printf( VMM_DEBUG, "Last Logical Block Address ... %08x\n", buf->last_block );
	vmm_printf( VMM_DEBUG, "Block Length ................. %08x\n", buf->block_len );
	vmm_printf( VMM_DEBUG, "\n" );

	return true;
}

bool scsi_cmd_read( SCSI_DEVICE *dev, u32 block_addr, u16 block_len, void *buf, u32 buf_len )
{
	SCSI_CDB_READ cdb;

	cdb.cmd			= SCSI_CMD_READ;
	cdb.flags		= 0;
	cdb.block_addr	= endian_conv32( block_addr );
	cdb.group_num	= 0;
	cdb.xfer_len	= endian_conv16( block_len );
	cdb.ctrl		= 0;
	if ( !dev->send_cmd( dev->bus_dev, &cdb, sizeof(cdb), buf, buf_len, true ) )
		return false;

	return true;
}
