/*!
******************************************************************************

	@file	keyboard.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __KEYBOARD_H__
#define __KEYBOARD_H__

#include "task.h"

typedef struct {
	u8	num;
	u8	mod;
	u8	key[8];
} KEY_CODES;

typedef struct {
	bool (*read)( void *, KEY_CODES * );
} KEYBOARD_OPS;

typedef struct {
	void *			dev;
	KEYBOARD_OPS	ops;
	u8				key[256];
} KEYBOARD;

typedef enum {
	MSG_KEY_BASE = TASK_MSG_BASE( TASK_ID_KEYBOARD ),
	MSG_KEY_DOWN,	// arg1=修飾キーの状態, arg2=キーコード
	MSG_KEY_UP,		// arg1=修飾キーの状態, arg2=キーコード
	MSG_KEY_IRQ,	// arg1=(予約), arg2=(予約)
#ifdef	_VSUN86_PCSIM
	MSG_VKEY_DOWN,	// arg1=仮想キーコード, arg2=修飾キーの状態
	MSG_VKEY_UP,	// arg1=仮想キーコード, arg2=修飾キーの状態
#endif	//_VSUN86_PCSIM
} KEYBOARD_EVENT;

#define KEY_MOD_LCTRL	0x01
#define KEY_MOD_LSHIFT	0x02
#define KEY_MOD_LALT	0x04
#define KEY_MOD_LWIN	0x08
#define KEY_MOD_RCTRL	0x10
#define KEY_MOD_RSHIFT	0x20
#define KEY_MOD_RALT	0x40
#define KEY_MOD_RWIN	0x80

#define KEY_NULL		0x00
#define KEY_KANJI		0x01
#define KEY_BACKSPACE	0x0F
#define KEY_TAB			0x10
#define KEY_CAPS		0x1E
#define KEY_RETURN		0x2B
#define KEY_INSERT		0x4B
#define KEY_DELETE		0x4C
#define KEY_LEFT		0x4F
#define KEY_HOME		0x50
#define KEY_END			0x51
#define KEY_UP			0x53
#define KEY_DOWN		0x54
#define KEY_PAGEUP		0x55
#define KEY_PAGEDOWN	0x56
#define KEY_RIGHT		0x59
#define KEY_NUMLOCK		0x5A
#define KEY_ESCAPE		0x6E
#define KEY_F1			0x70
#define KEY_F2			0x71
#define KEY_F3			0x72
#define KEY_F4			0x73
#define KEY_F5			0x74
#define KEY_F6			0x75
#define KEY_F7			0x76
#define KEY_F8			0x77
#define KEY_F9			0x78
#define KEY_F10			0x79
#define KEY_F11			0x7A
#define KEY_F12			0x7B
#define KEY_PRINTSCREEN	0x7C
#define KEY_SCROLLLOCK	0x7D
#define KEY_PAUSE		0x7E

#define IO_KBC_DATA		0x0060
#define IO_KBC_CMD		0x0064
#define IO_KBC_STATUS	0x0064

#define KBC_STATUS_OBF	0x01

extern bool keyboard_register( void *dev, KEYBOARD_OPS *ops );
extern void keyboard_task( void *args );

#endif //!__KEYBOARD_H__
