/*!
******************************************************************************

	@file	shell.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __SHELL_H__
#define __SHELL_H__

#include "disp.h"
#include "task.h"

typedef enum {
	MSG_SHELL_BASE = TASK_MSG_BASE( TASK_ID_SHELL ),
	MSG_SHELL_EXEC_CMD,
	MSG_SHELL_EXEC_FINISHED,
	MSG_SHELL_VM_NOP,
	MSG_SHELL_VM_EXIT,
} SHELL_EVENT;

#define CONSOLE_COLUMN_MAX		80
#define CONSOLE_LINE_MAX		100
#define CONSOLE_BUF_ENTRY_MAX	(CONSOLE_COLUMN_MAX * CONSOLE_LINE_MAX)

#define CONSOLE_FGCOLOR		COLOR_WHITE
#define CONSOLE_BGCOLOR		COLOR_BLACK

extern bool shell_init( void );
extern void shell_task( void *args );
extern void shell_set_vm_eventcb( void *proc );
extern void shell_put_char( int c, RGB32 color=CONSOLE_FGCOLOR );
extern void shell_put_string( const char *str, RGB32 color=CONSOLE_FGCOLOR );

#endif //!__SHELL_H__
