/*!
******************************************************************************

	@file	task.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __TASK_H__
#define __TASK_H__

#include "cpu.h"

#pragma pack(1)

typedef void (*TASK_PROC)( void * /*args*/ );

typedef enum {
	TASK_ID_TIMER,
	TASK_ID_KEYBOARD,
	TASK_ID_UART,
	TASK_ID_USB_OHCI,
	TASK_ID_USB_UHCI,
	TASK_ID_USB_EHCI,
	TASK_ID_SHELL,
	TASK_ID_VM,
	TASK_ID_SLEEP,
#ifdef	_VSUN86_PCSIM
	TASK_ID_PCSIM,
#endif	//_VSUN86_PCSIM
	TASK_ID_MAX = CPU_CONTEXT_MAX,
	TASK_ID_INVALID
} TASK_ID;

#define TASK_MSG_BASE( id )		((id) << 24)

typedef enum {
	TASK_STATE_HALT = -1,
	TASK_STATE_IDLE,
	TASK_STATE_BUSY,
	TASK_STATE_WAIT,
	TASK_STATE_MAX
} TASK_STATE;

typedef struct {
	TASK_ID		from;
	int			msg;
	u32			arg1;
	u32			arg2;
} TASK_EVENT;

typedef struct _TASK {
	CPU_CONTEXT *	context;
	TASK_ID			id;
	const char *	name;
	TASK_PROC		proc;
	void *			args;
	TASK_STATE		state;
	TASK_EVENT *	events;
	u32				event_cnt;
	u32				event_rp;
	u32				event_wp;
	u32				result;
	u64				start_tick;
	u64				elapsed_time;
	struct _TASK *	prev;
	struct _TASK *	next;
} TASK;

#pragma pack()

extern bool task_init( void );
extern bool task_start( void );
extern bool task_create( TASK_ID id, const char *name, TASK_PROC proc, void *args, u32 stack_size );
extern void task_switch( bool force, TASK_STATE cur_task_next_state );
//extern bool task_switch_fpu_regs( void );
extern bool task_wait_event( TASK_EVENT *event );
extern bool task_send_event( TASK_ID id, u32 msg, u32 arg1, u32 arg2 );
extern void task_lock( void );
extern void task_unlock( void );
extern void task_dump( void );
extern void task_sleep( u32 msec );

#endif //!__TASK_H__
