/*!
******************************************************************************

	@file	uhci_q.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/
/*-*- mode: C++; Encoding: utf8n -*-*/

#include "vsun86.h"
#include "pci.h"
#include "usb.h"
#include "uhci.h"
#include "printf.h"

#define UHCI_FLBASE			NON_CACHED_PTR( _uhci_flbase, u32 )
#define UHCI_FLBASE_SIZE	0x00010000				// 64KB  (16*4KB)
ALIGN(4096) static u8 _uhci_flbase[UHCI_FLBASE_SIZE];

//static UHCI_TD * uhci_alloc_td( UHCI_HCD *hcd );

bool uhci_queue_init( UHCI_HCD *hcd )
{
	const u8 index = hcd->id;

	hcd->frame_list = &UHCI_FLBASE[1024 * index];
	hcd->qh = (UHCI_QH *)&USB_HCQHBUF[USB_HCQH_MAX * USB_HCQH_ALIGN * index];

	// QHを初期化する
	// INT→CTRL→BULK(Read)→BULK(Write)の順で繋ぐ
	hcd->qh[UHCI_QH_INT   ].qh_link = QH_LINK_PTR( virt_to_phys(&hcd->qh[UHCI_QH_CTRL  ]), 0 );
	hcd->qh[UHCI_QH_INT   ].qe_link = TD_LINK_PTR( 0, 0, 1 );
	hcd->qh[UHCI_QH_CTRL  ].qh_link = QH_LINK_PTR( virt_to_phys(&hcd->qh[UHCI_QH_BULK_R]), 0 );
	hcd->qh[UHCI_QH_CTRL  ].qe_link = TD_LINK_PTR( 0, 0, 1 );
	hcd->qh[UHCI_QH_BULK_R].qh_link = QH_LINK_PTR( virt_to_phys(&hcd->qh[UHCI_QH_BULK_W]), 0 );
	hcd->qh[UHCI_QH_BULK_R].qe_link = TD_LINK_PTR( 0, 0, 1 );
	hcd->qh[UHCI_QH_BULK_W].qh_link = QH_LINK_PTR( 0, 1 );
	hcd->qh[UHCI_QH_BULK_W].qe_link = TD_LINK_PTR( 0, 0, 1 );

	for ( int i=0; i<1024; i++ )
		hcd->frame_list[i] = QH_LINK_PTR( virt_to_phys(hcd->qh), 0 );

	return true;
}

/*
static UHCI_TD * uhci_alloc_td( UHCI_HCD *hcd )
{
	(void)hcd;
	return NULL;
}
*/
