/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.translate;

import java.util.Arrays;
import java.util.List;

public final class Language {
    public static final String ARABIC = "ar";
    public static final String CHINESE = "zh";
    public static final String CHINESE_SIMPLIFIED = "zh-CN";
    public static final String CHINESE_TRADITIONAL = "zh-TW";
    public static final String DUTCH = "nl";
    public static final String ENGLISH = "en";
    public static final String FRENCH = "fr";
    public static final String GERMAN = "de";
    public static final String GREEK = "el";
    public static final String ITALIAN = "it";
    public static final String JAPANESE = "ja";
    public static final String KOREAN = "ko";
    public static final String PORTUGESE = "pt";
    public static final String RUSSIAN = "ru";
    public static final String SPANISH = "es";
    public static final List<String> validLanguages = Arrays.asList("ar", "zh", "zh-CN", "zh-TW", "en", "fr", "de", "it", "ja", "ko", "pt", "ru", "es");
    public static final List<String> validLanguagePairs = Arrays.asList("ar|en", "zh|en", "zh-CN|zh-TW", "zh-TW|zh-CN", "nl|en", "en|ar", "en|zh", "en|zh-CN", "en|zh-TW", "en|nl", "en|fr", "en|de", "en|el", "en|it", "en|ja", "en|ko", "en|pt", "en|ru", "en|es", "fr|en", "fr|de", "de|en", "de|fr", "el|en", "it|en", "ja|en", "ko|en", "pt|en", "ru|en", "es|en");

    public static boolean isValidLanguage(String language) {
        return validLanguages.contains(language);
    }

    public static boolean isValidLanguagePair(String from, String to) {
        return validLanguagePairs.contains(String.valueOf(from) + '|' + to);
    }
}

