/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.wagashi.sakuramochi;

import com.google.api.translate.Translate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import jp.sf.wagashi.sakuramochi.TranslateMessages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class TranslatePopupDialog
extends PopupDialog {
    private Browser fBrowser;
    private String fSrcText;
    private String fLangFrom;
    private String fLangTo;
    private static String fStyleSheet = null;
    private static RGB BG_COLOR_RGB = null;

    static {
        Display display = Display.getDefault();
        BG_COLOR_RGB = display.getSystemColor(29).getRGB();
    }

    public TranslatePopupDialog(Shell parent, int shellStyle, boolean takeFocusOnOpen, boolean persistBounds, boolean showDialogMenu, boolean showPersistAction, String titleText, String infoText) {
        super(parent, shellStyle, takeFocusOnOpen, persistBounds, showDialogMenu, showPersistAction, titleText, infoText);
    }

    protected Control createDialogArea(Composite parent) {
        this.fBrowser = new Browser(parent, 0);
        GridData gd = new GridData(1809);
        gd.horizontalIndent = 1;
        gd.verticalIndent = 1;
        this.fBrowser.setLayoutData((Object)gd);
        this.fBrowser.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    TranslatePopupDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.fBrowser;
    }

    public void setText(String text) {
        this.fBrowser.setText(TranslatePopupDialog.toHTML(text));
    }

    public void setHTML(String html) {
        this.fBrowser.setText(String.valueOf(TranslatePopupDialog.getStyleSheet()) + html);
    }

    public void setInfoText(String text) {
        super.setInfoText(text);
    }

    protected Point getInitialSize() {
        if (!this.getPersistBounds()) {
            return new Point(300, 180);
        }
        return super.getInitialSize();
    }

    protected Point getInitialLocation(Point initialSize) {
        if (!this.getPersistBounds()) {
            Point size = this.getInitialSize();
            Rectangle parentBounds = this.getParentShell().getBounds();
            int x = parentBounds.x + parentBounds.width / 2 - size.x / 2;
            int y = parentBounds.y + parentBounds.height / 2 - size.y / 2;
            return new Point(x, y);
        }
        return super.getInitialLocation(initialSize);
    }

    public void translate(String src, String from, String to) {
        this.fSrcText = src;
        this.fLangFrom = from;
        this.fLangTo = to;
        new TranslatorThread().start();
    }

    private static String getStyleSheet() {
        if (fStyleSheet != null) {
            return fStyleSheet;
        }
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocHoverStyleSheet.css");
        if (styleSheetURL != null) {
            try {
                styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
                BufferedReader reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                fStyleSheet = buffer.toString();
            }
            catch (IOException iOException) {
                fStyleSheet = null;
            }
        }
        return fStyleSheet;
    }

    private static String toHTML(String text) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><head><style CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        buffer.append(TranslatePopupDialog.getStyleSheet());
        buffer.append("</style></head><body text=\"#000000\" bgcolor=\"");
        TranslatePopupDialog.appendColor(buffer, BG_COLOR_RGB);
        buffer.append("\">");
        buffer.append(text == null ? "" : text);
        buffer.append("</body></html>");
        return buffer.toString();
    }

    private static void appendColor(StringBuffer buffer, RGB rgb) {
        buffer.append('#');
        buffer.append(Integer.toHexString(rgb.red));
        buffer.append(Integer.toHexString(rgb.green));
        buffer.append(Integer.toHexString(rgb.blue));
    }

    class TranslatorThread
    extends Thread {
        TranslatorThread() {
        }

        @Override
        public void run() {
            try {
                try {
                    String str = Translate.translate((String)TranslatePopupDialog.this.fSrcText, (String)TranslatePopupDialog.this.fLangFrom, (String)TranslatePopupDialog.this.fLangTo);
                    final String out = TranslatePopupDialog.toHTML(str);
                    TranslatePopupDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TranslatePopupDialog.this.fBrowser.setText(out);
                            TranslatePopupDialog.this.setInfoText(TranslateMessages.TranslatePopupDialog_translateComplete);
                        }
                    });
                }
                catch (Exception e) {
                    final String out = TranslatePopupDialog.toHTML(e.toString());
                    TranslatePopupDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TranslatePopupDialog.this.fBrowser.setText(out);
                            TranslatePopupDialog.this.setInfoText(TranslateMessages.TranslatePopupDialog_translateError);
                        }
                    });
                }
            }
            catch (Exception e) {
                final String out = TranslatePopupDialog.toHTML(e.toString());
                TranslatePopupDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TranslatePopupDialog.this.fBrowser.setText(out);
                        TranslatePopupDialog.this.setInfoText(TranslateMessages.TranslatePopupDialog_translateError);
                    }
                });
            }
        }
    }
}

